/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.BalanceUpdateArgs;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.balance.BalanceUpdateHandle;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.DateUtils;

public class InvcountSchemeHelper {
    private static final Log log = LogFactory.getLog(InvcountSchemeHelper.class);
    private static final int MAX_ID_SIZE = 500000;

    public static String invCountCustomExist(String entityName, QFilter[] basicFilter) {
        QFilter qFilter = new QFilter("completestatus", "=", (Object)"A");
        qFilter.and("freezeoutin", "=", (Object)true);
        qFilter.and("billstatus", "=", (Object)"C");
        String billNo = "";
        boolean exists = false;
        Map invCountsCollection = BusinessDataServiceHelper.loadFromCache((String)"im_invcountscheme", (String)"org,mulorg,warehouse,location,material,filterstring_tag,billno", (QFilter[])qFilter.toArray());
        if (invCountsCollection.isEmpty()) {
            return "";
        }
        for (DynamicObject invCounts : invCountsCollection.values()) {
            String serializationFilter;
            QFilter materialFilter;
            QFilter locationFilter;
            QFilter warehouseFilter;
            QFilter singleFilter = new QFilter("1", "=", (Object)1);
            HashSet<Long> orgIdSet = new HashSet<Long>();
            HashSet<Long> warehouseIdSet = new HashSet<Long>();
            HashSet<Long> locationIdSet = new HashSet<Long>();
            HashSet<Long> materialIdSet = new HashSet<Long>();
            DynamicObject org = invCounts.getDynamicObject("org");
            DynamicObjectCollection mulOrgs = invCounts.getDynamicObjectCollection("mulorg");
            if (!mulOrgs.isEmpty()) {
                for (DynamicObject mulOrg : mulOrgs) {
                    orgIdSet.add(mulOrg.getLong("fbasedataid_id"));
                }
            } else {
                orgIdSet.add((Long)org.get("id"));
            }
            InvcountSchemeHelper.buildIdSet(warehouseIdSet, invCounts, "warehouse");
            InvcountSchemeHelper.buildIdSet(locationIdSet, invCounts, "location");
            InvcountSchemeHelper.buildIdSet(materialIdSet, invCounts, "material");
            if (!orgIdSet.isEmpty()) {
                QFilter orgFilter = new QFilter("org.id", "in", orgIdSet);
                singleFilter.and(orgFilter);
            }
            if (null != (warehouseFilter = InvcountSchemeHelper.getSingleFilter(warehouseIdSet, "warehouse"))) {
                singleFilter.and(warehouseFilter);
            }
            if (null != (locationFilter = InvcountSchemeHelper.getSingleFilter(locationIdSet, "location"))) {
                singleFilter.and(locationFilter);
            }
            if (null != (materialFilter = InvcountSchemeHelper.getSingleFilter(materialIdSet, "material"))) {
                singleFilter.and(materialFilter);
            }
            if (!"".equals(serializationFilter = invCounts.getString("filterstring_tag"))) {
                QFilter customFilter = InvcountSchemeHelper.getCustomFilterString(serializationFilter);
                InvcountSchemeHelper.cycleCallQFilter(customFilter, singleFilter);
            }
            if (!(exists = InvcountSchemeHelper.checkIfExists(singleFilter, entityName, basicFilter))) continue;
            billNo = invCounts.getString("billno");
            return billNo;
        }
        return billNo;
    }

    private static boolean checkIfExists(QFilter singleFilter, String entityName, QFilter[] basicFilter) {
        boolean exists = false;
        HashSet<QFilter> completeFilter = new HashSet<QFilter>(4);
        completeFilter.add(singleFilter);
        try {
            QFilter[] cloneBasicFilter = InvcountSchemeHelper.deepClone(basicFilter);
            QFilter[] copyTotalQFlter = InvcountSchemeHelper.concatAll(cloneBasicFilter, new QFilter[][]{completeFilter.toArray(new QFilter[completeFilter.size()])});
            exists = QueryServiceHelper.exists((String)entityName, (QFilter[])copyTotalQFlter);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException("deep clone filter exception:" + e.getMessage());
        }
        if (exists) {
            return true;
        }
        return exists;
    }

    private static void cycleCallQFilter(QFilter customFilter, QFilter listQFilter) {
        List listQFilterNest = customFilter.getNests(true);
        if (listQFilterNest.isEmpty()) {
            Object value = customFilter.getValue();
            if ("EMPTY".equals(String.valueOf(value))) {
                return;
            }
            if (customFilter.getProperty().contains("material")) {
                InvcountSchemeHelper.setMaterialFilter(customFilter, listQFilter);
            } else {
                listQFilter.and(customFilter);
            }
        } else {
            QFilter qFilterParent = new QFilter(customFilter.getProperty(), customFilter.getCP(), customFilter.getValue());
            if (qFilterParent.getProperty().contains("material")) {
                InvcountSchemeHelper.setMaterialFilter(qFilterParent, listQFilter);
            } else {
                listQFilter.and(qFilterParent);
            }
            for (QFilter.QFilterNest qFilterNest : listQFilterNest) {
                InvcountSchemeHelper.cycleCallQFilter(qFilterNest.getFilter(), listQFilter);
            }
        }
    }

    private static void setMaterialFilter(QFilter materialFilter, QFilter listQFilter) {
        String property = materialFilter.getProperty();
        String repProperty = property.replace("material.", "");
        materialFilter.__setProperty(repProperty);
        List list = QueryServiceHelper.queryPrimaryKeys((String)"bd_material", (QFilter[])new QFilter[]{materialFilter}, null, (int)-1);
        if (list.size() > 500000) {
            InvcountSchemeHelper.splitMaterialIds(list, listQFilter);
        } else {
            materialFilter.__setProperty(property);
            listQFilter.and(materialFilter);
        }
    }

    private static void splitMaterialIds(List<Object> materialIdList, QFilter qFilter) {
        int size = materialIdList.size();
        int cycleNum = (int)Math.ceil((double)size / 500000.0);
        int remainNum = size % 500000;
        int endIndex = 0;
        QFilter materialFilter = null;
        for (int i = 0; i < cycleNum; ++i) {
            int startIndex = endIndex;
            endIndex = i == cycleNum - 1 && remainNum != 0 ? (endIndex += remainNum) : (endIndex += 500000);
            List<Object> subList = materialIdList.subList(startIndex, endIndex);
            QFilter spitMaterialFilter = new QFilter("material.id", "in", subList);
            materialFilter = materialFilter == null ? spitMaterialFilter : materialFilter.or(spitMaterialFilter);
        }
        qFilter.and(materialFilter);
    }

    public static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static String[] removeFiled(String[] source, String ... removeFileds) {
        HashSet<String> removeFiledSet = new HashSet<String>(removeFileds.length);
        for (String removeFiled : removeFileds) {
            removeFiledSet.add(removeFiled);
        }
        ArrayList<String> fileds = new ArrayList<String>(source.length);
        for (String string : source) {
            if (removeFiledSet.contains(string)) continue;
            fileds.add(string);
        }
        return fileds.toArray(new String[fileds.size()]);
    }

    public static String[] getDataSetFieldArray(DataSet dataSet) {
        Set fileds = CommonUtils.getDataSetField((DataSet)dataSet, (boolean)true);
        return fileds.toArray(new String[fileds.size()]);
    }

    public static Set<String> getDataSetField(DataSet dataSet) {
        return CommonUtils.getDataSetField((DataSet)dataSet, (boolean)true);
    }

    public static Set<String> getDataSetFieldByNaturalSort(DataSet dataSet) {
        return CommonUtils.getDataSetField((DataSet)dataSet, (boolean)false);
    }

    public static GroupbyDataSet addSumColumn(GroupbyDataSet dataSet, String ... sumFields) {
        for (String sumField : sumFields) {
            dataSet.sum(sumField);
        }
        return dataSet;
    }

    public static DataSet handleNullFiledAsZero(DataSet dataSet, String ... handleFields) {
        if (handleFields == null || handleFields.length == 0) {
            return dataSet;
        }
        HashMap<String, String> mapper = new HashMap<String, String>(16);
        for (String handleField : handleFields) {
            mapper.put(handleField, "case " + handleField + " when null then 0 else " + handleField + " end");
        }
        String[] fileds = InvcountSchemeHelper.mapperFileds(InvcountSchemeHelper.getDataSetFieldArray(dataSet), mapper, new String[0]);
        return dataSet.select(fileds);
    }

    public static String[] mapperFileds(String[] sourceFileds, Map<String, String> mapper, String ... excludeField) {
        if (sourceFileds == null || sourceFileds.length == 0) {
            return new String[0];
        }
        boolean isNeedMapper = true;
        if (mapper == null || mapper.size() == 0) {
            isNeedMapper = false;
        }
        HashSet<String> excludes = new HashSet<String>(excludeField.length);
        for (String exclude : excludeField) {
            excludes.add(exclude);
        }
        ArrayList<String> list = new ArrayList<String>(sourceFileds.length);
        for (String filed : sourceFileds) {
            if (excludes.contains(filed)) continue;
            if (mapper != null) {
                String mapFiled = mapper.get(filed);
                if (isNeedMapper && mapFiled != null) {
                    filed = mapFiled + " as " + filed;
                }
            }
            list.add(filed);
        }
        return list.toArray(new String[list.size()]);
    }

    public static String arraysToString(String[] sourceFileds) {
        String arrayS = Arrays.toString(sourceFileds);
        return arrayS.substring(1, arrayS.length() - 1);
    }

    public static String[] addFileds(String[] source, String ... addFiled) {
        return (String[])ArrayUtils.addAll((Object[])source, (Object[])addFiled);
    }

    public static String[] getInvBalacneEndQtyFieldAsBgnQty() {
        if (BalanceUpdateHandle.isNewPeriodBal()) {
            return new String[]{"qty_bal as bgnqty", "baseqty_bal as bgnbaseqty", "qty2nd_bal as bgnqty2nd"};
        }
        return new String[]{"endqty as bgnqty", "endbaseqty as bgnbaseqty", "endqty2nd as bgnqty2nd"};
    }

    public static JoinDataSet addJoinColumn(JoinDataSet dataSet, String ... joinFields) {
        for (String joinField : joinFields) {
            dataSet.on(joinField, joinField);
        }
        return dataSet;
    }

    public static <T> DataSet changFiledDataType(DataSet dataSet, String filedName, Class<T> T) {
        dataSet = dataSet.select(InvcountSchemeHelper.arraysToString(InvcountSchemeHelper.addFileds(InvcountSchemeHelper.removeFiled(InvcountSchemeHelper.getDataSetFieldArray(dataSet), filedName), "cast(" + filedName + " as " + T.getSimpleName() + ")as " + filedName + "")));
        return dataSet;
    }

    public static String collectionToString(Collection<String> sourceFileds) {
        return String.join((CharSequence)",", sourceFileds.toArray(new String[sourceFileds.size()]));
    }

    private static void buildIdSet(Set<Long> idList, DynamicObject invCounts, String filedName) {
        DynamicObjectCollection collection = (DynamicObjectCollection)invCounts.get(filedName);
        for (DynamicObject dynamicObject : collection) {
            Long id = dynamicObject.getLong("fbasedataid_id");
            idList.add(id);
        }
    }

    private static QFilter getSingleFilter(Set<Long> idSet, String filedName) {
        QFilter singleFilter = null;
        if (!idSet.isEmpty()) {
            singleFilter = new QFilter(filedName + ".id", "in", idSet);
        }
        return singleFilter;
    }

    private static QFilter getCustomFilterString(String serializationFilter) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)serializationFilter, FilterCondition.class);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)InvAccConst.getBalTb());
        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
        filterBuilder.buildFilter();
        QFilter filter = filterBuilder.getQFilter();
        return filter;
    }

    private static QFilter getBalanceUpdateFilter(BalanceUpdateArgs args) {
        BalanceTB balanceTB = args.getRule().getBalanceTB();
        long updateTime = args.getUpdateTime();
        StringBuilder sql = new StringBuilder();
        sql.append(" INNER JOIN ").append(balanceTB.getTb()).append("_tp ");
        sql.append(" sp ON sp.").append("fkeycol").append('=').append(balanceTB.getName()).append(".").append("fkeycol");
        Object[] params = null;
        if (updateTime > -1L) {
            sql.append(" AND ").append("fupdatetime").append("=?");
            params = new Object[]{updateTime};
        } else {
            sql.append(" AND ").append("fstatus").append("=?");
            sql.append(" AND ").append("fupdateruleid").append("=?");
            sql.append(" AND ").append("fbillid").append(InvcountSchemeHelper.getBillIdsFilter(args.getCtx().getBillIds()));
            params = new Object[]{"A", args.getRule().getId()};
        }
        QFilter joinSQL = QFilter.joinSQL((String)balanceTB.getName(), (String)sql.toString(), (Object[])params);
        return joinSQL;
    }

    public static void check4BalanceUpdate(BalanceUpdateArgs args) {
        String entityName = args.getRule().getBalanceTB().getName();
        log.info("InvcountSchemeHelper -------------------- \u65b0\u5f15\u64ce\u8fdb\u5165\u76d8\u70b9\u51bb\u7ed3\u5224\u65ad\uff0centityName:" + entityName);
        if (!InvAccConst.getBalTb().equals(entityName)) {
            return;
        }
        QFilter joinFs = args.getUpdatingBalFs();
        log.info("InvcountSchemeHelper -------------------- filter:" + joinFs);
        String freezeBillNo = InvcountSchemeHelper.invCountCustomExist(entityName, new QFilter[]{joinFs});
        if (!"".equals(freezeBillNo)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u76d8\u70b9\u201c%s\u201d\u51bb\u7ed3\u4e2d\uff0c\u7981\u6b62\u51fa\u5165\u5e93\u3002", (String)"RealTimeBalFilterStep_2", (String)"scmc-im-business", (Object[])new Object[0]), freezeBillNo));
        }
        log.info("InvcountSchemeHelper -------------------- \u672a\u51bb\u7ed3");
    }

    private static String getBillIdsFilter(Set<Object> billIds) {
        StringBuilder idStr = new StringBuilder();
        int i = 0;
        for (Object billid : billIds) {
            if (i != 0) {
                idStr.append(',');
            }
            idStr.append(billid);
            ++i;
        }
        if (billIds.size() == 1) {
            return String.format(" = %s", idStr);
        }
        return String.format(" IN (%s)", idStr);
    }

    private static String printqFilterArray(QFilter[] qFilters) {
        StringBuilder sb = new StringBuilder();
        for (QFilter qFilter : qFilters) {
            sb.append(qFilter.toString());
            sb.append(",");
        }
        String printString = sb.toString();
        return printString.substring(0, printString.lastIndexOf(44));
    }

    private static QFilter[] deepClone(QFilter[] basicFilter) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(basicFilter);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        return (QFilter[])objectInputStream.readObject();
    }

    public static QFilter getAdjustBillDateFilter(JSONObject jsonObject) {
        QFilter dateQFilter;
        Date filterdate = jsonObject.getDate("filterdate");
        String accessNode = jsonObject.getString("accessnode");
        if ("end".equals(accessNode)) {
            filterdate = DateUtils.addOneDay((Date)filterdate);
        }
        filterdate = DateUtils.getDayStartTime((Date)filterdate);
        QFilter bookdateFilter = new QFilter("bookdate", ">=", (Object)filterdate);
        Boolean excludeEnddate = jsonObject.getBoolean("excludeenddate");
        if (excludeEnddate.booleanValue()) {
            dateQFilter = new QFilter("bookdate", "<", (Object)filterdate);
            dateQFilter.and("bookdate", ">=", (Object)DateUtils.getFirstDayOfMonthByDate((Date)filterdate));
            dateQFilter.and("auditdate", ">=", (Object)filterdate);
            dateQFilter.or(bookdateFilter);
        } else {
            dateQFilter = bookdateFilter;
        }
        return dateQFilter;
    }

    public static QFilter getBillDateFilter(DynamicObject invCountSchemeObj) {
        Date endDate = invCountSchemeObj.getDate("enddate");
        String accessNode = invCountSchemeObj.getString("accessnode");
        if ("end".equals(accessNode)) {
            endDate = DateUtils.getDayEndTime((Date)endDate);
        }
        QFilter billDateFilter = new QFilter("bookdate", "<=", (Object)endDate);
        billDateFilter.and("bookdate", ">=", (Object)DateUtils.getFirstDayOfMonthByDate((Date)endDate));
        Boolean excludeEnddate = invCountSchemeObj.getBoolean("excludeenddate");
        if (excludeEnddate.booleanValue()) {
            billDateFilter.and("auditdate", "<=", (Object)endDate);
        }
        return billDateFilter;
    }
}

