/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.consts.Constants;
import kd.scmc.im.enums.PrecisionAccountEnum;

public class MaterialMultiUnitBotpHelper {
    private static int pricePrecision = 10;
    private static final String materialStr = "material";
    private static final String materialUnitStr = "materialUnit";
    private static final String entryUnitStr = "entryUnit";
    private static final String baseunitStr = "baseunit";

    public static void coverMultiUnit(DynamicObject entityEntry, Boolean isTax, Map<String, String> cacheMap) {
        DynamicObject materialInvInfo = entityEntry.getDynamicObject(materialStr);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        DynamicObject materialUnit = materialInvInfo.getDynamicObject("inventoryunit");
        DynamicObject entryUnit = entityEntry.getDynamicObject("unit");
        if (materialUnit == null || entryUnit == null || materialUnit.getString("id").equals(entryUnit.getString("id"))) {
            return;
        }
        entityEntry.set("unit", (Object)materialUnit);
        DynamicObject baseunit = entityEntry.getDynamicObject(baseunitStr);
        BigDecimal baseqty = entityEntry.getBigDecimal("baseqty");
        BigDecimal unit2ndRate = BillUnitAndQtytHelper.getUnitRateConv((Long)material.getPkValue(), (Long)materialUnit.getPkValue(), (Long)baseunit.getPkValue(), cacheMap);
        if (unit2ndRate == null || Constants.ZERO.compareTo(unit2ndRate) == 0) {
            return;
        }
        BigDecimal qtyUnit2nd = BigDecimal.ZERO;
        if (baseqty != null && baseqty.compareTo(BigDecimal.ZERO) != 0) {
            qtyUnit2nd = baseqty.divide(unit2ndRate, materialUnit.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)materialUnit.getInt("precisionaccount")));
        }
        entityEntry.set("qty", (Object)qtyUnit2nd);
        HashMap<String, DynamicObject> unitMap = new HashMap<String, DynamicObject>();
        unitMap.put(materialStr, material);
        unitMap.put(materialUnitStr, materialUnit);
        unitMap.put(entryUnitStr, entryUnit);
        unitMap.put(baseunitStr, baseunit);
        if (isTax.booleanValue()) {
            MaterialMultiUnitBotpHelper.calPrice("priceandtax", entityEntry, cacheMap, unitMap);
        } else {
            MaterialMultiUnitBotpHelper.calPrice("price", entityEntry, cacheMap, unitMap);
        }
    }

    private static void calPrice(String key, DynamicObject entityEntry, Map<String, String> cacheMap, Map<String, DynamicObject> unitMap) {
        BigDecimal taxPrice = MaterialMultiUnitBotpHelper.getNullToZero(key, entityEntry);
        BigDecimal srcUnit2BaseRate = BillUnitAndQtytHelper.getUnitRateConv((Long)unitMap.get(materialStr).getPkValue(), (Long)unitMap.get(entryUnitStr).getPkValue(), (Long)unitMap.get(baseunitStr).getPkValue(), cacheMap);
        BigDecimal targetUnit2BaseRate = BillUnitAndQtytHelper.getUnitRateConv((Long)unitMap.get(materialStr).getPkValue(), (Long)unitMap.get(baseunitStr).getPkValue(), (Long)unitMap.get(materialUnitStr).getPkValue(), cacheMap);
        taxPrice = taxPrice.divide(srcUnit2BaseRate.multiply(targetUnit2BaseRate), pricePrecision, 4);
        entityEntry.set(key, (Object)taxPrice);
    }

    private static BigDecimal getNullToZero(String key, DynamicObject entityEntry) {
        BigDecimal value = entityEntry.getBigDecimal(key);
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value;
    }
}

