/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.helper.TailDiffAdjust;
import kd.scmc.im.enums.StatusEnum;

public class MeasureDeviationAdjustHelper
extends TailDiffAdjust {
    private IFormView view;
    private Map<String, Object> customParams;

    public MeasureDeviationAdjustHelper(IFormView view, Map<String, Object> customParams) {
        super(view, customParams);
        this.view = view;
        this.customParams = customParams;
    }

    @Override
    protected void initEntryData(List rows) {
        IDataModel model = this.view.getModel();
        String formId = model.getDataEntityType().getName();
        DynamicObjectCollection entryCollection = model.getDataEntity().getDynamicObjectCollection("billentry");
        for (int i = 0; i < rows.size(); ++i) {
            JSONObject rowJsonObject = (JSONObject)rows.get(i);
            model.setValue("material", (Object)rowJsonObject.getLong("material"), i);
            model.setValue("materialmasterid", rowJsonObject.get((Object)"materialmasterid"), i);
            model.setValue("unit", (Object)rowJsonObject.getLong("unit"), i);
            model.setValue("baseunit", (Object)rowJsonObject.getLong("baseunit"), i);
            model.setValue("auxpty", (Object)rowJsonObject.getLong("auxpty"), i);
            model.setValue("unit2nd", (Object)rowJsonObject.getLong("unit2nd"), i);
            BigDecimal qty = rowJsonObject.getBigDecimal("qty");
            model.setValue("qty", (Object)qty.abs(), i);
            BigDecimal baseQty = rowJsonObject.getBigDecimal("baseqty");
            model.setValue("baseqty", (Object)baseQty.abs(), i);
            BigDecimal qty2nd = rowJsonObject.getBigDecimal("qty2nd");
            model.setValue("qtyunit2nd", (Object)qty2nd.abs(), i);
            model.setValue("lotnumber", (Object)rowJsonObject.getString("lotnum"), i);
            if (entryCollection != null && entryCollection.get(i) != null) {
                DynamicObject entry = (DynamicObject)entryCollection.get(i);
                entry.set("producedate", (Object)rowJsonObject.getDate("producedate"));
                entry.set("expirydate", (Object)rowJsonObject.getDate("expirydate"));
            }
            model.setValue("warehouse", (Object)rowJsonObject.getLong("warehouse"), i);
            model.setValue("location", (Object)rowJsonObject.getLong("location"), i);
            model.setValue("project", (Object)rowJsonObject.getLong("project"), i);
            model.setValue("configuredcode", (Object)rowJsonObject.getLong("configuredcode"), i);
            model.setValue("tracknumber", (Object)rowJsonObject.getLong("tracknumber"), i);
            this.dealEntryFields(model, rowJsonObject, formId, i);
        }
    }

    private void dealEntryFields(IDataModel model, JSONObject row, String formId, int rowIdx) {
        if ("im_otherinbill".equals(formId)) {
            model.setValue("invtype", (Object)row.getLong("invtype"), rowIdx);
            model.setValue("invstatus", (Object)row.getLong("invstatus"), rowIdx);
            model.setValue("ownertype", (Object)row.getString("ownertype"), rowIdx);
            model.setValue("owner", (Object)row.getLong("owner"), rowIdx);
            model.setValue("keepertype", (Object)row.getString("keepertype"), rowIdx);
            model.setValue("keeper", (Object)row.getLong("keeper"), rowIdx);
        } else {
            model.setValue("outinvtype", (Object)row.getLong("invtype"), rowIdx);
            model.setValue("outinvstatus", (Object)row.getLong("invstatus"), rowIdx);
            model.setValue("outownertype", (Object)row.getString("ownertype"), rowIdx);
            model.setValue("outowner", (Object)row.getLong("owner"), rowIdx);
            model.setValue("outkeepertype", (Object)row.getString("keepertype"), rowIdx);
            model.setValue("outkeeper", (Object)row.getLong("keeper"), rowIdx);
        }
    }

    @Override
    protected void initMainOrg(List rows) {
        JSONObject o = (JSONObject)this.customParams.get("org");
        Long org = o.getLong("id");
        this.view.getModel().setValue("org", (Object)org);
    }

    public static void dealBizType(String formId, ListShowParameter showParameter) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        QFilter qFilter1 = new QFilter("billentity.billform", "=", (Object)formId);
        QFilter qFilter2 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter4 = null;
        if ("im_otherinbill".equals(formId)) {
            qFilter4 = new QFilter("number", "<>", (Object)"370");
        } else if ("im_otheroutbill".equals(formId)) {
            qFilter4 = new QFilter("number", "<>", (Object)"380");
        }
        filterList.add(qFilter1);
        filterList.add(qFilter2);
        filterList.add(qFilter3);
        filterList.add(qFilter4);
        showParameter.getListFilterParameter().setQFilters(filterList);
    }
}

