/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.field.ComboItem;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.im.business.helper.DateHelper;
import kd.scmc.im.utils.CommonUtils;

public class NewInvOrgHelper {
    @Deprecated
    public static List<Map<String, String>> getHasPermissionAndStartedInvOrg(String entityName) {
        List<Map<String, String>> hasPermissionOrgs = NewInvOrgHelper.getPermissionOrgs(entityName);
        if (null == hasPermissionOrgs || hasPermissionOrgs.isEmpty()) {
            return null;
        }
        List<DynamicObject> startedInvOrg = NewInvOrgHelper.getStartedInvOrgs();
        if (null == startedInvOrg || startedInvOrg.isEmpty()) {
            return null;
        }
        return NewInvOrgHelper.getPermissionAndStartedInvOrg(hasPermissionOrgs, startedInvOrg);
    }

    public static List<Map<String, String>> getHasPermissionAndStartedInvOrg(String entityName, String appId) {
        List<Map<String, String>> hasPermissionOrgs;
        if (appId == null || "".equals(appId)) {
            appId = FormMetadataCache.getFormConfig((String)entityName).getAppId();
        }
        if (null == (hasPermissionOrgs = NewInvOrgHelper.getPermissionOrgs(entityName, appId)) || hasPermissionOrgs.isEmpty()) {
            return null;
        }
        List<DynamicObject> startedInvOrg = NewInvOrgHelper.getStartedInvOrgs();
        if (null == startedInvOrg || startedInvOrg.isEmpty()) {
            return null;
        }
        return NewInvOrgHelper.getPermissionAndStartedInvOrg(hasPermissionOrgs, startedInvOrg);
    }

    private static List<Map<String, String>> getPermissionAndStartedInvOrg(List<Map<String, String>> hasPermissionOrgs, List<DynamicObject> startedInvOrg) {
        ArrayList<String> startedOrgs = new ArrayList<String>(16);
        for (DynamicObject startedInv : startedInvOrg) {
            DynamicObject startedOrg = startedInv.getDynamicObject("org");
            if (CommonUtils.isNull((Object)startedOrg)) continue;
            startedOrgs.add(startedOrg.getString("number"));
        }
        ArrayList<Map<String, String>> hasPermissionAndStartedInvOrg = new ArrayList<Map<String, String>>(16);
        for (Map<String, String> org : hasPermissionOrgs) {
            String orgID = org.get("number");
            if (orgID == null || !startedOrgs.contains(orgID)) continue;
            hasPermissionAndStartedInvOrg.add(org);
        }
        if (hasPermissionAndStartedInvOrg.isEmpty()) {
            return null;
        }
        return hasPermissionAndStartedInvOrg;
    }

    @Deprecated
    public static List<Map<String, String>> getPermissionOrgs(String entityName) {
        String entityTypeId = FormMetadataCache.getFormConfig((String)entityName).getEntityTypeId();
        String appId = FormMetadataCache.getFormConfig((String)entityName).getAppId();
        return NewInvOrgHelper.getPermissionOrgs(entityTypeId, appId);
    }

    public static List<Map<String, String>> getPermissionOrgsByAppId(String entityName, String appId) {
        String entityTypeId = FormMetadataCache.getFormConfig((String)entityName).getEntityTypeId();
        if (appId == null || "".equals(appId)) {
            appId = FormMetadataCache.getFormConfig((String)entityName).getAppId();
        }
        return NewInvOrgHelper.getPermissionOrgs(entityTypeId, appId);
    }

    public static List<Map<String, String>> getHasPermissionAndStartedInvOrg(List<Map<String, String>> hasPermissionOrgs) {
        if (hasPermissionOrgs == null || hasPermissionOrgs.isEmpty()) {
            return null;
        }
        List<DynamicObject> startedInvOrg = NewInvOrgHelper.getStartedInvOrgs();
        if (startedInvOrg == null || startedInvOrg.isEmpty()) {
            return null;
        }
        return NewInvOrgHelper.getPermissionAndStartedInvOrg(hasPermissionOrgs, startedInvOrg);
    }

    public static List<Map<String, String>> getPermissionOrgs(String formId, String appId) {
        QFilter filterIsDefault;
        String orgViewType = "05";
        RequestContext requestContext = RequestContext.get();
        long userID = Long.parseLong(requestContext.getUserId());
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appId, (String)formId, (String)"47150e89000000ac");
        QFilter filterTreeType = new QFilter("view.treetype", "=", (Object)orgViewType);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            filterIsDefault = new QFilter("org.id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            filterTreeType = filterTreeType.and(filterIsDefault);
        }
        filterIsDefault = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter = freezeFilter.or(freezeFilter1);
        QFilter[] filterOrgs = new QFilter[]{filterTreeType, filterIsDefault, freezeFilter};
        return NewInvOrgHelper.rebuildPermissionOrgTree(filterOrgs);
    }

    private static List<Map<String, String>> rebuildPermissionOrgTree(QFilter[] filters) {
        if (filters == null) {
            return new ArrayList<Map<String, String>>(0);
        }
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)"id, org.id org, org.number number,org.name name,longnumber,parent", (QFilter[])filters, (String)"level,number");
        if (Utils.isListEmpty((List)orgCol)) {
            return new ArrayList<Map<String, String>>(0);
        }
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(16);
        HashMap orgLongToOrg = new HashMap(16);
        ArrayList<String> rootList = new ArrayList<String>(16);
        HashSet<String> hasChildList = new HashSet<String>(16);
        Iterator orgColIterator = orgCol.iterator();
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        while (orgColIterator.hasNext()) {
            DynamicObject orgView = (DynamicObject)orgColIterator.next();
            String longNumber = orgView.getString("longnumber");
            HashMap<String, String> org = new HashMap<String, String>(16);
            org.put("id", orgView.getString("org"));
            org.put("number", orgView.getString("number"));
            org.put("name", orgView.getString("name"));
            org.put("longnumber", longNumber);
            org.put("parentId", orgView.getString("parent"));
            org.put("isleaf", "1");
            if (rootOrgId == orgView.getLong("org")) {
                rootList.add(longNumber);
            } else {
                String parentLongNumber = StringUtils.substringBeforeLast((String)longNumber, (String)"!");
                Map parent = (Map)orgLongToOrg.get(parentLongNumber);
                if (parent == null) {
                    rootList.add(longNumber);
                } else {
                    parent.put("isleaf", "0");
                    hasChildList.add(parentLongNumber);
                }
            }
            treeList.add(org);
            orgLongToOrg.put(longNumber, org);
        }
        if (rootList.size() > 1) {
            HashMap<String, String> orgRoot = new HashMap<String, String>(16);
            orgRoot.put("id", "9999999999999");
            orgRoot.put("number", "0");
            orgRoot.put("name", ResManager.loadKDString((String)"\u5168\u90e8", (String)"NewInvOrgHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
            orgRoot.put("longnumber", "0");
            orgRoot.put("parentId", "0");
            orgRoot.put("isleaf", "0");
            treeList.add(orgRoot);
            for (String longNumber : rootList) {
                Map org = (Map)orgLongToOrg.get(longNumber);
                if (org == null) continue;
                org.put("parentId", "9999999999999");
                if (hasChildList.contains(longNumber)) {
                    org.put("isleaf", "0");
                    continue;
                }
                org.put("isleaf", "1");
            }
        }
        return treeList;
    }

    public static List<Long> getPermissionOrgListByUserId(String formId, String appId) {
        QFilter filterIsDefault;
        String orgViewType = "05";
        long userID = RequestContext.get().getCurrUserId();
        if (appId == null || "".equals(appId)) {
            appId = FormMetadataCache.getFormConfig((String)formId).getAppId();
        }
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)userID, (String)orgViewType, (String)appId, (String)formId, (String)"47150e89000000ac");
        QFilter filterTreeType = new QFilter("view.treetype", "=", (Object)orgViewType);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            filterIsDefault = new QFilter("org.id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            filterTreeType = filterTreeType.and(filterIsDefault);
        }
        filterIsDefault = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter = freezeFilter.or(freezeFilter1);
        QFilter[] filterOrgs = new QFilter[]{filterTreeType, filterIsDefault, freezeFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)"org.id org", (QFilter[])filterOrgs, (String)"");
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        if (!Utils.isListEmpty((List)orgCol)) {
            for (DynamicObject orgView : orgCol) {
                long orgId = orgView.getLong("org");
                orgIdList.add(orgId);
            }
        }
        return orgIdList;
    }

    public static List<ComboItem> getHasPermissionAndStartedInvOrgFilterColumns(List<Map<String, String>> hasPermissionOrgs) {
        List<Map<String, String>> orgs = NewInvOrgHelper.getHasPermissionAndStartedInvOrg(hasPermissionOrgs);
        if (orgs == null || orgs.isEmpty()) {
            return null;
        }
        return NewInvOrgHelper.HandleFilterColumns(orgs);
    }

    private static List<ComboItem> HandleFilterColumns(List<Map<String, String>> orgs) {
        long orgId = RequestContext.get().getOrgId();
        int len = orgs.size();
        ArrayList<ComboItem> orgItem = new ArrayList<ComboItem>(orgs.size());
        int myOrgIndex = 0;
        boolean myOrgindex_flag = true;
        Map<String, String> tempOrg = null;
        for (int i = 0; i < len; ++i) {
            tempOrg = orgs.get(i);
            orgItem.add(new ComboItem(new LocaleString(tempOrg.get("name")), tempOrg.get("id")));
            if (!myOrgindex_flag || !Long.valueOf(tempOrg.get("id")).equals(orgId)) continue;
            myOrgIndex = i;
            myOrgindex_flag = false;
        }
        if (myOrgIndex > 0) {
            ComboItem myOrg = (ComboItem)orgItem.set(myOrgIndex, (ComboItem)orgItem.get(0));
            orgItem.set(0, myOrg);
        }
        return orgItem;
    }

    public static List<ComboItem> getHasPermissionAndStartedInvOrgFilterColumns(String entityName) {
        List<Map<String, String>> orgs = NewInvOrgHelper.getHasPermissionAndStartedInvOrg(entityName);
        if (orgs == null || orgs.isEmpty()) {
            return null;
        }
        return NewInvOrgHelper.HandleFilterColumns(orgs);
    }

    @Deprecated
    public static Object[] getHasPermissionAndStartedInvOrgIds(String entityName) {
        List<Map<String, String>> orgs = NewInvOrgHelper.getHasPermissionAndStartedInvOrg(entityName);
        if (orgs == null || orgs.isEmpty()) {
            return null;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        for (Map<String, String> tempOrg : orgs) {
            orgIds.add(Long.valueOf(tempOrg.get("id")));
        }
        return orgIds.toArray();
    }

    public static Object[] getHasPermissionAndStartedInvOrgIds(String entityName, String appId) {
        List<Map<String, String>> orgs = NewInvOrgHelper.getHasPermissionAndStartedInvOrg(entityName, appId);
        if (orgs == null || orgs.isEmpty()) {
            return null;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        for (Map<String, String> tempOrg : orgs) {
            orgIds.add(Long.valueOf(tempOrg.get("id")));
        }
        return orgIds.toArray();
    }

    public static boolean checkHasPermissionByOrgId(String entityName, String appId, Object orgId) {
        long userId;
        int count;
        QFilter orgQFilter = new QFilter("org", "=", orgId);
        QFilter qFilter = new QFilter("startstatus", "=", (Object)"B");
        boolean orgStart = QueryServiceHelper.exists((String)"im_invstart", (QFilter[])new QFilter[]{orgQFilter, qFilter});
        if (orgStart && (count = PermissionServiceHelper.checkPermission((Long)(userId = RequestContext.get().getCurrUserId()), (Long)((Long)orgId), (String)appId, (String)entityName, (String)"47150e89000000ac")) == 1) {
            return true;
        }
        return orgStart;
    }

    public static List<DynamicObject> getStartedInvOrgs() {
        QFilter qFilter = new QFilter("startstatus", "=", (Object)"B");
        Map tempInvAcc = BusinessDataServiceHelper.loadFromCache((String)"im_invstart", (String)"id,org,startdate", (QFilter[])new QFilter[]{qFilter});
        if (null == tempInvAcc || tempInvAcc.isEmpty()) {
            return null;
        }
        ArrayList<DynamicObject> orgDOs = new ArrayList<DynamicObject>(tempInvAcc.size());
        for (DynamicObject orgObj : tempInvAcc.values()) {
            orgDOs.add(orgObj);
        }
        return orgDOs;
    }

    public static Long[] getStartedInvOrgsIds() {
        QFilter qFilter = new QFilter("startstatus", "=", (Object)"B");
        Map tempInvAcc = BusinessDataServiceHelper.loadFromCache((String)"im_invstart", (String)"id,org,startdate", (QFilter[])new QFilter[]{qFilter});
        if (tempInvAcc == null || tempInvAcc.isEmpty()) {
            return null;
        }
        ArrayList<Long> orgIDs = new ArrayList<Long>(16);
        for (DynamicObject invAcc : tempInvAcc.values()) {
            DynamicObject org = invAcc.getDynamicObject("org");
            if (org == null) continue;
            orgIDs.add(Long.valueOf(org.getPkValue().toString()));
        }
        return orgIDs.toArray(new Long[0]);
    }

    @Deprecated
    public static DynamicObject getDefaultInvOrg(String entityName) {
        List<Map<String, String>> orgs = NewInvOrgHelper.getHasPermissionAndStartedInvOrg(entityName);
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        long orgId = RequestContext.get().getOrgId();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        boolean hasCurrentOrgPerm = false;
        for (Map<String, String> tempOrg : orgs) {
            Long tempOrgId = Long.valueOf(tempOrg.get("id"));
            if (!tempOrgId.equals(org.getPkValue())) continue;
            hasCurrentOrgPerm = true;
            break;
        }
        if (!hasCurrentOrgPerm && orgs.get(0) != null && !orgs.get(0).isEmpty()) {
            return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(orgs.get(0).get("id")))});
        }
        return org;
    }

    public static DynamicObject getDefaultInvOrg(String entityName, String appId) {
        List<Map<String, String>> orgs = NewInvOrgHelper.getHasPermissionAndStartedInvOrg(entityName, appId);
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        long orgId = RequestContext.get().getOrgId();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        boolean hasCurrentOrgPerm = false;
        for (Map<String, String> tempOrg : orgs) {
            Long tempOrgId = Long.valueOf(tempOrg.get("id"));
            if (!tempOrgId.equals(org.getPkValue())) continue;
            hasCurrentOrgPerm = true;
            break;
        }
        if (!hasCurrentOrgPerm && orgs.get(0) != null && !orgs.get(0).isEmpty()) {
            return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(orgs.get(0).get("id")))});
        }
        return org;
    }

    @Deprecated
    public static Object[] getHasPermission(String entityName) {
        List<Map<String, String>> hasPermissionOrgs = NewInvOrgHelper.getPermissionOrgs(entityName);
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        for (Map<String, String> tempOrg : hasPermissionOrgs) {
            if (tempOrg.get("id").equals("9999999999999")) continue;
            orgIds.add(Long.valueOf(tempOrg.get("id")));
        }
        return orgIds.toArray();
    }

    public static Object[] getHasPermission(String entityName, String appId) {
        if (appId == null || "".equals(appId)) {
            appId = FormMetadataCache.getFormConfig((String)entityName).getAppId();
        }
        List<Map<String, String>> hasPermissionOrgs = NewInvOrgHelper.getPermissionOrgs(entityName, appId);
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        for (Map<String, String> tempOrg : hasPermissionOrgs) {
            if (tempOrg.get("id").equals("9999999999999")) continue;
            orgIds.add(Long.valueOf(tempOrg.get("id")));
        }
        return orgIds.toArray();
    }

    public static boolean isStartInv(Long org) {
        return DateHelper.getInvStartedDate(org) != null;
    }
}

