/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.enums.InvalidEnum;

public class OperatorGroupHelper {
    @Deprecated
    public static void setOperatorGroupFilter(SetFilterEvent e, List<Long> orgIds, String billFormId) {
        if (e.getMainOrgQFilter() == null) {
            orgIds = OperatorGroupHelper.buildOrgIds(billFormId);
        }
        long userId = UserServiceHelper.getCurrentUserId();
        ArrayList<Long> isolatedOrgList = new ArrayList<Long>(16);
        ArrayList<Long> notIsolatedOrgList = new ArrayList<Long>(16);
        OperatorGroupHelper.buildIsolateList(orgIds, isolatedOrgList, notIsolatedOrgList);
        if (isolatedOrgList.isEmpty()) {
            return;
        }
        List<Long> userGrpList = OperatorGroupHelper.getOperatorGroupByUser(userId, false);
        List<Long> userInvalidGrpList = OperatorGroupHelper.getOperatorGroupByUser(userId, true);
        List<Long> orgGrpList = OperatorGroupHelper.getOperatorGroupByOrg(isolatedOrgList, userId, userInvalidGrpList);
        List<Long> validOperatorGroup = OperatorGroupHelper.getValidOperatorGroup(orgGrpList, userGrpList, userInvalidGrpList);
        if (billFormId.equals("im_transdirbill")) {
            QFilter q = new QFilter("outoperatorgroup", "in", validOperatorGroup);
            q.or("outorg", "in", notIsolatedOrgList);
            e.getQFilters().add(q);
        } else {
            QFilter q = new QFilter("operatorgroup", "in", validOperatorGroup);
            q.or("org", "in", notIsolatedOrgList);
            e.getQFilters().add(q);
        }
    }

    public static void setOperatorGroupFilter(String appId, SetFilterEvent e, List<Long> orgIds, String billFormId) {
        if (e.getMainOrgQFilter() == null) {
            orgIds = OperatorGroupHelper.buildOrgIds(appId, billFormId);
        }
        long userId = UserServiceHelper.getCurrentUserId();
        ArrayList<Long> isolatedOrgList = new ArrayList<Long>(16);
        ArrayList<Long> notIsolatedOrgList = new ArrayList<Long>(16);
        OperatorGroupHelper.buildIsolateList(orgIds, isolatedOrgList, notIsolatedOrgList);
        if (isolatedOrgList.isEmpty()) {
            return;
        }
        ArrayList<Long> userGrpList = new ArrayList<Long>();
        ArrayList<Long> userOperList = new ArrayList<Long>();
        OperatorGroupHelper.getOperatorGroupByUser(isolatedOrgList, userId, userGrpList, userOperList);
        userOperList.add(0L);
        userGrpList.add(0L);
        if ("im_transdirbill".equals(billFormId)) {
            QFilter q = new QFilter("outoperatorgroup", "in", userGrpList);
            q.or("outorg", "in", notIsolatedOrgList);
            q.or("operator", "in", userOperList);
            q.or("outoperator", "in", userOperList);
            e.getQFilters().add(q);
        } else if ("im_invcountbill".equals(billFormId)) {
            QFilter q = new QFilter("operatorgroup", "in", userGrpList);
            q.or("org", "in", notIsolatedOrgList);
            q.or("operator", "in", userOperList);
            q.or("checker", "in", userOperList);
            q.or("checker2nd", "in", userOperList);
            e.getQFilters().add(q);
        } else {
            QFilter q = new QFilter("operatorgroup", "in", userGrpList);
            q.or("org", "in", notIsolatedOrgList);
            q.or("operator", "in", userOperList);
            e.getQFilters().add(q);
        }
    }

    @Deprecated
    private static List<Long> buildOrgIds(String entityName) {
        List<Map<String, String>> permissionOrgs = NewInvOrgHelper.getPermissionOrgs(entityName);
        ArrayList<Long> orgIds = new ArrayList<Long>(permissionOrgs.size());
        for (Map<String, String> permissionOrg : permissionOrgs) {
            orgIds.add(Long.valueOf(permissionOrg.get("id")));
        }
        return orgIds;
    }

    private static List<Long> buildOrgIds(String appId, String entityName) {
        List<Map<String, String>> permissionOrgs = NewInvOrgHelper.getPermissionOrgsByAppId(entityName, appId);
        ArrayList<Long> orgIds = new ArrayList<Long>(permissionOrgs.size());
        for (Map<String, String> permissionOrg : permissionOrgs) {
            orgIds.add(Long.valueOf(permissionOrg.get("id")));
        }
        return orgIds;
    }

    private static List<Long> getValidOperatorGroup(List<Long> orgGrpList, List<Long> userGrpList, List<Long> userInvalidGrpList) {
        ArrayList<Long> grpList = new ArrayList<Long>(16);
        if (orgGrpList == null || orgGrpList.size() == 0) {
            if (userGrpList == null || userGrpList.size() == 0) {
                grpList.add(0L);
                return grpList;
            }
            userGrpList.add(0L);
            return userGrpList;
        }
        if (!(userGrpList != null && userGrpList.size() != 0 || userInvalidGrpList != null && userInvalidGrpList.size() != 0)) {
            grpList.add(0L);
            return grpList;
        }
        if (userGrpList == null || userGrpList.size() == 0) {
            grpList.add(0L);
            return grpList;
        }
        for (Long orgGrp : orgGrpList) {
            if (!userGrpList.contains(orgGrp)) continue;
            grpList.add(orgGrp);
        }
        grpList.add(0L);
        return grpList;
    }

    private static List<Long> getOperatorGroupByOrg(List<Long> orgIds, Long userId, List<Long> userInvalidGrpList) {
        ArrayList<Long> operatorGroupList = new ArrayList<Long>(16);
        QFilter[] qFilters = OperatorGroupHelper.getQFilter(orgIds);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,operatorgrouptype", (QFilter[])qFilters);
        if (map != null && map.size() > 0) {
            for (DynamicObject dynamicObject : map.values()) {
                if (dynamicObject == null) continue;
                operatorGroupList.add((Long)dynamicObject.getPkValue());
            }
        }
        if (userInvalidGrpList != null && !userInvalidGrpList.isEmpty()) {
            operatorGroupList.removeAll(userInvalidGrpList);
        }
        return operatorGroupList;
    }

    private static QFilter[] getQFilter(List<Long> orgIds) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bd_operatorgroup");
        String baseDataTableName = dt.getAlias();
        String bsaeDataUseRangeTableName = baseDataTableName + "_U";
        QFilter qFilter1 = QFilter.joinSQL((String)"t_bd_operatorgroup", (String)("inner join " + bsaeDataUseRangeTableName + " on " + bsaeDataUseRangeTableName + ".fdataid = t_" + "bd_operatorgroup" + ".fid and " + bsaeDataUseRangeTableName + ".fuseorgid in(" + orgIds + ")"), (Object[])new Object[0]);
        QFilter qFilter2 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.INVENTORYGRP.getValue());
        return new QFilter[]{qFilter1, qFilter2};
    }

    private static QFilter getOrgQFilter(List<Long> orgIds) {
        QFilter orgQ = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", orgIds, (boolean)Boolean.TRUE);
        QFilter qFilter2 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.INVENTORYGRP.getValue());
        return orgQ.and(qFilter2);
    }

    private static List<Long> getOperatorGroupByUser(long userID, boolean invalid) {
        ArrayList<Long> operatorGroupList = null;
        QFilter q1 = new QFilter("operatorid", "=", (Object)userID);
        QFilter q2 = new QFilter("opergrptype", "=", (Object)OperatorGrpTypeEnum.INVENTORYGRP.getValue());
        String invalidValue = InvalidEnum.NO.getValue();
        if (invalid) {
            invalidValue = InvalidEnum.YES.getValue();
        }
        q2.and("invalid", "=", (Object)invalidValue);
        DynamicObjectCollection operatorCollection = QueryServiceHelper.query((String)"bd_operator", (String)"id,operatorgrpid", (QFilter[])new QFilter[]{q1, q2});
        if (operatorCollection != null && operatorCollection.size() > 0) {
            operatorGroupList = new ArrayList<Long>(operatorCollection.size());
            for (DynamicObject operator : operatorCollection) {
                if (operator == null) continue;
                operatorGroupList.add(operator.getLong("operatorgrpid"));
            }
        }
        return operatorGroupList;
    }

    private static void getOperatorGroupByUser(List<Long> orgIds, long userID, List<Long> userGrpList, List<Long> userOperList) {
        QFilter q1 = new QFilter("entryentity.operator.id", "=", (Object)userID);
        String invalidValue = InvalidEnum.NO.getValue();
        QFilter orgQFilter = OperatorGroupHelper.getOrgQFilter(orgIds);
        q1.and("entryentity.invalid", "=", (Object)invalidValue);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        DynamicObjectCollection operatorCollection = QueryServiceHelper.query((String)"bd_operatorgroup", (String)"id,groupdatashare,entryentity.charge charge,entryentity.id entryid", (QFilter[])new QFilter[]{orgQFilter, q1, enableFilter});
        if (operatorCollection != null && operatorCollection.size() > 0) {
            for (DynamicObject operator : operatorCollection) {
                if (operator == null) continue;
                if (operator.getBoolean("groupdatashare") || operator.getBoolean("charge")) {
                    userGrpList.add(operator.getLong("id"));
                    continue;
                }
                userOperList.add(operator.getLong("entryid"));
            }
        }
        if (CollectionUtils.isEmpty(userGrpList) && CollectionUtils.isEmpty(userOperList)) {
            DynamicObjectCollection grpList = QueryServiceHelper.query((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{orgQFilter, enableFilter});
            for (DynamicObject grp : grpList) {
                userGrpList.add(grp.getLong("id"));
            }
        }
    }

    public static QFilter getOperatorGroupByUserForAll(long userId, DynamicObject org) {
        ArrayList<Long> userGrpList = new ArrayList<Long>();
        ArrayList<Long> userOperList = new ArrayList<Long>();
        ArrayList<Long> orgList = new ArrayList<Long>();
        orgList.add(org.getLong("id"));
        OperatorGroupHelper.getOperatorGroupByUser(orgList, userId, userGrpList, userOperList);
        QFilter qFilter = new QFilter("operatorgrpid", "in", userGrpList);
        qFilter.or(new QFilter("id", "in", userOperList));
        if (userGrpList.isEmpty() && userOperList.isEmpty()) {
            qFilter = new QFilter("1", "=", (Object)1);
        }
        return qFilter;
    }

    private static void buildIsolateList(List<Long> orgIds, List<Long> isolateOrgList, List<Long> notIsolateOrgList) {
        DynamicObjectCollection sysParams;
        ParamPublishObject param = ParameterReader.getParameterObject(null, (String)"=9Q86DR2P+Q");
        if (param != null && (sysParams = ParameterHelper.queryAllOrgParams(orgIds, (String)"05", (String)param.getId())) != null) {
            for (DynamicObject sysParam : sysParams) {
                String operatorGroupIsolate;
                JSONObject sysParamJson;
                if (sysParam.get("fdata") == null || (sysParamJson = JSONObject.parseObject((String)sysParam.get("fdata").toString())) == null || !Boolean.parseBoolean(operatorGroupIsolate = sysParamJson.getString("foperatorgroupisolate"))) continue;
                isolateOrgList.add(sysParam.getLong("forgid"));
            }
        }
        for (Long orgId : orgIds) {
            if (isolateOrgList.contains(orgId)) continue;
            notIsolateOrgList.add(orgId);
        }
    }
}

