/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.OrgProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.scmc.im.utils.CommonUtils;
import org.apache.commons.lang3.StringUtils;

public class OrgHelper {
    public static List<Long> getHasPermissionOrg(String entityName) {
        String orgViewType = OrgHelper.getOrgViewType(entityName, null);
        return OrgHelper.getHasPermissionOrg(entityName, orgViewType);
    }

    public static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        Map tempInvStart = null;
        ArrayList<Long> orgIDs = new ArrayList<Long>();
        if ("05".equals(orgViewType)) {
            QFilter qFilter = new QFilter("startstatus", "=", (Object)"B");
            tempInvStart = BusinessDataServiceHelper.loadFromCache((String)"im_invstart", (String)"id,org,startdate", (QFilter[])new QFilter[]{qFilter});
            if (CommonUtils.isNull((Object)tempInvStart)) {
                return null;
            }
            for (DynamicObject invStart : tempInvStart.values()) {
                DynamicObject org = invStart.getDynamicObject("org");
                if (org == null) continue;
                orgIDs.add((Long)org.getPkValue());
            }
        }
        ArrayList<Long> orgs = new ArrayList<Long>();
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            if (tempInvStart != null && orgIDs.size() >= 1 && !orgIDs.contains(tempOrgId)) continue;
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    public static Long getDefaultOrg(String entityName) {
        String orgViewType = OrgHelper.getOrgViewType(entityName, null);
        return OrgHelper.getDefaultOrg(entityName, orgViewType);
    }

    public static Long getDefaultOrg(String entityName, String orgViewType) {
        long orgId = RequestContext.get().getOrgId();
        List<Long> orgs = OrgHelper.getHasPermissionOrg(entityName, orgViewType);
        if (orgs == null) {
            return null;
        }
        if (orgs != null && orgs.contains(orgId)) {
            return orgId;
        }
        return orgs.get(0);
    }

    private static String getOrgViewType(String entityName, String orgName) {
        String org;
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        OrgProp orgProp = (OrgProp)dataEntityType.getProperty(org = orgName == null ? "org" : orgName);
        if (orgProp == null) {
            return null;
        }
        String orgViewType = orgProp.getOrgFunc();
        if (StringUtils.isBlank((CharSequence)orgViewType)) {
            orgViewType = "15";
        }
        return orgViewType;
    }

    public static List<Long> getChildOrgId(String entityName, Long parentid, boolean includeParentSelf, String orgName) {
        String orgViewType = OrgHelper.getOrgViewType(entityName, orgName);
        return OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewType, Collections.singletonList(parentid), (boolean)includeParentSelf);
    }
}

