/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.IReportListModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class RealBalTailDiffAdjustHelper {
    public static DynamicObject checkData(BeforeDoOperationEventArgs args, int[] selectedRows) {
        if (selectedRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RealBalTailDiffAdjustHelper_4", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (operateKey == null) {
            return null;
        }
        Object paramPk = null;
        DataSet dataSet = DB.queryDataSet((String)"RealBalTailDiffAdjustHelper.checkData", (DBRoute)new DBRoute("scm"), (String)("select FCOMMONMAPID from T_IM_TAILADJUST_SETTING where fopnum = '" + operateKey + "_setting'"));
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            paramPk = row.get("FCOMMONMAPID");
        }
        if (paramPk == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5230\u64cd\u4f5c\u6309\u94ae\u4e2d\u6dfb\u52a0\u5bf9\u5e94\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u3002", (String)"RealBalTailDiffAdjustHelper_5", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        DynamicObject commonMapConfig = BusinessDataServiceHelper.loadSingle(paramPk, (String)"sbs_billfieldmapping");
        if (commonMapConfig == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6620\u5c04\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5230\u6309\u94ae\u64cd\u4f5c\u4e2d\u914d\u7f6e\u5176\u4ed6\u6620\u5c04\u3002", (String)"RealBalTailDiffAdjustHelper_6", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        boolean enable = commonMapConfig.getBoolean("isenable");
        if (!enable) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6620\u5c04\u914d\u7f6e\u201c%s\u201d\u5df2\u7981\u7528\uff0c\u8bf7\u5230\u201c\u4e1a\u52a1\u8bbe\u7f6e->\u901a\u7528\u914d\u7f6e->\u901a\u7528\u6620\u5c04\u914d\u7f6e\u201d\u4e2d\u542f\u7528\u6216\u5728\u6309\u94ae\u64cd\u4f5c\u4e2d\u914d\u7f6e\u5176\u4ed6\u6620\u5c04\u3002", (String)"RealBalTailDiffAdjustHelper_7", (String)"scmc-im-business", (Object[])new Object[0]), commonMapConfig.getString("number")));
        }
        return commonMapConfig;
    }

    public static Map<String, String> getMapping(DynamicObject commonMapConfig) {
        DynamicObjectCollection colsMapping = commonMapConfig.getDynamicObjectCollection("colsmap");
        HashMap<String, String> colMapping = new HashMap<String, String>(colsMapping.size() * 2);
        for (DynamicObject row : colsMapping) {
            String selectValue = row.getString("selectvalue");
            if (selectValue != null && !"0".equals(selectValue)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u91cf\u5c3e\u5dee\u8c03\u6574\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u4e2d\uff0c\u5b57\u6bb5\u6620\u5c04\u7684\u201c\u53d6\u503c\u201d\u4ec5\u652f\u6301\u201d\u6e90\u5355\u5b57\u6bb5\u201c\uff0c\u8bf7\u5230\u201c\u4e1a\u52a1\u8bbe\u7f6e->\u901a\u7528\u914d\u7f6e->\u901a\u7528\u6620\u5c04\u914d\u7f6e\u201d\u4e2d\u4fee\u6539\u3002", (String)"RealBalTailDiffAdjustHelper_8", (String)"scmc-im-business", (Object[])new Object[0]));
            }
            String targetObjCol = row.getString("targetobjcol");
            String sourceBillCol = row.getString("sourcebillcol");
            if (targetObjCol == null || sourceBillCol == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u91cf\u5c3e\u5dee\u8c03\u6574\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u4e2d\uff0c\u5b57\u6bb5\u6620\u5c04\u7684\u201c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u201d\u6216\u201d\u6765\u6e90\u5355\u636e\u201c\u7684\u201c\u6807\u8bc6\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5230\u201c\u4e1a\u52a1\u8bbe\u7f6e->\u901a\u7528\u914d\u7f6e->\u901a\u7528\u6620\u5c04\u914d\u7f6e\u201d\u4e2d\u4fee\u6539\u3002", (String)"RealBalTailDiffAdjustHelper_9", (String)"scmc-im-business", (Object[])new Object[0]));
            }
            colMapping.put(targetObjCol, sourceBillCol);
        }
        return colMapping;
    }

    public static BillShowParameter buildAdjustBill(ReportList reportList, Map<String, String> colsMapping, String opKey) {
        int[] selectedRows = reportList.getEntryState().getSelectedRows();
        IReportListModel reportModel = reportList.getReportModel();
        HashSet<Object> orgIds = new HashSet<Object>();
        DynamicObjectCollection rowDataList = new DynamicObjectCollection();
        Long orgId = 0L;
        for (int rowIndex : selectedRows) {
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            BigDecimal qty = rowData.getBigDecimal("qty");
            BigDecimal baseQty = rowData.getBigDecimal("baseqty");
            BigDecimal qty2nd = rowData.getBigDecimal("qty2nd");
            if ("adjustin".equals(opKey) && qty.compareTo(BigDecimal.ZERO) >= 0 && baseQty.compareTo(BigDecimal.ZERO) >= 0 && qty2nd.compareTo(BigDecimal.ZERO) >= 0 || "adjustout".equals(opKey) && qty.compareTo(BigDecimal.ZERO) <= 0 && baseQty.compareTo(BigDecimal.ZERO) <= 0 && qty2nd.compareTo(BigDecimal.ZERO) <= 0) continue;
            DynamicObject org = rowData.getDynamicObject("org");
            if (org != null) {
                orgIds.add(org.getPkValue());
                orgId = (Long)org.getPkValue();
            }
            rowDataList.add((Object)rowData);
        }
        if (rowDataList.size() == 0) {
            String msg = "adjustin".equals(opKey) ? ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bf9\u6570\u91cf\u6216\u57fa\u672c\u6570\u91cf\u6216\u8f85\u52a9\u6570\u91cf\u4e3a\u6b63\u6570\u7684\u5206\u5f55\u8fdb\u884c\u5165\u5e93\u8c03\u6574\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RealBalTailDiffAdjustHelper_1", (String)"scmc-im-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bf9\u6570\u91cf\u6216\u57fa\u672c\u6570\u91cf\u6216\u8f85\u52a9\u6570\u91cf\u4e3a\u8d1f\u6570\u7684\u5206\u5f55\u8fdb\u884c\u51fa\u5e93\u8c03\u6574\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RealBalTailDiffAdjustHelper_2", (String)"scmc-im-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        if (orgIds.isEmpty()) {
            return null;
        }
        if (orgIds.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u540c\u4e00\u5e93\u5b58\u7ec4\u7ec7\u4e0b\u7684\u6570\u636e\u8fdb\u884c\u5c3e\u5dee\u8c03\u6574\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RealBalTailDiffAdjustHelper_3", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)orgId);
        Map<String, Object> paramMap = RealBalTailDiffAdjustHelper.dealMaterialInvInfo(rowDataList, baseDataFilter, colsMapping, opKey);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("adjustin".equals(opKey) ? "im_otherinbill" : "im_otheroutbill");
        showParameter.setCustomParams(paramMap);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return showParameter;
    }

    private static Map<String, Object> dealMaterialInvInfo(DynamicObjectCollection rowDataList, QFilter baseDataFilter, Map<String, String> colsMapping, String mode) {
        ArrayList<Long> masterIds = new ArrayList<Long>(rowDataList.size());
        for (DynamicObject row : rowDataList) {
            DynamicObject material = row.getDynamicObject("material");
            Long masterId = material.getLong("id");
            masterIds.add(masterId);
        }
        QFilter qFilter = new QFilter("masterid", "in", masterIds);
        qFilter.and(baseDataFilter);
        Map materialDymLoad = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)"id", (QFilter[])qFilter.toArray());
        HashMap<Object, Long> rowIdAndInvIdMap = new HashMap<Object, Long>(materialDymLoad.size());
        for (Map.Entry entry : materialDymLoad.entrySet()) {
            Long masterId = ((DynamicObject)entry.getValue()).getLong("masterid.id");
            rowIdAndInvIdMap.put(masterId, (Long)entry.getKey());
        }
        HashSet<String> dateFields = new HashSet<String>(4);
        ArrayList arrayList = new ArrayList();
        for (DynamicObject rowData : rowDataList) {
            HashMap<String, Object> rowParamMap = new HashMap<String, Object>(32);
            for (Map.Entry<String, String> entry : colsMapping.entrySet()) {
                Object reportValue;
                String targetKey = entry.getKey();
                String sourceKey = entry.getValue();
                if (!rowData.containsProperty(sourceKey) || (reportValue = rowData.get(sourceKey)) == null) continue;
                if (reportValue instanceof DynamicObject) {
                    if ("material".equals(sourceKey)) {
                        DynamicObject material = rowData.getDynamicObject(sourceKey);
                        Long rowDataMaterialId = material.getLong("masterid");
                        if (!rowIdAndInvIdMap.containsKey(rowDataMaterialId)) continue;
                        rowParamMap.put(targetKey, rowIdAndInvIdMap.get(rowDataMaterialId));
                        rowParamMap.put("materialmasterid", rowDataMaterialId);
                        continue;
                    }
                    rowParamMap.put(targetKey, rowData.get(sourceKey + ".id"));
                    continue;
                }
                if (reportValue instanceof BigDecimal) {
                    BigDecimal qtyValue = rowData.getBigDecimal(sourceKey);
                    qtyValue = "adjustin".equals(mode) && qtyValue.compareTo(BigDecimal.ZERO) > 0 || "adjustout".equals(mode) && qtyValue.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : qtyValue.abs();
                    rowParamMap.put(targetKey, qtyValue);
                    continue;
                }
                rowParamMap.put(targetKey, reportValue);
                if (!(reportValue instanceof Date)) continue;
                dateFields.add(targetKey);
            }
            arrayList.add(rowParamMap);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("rows", arrayList);
        paramMap.put("isMeasureAdjust", true);
        paramMap.put("isNewAdjust", true);
        paramMap.put("colsmapping", colsMapping);
        paramMap.put("dateFields", dateFields);
        return paramMap;
    }
}

