/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.BalanceUpdateArgs;
import kd.bos.biz.balance.model.UpdateCtx;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.reserve.business.ConvRateContext;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.ReserveHelper;
import kd.mpscmm.msbd.reserve.business.ReserveRecordHandler;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.datasource.DefaultDataReader;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import kd.scmc.im.business.helper.ReserveTransBalRecordModel;

@Deprecated
public class ReserveTransHelper {
    private static final Log log = LogFactory.getLog(ReserveTransHelper.class);
    private static String[] reserveFields = new String[]{"bill_obj", "bill_no", "bill_id", "billentry_id", "bill_source", "entry_name", "billentry_seq", "reserve_scheme", "reservemethod", "reserveobjtype", "reserveobj"};
    private static List<String> reserveFieldList = new ArrayList<String>(Arrays.asList(reserveFields));

    public static void reserveRecordTrans(BalanceUpdateArgs args) {
        try (TraceSpan ruleSpan = Tracer.create((String)"ReserveTransHelper", (String)"reserveRecordTrans");){
            UpdateCtx ctx = args.getCtx();
            Set billIds = ctx.getBillIds();
            String entityNumber = ctx.getEntityNumber();
            UpdateRule rule = args.getRule();
            int updateType = rule.getUpdateType();
            String entryName = rule.getEntryName();
            BalanceTB balanceTB = rule.getBalanceTB();
            log.info("\u9884\u8ba1\u5165\u91ca\u653e\uff1a" + billIds);
            if (updateType < 0 || billIds.isEmpty() || entryName.contains(".")) {
                return;
            }
            if (ReserveTransHelper.isTrans(entityNumber, billIds)) {
                return;
            }
            DataSet snapData = ReserveTransHelper.getSnapData(args, billIds);
            Map<Long, ReserveTransBalRecordModel> entry4BalIdMap = ReserveTransHelper.getEntryBalRecordMap(snapData, balanceTB.getName());
            if (entry4BalIdMap.isEmpty()) {
                return;
            }
            Map<Object, Set<Object>> srcEntryMap = ReserveTransHelper.getBotpSrcEntryMap(entityNumber, entryName, entry4BalIdMap);
            log.info("\u5355\u636e\u5173\u8054\u5173\u7cfb\u4fe1\u606f\uff1a" + srcEntryMap);
            HashSet<Object> reserveBalIds = new HashSet<Object>(1024);
            for (Set<Object> srcEntryIds : srcEntryMap.values()) {
                reserveBalIds.addAll(srcEntryIds);
            }
            QFilter idF = new QFilter("bal_entryid", "in", reserveBalIds);
            QFilter qtyF = new QFilter("base_qty", ">", (Object)BigDecimal.ZERO);
            StringBuilder reserveCols = new StringBuilder("bill_obj,bill_no,bill_id,billentry_id,bill_source,entry_name,billentry_seq,bal_obj,bal_id,bal_entryid,base_qty,qty,qty2nd,reserve_scheme,bal_source,reservemethod,reserveobjtype,reserveobj");
            Map allFieldMap = MetadataServiceHelper.getDataEntityType((String)"msmod_reserve_record").getAllFields();
            HashSet<String> billModelFieldSet = new HashSet<String>(16);
            HashSet<String> balModelFieldSet = new HashSet<String>(16);
            for (String key : allFieldMap.keySet()) {
                if (key.startsWith("r_")) {
                    billModelFieldSet.add(key);
                    continue;
                }
                if (!key.startsWith("s_")) continue;
                balModelFieldSet.add(key);
            }
            for (String requesFiledInfo : billModelFieldSet) {
                reserveCols.append(",").append(requesFiledInfo);
            }
            for (String suppleFiledInfo : balModelFieldSet) {
                reserveCols.append(",").append(suppleFiledInfo);
            }
            log.info("\u8fc7\u6ee4\u9884\u7559\u8bb0\u5f55\u7684\u6761\u4ef6\u4e3a\uff1a" + idF.toString());
            DynamicObject[] reserveRecords = BusinessDataServiceHelper.load((String)"msmod_reserve_record", (String)reserveCols.toString(), (QFilter[])new QFilter[]{idF, qtyF});
            if (reserveRecords.length == 0) {
                return;
            }
            Map<String, List<DynamicObject>> recordsMap = ReserveTransHelper.getHandleRecords(entityNumber, entry4BalIdMap, reserveRecords, srcEntryMap, balanceTB.getName(), balModelFieldSet, billModelFieldSet);
            List<DynamicObject> reserveTransList = recordsMap.get("msmod_reservetrans");
            Object[] reserveTrans = SaveServiceHelper.save((DynamicObject[])reserveTransList.toArray(new DynamicObject[reserveTransList.size()]));
            log.info("\u9884\u7559\u8f6c\u79fb\u8bb0\u5f55\u4fdd\u5b58\u6210\u529f--\uff1a" + reserveTrans);
            Object[] reserve = SaveServiceHelper.save((DynamicObject[])reserveRecords);
            log.info("\u65e7\u9884\u7559\u8bb0\u5f55\u4fdd\u5b58\u6210\u529f--\uff1a" + reserve);
            List<DynamicObject> newReserveRecords = recordsMap.get("msmod_reserve_record");
            ThreadCache.put((Object)"ReserveOpName", (Object)ctx.getOp());
            ThreadCache.put((Object)"ReserveOpType", (Object)"unterminalrelease");
            ReserveRecordHandler.saveReserveRecordNoTrans(newReserveRecords);
            log.info("\u65b0\u589e\u9884\u7559\u8bb0\u5f55\u4fdd\u5b58\u6210\u529f--\uff1a" + newReserveRecords);
            log.info("\u9884\u7559\u8bb0\u5f55\u8f6c\u79fb\u6210\u529f-----");
        }
    }

    private static boolean isTrans(String formId, Set<Object> billIds) {
        Set srcIds = ReserveHelper.getBotpLinkBillIds((String)formId, (Long[])billIds.toArray(new Long[billIds.size()]));
        return QueryServiceHelper.exists((String)"msmod_reservetrans", (QFilter[])new QFilter("billId", "in", (Object)srcIds).toArray());
    }

    private static void writeBalUpdate(Collection<ReserveTransBalRecordModel> values, BalanceTB balanceTB) {
        String balLockTb = balanceTB.getTb() + "_a";
        String invSql = "update " + balLockTb + " set flockbaseqty = flockbaseqty + ? ,flockqty = flockqty + ?,flockqty2nd = flockqty2nd + ? where fid = ?";
        String aggSql = "update t_msmod_reserveaggregate_a set flockbaseqty = flockbaseqty + ? ,flockqty = flockqty + ?,flockqty2nd = flockqty2nd + ? where fid = ?";
        ArrayList<Object[]> pramsList = new ArrayList<Object[]>(1024);
        DBRoute scmRoute = balanceTB.getDbRoute();
        log.info("\u5f00\u59cb\u53cd\u5199\u4f59\u989d\u8bb0\u5f55\u9501\u5e93\u91cf---------------------");
        for (ReserveTransBalRecordModel reserveBalRecordModel : values) {
            if (pramsList.size() > 1000) {
                ReserveTransHelper.executeMethod(invSql, pramsList, scmRoute);
                pramsList.clear();
            }
            pramsList.add(new Object[]{reserveBalRecordModel.getLockBaseQty(), reserveBalRecordModel.getLockQty(), reserveBalRecordModel.getLockQty2nd(), reserveBalRecordModel.getBalId()});
        }
        if (!pramsList.isEmpty()) {
            ReserveTransHelper.executeMethod(invSql, pramsList, scmRoute);
        }
    }

    private static void executeMethod(String sql, List<Object[]> pramsList, DBRoute scmRoute) {
        DB.executeBatch((DBRoute)scmRoute, (String)sql, pramsList);
    }

    private static Map<Long, List<DynamicObject>> getEntryReserveMap(Map<Object, Set<Object>> srcEntryMap, DynamicObject[] reserveRecords) {
        HashMap<Long, List<DynamicObject>> entryIdReserveMap = new HashMap<Long, List<DynamicObject>>(reserveRecords.length);
        for (DynamicObject reserveRecord : reserveRecords) {
            long balId = reserveRecord.getLong("bal_entryid");
            for (Map.Entry<Object, Set<Object>> entrySet : srcEntryMap.entrySet()) {
                Set<Object> entryIds = entrySet.getValue();
                Long key = (Long)entrySet.getKey();
                if (!entryIds.contains(balId)) continue;
                ArrayList<DynamicObject> reserveRecordList = (ArrayList<DynamicObject>)entryIdReserveMap.get(key);
                if (reserveRecordList == null) {
                    reserveRecordList = new ArrayList<DynamicObject>(16);
                }
                reserveRecordList.add(reserveRecord);
                entryIdReserveMap.put(key, reserveRecordList);
            }
        }
        return entryIdReserveMap;
    }

    private static DataSet getSnapData(BalanceUpdateArgs args, Set<Object> billIds) {
        String snapCols = "fkeycol,fbillid,fentryid,fbaseqty_sp,fqty_sp,fqty2nd_sp";
        StringBuilder balSpQfb = new StringBuilder("fbaseqty_sp > 0 or fqty_sp > 0 or fqty2nd_sp > 0 ");
        DataSet balData = args.getUpdatedBalData("fid,fkeycol,fmaterialid,fbaseunitid,funitid", null, balSpQfb.toString());
        int i = 0;
        balSpQfb.append(" and fbillid in ( ");
        for (Object billId : billIds) {
            if (i > 0) {
                balSpQfb.append(",");
            }
            balSpQfb.append(billId);
            ++i;
        }
        balSpQfb.append(" )");
        DataSet snapData = args.getUpdatedSnapData(snapCols, balSpQfb.toString()).groupBy(new String[]{"fkeycol", "fbillid", "fentryid"}).sum("fbaseqty_sp").sum("fqty_sp").sum("fqty2nd_sp").finish();
        snapData = snapData.join(balData, JoinType.INNER).on("fkeycol", "fkeycol").select(new String[]{"fbillid", "fentryid", "fbaseqty_sp", "fqty_sp", "fqty2nd_sp"}, new String[]{"fid", "fmaterialid", "fbaseunitid", "funitid"}).finish();
        return snapData;
    }

    private static Map<String, List<DynamicObject>> getHandleRecords(String entityNumber, Map<Long, ReserveTransBalRecordModel> entry4BalIdMap, DynamicObject[] reserveRecords, Map<Object, Set<Object>> srcEntryMap, String balName, Set<String> balModelFieldSet, Set<String> billModelFieldSet) {
        Map<Long, List<DynamicObject>> entryIdReserveMap = ReserveTransHelper.getEntryReserveMap(srcEntryMap, reserveRecords);
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(2);
        if (entryIdReserveMap.isEmpty()) {
            return result;
        }
        Map<Long, Map<String, Long>> entryUnitMap = ReserveTransHelper.getEntryUnitMap(reserveRecords);
        ConvRateContext convRate = new ConvRateContext();
        log.info("\u9884\u7559\u8bb0\u5f55\u7684Map\u4e3a\uff1a" + entryIdReserveMap);
        ArrayList<DynamicObject> newReserveRecords = new ArrayList<DynamicObject>(reserveRecords.length);
        ArrayList<DynamicObject> reserveTransRecords = new ArrayList<DynamicObject>(reserveRecords.length);
        result.put("msmod_reserve_record", newReserveRecords);
        result.put("msmod_reservetrans", reserveTransRecords);
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        int length = 0;
        for (List<DynamicObject> values : entryIdReserveMap.values()) {
            length += values.size();
        }
        long[] ids = DB.genLongIds((String)"t_msmod_reserverecord", (int)length);
        int i = 0;
        log.info("reserveentryId: + " + entryIdReserveMap.keySet());
        log.info("balentryId: + " + entry4BalIdMap.keySet());
        Map<Long, Integer> entryIdExpireDateMap = ReserveTransHelper.getInventoryExpireMap(balName, entry4BalIdMap);
        Map<Long, DynamicObject> invBalanceMap = ReserveTransHelper.getInvBillInfo(entryIdReserveMap, balName, entry4BalIdMap);
        Map<Long, Long> aggInvMap = ReserveTransHelper.getAggInvMap(entryIdReserveMap, balName, entry4BalIdMap);
        for (Map.Entry<Long, List<DynamicObject>> entryIdReserve : entryIdReserveMap.entrySet()) {
            List<DynamicObject> reserveRecordList = entryIdReserve.getValue();
            Long entryId = entryIdReserve.getKey();
            ReserveTransBalRecordModel balRecordModel = entry4BalIdMap.get(entryId);
            if (balRecordModel == null) continue;
            for (DynamicObject reserveRecord : reserveRecordList) {
                Map<String, Long> unitMap = entryUnitMap.get(reserveRecord.getLong("bal_entryid"));
                if (unitMap == null) {
                    unitMap = entryUnitMap.get(0L);
                }
                if (unitMap == null && entryUnitMap.size() == 1) {
                    unitMap = entryUnitMap.get(entryUnitMap.keySet().toArray()[0]);
                }
                if (unitMap == null) continue;
                BigDecimal baseQty = reserveRecord.getBigDecimal("base_qty");
                BigDecimal qty = reserveRecord.getBigDecimal("qty");
                BigDecimal qty2nd = reserveRecord.getBigDecimal("qty2nd");
                Long reMaterialId = unitMap.get("materiel");
                Long reBaseUnitId = unitMap.get("baseunit");
                Long reUnitId = unitMap.get("unit");
                BigDecimal balbaseQty = balRecordModel.getAvbBaseQty();
                BigDecimal balQty = balRecordModel.getAvbQty();
                BigDecimal balQty2nd = balRecordModel.getAvbQty2nd();
                Long materialId = balRecordModel.getMaterialId();
                Long baseUnitId = balRecordModel.getBaseUnitId();
                Long unitId = balRecordModel.getUnitId();
                if (baseQty.compareTo(BigDecimal.ZERO) == 0 || balbaseQty.compareTo(BigDecimal.ZERO) == 0) continue;
                DynamicObject reserveTrans = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reservetrans");
                reserveTrans.set("transbill", (Object)entityNumber);
                reserveTrans.set("bfrecordid", reserveRecord.getPkValue());
                reserveTrans.set("afrecordid", (Object)ids[i]);
                reserveTrans.set("billid", (Object)balRecordModel.getBillId());
                reserveTrans.set("billentryid", (Object)entryId);
                reserveTrans.set("transtype", (Object)"trans");
                reserveTrans.set("creater", (Object)userId);
                reserveTrans.set("createdate", (Object)date);
                reserveTransRecords.add(reserveTrans);
                long newEntryID = balRecordModel.getBalId();
                DynamicObject suppleBill = invBalanceMap.get(newEntryID);
                DynamicObject newReserveRecord = ReserveTransHelper.createNewReserveRecord(reserveRecord, userId, date, newEntryID, billModelFieldSet);
                if (aggInvMap.get(newEntryID) != null) {
                    newReserveRecord.set("aggregateid", (Object)aggInvMap.get(newEntryID));
                }
                ReserveTransHelper.setRserveeRcordInfo(newReserveRecord, balName, suppleBill, balModelFieldSet);
                newReserveRecord.set("bal_obj", (Object)balName);
                newReserveRecord.set("bal_source", (Object)"1");
                if (entryIdExpireDateMap.get(newEntryID) != null) {
                    int expireDay = entryIdExpireDateMap.get(newEntryID);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    cal.add(5, expireDay);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    newReserveRecord.set("expiredate", (Object)cal.getTime());
                } else {
                    newReserveRecord.set("expiredate", null);
                }
                BigDecimal subBaseQty = BigDecimal.ZERO;
                BigDecimal subQty = BigDecimal.ZERO;
                BigDecimal subQty2nd = qty2nd.min(balQty2nd);
                if (baseQty.compareTo(balbaseQty) >= 0) {
                    subBaseQty = balbaseQty;
                    subQty = convRate.getSrcQty(subBaseQty, reMaterialId, reUnitId, reBaseUnitId);
                    balRecordModel.addLockBaseQty(balbaseQty);
                    balRecordModel.addLockQty(balQty);
                    balRecordModel.addLockQty2nd(balQty2nd);
                    reserveRecord.set("base_qty", (Object)baseQty.subtract(subBaseQty));
                    reserveRecord.set("qty", (Object)qty.subtract(subQty));
                    reserveRecord.set("qty2nd", (Object)qty2nd.subtract(subQty2nd));
                    newReserveRecord.set("id", (Object)ids[i]);
                    newReserveRecord.set("base_qty", (Object)subBaseQty);
                    newReserveRecord.set("qty", (Object)balQty);
                    newReserveRecord.set("qty2nd", (Object)subQty2nd);
                    newReserveRecord.set("bal_obj", (Object)balName);
                    newReserveRecord.set("bal_source", (Object)"1");
                    newReserveRecords.add(newReserveRecord);
                } else {
                    subBaseQty = baseQty;
                    subQty = convRate.getSrcQty(baseQty, materialId, unitId, baseUnitId);
                    balRecordModel.addLockBaseQty(baseQty);
                    balRecordModel.addLockQty(qty);
                    balRecordModel.addLockQty2nd(qty2nd);
                    reserveRecord.set("base_qty", (Object)BigDecimal.ZERO);
                    reserveRecord.set("qty", (Object)BigDecimal.ZERO);
                    reserveRecord.set("qty2nd", (Object)BigDecimal.ZERO);
                    newReserveRecord.set("id", (Object)ids[i]);
                    newReserveRecord.set("base_qty", (Object)baseQty);
                    newReserveRecord.set("qty", (Object)subQty);
                    newReserveRecord.set("qty2nd", (Object)subQty2nd);
                    newReserveRecords.add(newReserveRecord);
                }
                ++i;
            }
        }
        return result;
    }

    private static Map<Long, DynamicObject> getInvBillInfo(Map<Long, List<DynamicObject>> entryIdReserveMap, String balName, Map<Long, ReserveTransBalRecordModel> entry4BalIdMap) {
        ArrayList<Long> entryIds = new ArrayList<Long>(entryIdReserveMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entryIdReserve : entryIdReserveMap.entrySet()) {
            Long entryId = entryIdReserve.getKey();
            ReserveTransBalRecordModel balRecordModel = entry4BalIdMap.get(entryId);
            long newEntryID = balRecordModel.getBalId();
            entryIds.add(newEntryID);
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)balName);
        DynamicObject[] invBalance = BusinessDataServiceHelper.load((Object[])entryIds.toArray(), (DynamicObjectType)dataEntityType);
        HashMap<Long, DynamicObject> invBalanceMap = new HashMap<Long, DynamicObject>(invBalance.length);
        for (int i = 0; i < invBalance.length; ++i) {
            invBalanceMap.put(invBalance[i].getLong("id"), invBalance[i]);
        }
        return invBalanceMap;
    }

    private static Map<Long, Long> getAggInvMap(Map<Long, List<DynamicObject>> entryIdReserveMap, String balName, Map<Long, ReserveTransBalRecordModel> entry4BalIdMap) {
        HashMap<Long, Long> aggInvMap = new HashMap<Long, Long>(16);
        if (ReserveAggregateHelper.isAggregateInit()) {
            Map aggBalMap = ColsMapHelper.findBillColMaps((String)"msmod_reserveaggre", (String)"msmod_std_inv_field").getBalColMap();
            List aggregateField = ReserveAggregateHelper.getAggregateField();
            StringBuilder sb = new StringBuilder();
            for (String field : aggregateField) {
                sb.append((String)aggBalMap.get(field)).append(" as ").append(field).append(",");
            }
            DataSet aggSet = QueryServiceHelper.queryDataSet((String)DefaultDataReader.class.getName(), (String)"msmod_reserveaggre", (String)org.apache.commons.lang3.StringUtils.join((Object[])new String[]{sb.toString(), "id as aggid"}), null, null);
            ArrayList<Long> entryIds = new ArrayList<Long>(entryIdReserveMap.size());
            for (Map.Entry<Long, List<DynamicObject>> entryIdReserve : entryIdReserveMap.entrySet()) {
                Long entryId = entryIdReserve.getKey();
                ReserveTransBalRecordModel balRecordModel = entry4BalIdMap.get(entryId);
                long newEntryID = balRecordModel.getBalId();
                entryIds.add(newEntryID);
            }
            QFilter qFilter = new QFilter("id", "in", entryIds);
            DataSet invSet = QueryServiceHelper.queryDataSet((String)DefaultDataReader.class.getName(), (String)balName, (String)org.apache.commons.lang3.StringUtils.join((Object[])new String[]{sb.toString(), "id as invId"}), (QFilter[])qFilter.toArray(), null);
            JoinDataSet joinDataSet = invSet.join(aggSet);
            for (String field : aggregateField) {
                joinDataSet.on(field, field);
            }
            invSet = joinDataSet.select(new String[]{"aggid", "invId"}).finish();
            while (invSet.hasNext()) {
                Row row = invSet.next();
                aggInvMap.put(row.getLong("invId"), row.getLong("aggid"));
            }
        }
        return aggInvMap;
    }

    private static void setRserveeRcordInfo(DynamicObject newReserveRecord, String balName, DynamicObject suppleBill, Set<String> balModelFieldSet) {
        ColsMap supColsMap = ColsMapHelper.findBillColMaps((String)balName, (String)"msmod_std_inv_field");
        if (supColsMap != null) {
            Map balColMap = supColsMap.getBalColMap();
            Iterator<String> iterator = balModelFieldSet.iterator();
            while (iterator.hasNext()) {
                String billkey;
                String suppleModleInfo;
                String fild = suppleModleInfo = iterator.next();
                if (suppleModleInfo.startsWith("s_")) {
                    fild = suppleModleInfo.substring(2);
                }
                if ((billkey = (String)balColMap.get(fild)) == null || billkey.length() <= 0) continue;
                Object value = suppleBill.get(billkey);
                newReserveRecord.set(suppleModleInfo, value);
            }
        }
    }

    private static Map<Long, Integer> getInventoryExpireMap(String balName, Map<Long, ReserveTransBalRecordModel> entry4BalIdMap) {
        ColsMap colsMap = ColsMapHelper.findBillColMaps((String)balName, (String)"msmod_std_inv_field");
        HashMap<Long, Integer> entryIdExpireDateMap = new HashMap<Long, Integer>(8);
        StringBuilder sb = new StringBuilder();
        String selectEntryId = " id ";
        if (colsMap.getByBalCol("billentry") != null) {
            selectEntryId = StringUtils.join((Object[])new String[]{colsMap.getByBalCol("billentry"), ".id "});
        }
        sb.append(selectEntryId).append(" as entryID,");
        sb.append(colsMap.getByBalCol("materiel")).append(" as ").append("materialId,");
        sb.append(colsMap.getByBalCol("org")).append(" as ").append("orgId");
        ArrayList<Long> balEntryIdList = new ArrayList<Long>(entry4BalIdMap.size());
        for (ReserveTransBalRecordModel balRecordModel : entry4BalIdMap.values()) {
            balEntryIdList.add(balRecordModel.getBalId());
        }
        if (sb.length() < 1) {
            return entryIdExpireDateMap;
        }
        QFilter qFilter = new QFilter(selectEntryId, "in", balEntryIdList);
        DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)"ReserveTransHelper:getInventoryExpireMap", (String)balName, (String)sb.toString(), (QFilter[])new QFilter[]{qFilter}, null);
        String entityID = "bd_materialinventoryinfo";
        while (materialDataSet.hasNext()) {
            Row row = materialDataSet.next();
            QFilter orgQFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityID, (Long)row.getLong("orgId"));
            QFilter materialQFilter = new QFilter("masterid", "=", (Object)row.getLong("materialId"));
            materialQFilter.and("reservationperiod", "!=", null);
            materialQFilter.and("reservationperiod", "!=", (Object)0);
            String selectProperties = "reservationperiod";
            DynamicObject inventoryInfo = BusinessDataServiceHelper.loadSingleFromCache((String)entityID, (String)selectProperties, (QFilter[])new QFilter[]{orgQFilter, materialQFilter});
            if (inventoryInfo == null) continue;
            entryIdExpireDateMap.put(row.getLong("entryID"), inventoryInfo.getInt("reservationperiod"));
        }
        return entryIdExpireDateMap;
    }

    private static Map<Long, Map<String, Long>> getEntryUnitMap(DynamicObject[] reserveRecords) {
        HashMap<Long, Map<String, Long>> entryUnitMap = new HashMap<Long, Map<String, Long>>(reserveRecords.length);
        HashMap<String, HashSet<Long>> formBalIdMap = new HashMap<String, HashSet<Long>>(8);
        for (DynamicObject reserveRecord : reserveRecords) {
            String formId = reserveRecord.getString("bal_obj.id");
            HashSet<Long> balIds = (HashSet<Long>)formBalIdMap.get(formId);
            if (balIds == null) {
                balIds = new HashSet<Long>(16);
                formBalIdMap.put(formId, balIds);
            }
            balIds.add(reserveRecord.getLong("bal_id"));
        }
        Map colsMapMap = ColsMapHelper.findBillColMaps(formBalIdMap.keySet(), (String)"msmod_std_inv_field");
        for (Map.Entry entry : formBalIdMap.entrySet()) {
            String formId = (String)entry.getKey();
            Set balIds = (Set)entry.getValue();
            ColsMap colsMap = (ColsMap)colsMapMap.get(formId);
            if (balIds.isEmpty() || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)formId) || colsMap == null) {
                return entryUnitMap;
            }
            Map colMap = colsMap.getBalColMap();
            StringBuilder sb = new StringBuilder();
            sb.append((String)colMap.get("materiel")).append(" as ").append("materiel");
            sb.append(" , ").append((String)colMap.get("baseunit")).append(" as ").append("baseunit");
            sb.append(" , ").append((String)colMap.get("unit")).append(" as ").append("unit");
            String materiel = (String)colMap.get("materiel");
            if (materiel != null) {
                String[] materielArray = materiel.split("\\.");
                if (materielArray.length == 1) {
                    sb.append(" , ").append("id").append(" as ").append("entryid");
                } else {
                    if (colMap.get("billentry") == null) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7684\u9884\u7559\u4f9b\u5e94\u6a21\u578b\u914d\u7f6e\u4e2d\u6ca1\u6709\u914d\u7f6e\u5355\u636e\u4f53\u6807\u8bc6\uff0c\u8bf7\u68c0\u67e5\u9884\u7559\u4f9b\u5e94\u6a21\u578b\u914d\u7f6e\u3002", (String)"ReserveTransHelper_0", (String)"scmc-im-business", (Object[])new Object[0]), formId));
                    }
                    sb.append(" , ").append((String)colMap.get("billentry")).append(".id").append(" as ").append("entryid");
                }
            }
            DataSet bal = QueryServiceHelper.queryDataSet((String)(ReserveTransHelper.class.getName() + ":getEntryUnitMap"), (String)formId, (String)sb.toString(), (QFilter[])new QFilter("id", "in", (Object)balIds).toArray(), null);
            bal.forEach(v -> {
                Long balEntryId = v.getLong("entryid");
                HashMap<String, Long> unitMap = new HashMap<String, Long>(16);
                unitMap.put("materiel", v.getLong("materiel"));
                unitMap.put("baseunit", v.getLong("baseunit"));
                unitMap.put("unit", v.getLong("unit"));
                entryUnitMap.put(balEntryId, unitMap);
            });
        }
        return entryUnitMap;
    }

    private static DynamicObject createNewReserveRecord(DynamicObject reserveRecord, long userId, Date date, Long balId, Set<String> billModelFieldSet) {
        DynamicObject newReserveRecord = BusinessDataServiceHelper.newDynamicObject((String)reserveRecord.getDataEntityType().getName());
        reserveFieldList.addAll(billModelFieldSet);
        for (String reserveKey : reserveFieldList) {
            if ("reserve_scheme".equals(reserveKey)) {
                if (reserveRecord.get(reserveKey) == null) continue;
                try {
                    DynamicObject scheme = reserveRecord.getDynamicObject(reserveKey);
                    newReserveRecord.set(reserveKey, (Object)scheme.getLong("id"));
                }
                catch (Exception e) {
                    log.error("trans createNewReserveRecord", (Throwable)e);
                }
                continue;
            }
            newReserveRecord.set(reserveKey, reserveRecord.get(reserveKey));
        }
        newReserveRecord.set("creater", (Object)userId);
        newReserveRecord.set("create_date", (Object)date);
        newReserveRecord.set("reserveprctype", (Object)"2");
        newReserveRecord.set("bal_id", (Object)balId);
        newReserveRecord.set("bal_entryid", (Object)balId);
        return newReserveRecord;
    }

    private static Map<Long, ReserveTransBalRecordModel> getEntryBalRecordMap(DataSet snapData, String balFormId) {
        HashMap<Long, ReserveTransBalRecordModel> entryBalIdMap = new HashMap<Long, ReserveTransBalRecordModel>(1024);
        while (snapData.hasNext()) {
            Row row = snapData.next();
            ReserveTransBalRecordModel balRecordModel = new ReserveTransBalRecordModel();
            balRecordModel.setBalFormId(balFormId);
            balRecordModel.setBalId(row.getLong("fid"));
            balRecordModel.setBillId(row.getLong("fbillid"));
            balRecordModel.setBaseQty(row.getBigDecimal("fbaseqty_sp"));
            balRecordModel.setQty(row.getBigDecimal("fqty_sp"));
            balRecordModel.setQty2nd(row.getBigDecimal("fqty2nd_sp"));
            balRecordModel.setMaterialId(row.getLong("fmaterialid"));
            balRecordModel.setBaseUnitId(row.getLong("fbaseunitid"));
            balRecordModel.setUnitId(row.getLong("funitid"));
            entryBalIdMap.put(row.getLong("fentryid"), balRecordModel);
        }
        return entryBalIdMap;
    }

    private static Map<Object, Set<Object>> getBotpSrcEntryMap(String formId, String entryKey, Map<Long, ReserveTransBalRecordModel> entry4BalIdMap) {
        HashMap<Object, Set<Object>> srcEntryIdMap = new HashMap<Object, Set<Object>>(16);
        Set<Long> entryIds = entry4BalIdMap.keySet();
        if (entryIds.isEmpty()) {
            return srcEntryIdMap;
        }
        HashSet<Long> billIdSet = new HashSet<Long>(entry4BalIdMap.size());
        for (Map.Entry<Long, ReserveTransBalRecordModel> entry : entry4BalIdMap.entrySet()) {
            Long billId = entry.getValue().getBillId();
            billIdSet.add(billId);
        }
        Map botpUpPath4EntryId = ReserveHelper.getBotpUpPath4EntryId((String)formId, (String)entryKey, (Long[])entryIds.toArray(new Long[entryIds.size()]), (Long[])billIdSet.toArray(new Long[billIdSet.size()]));
        for (Long entryId : entryIds) {
            HashSet<Long> srcEntryIds = new HashSet<Long>(16);
            List srcIds = (List)botpUpPath4EntryId.get(entryId);
            if (srcIds != null) {
                srcEntryIds.addAll(srcIds);
            }
            srcEntryIds.add(entryId);
            srcEntryIdMap.put(entryId, srcEntryIds);
        }
        return srcEntryIdMap;
    }

    public static void unReserveRecordTrans(BalanceUpdateArgs args) {
        try (TraceSpan ruleSpan = Tracer.create((String)"ReserveTransHelper", (String)"unReserveRecordTrans");){
            UpdateCtx ctx = args.getCtx();
            Set billIds = ctx.getBillIds();
            String entityNumber = ctx.getEntityNumber();
            BalanceTB tb = args.getRule().getBalanceTB();
            String balFormId = tb.getName();
            if (billIds.isEmpty()) {
                return;
            }
            QFilter idF = new QFilter("billid", "in", (Object)billIds);
            QFilter formIdF = new QFilter("transbill", "=", (Object)entityNumber);
            DynamicObjectCollection reservetransCols = QueryServiceHelper.query((String)"msmod_reservetrans", (String)"bfrecordid,afrecordid,billentryid", (QFilter[])new QFilter[]{idF, formIdF});
            if (reservetransCols.isEmpty()) {
                return;
            }
            HashMap<Long, Long> reserveIdsMap = new HashMap<Long, Long>(reservetransCols.size());
            for (DynamicObject reservetrans : reservetransCols) {
                reserveIdsMap.put(reservetrans.getLong("afrecordid"), reservetrans.getLong("bfrecordid"));
            }
            ReserveTransHelper.handleBalAndReserveRecord(balFormId, reserveIdsMap, tb);
            log.info("\u5f00\u59cb\u5220\u9664\u8f6c\u79fb\u8bb0\u5f55\u548c\u9884\u7559\u8bb0\u5f55");
            DeleteServiceHelper.delete((String)"msmod_reservetrans", (QFilter[])new QFilter[]{idF, formIdF});
            DeleteServiceHelper.delete((String)"msmod_reserve_record", (QFilter[])new QFilter("id", "in", reserveIdsMap.keySet()).toArray());
        }
    }

    private static void handleBalAndReserveRecord(String balFormId, Map<Long, Long> reserveIdsMap, BalanceTB tb) {
        HashMap<Long, Object[]> reserveParamsMap = new HashMap<Long, Object[]>(reserveIdsMap.size());
        HashMap<Long, Object[]> balParamsMap = new HashMap<Long, Object[]>(reserveIdsMap.size());
        HashMap<Long, Object[]> aggParamsMap = new HashMap<Long, Object[]>(reserveIdsMap.size());
        HashMap<Long, Object[]> oldBalParamsMap = new HashMap<Long, Object[]>(reserveIdsMap.size());
        QFilter reserveIdF = new QFilter("id", "in", reserveIdsMap.keySet());
        QFilter balF = new QFilter("bal_obj", "in", (Object)balFormId);
        DataSet reserveRecords = QueryServiceHelper.queryDataSet((String)ReserveTransHelper.class.getName(), (String)"msmod_reserve_record", (String)"id,reserveprctype,bal_id,bal_entryid,base_qty,qty,qty2nd,aggregateid", (QFilter[])new QFilter[]{reserveIdF, balF}, null);
        HashSet<Long> bfReplaceIds = new HashSet<Long>(16);
        HashSet<Long> bfTransIds = new HashSet<Long>(16);
        while (reserveRecords.hasNext()) {
            Row reserveRecord = reserveRecords.next();
            Long reserveId = reserveRecord.getLong("id");
            BigDecimal baseQty = reserveRecord.getBigDecimal("base_qty");
            BigDecimal qty = reserveRecord.getBigDecimal("qty");
            BigDecimal qty2nd = reserveRecord.getBigDecimal("qty2nd");
            String reservePrc = reserveRecord.getString("reserveprctype");
            Long balId = reserveRecord.getLong("bal_entryid");
            Long aggId = reserveRecord.getLong("aggregateid");
            Long bfReserveId = reserveIdsMap.get(reserveId);
            if (bfReserveId == null) continue;
            Object[] reserveParam = (Object[])reserveParamsMap.get(bfReserveId);
            if (reserveParam == null) {
                reserveParam = new Object[]{baseQty, qty, qty2nd, bfReserveId};
                reserveParamsMap.put(bfReserveId, reserveParam);
            } else {
                reserveParam[0] = baseQty.add((BigDecimal)reserveParam[0]);
                reserveParam[1] = qty.add((BigDecimal)reserveParam[1]);
                reserveParam[2] = qty2nd.add((BigDecimal)reserveParam[2]);
            }
            Object[] balParam = (Object[])balParamsMap.get(balId);
            if (balParam == null) {
                balParam = new Object[]{baseQty, qty, qty2nd, balId};
                balParamsMap.put(balId, balParam);
            } else {
                balParam[0] = baseQty.add((BigDecimal)balParam[0]);
                balParam[1] = qty.add((BigDecimal)balParam[1]);
                balParam[2] = qty2nd.add((BigDecimal)balParam[2]);
            }
            Object[] aggParam = (Object[])aggParamsMap.get(aggId);
            if (aggParam == null) {
                aggParam = new Object[]{baseQty, qty, qty2nd, aggId};
                aggParamsMap.put(aggId, aggParam);
            } else {
                aggParam[0] = baseQty.add((BigDecimal)aggParam[0]);
                aggParam[1] = qty.add((BigDecimal)aggParam[1]);
                aggParam[2] = qty2nd.add((BigDecimal)aggParam[2]);
            }
            bfTransIds.add(bfReserveId);
            if (!"3".equals(reservePrc)) continue;
            bfReplaceIds.add(bfReserveId);
        }
        log.info("\u8fd8\u539f\u9884\u8ba1\u5165\u6570\u91cf\u548c\u91ca\u653e\u4f59\u989d\u9501\u5e93\u91cf");
        String table = tb.getTb();
        String reserveSql = "update t_msmod_reserverecord set  f_base_qty = f_base_qty + ? ,f_qty = f_qty+ ? ,f_qty2nd = f_qty2nd + ? where fid = ?";
        String balSql = "update " + table + "_a  set flockbaseqty = flockbaseqty - ? ,flockqty = flockqty - ? ,flockqty2nd = flockqty2nd - ? where fid = ?";
        DBRoute scmRoute = tb.getDbRoute();
        ReserveTransHelper.updateReserveParams(bfTransIds, reserveParamsMap, scmRoute);
        ReserveTransHelper.executeBatchRecordSql(reserveParamsMap, reserveSql, scmRoute);
        ReserveTransHelper.executeBatchRecordSql(balParamsMap, balSql, scmRoute);
        if (ReserveAggregateHelper.isAggregateInit()) {
            String aggSql = "update t_msmod_reserveaggregate_a  set flockbaseqty = flockbaseqty - ? ,flockqty = flockqty - ? ,flockqty2nd = flockqty2nd - ? where fid = ?";
            ReserveTransHelper.executeBatchRecordSql(aggParamsMap, aggSql, scmRoute);
        }
        ReserveTransHelper.rollOldBalanceLockQty(reserveParamsMap, oldBalParamsMap, bfReplaceIds, scmRoute, table);
    }

    private static void updateReserveParams(Set<Long> bfTransIds, Map<Long, Object[]> reserveParamsMap, DBRoute scmRoute) {
        ConvRateContext convRate = new ConvRateContext();
        DataSet oldReserveRecords = QueryServiceHelper.queryDataSet((String)ReserveTransHelper.class.getName(), (String)"msmod_reserve_record", (String)"id,bal_entryid,bal_obj", (QFilter[])new QFilter("id", "in", bfTransIds).and(new QFilter("ispredict", "=", (Object)true)).toArray(), null);
        HashMap<Long, Long> oldBalIdsMap = new HashMap<Long, Long>(16);
        String formId = null;
        while (oldReserveRecords.hasNext()) {
            Row next = oldReserveRecords.next();
            if (formId == null) {
                formId = next.getString("bal_obj");
            }
            oldBalIdsMap.put(next.getLong("id"), next.getLong("bal_entryid"));
        }
        ColsMap colsMap = ColsMapHelper.findBillColMaps(formId, (String)"msmod_std_inv_field");
        if (oldBalIdsMap.isEmpty() || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)formId) || colsMap == null) {
            return;
        }
        Map colMap = colsMap.getBalColMap();
        StringBuilder sb = new StringBuilder();
        sb.append((String)colMap.get("materiel")).append(" as ").append("materiel");
        sb.append(" , ").append((String)colMap.get("baseunit")).append(" as ").append("baseunit");
        sb.append(" , ").append((String)colMap.get("unit")).append(" as ").append("unit");
        QFilter qFilter = new QFilter((String)colMap.get("billentry") + ".id", "in", oldBalIdsMap.values());
        String materiel = (String)colMap.get("materiel");
        if (materiel != null) {
            String[] materielArray = materiel.split("\\.");
            if (materielArray.length == 1) {
                sb.append(" , ").append("id").append(" as ").append("entryid");
                qFilter = new QFilter("id", "in", oldBalIdsMap.values());
            } else {
                sb.append(" , ").append((String)colMap.get("billentry")).append(".id").append(" as ").append("entryid");
            }
        }
        DataSet bal = QueryServiceHelper.queryDataSet((String)(ReserveTransHelper.class.getName() + ":updateReserveParams"), (String)formId, (String)sb.toString(), (QFilter[])qFilter.toArray(), null);
        HashMap entryUnitMap = new HashMap(16);
        bal.forEach(v -> {
            Long balEntryId = v.getLong("entryid");
            HashMap<String, Long> unitMap = new HashMap<String, Long>(16);
            unitMap.put("materiel", v.getLong("materiel"));
            unitMap.put("baseunit", v.getLong("baseunit"));
            unitMap.put("unit", v.getLong("unit"));
            entryUnitMap.put(balEntryId, unitMap);
        });
        for (Map.Entry<Long, Object[]> reserveParams : reserveParamsMap.entrySet()) {
            Long reserveId = reserveParams.getKey();
            Object[] objects = reserveParams.getValue();
            Map unitMap = (Map)entryUnitMap.get(oldBalIdsMap.get(reserveId));
            if (unitMap == null) continue;
            BigDecimal baseQty = (BigDecimal)objects[0];
            objects[1] = convRate.getSrcQty(baseQty, (Long)unitMap.get("materiel"), (Long)unitMap.get("unit"), (Long)unitMap.get("baseunit"));
        }
    }

    private static void rollOldBalanceLockQty(Map<Long, Object[]> reserveParamsMap, Map<Long, Object[]> oldBalParamsMap, Set<Long> bfReserveIds, DBRoute scmRoute, String table) {
        if (bfReserveIds.isEmpty()) {
            return;
        }
        HashMap<Long, Object[]> oldAggParamsMap = new HashMap<Long, Object[]>(16);
        DataSet oldReserveRecords = QueryServiceHelper.queryDataSet((String)ReserveTransHelper.class.getName(), (String)"msmod_reserve_record", (String)"id,bal_id,aggregateid", (QFilter[])new QFilter("id", "in", bfReserveIds).toArray(), null);
        while (oldReserveRecords.hasNext()) {
            Row next = oldReserveRecords.next();
            Long reserveId = next.getLong("id");
            Long balId = next.getLong("bal_id");
            Long aggId = next.getLong("aggregateid");
            Object[] reserveObj = reserveParamsMap.get(reserveId);
            if (reserveObj == null) continue;
            Object[] balObj = oldBalParamsMap.get(balId);
            if (balObj == null) {
                balObj = new Object[]{reserveObj[0], reserveObj[1], reserveObj[2], balId};
                oldBalParamsMap.put(balId, balObj);
            } else {
                balObj[0] = ((BigDecimal)balObj[0]).add((BigDecimal)reserveObj[0]);
                balObj[1] = ((BigDecimal)balObj[1]).add((BigDecimal)reserveObj[1]);
                balObj[2] = ((BigDecimal)balObj[2]).add((BigDecimal)reserveObj[2]);
            }
            Object[] aggObj = (Object[])oldAggParamsMap.get(aggId);
            if (aggObj == null) {
                aggObj = new Object[]{reserveObj[0], reserveObj[1], reserveObj[2], aggId};
                oldAggParamsMap.put(aggId, aggObj);
                continue;
            }
            aggObj[0] = ((BigDecimal)aggObj[0]).add((BigDecimal)reserveObj[0]);
            aggObj[1] = ((BigDecimal)aggObj[1]).add((BigDecimal)reserveObj[1]);
            aggObj[2] = ((BigDecimal)aggObj[2]).add((BigDecimal)reserveObj[2]);
        }
        String balSql = "update " + table + "_a  set flockbaseqty = flockbaseqty + ? ,flockqty = flockqty + ? ,flockqty2nd = flockqty2nd + ? where fid = ?";
        ReserveTransHelper.executeBatchRecordSql(oldBalParamsMap, balSql, scmRoute);
        if (ReserveAggregateHelper.isAggregateInit()) {
            String aggSql = "update  t_msmod_reserveaggregate_a  set flockbaseqty = flockbaseqty + ? ,flockqty = flockqty + ? ,flockqty2nd = flockqty2nd + ? where fid = ?";
            ReserveTransHelper.executeBatchRecordSql(oldAggParamsMap, aggSql, scmRoute);
        }
    }

    private static void executeBatchRecordSql(Map<Long, Object[]> paramsMap, String sql, DBRoute scmRoute) {
        if (paramsMap.isEmpty()) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(1024);
        for (Object[] reserveParam : paramsMap.values()) {
            if (params.size() > 1000) {
                ReserveTransHelper.executeMethod(sql, params, scmRoute);
                params.clear();
            }
            params.add(reserveParam);
        }
        log.info("sql :" + sql + "params:" + params);
        ReserveTransHelper.executeMethod(sql, params, scmRoute);
    }
}

