/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public abstract class TailDiffAdjust {
    private IFormView view;
    private Map<String, Object> customParams;

    public TailDiffAdjust(IFormView view, Map<String, Object> customParams) {
        this.view = view;
        this.customParams = customParams;
    }

    public void dealMeasureDeviAdjust() {
        List rows = (List)this.customParams.get("rows");
        if (rows.size() <= 0) {
            return;
        }
        IDataModel model = this.view.getModel();
        for (int i = 1; i < rows.size(); ++i) {
            model.insertEntryRow("billentry", i);
        }
        this.initMainOrg(rows);
        this.initBizData();
        this.initBizType();
        this.initInvScheme();
        this.initEntryData(rows);
    }

    protected void initBizData() {
        IDataModel model = this.view.getModel();
        String formId = model.getDataEntityType().getName();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        model.setValue("dept", null);
        model.setValue("bizdept", null);
        model.setValue("operator", null);
        model.setValue("operatorgroup", null);
        if ("im_otherinbill".equals(formId)) {
            model.setValue("supplier", null);
        } else {
            model.setValue("customer", null);
        }
    }

    protected void initMainOrg(List rows) {
        if (rows.isEmpty()) {
            return;
        }
        JSONObject rowJsonObject = (JSONObject)rows.get(0);
        if (rowJsonObject == null) {
            return;
        }
        Object org = rowJsonObject.get((Object)"org");
        this.view.getModel().setValue("org", org);
    }

    protected void initBizType() {
        String formId = this.view.getModel().getDataEntityType().getName();
        QFilter qFilter = "im_otherinbill".equals(formId) ? new QFilter("number", "=", (Object)"370") : new QFilter("number", "=", (Object)"380");
        DynamicObject bizType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_biztype", (String)"id,number", (QFilter[])qFilter.toArray());
        this.view.getModel().setValue("biztype", bizType.getPkValue());
    }

    protected abstract void initEntryData(List var1);

    protected void initInvScheme() {
        String formId = this.view.getModel().getDataEntityType().getName();
        QFilter qFilter = "im_otherinbill".equals(formId) ? new QFilter("number", "=", (Object)"354") : new QFilter("number", "=", (Object)"355");
        DynamicObject invScheme = BusinessDataServiceHelper.loadSingle((String)"im_invscheme", (String)"id", (QFilter[])qFilter.toArray());
        this.view.getModel().setValue("invscheme", invScheme.getPkValue());
    }
}

