/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.scmc.im.business.helper.TailDiffAdjust;

public class TailDiffAdjustBillHelper
extends TailDiffAdjust {
    private IFormView view;
    private Map<String, Object> customParams;

    public TailDiffAdjustBillHelper(IFormView view, Map<String, Object> customParams) {
        super(view, customParams);
        this.view = view;
        this.customParams = customParams;
    }

    @Override
    protected void initEntryData(List rows) {
        IDataModel model = this.view.getModel();
        Object mappingObj = this.customParams.get("colsmapping");
        if (mappingObj == null) {
            return;
        }
        DynamicObjectCollection entryCollection = model.getDataEntity().getDynamicObjectCollection("billentry");
        Map colsMapping = (Map)mappingObj;
        JSONArray dateKeySet = null;
        Object dateFields = this.customParams.get("dateFields");
        if (dateFields != null) {
            dateKeySet = (JSONArray)dateFields;
        }
        for (int i = 0; i < rows.size(); ++i) {
            JSONObject rowJsonObject = (JSONObject)rows.get(i);
            LinkedList<String> multiCategoryFields = new LinkedList<String>();
            for (Map.Entry colMapping : colsMapping.entrySet()) {
                String billKey = (String)colMapping.getKey();
                String repoKey = (String)colMapping.getValue();
                if (billKey == null) continue;
                if ("ownertype".equals(repoKey) || "keepertype".equals(repoKey)) {
                    multiCategoryFields.addFirst(billKey);
                    continue;
                }
                if ("owner".equals(repoKey) || "keeper".equals(repoKey)) {
                    multiCategoryFields.addLast(billKey);
                    continue;
                }
                Object value = rowJsonObject.get((Object)billKey);
                String tarBillKey = billKey;
                if (billKey.contains("billentry")) {
                    tarBillKey = billKey.substring(billKey.indexOf(".") + 1);
                }
                if (dateKeySet != null && dateKeySet.contains((Object)billKey) && entryCollection != null && entryCollection.get(i) != null) {
                    ((DynamicObject)entryCollection.get(i)).set(tarBillKey, (Object)rowJsonObject.getDate(billKey));
                    continue;
                }
                model.setValue(tarBillKey, value, i);
            }
            for (String billKey : multiCategoryFields) {
                Object value = rowJsonObject.get((Object)billKey);
                if (billKey.contains("billentry")) {
                    billKey = billKey.substring(billKey.indexOf(".") + 1);
                }
                model.setValue(billKey, value, i);
            }
        }
    }

    @Override
    protected void initMainOrg(List rows) {
        if (rows.isEmpty()) {
            return;
        }
        JSONObject rowJsonObject = (JSONObject)rows.get(0);
        if (rowJsonObject == null) {
            return;
        }
        Object org = rowJsonObject.get((Object)"org");
        this.view.getModel().setValue("org", org);
    }
}

