/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.helper.BizGroupRecordHelper;
import kd.scmc.im.business.helper.BotpPushHepler;

public class TransInIsOverHelper {
    private static Log logger = LogFactory.getLog(TransInIsOverHelper.class);

    public static Map<Object, Boolean> updateIsOverTrans(Set<Long> mainBillIds, Set<Long> inBillIds) {
        if (mainBillIds == null || mainBillIds.isEmpty()) {
            return new HashMap<Object, Boolean>(16);
        }
        HashSet<Object> rowCloseIds = new HashSet<Object>(16);
        HashSet<Object> rowUnCloseIds = new HashSet<Object>(16);
        DynamicObjectCollection transBills = QueryServiceHelper.query((String)"im_transapply", (String)"billentry.id as entryid,billentry.baseqty as baseqty,billentry.transinbaseqty as transinbaseqty,billentry.transratedown as transratedown,billentry.transrateup as transrateup", (QFilter[])new QFilter("id", "in", mainBillIds).toArray());
        for (DynamicObject srcActiveRow : transBills) {
            boolean isOvertrans;
            BigDecimal baseqty = srcActiveRow.getBigDecimal("baseqty");
            BigDecimal transinbaseqty = srcActiveRow.getBigDecimal("transinbaseqty");
            BigDecimal transratedown = srcActiveRow.getBigDecimal("transratedown").divide(new BigDecimal(100));
            BigDecimal transrateup = srcActiveRow.getBigDecimal("transrateup").divide(new BigDecimal(100));
            int compareTo = transinbaseqty.compareTo(baseqty.multiply(new BigDecimal(1).add(transrateup)));
            int compareTo1 = transinbaseqty.compareTo(baseqty.multiply(new BigDecimal(1).subtract(transratedown)));
            boolean bl = isOvertrans = compareTo <= 0 && compareTo1 >= 0;
            if (isOvertrans) {
                rowCloseIds.add(srcActiveRow.getLong("entryid"));
                continue;
            }
            rowUnCloseIds.add(srcActiveRow.getLong("entryid"));
        }
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"im_transapply", (Long[])mainBillIds.toArray(new Long[mainBillIds.size()]));
        Set inIds = (Set)targetBills.get("im_transinbill");
        return TransInIsOverHelper.upOverTransBill(rowCloseIds, rowUnCloseIds, inBillIds, inIds);
    }

    private static Map<Object, Boolean> upOverTransBill(Set<Object> rowCloseIds, Set<Object> rowUnCloseIds, Set<Long> inBillIds, Set<Long> inIds) {
        HashMap<Object, Boolean> overTransMap = new HashMap<Object, Boolean>(16);
        HashSet<Object> rowIds = new HashSet<Object>(16);
        rowIds.addAll(rowCloseIds);
        rowIds.addAll(rowUnCloseIds);
        if (rowIds.isEmpty()) {
            return overTransMap;
        }
        HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>();
        QFilter invSchemeFilter = TransInIsOverHelper.getTransInInvScheme();
        if (inIds != null && !inIds.isEmpty()) {
            invSchemeFilter.and("id", "in", inIds);
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"im_transinbill", (String)"id,billstatus,auditdate,billentry.mainbillentryid,billentry.isovertrans", (QFilter[])invSchemeFilter.and(new QFilter("billentry.mainbillentryid", "in", rowIds)).toArray());
        HashSet<Long> falseEntryIds = new HashSet<Long>(16);
        HashSet<Long> trueEntryIds = new HashSet<Long>(16);
        HashSet<Long> transInBillIds = new HashSet<Long>(16);
        for (DynamicObject data : load) {
            DynamicObjectCollection billEntry = data.getDynamicObjectCollection("billentry");
            transInBillIds.add((Long)data.getPkValue());
            for (DynamicObject entry : billEntry) {
                entry.set("isovertrans", (Object)false);
                Object mainId = entry.get("mainbillentryid");
                overTransMap.put(entry.getPkValue(), false);
                if (rowUnCloseIds.contains(mainId)) {
                    entry.set("isovertrans", (Object)false);
                    if (!inIds.contains((Long)data.getPkValue())) continue;
                    falseEntryIds.add((Long)entry.getPkValue());
                    continue;
                }
                if (!rowCloseIds.contains(mainId)) continue;
                TransInIsOverHelper.buildTransInEntryIds(entryMap, trueEntryIds, entry, inIds, data);
            }
        }
        for (DynamicObject entry : entryMap.values()) {
            entry.set("isovertrans", (Object)true);
            overTransMap.put(entry.getPkValue(), true);
        }
        SaveServiceHelper.save((DynamicObject[])load);
        logger.info("kd.scmc.im.business.helper.TransInIsOverHelper.upOverTransBill \u8c03\u7528\u6838\u7b97\u6210\u7ec4\u5173\u7cfb\u63a5\u53e3\u53c2\u6570:true: " + trueEntryIds + "false: " + falseEntryIds);
        if (BizGroupRecordHelper.isBizGroupModel()) {
            BizGroupRecordHelper.setBizGroupCompleted(transInBillIds, trueEntryIds, falseEntryIds);
        } else {
            CommonParam commonParam = new CommonParam();
            commonParam.put((Object)"id", transInBillIds);
            commonParam.put((Object)"trueentryid", trueEntryIds);
            commonParam.put((Object)"falseentryid", falseEntryIds);
            ECServiceHelper.execute((String)"im_transinbill_overtrans", (String)"overTrans", (String)"fi", (String)"cal", (String)"CalGroupCompletedBatchDoService", (Param)commonParam);
        }
        return overTransMap;
    }

    private static void buildTransInEntryIds(Map<Long, DynamicObject> entryMap, Set<Long> trueEntryIds, DynamicObject entry, Set<Long> inBillIds, DynamicObject data) {
        Long mainBillEntryId = entry.getLong("mainbillentryid");
        DynamicObject parent = (DynamicObject)entry.getParent();
        Date auditdate = parent.getDate("auditdate");
        if (!entryMap.containsKey(mainBillEntryId)) {
            entryMap.put(mainBillEntryId, entry);
            trueEntryIds.add((Long)entry.getPkValue());
            return;
        }
        DynamicObject oldEntry = entryMap.get(mainBillEntryId);
        DynamicObject oldParent = (DynamicObject)oldEntry.getParent();
        Date oldDate = oldParent.getDate("auditdate");
        if (oldDate == null || auditdate == null) {
            return;
        }
        if (auditdate.compareTo(oldDate) > 0) {
            entryMap.put(mainBillEntryId, entry);
            if (inBillIds.contains((Long)data.getPkValue())) {
                trueEntryIds.remove((Long)oldEntry.getPkValue());
                trueEntryIds.add((Long)entry.getPkValue());
            }
        }
    }

    public static Map<Object, Boolean> updateIsOver4TransOut(String srcEntity, Set<Long> notMainIds, Set<Long> inBillIds, boolean isFromInBill) {
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)srcEntity, (Long[])notMainIds.toArray(new Long[notMainIds.size()]));
        HashSet srcIds = (HashSet)sourceBills.get("im_transoutbill");
        HashSet srcInIds = (HashSet)sourceBills.get("im_transinbill");
        if (null != srcInIds && !srcInIds.isEmpty()) {
            inBillIds.addAll(srcInIds);
        }
        logger.info("kd.scmc.im.business.helper.TransInIsOverHelper.updateIsOver4TransOut: srcIds:" + srcIds + ";srcInIds:" + srcInIds);
        if (srcIds == null || srcIds.isEmpty()) {
            return new HashMap<Object, Boolean>(16);
        }
        HashSet<Long> rowCloseIds = new HashSet<Long>(16);
        HashSet<Long> rowUnCloseIds = new HashSet<Long>(16);
        DynamicObjectCollection transOutBills = QueryServiceHelper.query((String)"im_transoutbill", (String)"id, billentry.id as entryid,billentry.baseqty as baseqty", (QFilter[])new QFilter("id", "in", (Object)srcIds).toArray());
        Map<Long, BigDecimal> inBillBaseQtyMap = TransInIsOverHelper.getTransInBillBaseQtyMap(transOutBills);
        for (DynamicObject srcActiveRow : transOutBills) {
            Long entryId = srcActiveRow.getLong("entryid");
            BigDecimal baseQty = srcActiveRow.getBigDecimal("baseqty");
            BigDecimal inBillCountBaseQty = inBillBaseQtyMap.getOrDefault(entryId, BigDecimal.ZERO);
            if (inBillCountBaseQty.compareTo(baseQty) >= 0) {
                rowCloseIds.add(entryId);
                continue;
            }
            rowUnCloseIds.add(entryId);
        }
        logger.info("kd.scmc.im.business.helper.TransInIsOverHelper.updateIsOver4TransOut:\u5206\u6b65\u8c03\u51fa\u5355\u5206\u5f55rowCloseIds = " + rowCloseIds + " ;rowUnCloseIds = " + rowUnCloseIds + " ;inBillIds" + inBillIds);
        return TransInIsOverHelper.upOverTrans4OutBill(rowCloseIds, rowUnCloseIds, srcIds, inBillIds, isFromInBill);
    }

    private static Map<Long, BigDecimal> getTransInBillBaseQtyMap(DynamicObjectCollection transOutBills) {
        ArrayList<Long> transOutEntryIds = new ArrayList<Long>(16);
        HashSet<Long> transOutIds = new HashSet<Long>(16);
        for (DynamicObject srcActiveRow : transOutBills) {
            Long id = srcActiveRow.getLong("id");
            Long l = srcActiveRow.getLong("entryid");
            transOutIds.add(id);
            transOutEntryIds.add(l);
        }
        Map<Long, List<Long>> transInEntryIdsMap = BotpPushHepler.getTrackDownEntryIdsMap("im_transoutbill", "billentry", transOutIds, transOutEntryIds, "im_transinbill", "billentry");
        ArrayList<Long> transInIds = new ArrayList<Long>(16);
        for (List list : transInEntryIdsMap.values()) {
            if (list == null || list.isEmpty()) continue;
            transInIds.addAll(list);
        }
        Map targetInBills = BFTrackerServiceHelper.findTargetBills((String)"im_transoutbill", (Long[])transOutIds.toArray(new Long[transOutIds.size()]));
        Set set = (Set)targetInBills.get("im_transinbill");
        if (set == null || set.isEmpty()) {
            return new HashMap<Long, BigDecimal>(16);
        }
        QFilter caFilter = new QFilter("id", "in", (Object)set);
        caFilter.and("billentry.srcbillentryid", "in", transInIds);
        caFilter.and("billstatus", "=", (Object)"C");
        caFilter.and("ischargeoff", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection writeOffTransInBills = QueryServiceHelper.query((String)"im_transinbill", (String)"billentry.id as entryid,billentry.srcbillentryid as srcbillentryid", (QFilter[])caFilter.toArray());
        for (DynamicObject writeOffTransInBill : writeOffTransInBills) {
            Long entryId = writeOffTransInBill.getLong("entryid");
            Long srcBillEntryId = writeOffTransInBill.getLong("srcbillentryid");
            Long outBillEntryId = TransInIsOverHelper.getOutBillEntryId(transInEntryIdsMap, srcBillEntryId);
            List<Long> downInEntryIds = transInEntryIdsMap.get(outBillEntryId);
            if (downInEntryIds == null || downInEntryIds.contains(entryId)) continue;
            downInEntryIds.add(entryId);
        }
        transInIds.clear();
        for (List<Long> ids : transInEntryIdsMap.values()) {
            if (ids == null || ids.isEmpty()) continue;
            transInIds.addAll(ids);
        }
        QFilter filter = new QFilter("id", "in", (Object)set);
        filter.and("billentry.id", "in", transInIds);
        filter.and("billstatus", "=", (Object)"C");
        DynamicObjectCollection transInBills = QueryServiceHelper.query((String)"im_transinbill", (String)"billentry.id as entryid,billentry.baseqty as baseqty", (QFilter[])filter.toArray());
        HashMap<Long, BigDecimal> transInBaseQtyMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject transInBill : transInBills) {
            Long entryId = transInBill.getLong("entryid");
            BigDecimal baseQty = transInBill.getBigDecimal("baseqty");
            transInBaseQtyMap.put(entryId, baseQty == null ? BigDecimal.ZERO : baseQty);
        }
        HashMap<Long, BigDecimal> outBillForInBillQtyMap = new HashMap<Long, BigDecimal>(16);
        for (Map.Entry<Long, List<Long>> entry : transInEntryIdsMap.entrySet()) {
            Long outEntryId = entry.getKey();
            List<Long> inEntryIds = entry.getValue();
            if (inEntryIds == null || inEntryIds.isEmpty()) continue;
            BigDecimal inBillBaseQty = BigDecimal.ZERO;
            for (Long inEntryId : inEntryIds) {
                inBillBaseQty = inBillBaseQty.add(transInBaseQtyMap.getOrDefault(inEntryId, BigDecimal.ZERO));
            }
            outBillForInBillQtyMap.put(outEntryId, inBillBaseQty);
        }
        return outBillForInBillQtyMap;
    }

    private static Long getOutBillEntryId(Map<Long, List<Long>> transInEntryIdsMap, Long srcBillEntryId) {
        for (Map.Entry<Long, List<Long>> entry : transInEntryIdsMap.entrySet()) {
            List<Long> value = entry.getValue();
            if (value == null || !value.contains(srcBillEntryId)) continue;
            return entry.getKey();
        }
        return 0L;
    }

    private static Map<Object, Boolean> upOverTrans4OutBill(Set<Long> rowCloseIds, Set<Long> rowUnCloseIds, Set<Long> outBillIds, Set<Long> inBillIds, boolean isFromInBill) {
        Set transInIds;
        Map<Long, Long> closeEntryIdMap = BotpPushHepler.getTrackDownBillMap("im_transoutbill", "billentry", outBillIds, rowCloseIds, "im_transinbill", "billentry");
        Map<Long, Long> unCloseEntryIdMap = BotpPushHepler.getTrackDownBillMap("im_transoutbill", "billentry", outBillIds, rowUnCloseIds, "im_transinbill", "billentry");
        logger.info("kd.scmc.im.business.helper.TransInIsOverHelper.upOverTrans4OutBill: closeEntryIdMap = " + closeEntryIdMap + " ;unCloseEntryIdMap" + unCloseEntryIdMap);
        HashMap<Object, Boolean> overTransMap = new HashMap<Object, Boolean>(16);
        HashSet<Long> rowEntryIds = new HashSet<Long>(16);
        rowEntryIds.addAll(closeEntryIdMap.keySet());
        rowEntryIds.addAll(unCloseEntryIdMap.keySet());
        if (rowEntryIds.isEmpty()) {
            return overTransMap;
        }
        HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>();
        QFilter schemeFilter = TransInIsOverHelper.getTransInInvScheme();
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"im_transoutbill", (Long[])outBillIds.toArray(new Long[outBillIds.size()]));
        HashSet<Long> inIds = new HashSet<Long>(16);
        if (targetBills != null && (transInIds = (Set)targetBills.get("im_transinbill")) != null) {
            inIds.addAll(transInIds);
            schemeFilter.and("id", "in", (Object)transInIds);
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"im_transinbill", (String)"id,billstatus,auditdate,billentry.mainbillentryid,billentry.isovertrans", (QFilter[])schemeFilter.and(new QFilter("billentry.id", "in", rowEntryIds)).toArray());
        HashSet<Long> falseEntryIds = new HashSet<Long>(16);
        HashSet<Long> trueEntryIds = new HashSet<Long>(16);
        HashSet<Long> transInBillIds = new HashSet<Long>(16);
        for (DynamicObject data : load) {
            Long billId = (Long)data.getPkValue();
            transInBillIds.add(billId);
            DynamicObjectCollection billEntry = data.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billEntry) {
                Long entryId = (Long)entry.getPkValue();
                overTransMap.put(entryId, false);
                entry.set("isovertrans", (Object)false);
                if (unCloseEntryIdMap.containsKey(entryId)) {
                    if (isFromInBill && !inIds.contains(billId)) continue;
                    falseEntryIds.add(entryId);
                    continue;
                }
                if (!closeEntryIdMap.containsKey(entryId)) continue;
                TransInIsOverHelper.buildTransInNotMain(entryMap, trueEntryIds, entry, closeEntryIdMap, inIds, billId, isFromInBill);
            }
        }
        for (DynamicObject entry : entryMap.values()) {
            entry.set("isovertrans", (Object)true);
            overTransMap.put(entry.getPkValue(), true);
        }
        SaveServiceHelper.save((DynamicObject[])load);
        logger.info("kd.scmc.im.business.helper.TransInIsOverHelper.upOverTrans4OutBill: overTransMap = " + overTransMap + ";\u8c03\u7528\u6838\u7b97\u6210\u7ec4\u5173\u7cfb\u63a5\u53e3\u53c2\u6570:true: " + trueEntryIds + "false: " + falseEntryIds);
        if (BizGroupRecordHelper.isBizGroupModel()) {
            BizGroupRecordHelper.setBizGroupCompleted(transInBillIds, trueEntryIds, falseEntryIds);
        } else {
            CommonParam commonParam = new CommonParam();
            commonParam.put((Object)"id", transInBillIds);
            commonParam.put((Object)"trueentryid", trueEntryIds);
            commonParam.put((Object)"falseentryid", falseEntryIds);
            ECServiceHelper.execute((String)"im_transinbill_overtrans", (String)"overTrans", (String)"fi", (String)"cal", (String)"CalGroupCompletedBatchDoService", (Param)commonParam);
        }
        return overTransMap;
    }

    public static QFilter getTransInInvScheme() {
        QFilter billFilter = new QFilter("billform", "=", (Object)"im_transinbill");
        Map transceiverTypes = BusinessDataServiceHelper.loadFromCache((String)"bd_transceivertype", (String)"id", (QFilter[])new QFilter("bizdirection", "=", (Object)"0").toArray());
        Map invSchemes = BusinessDataServiceHelper.loadFromCache((String)"im_invscheme", (String)"id", (QFilter[])billFilter.and(new QFilter("transceivertype", "in", transceiverTypes.keySet())).toArray());
        return new QFilter("invscheme", "in", invSchemes.keySet());
    }

    private static void buildTransInNotMain(Map<Long, DynamicObject> entryMap, Set<Long> trueEntryIds, DynamicObject entry, Map<Long, Long> closeEntryIdMap, Set<Long> inBillIds, Long billId, boolean isFromInBill) {
        DynamicObject oldEntry;
        DynamicObject oldParent;
        Date oldDate;
        Long entryId = (Long)entry.getPkValue();
        Long srcEntryId = closeEntryIdMap.get(entryId);
        DynamicObject parent = (DynamicObject)entry.getParent();
        Date auditdate = parent.getDate("auditdate");
        if (!entryMap.containsKey(srcEntryId)) {
            entryMap.put(srcEntryId, entry);
            if (!isFromInBill || inBillIds.contains(billId)) {
                trueEntryIds.add((Long)entry.getPkValue());
                return;
            }
        }
        if ((oldDate = (oldParent = (DynamicObject)(oldEntry = entryMap.get(srcEntryId)).getParent()).getDate("auditdate")) == null || auditdate == null) {
            return;
        }
        if (auditdate.compareTo(oldDate) > 0) {
            entryMap.put(srcEntryId, entry);
            if (!isFromInBill || inBillIds.contains(billId)) {
                trueEntryIds.remove((Long)oldEntry.getPkValue());
                trueEntryIds.add((Long)entry.getPkValue());
            }
        }
    }

    @Deprecated
    public static void updateTransOver4InBills(DynamicObject[] entities, String op) {
        HashSet<Long> mainBillIds = new HashSet<Long>(16);
        HashSet<Long> notMainIds = new HashSet<Long>(16);
        HashSet<Long> inBillIds = new HashSet<Long>(32);
        for (DynamicObject data : entities) {
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("billentry");
            boolean isChargeOff = data.getBoolean("ischargeoff");
            for (DynamicObject entry : entrys) {
                if (!isChargeOff && "audit".equals(op) && entry.getBoolean("isovertrans")) continue;
                String mainFormId = entry.getString("mainbillentity");
                if ("im_transapply".equals(mainFormId)) {
                    mainBillIds.add(entry.getLong("mainbillid"));
                } else {
                    notMainIds.add((Long)data.getPkValue());
                }
                inBillIds.add((Long)data.getPkValue());
            }
        }
        Map<Object, Boolean> entryOverTransMap = TransInIsOverHelper.updateIsOverTrans(mainBillIds, inBillIds);
        logger.info("kd/scmc/im/business/helper/TransInIsOverHelper.updateTransOver4InBills: mainBillIds : " + mainBillIds + ";notMainIds" + notMainIds + ";inBillIds : " + inBillIds + ";entryOverTransMap" + entryOverTransMap);
        entryOverTransMap.putAll(TransInIsOverHelper.updateIsOver4TransOut("im_transinbill", notMainIds, inBillIds, true));
        for (DynamicObject data : entities) {
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                Boolean isOver = entryOverTransMap.get(entry.getPkValue());
                if (isOver == null) continue;
                entry.set("isovertrans", (Object)isOver);
            }
        }
    }

    public static void updateTransOver4InBills(DataSet datas, String op) {
        HashSet<Long> mainBillIds = new HashSet<Long>(16);
        HashSet<Long> notMainIds = new HashSet<Long>(16);
        HashSet<Long> inBillIds = new HashSet<Long>(32);
        while (datas.hasNext()) {
            Row row = datas.next();
            boolean isChargeOff = row.getBoolean("ischargeoff");
            boolean isOverTrans = row.getBoolean("billentry.isovertrans");
            if (!isChargeOff && "audit".equals(op) && isOverTrans) continue;
            String mainFormId = row.getString("billentry.mainbillentity");
            if ("im_transapply".equals(mainFormId)) {
                mainBillIds.add(row.getLong("billentry.mainbillid"));
            } else {
                notMainIds.add(row.getLong("id"));
            }
            inBillIds.add(row.getLong("id"));
        }
        Map<Object, Boolean> entryOverTransMap = TransInIsOverHelper.updateIsOverTrans(mainBillIds, inBillIds);
        logger.info("kd/scmc/im/business/helper/TransInIsOverHelper.updateTransOver4InBills: mainBillIds : " + mainBillIds + ";notMainIds" + notMainIds + ";inBillIds : " + inBillIds + ";entryOverTransMap" + entryOverTransMap);
        entryOverTransMap.putAll(TransInIsOverHelper.updateIsOver4TransOut("im_transinbill", notMainIds, inBillIds, true));
    }

    public static void updateTransOver4OutBills(DynamicObject[] entities) {
        HashSet<Long> notMainIds = new HashSet<Long>(16);
        for (DynamicObject data : entities) {
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                String mainFormId = entry.getString("mainbillentity");
                if ("im_transapply".equals(mainFormId)) continue;
                notMainIds.add((Long)data.getPkValue());
            }
        }
        Map<Object, Boolean> entryOverTransMap = TransInIsOverHelper.updateIsOver4TransOut("im_transoutbill", notMainIds, new HashSet<Long>(4), false);
        for (DynamicObject data : entities) {
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                Boolean isOver = entryOverTransMap.get(entry.getPkValue());
                if (isOver == null) continue;
                entry.set("isovertrans", (Object)isOver);
            }
        }
    }
}

