/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.business.helper.datactrl.InvBizDataCtrlHelper;
import kd.scmc.im.business.helper.datactrl.WarehouseIsolateResultHandle;

public class WareHouseIsolateHelper {
    private static final String OUT_WAREHOUSE = "billentry.outwarehouse";
    private static final String IN_WAREHOUSE = "billentry.inwarehouse";
    private static final String WAREHOUSE = "billentry.warehouse";

    @Deprecated
    public static void setWareHoseFilter(SetFilterEvent e, List<Long> orgIds, String billFormId) {
        QFilter filter;
        if (e.getMainOrgQFilter() == null) {
            orgIds = WareHouseIsolateHelper.buildOrgIds(billFormId);
        }
        if ((filter = WareHouseIsolateHelper.getWareHouseFilter(orgIds, billFormId)) == null) {
            return;
        }
        e.getQFilters().add(filter);
    }

    @Deprecated
    public static void setWareHoseFilter(String appId, SetFilterEvent e, List<Long> orgIds, String billFormId) {
        QFilter filter;
        if (e.getMainOrgQFilter() == null) {
            orgIds = WareHouseIsolateHelper.buildOrgIds(billFormId, appId);
        }
        if ((filter = WareHouseIsolateHelper.getWareHouseFilter(orgIds, billFormId)) == null) {
            return;
        }
        e.getQFilters().add(filter);
    }

    public static void setWareHoseFilterByDataCtrl(String appId, SetFilterEvent e, List<Long> orgIds, String billFormId) {
        QFilter filter;
        if (e.getMainOrgQFilter() == null) {
            orgIds = NewInvOrgHelper.getPermissionOrgListByUserId(billFormId, appId);
        }
        if ((filter = WareHouseIsolateHelper.getWareHouseFilterByDataCtrl(orgIds, billFormId)) == null) {
            return;
        }
        e.getQFilters().add(filter);
    }

    @Deprecated
    public static QFilter getWareHoseFilter(List<Long> orgIds, String billFormId) {
        if (orgIds == null) {
            orgIds = WareHouseIsolateHelper.buildOrgIds(billFormId);
        }
        return WareHouseIsolateHelper.getWareHouseFilter(orgIds, billFormId);
    }

    public static QFilter getWareHoseFilter(String appId, List<Long> orgIds, String billFormId) {
        if (orgIds == null) {
            orgIds = WareHouseIsolateHelper.buildOrgIds(billFormId, appId);
        }
        return WareHouseIsolateHelper.getWareHouseFilter(orgIds, billFormId);
    }

    private static QFilter getWareHouseFilter(List<Long> orgIds, String billFormId) {
        long userId = UserServiceHelper.getCurrentUserId();
        ArrayList<Long> isolatedOrgList = new ArrayList<Long>(16);
        ArrayList<Long> notIsolatedOrgList = new ArrayList<Long>(16);
        WareHouseIsolateHelper.buildIsolateList(orgIds, isolatedOrgList, notIsolatedOrgList);
        if (CollectionUtils.isEmpty(isolatedOrgList)) {
            return null;
        }
        List<DynamicObject> isolatedWareHouses = WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId(userId, isolatedOrgList);
        if (CollectionUtils.isEmpty(isolatedWareHouses)) {
            return null;
        }
        ArrayList<Long> isolatedWHIds = new ArrayList<Long>(isolatedWareHouses.size());
        for (DynamicObject wareHose : isolatedWareHouses) {
            Long wareHosePkValue = (Long)wareHose.getPkValue();
            isolatedWHIds.add(wareHosePkValue);
        }
        if (billFormId.equals("im_transdirbill")) {
            QFilter filter1 = new QFilter("billentry", "=", null).or("outorg", "in", notIsolatedOrgList).or("org", "in", notIsolatedOrgList);
            QFilter filter2 = new QFilter(OUT_WAREHOUSE, "=", (Object)0).and(WAREHOUSE, "=", (Object)0);
            QFilter filter3 = new QFilter("outorg", "in", isolatedOrgList).and(OUT_WAREHOUSE, "in", isolatedWHIds);
            QFilter filter4 = new QFilter("org", "in", isolatedOrgList).and(WAREHOUSE, "in", isolatedWHIds);
            return filter1.or(filter2).or(filter3).or(filter4);
        }
        if ("im_transoutbill".equals(billFormId)) {
            return WareHouseIsolateHelper.buildTransOutWarehouseQfilter(isolatedOrgList, notIsolatedOrgList, isolatedWHIds);
        }
        if ("im_transinbill".equals(billFormId)) {
            return WareHouseIsolateHelper.buildTransInWarehouseQfilter(isolatedOrgList, notIsolatedOrgList, isolatedWHIds);
        }
        if ("im_purinbill".equals(billFormId) || "im_invinspectbill".equals(billFormId)) {
            return WareHouseIsolateHelper.buildPurWarehouseQfilter(isolatedOrgList, notIsolatedOrgList, isolatedWHIds);
        }
        if ("im_saloutbill".equals(billFormId)) {
            return WareHouseIsolateHelper.buildSalWarehouseQfilter(isolatedOrgList, notIsolatedOrgList, isolatedWHIds);
        }
        if ("im_mdc_ominbill".equals(billFormId) || "im_mdc_omcmplinbill".equals(billFormId)) {
            return WareHouseIsolateHelper.buildMdcWarehouseQfilter(isolatedOrgList, notIsolatedOrgList, isolatedWHIds);
        }
        QFilter filter = new QFilter("org", "in", notIsolatedOrgList).or("billentry", "=", null);
        QFilter qFilter1 = new QFilter(WAREHOUSE, "in", isolatedWHIds).or(WAREHOUSE, "=", (Object)0);
        QFilter qFilter2 = new QFilter("org", "in", isolatedOrgList);
        QFilter qFilter3 = qFilter1.and(qFilter2);
        filter.or(qFilter3);
        return filter;
    }

    private static QFilter getWareHouseFilterByDataCtrl(List<Long> orgIds, String billFormId) {
        ArrayList<Long> isolatedOrgList = new ArrayList<Long>(16);
        ArrayList<Long> notIsolatedOrgList = new ArrayList<Long>(16);
        WareHouseIsolateHelper.buildIsolateList(orgIds, isolatedOrgList, notIsolatedOrgList);
        if (CollectionUtils.isEmpty(isolatedOrgList)) {
            return null;
        }
        ArrayList<Long> isolatedWHIds = new ArrayList<Long>();
        String ctrlField = "warehouse";
        for (Long isolatedOrg : isolatedOrgList) {
            Set<Long> isolatedWHIdSet = InvBizDataCtrlHelper.buildLimitHelper(new WarehouseIsolateResultHandle()).getDataByUser(Collections.singletonList(isolatedOrg), billFormId, ctrlField);
            if (CollectionUtils.isEmpty(isolatedWHIdSet)) {
                notIsolatedOrgList.add(isolatedOrg);
                continue;
            }
            isolatedWHIds.addAll(isolatedWHIdSet);
        }
        if (isolatedWHIds.isEmpty()) {
            isolatedWHIds.add(0L);
        }
        if (billFormId.equals("im_transdirbill")) {
            QFilter filter1 = new QFilter("billentry", "=", null).or("outorg", "in", notIsolatedOrgList).or("org", "in", notIsolatedOrgList);
            QFilter filter2 = new QFilter("outorg", "in", isolatedOrgList).and(OUT_WAREHOUSE, "in", isolatedWHIds);
            QFilter filter3 = new QFilter("org", "in", isolatedOrgList).and(WAREHOUSE, "in", isolatedWHIds);
            return filter1.or(filter2).or(filter3);
        }
        if ("im_transoutbill".equals(billFormId)) {
            return WareHouseIsolateHelper.buildTransOutWarehouseQfilter(isolatedOrgList, notIsolatedOrgList, isolatedWHIds);
        }
        if ("im_transinbill".equals(billFormId)) {
            return WareHouseIsolateHelper.buildTransInWarehouseQfilter(isolatedOrgList, notIsolatedOrgList, isolatedWHIds);
        }
        if ("im_invinspectbill".equals(billFormId)) {
            return WareHouseIsolateHelper.buildInspectWarehouseQFilter(isolatedOrgList, notIsolatedOrgList, isolatedWHIds);
        }
        if ("im_purinbill".equals(billFormId)) {
            return WareHouseIsolateHelper.buildPurWarehouseQfilter(isolatedOrgList, notIsolatedOrgList, isolatedWHIds);
        }
        if ("im_saloutbill".equals(billFormId)) {
            return WareHouseIsolateHelper.buildSalWarehouseQfilter(isolatedOrgList, notIsolatedOrgList, isolatedWHIds);
        }
        if ("im_mdc_ominbill".equals(billFormId) || "im_mdc_omcmplinbill".equals(billFormId)) {
            return WareHouseIsolateHelper.buildMdcWarehouseQfilter(isolatedOrgList, notIsolatedOrgList, isolatedWHIds);
        }
        QFilter filter = new QFilter("org", "in", notIsolatedOrgList).or("billentry", "=", null);
        QFilter qFilter1 = new QFilter(WAREHOUSE, "in", isolatedWHIds);
        QFilter qFilter2 = new QFilter("org", "in", isolatedOrgList);
        QFilter qFilter3 = qFilter1.and(qFilter2);
        filter.or(qFilter3);
        return filter;
    }

    private static QFilter buildMdcWarehouseQfilter(List<Long> isolatedOrgList, List<Long> notIsolatedOrgList, List<Long> isolatedWHIds) {
        QFilter filter = new QFilter("org", "in", notIsolatedOrgList).or("billentry", "=", null);
        QFilter qFilter1 = new QFilter(WAREHOUSE, "in", isolatedWHIds).or(WAREHOUSE, "=", (Object)0).or(OUT_WAREHOUSE, "in", isolatedWHIds).or(OUT_WAREHOUSE, "=", (Object)0);
        QFilter qFilter2 = new QFilter("org", "in", isolatedOrgList);
        QFilter qFilter3 = qFilter1.and(qFilter2);
        filter.or(qFilter3);
        return filter;
    }

    private static QFilter buildSalWarehouseQfilter(List<Long> isolatedOrgList, List<Long> notIsolatedOrgList, List<Long> isolatedWHIds) {
        QFilter filter = new QFilter("org", "in", notIsolatedOrgList).or("billentry", "=", null);
        QFilter qFilter1 = new QFilter(WAREHOUSE, "in", isolatedWHIds).or(WAREHOUSE, "=", (Object)0).or(IN_WAREHOUSE, "in", isolatedWHIds);
        QFilter qFilter2 = new QFilter("org", "in", isolatedOrgList);
        QFilter qFilter3 = qFilter1.and(qFilter2);
        filter.or(qFilter3);
        return filter;
    }

    private static QFilter buildPurWarehouseQfilter(List<Long> isolatedOrgList, List<Long> notIsolatedOrgList, List<Long> isolatedWHIds) {
        QFilter filter = new QFilter("org", "in", notIsolatedOrgList).or("billentry", "=", null);
        QFilter qFilter1 = new QFilter(WAREHOUSE, "in", isolatedWHIds).or(WAREHOUSE, "=", (Object)0).or(OUT_WAREHOUSE, "in", isolatedWHIds);
        QFilter qFilter2 = new QFilter("org", "in", isolatedOrgList);
        QFilter qFilter3 = qFilter1.and(qFilter2);
        filter.or(qFilter3);
        return filter;
    }

    private static QFilter buildInspectWarehouseQFilter(List<Long> isolatedOrgList, List<Long> notIsolatedOrgList, List<Long> isolatedWHIds) {
        QFilter filter = new QFilter("org", "in", notIsolatedOrgList).or("billentry", "=", null);
        QFilter qFilter1 = new QFilter(WAREHOUSE, "in", isolatedWHIds).or(OUT_WAREHOUSE, "in", isolatedWHIds).or("billentry.qualifiedwarehouse", "in", isolatedWHIds).or("billentry.unqualifiedwarehouse", "in", isolatedWHIds);
        QFilter qFilter2 = new QFilter("org", "in", isolatedOrgList);
        QFilter qFilter3 = qFilter1.and(qFilter2);
        filter.or(qFilter3);
        return filter;
    }

    private static QFilter buildTransInWarehouseQfilter(List<Long> isolatedOrgList, List<Long> notIsolatedOrgList, List<Long> isolatedWHIds) {
        QFilter filterOne = new QFilter("billentry", "=", null).or("org", "in", notIsolatedOrgList).or("outorg", "in", notIsolatedOrgList);
        QFilter filterTwo = new QFilter(WAREHOUSE, "=", (Object)0).and(OUT_WAREHOUSE, "=", (Object)0);
        QFilter filterThree = new QFilter("org", "in", isolatedOrgList).and(WAREHOUSE, "in", isolatedWHIds);
        QFilter filterFour = new QFilter("org", "in", isolatedOrgList).and(OUT_WAREHOUSE, "in", isolatedWHIds);
        QFilter filterFive = new QFilter("outorg", "in", isolatedOrgList).and(OUT_WAREHOUSE, "in", isolatedWHIds);
        return filterOne.or(filterTwo).or(filterThree).or(filterFour).or(filterFive);
    }

    private static QFilter buildTransOutWarehouseQfilter(List<Long> isolatedOrgList, List<Long> notIsolatedOrgList, List<Long> isolatedWHIds) {
        QFilter filterOne = new QFilter("billentry", "=", null).or("org", "in", notIsolatedOrgList).or("inorg", "in", notIsolatedOrgList);
        QFilter filterTwo = new QFilter(WAREHOUSE, "=", (Object)0).and(IN_WAREHOUSE, "=", (Object)0);
        QFilter filterThree = new QFilter("org", "in", isolatedOrgList).and(WAREHOUSE, "in", isolatedWHIds);
        QFilter filterFour = new QFilter("org", "in", isolatedOrgList).and(IN_WAREHOUSE, "in", isolatedWHIds);
        QFilter filterFive = new QFilter("inorg", "in", isolatedOrgList).and(IN_WAREHOUSE, "in", isolatedWHIds);
        return filterOne.or(filterTwo).or(filterThree).or(filterFour).or(filterFive);
    }

    @Deprecated
    private static List<Long> buildOrgIds(String entityName) {
        List<Map<String, String>> permissionOrgs = NewInvOrgHelper.getPermissionOrgs(entityName);
        ArrayList<Long> orgIds = new ArrayList<Long>(permissionOrgs.size());
        for (Map<String, String> permissionOrg : permissionOrgs) {
            orgIds.add(Long.valueOf(permissionOrg.get("id")));
        }
        return orgIds;
    }

    private static List<Long> buildOrgIds(String entityName, String appId) {
        List<Map<String, String>> permissionOrgs = NewInvOrgHelper.getPermissionOrgsByAppId(entityName, appId);
        ArrayList<Long> orgIds = new ArrayList<Long>(permissionOrgs.size());
        for (Map<String, String> permissionOrg : permissionOrgs) {
            orgIds.add(Long.valueOf(permissionOrg.get("id")));
        }
        return orgIds;
    }

    public static void buildIsolateList(List<Long> orgIds, List<Long> isolateOrgList, List<Long> notIsolateOrgList) {
        DynamicObjectCollection sysParams;
        ParamPublishObject param = ParameterReader.getParameterObject(null, (String)"=9Q86DR2P+Q");
        if (param != null && (sysParams = ParameterHelper.queryAllOrgParams(orgIds, (String)"05", (String)param.getId())) != null) {
            for (DynamicObject sysParam : sysParams) {
                String wareHouseIsolate;
                JSONObject sysParamJson;
                if (sysParam.get("fdata") == null || (sysParamJson = JSONObject.parseObject((String)sysParam.get("fdata").toString())) == null || sysParamJson.isEmpty() || !Boolean.parseBoolean(wareHouseIsolate = sysParamJson.getString("fwarehouseisolate"))) continue;
                isolateOrgList.add(sysParam.getLong("forgid"));
            }
        }
        for (Long orgId : orgIds) {
            if (isolateOrgList.contains(orgId)) continue;
            notIsolateOrgList.add(orgId);
        }
    }

    public static Boolean setWareHouseIsolateF7Filter(String formId, DynamicObject org, ListShowParameter showParameter) {
        QFilter warehouseF7Filter = WareHouseIsolateHelper.getCustomWarehouseF7Filter(formId, org);
        if (warehouseF7Filter == null) {
            return false;
        }
        showParameter.getListFilterParameter().setFilter(warehouseF7Filter);
        return true;
    }

    public static QFilter getWarehouseIsolateQFilterByDataCtrl(DynamicObject entity, String formId, String ctrlField) {
        return InvBizDataCtrlHelper.buildF7Helper().getF7QFilterByStrategy(entity, formId, ctrlField);
    }

    public static void setWarehouseQFilterByDataCtrl(Long orgId, ListShowParameter showParameter, String formId, DynamicObject entity, String ctrlField) {
        QFilter qFilter = WareHouseIsolateHelper.getWarehouseIsolateQFilterByDataCtrl(entity, formId, ctrlField);
        if (null != qFilter) {
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else {
            Long[] allWhs = WarehouseHelper.getAllWarehouseIDs(orgId);
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allWhs));
        }
    }

    public static QFilter getCustomWarehouseF7Filter(String formId, List<Long> orgIds) {
        if (orgIds.isEmpty()) {
            return null;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        Map<String, Map<String, Object>> batchAppParameters = AppParameterHelper.getBatchAppParameterByFormId(formId, orgIds);
        if (batchAppParameters == null || batchAppParameters.isEmpty()) {
            return null;
        }
        ArrayList<Long> isoOrgIds = new ArrayList<Long>(16);
        ArrayList<Long> noIsoOrgIds = new ArrayList<Long>(16);
        for (Map.Entry<String, Map<String, Object>> batchAppParameter : batchAppParameters.entrySet()) {
            String orgId = batchAppParameter.getKey();
            Map<String, Object> parameters = batchAppParameter.getValue();
            if (parameters == null || !parameters.containsKey("fwarehouseisolate")) continue;
            boolean wareHouseIsolate = (Boolean)parameters.get("fwarehouseisolate");
            if (wareHouseIsolate) {
                isoOrgIds.add(Long.valueOf(orgId));
                continue;
            }
            noIsoOrgIds.add(Long.valueOf(orgId));
        }
        ArrayList<Long> wareHouseIds = new ArrayList<Long>(16);
        List<DynamicObject> wareHouses = WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId(userId, isoOrgIds, formId);
        for (DynamicObject wareHose : wareHouses) {
            Long wareHosePkValue = wareHose.getLong("id");
            wareHouseIds.add(wareHosePkValue);
        }
        if (!noIsoOrgIds.isEmpty()) {
            wareHouseIds.addAll(WarehouseHelper.getAllFinishInitWarehouseIDsByOrgIds(noIsoOrgIds));
        }
        return new QFilter("id", "in", wareHouseIds);
    }

    public static QFilter getCustomWarehouseF7Filter(String formId, DynamicObject org) {
        if (org == null) {
            return null;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        Object wareHouseIsolate = AppParameterHelper.getAppParameterByFormId(formId, (Long)org.getPkValue(), "fwarehouseisolate");
        if (wareHouseIsolate instanceof Boolean && !((Boolean)wareHouseIsolate).booleanValue()) {
            return null;
        }
        List<DynamicObject> wareHouses = "im_invcountscheme".equals(formId) || "im_invcountbill".equals(formId) ? WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId(userId, Collections.singletonList(org.getLong("id")), formId) : WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId(userId, Collections.singletonList(org.getLong("id")));
        if (CollectionUtils.isEmpty(wareHouses)) {
            return null;
        }
        ArrayList<Long> wareHouseIds = new ArrayList<Long>(16);
        for (DynamicObject wareHose : wareHouses) {
            Long wareHosePkValue = (Long)wareHose.getPkValue();
            wareHouseIds.add(wareHosePkValue);
        }
        return new QFilter("id", "in", wareHouseIds);
    }

    @Deprecated
    public static QFilter getCAWHIsolateQFilter(List<Long> orgIds, String billFormId, String queryKey) {
        long userId = UserServiceHelper.getCurrentUserId();
        if (orgIds == null || orgIds.isEmpty()) {
            orgIds = WareHouseIsolateHelper.buildOrgIds(billFormId);
        }
        ArrayList<Long> isolatedOrgList = new ArrayList<Long>(16);
        ArrayList<Long> notIsolatedOrgList = new ArrayList<Long>(16);
        WareHouseIsolateHelper.buildIsolateList(orgIds, isolatedOrgList, notIsolatedOrgList);
        if (CollectionUtils.isEmpty(isolatedOrgList)) {
            return new QFilter("org", "in", orgIds);
        }
        List<DynamicObject> isolatedWareHouses = WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId(userId, isolatedOrgList);
        if (CollectionUtils.isEmpty(isolatedWareHouses)) {
            return new QFilter("org", "in", orgIds);
        }
        QFilter filter = WareHouseIsolateHelper.getFilterByCA(isolatedOrgList, notIsolatedOrgList, isolatedWareHouses, queryKey);
        return filter;
    }

    public static QFilter getCAWHIsolateQFilter(String appId, List<Long> orgIds, String billFormId, String queryKey) {
        long userId = UserServiceHelper.getCurrentUserId();
        if (orgIds == null || orgIds.isEmpty()) {
            orgIds = WareHouseIsolateHelper.buildOrgIds(billFormId, appId);
        }
        ArrayList<Long> isolatedOrgList = new ArrayList<Long>(16);
        ArrayList<Long> notIsolatedOrgList = new ArrayList<Long>(16);
        WareHouseIsolateHelper.buildIsolateList(orgIds, isolatedOrgList, notIsolatedOrgList);
        if (CollectionUtils.isEmpty(isolatedOrgList)) {
            return new QFilter("org", "in", orgIds);
        }
        List<DynamicObject> isolatedWareHouses = WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId(userId, isolatedOrgList);
        if (CollectionUtils.isEmpty(isolatedWareHouses)) {
            return new QFilter("org", "in", orgIds);
        }
        QFilter filter = WareHouseIsolateHelper.getFilterByCA(isolatedOrgList, notIsolatedOrgList, isolatedWareHouses, queryKey);
        return filter;
    }

    private static QFilter getFilterByCA(List<Long> isolatedOrgList, List<Long> notIsolatedOrgList, List<DynamicObject> isolatedWareHouses, String queryKey) {
        ArrayList<Long> isolatedWHIds = new ArrayList<Long>(isolatedWareHouses.size());
        for (DynamicObject wareHose : isolatedWareHouses) {
            Long wareHosePkValue = (Long)wareHose.getPkValue();
            isolatedWHIds.add(wareHosePkValue);
        }
        QFilter filter = new QFilter("org", "in", isolatedOrgList).and(new QFilter(queryKey, "in", isolatedWHIds));
        filter.or(new QFilter("org", "in", notIsolatedOrgList));
        return filter;
    }

    public static List<DynamicObject> getWarehouseByUserIdAndOrgId(Long userId, List<Long> orgIds) {
        ArrayList<DynamicObject> warehouses = new ArrayList<DynamicObject>(16);
        if (orgIds.isEmpty()) {
            return warehouses;
        }
        Set<Long> operatorIds = WareHouseIsolateHelper.getOperatorIds(userId);
        DynamicObject[] warehouseSetups = WareHouseIsolateHelper.getWarehouseSetups(orgIds, operatorIds, null);
        WareHouseIsolateHelper.warehouseCorrection(orgIds, warehouses, warehouseSetups);
        return warehouses;
    }

    public static Map<Long, Set<Long>> getWarehouseByUserIdAndOrgIds(Long userId, List<Long> orgIds) {
        if (orgIds.isEmpty()) {
            return new HashMap<Long, Set<Long>>(1);
        }
        Set<Long> operatorIds = WareHouseIsolateHelper.getOperatorIds(userId);
        DynamicObject[] warehouseSetups = WareHouseIsolateHelper.getWarehouseSetups(orgIds, operatorIds, null);
        Map<Long, Set<Long>> longSetMap = WareHouseIsolateHelper.warehouseIds(orgIds, warehouseSetups);
        return longSetMap;
    }

    public static List<DynamicObject> getWarehouseByUserIdAndOrgId(Long userId, List<Long> orgIds, String formId) {
        ArrayList<DynamicObject> warehouses = new ArrayList<DynamicObject>(16);
        if (orgIds.isEmpty()) {
            return warehouses;
        }
        Set<Long> operatorIds = WareHouseIsolateHelper.getOperatorIds(userId);
        DynamicObject[] warehouseSetups = WareHouseIsolateHelper.getWarehouseSetups(orgIds, operatorIds, formId);
        WareHouseIsolateHelper.warehouseCorrection(orgIds, warehouses, warehouseSetups);
        return warehouses;
    }

    private static void warehouseCorrection(List<Long> orgIds, List<DynamicObject> warehouses, DynamicObject[] warehouseSetups) {
        ArrayList<Long> notOperatorOrgIds = new ArrayList<Long>(orgIds);
        for (DynamicObject warehouseSetup : warehouseSetups) {
            warehouses.add(warehouseSetup.getDynamicObject("warehouse"));
            DynamicObject org = warehouseSetup.getDynamicObject("org");
            Object orgId = org.getPkValue();
            notOperatorOrgIds.remove(orgId);
        }
        if (!notOperatorOrgIds.isEmpty()) {
            QFilter orgf = new QFilter("org", "in", (Object)notOperatorOrgIds.toArray());
            orgf.and(new QFilter("startstatus", "=", (Object)"B"));
            Map warehouseDycs = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)"warehouse", (QFilter[])new QFilter[]{orgf});
            for (Map.Entry objectEntry : warehouseDycs.entrySet()) {
                DynamicObject warehouse = ((DynamicObject)objectEntry.getValue()).getDynamicObject("warehouse");
                warehouses.add(warehouse);
            }
        }
    }

    private static Map<Long, Set<Long>> warehouseIds(List<Long> orgIds, DynamicObject[] warehouseSetups) {
        Long warehouseId;
        HashMap<Long, Set<Long>> orgToWarehouse = new HashMap<Long, Set<Long>>(16);
        ArrayList<Long> notOperatorOrgIds = new ArrayList<Long>(orgIds);
        for (DynamicObject warehouseSetup : warehouseSetups) {
            warehouseId = warehouseSetup.getLong("warehouse.id");
            DynamicObject org = warehouseSetup.getDynamicObject("org");
            if (!orgToWarehouse.containsKey(org.getPkValue())) {
                orgToWarehouse.put((Long)org.getPkValue(), new HashSet(16));
            }
            ((Set)orgToWarehouse.get((Long)org.getPkValue())).add(warehouseId);
            Object orgId = org.getPkValue();
            notOperatorOrgIds.remove(orgId);
        }
        if (!notOperatorOrgIds.isEmpty()) {
            QFilter orgf = new QFilter("org", "in", (Object)notOperatorOrgIds.toArray());
            orgf.and(new QFilter("startstatus", "=", (Object)"B"));
            Map warehouseDycs = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)"warehouse", (QFilter[])new QFilter[]{orgf});
            for (Map.Entry objectEntry : warehouseDycs.entrySet()) {
                warehouseId = ((DynamicObject)objectEntry.getValue()).getLong("warehouse.id");
                Long orgId = ((DynamicObject)objectEntry.getValue()).getLong("org.id");
                if (!orgToWarehouse.containsKey(orgId)) {
                    orgToWarehouse.put(orgId, new HashSet());
                }
                ((Set)orgToWarehouse.get(orgId)).add(warehouseId);
            }
        }
        return orgToWarehouse;
    }

    private static DynamicObject[] getWarehouseSetups(List<Long> orgIds, Set<Long> operatorIds, String formId) {
        QFilter qFilter = new QFilter("org", "in", orgIds);
        qFilter.and(new QFilter("operatorentity.operatoruser", "in", operatorIds));
        qFilter.and(new QFilter("startstatus", "=", (Object)"B"));
        if ("im_invcountscheme".equals(formId) || "im_invcountbill".equals(formId)) {
            qFilter.and(new QFilter("initstatus", "=", (Object)"B"));
        }
        return BusinessDataServiceHelper.load((String)"im_warehousesetup", (String)"org,warehouse", (QFilter[])qFilter.toArray());
    }

    private static Set<Long> getOperatorIds(Long userId) {
        QFilter qFilter1 = new QFilter("operatorid", "=", (Object)userId);
        qFilter1.and(new QFilter("opergrptype", "=", (Object)"KCZ"));
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bd_operator", (String)"id", (QFilter[])qFilter1.toArray());
        HashSet<Long> operatorIds = new HashSet<Long>(ids.length);
        if (ids.length <= 0) {
            return operatorIds;
        }
        for (DynamicObject id : ids) {
            operatorIds.add(Long.parseLong(id.getPkValue().toString()));
        }
        return operatorIds;
    }

    public static List<DynamicObject> getWarehouses(Object org, String reportName, boolean isQuery) {
        List<DynamicObject> warehouses = new ArrayList<DynamicObject>(16);
        Long userId = UserServiceHelper.getCurrentUserId();
        if (org instanceof DynamicObject) {
            DynamicObject orgObj = (DynamicObject)org;
            Object warehouseIsolate = AppParameterHelper.getAppParameterByFormId(reportName, Long.parseLong(orgObj.getPkValue().toString()), "fwarehouseisolate");
            if (warehouseIsolate instanceof Boolean && ((Boolean)warehouseIsolate).booleanValue()) {
                warehouses = WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId(userId, Collections.singletonList((Long)orgObj.getPkValue()), null);
            }
        } else if (org instanceof DynamicObjectCollection) {
            ArrayList<Long> listOrgId = new ArrayList<Long>();
            for (DynamicObject dynamicObject : (DynamicObjectCollection)org) {
                listOrgId.add(dynamicObject.getLong(isQuery ? "id" : "fbasedataid_id"));
            }
            ArrayList<Long> isolateOrgList = new ArrayList<Long>(16);
            ArrayList<Long> notIsolateOrgList = new ArrayList<Long>(16);
            WareHouseIsolateHelper.buildIsolateList(listOrgId, isolateOrgList, notIsolateOrgList);
            List<DynamicObject> notIsoWarehouse = WareHouseIsolateHelper.getAllWarehouse(notIsolateOrgList);
            List<DynamicObject> isoWarehouses = WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId(userId, isolateOrgList, null);
            HashSet<DynamicObject> dynamicObjects = new HashSet<DynamicObject>(notIsoWarehouse);
            dynamicObjects.addAll(isoWarehouses);
            warehouses.addAll(dynamicObjects);
        }
        return warehouses;
    }

    private static List<DynamicObject> getAllWarehouse(List<Long> orgIds) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        if (orgIds == null || orgIds.isEmpty()) {
            return result;
        }
        QFilter orgf = new QFilter("org", "in", (Object)orgIds.toArray());
        orgf.and(new QFilter("startstatus", "=", (Object)"B"));
        Map warehouseDycs = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)"warehouse", (QFilter[])new QFilter[]{orgf});
        for (DynamicObject warehouseSetup : warehouseDycs.values()) {
            result.add(warehouseSetup.getDynamicObject("warehouse"));
        }
        return result;
    }

    public static List<Long> getWarehouseIds(Object org, String reportName, boolean isQuery) {
        List<Long> warehouses = new ArrayList<Long>(16);
        Long userId = UserServiceHelper.getCurrentUserId();
        if (org instanceof DynamicObject) {
            DynamicObject orgObj = (DynamicObject)org;
            Object warehouseIsolate = AppParameterHelper.getAppParameterByFormId(reportName, Long.parseLong(orgObj.getPkValue().toString()), "fwarehouseisolate");
            if (warehouseIsolate instanceof Boolean && ((Boolean)warehouseIsolate).booleanValue()) {
                warehouses = WareHouseIsolateHelper.getWarehouseIdsByUserIdAndOrgId(userId, Collections.singletonList((Long)orgObj.getPkValue()), null);
            }
        } else if (org instanceof DynamicObjectCollection) {
            ArrayList<Long> listOrgId = new ArrayList<Long>();
            for (DynamicObject dynamicObject : (DynamicObjectCollection)org) {
                listOrgId.add(dynamicObject.getLong(isQuery ? "id" : "fbasedataid_id"));
            }
            ArrayList<Long> isolateOrgList = new ArrayList<Long>(16);
            ArrayList<Long> notIsolateOrgList = new ArrayList<Long>(16);
            WareHouseIsolateHelper.buildIsolateList(listOrgId, isolateOrgList, notIsolateOrgList);
            List<Long> notIsoWarehouse = WareHouseIsolateHelper.getAllWarehouseIds(notIsolateOrgList);
            List<Long> isoWarehouses = WareHouseIsolateHelper.getWarehouseIdsByUserIdAndOrgId(userId, isolateOrgList, null);
            HashSet<Long> dynamicObjects = new HashSet<Long>(notIsoWarehouse);
            dynamicObjects.addAll(isoWarehouses);
            warehouses.addAll(dynamicObjects);
        }
        return warehouses;
    }

    public static List<Long> getWarehouseIdsByUserIdAndOrgId(Long userId, List<Long> orgIds, String formId) {
        ArrayList<Long> warehouses = new ArrayList<Long>(16);
        if (orgIds.isEmpty()) {
            return warehouses;
        }
        Set<Long> operatorIds = WareHouseIsolateHelper.getOperatorIds(userId);
        DataSet warehouseSetups = WareHouseIsolateHelper.getWarehouseSetupIds(orgIds, operatorIds, formId);
        WareHouseIsolateHelper.warehouseIdsCorrection(orgIds, warehouses, warehouseSetups);
        return warehouses;
    }

    private static DataSet getWarehouseSetupIds(List<Long> orgIds, Set<Long> operatorIds, String formId) {
        QFilter qFilter = new QFilter("org", "in", orgIds);
        qFilter.and(new QFilter("operatorentity.operatoruser", "in", operatorIds));
        qFilter.and(new QFilter("startstatus", "=", (Object)"B"));
        if ("im_invcountscheme".equals(formId) || "im_invcountbill".equals(formId)) {
            qFilter.and(new QFilter("initstatus", "=", (Object)"B"));
        }
        return QueryServiceHelper.queryDataSet((String)"kd.scmc.im.business.helper.WareHouseIsolateHelper", (String)"im_warehousesetup", (String)"org.id,warehouse.id", (QFilter[])qFilter.toArray(), null);
    }

    private static void warehouseIdsCorrection(List<Long> orgIds, List<Long> warehouses, DataSet warehouseSetups) {
        ArrayList<Long> notOperatorOrgIds = new ArrayList<Long>(orgIds);
        while (warehouseSetups.hasNext()) {
            Row next = warehouseSetups.next();
            Object orgId = next.get("org.id");
            Long whId = next.getLong("warehouse.id");
            warehouses.add(whId);
            notOperatorOrgIds.remove(orgId);
        }
        if (!notOperatorOrgIds.isEmpty()) {
            QFilter orgf = new QFilter("org", "in", (Object)notOperatorOrgIds.toArray());
            orgf.and(new QFilter("startstatus", "=", (Object)"B"));
            DataSet whDataset = QueryServiceHelper.queryDataSet((String)"kd.scmc.im.business.helper.WareHouseIsolateHelper", (String)"im_warehousesetup", (String)"warehouse.id", (QFilter[])orgf.toArray(), null);
            while (whDataset.hasNext()) {
                Row next = whDataset.next();
                Long whId = next.getLong("warehouse.id");
                warehouses.add(whId);
            }
        }
    }

    private static List<Long> getAllWarehouseIds(List<Long> orgIds) {
        ArrayList<Long> result = new ArrayList<Long>(16);
        if (orgIds == null || orgIds.isEmpty()) {
            return result;
        }
        QFilter orgf = new QFilter("org", "in", (Object)orgIds.toArray());
        orgf.and(new QFilter("startstatus", "=", (Object)"B"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.scmc.im.business.helper.WareHouseIsolateHelper", (String)"im_warehousesetup", (String)"warehouse.id", (QFilter[])orgf.toArray(), null);
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            Long whId = next.getLong("warehouse.id");
            result.add(whId);
        }
        return result;
    }
}

