/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class WarehouseSetupHelper {
    public static final int BATCH_SIZE = 200;

    public static Map<Long, Map<String, Long>> loadMaterialEntryMap(Collection<Object> warehouseSetupIds) {
        HashMap<Long, Map<String, Long>> materialEntryMap = new HashMap<Long, Map<String, Long>>(2);
        if (ObjectUtils.isEmpty(warehouseSetupIds)) {
            return materialEntryMap;
        }
        QFilter qFilter = new QFilter("id", "in", warehouseSetupIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)WarehouseSetupHelper.class.getName(), (String)"im_warehousesetup", (String)"materialentity.id AS entryid,org,warehouse,materialentity.materialnumber AS materialnumber,materialentity.materialgrpnumber AS materialgrpnumber", (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long entryId = row.getLong("entryid");
                Long orgId = row.getLong("org");
                Long warehouseId = row.getLong("warehouse");
                Long materielId = row.getLong("materialnumber");
                Long materielGrpId = row.getLong("materialgrpnumber");
                if (materielId == 0L && materielGrpId == 0L) continue;
                HashMap<String, Long> map = new HashMap<String, Long>(4);
                map.put("org", orgId);
                map.put("warehouse", warehouseId);
                map.put("materialnumber", materielId);
                map.put("materialgrpnumber", materielGrpId);
                materialEntryMap.put(entryId, map);
            }
        }
        return materialEntryMap;
    }

    public static void syncDefaultWarehouse(DynamicObject[] entities, Map<Long, Map<String, Long>> materialEntryMap, boolean isSave) {
        if (ObjectUtils.isEmpty(materialEntryMap)) {
            return;
        }
        for (DynamicObject entity : entities) {
            DynamicObjectCollection todoRows = entity.getDynamicObjectCollection("materialentity");
            for (DynamicObject todoRow : todoRows) {
                Long entryId = (Long)todoRow.getPkValue();
                if (!isSave) continue;
                materialEntryMap.remove(entryId);
            }
        }
        if (materialEntryMap == null || materialEntryMap.isEmpty()) {
            return;
        }
        ArrayList<Map<String, Long>> mapList = new ArrayList<Map<String, Long>>(materialEntryMap.values());
        List splitList = Lists.partition(mapList, (int)200);
        for (List split : splitList) {
            QFilter orgWarehouseFilters = WarehouseSetupHelper.buildFilter(split);
            if (null == orgWarehouseFilters) {
                return;
            }
            DeleteServiceHelper.delete((String)"im_materdefaultwh", (QFilter[])orgWarehouseFilters.toArray());
        }
    }

    private static QFilter buildFilter(Collection<Map<String, Long>> mapList) {
        QFilter orgWarehouseFilters = null;
        for (Map<String, Long> map : mapList) {
            Long orgId = map.get("org");
            Long warehouseId = map.get("warehouse");
            Long materielId = map.get("materialnumber");
            Long materielGrpId = map.get("materialgrpnumber");
            QFilter qFilter = new QFilter("org", "=", (Object)orgId);
            qFilter.and("defaultwarehouse", "=", (Object)warehouseId);
            if (materielId != null && materielId != 0L) {
                qFilter.and("materialnumber", "=", (Object)materielId);
            } else {
                qFilter.and("materialgrpnumber", "=", (Object)materielGrpId);
            }
            orgWarehouseFilters = orgWarehouseFilters == null ? qFilter : orgWarehouseFilters.or(qFilter);
        }
        return orgWarehouseFilters;
    }
}

