/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.acct;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.EnumBillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.consts.CloseAccountConst;
import kd.scmc.im.consts.InvBalanceConst;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.DateUtils;

public class CloseAcctHelper {
    private static final Log log = LogFactory.getLog(CloseAcctHelper.class);
    private static final String BIZ_DOMAIN = "biztype.domain";
    private static final String NOT_VIRTUAL_BILL = "0";
    private static final String UNVERIFYBASEQTY = "billentry.unverifybaseqty";
    private static final String HASNOTAPBUSBILL = "0";
    private static final String BILL_STATUS_AUDIT = "C";
    private static final int SPLIT_ROWS_SIZE = 200;

    public static Map<Boolean, String> isAllowOp(DynamicObjectCollection dataEntity, int[] selectRows, List<DLock> locks) {
        boolean allowOp = true;
        HashMap<Boolean, String> checkMap = new HashMap<Boolean, String>();
        StringBuilder checkMsg = new StringBuilder();
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject org = ((DynamicObject)dataEntity.get(selectRows[i])).getDynamicObject("org");
            DynamicObject warehouse = ((DynamicObject)dataEntity.get(selectRows[i])).getDynamicObject("warehouse");
            if (org == null || warehouse == null) continue;
            StringBuilder closeDateKey = new StringBuilder();
            closeDateKey.append(org.getPkValue());
            closeDateKey.append(",");
            closeDateKey.append(warehouse.getPkValue());
            DLock lock = DLock.create((String)String.format("scm/im/%s/%s", "im_closeaccount", closeDateKey)).fastMode();
            if (lock.tryLock()) {
                locks.add(lock);
                continue;
            }
            allowOp = false;
            String orgName = org.getLocaleString("name").getLocaleValue();
            String warehouseName = warehouse.getLocaleString("name").getLocaleValue();
            checkMsg.append(String.format(CloseAccountConst.getLOCKMSGFORMAT(), orgName, warehouseName));
        }
        checkMap.put(allowOp, checkMsg.toString());
        return checkMap;
    }

    public static Map<String, DynamicObject> batchGetCloseDateMap(DynamicObjectCollection dataEntity, List<Integer> selectRows, boolean containDeletef) {
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>();
        if (selectRows.isEmpty()) {
            return result;
        }
        List partition = Lists.partition(selectRows, (int)200);
        for (List splitSuccessRows : partition) {
            QFilter closef = null;
            for (Integer item : splitSuccessRows) {
                closef = CloseAcctHelper.buildOrgWarehouseDateFilter(dataEntity, item, closef, false, false, "", null);
            }
            if (containDeletef && closef != null) {
                closef = closef.and(new QFilter("isdelete", "<>", (Object)true));
            }
            result.putAll(CloseAcctHelper.getCloseDateMap(closef));
        }
        return result;
    }

    public static Map<String, DynamicObject> getCloseDateMap(QFilter closeFilter) {
        HashMap<String, DynamicObject> closeDateMap = new HashMap<String, DynamicObject>(16);
        if (closeFilter == null) {
            return closeDateMap;
        }
        try (DataSet closeRecord = null;){
            String org = "org";
            String warehouse = "warehouse";
            String name = "name";
            String orgName = org + "." + name;
            String warehouseName = warehouse + "." + name;
            List<String> properties = Arrays.asList("id", org, warehouse, orgName, warehouseName, "closedate");
            String selectProperties = StringUtils.join((Object[])properties.toArray(), (String)",");
            closeRecord = QueryServiceHelper.queryDataSet((String)"im_closeaccountrecord", (String)"im_closeaccountrecord", (String)selectProperties, (QFilter[])closeFilter.toArray(), (String)"closedate").groupBy(new String[]{org, warehouse, orgName, warehouseName}).max("closedate").max("id").finish();
            closeRecord.forEach(row -> {
                String key = row.getString(org) + "," + row.getString(warehouse);
                DynamicObject item = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"im_closeaccountrecord"));
                item.set("id", (Object)row.getLong("id"));
                item.set("closedate", (Object)row.getDate("closedate"));
                DynamicObject orgdyc = CloseAcctHelper.getDynamicObject("bos_org", row.getString(orgName), row.getLong(org));
                item.set(org, (Object)orgdyc);
                DynamicObject warehouseDyc = CloseAcctHelper.getDynamicObject("bd_warehouse", row.getString(warehouseName), row.getLong(warehouse));
                item.set(warehouse, (Object)warehouseDyc);
                closeDateMap.put(key, item);
            });
        }
        return closeDateMap;
    }

    public static Map<String, DynamicObject> getCloseDateMap(DynamicObject[] orgWarehouses) {
        QFilter closeFilter = new QFilter("isdelete", "<>", (Object)true);
        closeFilter = closeFilter.and(CloseAcctHelper.buildCloseFilter(orgWarehouses));
        return CloseAcctHelper.getCloseDateMap(closeFilter);
    }

    public static Map<String, DynamicObject> getCloseDateMap(HashMap<Long, Set<Long>> orgWarehouseMap) {
        QFilter closeFilter = CloseAcctHelper.buildOrgWarehousesFilter(orgWarehouseMap);
        if (closeFilter != null) {
            closeFilter.and(new QFilter("isdelete", "<>", (Object)true));
        }
        return CloseAcctHelper.getCloseDateMap(closeFilter);
    }

    public static Map<String, DynamicObject> getAllCloseDateMap(Map<Long, Set<Long>> orgWarehouseMap) {
        QFilter closef = CloseAcctHelper.buildOrgWarehousesFilter(orgWarehouseMap);
        return CloseAcctHelper.getCloseDateMap(closef);
    }

    public static Map<String, List<Date>> getCloseDateGroups(QFilter closef) {
        DynamicObject[] closeDateDycs;
        HashMap<String, List<Date>> closeDateMap = new HashMap<String, List<Date>>();
        if (closef == null) {
            return closeDateMap;
        }
        String selects = "org,warehouse,closedate";
        for (DynamicObject dateDyc : closeDateDycs = BusinessDataServiceHelper.load((String)"im_closeaccountrecord", (String)selects, (QFilter[])new QFilter[]{closef}, (String)"closedate")) {
            DynamicObject orgDyc = dateDyc.getDynamicObject("org");
            DynamicObject warehouseDyc = dateDyc.getDynamicObject("warehouse");
            String orgWarehouseKey = orgDyc.getPkValue() + "," + warehouseDyc.getPkValue();
            closeDateMap.computeIfAbsent(orgWarehouseKey, k -> new ArrayList());
            ((List)closeDateMap.get(orgWarehouseKey)).add(dateDyc.getDate("closedate"));
        }
        return closeDateMap;
    }

    public static Map<Integer, String> checkCloseDate(DynamicObjectCollection dataEntity, int[] selectRows, List<Integer> successRows, List<Integer> dateEqualLastDateRows, List<Integer> checkDateFailRows) {
        HashMap<Integer, String> execInfoMap = new HashMap<Integer, String>();
        List<Integer> rows = Arrays.stream(selectRows).boxed().collect(Collectors.toList());
        Map<String, DynamicObject> closeDateMap = CloseAcctHelper.batchGetCloseDateMap(dataEntity, rows, false);
        Map<String, Date> warehouseSetupTimeMap = WarehouseHelper.getOrgWarehouseSetupTime(CloseAcctHelper.getOrgWarehouseMap(dataEntity, selectRows));
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject org = ((DynamicObject)dataEntity.get(selectRows[i])).getDynamicObject("org");
            DynamicObject warehouse = ((DynamicObject)dataEntity.get(selectRows[i])).getDynamicObject("warehouse");
            if (org == null || warehouse == null) continue;
            Date closeDate = ((DynamicObject)dataEntity.get(selectRows[i])).getDate("closedate");
            String closeDateKey = org.getPkValue() + "," + warehouse.getPkValue();
            DynamicObject record = closeDateMap.get(closeDateKey);
            String orgName = org.getLocaleString("name").getLocaleValue();
            String warehouseName = warehouse.getLocaleString("name").getLocaleValue();
            if (closeDate == null) {
                execInfoMap.put(selectRows[i], String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5173\u8d26\u65e5\u671f\u3002", (String)"CloseAcctHelper_0", (String)"scmc-im-business", (Object[])new Object[0]), orgName, warehouseName));
                checkDateFailRows.add(selectRows[i]);
                continue;
            }
            if (closeDate != null && !CommonUtils.isNull((Object)record) && DateUtils.getDate((Date)closeDate).compareTo(DateUtils.getDate((Date)record.getDate("closedate"))) < 0) {
                execInfoMap.put(selectRows[i], CloseAccountConst.getCLOSEDATEVALIDATEMSGFORMAT());
                checkDateFailRows.add(selectRows[i]);
                continue;
            }
            Date warehouseSetupDate = warehouseSetupTimeMap.get(closeDateKey);
            if (closeDate != null && warehouseSetupDate != null && DateUtils.getDate((Date)closeDate).compareTo(warehouseSetupDate) < 0) {
                execInfoMap.put(selectRows[i], CloseAccountConst.getCLOSEDATEVALIDATESTARTMSGFORMAT());
                checkDateFailRows.add(selectRows[i]);
                continue;
            }
            successRows.add(selectRows[i]);
            if (record == null || DateUtils.getDate((Date)closeDate).compareTo(record.getDate("closedate")) != 0) continue;
            dateEqualLastDateRows.add(selectRows[i]);
        }
        return execInfoMap;
    }

    public static String checkCloseDateMonth(DynamicObjectCollection dynamicObjectCollection, int[] selectRows) {
        StringBuilder execInfo = new StringBuilder();
        for (int selectRow : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(selectRow);
            DynamicObject org = dynamicObject.getDynamicObject("org");
            DynamicObject wareHouse = dynamicObject.getDynamicObject("warehouse");
            if (org == null || wareHouse == null) continue;
            Date closeDate = dynamicObject.getDate("closedate");
            Date thisMonthFirstDay = DateUtils.getFirstDayOfMonthByDate((Date)new Date());
            if (closeDate == null || closeDate.before(thisMonthFirstDay)) continue;
            String orgName = org.getString("name");
            String wareHouseName = wareHouse.getString("name");
            execInfo.append(String.format(CloseAccountConst.getCloseDateAfterThisMonth(), orgName, wareHouseName));
        }
        return execInfo.toString();
    }

    public static Map<Integer, String> checkLastCloseDate(DynamicObjectCollection dataEntity, int[] selectRows, List<Integer> successRows, List<Object> deleteIds) {
        HashMap<Integer, String> execInfoMap = new HashMap<Integer, String>();
        Map<String, DynamicObject> lastCloseDateMap = CloseAcctHelper.batchGetCloseDateMap(dataEntity, Arrays.stream(selectRows).boxed().collect(Collectors.toList()), true);
        for (int item : selectRows) {
            DynamicObject org = ((DynamicObject)dataEntity.get(item)).getDynamicObject("org");
            DynamicObject warehouse = ((DynamicObject)dataEntity.get(item)).getDynamicObject("warehouse");
            String closeDateKey = org.getPkValue() + "," + warehouse.getPkValue();
            if (CommonUtils.isNull((Object)lastCloseDateMap.get(closeDateKey))) {
                execInfoMap.put(item, CloseAccountConst.getUNCLOSEDATEVALIDATEMSGFORMAT());
                continue;
            }
            successRows.add(item);
            deleteIds.add(lastCloseDateMap.get(closeDateKey).getPkValue());
        }
        return execInfoMap;
    }

    public static Map<Object, DynamicObject> getInitWarehouses(QFilter filter) {
        QFilter initf = new QFilter("initstatus", "=", (Object)"B");
        String selectProperties = "org,warehouse";
        initf = filter == null ? initf : initf.and(filter);
        Map orgWarehouseMap = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)selectProperties, (QFilter[])initf.toArray());
        return orgWarehouseMap;
    }

    public static Map<String, Map<String, String>> checkUnAuditBill(DynamicObjectCollection dataEntity, List<Integer> successRows, Map<String, Boolean> checkMap) {
        List closeAcctBillList = InvBalanceConst.getBalBillList();
        DynamicObjectCollection existBills = QueryServiceHelper.query((String)"bos_entityobject", (String)"number", (QFilter[])new QFilter("number", "in", (Object)closeAcctBillList).toArray());
        ArrayList<String> existBillList = new ArrayList<String>(16);
        for (DynamicObject existBill : existBills) {
            existBillList.add(existBill.getString("number"));
        }
        DataSet allDataSet = null;
        List partition = Lists.partition(successRows, (int)200);
        for (String formId : existBillList) {
            for (List splitSuccessRows : partition) {
                QFilter unAuditFilter = CloseAcctHelper.getUnAuditBillFilter(dataEntity, splitSuccessRows, formId, checkMap);
                DataSet unAuditBills = CloseAcctHelper.getCheckFailedBills(formId, unAuditFilter);
                allDataSet = CloseAcctHelper.mergeDataSet(allDataSet, unAuditBills);
            }
        }
        return CloseAcctHelper.getUnAuditCheckMsgMap(allDataSet);
    }

    private static Map<String, Map<String, String>> getUnAuditCheckMsgMap(DataSet unAuditBillDataSet) {
        HashMap<String, Map<String, String>> failMsgMap = new HashMap<String, Map<String, String>>();
        if (unAuditBillDataSet == null) {
            return failMsgMap;
        }
        HashMap rowUnAuditBillMap = new HashMap();
        HashMap rowStatusMap = new HashMap();
        for (Row unAuditBill : unAuditBillDataSet) {
            String formId = unAuditBill.getString("formid");
            String orgWarehouseKey = CloseAcctHelper.getOrgWarehouseKey(unAuditBill.getString("org"), unAuditBill.getString("warehouse"));
            rowUnAuditBillMap.putIfAbsent(orgWarehouseKey, new HashMap());
            rowStatusMap.putIfAbsent(orgWarehouseKey, new HashMap());
            ((Map)rowUnAuditBillMap.get(orgWarehouseKey)).putIfAbsent(formId, new HashSet());
            ((Map)rowStatusMap.get(orgWarehouseKey)).putIfAbsent(formId, new HashSet());
            ((Set)((Map)rowUnAuditBillMap.get(orgWarehouseKey)).get(formId)).add(unAuditBill.getString("billno"));
            ((Set)((Map)rowStatusMap.get(orgWarehouseKey)).get(formId)).add(unAuditBill.getString("billstatus"));
        }
        for (Map.Entry rowUnAuditBillEntry : rowUnAuditBillMap.entrySet()) {
            String orgWarehouseKey = (String)rowUnAuditBillEntry.getKey();
            Map formUnAuditBillMap = (Map)rowUnAuditBillEntry.getValue();
            Map formStatusMap = (Map)rowStatusMap.get(orgWarehouseKey);
            failMsgMap.putIfAbsent(orgWarehouseKey, new HashMap());
            for (Map.Entry formUnAuditBillEntry : formUnAuditBillMap.entrySet()) {
                String formId = (String)formUnAuditBillEntry.getKey();
                Set statusSet = (Set)formStatusMap.get(formId);
                String billNo = StringUtils.join((Object[])((Set)formUnAuditBillEntry.getValue()).toArray(), (String)",");
                ((Map)failMsgMap.get(orgWarehouseKey)).put(CloseAcctHelper.getUnAuditCheckMsg(formId, statusSet), billNo);
            }
        }
        return failMsgMap;
    }

    public static String getOrgWarehouseKey(String orgId, String warehouseId) {
        return orgId + "," + warehouseId;
    }

    private static String getUnAuditCheckMsg(String formId, Set statusSet) {
        StringBuilder statusMsgBuilder = new StringBuilder();
        String billHint = CloseAccountConst.getUNAUDITFORMAT();
        if (statusSet != null && !CollectionUtils.isEmpty((Collection)statusSet)) {
            if (statusSet.contains(EnumBillStatus.A.toString()) && statusSet.contains(EnumBillStatus.B.toString())) {
                billHint = CloseAccountConst.getTEMPORARYANDSUBMITFORMAT();
            } else if (statusSet.contains(EnumBillStatus.A.toString())) {
                billHint = CloseAccountConst.getTEMPORARYSTORAGEFORMAT();
            } else if (statusSet.contains(EnumBillStatus.B.toString())) {
                billHint = CloseAccountConst.getSUBMITFORMAT();
            }
        }
        statusMsgBuilder.append(billHint).append("#").append(formId);
        String localEntityName = EntityMetadataCache.getDataEntityType((String)formId).getDisplayName().getLocaleValue();
        return String.format(statusMsgBuilder.toString(), localEntityName);
    }

    public static Map<String, Map<String, String>> checkOmcToAPBill(DynamicObjectCollection dataEntity, List<Integer> successRows, Map<String, Boolean> checkMap) {
        DynamicObject omcBill = QueryServiceHelper.queryOne((String)"bos_entityobject", (String)"number", (QFilter[])new QFilter("number", "=", (Object)"im_mdc_omcmplinbill").toArray());
        if (omcBill == null) {
            return new HashMap<String, Map<String, String>>();
        }
        DataSet allOmcToApBills = null;
        List partition = Lists.partition(successRows, (int)200);
        for (List splitSuccessRows : partition) {
            QFilter omcToApFilter = CloseAcctHelper.getOmcToApFilter(dataEntity, splitSuccessRows, checkMap);
            DataSet omcToApBills = CloseAcctHelper.getCheckFailedBills("im_mdc_omcmplinbill", omcToApFilter);
            allOmcToApBills = CloseAcctHelper.mergeDataSet(allOmcToApBills, omcToApBills);
        }
        return CloseAcctHelper.getOmcToApCheckMsgMap(allOmcToApBills);
    }

    private static Map<String, Map<String, String>> getOmcToApCheckMsgMap(DataSet allOmcToApBills) {
        HashMap<String, Map<String, String>> failMsgMap = new HashMap<String, Map<String, String>>();
        if (allOmcToApBills == null) {
            return failMsgMap;
        }
        HashMap omcToApBillMap = new HashMap();
        for (Row bill : allOmcToApBills) {
            String formId = bill.getString("formid");
            String orgWarehouseKey = CloseAcctHelper.getOrgWarehouseKey(bill.getString("org"), bill.getString("warehouse"));
            omcToApBillMap.putIfAbsent(orgWarehouseKey, new HashMap());
            ((Map)omcToApBillMap.get(orgWarehouseKey)).putIfAbsent(formId, new HashSet());
            ((Set)((Map)omcToApBillMap.get(orgWarehouseKey)).get(formId)).add(bill.getString("billno"));
        }
        for (Map.Entry rowUnAuditBillEntry : omcToApBillMap.entrySet()) {
            String orgWarehouseKey = (String)rowUnAuditBillEntry.getKey();
            Map formUnAuditBillMap = (Map)rowUnAuditBillEntry.getValue();
            failMsgMap.putIfAbsent(orgWarehouseKey, new HashMap());
            for (Map.Entry formUnAuditBillEntry : formUnAuditBillMap.entrySet()) {
                String formId = (String)formUnAuditBillEntry.getKey();
                String billNo = StringUtils.join((Object[])((Set)formUnAuditBillEntry.getValue()).toArray(), (String)",");
                ((Map)failMsgMap.get(orgWarehouseKey)).put(CloseAcctHelper.getOmcCheckMsg(formId), billNo);
            }
        }
        return failMsgMap;
    }

    private static String getOmcCheckMsg(String formId) {
        StringBuilder failMsgBuilder = new StringBuilder();
        String billHint = CloseAccountConst.getNotConvertAp();
        failMsgBuilder.append(billHint).append("#").append(formId);
        String localEntityName = EntityMetadataCache.getDataEntityType((String)formId).getDisplayName().getLocaleValue();
        return String.format(failMsgBuilder.toString(), localEntityName);
    }

    public static Map<String, Map<String, String>> checkUnSettleBill(DynamicObjectCollection dataEntity, List<Integer> successRows, Map<String, Boolean> checkMap) {
        List<String> excludeBillS = Arrays.asList("im_locationtransfer", "im_assembbill", "im_disassemblebill", "im_adjustbill");
        ArrayList balBillList = new ArrayList(InvBalanceConst.getBalBillList());
        balBillList.removeAll(excludeBillS);
        QFilter billFilter = new QFilter("bill", "in", balBillList);
        Map settleCfgMap = BusinessDataServiceHelper.loadFromCache((String)"ism_interorgsettlecfg", (String)"bill", (QFilter[])billFilter.toArray());
        DataSet allCheckBills = null;
        HashSet<String> formIdSet = new HashSet<String>(16);
        for (Map.Entry settleCfg : settleCfgMap.entrySet()) {
            String formId;
            DynamicObject settleCfgValue = (DynamicObject)settleCfg.getValue();
            if (settleCfgValue == null || formIdSet.contains(formId = settleCfgValue.getString("bill_id"))) continue;
            formIdSet.add(formId);
            List partition = Lists.partition(successRows, (int)200);
            for (List splitSuccessRows : partition) {
                QFilter unSettleFilter = CloseAcctHelper.getUnSettleBillFilter(dataEntity, splitSuccessRows, formId, checkMap);
                DataSet checkBills = CloseAcctHelper.getCheckFailedBills(formId, unSettleFilter);
                allCheckBills = CloseAcctHelper.mergeDataSet(allCheckBills, checkBills);
            }
        }
        if (allCheckBills == null) {
            return new HashMap<String, Map<String, String>>();
        }
        HashMap checkBillMap = new HashMap(16);
        HashMap<Long, Map<String, Object>> billInfoMap = new HashMap<Long, Map<String, Object>>(16);
        for (Row checkBill : allCheckBills) {
            Long id = checkBill.getLong("id");
            String formId = checkBill.getString("formid");
            checkBillMap.putIfAbsent(formId, new HashSet());
            ((Set)checkBillMap.get(formId)).add(id);
            billInfoMap.putIfAbsent(id, new HashMap(16));
            Map billInfo = (Map)billInfoMap.get(id);
            billInfo.put("formid", checkBill.getString("formid"));
            billInfo.put("billno", checkBill.getString("billno"));
            billInfo.put("org", checkBill.getString("org"));
            Object wareHouse = billInfo.get("warehouse");
            if (wareHouse == null) {
                billInfo.put("warehouse", checkBill.getString("warehouse"));
                continue;
            }
            billInfo.put("warehouse", wareHouse + "#" + checkBill.getString("warehouse"));
        }
        Map settleResultMap = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"ism", (String)"SettleBillService", (String)"validateSettle", (Object[])new Object[]{checkBillMap});
        return CloseAcctHelper.getUnSettleCheckMsgMap(settleResultMap, billInfoMap);
    }

    private static Map<String, Map<String, String>> getUnSettleCheckMsgMap(Map<String, Set<Long>> settleResultMap, Map<Long, Map<String, Object>> billInfoMap) {
        HashMap<String, Map<String, String>> unSettleCheckMsgMap = new HashMap<String, Map<String, String>>();
        settleResultMap.forEach((settleResult, ids) -> {
            HashMap unSettleMsgMap = new HashMap();
            String settleMsg = null;
            if ("nosettle".equals(settleResult)) {
                settleMsg = CloseAccountConst.getNotSETTLE();
            } else if ("settlefail".equals(settleResult)) {
                settleMsg = CloseAccountConst.getSETTLEFAILED();
            }
            for (Long l : ids) {
                String[] splitWarehouses;
                Map billInfo = (Map)billInfoMap.get(l);
                String formId = (String)billInfo.get("formid");
                String billNo = (String)billInfo.get("billno");
                String warehouse = (String)billInfo.get("warehouse");
                for (String splitWarehouse : splitWarehouses = warehouse.split("#")) {
                    String orgWarehouseKey = CloseAcctHelper.getOrgWarehouseKey((String)billInfo.get("org"), splitWarehouse);
                    unSettleMsgMap.putIfAbsent(orgWarehouseKey, new HashMap());
                    ((Map)unSettleMsgMap.get(orgWarehouseKey)).putIfAbsent(formId, new HashSet(16));
                    ((Set)((Map)unSettleMsgMap.get(orgWarehouseKey)).get(formId)).add(billNo);
                }
            }
            for (Map.Entry entry : unSettleMsgMap.entrySet()) {
                unSettleCheckMsgMap.putIfAbsent((String)entry.getKey(), new HashMap());
                Map unSettleCheckMap = (Map)entry.getValue();
                for (Map.Entry unSettleChekEntry : unSettleCheckMap.entrySet()) {
                    String formId = (String)unSettleChekEntry.getKey();
                    String tipMsg = settleMsg + "#" + formId;
                    String localEntityName = EntityMetadataCache.getDataEntityType((String)formId).getDisplayName().getLocaleValue();
                    String billNo = StringUtils.join((Object[])((Set)unSettleChekEntry.getValue()).toArray(), (String)",");
                    ((Map)unSettleCheckMsgMap.get(entry.getKey())).put(String.format(tipMsg, localEntityName), billNo);
                }
            }
        });
        return unSettleCheckMsgMap;
    }

    private static DataSet getCheckFailedBills(String formId, QFilter billFilters) {
        String orgf = "org";
        String warehousef = "billentry.warehouse";
        DataSet dycs = CloseAcctHelper.getUnAuditBillDycs(billFilters, formId, orgf, warehousef);
        switch (formId) {
            case "im_transdirbill": {
                orgf = "outorg";
                warehousef = "billentry.outwarehouse";
                DataSet spDataSet = CloseAcctHelper.getUnAuditBillDycs(billFilters, formId, orgf, warehousef);
                dycs = CloseAcctHelper.mergeDataSet(dycs, spDataSet);
                break;
            }
            case "im_assembbill": 
            case "im_adjustbill": 
            case "im_disassemblebill": {
                orgf = "org";
                warehousef = "billentry.afterentity.warehouse1";
                dycs = CloseAcctHelper.mergeDataSet(dycs, CloseAcctHelper.getUnAuditBillDycs(billFilters, formId, orgf, warehousef));
                break;
            }
            case "im_transoutbill": {
                orgf = "org";
                warehousef = "billentry.inwarehouse";
                dycs = CloseAcctHelper.mergeDataSet(dycs, CloseAcctHelper.getUnAuditBillDycs(billFilters, formId, orgf, warehousef));
                orgf = "inorg";
                warehousef = "billentry.inwarehouse";
                dycs = CloseAcctHelper.mergeDataSet(dycs, CloseAcctHelper.getUnAuditBillDycs(billFilters, formId, orgf, warehousef));
                break;
            }
            case "im_transinbill": {
                orgf = "org";
                warehousef = "billentry.outwarehouse";
                dycs = CloseAcctHelper.mergeDataSet(dycs, CloseAcctHelper.getUnAuditBillDycs(billFilters, formId, orgf, warehousef));
                orgf = "outorg";
                warehousef = "billentry.outwarehouse";
                dycs = CloseAcctHelper.mergeDataSet(dycs, CloseAcctHelper.getUnAuditBillDycs(billFilters, formId, orgf, warehousef));
                break;
            }
            case "im_purinbill": 
            case "im_mdc_omcmplinbill": 
            case "im_mdc_ominbill": 
            case "im_ospurinbill": {
                orgf = "org";
                warehousef = "billentry.outwarehouse";
                dycs = CloseAcctHelper.mergeDataSet(dycs, CloseAcctHelper.getUnAuditBillDycs(billFilters, formId, orgf, warehousef));
                break;
            }
            case "im_saloutbill": {
                orgf = "org";
                warehousef = "billentry.inwarehouse";
                dycs = CloseAcctHelper.mergeDataSet(dycs, CloseAcctHelper.getUnAuditBillDycs(billFilters, formId, orgf, warehousef));
                break;
            }
        }
        return dycs;
    }

    private static DataSet mergeDataSet(DataSet dataSet1, DataSet dataSet2) {
        if (dataSet1 != null && dataSet2 != null) {
            return dataSet1.union(dataSet2);
        }
        if (dataSet1 != null) {
            return dataSet1;
        }
        if (dataSet2 != null) {
            return dataSet2;
        }
        return null;
    }

    private static void addFailRows(DynamicObjectCollection dataEntity, List<Integer> successRows, List<Integer> failRows, Map<String, DynamicObjectCollection> failedBillMap, String formId, DynamicObjectCollection failedBills) {
        ArrayList<String> orgWarehouseKeys = new ArrayList<String>(16);
        CloseAcctHelper.addOrgWarehouseKey(orgWarehouseKeys, failedBills);
        for (Integer item : successRows) {
            DynamicObject org = ((DynamicObject)dataEntity.get(item.intValue())).getDynamicObject("org");
            DynamicObject warehouse = ((DynamicObject)dataEntity.get(item.intValue())).getDynamicObject("warehouse");
            String orgWarehouseKey = org.getPkValue() + "," + warehouse.getPkValue();
            if (!orgWarehouseKeys.contains(orgWarehouseKey)) continue;
            failedBillMap.computeIfAbsent(formId, k -> new DynamicObjectCollection());
            if (!failedBillMap.get(formId).equals((Object)failedBills)) {
                failedBillMap.get(formId).addAll((Collection)failedBills);
            }
            failRows.add(item);
        }
    }

    public static void updateCloseRecord(DynamicObjectCollection dataEntity, List<Integer> successRows, List<DynamicObject> updateDycs, List<Integer> dateEqualLastDateRows, List<Integer> failRows) {
        successRows.removeAll(failRows);
        dateEqualLastDateRows.removeAll(failRows);
        CloseAcctHelper.updateCloseRecordDyc(dataEntity, dateEqualLastDateRows);
        ArrayList<Integer> dateNotEqualLastDateRows = new ArrayList<Integer>(successRows);
        dateNotEqualLastDateRows.removeAll(dateEqualLastDateRows);
        CloseAcctHelper.createRecordDycs(dataEntity, dateNotEqualLastDateRows, updateDycs);
    }

    public static void updateBalEndate(List<DynamicObject> closeRecordDycs) {
        ArrayList<Object[]> insertList = new ArrayList<Object[]>(closeRecordDycs.size() * 4);
        for (DynamicObject item : closeRecordDycs) {
            DynamicObject org = item.getDynamicObject("org");
            DynamicObject warehouse = item.getDynamicObject("warehouse");
            insertList.add(new Object[]{item.get("closedate"), org.getPkValue(), warehouse.getPkValue(), item.get("closedate")});
        }
        DB.executeBatch((DBRoute)new DBRoute("im"), (String)InvBalanceConst.getUpdateBalDateSql(), insertList);
    }

    private static DynamicObject getDynamicObject(String entityType, String name, Long id) {
        DynamicObject dyc = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityType));
        dyc.set("id", (Object)id);
        dyc.set("name", (Object)name);
        return dyc;
    }

    private static QFilter buildOrgWarehousesFilter(Map<Long, Set<Long>> orgWarehouseMap) {
        QFilter orgWarehouseFilters = null;
        for (Map.Entry<Long, Set<Long>> entry : orgWarehouseMap.entrySet()) {
            QFilter orgf = new QFilter("org.id", "=", (Object)entry.getKey());
            QFilter orgWarehousef = new QFilter("warehouse.id", "in", (Object)entry.getValue().toArray());
            orgWarehousef.and(orgf);
            orgWarehouseFilters = orgWarehouseFilters == null ? orgWarehousef : orgWarehouseFilters.or(orgWarehousef);
        }
        return orgWarehouseFilters;
    }

    public static DataSet getUnAuditBillDycs(QFilter orgWarehouseFilters, String formId, String orgf, String warehousef) {
        orgf = orgf + " " + "org";
        warehousef = warehousef + " " + "warehouse";
        String formIdf = "'" + formId + "' as formid";
        String[] groups = Arrays.asList("formid", "org", "warehouse", "id", "billno", "billstatus").toArray(new String[0]);
        String selectProperties = StringUtils.join((Object[])Arrays.asList(formIdf, orgf, warehousef, "id", "billno", "billstatus").toArray(new String[0]), (String)",");
        if (orgWarehouseFilters != null) {
            return QueryServiceHelper.queryDataSet((String)(formId + orgf + warehousef), (String)formId, (String)selectProperties, (QFilter[])orgWarehouseFilters.toArray(), null).groupBy(groups).finish();
        }
        return null;
    }

    private static QFilter getOrgWarehouseDateFilters(DynamicObjectCollection dataEntity, List<Integer> successRows, String formId) {
        QFilter closef = null;
        for (Integer item : successRows) {
            closef = CloseAcctHelper.buildOrgWarehouseDateFilter(dataEntity, item, closef, true, false, "billentry.", null);
            switch (formId) {
                case "im_transdirbill": {
                    closef = CloseAcctHelper.buildOrgWarehouseDateFilter(dataEntity, item, closef, true, true, "billentry.", formId);
                    break;
                }
                case "im_assembbill": 
                case "im_adjustbill": 
                case "im_disassemblebill": {
                    closef = CloseAcctHelper.buildOrgWarehouseDateFilter(dataEntity, item, closef, true, false, "billentry.afterentity.", formId);
                    break;
                }
                case "im_transoutbill": {
                    closef = CloseAcctHelper.buildOrgWarehouseDateFilter(dataEntity, item, closef, true, true, "billentry.", formId);
                    break;
                }
                case "im_transinbill": {
                    closef = CloseAcctHelper.buildOrgWarehouseDateFilter(dataEntity, item, closef, true, false, "billentry.", formId);
                    break;
                }
                case "im_purinbill": 
                case "im_mdc_omcmplinbill": 
                case "im_mdc_ominbill": 
                case "im_ospurinbill": {
                    closef = CloseAcctHelper.buildOrgWarehouseDateFilter(dataEntity, item, closef, true, false, "billentry.", formId);
                    break;
                }
                case "im_saloutbill": {
                    closef = CloseAcctHelper.buildOrgWarehouseDateFilter(dataEntity, item, closef, true, true, "billentry.", formId);
                    break;
                }
            }
        }
        Map mdcBillTypeMap = InvBalanceConst.getMdcBillTypeMap();
        String billType = (String)mdcBillTypeMap.get(formId);
        if (billType != null && closef != null) {
            ArrayList<String> billTypes = new ArrayList<String>();
            DynamicObjectCollection bosBillTypes = QueryServiceHelper.query((String)"bos_billtype", (String)"number", (QFilter[])new QFilter[]{new QFilter("billformid", "=", (Object)formId)});
            if (bosBillTypes == null || bosBillTypes.size() == 0) {
                closef.and("billtype.number", "=", (Object)billType);
                return closef;
            }
            for (DynamicObject bosBillType : bosBillTypes) {
                billTypes.add(bosBillType.getString("number"));
            }
            closef.and("billtype.number", "in", billTypes);
        }
        return closef;
    }

    private static QFilter getUnAuditBillFilter(DynamicObjectCollection dataEntity, List<Integer> successRows, String formId, Map<String, Boolean> checkMap) {
        QFilter orgWarehouseDateFilter = CloseAcctHelper.getOrgWarehouseDateFilters(dataEntity, successRows, formId);
        if (orgWarehouseDateFilter != null) {
            if (Boolean.FALSE.equals(checkMap.get("checkboxsave")) && Boolean.FALSE.equals(checkMap.get("checkboxsubmit"))) {
                return null;
            }
            MainEntityType dataType = MetadataServiceHelper.getDataEntityType((String)formId);
            IDataEntityProperty invSchemeType = dataType.findProperty("invscheme");
            QFilter unAuditFilter = CloseAcctHelper.getUnAuditFilter(checkMap);
            if (invSchemeType != null) {
                QFilter invSchemeF = new QFilter("invscheme.isnotupdate", "=", (Object)false);
                orgWarehouseDateFilter = unAuditFilter == null ? null : orgWarehouseDateFilter.and(unAuditFilter).and(invSchemeF);
            } else {
                orgWarehouseDateFilter = unAuditFilter == null ? null : orgWarehouseDateFilter.and(unAuditFilter);
            }
        }
        return orgWarehouseDateFilter;
    }

    private static QFilter getUnSettleBillFilter(DynamicObjectCollection dataEntity, List<Integer> successRows, String formId, Map<String, Boolean> checkMap) {
        QFilter orgWarehouseDateFilter = CloseAcctHelper.getOrgWarehouseDateFilters(dataEntity, successRows, formId);
        if (orgWarehouseDateFilter != null) {
            if (Boolean.FALSE.equals(checkMap.get("checksettlestatus"))) {
                return null;
            }
            QFilter qFilter = new QFilter("isvirtualbill", "=", (Object)"0").or(BIZ_DOMAIN, "=", (Object)"6");
            orgWarehouseDateFilter = orgWarehouseDateFilter.and("billstatus", "=", (Object)BILL_STATUS_AUDIT).and(qFilter);
        }
        return orgWarehouseDateFilter;
    }

    private static QFilter getOmcToApFilter(DynamicObjectCollection dataEntity, List<Integer> successRows, Map<String, Boolean> checkMap) {
        QFilter orgWarehouseDateFilter = CloseAcctHelper.getOrgWarehouseDateFilters(dataEntity, successRows, "im_mdc_omcmplinbill");
        if (orgWarehouseDateFilter != null) {
            if (Boolean.FALSE.equals(checkMap.get("checkomctoap"))) {
                return null;
            }
            orgWarehouseDateFilter = orgWarehouseDateFilter.and(UNVERIFYBASEQTY, "!=", (Object)0).and("hasapbusbill", "=", (Object)"0").and("billstatus", "=", (Object)BILL_STATUS_AUDIT);
        }
        return orgWarehouseDateFilter;
    }

    private static QFilter getUnAuditFilter(Map<String, Boolean> checkMap) {
        QFilter unAuditFilter = null;
        if (checkMap.get("checkboxsave").booleanValue() && !checkMap.get("checkboxsubmit").booleanValue()) {
            unAuditFilter = new QFilter("billstatus", "=", (Object)EnumBillStatus.A);
        } else if (!checkMap.get("checkboxsave").booleanValue() && checkMap.get("checkboxsubmit").booleanValue()) {
            unAuditFilter = new QFilter("billstatus", "=", (Object)EnumBillStatus.B);
        } else if (checkMap.get("checkboxsave").booleanValue() && checkMap.get("checkboxsubmit").booleanValue()) {
            ArrayList<String> billstatus = new ArrayList<String>(2);
            billstatus.add(EnumBillStatus.A.toString());
            billstatus.add(EnumBillStatus.B.toString());
            unAuditFilter = new QFilter("billstatus", "in", billstatus);
        }
        return unAuditFilter;
    }

    private static void addOrgWarehouseKey(List<String> keys, DynamicObjectCollection dycs) {
        for (DynamicObject item : dycs) {
            keys.add(item.getString("org") + "," + item.getString("warehouse"));
        }
    }

    private static QFilter buildOrgWarehouseDateFilter(DynamicObjectCollection dataEntity, Integer rowIndex, QFilter closef, boolean includeDate, Boolean isOutOrgWarehouse, String entryPre, String formId) {
        if ("im_transoutbill".equals(formId) || "im_transinbill".equals(formId)) {
            closef = CloseAcctHelper.buildTransQfilter(dataEntity, rowIndex, closef, includeDate, isOutOrgWarehouse, entryPre);
        } else if ("im_purinbill".equals(formId) || "im_saloutbill".equals(formId) || "im_mdc_omcmplinbill".equals(formId) || "im_mdc_ominbill".equals(formId) || "im_ospurinbill".equals(formId)) {
            closef = CloseAcctHelper.buildPurAndSalQfilter(dataEntity, rowIndex, closef, includeDate, isOutOrgWarehouse, entryPre);
        } else {
            String orgf = isOutOrgWarehouse != false ? "outorg" : "org";
            String warehousef = isOutOrgWarehouse != false ? entryPre + "outwarehouse" : entryPre + "warehouse";
            warehousef = entryPre.contains("afterentity") ? warehousef + "1" : warehousef;
            QFilter tmpf = CloseAcctHelper.getOrgAndWhouseQfilter(dataEntity, rowIndex, includeDate, orgf, warehousef);
            closef = CloseAcctHelper.addTmpQfilter(closef, tmpf);
        }
        return closef;
    }

    private static QFilter buildPurAndSalQfilter(DynamicObjectCollection dataEntity, Integer rowIndex, QFilter closef, boolean includeDate, Boolean isOutOrgWarehouse, String entryPre) {
        QFilter transTmpfTwo = null;
        transTmpfTwo = isOutOrgWarehouse != false ? CloseAcctHelper.getOrgAndWhouseQfilter(dataEntity, rowIndex, includeDate, "org", entryPre + "inwarehouse") : CloseAcctHelper.getOrgAndWhouseQfilter(dataEntity, rowIndex, includeDate, "org", entryPre + "outwarehouse");
        return CloseAcctHelper.addTmpQfilter(closef, transTmpfTwo);
    }

    private static QFilter buildTransQfilter(DynamicObjectCollection dataEntity, Integer rowIndex, QFilter closef, boolean includeDate, boolean isOutOrgWarehouse, String entryPre) {
        QFilter transTmpfOne = null;
        QFilter transTmpfTwo = null;
        if (isOutOrgWarehouse) {
            transTmpfOne = CloseAcctHelper.getOrgAndWhouseQfilter(dataEntity, rowIndex, includeDate, "org", entryPre + "inwarehouse");
            transTmpfTwo = CloseAcctHelper.getOrgAndWhouseQfilter(dataEntity, rowIndex, includeDate, "inorg", entryPre + "inwarehouse");
        } else {
            transTmpfOne = CloseAcctHelper.getOrgAndWhouseQfilter(dataEntity, rowIndex, includeDate, "org", entryPre + "outwarehouse");
            transTmpfTwo = CloseAcctHelper.getOrgAndWhouseQfilter(dataEntity, rowIndex, includeDate, "outorg", entryPre + "outwarehouse");
        }
        return CloseAcctHelper.addTmpQfilter(closef, transTmpfOne, transTmpfTwo);
    }

    private static QFilter addTmpQfilter(QFilter closef, QFilter ... transTmpfOnes) {
        for (QFilter qFilter : transTmpfOnes) {
            if (qFilter == null) continue;
            closef = closef == null ? qFilter : closef.or(qFilter);
        }
        return closef;
    }

    private static QFilter getOrgAndWhouseQfilter(DynamicObjectCollection dataEntity, Integer rowIndex, boolean includeDate, String orgf, String warehousef) {
        DynamicObject org = ((DynamicObject)dataEntity.get(rowIndex.intValue())).getDynamicObject("org");
        DynamicObject warehouse = ((DynamicObject)dataEntity.get(rowIndex.intValue())).getDynamicObject("warehouse");
        if (org == null || warehouse == null) {
            return null;
        }
        QFilter tmpf = new QFilter(orgf, "=", org.getPkValue());
        tmpf.and(new QFilter(warehousef, "=", warehouse.getPkValue()));
        if (includeDate) {
            Date lastDate = ((DynamicObject)dataEntity.get(rowIndex.intValue())).getDate("lastclosedate");
            Date date = ((DynamicObject)dataEntity.get(rowIndex.intValue())).getDate("closedate");
            Date closeDate = DateUtils.getDayStartTime((Date)DateUtils.addOneDay((Date)date));
            QFilter closeDatef = new QFilter("bookdate", "<", (Object)closeDate);
            tmpf.and(closeDatef);
            if (lastDate != null) {
                QFilter lastDatef = new QFilter("bookdate", ">", (Object)lastDate);
                tmpf.and(lastDatef);
            }
        }
        return tmpf;
    }

    private static QFilter buildOrgWarehouseFilter(QFilter closef, Object orgId, Object warehouseId, String orgf, String warehousef) {
        QFilter tmpf = new QFilter(orgf, "=", orgId);
        tmpf.and(new QFilter(warehousef, "=", warehouseId));
        closef = closef == null ? tmpf : closef.or(tmpf);
        return closef;
    }

    private static void createRecordDycs(DynamicObjectCollection dataEntity, List<Integer> dateNotEqualLastDateRows, List<DynamicObject> updateDycs) {
        for (Integer item : dateNotEqualLastDateRows) {
            DynamicObject newRecord = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"im_closeaccountrecord"));
            DynamicObject org = ((DynamicObject)dataEntity.get(item.intValue())).getDynamicObject("org");
            DynamicObject warehouse = ((DynamicObject)dataEntity.get(item.intValue())).getDynamicObject("warehouse");
            Date closeDate = ((DynamicObject)dataEntity.get(item.intValue())).getDate("closedate");
            newRecord.set("org", (Object)org);
            newRecord.set("warehouse", (Object)warehouse);
            closeDate = closeDate == null ? DateUtils.getDayStartTime((Date)new Date()) : closeDate;
            newRecord.set("closedate", (Object)DateUtils.getDate((Date)closeDate));
            updateDycs.add(newRecord);
        }
    }

    private static QFilter buildCloseFilter(DynamicObject[] orgWarehouses) {
        QFilter closef = null;
        for (DynamicObject item : orgWarehouses) {
            DynamicObject orgDyc = item.getDynamicObject("org");
            DynamicObject warehouseDyc = item.getDynamicObject("warehouse");
            if (CommonUtils.isNull((Object)orgDyc) || CommonUtils.isNull((Object)warehouseDyc)) continue;
            Object orgId = orgDyc.getPkValue();
            Object warehouseId = warehouseDyc.getPkValue();
            closef = CloseAcctHelper.buildOrgWarehouseFilter(closef, orgId, warehouseId, "org", "warehouse");
        }
        return closef;
    }

    private static Map<Long, Set<Long>> getOrgWarehouseMap(DynamicObjectCollection dataEntity, int[] selectRows) {
        HashMap<Long, Set<Long>> orgWarehouseMap = new HashMap<Long, Set<Long>>();
        int[] nArray = selectRows;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer item = nArray[i];
            DynamicObject orgDyc = ((DynamicObject)dataEntity.get(item.intValue())).getDynamicObject("org");
            DynamicObject warehouseDyc = ((DynamicObject)dataEntity.get(item.intValue())).getDynamicObject("warehouse");
            orgWarehouseMap.computeIfAbsent((Long)orgDyc.getPkValue(), k -> new HashSet());
            ((Set)orgWarehouseMap.get(orgDyc.getPkValue())).add((Long)warehouseDyc.getPkValue());
        }
        return orgWarehouseMap;
    }

    private static void updateCloseRecordDyc(DynamicObjectCollection dataEntity, List<Integer> dateEqualLastDateRows) {
        DynamicObject[] closeRecordDycs;
        QFilter lastDatef = null;
        for (Integer item : dateEqualLastDateRows) {
            DynamicObject orgDyc = ((DynamicObject)dataEntity.get(item.intValue())).getDynamicObject("org");
            DynamicObject warehouseDyc = ((DynamicObject)dataEntity.get(item.intValue())).getDynamicObject("warehouse");
            if (orgDyc == null || warehouseDyc == null) continue;
            Date closeDate = ((DynamicObject)dataEntity.get(item.intValue())).getDate("closedate");
            QFilter tmpf = new QFilter("org", "=", orgDyc.getPkValue());
            tmpf.and(new QFilter("warehouse", "=", warehouseDyc.getPkValue()));
            tmpf.and(new QFilter("closedate", "=", (Object)DateUtils.getDate((Date)closeDate)));
            lastDatef = lastDatef == null ? tmpf : lastDatef.or(tmpf);
        }
        if (lastDatef == null) {
            return;
        }
        lastDatef.and(new QFilter("isdelete", "=", (Object)true));
        for (DynamicObject closeDyc : closeRecordDycs = BusinessDataServiceHelper.load((String)"im_closeaccountrecord", (String)"isdelete", (QFilter[])lastDatef.toArray())) {
            closeDyc.set("isdelete", (Object)false);
        }
        SaveServiceHelper.save((DynamicObject[])closeRecordDycs);
    }
}

