/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;

public abstract class AbstractImService {
    protected Map<String, String> BASEDATA_MAP_FIELDS = new HashMap<String, String>(16);
    protected Set<String> BASEDATA_FIELDS = new HashSet<String>(16);
    protected Set<String> DATE_FIELDS = new HashSet<String>(4);
    protected Set<String> MUST_INPUT_STRINGS = new HashSet<String>(8);
    protected ApiResult apiResultCheck = new ApiResult();

    protected ApiResult checkInputParams(LinkedHashMap<String, Object> param, QFilter ... qFilters) {
        return this.checkBaseDataInputParamFormat(param, this.BASEDATA_FIELDS, qFilters);
    }

    protected ApiResult checkInputParams(LinkedHashMap<String, Object> param, Set<String> must_input_strings, QFilter ... qFilters) {
        this.checkMustInput(param, must_input_strings);
        if (!this.apiResultCheck.getSuccess()) {
            return this.apiResultCheck;
        }
        return this.checkInputParams(param, qFilters);
    }

    protected ApiResult checkMustInput(LinkedHashMap<String, Object> param, Set<String> must_input_strings) {
        Set<String> setParam = param.keySet();
        must_input_strings.removeAll(setParam);
        if (!must_input_strings.isEmpty()) {
            this.apiResultCheck = ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53c2\u6570\u201c%s\u201d\u3002", (String)"InvAccQueryApiService_0", (String)"scmc-im-webapi", (Object[])new Object[0]), must_input_strings), (String)"001");
        }
        return this.apiResultCheck;
    }

    protected void setSpecailFiledValueByInput(String billformId) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billformId);
        Map allFiledsInfo = dataEntityType.getAllFields();
        for (Map.Entry entry : allFiledsInfo.entrySet()) {
            if (entry.getValue() instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)entry.getValue();
                String entityId = basedataProp.getBaseEntityId();
                this.BASEDATA_MAP_FIELDS.put((String)entry.getKey(), entityId);
                continue;
            }
            if (!(entry.getValue() instanceof DateTimeProp)) continue;
            this.DATE_FIELDS.add((String)entry.getKey());
        }
    }

    protected ApiResult checkBaseDataInputParamFormat(LinkedHashMap<String, Object> param, Set<String> BASEDATA_FIELDS, QFilter ... qFilter) {
        if (qFilter != null && qFilter.length > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"qFilter\u53d8\u957f\u53c2\u6570\u4e2a\u6570\u4e0d\u80fd\u5927\u4e8e1\u3002", (String)"AbstractImService_0", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        HashSet<String> errorInfo = new HashSet<String>();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            String inputKey = entry.getKey();
            if (!BASEDATA_FIELDS.contains(inputKey)) continue;
            LinkedHashMap inputBaseData = (LinkedHashMap)param.get(inputKey);
            Object id_value = inputBaseData.get("id");
            String number_valuse = (String)inputBaseData.get("number");
            if (id_value == null && number_valuse == null) {
                errorInfo.add(inputKey);
                continue;
            }
            if (number_valuse != null && qFilter != null) {
                qFilter[0].and(inputKey + ".number", "in", Arrays.asList(number_valuse.split(",")));
            }
            if (id_value == null || qFilter == null) continue;
            if (id_value instanceof String) {
                String[] idStrings = ((String)id_value).split(",");
                long[] ids = new long[idStrings.length];
                for (int i = 0; i < ids.length; ++i) {
                    ids[i] = Long.parseLong(idStrings[i]);
                }
                qFilter[0].and(inputKey, "in", (Object)ids);
                continue;
            }
            if (id_value instanceof Set || id_value instanceof List) {
                qFilter[0].and(inputKey, "in", id_value);
                continue;
            }
            qFilter[0].and(inputKey, "=", id_value);
        }
        if (errorInfo.size() == 0) {
            return this.apiResultCheck;
        }
        this.apiResultCheck = ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u7684\u201c%s\u201d\u884c\u683c\u5f0f\u6709\u8bef\u3002", (String)"InvAccQueryApiService_2", (String)"scmc-im-webapi", (Object[])new Object[0]), errorInfo), (String)"099");
        return this.apiResultCheck;
    }

    protected ApiResult checkNotExistFiled(Set<String> BILL_ALL_FIELDS, LinkedHashMap<String, Object> param) {
        HashSet<String> errorInfo = new HashSet<String>();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            String key = entry.getKey();
            if (BILL_ALL_FIELDS.contains(key)) continue;
            errorInfo.add(key);
        }
        if (errorInfo.size() == 0) {
            return this.apiResultCheck;
        }
        this.apiResultCheck = ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u672a\u50a8\u5b58\u8f93\u5165\u53c2\u6570\u201c%s\u201d\u7684\u76f8\u5173\u4fe1\u606f,\u8bf7\u66f4\u6362\u67e5\u8be2\u6761\u4ef6\u3002", (String)"InvAccQueryApiService_1", (String)"scmc-im-webapi", (Object[])new Object[0]), errorInfo), (String)"020");
        return this.apiResultCheck;
    }
}

