/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.api;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.api.AbstractImService;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.sbs.business.reservation.ReserveHelper;

public class InvRealAccQueryService
extends AbstractImService {
    private QFilter structureQFilter = new QFilter("1", "=", (Object)1);
    private static final Set<String> excludeQtyFiledDispaly = new HashSet<String>();
    private static final String ALGOKEY;
    private Set<String> ALL_INV_ACC_FIELDS;
    private static Log logger;

    public InvRealAccQueryService() {
        this.MUST_INPUT_STRINGS.add("material");
        this.MUST_INPUT_STRINGS.add("org");
        this.ALL_INV_ACC_FIELDS = null;
    }

    public ApiResult invAccQuery(Map<String, Object> params) {
        logger.info("\u3010\u67e5\u8be2\u5373\u65f6\u5e93\u5b58\u670d\u52a1\u3011traceId\u4e3a\uff1a" + RequestContext.get().getTraceId() + "\u8f93\u5165\u53c2\u6570\u4e3a\uff1a" + params.toString());
        this.initInvAccFields();
        LinkedHashMap param = (LinkedHashMap)params.get("data");
        this.checkInputParams((LinkedHashMap<String, Object>)param, this.MUST_INPUT_STRINGS, this.structureQFilter);
        if (!this.apiResultCheck.getSuccess()) {
            return this.apiResultCheck;
        }
        this.initStructureQFilter(param);
        List<Map<String, Object>> returnData = this.getReturnData(params);
        return ApiResult.success(returnData);
    }

    public List<Map<String, Object>> invAccQueryExtForInner(Map<String, Object> params) {
        logger.info("\u3010\u67e5\u8be2\u5373\u65f6\u5e93\u5b58\u670d\u52a1\u3011traceId\u4e3a\uff1a" + RequestContext.get().getTraceId() + "\u8f93\u5165\u53c2\u6570\u4e3a\uff1a" + params.toString());
        this.initInvAccFields();
        LinkedHashMap param = (LinkedHashMap)params.get("data");
        this.checkInputParams((LinkedHashMap<String, Object>)param, this.MUST_INPUT_STRINGS, this.structureQFilter);
        if (!this.apiResultCheck.getSuccess()) {
            return null;
        }
        this.initStructureQFilter(param);
        List<Map<String, Object>> returnData = this.getReturnData(params);
        return returnData;
    }

    private List<Map<String, Object>> getReturnData(Map<String, Object> params) {
        DataSet invAccDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)InvAccConst.getBalTb(), (String)String.join((CharSequence)",", this.ALL_INV_ACC_FIELDS), (QFilter[])this.structureQFilter.toArray(), null);
        ArrayList<Map<String, Object>> returnData = new ArrayList<Map<String, Object>>(15);
        invAccDataSet = ReserveHelper.getAvbbaseqty((DataSet)invAccDataSet);
        invAccDataSet = invAccDataSet.filter("baseqty != 0 or qty != 0 or qty2nd !=0");
        Set<String> invAccDaaSetFileds = InvRealAccQueryService.getDataSetField(invAccDataSet);
        while (invAccDataSet.hasNext()) {
            Row row = invAccDataSet.next();
            HashMap<String, Object> rowDataParse = new HashMap<String, Object>(32);
            for (String field : invAccDaaSetFileds) {
                Object fieldValue = row.get(field);
                if (excludeQtyFiledDispaly.contains(field)) continue;
                if (fieldValue instanceof BigDecimal && ((BigDecimal)fieldValue).compareTo(BigDecimal.ZERO) == 0) {
                    rowDataParse.put(field, ((BigDecimal)fieldValue).intValue());
                    continue;
                }
                rowDataParse.put(field, row.get(field));
            }
            returnData.add(rowDataParse);
        }
        return returnData;
    }

    private void initStructureQFilter(LinkedHashMap<String, Object> param) {
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            String key = entry.getKey();
            if (this.BASEDATA_FIELDS.contains(key)) continue;
            this.structureQFilter.and(key, "=", entry.getValue());
        }
    }

    @Override
    public ApiResult checkInputParams(LinkedHashMap<String, Object> param, Set<String> must_input_strings, QFilter ... qFilters) {
        super.checkInputParams(param, must_input_strings, qFilters);
        if (!this.apiResultCheck.getSuccess()) {
            return this.apiResultCheck;
        }
        return this.checkNotExistFiled(this.ALL_INV_ACC_FIELDS, param);
    }

    private void initInvAccFields() {
        Map invAccMapFieldInfo = EntityMetadataCache.getDataEntityType((String)InvAccConst.getBalTb()).getAllFields();
        if (this.ALL_INV_ACC_FIELDS == null) {
            HashSet setTmp = new HashSet(invAccMapFieldInfo.keySet());
            this.ALL_INV_ACC_FIELDS = setTmp;
            this.ALL_INV_ACC_FIELDS.add("id");
        }
        for (Map.Entry entry : invAccMapFieldInfo.entrySet()) {
            if (!(entry.getValue() instanceof BasedataProp)) continue;
            this.BASEDATA_FIELDS.add(entry.getKey());
        }
    }

    private static Set<String> getDataSetField(DataSet dataSet) {
        Field[] fields = dataSet.getRowMeta().getFields();
        LinkedHashSet<String> fs = new LinkedHashSet<String>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fields[i].getName();
            fs.add(fieldName);
        }
        return fs;
    }

    static {
        excludeQtyFiledDispaly.add("lockqty");
        excludeQtyFiledDispaly.add("lockbaseqty");
        excludeQtyFiledDispaly.add("lockqty2nd");
        excludeQtyFiledDispaly.add("avbqty");
        excludeQtyFiledDispaly.add("avbqty2nd");
        ALGOKEY = InvRealAccQueryService.class.getName();
        logger = LogFactory.getLog(InvRealAccQueryService.class);
    }
}

