/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.calcost;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.helper.calcost.CalcExprHelper;
import kd.scmc.im.business.helper.calcost.filter.QueryPriceOrgFilter;
import kd.scmc.im.consts.QueryCalCostConst;

public class CalCostHelper {
    private static final String SELECT_PROPERTIES = "number, enable, billentrykey, filterformula_tag, filterjson_tag, iscostmainaccount, accounttype, costaccount, costcolsmapentry.costrecordfield, costcolsmapentry.costrecordfieldkey, costcolsmapentry.imbillfield, costcolsmapentry.imbillfieldkey";
    private static final String PRICE_SELECT_PROPERTIES = "number, enable, billentrykey, priceobject, billfilterscript_tag, pricefieldkey, exratedatefieldkey, exratetable, amountcalentry, amountcalentry.amountfieldkey, amountcalentry.formulascript_tag, orgentry, orgentry.org, orgentry.isincludesuborg";
    private static final int SPLIT_NUMS = 1000;

    public static void setImBillCalCost(Map<String, Object> param) {
        String operationKey;
        Set billIds = (Set)param.get("billIds");
        String entityName = (String)param.get("entityName");
        QFilter qFilter = new QFilter("imbill", "=", (Object)entityName).and("operation", "=", (Object)(operationKey = (String)param.get("operationKey")));
        DynamicObject[] costConfigs = BusinessDataServiceHelper.load((String)"im_costpriceconf", (String)SELECT_PROPERTIES, (QFilter[])qFilter.toArray());
        if (costConfigs.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u5355\u636e\u672a\u914d\u7f6e\u83b7\u53d6\u6210\u672c\u914d\u7f6e\uff0c\u83b7\u53d6\u6210\u672c\u5931\u8d25\u3002", (String)"CalCostHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        HashSet<DynamicObject> enableCostConfigs = new HashSet<DynamicObject>(16);
        for (DynamicObject costConfig : costConfigs) {
            boolean enable = costConfig.getBoolean("enable");
            if (!enable) continue;
            enableCostConfigs.add(costConfig);
        }
        if (enableCostConfigs.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u5355\u636e\u7684\u6210\u672c\u914d\u7f6e\u5df2\u88ab\u7981\u7528\uff0c\u83b7\u53d6\u6210\u672c\u5931\u8d25\u3002", (String)"CalCostHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        List<List<Long>> splitIdList = CalCostHelper.getSplitIdList(billIds);
        HashMap allDataEntityMap = new HashMap(16);
        for (List<Long> idList : splitIdList) {
            Map dataEntityMap = BusinessDataServiceHelper.loadFromCache((Object[])idList.toArray(), (String)entityName);
            allDataEntityMap.putAll(dataEntityMap);
        }
        HashMap<Long, DynamicObject> entryConfigMap = new HashMap<Long, DynamicObject>(16);
        HashSet<DynamicObject> matchDymS = new HashSet<DynamicObject>(16);
        HashSet<DynamicObject> unMatchDymS = new HashSet<DynamicObject>(16);
        for (DynamicObject dynamicObject : enableCostConfigs) {
            String string = dynamicObject.getString("filterformula_tag");
            String billEntryKey = dynamicObject.getString("billentrykey");
            for (Map.Entry dataEntityMap : allDataEntityMap.entrySet()) {
                DynamicObject dataEntity = (DynamicObject)dataEntityMap.getValue();
                MainEntityType entityType = (MainEntityType)dataEntity.getDataEntityType();
                DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    if ("afterentity".equals(billEntryKey)) {
                        DynamicObjectCollection afterEntrys = entry.getDynamicObjectCollection(billEntryKey);
                        for (DynamicObject afterEntry : afterEntrys) {
                            CalCostHelper.isMatchEntry(afterEntry, dynamicObject, entityType, string, entryConfigMap);
                        }
                        continue;
                    }
                    CalCostHelper.isMatchEntry(entry, dynamicObject, entityType, string, entryConfigMap);
                }
            }
        }
        Set matchEntryIds = entryConfigMap.keySet();
        for (Map.Entry entry : allDataEntityMap.entrySet()) {
            DynamicObject dataEntity = (DynamicObject)entry.getValue();
            HashSet<Long> hashSet = new HashSet<Long>(16);
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("billentry");
            for (DynamicObject entry2 : entrys) {
                hashSet.add(entry2.getLong("id"));
                if (!entry2.getDataEntityType().getProperties().containsKey((Object)"afterentity")) continue;
                DynamicObjectCollection afterEntrys = entry2.getDynamicObjectCollection("afterentity");
                for (DynamicObject afterEntry : afterEntrys) {
                    hashSet.add(afterEntry.getLong("id"));
                }
            }
            if (!hashSet.removeAll(matchEntryIds)) {
                unMatchDymS.add(dataEntity);
                continue;
            }
            matchDymS.add(dataEntity);
        }
        if (!unMatchDymS.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (DynamicObject unMatchDym : unMatchDymS) {
                stringBuilder.append(unMatchDym.getString("billno"));
                stringBuilder.append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(","));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u5728\u6210\u672c\u914d\u7f6e\u7684\u6570\u636e\u8303\u56f4\uff0c\u83b7\u53d6\u6210\u672c\u5931\u8d25\u3002", (String)"CalCostHelper_3", (String)"scmc-im-business", (Object[])new Object[0]), stringBuilder));
        }
        Map<DynamicObject, Set<Long>> map = CalCostHelper.getConfigEntryMap(entryConfigMap);
        HashMap<Object, Map<String, Object>> hashMap = new HashMap<Object, Map<String, Object>>(16);
        for (Map.Entry entry : map.entrySet()) {
            DynamicObject costConfig = (DynamicObject)entry.getKey();
            Set entryIds = (Set)entry.getValue();
            String billEntryKey = costConfig.getString("billentrykey");
            DynamicObjectCollection costColsMapEntryS = costConfig.getDynamicObjectCollection("costcolsmapentry");
            if (costColsMapEntryS.isEmpty()) continue;
            Map<String, String> colsMap = CalCostHelper.getColsMap(costColsMapEntryS);
            List<Map<String, Object>> costFieldMapList = CalCostHelper.getCostFieldMapList(entityName, costConfig, entryIds);
            if (costFieldMapList.isEmpty()) continue;
            Map<Object, Map<String, Object>> imBillValueList = CalCostHelper.getImBillValueList(colsMap, costFieldMapList);
            hashMap.putAll(imBillValueList);
        }
        if (hashMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u6838\u7b97\u6210\u672c\u4e3a\u7a7a\u3002", (String)"CalCostHelper_2", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        List transformBills = QueryCalCostConst.getTransformBill();
        for (DynamicObject matchDym : matchDymS) {
            DynamicObjectCollection entryS = matchDym.getDynamicObjectCollection("billentry");
            CalCostHelper.setBillEntryField(entityName, entryS, hashMap);
            if (!transformBills.contains(entityName)) continue;
            for (DynamicObject entry : entryS) {
                DynamicObjectCollection afterEntrys = entry.getDynamicObjectCollection("afterentity");
                CalCostHelper.setBillEntryField(entityName, afterEntrys, hashMap);
            }
        }
        SaveServiceHelper.update((DynamicObject[])matchDymS.toArray(new DynamicObject[0]));
    }

    public static void queryPrice(Map<String, Object> param) {
        Set billIds = (Set)param.get("billIds");
        String entityName = (String)param.get("entityName");
        String operationKey = (String)param.get("operationKey");
        String modelType = (String)param.get("modelType");
        DynamicObject bill = (DynamicObject)param.get("bill");
        Object fromDatabase = param.get("fromDatabase");
        QFilter qFilter = new QFilter("imbill", "=", (Object)entityName).and("operation", "=", (Object)operationKey).and("enable", "=", (Object)"1");
        DynamicObject[] priceConfigs = BusinessDataServiceHelper.load((String)"im_priceconf", (String)PRICE_SELECT_PROPERTIES, (QFilter[])qFilter.toArray());
        if (priceConfigs.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u83b7\u53d6\u5355\u4f4d\u6210\u672c\u914d\u7f6e\uff0c\u83b7\u53d6\u5355\u4f4d\u6210\u672c\u5931\u8d25\u3002", (String)"CalCostHelper_4", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        if (priceConfigs.length > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u4f4d\u6210\u672c\u914d\u7f6e\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"CalCostHelper_8", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        DynamicObject priceConfig = priceConfigs[0];
        boolean enable = priceConfig.getBoolean("enable");
        if (!enable) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u4f4d\u6210\u672c\u914d\u7f6e\u5df2\u88ab\u7981\u7528\uff0c\u83b7\u53d6\u5355\u4f4d\u6210\u672c\u5931\u8d25\u3002", (String)"CalCostHelper_5", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        if (billIds.isEmpty()) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject[] bills = "bill".equals(modelType) ? new DynamicObject[]{bill} : BusinessDataServiceHelper.load((Object[])billIds.toArray(), (DynamicObjectType)entityType);
        List<DynamicObject> applyOrgBills = QueryPriceOrgFilter.filterByApplyOrg(entityType, priceConfig, bills);
        List<Long> matchEntryIds = CalCostHelper.matchEntry(entityType, applyOrgBills, priceConfig, modelType);
        String billEntryKey = priceConfig.getString("billentrykey");
        Set<DynamicObject> matchDymS = CalCostHelper.filterBill(entityType, applyOrgBills, matchEntryIds, billEntryKey, modelType);
        Map<Long, Map<String, Object>> priceParam = CalCostHelper.preparePriceParam(entityName, entityType, billEntryKey, matchDymS, modelType, matchEntryIds);
        String priceObject = priceConfig.getString("priceobject");
        Map costPriceResult = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCostPriceService", (String)"getPrice4ExtSys", (Object[])new Object[]{priceObject, priceParam});
        if (costPriceResult == null || costPriceResult.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u5355\u4f4d\u6210\u672c\u4e3a\u7a7a\u3002", (String)"CalCostHelper_9", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        String entryKey = CalCostHelper.getEntryKey(entityType, billEntryKey);
        for (DynamicObject matchDym : matchDymS) {
            DynamicObjectCollection entrys = matchDym.getDynamicObjectCollection(entryKey);
            for (DynamicObject entry : entrys) {
                if (!entryKey.equals(billEntryKey)) {
                    DynamicObjectCollection afterEntrys = entry.getDynamicObjectCollection(billEntryKey);
                    for (DynamicObject afterEntry : afterEntrys) {
                        CalCostHelper.calSetEntryPrice(entityType, matchDym, afterEntry, priceConfig, costPriceResult, modelType);
                    }
                    continue;
                }
                CalCostHelper.calSetEntryPrice(entityType, matchDym, entry, priceConfig, costPriceResult, modelType);
            }
        }
        if (Boolean.TRUE.equals(fromDatabase)) {
            SaveServiceHelper.update((DynamicObject[])matchDymS.toArray(new DynamicObject[0]));
        }
    }

    private static List<Long> matchEntry(MainEntityType entityType, List<DynamicObject> applyOrgBills, DynamicObject priceConfig, String modelType) {
        String filterScript = priceConfig.getString("billfilterscript_tag");
        String billEntryKey = priceConfig.getString("billentrykey");
        ArrayList<Long> matchEntryIds = new ArrayList<Long>(16);
        String entryKey = CalCostHelper.getEntryKey(entityType, billEntryKey);
        for (DynamicObject bill : applyOrgBills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryKey);
            for (DynamicObject entry : entrys) {
                if (!entryKey.equals(billEntryKey)) {
                    DynamicObjectCollection afterEntrys = entry.getDynamicObjectCollection(billEntryKey);
                    for (DynamicObject afterEntry : afterEntrys) {
                        if (!CalCostHelper.isMatch(afterEntry, entityType, filterScript)) continue;
                        if ("bill".equals(modelType)) {
                            matchEntryIds.add(afterEntry.getLong("seq"));
                            continue;
                        }
                        matchEntryIds.add(afterEntry.getLong("id"));
                    }
                    continue;
                }
                if (!CalCostHelper.isMatch(entry, entityType, filterScript)) continue;
                if ("bill".equals(modelType)) {
                    matchEntryIds.add(entry.getLong("seq"));
                    continue;
                }
                matchEntryIds.add(entry.getLong("id"));
            }
        }
        return matchEntryIds;
    }

    private static String getEntryKey(MainEntityType entityType, String billEntryKey) {
        IDataEntityProperty property = entityType.findProperty(billEntryKey);
        if (property instanceof SubEntryProp) {
            IDataEntityType parentEntry = property.getParent();
            if (parentEntry instanceof EntryType) {
                billEntryKey = parentEntry.getName();
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u4f4d\u6210\u672c\u914d\u7f6e\u4e2d\u914d\u7f6e\u7684\u201c\u5355\u636e\u4f53\u201d\u5c42\u7ea7\u8d85\u8fc7\u4e8c\u7ea7\uff0c\u83b7\u53d6\u5355\u4f4d\u6210\u672c\u5931\u8d25\u3002", (String)"CalCostHelper_12", (String)"scmc-im-business", (Object[])new Object[0]));
            }
        }
        return billEntryKey;
    }

    private static Set<DynamicObject> filterBill(MainEntityType entityType, List<DynamicObject> applyOrgBills, List<Long> matchEntryIds, String billEntryKey, String modelType) {
        HashSet<DynamicObject> matchDymS = new HashSet<DynamicObject>(16);
        HashSet<DynamicObject> unMatchDymS = new HashSet<DynamicObject>(16);
        String entryKey = CalCostHelper.getEntryKey(entityType, billEntryKey);
        for (DynamicObject bill : applyOrgBills) {
            ArrayList<Long> billEntryIds = new ArrayList<Long>(16);
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryKey);
            for (DynamicObject entry : entrys) {
                if (!entryKey.equals(billEntryKey)) {
                    DynamicObjectCollection afterEntrys = entry.getDynamicObjectCollection(billEntryKey);
                    for (DynamicObject afterEntry : afterEntrys) {
                        if ("bill".equals(modelType)) {
                            billEntryIds.add(afterEntry.getLong("seq"));
                            continue;
                        }
                        billEntryIds.add(afterEntry.getLong("id"));
                    }
                    continue;
                }
                if ("bill".equals(modelType)) {
                    billEntryIds.add(entry.getLong("seq"));
                    continue;
                }
                billEntryIds.add(entry.getLong("id"));
            }
            if (!billEntryIds.removeAll(matchEntryIds) && !billEntryIds.isEmpty()) {
                unMatchDymS.add(bill);
                continue;
            }
            matchDymS.add(bill);
        }
        if (!unMatchDymS.isEmpty()) {
            StringBuilder billNums = new StringBuilder();
            for (DynamicObject unMatchDym : unMatchDymS) {
                billNums.append(unMatchDym.getString("billno"));
                billNums.append(",");
            }
            billNums.deleteCharAt(billNums.lastIndexOf(","));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u7b26\u5408\u5355\u4f4d\u6210\u672c\u914d\u7f6e\u7684\u89c4\u5219\u542f\u7528\u6761\u4ef6\uff0c\u83b7\u53d6\u5355\u4f4d\u6210\u672c\u5931\u8d25\u3002", (String)"CalCostHelper_6", (String)"scmc-im-business", (Object[])new Object[0]), billNums));
        }
        return matchDymS;
    }

    private static Map<Long, Map<String, Object>> preparePriceParam(String entityName, MainEntityType entityType, String entryKey, Set<DynamicObject> matchDymS, String modelType, List<Long> matchEntryIds) {
        HashMap<Long, Map<String, Object>> priceParam = new HashMap<Long, Map<String, Object>>(16);
        if (matchDymS.isEmpty()) {
            return priceParam;
        }
        HashSet<String> entities = new HashSet<String>(1);
        entities.add(entityName);
        Map resultMapping = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCostPriceService", (String)"getBizBillField2CalBillFields", (Object[])new Object[]{entities});
        if (resultMapping == null || resultMapping.size() == 0) {
            String failReason = ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u6838\u7b97\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\uff0c\u65e0\u6cd5\u8fdb\u884c\u6210\u672c\u67e5\u8be2\u3002", (String)"CalCostHelper_7", (String)"scmc-im-business", (Object[])new Object[0]);
            throw new KDBizException(failReason);
        }
        String entryName = CalCostHelper.getEntryKey(entityType, entryKey);
        Map fieldMap = (Map)resultMapping.get(entityName);
        HashMap<String, String> headFieldMap = new HashMap<String, String>(fieldMap.size());
        HashMap<String, String> entryFieldMap = new HashMap<String, String>(fieldMap.size());
        for (Map.Entry fieldKeys : fieldMap.entrySet()) {
            IDataEntityProperty findProperty;
            String parentKey;
            String billFieldKey = (String)fieldKeys.getKey();
            Set costFieldKey = (Set)fieldKeys.getValue();
            if (costFieldKey == null || costFieldKey.isEmpty() || StringUtils.isEmpty((CharSequence)(parentKey = (findProperty = entityType.findProperty(billFieldKey)).getParent().getName()))) continue;
            if (parentKey.equals(entityName)) {
                costFieldKey.forEach(v -> headFieldMap.put((String)v, billFieldKey));
                continue;
            }
            if (!parentKey.equals(entryKey)) continue;
            costFieldKey.forEach(v -> entryFieldMap.put((String)v, billFieldKey));
        }
        for (DynamicObject matchDym : matchDymS) {
            Map<String, Object> headParamValue = CalCostHelper.getParamValue(matchDym, headFieldMap);
            DynamicObjectCollection entrys = matchDym.getDynamicObjectCollection(entryName);
            for (DynamicObject entry : entrys) {
                if (!entryName.equals(entryKey)) {
                    DynamicObjectCollection afterEntrys = entry.getDynamicObjectCollection(entryKey);
                    for (DynamicObject afterEntry : afterEntrys) {
                        CalCostHelper.buildPriceParam(entityName, priceParam, entryFieldMap, headParamValue, afterEntry, modelType, matchEntryIds);
                    }
                    continue;
                }
                CalCostHelper.buildPriceParam(entityName, priceParam, entryFieldMap, headParamValue, entry, modelType, matchEntryIds);
            }
        }
        return priceParam;
    }

    private static void calSetEntryPrice(MainEntityType mainEntityType, DynamicObject bill, DynamicObject entry, DynamicObject priceConfig, Map<Object, Map<String, Object>> costPriceResult, String modelType) {
        DynamicObject tarCurrency;
        long id = entry.getLong("id");
        if ("bill".equals(modelType)) {
            id = entry.getLong("seq");
        }
        Map<String, Object> priceResult = costPriceResult.get(id);
        if (priceConfig == null || priceResult == null || priceResult.isEmpty()) {
            return;
        }
        BigDecimal price = (BigDecimal)priceResult.get("price");
        long currencyId = (Long)priceResult.get("currency");
        String exRateDateFieldKey = priceConfig.getString("exratedatefieldkey");
        DynamicObject exrateTable = priceConfig.getDynamicObject("exratetable");
        String priceFieldKey = priceConfig.getString("pricefieldkey");
        String priceFieldKeySplit = CalCostHelper.getSplitFieldKey(priceFieldKey);
        Map mainCurrencyFmt = FmtInfoUtils.getMainCurrencyFmt();
        int amtPrecision = (Integer)mainCurrencyFmt.get("ap");
        int pricePrecision = (Integer)mainCurrencyFmt.get("pp");
        PriceProp priceProp = (PriceProp)entry.getDataEntityType().getProperties().get((Object)priceFieldKeySplit);
        if (priceProp == null) {
            String failReason = ResManager.loadKDString((String)"\u5355\u4f4d\u6210\u672c\u56de\u586b\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0c\u83b7\u53d6\u5355\u4f4d\u6210\u672c\u5931\u8d25\u3002", (String)"CalCostHelper_10", (String)"scmc-im-business", (Object[])new Object[0]);
            throw new KDBizException(failReason);
        }
        String controlPropName = priceProp.getControlPropName();
        long tarCurrencyId = 0L;
        if (controlPropName != null && (tarCurrency = bill.getDynamicObject(controlPropName)) != null) {
            tarCurrencyId = tarCurrency.getLong("id");
            amtPrecision = tarCurrency.getInt("amtprecision");
            pricePrecision = tarCurrency.getInt("priceprecision");
        }
        RowDataModel rowDataModel = new RowDataModel(entry.getDataEntityType().getName(), mainEntityType);
        rowDataModel.setRowContext(entry);
        if (StringUtils.isNotBlank((CharSequence)exRateDateFieldKey) && exrateTable != null) {
            Date exRateDate = bill.getDate(exRateDateFieldKey);
            long exRateTableId = exrateTable.getLong("id");
            if (currencyId != tarCurrencyId) {
                BigDecimal exRate = BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)currencyId, (Long)tarCurrencyId, (Date)exRateDate);
                if (exRate == null) {
                    String failReason = ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6709\u6548\u6c47\u7387\uff0c\u83b7\u53d6\u5355\u4f4d\u6210\u672c\u5931\u8d25\u3002", (String)"CalCostHelper_11", (String)"scmc-im-business", (Object[])new Object[0]);
                    throw new KDBizException(failReason);
                }
                price = price.multiply(exRate);
            }
        }
        price = price.setScale(pricePrecision, 4);
        rowDataModel.setValue(priceFieldKeySplit, (Object)price);
        DynamicObjectCollection amountCalEntrys = priceConfig.getDynamicObjectCollection("amountcalentry");
        DataEntityPropertyCollection properties = entry.getDataEntityType().getProperties();
        for (DynamicObject amountCalEntry : amountCalEntrys) {
            String amountFieldKey = amountCalEntry.getString("amountfieldkey");
            String amountFieldKeySplit = CalCostHelper.getSplitFieldKey(amountFieldKey);
            String formulaScript = amountCalEntry.getString("formulascript_tag");
            BigDecimal expressionValue = (BigDecimal)CalCostHelper.getExpressionValue(entry, mainEntityType, formulaScript);
            IDataEntityProperty amountFieldPro = (IDataEntityProperty)properties.get((Object)amountFieldKeySplit);
            if (amountFieldPro instanceof AmountProp) {
                expressionValue = expressionValue.setScale(amtPrecision, 4);
            }
            rowDataModel.setValue(amountFieldKeySplit, (Object)expressionValue);
        }
    }

    private static void buildPriceParam(String entityName, Map<Long, Map<String, Object>> priceParam, Map<String, String> entryFieldMap, Map<String, Object> headParamValue, DynamicObject entry, String modelType, List<Long> matchEntryIds) {
        long id = entry.getLong("id");
        if ("bill".equals(modelType)) {
            id = entry.getLong("seq");
        }
        if (!matchEntryIds.contains(id)) {
            return;
        }
        HashMap<String, Object> entryPriceParam = new HashMap<String, Object>(4);
        entryPriceParam.putAll(headParamValue);
        Map<String, Object> entryParamValue = CalCostHelper.getParamValue(entry, entryFieldMap);
        entryPriceParam.putAll(entryParamValue);
        entryPriceParam.put("entityobject", entityName);
        priceParam.put(id, entryPriceParam);
    }

    private static boolean isMatch(DynamicObject entry, MainEntityType type, String filterFormula) {
        RowDataModel rowDataModel = new RowDataModel(entry.getDataEntityType().getName(), type);
        ExpressionParameter preConditionParam = new ExpressionParameter(filterFormula, rowDataModel);
        preConditionParam.setFcunLib(FunctionManage.get());
        preConditionParam.setActiveRow((Object)entry);
        return (Boolean)CalcExprHelper.getExpressionValue(preConditionParam);
    }

    private static Object getExpressionValue(DynamicObject entry, MainEntityType type, String filterFormula) {
        RowDataModel rowDataModel = new RowDataModel(entry.getDataEntityType().getName(), type);
        ExpressionParameter preConditionParam = new ExpressionParameter(filterFormula, rowDataModel);
        preConditionParam.setFcunLib(FunctionManage.get());
        preConditionParam.setActiveRow((Object)entry);
        return CalcExprHelper.getExpressionValue(preConditionParam);
    }

    private static Map<Object, Map<String, Object>> getImBillValueList(Map<String, String> colsMap, List<Map<String, Object>> costFieldMapList) {
        HashMap<Object, Map<String, Object>> imBillValueList = new HashMap<Object, Map<String, Object>>(16);
        Set<String> costRecordFields = colsMap.keySet();
        for (Map<String, Object> costFieldResultMap : costFieldMapList) {
            HashMap imBillValueMap = new HashMap(16);
            Object bizBillEntryId = costFieldResultMap.get("bizbillentryid");
            costRecordFields.forEach(field -> imBillValueMap.put(colsMap.get(field), costFieldResultMap.get(field)));
            imBillValueList.put(bizBillEntryId, imBillValueMap);
        }
        return imBillValueList;
    }

    private static Map<String, String> getColsMap(DynamicObjectCollection costColsMapEntryS) {
        HashMap<String, String> colsMap = new HashMap<String, String>(16);
        for (DynamicObject costColsMapEntry : costColsMapEntryS) {
            String costRecordFieldKey = costColsMapEntry.getString("costrecordfieldkey");
            String imBillFieldKey = costColsMapEntry.getString("imbillfieldkey");
            String[] costRecordFieldKeySplits = costRecordFieldKey.split("\\.");
            String costRecordFieldKeySplit = costRecordFieldKeySplits[costRecordFieldKeySplits.length - 1];
            String[] imBillFieldKeySplits = imBillFieldKey.split("\\.");
            String imBillFieldKeySplit = imBillFieldKeySplits[imBillFieldKeySplits.length - 1];
            colsMap.put(costRecordFieldKeySplit, imBillFieldKeySplit);
        }
        return colsMap;
    }

    private static List<Map<String, Object>> getCostFieldMapList(String entityName, DynamicObject costConfig, Set<Long> entryIds) {
        boolean isCostMainAccount = costConfig.getBoolean("iscostmainaccount");
        DynamicObject accountType = costConfig.getDynamicObject("accounttype");
        DynamicObject costAccount = costConfig.getDynamicObject("costaccount");
        List<List<Long>> splitIdList = CalCostHelper.getSplitIdList(entryIds);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("bizentitynumber", entityName);
        paramMap.put("ismainaccount", isCostMainAccount);
        paramMap.put("costaccountids", costAccount == null ? null : costAccount.getPkValue());
        paramMap.put("booktypeids", accountType == null ? null : accountType.getPkValue());
        ArrayList<Map<String, Object>> allCostFieldList = new ArrayList<Map<String, Object>>(16);
        for (List<Long> splitEntryIds : splitIdList) {
            HashSet<Long> splitEntryIdSet = new HashSet<Long>(splitEntryIds);
            paramMap.put("bizbillentryids", splitEntryIdSet);
            List<Map<String, Object>> costFieldMapList = CalCostHelper.queryCostField(paramMap);
            if (costFieldMapList == null) continue;
            allCostFieldList.addAll(costFieldMapList);
        }
        return allCostFieldList;
    }

    private static List<Map<String, Object>> queryCostField(Map<String, Object> paramMap) {
        return (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CostRecordCostUpdateService", (String)"getRecordCost", (Object[])new Object[]{paramMap});
    }

    private static Map<DynamicObject, Set<Long>> getConfigEntryMap(Map<Long, DynamicObject> matchEntryConfig) {
        HashMap<DynamicObject, Set<Long>> configEntryMap = new HashMap<DynamicObject, Set<Long>>(16);
        for (Map.Entry<Long, DynamicObject> entryConfig : matchEntryConfig.entrySet()) {
            Long entryId = entryConfig.getKey();
            DynamicObject costConfig = entryConfig.getValue();
            HashSet<Long> entryIds = (HashSet<Long>)configEntryMap.get(costConfig);
            if (entryIds == null) {
                entryIds = new HashSet<Long>(16);
                entryIds.add(entryId);
                configEntryMap.put(costConfig, entryIds);
                continue;
            }
            entryIds.add(entryId);
        }
        return configEntryMap;
    }

    private static void isMatchEntry(DynamicObject entry, DynamicObject costConfig, MainEntityType entityType, String filterFormula, Map<Long, DynamicObject> entryConfigMap) {
        Long configPkValue = (Long)costConfig.getPkValue();
        if (CalCostHelper.isMatch(entry, entityType, filterFormula)) {
            Long matchEntryId = (Long)entry.getPkValue();
            DynamicObject config = entryConfigMap.get(matchEntryId);
            if (config == null) {
                entryConfigMap.put(matchEntryId, costConfig);
            } else {
                Long configId = (Long)config.getPkValue();
                if (configId <= configPkValue) {
                    entryConfigMap.put(matchEntryId, costConfig);
                }
            }
        }
    }

    private static void setBillEntryField(String entityNum, DynamicObjectCollection entryS, Map<Object, Map<String, Object>> imBillValueList) {
        for (DynamicObject entry : entryS) {
            BigDecimal amount;
            Object billEntryId = entry.getPkValue();
            Map<String, Object> imBillEntryValue = imBillValueList.get(billEntryId);
            if (imBillEntryValue == null || imBillEntryValue.isEmpty()) continue;
            imBillEntryValue.forEach((arg_0, arg_1) -> ((DynamicObject)entry).set(arg_0, arg_1));
            if (!"im_materialreqoutbill".equals(entityNum) || (amount = (BigDecimal)entry.get("amount")) == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            entry.set("remainpuramount", (Object)amount);
        }
    }

    private static List<List<Long>> getSplitIdList(Set<Long> billIdSet) {
        ArrayList<List<Long>> splitIdList = new ArrayList<List<Long>>(16);
        ArrayList<Long> billIdList = new ArrayList<Long>(billIdSet);
        int size = billIdSet.size();
        int cycleNum = (int)Math.ceil((double)size / 1000.0);
        int remainNum = size % 1000;
        int endIndex = 0;
        for (int i = 0; i < cycleNum; ++i) {
            int startIndex = endIndex;
            endIndex = i == cycleNum - 1 && remainNum != 0 ? (endIndex += remainNum) : (endIndex += 1000);
            List subList = billIdList.subList(startIndex, endIndex);
            splitIdList.add(subList);
        }
        return splitIdList;
    }

    private static Map<String, Object> getParamValue(DynamicObject bill, Map<String, String> fieldMap) {
        if (fieldMap == null || fieldMap.size() == 0) {
            return new HashMap<String, Object>(1);
        }
        HashMap<String, Object> paramValMap = new HashMap<String, Object>(fieldMap.size());
        for (Map.Entry<String, String> fieldMapEntry : fieldMap.entrySet()) {
            String calFieldKey = fieldMapEntry.getKey();
            String invFieldKey = fieldMapEntry.getValue();
            Object value = bill.get(invFieldKey);
            if (value instanceof DynamicObject) {
                String materialEntity;
                DynamicObject dynaobject = (DynamicObject)value;
                switch (materialEntity = dynaobject.getDataEntityType().getName()) {
                    case "bd_materialinventoryinfo": 
                    case "bd_materialpurchaseinfo": 
                    case "bd_materialsalinfo": 
                    case "bd_materialmftinfo": 
                    case "bd_inspect_cfg": {
                        dynaobject = dynaobject.getDynamicObject("masterid");
                    }
                }
                value = dynaobject.getLong("id");
            }
            paramValMap.put(calFieldKey, value);
        }
        return paramValMap;
    }

    public static String getSplitFieldKey(String fieldKey) {
        String[] fieldKeySplits = fieldKey.split("\\.");
        if (fieldKeySplits.length == 0) {
            return fieldKey;
        }
        return fieldKeySplits[fieldKeySplits.length - 1];
    }
}

