/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.calcost;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.im.business.helper.EntityParseHelper;
import kd.scmc.im.business.helper.calcost.MetaHelper;
import kd.scmc.sbs.business.common.colsAssist.IColsSelectStrategy;
import kd.scmc.sbs.business.common.colsAssist.SelectParams;

public class FormShowHelper {
    public static void showEntrySelectForm(AbstractFormPlugin formPlugin, String entityNumber, IColsSelectStrategy selectStrategy, String closeCallBackActionId) {
        SelectParams params = new SelectParams();
        MetaHelper meta = new MetaHelper(selectStrategy, entityNumber);
        String jsonTree = meta.buildTree2JSON();
        params.setJsonTree(jsonTree);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sbs_colstree_select");
        showParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u4f53", (String)"QueryCalCostHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
        showParameter.getCustomParams().putAll(params.toMap());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IFormView view = formPlugin.getView();
        view.showForm(showParameter);
    }

    public static void showColsTreeForm(AbstractFormPlugin formPlugin, String entityNumber, int rowIndex, IColsSelectStrategy selectStrategy, List<String> selectFields, List<String> filterList, String closeCallBackActionId) {
        SelectParams params = new SelectParams();
        MetaHelper meta = new MetaHelper(selectStrategy, entityNumber);
        String jsonTree = meta.buildTree2JSON(selectFields, filterList);
        params.setJsonTree(jsonTree);
        formPlugin.getPageCache().put("rowindex", String.valueOf(rowIndex));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sbs_colstree_select");
        showParameter.getCustomParams().putAll(params.toMap());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IFormView view = formPlugin.getView();
        view.showForm(showParameter);
    }

    public static void closeCallSetField(IDataModel dataModel, String returnData, String field, String fieldKey) {
        JSONArray fieldArr = (JSONArray)SerializationUtils.fromJsonString((String)returnData, JSONArray.class);
        if (fieldArr != null && !fieldArr.isEmpty()) {
            Map fieldMap = (Map)fieldArr.get(0);
            dataModel.setValue(field, fieldMap.get("text"));
            dataModel.setValue(fieldKey, fieldMap.get("id"));
        }
    }

    public static void closeCallSetEntryField(IDataModel dataModel, IPageCache pageCache, String returnData, String field, String fieldKey) {
        JSONArray fieldArr = (JSONArray)SerializationUtils.fromJsonString((String)returnData, JSONArray.class);
        if (fieldArr != null && !fieldArr.isEmpty()) {
            String rowIndex = pageCache.get("rowindex");
            Map fieldMap = (Map)fieldArr.get(0);
            dataModel.setValue(field, fieldMap.get("text"), Integer.parseInt(rowIndex));
            dataModel.setValue(fieldKey, fieldMap.get("id"), Integer.parseInt(rowIndex));
        }
    }

    public static void setOperationItems(IDataModel dataModel, IFormView view, String entityKey, String operationKey) {
        DynamicObject entity = dataModel.getDataEntity().getDynamicObject(entityKey);
        ComboEdit opEdit = (ComboEdit)view.getControl(operationKey);
        if (entity == null) {
            opEdit.setComboItems(null);
            return;
        }
        String entityNum = entity.getString("number");
        List operations = EntityMetadataCache.getDataEntityOperate((String)entityNum);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        for (Map operation : operations) {
            String opKey = (String)operation.get("key");
            Map opName = (Map)operation.get("name");
            comboItems.add(new ComboItem(LocaleString.fromMap((Map)opName), opKey));
        }
        opEdit.setComboItems(comboItems);
    }

    public static void showEntryFormulaForm(AbstractFormPlugin formPlugin, int rowIndex, String entityNumber, String filterJson, String closeCallBackActionId) {
        String filedNodes = formPlugin.getPageCache().get("formulafieldnodes");
        String entityNumberCache = formPlugin.getPageCache().get("entitynumbercachekey");
        if (StringUtils.isEmpty((CharSequence)entityNumberCache) || !entityNumberCache.equals(entityNumber)) {
            formPlugin.getPageCache().put("entitynumbercachekey", entityNumber);
            filedNodes = "";
        }
        if (StringUtils.isBlank((CharSequence)filedNodes)) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(entityType);
            parameter.setOnlyPhysicsField(false);
            TreeNode treeNode = EntityParseHelper.buildBillTreeNodes(parameter);
            filedNodes = SerializationUtils.toJsonString((Object)treeNode);
            formPlugin.getPageCache().put("formulafieldnodes", filedNodes);
        }
        formPlugin.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_formula");
        showParameter.getCustomParams().put("formula", filterJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", filedNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IFormView view = formPlugin.getView();
        view.showForm(showParameter);
    }

    public static void closeCallSetEntryFormula(IDataModel dataModel, IPageCache pageCache, String returnData, String filterDesc, String filterJson, String filterFormula) {
        CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
        String expression = crCondition.getExpression();
        String exprTran = crCondition.getExprTran() == null ? "" : crCondition.getExprTran();
        String destValueShow = exprTran.length() > 300 ? exprTran.substring(0, 297) + "..." : exprTran;
        String rowIndex = pageCache.get("rowIndex");
        dataModel.setValue(filterDesc, (Object)destValueShow, Integer.parseInt(rowIndex));
        dataModel.setValue(filterJson, (Object)returnData, Integer.parseInt(rowIndex));
        dataModel.setValue(filterFormula, (Object)expression, Integer.parseInt(rowIndex));
    }

    public static void showFilterForm(AbstractFormPlugin formPlugin, IDataModel dataModel, String entityNumber, String filterJsonKey, String closeCallBackActionId) {
        String filterJson = dataModel.getDataEntity().getString(filterJsonKey);
        String filedNodes = formPlugin.getPageCache().get("fieldnodes");
        String entityNumberCache = formPlugin.getPageCache().get("entitynumbercachekey");
        if (StringUtils.isEmpty((CharSequence)entityNumberCache) || !entityNumberCache.equals(entityNumber)) {
            formPlugin.getPageCache().put("entitynumbercachekey", entityNumber);
            filedNodes = "";
        }
        if (StringUtils.isBlank((CharSequence)filedNodes)) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(entityType);
            parameter.setOnlyPhysicsField(false);
            TreeNode treeNode = EntityParseHelper.buildBillTreeNodes(parameter);
            filedNodes = SerializationUtils.toJsonString((Object)treeNode);
            formPlugin.getPageCache().put("fieldnodes", filedNodes);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", filterJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", filedNodes);
        showParameter.getCustomParams().put("needflexfield", String.valueOf(false));
        showParameter.addCustPlugin("kd.scmc.im.formplugin.tpl.FieldHandlePlugin");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IFormView view = formPlugin.getView();
        view.showForm(showParameter);
    }

    public static void closeCallSetFilter(IDataModel dataModel, IPageCache pageCache, String returnData, String filterDesc, String filterJson, String filterFormula) {
        CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
        String entityNumCache = pageCache.get("entitynumbercachekey");
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumCache), crCondition.getFilterCondition());
        filterBuilder.buildFilter(false);
        String[] scripts = filterBuilder.buildFilterScript();
        String destValue = scripts[0];
        String highExpression = crCondition.getExpression();
        if (StringUtils.isNotEmpty((CharSequence)destValue) && StringUtils.isNotEmpty((CharSequence)highExpression)) {
            destValue = destValue + " and (" + highExpression + ")";
        } else if (StringUtils.isEmpty((CharSequence)destValue) && StringUtils.isNotEmpty((CharSequence)highExpression)) {
            destValue = highExpression;
        }
        String exprTran = crCondition.getExprTran() == null ? "" : crCondition.getExprTran();
        String destValueShow = exprTran.length() > 300 ? exprTran.substring(0, 297) + "..." : exprTran;
        dataModel.setValue(filterDesc, (Object)destValueShow);
        dataModel.setValue(filterJson, (Object)returnData);
        dataModel.setValue(filterFormula, (Object)destValue);
    }

    public static void showApplyOrgForm(IFormView view, Object priceConfId) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("confid", priceConfId);
        params.put("confentity", "im_priceconf");
        params.put("conffield", "priceconf");
        params.put("applyorgentity", "im_priceconf_org");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("im_applyorg");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(params);
        view.showForm(showParameter);
    }
}

