/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.calcost;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.sbs.business.common.colsAssist.DefaultSelectStrategy;
import kd.scmc.sbs.business.common.colsAssist.IColsSelectStrategy;

public class MetaHelper {
    private IColsSelectStrategy strategy;
    private MainEntityType meta;

    public MetaHelper(IColsSelectStrategy strategy, MainEntityType meta) {
        if (meta == null) {
            throw new KDBizException(this.getMsgMetaHelperError());
        }
        this.meta = meta;
        this.strategy = strategy == null ? new DefaultSelectStrategy() : strategy;
    }

    private String getMsgMetaHelperError() {
        return ResManager.loadKDString((String)"MetaHelper:\u4f20\u5165\u7684\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MetaHelper_0", (String)"scmc-im-business", (Object[])new Object[0]);
    }

    public MetaHelper(IColsSelectStrategy strategy, String metaNo) {
        this(strategy, MetadataServiceHelper.getDataEntityType((String)metaNo));
    }

    private String getRootId() {
        return "0";
    }

    public String buildTree2JSON(List<String> selectFields, List<String> filterFields) {
        List<String> filterList = this.buildFilterField(filterFields);
        return SerializationUtils.toJsonString((Object)this.buildTreeFilterField(selectFields, filterList));
    }

    public String buildTree2JSON() {
        return SerializationUtils.toJsonString((Object)this.buildTree());
    }

    public TreeNode buildTree() {
        Map allFields = this.meta.getAllFields();
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
        String rootId = this.getRootId();
        TreeNode root = new TreeNode(null, rootId, this.meta.getDisplayName().getLocaleValue());
        nodeMap.put(rootId, root);
        root.setIsOpened(true);
        IDataEntityType parent = null;
        for (IDataEntityProperty pro : allFields.values()) {
            parent = pro.getParent();
            if (parent instanceof MainEntityType) {
                this.strategy.buildNode4Head(root, pro);
                continue;
            }
            if (parent instanceof EntryType && parent.getParent() instanceof MainEntityType) {
                if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
                TreeNode entryNode = this.getEntryNode(nodeMap, parent);
                this.strategy.buildNode4Entry(entryNode, pro);
                if (nodeMap.containsKey(entryNode.getId())) continue;
                nodeMap.put(entryNode.getId(), entryNode);
                root.addChild(entryNode);
                continue;
            }
            if (!(parent instanceof EntryType) || !(parent.getParent() instanceof EntryType)) continue;
            EntryType grandParent = (EntryType)parent.getParent();
            if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
            TreeNode subEntryNode = this.getEntryNode(nodeMap, parent);
            TreeNode entryNode = this.getEntryNode(nodeMap, (IDataEntityType)grandParent);
            this.strategy.buildNode4Entry(entryNode, subEntryNode, pro);
            if (nodeMap.containsKey(subEntryNode.getId())) continue;
            nodeMap.put(subEntryNode.getId(), subEntryNode);
            entryNode.addChild(subEntryNode);
        }
        return root;
    }

    public TreeNode buildTreeFilterField(List<String> selectFields, List<String> filterFields) {
        Map allFields = this.meta.getAllFields();
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        String rootId = this.getRootId();
        TreeNode root = new TreeNode(null, rootId, this.meta.getDisplayName().getLocaleValue());
        nodeMap.put(rootId, root);
        root.setIsOpened(true);
        for (IDataEntityProperty pro : allFields.values()) {
            if (!CollectionUtils.isEmpty(filterFields) && filterFields.contains(pro.getName()) || !CollectionUtils.isEmpty(selectFields) && !selectFields.contains(pro.getName())) continue;
            IDataEntityType parent = pro.getParent();
            if (parent instanceof MainEntityType) {
                this.strategy.buildNode4Head(root, pro);
                continue;
            }
            if (parent instanceof EntryType && parent.getParent() instanceof MainEntityType) {
                if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
                TreeNode entryNode = this.getEntryNode(nodeMap, parent);
                this.strategy.buildNode4Entry(entryNode, pro);
                if (nodeMap.containsKey(entryNode.getId()) || entryNode.getChildren() == null) continue;
                nodeMap.put(entryNode.getId(), entryNode);
                root.addChild(entryNode);
                continue;
            }
            if (!(parent instanceof EntryType) || !(parent.getParent() instanceof EntryType)) continue;
            EntryType grandParent = (EntryType)parent.getParent();
            if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
            TreeNode subEntryNode = this.getEntryNode(nodeMap, parent);
            TreeNode entryNode = this.getEntryNode(nodeMap, (IDataEntityType)grandParent);
            this.strategy.buildNode4Entry(entryNode, subEntryNode, pro);
            if (nodeMap.containsKey(subEntryNode.getId()) || subEntryNode.getChildren() == null) continue;
            nodeMap.put(subEntryNode.getId(), subEntryNode);
            root.addChild(subEntryNode);
        }
        return root;
    }

    private List<String> buildFilterField(List<String> filterFields) {
        ArrayList<String> list = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(filterFields)) {
            for (String field : filterFields) {
                if (field == null) continue;
                String[] fields = field.split("\\.");
                if (fields.length > 1) {
                    String endField = fields[fields.length - 1];
                    if ("id".equals(endField)) {
                        list.add(field);
                        continue;
                    }
                    list.add(endField);
                    continue;
                }
                list.add(field);
            }
        }
        return list;
    }

    private TreeNode getEntryNode(Map<String, TreeNode> nodeMap, IDataEntityType entryPro) {
        String entryName = entryPro.getName();
        TreeNode entryNode = nodeMap.get(entryName);
        if (entryNode == null) {
            entryNode = this.strategy.getTreeNode(this.getRootId(), entryName, entryPro.getDisplayName().toString());
            entryNode.setIsOpened(true);
        }
        return entryNode;
    }
}

