/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.entrust;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.ImBillBotpHelp;
import kd.scmc.im.business.helper.PrecisionAccountHelper;
import kd.scmc.im.consts.InvschemeConsts;
import kd.scmc.im.enums.PrecisionAccountEnum;

public class InvEntrustHelper {
    protected static final Log logger = LogFactory.getLog(InvEntrustHelper.class);
    private static String KEY_ENTRUSTENTRYID = "entrustEntryid";
    private static String KEY_QTY = "qty";
    private static String KEY_PRICE = "price";
    private static String KEY_PRICEANDTAX = "priceandtax";
    private static String KEY_TAXRATEID = "taxrateid";
    private static String KEY_TAXRATE = "taxrate";
    private static String KEY_DISCOUNTTYPE = "discounttype";
    private static String KEY_DISCOUNTRATE = "discountrate";
    private static String KEY_SETTLECURRENCY = "settlecurrency";
    private static String KEY_EXRATETABLE = "exratetable";
    private static String KEY_EXRATEDATE = "exratedate";
    private static String KEY_EXCHANGERATE = "exchangerate";
    private static String KEY_PAYMODE = "paymode";
    private static String KEY_SETTLETYPE = "settletype";
    private static String KEY_ISTAX = "istax";
    private static String KEY_STATUS = "status";
    private static String KEY_MSG = "msg";
    private static String FLAG_SUCCESS = "S";
    private static String FLAG_ERROR = "E";
    private static String BIZTIME = "biztime";
    private static String BOOKDATE = "bookdate";
    protected static final String SALAGENCY_SELECT = "billentry.id as salaencyEntryid,billentry.price as price,billentry.priceandtax as priceandtax,billentry.taxrateid as taxrateid,billentry.taxrate as taxrate,billentry.discounttype as discounttype,billentry.discountrate as discountrate,settlecurrency,exratetable,exratedate,exchangerate,paymode,settletype,istax,bizdate,bookdate";

    public static Map<Long, Map<String, String>> salOutBillWriteBack(Map<Long, Map<Long, BigDecimal>> entrustMap) throws KDException {
        if (entrustMap == null || entrustMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u59d4\u6258\u4ee3\u9500\u8bb0\u5f55\u5173\u7cfb\u6620\u5c04\u4e3a\u7a7a\u3002", (String)"InvEntrustHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        logger.info("salOutBillWriteBack (entrustMap):" + entrustMap);
        Map<Long, Map<Long, Long>> salOutBillMap = InvEntrustHelper.getSalOutBills(entrustMap.keySet());
        logger.info("salOutBillWriteBack (salOutBillMap):" + salOutBillMap);
        HashMap<String, Map<Object, DynamicObject>> basecache = new HashMap<String, Map<Object, DynamicObject>>(4);
        Map<Long, List<Map<String, Object>>> sendOutEntrustMap = InvEntrustHelper.getSendOutEntrustMaps(entrustMap, basecache);
        logger.info("salOutBillWriteBack (sendOutEntrustMap):" + sendOutEntrustMap);
        return InvEntrustHelper.handleSalOutBill(salOutBillMap, sendOutEntrustMap, basecache);
    }

    private static Map<Long, Map<String, String>> handleSalOutBill(Map<Long, Map<Long, Long>> salOutBillMap, Map<Long, List<Map<String, Object>>> sendOutEntrustMap, Map<String, Map<Object, DynamicObject>> basecache) {
        DynamicObject[] salOutBills;
        HashMap<Long, Map<String, String>> resultMap = new HashMap<Long, Map<String, String>>(salOutBillMap.size());
        for (DynamicObject salOutBill : salOutBills = BusinessDataServiceHelper.load((Object[])salOutBillMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"im_saloutbill"))) {
            Long salOutBillId = (Long)salOutBill.getPkValue();
            Map<Long, Long> salOutBillEntryMap = salOutBillMap.get(salOutBillId);
            try {
                InvEntrustHelper.validateSalOutBill(salOutBill);
                DynamicObjectCollection salOutBillEntries = salOutBill.getDynamicObjectCollection("billentry");
                ArrayList<DynamicObject> salOutBillSplitEntries = new ArrayList<DynamicObject>();
                HashMap<String, String> cacheMap = new HashMap<String, String>(salOutBillEntries.size());
                Long seq = 1L;
                for (DynamicObject salOutBillEntry : salOutBillEntries) {
                    Long salOutEntryId = (Long)salOutBillEntry.getPkValue();
                    Long sendOutEntryId = salOutBillEntryMap.get(salOutEntryId);
                    List<Map<String, Object>> entrustEntries = sendOutEntrustMap.get(sendOutEntryId);
                    InvEntrustHelper.validateSalOutBillEntry(salOutBillEntry, entrustEntries);
                    BigDecimal oribaseQty = salOutBillEntry.getBigDecimal("baseqty");
                    BigDecimal ori2ndQty = salOutBillEntry.getBigDecimal("qtyunit2nd");
                    Object material = salOutBillEntry.get("materialmasterid");
                    Long materialmasterid = material instanceof DynamicObject ? (Long)((DynamicObject)material).getPkValue() : (material == null ? Long.valueOf(0L) : (Long)material);
                    DynamicObject baseUnit = salOutBillEntry.getDynamicObject("baseunit");
                    DynamicObject unit = salOutBillEntry.getDynamicObject("unit");
                    BigDecimal unitRate = BillUnitAndQtytHelper.getUnitRateConv(materialmasterid, (Long)baseUnit.getPkValue(), (Long)unit.getPkValue(), cacheMap);
                    for (int i = 0; i < entrustEntries.size(); ++i) {
                        Map<String, Object> entrustEntry = entrustEntries.get(i);
                        if (seq == 1L) {
                            InvEntrustHelper.setSalOutProp(salOutBill, entrustEntry, basecache);
                        }
                        if (i == 0) {
                            InvEntrustHelper.setSalOutEntryProp(salOutBillEntry, entrustEntry, seq, oribaseQty, ori2ndQty, unitRate, basecache);
                        } else {
                            DynamicObject salOutBillSplitEntry = (DynamicObject)OrmUtils.clone((IDataEntityBase)salOutBillEntry, (boolean)false, (boolean)true);
                            InvEntrustHelper.setSalOutEntryProp(salOutBillSplitEntry, entrustEntry, seq, oribaseQty, ori2ndQty, unitRate, basecache);
                            salOutBillSplitEntries.add(salOutBillSplitEntry);
                        }
                        Long l = seq;
                        Long l2 = seq = Long.valueOf(seq + 1L);
                    }
                }
                if (!salOutBillSplitEntries.isEmpty()) {
                    salOutBillEntries.addAll(salOutBillSplitEntries);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{salOutBill});
                    salOutBill = BusinessDataServiceHelper.loadSingle((Object)salOutBillId, (String)"im_saloutbill");
                }
                ImBillBotpHelp.reCalFields(salOutBill, "im_saloutbill");
                Map<String, String> result = InvEntrustHelper.saveOperateSalOutBill(salOutBill);
                resultMap.put(salOutBillId, result);
            }
            catch (Exception e) {
                HashMap<String, String> result = new HashMap<String, String>(2);
                result.put(KEY_STATUS, FLAG_ERROR);
                result.put(KEY_MSG, e.getMessage());
                resultMap.put(salOutBillId, result);
            }
        }
        return resultMap;
    }

    private static void validateSalOutBill(DynamicObject salOutBill) {
        if (!"A".equals(salOutBill.getString("billstatus"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u662f\u6682\u5b58\u3002", (String)"InvEntrustHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
        }
    }

    private static void validateSalOutBillEntry(DynamicObject salOutBillEntry, List<Map<String, Object>> entrustEntries) {
        BigDecimal newQty;
        BigDecimal oriQty = salOutBillEntry.getBigDecimal("baseqty");
        if (oriQty.compareTo(newQty = entrustEntries.stream().map(item -> (BigDecimal)item.get(KEY_QTY)).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u884c%s\u5904\u7406\u524d\u540e\u7684\u6570\u91cf\u4e0d\u4e00\u81f4\u3002", (String)"InvEntrustHelper_2", (String)"scmc-im-business", (Object[])new Object[0]), salOutBillEntry.getLong("seq")));
        }
    }

    private static Map<String, String> saveOperateSalOutBill(DynamicObject salOutBill) {
        HashMap<String, String> result = new HashMap<String, String>(2);
        try {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("isshowmessage", "false");
            option.setVariableValue("ignoreinteraction", "true");
            option.setVariableValue("ignoreValidation", "true");
            option.setVariableValue("WF", "false");
            OperationResult opeResult = OperationServiceHelper.executeOperate((String)"save", (String)"im_saloutbill", (DynamicObject[])new DynamicObject[]{salOutBill}, (OperateOption)option);
            if (!opeResult.isSuccess()) {
                StringBuilder sb = new StringBuilder();
                sb.append(opeResult.getMessage());
                sb.append(';');
                opeResult.getAllErrorInfo().forEach(info -> {
                    sb.append(info.getMessage());
                    sb.append(';');
                });
                opeResult.getAllErrorOrValidateInfo().forEach(info -> {
                    sb.append(info.getMessage());
                    sb.append(';');
                });
                result.put(KEY_STATUS, FLAG_ERROR);
                result.put(KEY_MSG, sb.toString());
            } else {
                result.put(KEY_STATUS, FLAG_SUCCESS);
            }
        }
        catch (Exception e) {
            result.put(KEY_STATUS, FLAG_ERROR);
            result.put(KEY_MSG, e.getMessage());
        }
        return result;
    }

    private static void setSalOutProp(DynamicObject salOutBill, Map<String, Object> entrustEntry, Map<String, Map<Object, DynamicObject>> basecache) {
        salOutBill.set("settlecurrency", (Object)basecache.get("bd_currency").get(entrustEntry.get(KEY_SETTLECURRENCY)));
        salOutBill.set("exratetable", (Object)basecache.get("bd_exratetable").get(entrustEntry.get(KEY_EXRATETABLE)));
        salOutBill.set("exratedate", entrustEntry.get(KEY_EXRATEDATE));
        salOutBill.set("exchangerate", entrustEntry.get(KEY_EXCHANGERATE));
        salOutBill.set("paymode", entrustEntry.get(KEY_PAYMODE));
        salOutBill.set("settletype", (Object)basecache.get("bd_settlementtype").get(entrustEntry.get(KEY_SETTLETYPE)));
        salOutBill.set("istax", entrustEntry.get(KEY_ISTAX));
        salOutBill.set("biztime", entrustEntry.get(BIZTIME));
        Date salBookDate = salOutBill.getDate("bookdate");
        Date enTrustBookDate = (Date)entrustEntry.get(BOOKDATE);
        if (enTrustBookDate.after(salBookDate)) {
            salOutBill.set("bookdate", (Object)enTrustBookDate);
        } else {
            salOutBill.set("bookdate", (Object)salBookDate);
        }
    }

    private static void setSalOutEntryProp(DynamicObject salOutBillEntry, Map<String, Object> entrustEntry, Long seq, BigDecimal oribaseQty, BigDecimal ori2ndQty, BigDecimal unitRate, Map<String, Map<Object, DynamicObject>> basecache) {
        salOutBillEntry.set("seq", (Object)seq);
        salOutBillEntry.set("price", entrustEntry.get(KEY_PRICE));
        salOutBillEntry.set("priceandtax", entrustEntry.get(KEY_PRICEANDTAX));
        salOutBillEntry.set("taxrateid", (Object)basecache.get("bd_taxrate").get(entrustEntry.get(KEY_TAXRATEID)));
        salOutBillEntry.set("taxrate", entrustEntry.get(KEY_TAXRATE));
        salOutBillEntry.set("discounttype", entrustEntry.get(KEY_DISCOUNTTYPE));
        salOutBillEntry.set("discountrate", entrustEntry.get(KEY_DISCOUNTRATE));
        BigDecimal baseQty = (BigDecimal)entrustEntry.get(KEY_QTY);
        DynamicObject unit = salOutBillEntry.getDynamicObject("unit");
        BigDecimal qty = PrecisionAccountHelper.dealWithprecision(unit, baseQty.multiply(unitRate));
        DynamicObject unit2nd = salOutBillEntry.getDynamicObject("unit2nd");
        BigDecimal qty2nd = null;
        qty2nd = unit2nd == null || oribaseQty.compareTo(BigDecimal.ZERO) == 0 || ori2ndQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : ori2ndQty.multiply(baseQty).divide(oribaseQty, unit2nd.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)unit2nd.getInt("precisionaccount")));
        salOutBillEntry.set("baseqty", (Object)baseQty);
        salOutBillEntry.set("qty", (Object)qty);
        salOutBillEntry.set("qtyunit2nd", (Object)qty2nd);
        salOutBillEntry.set("remainreturnbaseqty", (Object)baseQty);
        salOutBillEntry.set("remainreturnqty", (Object)qty);
        salOutBillEntry.set("remainjoinpricebaseqty", (Object)baseQty);
        salOutBillEntry.set("remainjoinpriceqty", (Object)qty);
        salOutBillEntry.set("unverifybaseqty", (Object)baseQty);
        salOutBillEntry.set("unverifyqty", (Object)qty);
        salOutBillEntry.set("entrustunverifybaseqty", (Object)baseQty);
        salOutBillEntry.set("entrustunverifyqty", (Object)qty);
        BigDecimal baseMCost = salOutBillEntry.getBigDecimal("unitmaterialcost");
        baseMCost = baseMCost == null ? new BigDecimal(BigInteger.ZERO) : baseMCost;
        salOutBillEntry.set("materialcost", (Object)baseMCost.multiply(qty));
    }

    private static Map<Long, Map<Long, Long>> getSalOutBills(Set<Long> sendOutBillEntryIds) {
        DynamicObject[] salOutBills = BusinessDataServiceHelper.load((String)"im_saloutbill", (String)"id,billentry.id,billentry.srcbillentryid", (QFilter[])new QFilter("invscheme", "in", (Object)new Long[]{InvschemeConsts.INVSCHEM_ENTRUST_SALEOUT, InvschemeConsts.INVSCHEM_ENTRUST_SALEOUT_BACK}).and("billentry.id", "in", sendOutBillEntryIds).toArray());
        HashMap<Long, Map<Long, Long>> salOutBillMap = new HashMap<Long, Map<Long, Long>>(salOutBills.length);
        for (DynamicObject salOutBill : salOutBills) {
            Long salOutBillId = (Long)salOutBill.getPkValue();
            DynamicObjectCollection salOutBillEntries = salOutBill.getDynamicObjectCollection("billentry");
            HashMap<Long, Long> salOutBillEntryMap = new HashMap<Long, Long>(salOutBillEntries.size());
            for (DynamicObject salOutBillEntry : salOutBillEntries) {
                Long salOutBillEntryId = (Long)salOutBillEntry.getPkValue();
                salOutBillEntryMap.put(salOutBillEntryId, salOutBillEntryId);
            }
            salOutBillMap.put(salOutBillId, salOutBillEntryMap);
        }
        return salOutBillMap;
    }

    private static Map<Long, List<Map<String, Object>>> getSendOutEntrustMaps(Map<Long, Map<Long, BigDecimal>> entrustMap, Map<String, Map<Object, DynamicObject>> basecache) {
        HashMap<Long, List<Map<String, Object>>> sendOutEntrustMap = new HashMap<Long, List<Map<String, Object>>>(entrustMap.size());
        HashSet<Long> salaencyEntryids = new HashSet<Long>(entrustMap.size() * 20);
        for (Map.Entry<Long, Map<Long, BigDecimal>> entry : entrustMap.entrySet()) {
            salaencyEntryids.addAll(entry.getValue().keySet());
        }
        HashSet<Long> currencyids = new HashSet<Long>();
        HashSet<Long> exratetableids = new HashSet<Long>();
        HashSet<Long> settlementtypeids = new HashSet<Long>();
        HashSet<Long> taxrateids = new HashSet<Long>();
        HashMap salaencyEntryMap = new HashMap(salaencyEntryids.size());
        try (DataSet entrustSet = QueryServiceHelper.queryDataSet((String)InvEntrustHelper.class.getName(), (String)"sm_salesagency", (String)SALAGENCY_SELECT, (QFilter[])new QFilter("billentry.id", "in", salaencyEntryids).toArray(), null);){
            for (Row row : entrustSet) {
                HashMap<String, Object> salaencyEntryAttr = new HashMap<String, Object>(13);
                Long salaencyEntryid = row.getLong("salaencyEntryid");
                salaencyEntryAttr.put(KEY_PRICE, row.get("price"));
                salaencyEntryAttr.put(KEY_PRICEANDTAX, row.get("priceandtax"));
                salaencyEntryAttr.put(KEY_TAXRATEID, row.get("taxrateid"));
                salaencyEntryAttr.put(KEY_TAXRATE, row.get("taxrate"));
                salaencyEntryAttr.put(KEY_DISCOUNTTYPE, row.get("discounttype"));
                salaencyEntryAttr.put(KEY_DISCOUNTRATE, row.get("discountrate"));
                salaencyEntryAttr.put(KEY_SETTLECURRENCY, row.get("settlecurrency"));
                salaencyEntryAttr.put(KEY_EXRATETABLE, row.get("exratetable"));
                salaencyEntryAttr.put(KEY_EXRATEDATE, row.get("exratedate"));
                salaencyEntryAttr.put(KEY_EXCHANGERATE, row.get("exchangerate"));
                salaencyEntryAttr.put(KEY_PAYMODE, row.get("paymode"));
                salaencyEntryAttr.put(KEY_SETTLETYPE, row.get("settletype"));
                salaencyEntryAttr.put(KEY_ISTAX, row.get("istax"));
                salaencyEntryAttr.put(BIZTIME, row.get("bizdate"));
                salaencyEntryAttr.put(BOOKDATE, row.get("bookdate") == null ? row.get("bizdate") : row.get("bookdate"));
                currencyids.add(row.getLong("settlecurrency"));
                exratetableids.add(row.getLong("exratetable"));
                settlementtypeids.add(row.getLong("settletype"));
                taxrateids.add(row.getLong("taxrateid"));
                salaencyEntryMap.put(salaencyEntryid, salaencyEntryAttr);
            }
        }
        Map currencymap = BusinessDataServiceHelper.loadFromCache((Object[])currencyids.toArray(), (String)"bd_currency");
        basecache.put("bd_currency", currencymap);
        Map exratetablemap = BusinessDataServiceHelper.loadFromCache((Object[])exratetableids.toArray(), (String)"bd_exratetable");
        basecache.put("bd_exratetable", exratetablemap);
        Map settlementtypemap = BusinessDataServiceHelper.loadFromCache((Object[])settlementtypeids.toArray(), (String)"bd_settlementtype");
        basecache.put("bd_settlementtype", settlementtypemap);
        Map taxratemap = BusinessDataServiceHelper.loadFromCache((Object[])taxrateids.toArray(), (String)"bd_taxrate");
        basecache.put("bd_taxrate", taxratemap);
        for (Map.Entry<Long, Map<Long, BigDecimal>> entry : entrustMap.entrySet()) {
            Long sendOutEntryId = entry.getKey();
            Map<Long, BigDecimal> salaencyEntries = entry.getValue();
            ArrayList newEntrustEntries = new ArrayList(salaencyEntries.size());
            for (Map.Entry<Long, BigDecimal> salaencyEntry : salaencyEntries.entrySet()) {
                Long salaencyEntryId = salaencyEntry.getKey();
                Map salaencyEntryAttr = (Map)salaencyEntryMap.get(salaencyEntryId);
                HashMap<String, Number> newEntrustEntryMap = new HashMap<String, Number>(15);
                newEntrustEntryMap.put(KEY_ENTRUSTENTRYID, salaencyEntryId);
                newEntrustEntryMap.put(KEY_QTY, salaencyEntry.getValue());
                newEntrustEntryMap.putAll(salaencyEntryAttr);
                newEntrustEntries.add(newEntrustEntryMap);
            }
            sendOutEntrustMap.put(sendOutEntryId, newEntrustEntries);
        }
        return sendOutEntrustMap;
    }
}

