/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.freeze;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.biz.balance.model.BalanceUpdateArgs;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.freeze.FreezeIgnoreHelper;
import kd.scmc.im.business.pojo.freeze.FreezeIgnore;
import kd.scmc.im.business.pojo.freeze.FreezeIgnoreExpression;
import kd.scmc.im.consts.InvAccConst;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class FreezeLogCheckHelper {
    private static final Log log = LogFactory.getLog(FreezeLogCheckHelper.class);
    private static final List<String> COMPARE_FIELDS = FreezeLogCheckHelper.getCompareFields();
    private static final String FREEZE_LOG_FIELDS;
    private static final String INVREALBALANCE_FIELDS;

    private static List<String> getCompareFields() {
        ArrayList<String> fields = new ArrayList<String>(4);
        fields.add("org");
        fields.add("ownertype");
        fields.add("owner");
        fields.add("keepertype");
        fields.add("keeper");
        fields.add("warehouse");
        fields.add("location");
        fields.add("invstatus");
        fields.add("invtype");
        fields.add("material");
        fields.add("auxpty");
        fields.add("lotnum");
        fields.add("producedate");
        fields.add("expirydate");
        fields.add("unit");
        fields.add("baseunit");
        fields.add("unit2nd");
        fields.add("project");
        fields.add("configuredcode");
        fields.add("tracknumber");
        return fields;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void matchDimension(String providerEntityNumber, String freezeEntityNumber, DataSet balanceDataSet, BalanceUpdateArgs args) {
        QFilter freezeLogFilter = new QFilter("providerentity", "=", (Object)providerEntityNumber);
        freezeLogFilter.and("freezeentity", "=", (Object)freezeEntityNumber);
        QFilter materielFilter = FreezeLogCheckHelper.generateFreezeLogFilter(balanceDataSet);
        try (DataSet freezeLogDataSet = QueryServiceHelper.queryDataSet((String)FreezeLogCheckHelper.class.getName(), (String)"msmod_freezelog", (String)FREEZE_LOG_FIELDS, (QFilter[])freezeLogFilter.and(materielFilter).toArray(), null);){
            while (freezeLogDataSet.hasNext()) {
                Row freezeLogDimension = freezeLogDataSet.next();
                HashMap<String, Object> params = new HashMap<String, Object>(COMPARE_FIELDS.size());
                String dimensionExpr = FreezeLogCheckHelper.buildDimensionExpr(freezeLogDimension, params);
                HashSet<String> keyCols = new HashSet<String>(16);
                try (DataSet tmpBalanceDataset = balanceDataSet.copy().filter(dimensionExpr, params);){
                    while (tmpBalanceDataset.hasNext()) {
                        Row balanceRow = tmpBalanceDataset.next();
                        keyCols.add(balanceRow.getString("keycol"));
                    }
                }
                if (keyCols.isEmpty()) continue;
                String updateEntityNumber = args.getCtx().getEntityNumber();
                MainEntityType updateEntity = MetadataServiceHelper.getDataEntityType((String)updateEntityNumber);
                String entityName = updateEntity.getDisplayName().getLocaleValue();
                DataSet dataSet = args.getUpdatedSnapData(new String[]{"fbillno", "fbillname"}, null, keyCols.toArray(new String[keyCols.size()]));
                Throwable throwable = null;
                try {
                    try {
                        StringJoiner stringJoiner = new StringJoiner(",");
                        while (dataSet.hasNext()) {
                            Row row = dataSet.next();
                            String billno = row.getString("fbillno");
                            stringJoiner.add(billno);
                        }
                        String freezeBillNos = stringJoiner.toString();
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u201c%2$s\u201d\u51bb\u7ed3\u5e93\u5b58\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5e93\u5b58\u66f4\u65b0\u3002", (String)"FreezeCheckHelper_0", (String)"scmc-im-business", (Object[])new Object[0]), entityName, freezeBillNos));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (dataSet == null) throw throwable3;
                    if (throwable != null) {
                        try {
                            dataSet.close();
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    } else {
                        dataSet.close();
                    }
                    throw throwable3;
                    return;
                }
            }
        }
    }

    private static QFilter generateFreezeLogFilter(DataSet balanceDataSet) {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> materielIds = new HashSet<Long>(16);
        HashSet<Long> warehouseIds = new HashSet<Long>(16);
        try (DataSet dataSet = balanceDataSet.copy();){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                CollectionUtils.addIgnoreNull(materielIds, (Object)row.getLong("material"));
                CollectionUtils.addIgnoreNull(orgIds, (Object)row.getLong("org"));
                CollectionUtils.addIgnoreNull(warehouseIds, (Object)row.getLong("warehouse"));
            }
        }
        orgIds.add(0L);
        materielIds.add(0L);
        warehouseIds.add(0L);
        QFilter freezeLogFilter = new QFilter("material", "in", materielIds);
        freezeLogFilter.and("org", "in", orgIds);
        freezeLogFilter.and("warehouse", "in", warehouseIds);
        return freezeLogFilter;
    }

    private static String buildDimensionExpr(Row row, Map<String, Object> params) {
        StringJoiner joiner = new StringJoiner(" and ");
        joiner.add("1=1");
        for (String compareField : COMPARE_FIELDS) {
            Object value = row.get(compareField);
            if (value instanceof String && StringUtils.isBlank((CharSequence)((String)value)) || value instanceof Long && Objects.equals(0L, value) || !ObjectUtils.isNotEmpty((Object)value)) continue;
            String valueField = compareField + "_val";
            joiner.add(compareField + "=" + valueField);
            params.put(valueField, value);
        }
        return joiner.toString();
    }

    private static boolean isSkip(String updateEntityNumber, Set<Object> billIds, FreezeIgnore freezeIgnore) {
        QFilter chain = null;
        for (FreezeIgnoreExpression freezeIgnoreExpression : freezeIgnore.getFreezeIgnoreExpressionList()) {
            if (!StringUtils.equals((CharSequence)freezeIgnoreExpression.getBizEntity().getNumber(), (CharSequence)updateEntityNumber)) continue;
            if (StringUtils.isBlank((CharSequence)freezeIgnoreExpression.getFilterJson())) {
                return true;
            }
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)freezeIgnoreExpression.getBizEntity().getNumber());
            CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)freezeIgnoreExpression.getFilterJson(), CRCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, crCondition.getFilterCondition());
            filterBuilder.buildFilter();
            QFilter filter = filterBuilder.getQFilter();
            chain = filter.or(chain);
        }
        if (chain == null) {
            return false;
        }
        QFilter qFilter = new QFilter("id", "in", billIds);
        qFilter = qFilter.and(chain);
        return QueryServiceHelper.exists((String)updateEntityNumber, (QFilter[])qFilter.toArray());
    }

    public static void check4BalanceUpdate(BalanceUpdateArgs args) {
        String providerEntityNumber = args.getRule().getBalanceTB().getName();
        log.info("FreezeCheckHelper -------------------- \u65b0\u5f15\u64ce\u8fdb\u5165\u51bb\u7ed3\u8bb0\u5f55\u5224\u65ad\uff0centityName:{}", (Object)providerEntityNumber);
        if (!InvAccConst.getBalTb().equals(providerEntityNumber)) {
            return;
        }
        List<FreezeIgnore> freezeIgnores = FreezeIgnoreHelper.load(providerEntityNumber);
        if (CollectionUtils.isEmpty(freezeIgnores)) {
            log.info("FreezeCheckHelper -------------------- \u65e0\u914d\u7f6e\u5ffd\u7565\u51bb\u7ed3\u914d\u7f6e\uff0c\u8df3\u8fc7\u51bb\u7ed3\u8bb0\u5f55\u68c0\u6d4b");
            return;
        }
        QFilter balanceFilter = args.getUpdatingBalFs();
        String updateEntityNumber = args.getCtx().getEntityNumber();
        try (DataSet balanceDataSet = QueryServiceHelper.queryDataSet((String)FreezeLogCheckHelper.class.getName(), (String)providerEntityNumber, (String)INVREALBALANCE_FIELDS, (QFilter[])balanceFilter.toArray(), null);){
            for (FreezeIgnore freezeIgnore : freezeIgnores) {
                if (FreezeLogCheckHelper.isSkip(updateEntityNumber, args.getCtx().getBillIds(), freezeIgnore)) continue;
                FreezeLogCheckHelper.matchDimension(providerEntityNumber, freezeIgnore.getFreezeEntity().getNumber(), balanceDataSet, args);
            }
        }
        log.info("FreezeCheckHelper -------------------- \u672a\u51bb\u7ed3");
    }

    static {
        ArrayList<String> freezeLogFields = new ArrayList<String>();
        freezeLogFields.addAll(COMPARE_FIELDS);
        freezeLogFields.add("freezeentity");
        freezeLogFields.add("freezebillno");
        freezeLogFields.add("freezebillid");
        FREEZE_LOG_FIELDS = StringUtils.join(freezeLogFields, (String)",");
        ArrayList<String> invrealbalanceFields = new ArrayList<String>();
        invrealbalanceFields.addAll(COMPARE_FIELDS);
        invrealbalanceFields.add("keycol");
        INVREALBALANCE_FIELDS = StringUtils.join(invrealbalanceFields, (String)",");
    }
}

