/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.importdata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.enums.EnableStatusEnum;

public class ImptDataSourceHelper {
    private static final String AUXPTY_MANUAL_INPUT = "3";

    @Deprecated
    public static Map<Object, Object> getPurToReqOrgs(Set<Long> purOrgIds) {
        HashMap<Object, Object> purToReqOrgs = new HashMap<Object, Object>();
        ArrayList<Long> bosOrgs = new ArrayList<Long>(ImptDataSourceHelper.getBosOrgs());
        for (Long orgId : purOrgIds) {
            List reqOrgs = OrgUnitServiceHelper.getFromOrgs((String)OrgViewTypeEnum.IS_PURCHASE.getViewType(), (Long)orgId, (String)"", (boolean)false);
            if (reqOrgs == null || reqOrgs.isEmpty()) {
                purToReqOrgs.put(orgId, bosOrgs);
                purToReqOrgs.put(orgId + "_tag", false);
                continue;
            }
            if (!reqOrgs.contains(orgId)) {
                reqOrgs.add(orgId);
            }
            purToReqOrgs.put(orgId, reqOrgs);
            purToReqOrgs.put(orgId + "_tag", true);
        }
        return purToReqOrgs;
    }

    public static Map<Object, Object> getPurToReqOrgs1(Set<Long> purOrgIds) {
        HashMap<Object, Object> purToReqOrgs = new HashMap<Object, Object>();
        for (Long orgId : purOrgIds) {
            List reqOrgs = OrgUnitServiceHelper.getFromOrgs((String)OrgViewTypeEnum.IS_PURCHASE.getViewType(), (Long)orgId, (String)"", (boolean)false);
            if (reqOrgs == null || reqOrgs.isEmpty()) {
                purToReqOrgs.put(orgId + "_tag", false);
                continue;
            }
            if (!reqOrgs.contains(orgId)) {
                reqOrgs.add(orgId);
            }
            purToReqOrgs.put(orgId, reqOrgs);
            purToReqOrgs.put(orgId + "_tag", true);
        }
        return purToReqOrgs;
    }

    public static Map<Object, Set<Long>> getOrgToSettleOrgs(Set<Long> orgIds) {
        HashMap<Object, Set<Long>> orgToSettleOrgs = new HashMap<Object, Set<Long>>(10);
        for (Long orgId : orgIds) {
            Map companyByOrg;
            HashSet<Long> resultSet = new HashSet<Long>();
            List orgs = OrgUnitServiceHelper.getFromOrgs((String)OrgViewTypeEnum.IS_INVENTORY.getViewType(), (Long)orgId, (String)OrgViewTypeEnum.IS_ACCOUNTING.getViewType(), (boolean)false);
            if (orgs != null && orgs.size() > 0) {
                resultSet.addAll(orgs);
            }
            if ((companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)false, (Boolean)true)) != null && companyByOrg.size() > 0) {
                Long companyId = (Long)companyByOrg.get("id");
                resultSet.add(companyId);
            }
            orgToSettleOrgs.put(orgId, resultSet);
        }
        return orgToSettleOrgs;
    }

    public static Map<Long, List<Long>> getInvToPurOrgs(Set<Long> orgIds) {
        HashMap<Long, List<Long>> invToPurOrgs = new HashMap<Long, List<Long>>();
        QFilter purFunFilter = ImptDataSourceHelper.getEnableFilter();
        purFunFilter.and("fispurchase", "=", (Object)Boolean.TRUE);
        Map purFunOrgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])purFunFilter.toArray());
        ArrayList<Long> toPurOrgIds = new ArrayList<Long>(10);
        for (Object purOrgId : purFunOrgs.keySet()) {
            Long purOrgIdTemp = Long.valueOf(String.valueOf(purOrgId));
            toPurOrgIds.add(purOrgIdTemp);
        }
        for (Long orgId : orgIds) {
            boolean hasPurchase;
            List purOrgs = OrgUnitServiceHelper.getFromOrgs((String)OrgViewTypeEnum.IS_INVENTORY.getViewType(), (Long)orgId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType(), (boolean)false);
            if (purOrgs == null || purOrgs.isEmpty()) {
                invToPurOrgs.put(orgId, toPurOrgIds);
                continue;
            }
            if (!purOrgs.contains(orgId) && (hasPurchase = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType()))) {
                purOrgs.add(orgId);
            }
            invToPurOrgs.put(orgId, purOrgs);
        }
        return invToPurOrgs;
    }

    @Deprecated
    public static Map<Long, List<Long>> getOrgToDepts(Set<Long> orgIds) {
        HashMap<Long, List<Long>> orgToDepts = new HashMap<Long, List<Long>>(16);
        QFilter adminOrgFilter = ImptDataSourceHelper.getAuditedFilter();
        QFilter enableFilter = ImptDataSourceHelper.getEnableFilter();
        adminOrgFilter.and(enableFilter);
        Map adminOrgs = BusinessDataServiceHelper.loadFromCache((String)"bos_adminorg", (String)"id", (QFilter[])adminOrgFilter.toArray());
        Set adminOrgIds = adminOrgs.keySet();
        ArrayList<Long> toAdminOrgIds = new ArrayList<Long>(10);
        for (Object adminOrgId : adminOrgIds) {
            Long orgIdTemp = Long.valueOf(String.valueOf(adminOrgId));
            toAdminOrgIds.add(orgIdTemp);
        }
        for (Long orgId : orgIds) {
            List subDeptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
            if (subDeptIds.isEmpty()) {
                orgToDepts.put(orgId, toAdminOrgIds);
                continue;
            }
            orgToDepts.put(orgId, subDeptIds);
        }
        return orgToDepts;
    }

    public static Map<Long, List<Long>> getOrgToDepts1(Set<Long> orgIds) {
        HashMap<Long, List<Long>> orgToDepts = new HashMap<Long, List<Long>>(16);
        for (Long orgId : orgIds) {
            List subDeptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
            orgToDepts.put(orgId, subDeptIds);
        }
        return orgToDepts;
    }

    public static Map<Long, List<Long>> getOrgToBizDepts(Set<Long> orgIds) {
        return ImptDataSourceHelper.getOrgToDepts(orgIds);
    }

    public static Map<String, Object> getMaterialToAuxptys(Set<Long> materialIds) {
        HashMap<String, Object> proKeyToAuxInfo = new HashMap<String, Object>(16);
        HashMap<Long, Integer> materialToAuxptySize = new HashMap<Long, Integer>(16);
        HashMap<String, Map<String, Set<Long>>> auxptyRange = new HashMap<String, Map<String, Set<Long>>>(16);
        HashMap<String, Long> materialToAuxptySourceId = new HashMap<String, Long>(16);
        HashMap<Long, List> materialToAuxSetup = new HashMap<Long, List>(16);
        QFilter materialFilter = new QFilter("id", "in", materialIds);
        QFilter flexProFilter = ImptDataSourceHelper.getAuditedFilter();
        DataSet materialSet = QueryServiceHelper.queryDataSet((String)ImptDataSourceHelper.getAlgoKey(), (String)"bd_material", (String)"id as materialId,auxptyentry.auxpty as auxptyId", (QFilter[])materialFilter.toArray(), (String)"");
        DataSet flexProSet = QueryServiceHelper.queryDataSet((String)ImptDataSourceHelper.getAlgoKey(), (String)"bd_auxproperty", (String)"id as auxptyId,flexfield,valuetype,manuallydatatype as datatype,istrim,name as auxptyName, assistanttype", (QFilter[])flexProFilter.toArray(), (String)"");
        DataSet auxptyInfoSet = materialSet.join(flexProSet, JoinType.INNER).select(new String[]{"materialId", "auxptyId"}, new String[]{"flexfield", "valuetype", "datatype", "istrim", "auxptyName", "assistanttype"}).on("auxptyId", "auxptyId").finish();
        while (auxptyInfoSet.hasNext()) {
            int auxptySize = 0;
            HashMap<String, Object> auxDataSetup = new HashMap<String, Object>(16);
            Row row = auxptyInfoSet.next();
            Long materialId = row.getLong("materialId");
            Long assistantType = row.getLong("assistanttype");
            String flexField = row.getString("flexfield");
            String valueType = row.getString("valuetype");
            auxptySize = !materialToAuxptySize.containsKey(materialId) ? 1 : (Integer)materialToAuxptySize.get(materialId) + 1;
            materialToAuxptySize.put(materialId, auxptySize);
            auxDataSetup.put("valueType", valueType);
            if (!AUXPTY_MANUAL_INPUT.equals(valueType)) {
                HashMap<String, Object> flexFieldMap = new HashMap<String, Object>(16);
                flexFieldMap.put(flexField + "_" + assistantType, null);
                String key = materialId + "_" + flexField;
                auxptyRange.put(key, flexFieldMap);
                materialToAuxptySourceId.put(key, assistantType);
                List list = materialToAuxSetup.computeIfAbsent(materialId, k -> new ArrayList(10));
                auxDataSetup.put("flexfield", flexField);
                list.add(auxDataSetup);
                continue;
            }
            String auxptyName = row.getString("auxptyName");
            String dataType = row.getString("datatype");
            Boolean istrim = row.getBoolean("istrim");
            try {
                Map dataTypeData = (Map)JSONUtils.cast((String)dataType, Map.class);
                String valType = (String)dataTypeData.get("type");
                if ("decimal".equals(valType)) {
                    Double minValue = (Double)dataTypeData.get("min");
                    Double maxValue = (Double)dataTypeData.get("max");
                    Integer precision = (Integer)dataTypeData.get("precision");
                    Integer scale = (Integer)dataTypeData.get("scale");
                    auxDataSetup.put("minValue", minValue);
                    auxDataSetup.put("maxValue", maxValue);
                    auxDataSetup.put("precision", precision);
                    auxDataSetup.put("scale", scale);
                } else if ("varchar".equals(valType)) {
                    Integer length = (Integer)dataTypeData.get("length");
                    auxDataSetup.put("length", length);
                }
                auxDataSetup.put("auxptyName", auxptyName);
                auxDataSetup.put("valType", valType);
                auxDataSetup.put("flexfield", flexField);
                auxDataSetup.put("istrim", istrim);
                List list = materialToAuxSetup.computeIfAbsent(materialId, k -> new ArrayList(10));
                list.add(auxDataSetup);
            }
            catch (IOException e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8f85\u52a9\u5c5e\u6027\u503c\u65f6\u5f02\u5e38\uff1a%s\u3002", (String)"ImptDataSourceHelperAuxptyParseErr", (String)"scmc-im-business", (Object[])new Object[0]), e.getMessage()));
            }
        }
        Map<String, Map<String, Set<Long>>> auxptyValueRange = ImptDataSourceHelper.setAuxptyRange(auxptyRange, materialToAuxptySourceId);
        proKeyToAuxInfo.put("materialToAuxptySize", materialToAuxptySize);
        proKeyToAuxInfo.put("materialToAuxSetup", materialToAuxSetup);
        proKeyToAuxInfo.put("auxptyValueRange", auxptyValueRange);
        return proKeyToAuxInfo;
    }

    private static Map<String, Map<String, Set<Long>>> setAuxptyRange(Map<String, Map<String, Set<Long>>> auxptyRange, Map<String, Long> materialToAuxptySourceId) {
        Set<String> keySet = auxptyRange.keySet();
        ArrayList<Long> materialIds = new ArrayList<Long>(keySet.size());
        for (String key : keySet) {
            materialIds.add(Long.valueOf(key.split("_")[0]));
        }
        QFilter qFilter = new QFilter("material", "in", materialIds);
        DataSet auxptyValueRange = QueryServiceHelper.queryDataSet((String)ImptDataSourceHelper.getAlgoKey(), (String)"bd_auxptyvalue", (String)"material as materialid, auxpty.flexfield as flexfield, auxpty.assistanttype as assistanttype, entryentity.auxptyvalueid as auxptyvalueid,entryentity.apvaluenum as apvaluenum, entryentity.isenable as isenable", (QFilter[])qFilter.toArray(), (String)"");
        while (auxptyValueRange.hasNext()) {
            Row row = auxptyValueRange.next();
            Long materialId = row.getLong("materialid");
            String flexField = row.getString("flexfield");
            Long l = row.getLong("auxptyvalueid");
            Boolean isEnable = row.getBoolean("isenable");
            String assistantType = row.getString("assistanttype");
            Set auxptyValues = auxptyRange.get(materialId + "_" + (String)flexField).computeIfAbsent((String)flexField + "_" + assistantType, k -> new HashSet(16));
            if (!isEnable.booleanValue()) continue;
            auxptyValues.add(l);
        }
        ArrayList<Long> auxptyIds = new ArrayList<Long>(16);
        Set<Map.Entry<String, Map<String, Set<Long>>>> auxptyRanges = auxptyRange.entrySet();
        for (Map.Entry entry : auxptyRanges) {
            Long materialId = Long.valueOf(((String)entry.getKey()).split("_")[0]);
            DynamicObject[] auxptyMaps = (DynamicObject[])entry.getValue();
            Set auxptyMap = auxptyMaps.entrySet();
            for (Map.Entry entry2 : auxptyMap) {
                String flexField = (String)entry2.getKey();
                String[] keys = flexField.split("_");
                if (entry2.getValue() != null) continue;
                auxptyIds.add(materialToAuxptySourceId.get(materialId + "_" + keys[0]));
            }
        }
        if (auxptyIds.size() == 0) {
            ImptDataSourceHelper.dealMapKey(auxptyRange);
            return auxptyRange;
        }
        QFilter qFilterAssistantDataDetail = new QFilter("group", "in", auxptyIds);
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"bos_assistantdata_detail", (String)"id, group.id", (QFilter[])qFilterAssistantDataDetail.toArray());
        if (dynamicObjectArray == null || dynamicObjectArray.length == 0) {
            ImptDataSourceHelper.dealMapKey(auxptyRange);
            return auxptyRange;
        }
        HashMap<Long, Set> groupMap = new HashMap<Long, Set>(16);
        for (DynamicObject dynamicObject : dynamicObjectArray) {
            long groupId = dynamicObject.getLong("group_id");
            long auxptyPropId = dynamicObject.getLong("id");
            Set ids = groupMap.computeIfAbsent(groupId, k -> new HashSet(16));
            ids.add(auxptyPropId);
        }
        Set groups = groupMap.entrySet();
        for (Map.Entry group : groups) {
            Long groupId = (Long)group.getKey();
            for (Map.Entry<String, Map<String, Set<Long>>> ranges : auxptyRanges) {
                Map<String, Set<Long>> auxptyMaps = ranges.getValue();
                Set<Map.Entry<String, Set<Long>>> auxptyMap = auxptyMaps.entrySet();
                for (Map.Entry<String, Set<Long>> entry : auxptyMap) {
                    String flexField = entry.getKey();
                    String[] keys = flexField.split("_");
                    Long auxptyGroupId = Long.valueOf(keys[1]);
                    if (!groupId.equals(auxptyGroupId)) continue;
                    entry.setValue((Set<Long>)group.getValue());
                }
            }
        }
        ImptDataSourceHelper.dealMapKey(auxptyRange);
        return auxptyRange;
    }

    private static void dealMapKey(Map<String, Map<String, Set<Long>>> auxptyRange) {
        Set<Map.Entry<String, Map<String, Set<Long>>>> auxptyRanges = auxptyRange.entrySet();
        for (Map.Entry<String, Map<String, Set<Long>>> ranges : auxptyRanges) {
            Map<String, Set<Long>> auxptyMaps = ranges.getValue();
            Set<Map.Entry<String, Set<Long>>> auxptyMap = auxptyMaps.entrySet();
            HashMap<String, Set<Long>> newMap = new HashMap<String, Set<Long>>(16);
            for (Map.Entry<String, Set<Long>> entry : auxptyMap) {
                String flexField = entry.getKey();
                Set<Long> value = entry.getValue();
                String[] keys = flexField.split("_");
                String key = keys[0];
                newMap.put(key, value);
            }
            auxptyRange.put(ranges.getKey(), newMap);
        }
    }

    public static Map<Long, List<Object>> getOrgToAccountOwners(Set<Long> orgIds) {
        HashMap<Long, List<Object>> invOrgToOwners = new HashMap<Long, List<Object>>(16);
        for (Long orgId : orgIds) {
            ArrayList<Object> ownerArray = OwnerHelper.getOwners(orgId);
            ArrayList<Object> ownerIds = new ArrayList<Object>(ownerArray);
            Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)false, (Boolean)true);
            Object settleOrgId = null;
            if (companyByOrg != null && (settleOrgId = (Object)companyByOrg.get("id")) != null && StringUtils.isNotEmpty((String)settleOrgId.toString())) {
                ownerIds.add(settleOrgId);
            }
            invOrgToOwners.put(orgId, ownerIds);
        }
        return invOrgToOwners;
    }

    public static Map<Long, Set<Long>> getFixedConvertTypeUnits(Map<Long, Long> materialToBaseUnit) {
        HashMap<Long, Set<Long>> materialToUnits = new HashMap<Long, Set<Long>>(16);
        Set<Long> materialIds = materialToBaseUnit.keySet();
        String selectUnitFields = "measureunitid as unitId,materialid";
        QFilter unitFilter = new QFilter("converttype", "=", (Object)"1");
        unitFilter.and("materialid", "in", materialIds);
        DataSet unitDataSet = QueryServiceHelper.queryDataSet((String)ImptDataSourceHelper.getAlgoKey(), (String)"bd_multimeasureunit", (String)selectUnitFields, (QFilter[])unitFilter.toArray(), (String)"");
        unitDataSet = unitDataSet.select(new String[]{"unitId", "materialid"});
        while (unitDataSet.hasNext()) {
            Row row = unitDataSet.next();
            Long materialId = row.getLong("materialid");
            Long unitId = row.getLong("unitId");
            if (materialId == null) continue;
            if (!materialToUnits.containsKey(materialId)) {
                materialToUnits.put(materialId, new HashSet());
            }
            ((Set)materialToUnits.get(materialId)).add(unitId);
        }
        Set materialToUnitsKeys = materialToUnits.keySet();
        for (Long materialId : materialIds) {
            if (!materialToUnitsKeys.contains(materialId)) {
                materialToUnits.put(materialId, new HashSet());
            }
            ((Set)materialToUnits.get(materialId)).add(materialToBaseUnit.get(materialId));
        }
        return materialToUnits;
    }

    public static Map<Long, Set<Long>> getOrgToWarehouses(Set<Long> orgIds) {
        return ImptDataSourceHelper.getOrgToWarehouses(orgIds, false);
    }

    public static Long getCompanyByOrg(Long orgId) {
        Object settleOrg;
        Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)false, (Boolean)true);
        Long settleOrgId = null;
        if (companyByOrg != null && (settleOrg = companyByOrg.get("id")) != null && StringUtils.isNotEmpty((String)settleOrg.toString())) {
            settleOrgId = (Long)settleOrg;
        }
        return settleOrgId;
    }

    public static Map<Long, Set<Long>> getOrgToWarehouses(Set<Long> orgIds, boolean isOpenLocation) {
        HashMap<Long, Set<Long>> orgToWarehouse = new HashMap<Long, Set<Long>>(16);
        if (orgIds.isEmpty()) {
            return orgToWarehouse;
        }
        QFilter whFilter = new QFilter("org", "in", orgIds);
        whFilter.and("startstatus", "=", (Object)"B");
        whFilter.and("initstatus", "=", (Object)"B");
        if (isOpenLocation) {
            whFilter.and("warehouse.isopenlocation", "=", (Object)"1");
        }
        String whSetupSelects = "org.id,warehouse.id";
        Map warehouseSetups = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)whSetupSelects, (QFilter[])whFilter.toArray());
        for (DynamicObject warehouseSetup : warehouseSetups.values()) {
            Long warehouseId = warehouseSetup.getLong("warehouse.id");
            Long orgId = warehouseSetup.getLong("org.id");
            if (!orgToWarehouse.containsKey(orgId)) {
                orgToWarehouse.put(orgId, new HashSet());
            }
            ((Set)orgToWarehouse.get(orgId)).add(warehouseId);
        }
        return orgToWarehouse;
    }

    public static Map<String, Object> getIsOlateWarehouseByUserIdAndOrgId(Set<Long> orgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        long userId = UserServiceHelper.getCurrentUserId();
        ArrayList<Long> isolateOrgList = new ArrayList<Long>(16);
        ArrayList<Long> notIsolateOrgList = new ArrayList<Long>(16);
        WareHouseIsolateHelper.buildIsolateList(new ArrayList<Long>(orgIds), isolateOrgList, notIsolateOrgList);
        Map<Long, Set<Long>> warehouseByUserIdAndOrgIds = WareHouseIsolateHelper.getWarehouseByUserIdAndOrgIds(userId, isolateOrgList);
        param.put("isOlateWarehouse", warehouseByUserIdAndOrgIds);
        param.put("isolateOrgList", new HashSet<Long>(isolateOrgList));
        return param;
    }

    public static Set<Long> getBizTypes(String formId) {
        HashSet<Long> bizTypeIds = new HashSet<Long>();
        QFilter bizTypeFilter = ImptDataSourceHelper.getAuditedFilter();
        bizTypeFilter.and("billentity.billform", "=", (Object)formId);
        Map bizTypes = BusinessDataServiceHelper.loadFromCache((String)"bd_biztype", (String)"id", (QFilter[])bizTypeFilter.toArray());
        if (bizTypes != null && !bizTypes.isEmpty()) {
            for (DynamicObject bizTypeObj : bizTypes.values()) {
                Long bizTypeId = bizTypeObj.getLong("id");
                bizTypeIds.add(bizTypeId);
            }
        }
        return bizTypeIds;
    }

    public static Set<Long> getHasPermissionOrgIds(String formId) {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        List<Map<String, String>> hasPermissionOrgs = NewInvOrgHelper.getHasPermissionAndStartedInvOrg(formId);
        if (hasPermissionOrgs == null || hasPermissionOrgs.isEmpty()) {
            return orgIds;
        }
        for (Map<String, String> orgData : hasPermissionOrgs) {
            orgIds.add(Long.valueOf(orgData.get("id")));
        }
        return orgIds;
    }

    public static Map<Long, String> getBillToTransceiver(Map<Long, List<Long>> invschemeToBills) {
        HashMap<Long, String> billToTransceiver = new HashMap<Long, String>();
        QFilter invSeFilter = new QFilter("id", "in", invschemeToBills.keySet());
        DynamicObjectCollection invschemes = QueryServiceHelper.query((String)"im_invscheme", (String)"id as invschemeId,transceivertype.transceiver as transceiver", (QFilter[])invSeFilter.toArray());
        for (DynamicObject invscheme : invschemes) {
            Long invschemeId = invscheme.getLong("invschemeId");
            String transceiver = invscheme.getString("transceiver");
            List<Long> billIds = invschemeToBills.get(invschemeId);
            for (Long billId : billIds) {
                billToTransceiver.put(billId, transceiver);
            }
        }
        return billToTransceiver;
    }

    public static Map<String, List<String>> getHasPermissionOrgs(String formId) {
        RequestContext requestContext = RequestContext.get();
        String currUserId = requestContext.getUserId();
        HashMap<String, List<String>> userToPermissOrgs = new HashMap<String, List<String>>();
        List<Map<String, String>> hasPermissionOrgs = NewInvOrgHelper.getHasPermissionAndStartedInvOrg(formId);
        if (hasPermissionOrgs == null || hasPermissionOrgs.isEmpty()) {
            return new HashMap<String, List<String>>();
        }
        for (Map<String, String> orgData : hasPermissionOrgs) {
            if (!userToPermissOrgs.containsKey(currUserId)) {
                userToPermissOrgs.put(currUserId, new ArrayList(10));
            }
            ((List)userToPermissOrgs.get(currUserId)).add(orgData.get("id"));
        }
        return userToPermissOrgs;
    }

    public static Map<String, List<Long>> getBillBizTypeToInvSchemes(Set<String> billBizTypeKeys) {
        ArrayList<QFilter> invSchemeFilters = new ArrayList<QFilter>(10);
        for (String billBizTypeKey : billBizTypeKeys) {
            int dotIndex = billBizTypeKey.indexOf(46);
            String formId = billBizTypeKey.substring(0, dotIndex);
            Long bizTypeId = Long.valueOf(billBizTypeKey.substring(dotIndex + 1));
            QFilter InvSchemeFilter = new QFilter("billform", "=", (Object)formId);
            InvSchemeFilter.and("bitypeentry.biztype", "=", (Object)bizTypeId);
            InvSchemeFilter.and("enable", "=", (Object)Boolean.TRUE);
            invSchemeFilters.add(InvSchemeFilter);
        }
        DynamicObjectCollection invSchemes = QueryServiceHelper.query((String)"im_invscheme", (String)"id,billform,bitypeentry.biztype as biztypeid", (QFilter[])invSchemeFilters.toArray(new QFilter[invSchemeFilters.size()]));
        HashMap<String, List<Long>> billBizTypeToInvSchemes = new HashMap<String, List<Long>>(16);
        for (DynamicObject invScheme : invSchemes) {
            Long invSchemeId = invScheme.getLong("id");
            String billForm = invScheme.getString("billform");
            Long bizTypeId = invScheme.getLong("biztypeid");
            String billBizTypeKey = billForm + "." + bizTypeId;
            if (!billBizTypeToInvSchemes.containsKey(billBizTypeKey)) {
                billBizTypeToInvSchemes.put(billBizTypeKey, new ArrayList());
            }
            ((List)billBizTypeToInvSchemes.get(billBizTypeKey)).add(invSchemeId);
        }
        return billBizTypeToInvSchemes;
    }

    @Deprecated
    public static Set<Long> getBosOrgs() {
        HashSet<Long> bosOrgs = new HashSet<Long>(16);
        Map orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])ImptDataSourceHelper.getEnableFilter().toArray());
        for (Object obj : orgs.keySet()) {
            Long orgId = Long.valueOf(String.valueOf(obj));
            bosOrgs.add(orgId);
        }
        return bosOrgs;
    }

    public static DynamicObject getBosOrgs(Long id) {
        QFilter filter = ImptDataSourceHelper.getEnableFilter();
        filter.and("id", "=", (Object)id);
        DynamicObject bosOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])filter.toArray());
        return bosOrg;
    }

    private static QFilter getAuditedFilter() {
        QFilter auditedFilter = ImptDataSourceHelper.getEnableFilter();
        auditedFilter.and("status", "=", (Object)"C");
        return auditedFilter;
    }

    private static QFilter getEnableFilter() {
        return new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
    }

    private static String getAlgoKey() {
        return ImptDataSourceHelper.class.getName();
    }

    public static Map<Long, Set<Long>> getOrgToMasterData(Map<Long, Set<Long>> inputData) {
        Map resultData = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"checkAvailableMasterData", (Object[])new Object[]{"bd_material", inputData});
        return resultData == null ? new HashMap(16) : resultData;
    }

    public static Map<Object, DynamicObject> getOrgToSupplier(Long orgpk, Object supplierId) {
        QFilter filter = new QFilter("id", "=", supplierId);
        filter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        filter.and("status", "=", (Object)"C");
        filter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)orgpk));
        return BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (QFilter[])filter.toArray());
    }

    public static Map<Object, DynamicObject> getOrgToCustomer(Long orgpk, Object customerId) {
        QFilter filter = new QFilter("id", "=", customerId);
        filter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        filter.and("status", "=", (Object)"C");
        filter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)orgpk));
        return BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (QFilter[])filter.toArray());
    }

    public static Map<Long, Set<Long>> getOrgToOperatorGroup(Long orgId, String operatorGrpType) {
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        filter.and("enable", "=", (Object)Character.valueOf('1'));
        filter.and("operatorgrouptype", "=", (Object)operatorGrpType);
        Map operatorGroupMap = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,entryentity.id,entryentity.invalid", (QFilter[])filter.toArray());
        HashMap<Long, Set<Long>> operatorMapping = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry operatorGroup : operatorGroupMap.entrySet()) {
            Long operatorGroupId = (Long)operatorGroup.getKey();
            operatorMapping.computeIfAbsent(operatorGroupId, k -> new HashSet(16));
            Set operatorIds = (Set)operatorMapping.get(operatorGroupId);
            DynamicObject operatorGroupEntity = (DynamicObject)operatorGroup.getValue();
            DynamicObjectCollection operators = operatorGroupEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject operator : operators) {
                if (operator == null || operator.getBoolean("invalid")) continue;
                operatorIds.add((Long)operator.getPkValue());
            }
        }
        return operatorMapping;
    }

    public static Map<Object, DynamicObject> cacheSettleType() {
        QFilter filter = ImptDataSourceHelper.getEnableFilter();
        return BusinessDataServiceHelper.loadFromCache((String)"bd_settlementtype", (QFilter[])filter.toArray());
    }

    public static Map<Object, DynamicObject> cacheTaxRateId() {
        QFilter filter = ImptDataSourceHelper.getEnableFilter();
        return BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (QFilter[])filter.toArray());
    }

    public static Map<Object, DynamicObject> cachePayCondition() {
        QFilter filter = ImptDataSourceHelper.getEnableFilter();
        return BusinessDataServiceHelper.loadFromCache((String)"bd_paycondition", (QFilter[])filter.toArray());
    }

    public static Map<Object, DynamicObject> cacheProviderLinkMan(Set<Long> providerSupplierIds) {
        QFilter filter = new QFilter("invalid", "=", (Object)Character.valueOf('0'));
        filter.and("supplierid", "in", providerSupplierIds);
        return BusinessDataServiceHelper.loadFromCache((String)"bd_supplierlinkman", (QFilter[])filter.toArray());
    }

    public static DynamicObject cacheInvScheme(Object pkValue) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)"im_invscheme");
    }

    public static DynamicObject getDefaultOwner(Object ownerId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)ownerId, (String)"bos_org");
    }
}

