/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.importdata;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bd.sbd.enums.CalDirectionEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.business.pojo.ValidateResult;
import kd.scmc.im.enums.EnableStatusEnum;
import kd.scmc.im.helper.ShelfLifeDateUtil;
import kd.scmc.im.utils.DateUtils;
import kd.scmc.sbs.business.sn.billFiledMapper.BillFieldMapper;
import kd.scmc.sbs.business.sn.billFiledMapper.BillFieldMapperFactory;

public class ImptValidateHelper {
    private static final String AUXPTY_MANUAL_AUXPTY = "2";
    private static final String AUXPTY_MANUAL_BASE = "1";
    private static final int LOTNUMBER_MAX_LENGTH = 50;
    private static final int COMMENT_MAX_LENGTH = 255;
    private static final String CALFORENDDATERULE_2 = "2";

    public static boolean isCheck(String opKey, ExtendedDataEntity dataEntity) {
        boolean isCheck = false;
        DynamicObject billObj = dataEntity.getDataEntity();
        String billCreType = billObj.getString("billcretype");
        boolean isChargeOff = billObj.getBoolean("ischargeoff");
        if (!isChargeOff && (AUXPTY_MANUAL_BASE.equals(billCreType) || "3".equals(billCreType))) {
            isCheck = true;
        }
        return isCheck || !"save".equals(opKey);
    }

    public static boolean checkLingualismTxtLen(Map<String, String> txtData, int limitLen) {
        if (txtData != null && !txtData.isEmpty()) {
            String txtCN = txtData.get("zh_CN");
            String txtTW = txtData.get("zh_TW");
            String txtEN = txtData.get("en_US");
            Boolean isTxtCN = txtCN != null && txtCN.length() > limitLen;
            Boolean isTxtTW = txtTW != null && txtTW.length() > limitLen;
            Boolean isTxtEN = txtEN != null && txtEN.length() > limitLen;
            if (isTxtCN.booleanValue() || isTxtTW.booleanValue() || isTxtEN.booleanValue()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isEnableLot(DynamicObject materialStategyDym) {
        if (materialStategyDym == null) {
            return false;
        }
        return materialStategyDym.getBoolean("enablelot");
    }

    public static boolean isEnableShelflifeMgr(DynamicObject materialStategyDym) {
        if (materialStategyDym == null) {
            return false;
        }
        return materialStategyDym.getBoolean("enableshelflifemgr");
    }

    public static boolean isEnableAuxpty(DynamicObject materialStategyDym) {
        if (materialStategyDym == null) {
            return false;
        }
        DynamicObject materialObj = materialStategyDym.getDynamicObject("masterid");
        return materialObj.getBoolean("isuseauxpty");
    }

    public static boolean isNumeric(String inputNum) {
        Pattern pattern = Pattern.compile("-?[0-9]+\\.?[0-9]*");
        String bigStr = null;
        try {
            bigStr = new BigDecimal(inputNum).toString();
        }
        catch (Exception e) {
            return false;
        }
        Matcher isNum = pattern.matcher(bigStr);
        return isNum.matches();
    }

    public static ValidateResult checkBizDept(DynamicObject billObj, List<Long> bizDeptIds) {
        DynamicObject bizOrg = billObj.getDynamicObject("bizorg");
        DynamicObject bizDept = billObj.getDynamicObject("bizdept");
        return ImptValidateHelper.checkbizDept(bizDeptIds, bizOrg, bizDept);
    }

    public static ValidateResult checkbizDept(List<Long> bizDeptIds, DynamicObject bizOrg, DynamicObject bizDept) {
        ValidateResult valResultInfo = new ValidateResult();
        if (bizDept == null) {
            return valResultInfo;
        }
        String orgNum = bizOrg.getString("number");
        Long bizDeptId = bizDept.getLong("id");
        if (bizDeptIds != null && !bizDeptIds.isEmpty() && !bizDeptIds.contains(bizDeptId)) {
            String bizDeptNum = bizDept.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u4e0d\u5b58\u5728\u4e1a\u52a1\u90e8\u95e8\u201c%2$s\u201d\u3002", (String)"ImptValidateHelperBizOrgCkDeptErr", (String)"scmc-im-business", (Object[])new Object[0]), orgNum, bizDeptNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkTransferCause(Map<String, String> transfercauseData) {
        ValidateResult valResultInfo = new ValidateResult();
        if (!ImptValidateHelper.checkLingualismTxtLen(transfercauseData, 255)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u539f\u56e0\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7255\u4e2a\u5b57\u7b26\u3002", (String)"ImptValidateHelperCkTransferCauseErr", (String)"scmc-im-business", (Object[])new Object[0]), new Object[0]);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkCurrency(DynamicObject currency) {
        ValidateResult valResultInfo = new ValidateResult();
        if (!currency.getBoolean("enable")) {
            String currencyNum = currency.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u5e01\u79cd\u201c%s\u201d\u4e0d\u53ef\u7528\u3002", (String)"ImptValidateHelperCurrencyErr", (String)"scmc-im-business", (Object[])new Object[0]), currencyNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkPrice(BigDecimal price) {
        ValidateResult valResultInfo = new ValidateResult();
        BigDecimal maxValue = new BigDecimal("9999999999999");
        if (maxValue.compareTo(price) < 0 || BigDecimal.ZERO.compareTo(price) > 0) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53d6\u503c\u8303\u56f4\u4e3a\u201c0\u2264\u4ef7\u683c\u22649999999999999\u201d\u7684\u5355\u4ef7\u3002", (String)"ImptValidateHelperCkPriceErr", (String)"scmc-im-business", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkAuxpty(DynamicObject entryObj, DynamicObject materialInvInfo, Map<String, Object> materialToAuxptys) {
        ValidateResult validateResult = new ValidateResult();
        DynamicObject materialObj = materialInvInfo.getDynamicObject("masterid");
        String materialNum = materialObj.getString("number");
        Long materialId = materialObj.getLong("id");
        if (!ImptValidateHelper.isEnableAuxpty(materialInvInfo)) {
            return validateResult;
        }
        DynamicObject auxpty = entryObj.getDynamicObject("auxpty");
        if (auxpty == null) {
            return validateResult;
        }
        Map materialToAuxptySize = (Map)materialToAuxptys.get("materialToAuxptySize");
        Integer auxptySizeObj = (Integer)materialToAuxptySize.get(materialId);
        if (materialToAuxptys.isEmpty() || auxptySizeObj == null || auxptySizeObj == 0) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u542f\u7528\u4e86\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u7ef4\u62a4\u7269\u6599\u7684\u8f85\u52a9\u5c5e\u6027\u4fe1\u606f\u3002", (String)"InvBillImptValidateCkAuxptyInfo", (String)"scmc-im-business", (Object[])new Object[0]), materialNum);
            validateResult.setErrValResult(errMsg);
            return validateResult;
        }
        Map materialToAuxSetup = (Map)materialToAuxptys.get("materialToAuxSetup");
        String auxValue = auxpty.getString("value");
        try {
            Map imptAuxData = (Map)JSONUtils.cast((String)auxValue, HashMap.class);
            int imptAuxSize = imptAuxData.size();
            int auxSizeOfMt = auxptySizeObj;
            if (imptAuxSize < auxSizeOfMt) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u542f\u7528\u4e86\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u8f93\u5165\u5b8c\u6574\u7684\u8f85\u52a9\u5c5e\u6027\u503c\u3002", (String)"ImptValidateHelperCkAuxptyErr", (String)"scmc-im-business", (Object[])new Object[0]), materialNum);
                validateResult.setErrValResult(errMsg);
                return validateResult;
            }
            if (imptAuxSize > auxSizeOfMt) {
                String errMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u8f85\u52a9\u5c5e\u6027\u4e2a\u6570\u5927\u4e8e\u7269\u6599\u7ef4\u62a4\u7684\u8f85\u52a9\u5c5e\u6027\u4e2a\u6570\uff0c\u8bf7\u6838\u5bf9\u8f85\u52a9\u5c5e\u6027\u4fe1\u606f\u6216\u4e0b\u8f7d\u6700\u65b0\u7684\u5bfc\u5165\u6a21\u677f\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ImptValidateHelperCkAuxptyUpdErr", (String)"scmc-im-business", (Object[])new Object[0]);
                validateResult.setErrValResult(errMsg);
                return validateResult;
            }
            List auxSetupList = (List)materialToAuxSetup.get(materialId);
            if (auxSetupList == null || auxSetupList.isEmpty()) {
                return validateResult;
            }
            for (Map auxSetup : auxSetupList) {
                Object length;
                boolean istrim;
                Object flexfieldObj;
                String valueType;
                Object valueTypeObj = auxSetup.get("valueType");
                if (valueTypeObj == null || AUXPTY_MANUAL_BASE.equals(valueType = String.valueOf(valueTypeObj)) || (flexfieldObj = auxSetup.get("flexfield")) == null) continue;
                String flexfield = String.valueOf(flexfieldObj);
                if ("2".equals(valueType)) {
                    Long auxptyId = (Long)imptAuxData.get(flexfield);
                    Map auxptyValueRange = (Map)materialToAuxptys.get("auxptyValueRange");
                    Set values = (Set)((Map)auxptyValueRange.get(materialId + "_" + flexfield)).get(flexfield);
                    if (values != null && values.contains(auxptyId)) continue;
                    String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u7684\u8f85\u52a9\u5c5e\u6027\u503c\u8303\u56f4\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u503c\u6216\u5bfc\u5165\u7684\u8f85\u52a9\u5c5e\u6027\u503c\u672a\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\u8f85\u52a9\u5c5e\u6027\u7684\u503c\u3002", (String)"ImptValidateHelperCkAuxptyValueRange", (String)"scmc-im-business", (Object[])new Object[0]), materialNum);
                    validateResult.setErrValResult(errMsg);
                    return validateResult;
                }
                Object valTypeObj = auxSetup.get("valType");
                Object txtValObj = imptAuxData.get(flexfield);
                if (txtValObj == null || valTypeObj == null) continue;
                String valType = String.valueOf(valTypeObj);
                String txtVal = String.valueOf(txtValObj);
                if (txtVal.contains("importprop=")) {
                    String errMsg = String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u5df2\u66f4\u65b0\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u7684\u5bfc\u5165\u6a21\u677f\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ImptValidateHelperCkAuxptyUpdReImpt", (String)"scmc-im-business", (Object[])new Object[0]), new Object[0]);
                    validateResult.setErrValResult(errMsg);
                    return validateResult;
                }
                Object auxptyNameObj = auxSetup.get("auxptyName");
                String auxptyName = "Unknown";
                if (auxptyNameObj != null) {
                    auxptyName = String.valueOf(auxptyNameObj);
                }
                if (istrim = ((Boolean)auxSetup.get("istrim")).booleanValue()) {
                    txtVal = txtVal.trim();
                }
                if ("decimal".equals(valType)) {
                    return ImptValidateHelper.checkAuxptyByDecimal(materialNum, auxSetup, txtVal, auxptyName);
                }
                if (!"varchar".equals(valType) || (length = auxSetup.get("length")) == null || (Integer)length == 0 || txtVal.length() <= (Integer)length) continue;
                String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u8f85\u52a9\u5c5e\u6027\u503c\u201c%2$s\u201d\u5b57\u7b26\u5927\u5c0f\u8d85\u8fc7\u503c\u6700\u5927\u957f\u5ea6\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ImptValidateHelperCkAuxptyLenErr", (String)"scmc-im-business", (Object[])new Object[0]), materialNum, auxptyName);
                validateResult.setErrValResult(errMsg);
                return validateResult;
            }
            return validateResult;
        }
        catch (IOException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u503c\u89e3\u6790\u5f02\u5e38\uff1a%s\u3002", (String)"ImptValidateHelperAuxptyParseErr", (String)"scmc-im-business", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private static ValidateResult checkAuxptyByDecimal(String materialNum, Map<String, Object> auxSetup, String txtVal, String auxptyName) {
        BigDecimal decMaxVal;
        BigDecimal decMinVal;
        ValidateResult validateResult = new ValidateResult();
        if (!ImptValidateHelper.isNumeric(txtVal)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u8f85\u52a9\u5c5e\u6027\u503c\u201c%2$s\u201d\u4e0d\u662f\u6570\u5b57\u7c7b\u578b\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ImptValidateHelperCkAuxptyNumErr", (String)"scmc-im-business", (Object[])new Object[0]), materialNum, auxptyName);
            validateResult.setErrValResult(errMsg);
            return validateResult;
        }
        BigDecimal inputDec = new BigDecimal(txtVal);
        Object minValueObj = auxSetup.get("minValue");
        Double minValue = 0.0;
        if (minValueObj != null) {
            minValue = (Double)minValueObj;
        }
        if (inputDec.compareTo(decMinVal = BigDecimal.valueOf(minValue)) < 0) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u8f85\u52a9\u5c5e\u6027\u503c\u201c%2$s\u201d\u4e0d\u80fd\u5c0f\u4e8e\u8bbe\u7f6e\u7684\u6700\u5c0f\u503c\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ImptValidateHelperCkAuxptyMinErr", (String)"scmc-im-business", (Object[])new Object[0]), materialNum, auxptyName);
            validateResult.setErrValResult(errMsg);
            return validateResult;
        }
        Object maxValueObj = auxSetup.get("maxValue");
        Double maxValue = 0.0;
        if (maxValueObj != null) {
            maxValue = (Double)maxValueObj;
        }
        if (inputDec.compareTo(decMaxVal = BigDecimal.valueOf(maxValue)) > 0) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u8f85\u52a9\u5c5e\u6027\u503c\u201c%2$s\u201d\u4e0d\u80fd\u5927\u4e8e\u8bbe\u7f6e\u7684\u6700\u5927\u503c\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ImptValidateHelperCkAuxptyMaxErr", (String)"scmc-im-business", (Object[])new Object[0]), materialNum, auxptyName);
            validateResult.setErrValResult(errMsg);
            return validateResult;
        }
        int precision = (Integer)auxSetup.get("precision");
        int scale = (Integer)auxSetup.get("scale");
        if (txtVal.contains(".")) {
            int dotIndex = txtVal.indexOf(".");
            String integers = txtVal.substring(0, dotIndex);
            if (integers.length() > precision) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u8f85\u52a9\u5c5e\u6027\u503c\u201c%2$s\u201d\u4e0e\u6574\u4f53\u7cbe\u5ea6\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ImptValidateHelperCkAuxptyPreciNotMatch", (String)"scmc-im-business", (Object[])new Object[0]), materialNum, auxptyName);
                validateResult.setErrValResult(errMsg);
                return validateResult;
            }
        } else if (txtVal.length() > precision) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u8f85\u52a9\u5c5e\u6027\u503c\u201c%2$s\u201d\u4e0e\u6574\u4f53\u7cbe\u5ea6\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ImptValidateHelperCkAuxptyPreciErr", (String)"scmc-im-business", (Object[])new Object[0]), materialNum, auxptyName);
            validateResult.setErrValResult(errMsg);
            return validateResult;
        }
        return validateResult;
    }

    public static ValidateResult checkQty(BigDecimal qty, BigDecimal qtyunit2nd) {
        ValidateResult valResultInfo = new ValidateResult();
        BigDecimal maxValue = new BigDecimal("9999999999999");
        if (maxValue.compareTo(qty) < 0 || BigDecimal.ZERO.compareTo(qty) > 0) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53d6\u503c\u8303\u56f4\u4e3a\u201c0\u2264\u6570\u91cf\u22649999999999999\u201d\u7684\u6570\u91cf\u3002", (String)"ImptValidateHelperCkQtyErr", (String)"scmc-im-business", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
            return valResultInfo;
        }
        if (maxValue.compareTo(qtyunit2nd) < 0 || BigDecimal.ZERO.compareTo(qtyunit2nd) > 0) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53d6\u503c\u8303\u56f4\u4e3a\u201c0\u2264\u8f85\u52a9\u6570\u91cf\u22649999999999999\u201d\u7684\u8f85\u52a9\u6570\u91cf\u3002", (String)"ImptValidateHelperCkQty2ndErr", (String)"scmc-im-business", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkUnQty(BigDecimal qty, BigDecimal qtyunit2nd) {
        ValidateResult valResultInfo = new ValidateResult();
        BigDecimal minValue = new BigDecimal("-9999999999999");
        if (minValue.compareTo(qty) > 0 || BigDecimal.ZERO.compareTo(qty) < 0) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53d6\u503c\u8303\u56f4\u4e3a\u201c-9999999999999\u2264\u6570\u91cf\u22640\u201d\u7684\u6570\u91cf\u3002", (String)"ImptValidateHelperCkUnQtyErr", (String)"scmc-im-business", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
            return valResultInfo;
        }
        if (minValue.compareTo(qtyunit2nd) > 0 || BigDecimal.ZERO.compareTo(qtyunit2nd) < 0) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53d6\u503c\u8303\u56f4\u4e3a\u201c-9999999999999\u2264\u8f85\u52a9\u6570\u91cf\u22640\u201d\u7684\u8f85\u52a9\u6570\u91cf\u3002", (String)"ImptValidateHelperCkUnQty2ndErr", (String)"scmc-im-business", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkUnit(Set<Long> fixedConvUnits, Long unitId) {
        ValidateResult valResultInfo = new ValidateResult();
        if (fixedConvUnits == null || !fixedConvUnits.contains(unitId)) {
            String errMsg = ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u5fc5\u987b\u4e0e\u57fa\u672c\u5355\u4f4d\u6709\u56fa\u5b9a\u6362\u7b97\u5173\u7cfb\u3002", (String)"ImptValidateHelperCkUnitErr", (String)"scmc-im-business", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkLotNumber(DynamicObject entryObj) {
        ValidateResult valResultInfo = new ValidateResult();
        DynamicObject materialInfo = entryObj.getDynamicObject("material");
        if (ImptValidateHelper.isEnableLot(materialInfo)) {
            DynamicObject materialObj = materialInfo.getDynamicObject("masterid");
            String materialNum = materialObj.getString("number");
            String lotNumber = (String)entryObj.get("lotnumber");
            if (StringUtils.isEmpty((String)lotNumber)) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u5df2\u542f\u7528\u6279\u53f7\u7ba1\u7406\uff0c\u6279\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ImptValidateHelperCkLotErr_1", (String)"scmc-im-business", (Object[])new Object[0]), materialNum);
                valResultInfo.setErrValResult(errMsg);
            } else if (lotNumber.length() > 50) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u6279\u53f7\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"ImptValidateHelperCkLotErr_2", (String)"scmc-im-business", (Object[])new Object[0]), materialNum);
                valResultInfo.setErrValResult(errMsg);
            }
        } else {
            entryObj.set("lotnumber", null);
        }
        return valResultInfo;
    }

    public static ValidateResult checkProduceDateAndExpiryDate(DynamicObject entryObj) {
        Date produceDate = entryObj.getDate("producedate");
        Date expiryDate = entryObj.getDate("expirydate");
        DynamicObject materialInfo = entryObj.getDynamicObject("material");
        if (ImptValidateHelper.isEnableShelflifeMgr(materialInfo)) {
            return ImptValidateHelper.shelflifeHandle(entryObj, produceDate, expiryDate, materialInfo);
        }
        entryObj.set("producedate", null);
        entryObj.set("expirydate", null);
        return new ValidateResult();
    }

    private static void setDate(DynamicObject entryObj, Date date, ValidateResult validateResult, boolean isProduceDate) {
        DynamicObject materialInfo = entryObj.getDynamicObject("material");
        DynamicObject materialObj = materialInfo.getDynamicObject("masterid");
        String materialNum = materialObj.getString("number");
        String shelfLifeUnit = materialInfo.getString("shelflifeunit");
        int shelfLife = materialInfo.getInt("shelflife");
        String calculationForEndDate = materialInfo.getString("calculationforenddate");
        if (!isProduceDate && "2".equals(calculationForEndDate)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u4fdd\u8d28\u671f\u8ba1\u7b97\u65b9\u5f0f\u4e3a\u201c\u751f\u4ea7\u65e5\u671f+\u4fdd\u8d28\u671f\u4e0a\u4e2a\u6708\u7684\u6700\u540e\u4e00\u5929\u201d\uff0c\u65e0\u6cd5\u6839\u636e\u5230\u671f\u65e5\u671f\u8ba1\u7b97\u751f\u4ea7\u65e5\u671f\uff0c\u8bf7\u586b\u5199\u751f\u4ea7\u65e5\u671f\u3002", (String)"ImptValidateHelperCkProduceDateAndExpiryDate_2", (String)"scmc-im-business", (Object[])new Object[0]), materialNum);
            validateResult.setErrValResult(errMsg);
            return;
        }
        Date result = ShelfLifeDateUtil.shelflifeDateCal((String)shelfLifeUnit, (int)(isProduceDate ? shelfLife : shelfLife * -1), (Date)date, (String)calculationForEndDate);
        if (isProduceDate && result.before(date) && "2".equals(calculationForEndDate)) {
            String newExpiryDateStr = DateUtils.getDateString((Date)result);
            String newProduceDateStr = DateUtils.getDateString((Date)date);
            String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u6839\u636e\u751f\u4ea7\u65e5\u671f\u8ba1\u7b97\u51fa\u7684\u5230\u671f\u65e5\u671f\u201c%2$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%3$s\u201d\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\uff0c\u8bf7\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4fdd\u8d28\u671f\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u548c\u4fdd\u8d28\u671f\u8bbe\u7f6e\u3002", (String)"ImptValidateHelperCkProduceDateAndExpiryDate_3", (String)"scmc-im-business", (Object[])new Object[0]), materialNum, newExpiryDateStr, newProduceDateStr);
            validateResult.setErrValResult(errMsg);
            return;
        }
        entryObj.set(isProduceDate ? "expirydate" : "producedate", (Object)result);
    }

    public static ValidateResult checkWarehouse(DynamicObject entryObj, Set<Long> warehouseIds, DynamicObject org, boolean isInitBill) {
        ValidateResult valResultInfo = new ValidateResult();
        DynamicObject warehouse = entryObj.getDynamicObject("warehouse");
        Long warehouseId = warehouse.getLong("id");
        if (warehouseIds != null) {
            String warehouseNum = warehouse.getString("number");
            if (!warehouse.getBoolean("enable") || !"C".equals(warehouse.getString("status"))) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u201c%s\u201d\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u4ed3\u5e93\u662f\u5426\u5df2\u5ba1\u6838\u6216\u5df2\u542f\u7528\u3002", (String)"ImptValidateHelperCkWarehouseErr_1", (String)"scmc-im-business", (Object[])new Object[0]), warehouseNum);
                valResultInfo.setErrValResult(errMsg);
                return valResultInfo;
            }
            if (!warehouseIds.contains(warehouseId) && !isInitBill) {
                String orgNum = org.getString("number");
                String errMsg = String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u201c%1$s\u201d\u4e0d\u662f\u5e93\u5b58\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\u5df2\u542f\u7528\u5df2\u521d\u59cb\u5316\u7684\u4ed3\u5e93\uff0c\u8bf7\u68c0\u67e5\u4ed3\u5e93\u8bbe\u7f6e\u3002", (String)"ImptValidateHelperCkWarehouseErr_2", (String)"scmc-im-business", (Object[])new Object[0]), warehouseNum, orgNum);
                valResultInfo.setErrValResult(errMsg);
                return valResultInfo;
            }
        }
        return valResultInfo;
    }

    public static ValidateResult checkWarehouse(DynamicObject entryObj, Set<Long> warehouseIds, DynamicObject org, boolean isInitBill, String warehouseField) {
        ValidateResult valResultInfo = new ValidateResult();
        DynamicObject warehouse = entryObj.getDynamicObject(warehouseField);
        Long warehouseId = warehouse.getLong("id");
        if (warehouseIds != null) {
            String warehouseNum = warehouse.getString("number");
            if (!warehouse.getBoolean("enable") || !"C".equals(warehouse.getString("status"))) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u201c%s\u201d\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u4ed3\u5e93\u662f\u5426\u5df2\u5ba1\u6838\u6216\u5df2\u542f\u7528\u3002", (String)"ImptValidateHelperCkWarehouseErr_1", (String)"scmc-im-business", (Object[])new Object[0]), warehouseNum);
                valResultInfo.setErrValResult(errMsg);
                return valResultInfo;
            }
            if (!warehouseIds.contains(warehouseId) && !isInitBill) {
                String orgNum = org.getString("number");
                String errMsg = String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u201c%1$s\u201d\u4e0d\u662f\u5e93\u5b58\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\u5df2\u542f\u7528\u5df2\u521d\u59cb\u5316\u7684\u4ed3\u5e93\uff0c\u8bf7\u68c0\u67e5\u4ed3\u5e93\u8bbe\u7f6e\u3002", (String)"ImptValidateHelperCkWarehouseErr_2", (String)"scmc-im-business", (Object[])new Object[0]), warehouseNum, orgNum);
                valResultInfo.setErrValResult(errMsg);
                return valResultInfo;
            }
        }
        return valResultInfo;
    }

    @Deprecated
    public static ValidateResult checkLocation(DynamicObject entryObj, DynamicObject warehouse, String locationField) {
        Long locationId;
        ValidateResult valResultInfo = new ValidateResult();
        boolean isOpenlocation = warehouse.getBoolean("isopenlocation");
        if (!isOpenlocation) {
            entryObj.set("location", null);
            return valResultInfo;
        }
        DynamicObject location = entryObj.getDynamicObject(locationField);
        String warehouseNum = warehouse.getString("number");
        if (location == null) {
            return valResultInfo;
        }
        Long warehouseId = (Long)warehouse.getPkValue();
        boolean isContains = WarehouseHelper.containLocationInWarehouse(warehouseId, locationId = (Long)location.getPkValue());
        if (!isContains) {
            String locationNum = entryObj.getString("location.number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u4ed3\u4f4d\u201c%1$s\u201d\u4e0e\u4ed3\u5e93\u201c%2$s\u201d\u4e0d\u5339\u914d\u3002", (String)"ImptValidateHelperCkLocatErr_2", (String)"scmc-im-business", (Object[])new Object[0]), locationNum, warehouseNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkLocation(DynamicObject entryObj, DynamicObject warehouse, String locationField, Map<Long, Set<Long>> whIdToLocationIdsMap) {
        boolean contain;
        ValidateResult valResultInfo = new ValidateResult();
        boolean isOpenlocation = warehouse.getBoolean("isopenlocation");
        if (!isOpenlocation) {
            entryObj.set("location", null);
            return valResultInfo;
        }
        DynamicObject location = entryObj.getDynamicObject(locationField);
        String warehouseNum = warehouse.getString("number");
        if (location == null) {
            return valResultInfo;
        }
        Long warehouseId = (Long)warehouse.getPkValue();
        Long locationId = (Long)location.getPkValue();
        boolean bl = contain = whIdToLocationIdsMap.get(warehouseId) != null && whIdToLocationIdsMap.get(warehouseId).contains(locationId);
        if (!contain) {
            String locationNum = entryObj.getString("location.number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u4ed3\u4f4d\u201c%1$s\u201d\u4e0e\u4ed3\u5e93\u201c%2$s\u201d\u4e0d\u5339\u914d\u3002", (String)"ImptValidateHelperCkLocatErr_2", (String)"scmc-im-business", (Object[])new Object[0]), locationNum, warehouseNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkLocation(DynamicObject entryObj, DynamicObject warehouse) {
        Long locationId;
        ValidateResult valResultInfo = new ValidateResult();
        boolean isOpenlocation = warehouse.getBoolean("isopenlocation");
        if (!isOpenlocation) {
            entryObj.set("location", null);
            return valResultInfo;
        }
        DynamicObject location = entryObj.getDynamicObject("location");
        String warehouseNum = warehouse.getString("number");
        if (location == null) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u201c%s\u201d\u5df2\u5f00\u542f\u4ed3\u4f4d\u7ba1\u7406,\u8bf7\u586b\u5199\u4ed3\u4f4d\u4fe1\u606f\u3002", (String)"ImptValidateHelperCkLocatErr_1", (String)"scmc-im-business", (Object[])new Object[0]), warehouseNum);
            valResultInfo.setErrValResult(errMsg);
            return valResultInfo;
        }
        Long warehouseId = (Long)warehouse.getPkValue();
        boolean isContains = WarehouseHelper.containLocationInWarehouse(warehouseId, locationId = (Long)location.getPkValue());
        if (!isContains) {
            String locationNum = entryObj.getString("location.number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u4ed3\u4f4d\u201c%1$s\u201d\u4e0e\u4ed3\u5e93\u201c%2$s\u201d\u4e0d\u5339\u914d\u3002", (String)"ImptValidateHelperCkLocatErr_2", (String)"scmc-im-business", (Object[])new Object[0]), locationNum, warehouseNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkInvType(boolean isInUpdate, DynamicObject invType, DynamicObjectCollection invTypeEntrys, String invSchemeNum) {
        ValidateResult valResultInfo = new ValidateResult();
        if (invType != null) {
            String invTypeNum = invType.getString("number");
            boolean isEnableType = invType.getBoolean("enable");
            if (!isEnableType) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5e93\u5b58\u7c7b\u578b\u4e0d\u53ef\u7528\u3002", (String)"ImptValidateHelperCkInvTypeErr_3", (String)"scmc-im-business", (Object[])new Object[0]), invTypeNum);
                valResultInfo.setErrValResult(errMsg);
            }
        }
        return valResultInfo;
    }

    public static ValidateResult checkOwner(String ownerType, DynamicObject owner, DynamicObject org, List<Object> accountOwners) {
        ValidateResult valResultInfo = new ValidateResult();
        if ("bos_org".equals(ownerType) && owner != null) {
            Object ownerId = owner.getPkValue();
            String ownerNum = owner.getString("number");
            String orgNum = org.getString("number");
            if (accountOwners == null || accountOwners.isEmpty() || !accountOwners.contains(ownerId)) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u4e0d\u5b58\u5728\u6838\u7b97\u7ec4\u7ec7\u7c7b\u578b\u8d27\u4e3b\u201c%2$s\u201d\uff0c\u8bf7\u68c0\u67e5\u8be5\u8d27\u4e3b\u6570\u636e\u3002", (String)"ImptValidateHelperCkOwnerErr", (String)"scmc-im-business", (Object[])new Object[0]), orgNum, ownerNum);
                valResultInfo.setErrValResult(errMsg);
            }
        }
        return valResultInfo;
    }

    public static ValidateResult checkSupplierOrCustomerOwner(String ownerType, DynamicObject owner, DynamicObject org, List<Object> ownerIds, String message) {
        ValidateResult valResultInfo = new ValidateResult();
        if (!"bd_customer".equals(ownerType) && !"bd_supplier".equals(ownerType)) {
            return valResultInfo;
        }
        if (owner != null) {
            Object ownerId = owner.getPkValue();
            String ownerNum = owner.getString("number");
            String orgNum = org.getString("number");
            if (ownerIds == null || ownerIds.isEmpty() || !ownerIds.contains(ownerId)) {
                String errMsg = "bd_customer".equals(ownerType) ? String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d\u4e2d\u65e0\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u5ba2\u6237\u7c7b\u578b\u201c%3$s\u201d\uff0c\u6216\u5df2\u7981\u7528/\u672a\u5ba1\u6838\u3002", (String)"ImptValidateHelperCkOwnerErr_1", (String)"scmc-im-business", (Object[])new Object[0]), orgNum, ownerNum, message) : String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d\u4e2d\u65e0\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u4f9b\u5e94\u5546\u7c7b\u578b\u201c%3$s\u201d\uff0c\u6216\u5df2\u7981\u7528/\u672a\u5ba1\u6838\u3002", (String)"ImptValidateHelperCkOwnerErr_2", (String)"scmc-im-business", (Object[])new Object[0]), orgNum, ownerNum, message);
                valResultInfo.setErrValResult(errMsg);
            }
        }
        return valResultInfo;
    }

    public static ValidateResult checkReqOrg(DynamicObject billObj, DynamicObject reqOrg, Set<Long> bosOrgs) {
        ValidateResult valResultInfo = new ValidateResult();
        DynamicObject org = billObj.getDynamicObject("org");
        Long orgId = org.getLong("id");
        Long reqOrgId = reqOrg.getLong("id");
        String reqNum = reqOrg.getString("number");
        if (!bosOrgs.contains(reqOrgId) && !bosOrgs.contains(orgId)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u9700\u6c42\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u4e1a\u52a1\u5355\u5143\u8303\u56f4\u5185\u7684\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"ImptValidateHelperCkReqOrgErr", (String)"scmc-im-business", (Object[])new Object[0]), reqNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkBizType(Set<Long> bizTypeIds, DynamicObject bizType) {
        ValidateResult valResultInfo = new ValidateResult();
        Long bizTypeId = bizType.getLong("id");
        if (!bizTypeIds.contains(bizTypeId)) {
            String bizTypeNum = bizType.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u201c%s\u201d\u4e0e\u5355\u636e\u4e0d\u5339\u914d\u6216\u7981\u7528\u3002", (String)"ImptValidateHelperCkBizTypeErr", (String)"scmc-im-business", (Object[])new Object[0]), bizTypeNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkBizType(List<Object> bizTypeIds, DynamicObject bizType, DynamicObject billType) {
        ValidateResult valResultInfo = new ValidateResult();
        Object bizTypeId = bizType.get("id");
        if (!bizTypeIds.contains(bizTypeId)) {
            String bizTypeNum = bizType.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u201c%1$s\u201d\u4e0d\u662f\u5355\u636e\u7c7b\u578b\u201c%2$s\u201d\u5173\u8054\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"ImptValidateHelperCkBizTypeErr_1", (String)"scmc-im-business", (Object[])new Object[0]), bizTypeNum, billType.getString("number"));
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkComment(Map<String, String> commentData) {
        ValidateResult valResultInfo = new ValidateResult();
        if (!ImptValidateHelper.checkLingualismTxtLen(commentData, 255)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5907\u6ce8\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u5b57\u7b26\u3002", (String)"ImptValidateHelperCkCommentErr", (String)"scmc-im-business", (Object[])new Object[0]), 255);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkDept(DynamicObject billObj, List<Long> deptIds) {
        ValidateResult valResultInfo = new ValidateResult();
        DynamicObject org = billObj.getDynamicObject("org");
        DynamicObject dept = billObj.getDynamicObject("dept");
        if (org == null || dept == null) {
            return valResultInfo;
        }
        String orgNum = org.getString("number");
        Long deptId = dept.getLong("id");
        if (deptIds != null && !deptIds.isEmpty() && !deptIds.contains(deptId)) {
            String deptNum = dept.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u4e0d\u5b58\u5728\u5e93\u7ba1\u90e8\u95e8\u201c%2$s\u201d\u6216\u8be5\u5e93\u7ba1\u90e8\u95e8\u5df2\u88ab\u5c01\u5b58\u3002", (String)"ImptValidateHelperCkDeptErr", (String)"scmc-im-business", (Object[])new Object[0]), orgNum, deptNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkPurDept(DynamicObject billObj, List<Long> deptIds, String orgKey, String deptKey) {
        ValidateResult valResultInfo = new ValidateResult();
        DynamicObject org = billObj.getDynamicObject(orgKey);
        DynamicObject dept = billObj.getDynamicObject(deptKey);
        if (org == null || dept == null) {
            return valResultInfo;
        }
        String orgNum = org.getString("number");
        Long deptId = dept.getLong("id");
        if (deptIds != null && !deptIds.isEmpty() && !deptIds.contains(deptId)) {
            String deptNum = dept.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u4e0d\u5b58\u5728\u91c7\u8d2d\u90e8\u95e8\u201c%2$s\u201d\u6216\u8be5\u91c7\u8d2d\u90e8\u95e8\u5df2\u5c01\u5b58\u3002", (String)"ImptValidateHelperPurCkDeptErr", (String)"scmc-im-business", (Object[])new Object[0]), orgNum, deptNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkCustomer(DynamicObject billObj, Set<Long> customers) {
        ValidateResult valResultInfo = new ValidateResult();
        DynamicObject org = billObj.getDynamicObject("org");
        String orgNum = org.getString("number");
        DynamicObject customer = billObj.getDynamicObject("customer");
        Long customerId = customer == null ? 0L : customer.getLong("id");
        if (customer != null && !customers.contains(customerId)) {
            String customerNum = customer.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u4e0d\u5b58\u5728\u5ba2\u6237\u201c%2$s\u201d\u3002", (String)"ImptValidateHelperCkCustomerErr", (String)"scmc-im-business", (Object[])new Object[0]), orgNum, customerNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    @Deprecated
    public static ValidateResult checkInvschemes(DynamicObject invscheme, List<Long> invschemes) {
        return new ValidateResult();
    }

    public static ValidateResult checkInvSchemes(DynamicObject invScheme, Long bizTypeId) {
        ValidateResult valResultInfo = new ValidateResult();
        boolean enable = invScheme.getBoolean("enable");
        DynamicObjectCollection bizTypeEntry = invScheme.getDynamicObjectCollection("bitypeentry");
        HashSet<Long> invSchemeBizTypeIds = new HashSet<Long>(8);
        if (bizTypeEntry != null && !bizTypeEntry.isEmpty() && enable) {
            for (DynamicObject entry : bizTypeEntry) {
                Long entryBizTypeId = entry.getLong("biztype_id");
                invSchemeBizTypeIds.add(entryBizTypeId);
            }
        }
        if (!invSchemeBizTypeIds.contains(bizTypeId)) {
            String invSchemeNum = invScheme.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4e8b\u52a1\u201c%s\u201d\u4e0e\u5355\u636e\u7684\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5339\u914d\u6216\u5df2\u7981\u7528\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5e93\u5b58\u4e8b\u52a1\u3002", (String)"ImptValidateHelperCkInvschemeErr", (String)"scmc-im-business", (Object[])new Object[0]), invSchemeNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkAvailableMasterData(DynamicObject org, DynamicObject material, Map<Long, Set<Long>> queryData) {
        ValidateResult valResultInfo = new ValidateResult();
        if (material == null) {
            return valResultInfo;
        }
        String orgNum = org.getString("number");
        Long orgId = org.getLong("id");
        String masterNum = material.getString("number");
        Long masterId = material.getLong("id");
        Set<Long> queryMasterIds = queryData.get(orgId);
        if (queryMasterIds != null && !queryMasterIds.contains(masterId)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u65e0\u6743\u4f7f\u7528\u7269\u6599\u201c%2$s\u201d\u3002", (String)"ImptValidateHelperCkAvailableMasterErr", (String)"scmc-im-business", (Object[])new Object[0]), orgNum, masterNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkStartedInvOrg(DynamicObject billObj, List<DynamicObject> startedInvOrgs) {
        ValidateResult valResultInfo = new ValidateResult();
        DynamicObject orgDy = (DynamicObject)billObj.get("org");
        String OrgPkValue = String.valueOf(orgDy.getPkValue());
        boolean isStartedInvOrg = false;
        for (DynamicObject startedInvOrg : startedInvOrgs) {
            String startedInvOrgPkValue;
            DynamicObject startedInvOrgDy = (DynamicObject)startedInvOrg.get("org");
            if (startedInvOrgDy == null || !(startedInvOrgPkValue = String.valueOf(startedInvOrgDy.getPkValue())).equals(OrgPkValue)) continue;
            isStartedInvOrg = true;
        }
        if (!isStartedInvOrg) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u672a\u542f\u7528\u5e93\u5b58\u3002", (String)"ImptValidateHelperCkOrgErr", (String)"scmc-im-business", (Object[])new Object[0]), orgDy.getString("number"));
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkBizOrg(DynamicObject billObj, Map<Long, List<Long>> invToPurOrgs) {
        ValidateResult valResultInfo = new ValidateResult();
        DynamicObject org = (DynamicObject)billObj.get("org");
        Long pkValue = Long.valueOf(String.valueOf(org.getPkValue()));
        List<Long> purOrgs = invToPurOrgs.get(pkValue);
        DynamicObject bizOrg = (DynamicObject)billObj.get("bizorg");
        if (bizOrg == null) {
            String srcSystem;
            String billKey = billObj.getDataEntityType().getName();
            BillFieldMapper billFieldMapper = BillFieldMapperFactory.getBillFieldMapper((String)billKey);
            String entryKey = billFieldMapper.getBillEntryKey();
            DynamicObjectCollection entryObjs = billObj.getDynamicObjectCollection(entryKey);
            if (entryObjs != null && !entryObjs.isEmpty() && "EAS".equals(srcSystem = ((DynamicObject)entryObjs.get(0)).getString("srcsystem"))) {
                return valResultInfo;
            }
            String errMsg = String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6\u3002", (String)"ImptValidateHelperCkBizOrgErr_1", (String)"scmc-im-business", (Object[])new Object[0]), new Object[0]);
            valResultInfo.setErrValResult(errMsg);
            return valResultInfo;
        }
        Long bizOrgPk = Long.valueOf(String.valueOf(bizOrg.getPkValue()));
        if (!purOrgs.contains(bizOrgPk)) {
            String bizOrgNumber = bizOrg.getString("number");
            String orgNumber = org.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143\u534f\u4f5c\u8bbe\u7f6e\u4e2d\u91c7\u8d2d\u7ec4\u7ec7\u201c%1$s\u201d\u672a\u59d4\u6258\u5e93\u5b58\u7ec4\u7ec7\u201c%2$s\u201d\uff0c\u6216\u91c7\u8d2d\u7ec4\u7ec7\u201c%3$s\u201d\u6ca1\u6709\u91c7\u8d2d\u804c\u80fd\u3002", (String)"ImptValidateHelperCkBizOrgErr", (String)"scmc-im-business", (Object[])new Object[0]), bizOrgNumber, orgNumber, bizOrgNumber);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkEntryReqOrg(DynamicObject billObj, DynamicObject entryObj, Map<Object, Object> purOrgToReqOrgs, String purOrgKey, String reqOrgKey) {
        ValidateResult valResultInfo = new ValidateResult();
        DynamicObject org = (DynamicObject)billObj.get(purOrgKey);
        Long pkValue = Long.valueOf(String.valueOf(org.getPkValue()));
        if (purOrgToReqOrgs == null) {
            return valResultInfo;
        }
        List reqOrgs = (List)purOrgToReqOrgs.get(pkValue);
        DynamicObject reqOrg = (DynamicObject)entryObj.get(reqOrgKey);
        Long reqOrgPk = Long.valueOf(String.valueOf(reqOrg.getPkValue()));
        if (reqOrgs != null && !reqOrgs.isEmpty() && !reqOrgs.contains(reqOrgPk)) {
            String reqOrgNumber = reqOrg.getString("number");
            String orgNumber = org.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143\u534f\u4f5c\u8bbe\u7f6e\u4e2d\u9700\u6c42\u7ec4\u7ec7\u201c%1$s\u201d\u672a\u59d4\u6258\u91c7\u8d2d\u7ec4\u7ec7\u201c%2$s\u201d\u6216\u9700\u6c42\u7ec4\u7ec7\u201c%3$s\u201d\u4e0d\u662f\u4e1a\u52a1\u5355\u5143\u3002", (String)"ImptValidateHelperCkEntryReqOrgErr", (String)"scmc-im-business", (Object[])new Object[0]), reqOrgNumber, orgNumber, reqOrgNumber);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkSupplier(DynamicObject billObj, List<Object> supplierIds) {
        ValidateResult valResultInfo = new ValidateResult();
        DynamicObject supplier = billObj.getDynamicObject("supplier");
        Object supplierId = supplier == null ? "" : supplier.getPkValue();
        boolean isSupplier = false;
        if (supplierIds != null && supplierIds.contains(supplierId)) {
            isSupplier = true;
        }
        if (isSupplier) {
            HashSet<String> vMI = new HashSet<String>();
            vMI.add("130");
            vMI.add("1301");
            vMI.add("323");
            vMI.add("3231");
            DynamicObject bizType = billObj.getDynamicObject("biztype");
            String bizTypeNumber = bizType.getString("number");
            if (vMI.contains(bizTypeNumber) && supplier != null && !supplier.getBoolean("enablevmi")) {
                String supplierNumber = supplier.getString("number");
                String errMsg = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u201c%s\u201d\u4e0d\u53efVMI\u3002", (String)"ImptValidateHelperCkSupplierErr_0", (String)"scmc-im-business", (Object[])new Object[0]), supplierNumber);
                valResultInfo.setErrValResult(errMsg);
            }
        } else {
            DynamicObject org = billObj.getDynamicObject("org");
            if (org == null || supplier == null) {
                return valResultInfo;
            }
            String orgNumber = org.getString("number");
            String supplierNumber = supplier.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u80fd\u4f7f\u7528\u4f9b\u5e94\u5546\u201c%2$s\u201d\u6216\u4f9b\u5e94\u5546\u5df2\u88ab\u7981\u7528\u3002", (String)"ImptValidateHelperCkSupplierErr_1", (String)"scmc-im-business", (Object[])new Object[0]), orgNumber, supplierNumber);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    @Deprecated
    public static ValidateResult checkSupplier(DynamicObject billObj) {
        ValidateResult valResultInfo = new ValidateResult();
        DynamicObject org = billObj.getDynamicObject("org");
        Long orgId = org == null ? Long.valueOf(0L) : (Long)org.getPkValue();
        DynamicObject supplier = billObj.getDynamicObject("supplier");
        Long supplierId = supplier == null ? Long.valueOf(0L) : billObj.getDynamicObject("supplier").getPkValue();
        QFilter filter = new QFilter("id", "=", (Object)supplierId);
        filter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        filter.and("status", "=", (Object)"C");
        filter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)orgId));
        boolean exists = QueryServiceHelper.exists((String)"bd_supplier", (QFilter[])filter.toArray());
        if (exists) {
            HashSet<String> vMI = new HashSet<String>();
            vMI.add("130");
            vMI.add("1301");
            vMI.add("323");
            vMI.add("3231");
            DynamicObject bizType = billObj.getDynamicObject("biztype");
            String bizTypeNumber = bizType.getString("number");
            if (vMI.contains(bizTypeNumber) && supplier != null && !supplier.getBoolean("enablevmi")) {
                String supplierNumber = supplier.getString("number");
                String errMsg = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u201c%s\u201d\u4e0d\u53efVMI\u3002", (String)"ImptValidateHelperCkSupplierErr_0", (String)"scmc-im-business", (Object[])new Object[0]), supplierNumber);
                valResultInfo.setErrValResult(errMsg);
            }
        } else {
            if (org == null || supplier == null) {
                return valResultInfo;
            }
            String orgNumber = org.getString("number");
            String supplierNumber = supplier.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u80fd\u4f7f\u7528\u4f9b\u5e94\u5546\u201c%2$s\u201d\u6216\u4f9b\u5e94\u5546\u5df2\u88ab\u7981\u7528\u3002", (String)"ImptValidateHelperCkSupplierErr_1", (String)"scmc-im-business", (Object[])new Object[0]), orgNumber, supplierNumber);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkSupplier(DynamicObject billObj, Map<Long, Set<Long>> orgAndSupIds) {
        ValidateResult valResultInfo = new ValidateResult();
        DynamicObject org = billObj.getDynamicObject("org");
        Long orgId = org == null ? Long.valueOf(0L) : (Long)org.getPkValue();
        DynamicObject supplier = billObj.getDynamicObject("supplier");
        Long supplierId = supplier == null ? Long.valueOf(0L) : (Long)billObj.getDynamicObject("supplier").getPkValue();
        Set supIds = orgAndSupIds.getOrDefault(orgId, new HashSet(0));
        if (supIds.contains(supplierId)) {
            HashSet<String> vMI = new HashSet<String>();
            vMI.add("130");
            vMI.add("1301");
            vMI.add("323");
            vMI.add("3231");
            DynamicObject bizType = billObj.getDynamicObject("biztype");
            String bizTypeNumber = bizType.getString("number");
            if (vMI.contains(bizTypeNumber) && supplier != null && !supplier.getBoolean("enablevmi")) {
                String supplierNumber = supplier.getString("number");
                String errMsg = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u201c%s\u201d\u4e0d\u53efVMI\u3002", (String)"ImptValidateHelperCkSupplierErr_0", (String)"scmc-im-business", (Object[])new Object[0]), supplierNumber);
                valResultInfo.setErrValResult(errMsg);
            }
        } else {
            if (org == null || supplier == null) {
                return valResultInfo;
            }
            String orgNumber = org.getString("number");
            String supplierNumber = supplier.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u80fd\u4f7f\u7528\u4f9b\u5e94\u5546\u201c%2$s\u201d\u6216\u4f9b\u5e94\u5546\u5df2\u88ab\u7981\u7528\u3002", (String)"ImptValidateHelperCkSupplierErr_1", (String)"scmc-im-business", (Object[])new Object[0]), orgNumber, supplierNumber);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkEnableSupplier(DynamicObject supplier, String key, List<Object> supplierIds) {
        ValidateResult valResultInfo = new ValidateResult();
        Object supplierId = supplier == null ? "" : supplier.getPkValue();
        boolean isSupplier = false;
        if (supplierIds != null && supplierIds.contains(supplierId)) {
            isSupplier = true;
        }
        if (!isSupplier) {
            String supplierNumber = supplier == null ? "" : supplier.getString("number");
            HashMap<String, String> nameMap = new HashMap<String, String>(4);
            nameMap.put("providersupplier", ResManager.loadKDString((String)"\u4f9b\u8d27\u4f9b\u5e94\u5546", (String)"ImptValidateHelperCkEnableSupplier_0", (String)"scmc-im-business", (Object[])new Object[0]));
            nameMap.put("receivesupplier", ResManager.loadKDString((String)"\u6536\u6b3e\u4f9b\u5e94\u5546", (String)"ImptValidateHelperCkEnableSupplier_1", (String)"scmc-im-business", (Object[])new Object[0]));
            nameMap.put("invoicesupplier", ResManager.loadKDString((String)"\u51fa\u7968\u4f9b\u5e94\u5546", (String)"ImptValidateHelperCkEnableSupplier_2", (String)"scmc-im-business", (Object[])new Object[0]));
            String supplierName = (String)nameMap.get(key);
            String errMsg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684%2$s\u662f\u5e93\u5b58\u7ec4\u7ec7\u7ba1\u63a7\u8303\u56f4\u5185\u7684\u4e0d\u53ef\u7528\u7684\u4f9b\u5e94\u5546\u3002", (String)"ImptValidateHelperCkEnableSupplier", (String)"scmc-im-business", (Object[])new Object[0]), supplierNumber, supplierName);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static ValidateResult checkOperator(String operatorGrpType, DynamicObject billObj, Map<Long, Set<Long>> operatorGroupMapping) {
        ValidateResult valResultInfo = new ValidateResult();
        boolean isInv = "KCZ".equals(operatorGrpType);
        String orgString = isInv ? "org" : "bizorg";
        String operatorString = isInv ? "operator" : "bizoperator";
        String operatorGroupString = isInv ? "operatorgroup" : "bizoperatorgroup";
        DynamicObject org = billObj.getDynamicObject(orgString);
        DynamicObject operator = billObj.getDynamicObject(operatorString);
        DynamicObject operatorGroup = billObj.getDynamicObject(operatorGroupString);
        String orgNum = org.getString("number");
        if (operator == null && operatorGroup == null) {
            return valResultInfo;
        }
        if (operator != null && operatorGroup != null) {
            Set<Long> operators = operatorGroupMapping.get(operatorGroup.getLong("id"));
            if (operators == null) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u53ef\u7528\u4e1a\u52a1\u7ec4\u201c%2$s\u201d\uff0c\u4e1a\u52a1\u7ec4\u672a\u542f\u7528\u6216\u8be5\u4e1a\u52a1\u7ec4\u4e0e\u4e1a\u52a1\u7ec4\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ImptValidateHelperCkOperator_1", (String)"scmc-im-business", (Object[])new Object[0]), orgNum, operatorGroup.getString("number"));
                valResultInfo.setErrValResult(errMsg);
                return valResultInfo;
            }
            if (!operators.contains(operator.getLong("id"))) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u7ec4\u201c%1$s\u201d\u4e0b\u4e0d\u5b58\u5728\u4e1a\u52a1\u5458\u201c%2$s\u201d\uff0c\u6216\u8be5\u4e1a\u52a1\u5458\u5df2\u5931\u6548\u3002", (String)"ImptValidateHelperCkOperator_2", (String)"scmc-im-business", (Object[])new Object[0]), operatorGroup.getString("number"), operator.getString("operatornumber"));
                valResultInfo.setErrValResult(errMsg);
                return valResultInfo;
            }
        } else if (operator == null) {
            billObj.set(operatorGroupString, null);
        } else {
            boolean flag = false;
            for (Map.Entry<Long, Set<Long>> operatorGroupEntry : operatorGroupMapping.entrySet()) {
                Set<Long> operators = operatorGroupEntry.getValue();
                if (!operators.contains(operator.getLong("id"))) continue;
                billObj.set(operatorGroupString, (Object)operatorGroupEntry.getKey());
                flag = true;
                break;
            }
            if (!flag) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u4e1a\u52a1\u5458\u201c%2$s\u201d\u4e0d\u53ef\u7528\uff0c\u6216\u8be5\u4e1a\u52a1\u5458\u5df2\u5931\u6548\u3002", (String)"ImptValidateHelperCkOperator_3", (String)"scmc-im-business", (Object[])new Object[0]), orgNum, operator.getString("operatornumber"));
                valResultInfo.setErrValResult(errMsg);
            }
        }
        return valResultInfo;
    }

    public static ValidateResult checkSettleType(DynamicObject billObj, Map<Object, DynamicObject> settleTypeMapping) {
        ValidateResult valResultInfo = new ValidateResult();
        DynamicObject supplier = billObj.getDynamicObject("supplier");
        DynamicObject settleType = billObj.getDynamicObject("settletype");
        if (settleType == null && supplier != null) {
            DynamicObject settlementType = supplier.getDynamicObject("settlementtypeid");
            billObj.set("settletype", (Object)settlementType);
        }
        if (settleType != null) {
            Object pkValue = settleType.getPkValue();
            String number = settleType.getString("number");
            if (settleTypeMapping == null || !settleTypeMapping.containsKey(pkValue)) {
                String errMsg = String.format(ResManager.loadKDString((String)"\uff08\u4f9b\u5e94\u5546\u6216\u5bfc\u5165\u7684\uff09\u7ed3\u7b97\u65b9\u5f0f\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\u3002", (String)"ImptValidateHelperCkcheckSettleType", (String)"scmc-im-business", (Object[])new Object[0]), number);
                valResultInfo.setErrValResult(errMsg);
            }
        }
        return valResultInfo;
    }

    public static ValidateResult checkPayCondition(DynamicObject billObj, Map<Object, DynamicObject> payConditionMapping) {
        ValidateResult valResultInfo = new ValidateResult();
        DynamicObject supplier = billObj.getDynamicObject("supplier");
        DynamicObject payCondition = billObj.getDynamicObject("paycondition");
        if (payCondition == null && supplier != null) {
            DynamicObject payCond = supplier.getDynamicObject("paycond");
            billObj.set("paycondition", (Object)payCond);
        }
        if (payCondition != null) {
            Object pkValue = payCondition.getPkValue();
            String number = payCondition.getString("number");
            if (payConditionMapping == null || !payConditionMapping.containsKey(pkValue)) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6761\u4ef6\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\u3002", (String)"ImptValidateHelperCkPayCondition", (String)"scmc-im-business", (Object[])new Object[0]), number);
                valResultInfo.setErrValResult(errMsg);
            }
        }
        return valResultInfo;
    }

    public static ValidateResult checkTaxRateId(DynamicObject billObj, DynamicObject entryObj, Map<Object, DynamicObject> taxRateIdMapping) {
        ValidateResult valResultInfo = new ValidateResult();
        Date bizTime = billObj.getDate("biztime");
        DynamicObject taxRateId = entryObj.getDynamicObject("taxrateid");
        Object taxRateIdPk = taxRateId.getPkValue();
        DynamicObject taxRate = taxRateIdMapping.get(taxRateIdPk);
        if (taxRate != null) {
            Date activedate = taxRateId.getDate("activedate");
            Date expdate = taxRateId.getDate("expdate");
            Object taxrate = taxRateId.get("taxrate");
            if (activedate.compareTo(bizTime) > 0 || expdate != null && expdate.compareTo(bizTime) < 0) {
                String errMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u4e0d\u5728\u7a0e\u7387\u751f\u6548\u65e5\u671f\u8303\u56f4\u5185\u3002", (String)"ImptValidateHelperCkTaxRateId", (String)"scmc-im-business", (Object[])new Object[0]);
                valResultInfo.setErrValResult(errMsg);
                return valResultInfo;
            }
            entryObj.set("taxrate", taxrate);
        }
        return valResultInfo;
    }

    public static ValidateResult checkProject(DynamicObject project) {
        ValidateResult valResultInfo = new ValidateResult();
        if (project != null) {
            String status = project.getString("status");
            boolean enable = project.getBoolean("enable");
            if (!"C".equals(status) || !enable) {
                String proNum = project.getString("number");
                String errMsg = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u53f7\u201c%s\u201d\u672a\u5ba1\u6838\u6216\u8005\u672a\u542f\u7528,\u8bf7\u5148\u5ba1\u6838\u6216\u542f\u7528\u3002", (String)"ImptValidateHelperCkProject_1", (String)"scmc-im-business", (Object[])new Object[0]), proNum);
                valResultInfo.setErrValResult(errMsg);
                return valResultInfo;
            }
        }
        return valResultInfo;
    }

    private static ValidateResult shelflifeHandle(DynamicObject entryObj, Date producedate, Date expirydate, DynamicObject materialInfo) {
        ValidateResult valResultInfo = new ValidateResult();
        DynamicObject materialObj = materialInfo.getDynamicObject("masterid");
        String materialNum = materialObj.getString("number");
        String caldirec = materialInfo.getString("caldirection");
        String string = caldirec = StringUtils.isBlank((String)caldirec) ? CalDirectionEnum.CALBOTH.getValue() : caldirec;
        if (!caldirec.equals(CalDirectionEnum.CALNONE.getValue())) {
            if (caldirec.equals(CalDirectionEnum.CALBOTH.getValue())) {
                if (producedate != null) {
                    ImptValidateHelper.setDate(entryObj, producedate, valResultInfo, true);
                } else if (expirydate != null) {
                    ImptValidateHelper.setDate(entryObj, expirydate, valResultInfo, false);
                }
            } else if (caldirec.equals(CalDirectionEnum.CALENDDATE.getValue())) {
                if (producedate != null && expirydate == null) {
                    ImptValidateHelper.setDate(entryObj, producedate, valResultInfo, true);
                }
            } else if (caldirec.equals(CalDirectionEnum.CALSTARTDATE.getValue()) && expirydate != null && producedate == null) {
                ImptValidateHelper.setDate(entryObj, expirydate, valResultInfo, false);
            }
        }
        producedate = entryObj.getDate("producedate");
        expirydate = entryObj.getDate("expirydate");
        if (producedate != null && expirydate != null && producedate.after(expirydate)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5230\u671f\u65e5\u671f\u3002", (String)"InvBillImptShelflifeDateErr_4", (String)"scmc-im-business", (Object[])new Object[0]), materialNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }
}

