/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.impt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.util.JSONUtils;
import kd.scmc.im.business.balance.recal.BalReCalCache;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.enums.EnableStatusEnum;

public class ImptDataSourceHelper {
    public static Map<Long, List<Long>> getPurToReqOrgs(Set<Long> purOrgIds) {
        HashMap<Long, List<Long>> purToReqOrgs = new HashMap<Long, List<Long>>();
        ArrayList<Long> bosOrgs = new ArrayList<Long>(ImptDataSourceHelper.getBosOrgs());
        for (Long orgId : purOrgIds) {
            List reqOrgs = OrgUnitServiceHelper.getFromOrgs((String)OrgViewTypeEnum.IS_PURCHASE.getViewType(), (Long)orgId, (String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (boolean)true);
            if (reqOrgs == null || reqOrgs.isEmpty()) {
                purToReqOrgs.put(orgId, bosOrgs);
                continue;
            }
            purToReqOrgs.put(orgId, reqOrgs);
        }
        return purToReqOrgs;
    }

    public static Map<Long, List<Long>> getInvToPurOrgs(Set<Long> orgIds) {
        HashMap<Long, List<Long>> invToPurOrgs = new HashMap<Long, List<Long>>();
        QFilter purFunFilter = ImptDataSourceHelper.getEnableFilter();
        purFunFilter.and("fispurchase", "=", (Object)Boolean.TRUE);
        Map purFunOrgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])purFunFilter.toArray());
        ArrayList<Long> toPurOrgIds = new ArrayList<Long>(10);
        for (Object purOrgId : purFunOrgs.keySet()) {
            Long purOrgIdTemp = Long.valueOf(String.valueOf(purOrgId));
            toPurOrgIds.add(purOrgIdTemp);
        }
        for (Long orgId : orgIds) {
            List purOrgs = OrgUnitServiceHelper.getFromOrgs((String)OrgViewTypeEnum.IS_INVENTORY.getViewType(), (Long)orgId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType(), (boolean)true);
            if (purOrgs == null || purOrgs.isEmpty()) {
                invToPurOrgs.put(orgId, toPurOrgIds);
                continue;
            }
            invToPurOrgs.put(orgId, purOrgs);
        }
        return invToPurOrgs;
    }

    public static Map<Long, List<Long>> getOrgToDepts(Set<Long> orgIds, Map<Long, Long> orgToDefDeptId) {
        HashMap<Long, List<Long>> orgToDepts = new HashMap<Long, List<Long>>(16);
        QFilter adminOrgFilter = ImptDataSourceHelper.getAuditedFilter();
        Map adminOrgs = BusinessDataServiceHelper.loadFromCache((String)"bos_adminorg", (String)"id", (QFilter[])adminOrgFilter.toArray());
        Set adminOrgIds = adminOrgs.keySet();
        ArrayList<Long> toAdminOrgIds = new ArrayList<Long>(10);
        for (Object k : adminOrgIds) {
            Long orgIdTemp = Long.valueOf(String.valueOf(k));
            toAdminOrgIds.add(orgIdTemp);
        }
        for (Long l : orgIds) {
            List subDeptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(l), (boolean)true);
            if (subDeptIds.isEmpty()) {
                orgToDepts.put(l, toAdminOrgIds);
                continue;
            }
            orgToDepts.put(l, subDeptIds);
        }
        if (orgToDefDeptId == null || orgToDefDeptId.isEmpty()) {
            return orgToDepts;
        }
        for (Map.Entry entry : orgToDefDeptId.entrySet()) {
            Long orgId = (Long)entry.getKey();
            Long deptId = (Long)entry.getValue();
            List deptIds = (List)orgToDepts.get(orgId);
            if (deptIds == null) {
                orgToDepts.put(orgId, Collections.singletonList(deptId));
                continue;
            }
            if (deptIds.contains(deptId)) continue;
            deptIds.add(deptId);
        }
        return orgToDepts;
    }

    public static Map<Long, List<Long>> getOrgToBizDepts(Set<Long> orgIds) {
        return ImptDataSourceHelper.getOrgToDepts(orgIds, null);
    }

    public static Map<String, Object> getMaterialToAuxptys(Set<Long> materialIds) {
        HashMap<String, Object> proKeyToAuxInfo = new HashMap<String, Object>(16);
        HashMap<Long, Integer> materialToAuxptySize = new HashMap<Long, Integer>(16);
        HashMap materialToAuxSetup = new HashMap(16);
        QFilter materialFilter = new QFilter("id", "in", materialIds);
        QFilter flexProFilter = ImptDataSourceHelper.getAuditedFilter();
        DataSet materialSet = QueryServiceHelper.queryDataSet((String)ImptDataSourceHelper.getAlgoKey(), (String)"bd_material", (String)"id as materialId,auxptyentry.auxpty as auxptyId", (QFilter[])materialFilter.toArray(), (String)"");
        DataSet flexProSet = QueryServiceHelper.queryDataSet((String)ImptDataSourceHelper.getAlgoKey(), (String)"bd_auxproperty", (String)"id as auxptyId,flexfield,valuetype,manuallydatatype as datatype,istrim,name as auxptyName", (QFilter[])flexProFilter.toArray(), (String)"");
        DataSet auxptyInfoSet = materialSet.join(flexProSet, JoinType.INNER).select(new String[]{"materialId", "auxptyId"}, new String[]{"flexfield", "valuetype", "datatype", "istrim", "auxptyName"}).on("auxptyId", "auxptyId").finish();
        while (auxptyInfoSet.hasNext()) {
            int auxptySize = 0;
            HashMap<String, Object> auxDataSetup = new HashMap<String, Object>(16);
            Row row = auxptyInfoSet.next();
            Long materialId = row.getLong("materialId");
            String valueType = row.getString("valuetype");
            auxptySize = !materialToAuxptySize.containsKey(materialId) ? 1 : (Integer)materialToAuxptySize.get(materialId) + 1;
            materialToAuxptySize.put(materialId, auxptySize);
            if (!"3".equals(valueType)) continue;
            String flexfield = row.getString("flexfield");
            String dataType = row.getString("datatype");
            Boolean istrim = row.getBoolean("istrim");
            String auxptyName = row.getString("auxptyName");
            try {
                Map dataTypeData = (Map)JSONUtils.cast((String)dataType, Map.class);
                String valType = (String)dataTypeData.get("type");
                if ("decimal".equals(valType)) {
                    Double minValue = (Double)dataTypeData.get("min");
                    Double maxValue = (Double)dataTypeData.get("max");
                    Integer precision = (Integer)dataTypeData.get("precision");
                    Integer scale = (Integer)dataTypeData.get("scale");
                    auxDataSetup.put("minValue", minValue);
                    auxDataSetup.put("maxValue", maxValue);
                    auxDataSetup.put("precision", precision);
                    auxDataSetup.put("scale", scale);
                } else if ("varchar".equals(valType)) {
                    Integer length = (Integer)dataTypeData.get("length");
                    auxDataSetup.put("length", length);
                }
                auxDataSetup.put("valType", valType);
                auxDataSetup.put("flexfield", flexfield);
                auxDataSetup.put("istrim", istrim);
                auxDataSetup.put("auxptyName", auxptyName);
                auxDataSetup.put("valueType", valueType);
                if (!materialToAuxSetup.containsKey(materialId)) {
                    materialToAuxSetup.put(materialId, new ArrayList());
                }
                ((List)materialToAuxSetup.get(materialId)).add(auxDataSetup);
            }
            catch (IOException e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8f85\u52a9\u5c5e\u6027\u503c\u65f6\u5f02\u5e38\uff1a%s\u3002", (String)"ImptDataSourceHelperAuxptyParseErr", (String)"scmc-im-business", (Object[])new Object[0]), e.getMessage()));
            }
        }
        proKeyToAuxInfo.put("materialToAuxptySize", materialToAuxptySize);
        proKeyToAuxInfo.put("materialToAuxSetup", materialToAuxSetup);
        return proKeyToAuxInfo;
    }

    public static Map<Long, List<Object>> getOrgToAccountOwners(Set<Long> invOrgIds) {
        HashMap<Long, List<Object>> invOrgToOwners = new HashMap<Long, List<Object>>(16);
        for (Long orgId : invOrgIds) {
            ArrayList<Object> ownerArray = OwnerHelper.getOwners(orgId);
            ArrayList<Object> ownerIds = new ArrayList<Object>(ownerArray);
            invOrgToOwners.put(orgId, ownerIds);
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(invOrgIds);
        Map accountingBizUnit = OrgUnitServiceHelper.getAccountingBizUnit((long)15L, orgIds, (boolean)Boolean.FALSE, (boolean)Boolean.TRUE);
        for (Map.Entry accountingBizEntry : accountingBizUnit.entrySet()) {
            Long orgId = (Long)accountingBizEntry.getKey();
            Map accountingBizMap = (Map)accountingBizEntry.getValue();
            if (accountingBizMap == null || accountingBizMap.isEmpty()) continue;
            Object ownerId = accountingBizMap.get("id");
            invOrgToOwners.putIfAbsent(orgId, new ArrayList(16));
            ((List)invOrgToOwners.get(orgId)).add(ownerId);
        }
        return invOrgToOwners;
    }

    public static Map<Long, Set<Long>> getFixedConvertTypeUnits(Map<Long, Long> materialToBaseUnit) {
        HashMap<Long, Set<Long>> materialToUnits = new HashMap<Long, Set<Long>>(16);
        Set<Long> materialIds = materialToBaseUnit.keySet();
        String selectUnitFields = "measureunitid as unitId,materialid";
        QFilter unitFilter = new QFilter("converttype", "=", (Object)"1");
        unitFilter.and("materialid", "in", materialIds);
        DataSet unitDataSet = QueryServiceHelper.queryDataSet((String)ImptDataSourceHelper.getAlgoKey(), (String)"bd_multimeasureunit", (String)selectUnitFields, (QFilter[])unitFilter.toArray(), (String)"");
        unitDataSet = unitDataSet.select(new String[]{"unitId", "materialid"});
        while (unitDataSet.hasNext()) {
            Row row = unitDataSet.next();
            Long materialId = row.getLong("materialid");
            Long unitId = row.getLong("unitId");
            if (materialId == null) continue;
            if (!materialToUnits.containsKey(materialId)) {
                materialToUnits.put(materialId, new HashSet());
            }
            ((Set)materialToUnits.get(materialId)).add(unitId);
        }
        Set materialToUnits_Key = materialToUnits.keySet();
        for (Long materialId : materialIds) {
            if (!materialToUnits_Key.contains(materialId)) {
                materialToUnits.put(materialId, new HashSet());
            }
            ((Set)materialToUnits.get(materialId)).add(materialToBaseUnit.get(materialId));
        }
        return materialToUnits;
    }

    public static Map<Long, Set<Long>> getOrgToWarehouses(Set<Long> orgIds) {
        return ImptDataSourceHelper.getOrgToWarehouses(orgIds, false);
    }

    public static Map<Long, Set<Long>> getOrgToWarehouses(Set<Long> orgIds, boolean isOpenLocation) {
        HashMap<Long, Set<Long>> orgToWarehouse = new HashMap<Long, Set<Long>>(16);
        if (orgIds.isEmpty()) {
            return orgToWarehouse;
        }
        QFilter whFilter = new QFilter("org", "in", orgIds);
        whFilter.and("startstatus", "=", (Object)"B");
        whFilter.and("initstatus", "=", (Object)"B");
        if (isOpenLocation) {
            whFilter.and("warehouse.isopenlocation", "=", (Object)"1");
        }
        String whSetupSelects = "org.id,warehouse.id";
        Map warehouseSetups = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)whSetupSelects, (QFilter[])whFilter.toArray());
        for (DynamicObject warehouseSetup : warehouseSetups.values()) {
            Long warehouseId = warehouseSetup.getLong("warehouse.id");
            Long orgId = warehouseSetup.getLong("org.id");
            if (!orgToWarehouse.containsKey(orgId)) {
                orgToWarehouse.put(orgId, new HashSet());
            }
            ((Set)orgToWarehouse.get(orgId)).add(warehouseId);
        }
        return orgToWarehouse;
    }

    public static Set<Long> getBizTypes(String formId) {
        HashSet<Long> bizTypeIds = new HashSet<Long>();
        QFilter bizTypeFilter = ImptDataSourceHelper.getAuditedFilter();
        bizTypeFilter.and("billentity.billform", "=", (Object)formId);
        Map bizTypes = BusinessDataServiceHelper.loadFromCache((String)"bd_biztype", (String)"id", (QFilter[])bizTypeFilter.toArray());
        if (bizTypes != null && !bizTypes.isEmpty()) {
            for (DynamicObject bizTypeObj : bizTypes.values()) {
                Long bizTypeId = bizTypeObj.getLong("id");
                bizTypeIds.add(bizTypeId);
            }
        }
        return bizTypeIds;
    }

    @Deprecated
    public static Set<Long> getHasPermissionOrgIds(String formId) {
        long userId = RequestContext.get().getCurrUserId();
        IAppCache appCache = BalReCalCache.getImAppCache();
        List<Map<String, String>> hasPermissionOrgs = (List<Map<String, String>>)appCache.get(ImptDataSourceHelper.class.getName() + userId, List.class);
        if (hasPermissionOrgs == null) {
            hasPermissionOrgs = NewInvOrgHelper.getHasPermissionAndStartedInvOrg(formId);
            appCache.put(ImptDataSourceHelper.class.getName() + userId, hasPermissionOrgs);
        }
        HashSet<Long> orgIds = new HashSet<Long>(16);
        if (hasPermissionOrgs == null || hasPermissionOrgs.isEmpty()) {
            return orgIds;
        }
        for (Map<String, String> orgData : hasPermissionOrgs) {
            orgIds.add(Long.valueOf(orgData.get("id")));
        }
        return orgIds;
    }

    public static Set<Long> getHasPermissionOrgIds(String formId, String appId) {
        long userId = RequestContext.get().getCurrUserId();
        IAppCache appCache = BalReCalCache.getImAppCache();
        List<Map<String, String>> hasPermissionOrgs = (List<Map<String, String>>)appCache.get(ImptDataSourceHelper.class.getName() + userId, List.class);
        if (hasPermissionOrgs == null) {
            hasPermissionOrgs = NewInvOrgHelper.getHasPermissionAndStartedInvOrg(formId, appId);
            appCache.put(ImptDataSourceHelper.class.getName() + userId, hasPermissionOrgs);
        }
        HashSet<Long> orgIds = new HashSet<Long>(16);
        if (hasPermissionOrgs == null || hasPermissionOrgs.isEmpty()) {
            return orgIds;
        }
        for (Map<String, String> orgData : hasPermissionOrgs) {
            orgIds.add(Long.valueOf(orgData.get("id")));
        }
        return orgIds;
    }

    public static Map<Long, String> getBillToTransceiver(Map<Long, List<Long>> invschemeToBills) {
        HashMap<Long, String> billToTransceiver = new HashMap<Long, String>();
        QFilter invSeFilter = new QFilter("id", "in", invschemeToBills.keySet());
        DynamicObjectCollection invschemes = QueryServiceHelper.query((String)"im_invscheme", (String)"id as invschemeId,transceivertype.transceiver as transceiver", (QFilter[])invSeFilter.toArray());
        for (DynamicObject invscheme : invschemes) {
            Long invschemeId = invscheme.getLong("invschemeId");
            String transceiver = invscheme.getString("transceiver");
            List<Long> billIds = invschemeToBills.get(invschemeId);
            for (Long billId : billIds) {
                billToTransceiver.put(billId, transceiver);
            }
        }
        return billToTransceiver;
    }

    public static Map<String, List<String>> getHasPermissionOrgs(String formId) {
        RequestContext requestContext = RequestContext.get();
        String currUserId = requestContext.getUserId();
        HashMap<String, List<String>> userToPermissOrgs = new HashMap<String, List<String>>();
        List<Map<String, String>> hasPermissionOrgs = NewInvOrgHelper.getHasPermissionAndStartedInvOrg(formId);
        if (hasPermissionOrgs == null || hasPermissionOrgs.isEmpty()) {
            return new HashMap<String, List<String>>();
        }
        for (Map<String, String> orgData : hasPermissionOrgs) {
            if (!userToPermissOrgs.containsKey(currUserId)) {
                userToPermissOrgs.put(currUserId, new ArrayList(10));
            }
            ((List)userToPermissOrgs.get(currUserId)).add(orgData.get("number"));
        }
        return userToPermissOrgs;
    }

    public static Map<String, List<Long>> getBillBizTypeToInvschemes(Set<String> billBizTypeKeys) {
        ArrayList<QFilter> invschemeFilters = new ArrayList<QFilter>(10);
        for (String billBizTypeKey : billBizTypeKeys) {
            int dotIndex = billBizTypeKey.indexOf(46);
            String formId = billBizTypeKey.substring(0, dotIndex);
            Long bizTypeId = Long.valueOf(billBizTypeKey.substring(dotIndex + 1, billBizTypeKey.length()));
            QFilter InvschemeFilter = new QFilter("billform", "=", (Object)formId);
            InvschemeFilter.and("bitypeentry.biztype", "=", (Object)bizTypeId);
            InvschemeFilter.and("enable", "=", (Object)Boolean.TRUE);
            invschemeFilters.add(InvschemeFilter);
        }
        DynamicObjectCollection invschemes = QueryServiceHelper.query((String)"im_invscheme", (String)"id,billform,bitypeentry.biztype as biztypeid", (QFilter[])invschemeFilters.toArray(new QFilter[invschemeFilters.size()]));
        HashMap<String, List<Long>> billBizTypeToInvschemes = new HashMap<String, List<Long>>(16);
        for (DynamicObject invscheme : invschemes) {
            Long invschemeId = invscheme.getLong("id");
            String billForm = invscheme.getString("billform");
            Long bizTypeId = invscheme.getLong("biztypeid");
            String billBizTypeKey = billForm + "." + bizTypeId;
            if (!billBizTypeToInvschemes.containsKey(billBizTypeKey)) {
                billBizTypeToInvschemes.put(billBizTypeKey, new ArrayList());
            }
            ((List)billBizTypeToInvschemes.get(billBizTypeKey)).add(invschemeId);
        }
        return billBizTypeToInvschemes;
    }

    public static Set<Long> getBosOrgs() {
        HashSet<Long> bosOrgs = new HashSet<Long>(16);
        Map orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])ImptDataSourceHelper.getEnableFilter().toArray());
        for (Object obj : orgs.keySet()) {
            Long orgId = Long.valueOf(String.valueOf(obj));
            bosOrgs.add(orgId);
        }
        return bosOrgs;
    }

    private static QFilter getAuditedFilter() {
        QFilter auditedFilter = ImptDataSourceHelper.getEnableFilter();
        auditedFilter.and("status", "=", (Object)"C");
        return auditedFilter;
    }

    private static QFilter getEnableFilter() {
        return new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
    }

    private static String getAlgoKey() {
        return ImptDataSourceHelper.class.getName();
    }
}

