/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.invplan;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.bos.util.SAXReaderUtil;
import kd.scmc.im.consts.InvPlanConst;
import kd.scmc.im.enums.InitContextEnum;
import org.dom4j.Document;

public class InvPlanInitHelper {
    private static final Log log = LogFactory.getLog(InvPlanInitHelper.class);
    private static final String CREATEORG = "createorg";
    private static final String ISREDLIGHT = "isredlight";
    private static final String ISYELLOWLIGHT = "isyellowlight";
    private static final String ISGREENLIGHT = "isgreenlight";
    private static final String ISSHOW = "isshow";
    private static final String PRIORITY = "priority";
    private static final String MRP_EXCEPTIONGROUP = "mrp_exceptiongroup";
    private static final String MRP_DEFINITIONEXCEPTION = "mrp_definitionexception";
    private static final String NUMBER = "number";
    private static final String STATUS = "status";
    private static final String NAME = "name";
    private static final String ENABLE = "enable";
    private static final String INIT_STATUS = "initstatus";
    private static final String CREATOR = "creator";
    private static final String CREATETIME = "createtime";
    private static final String CTRLSTRATEGY = "ctrlstrategy";
    private static final String ISVISIBLE = "isvisible";
    private static final String GROUP = "group";

    public static void initConfigData(long orgId) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
        ArrayList<InitContextEnum> values = new ArrayList<InitContextEnum>(Arrays.asList(InitContextEnum.values()));
        DataSet initItems = QueryServiceHelper.queryDataSet((String)InvPlanInitHelper.class.getName(), (String)"im_invplaninit", (String)"inittype", (QFilter[])new QFilter[]{qFilter}, null);
        while (initItems.hasNext()) {
            Row row = initItems.next();
            InitContextEnum num = InitContextEnum.fromName((String)row.getString("inittype"));
            if (num == null) continue;
            values.remove(num);
        }
        for (InitContextEnum initContextEnum : values) {
            DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"im_invplaninit");
            data.set("org", (Object)orgId);
            data.set(CREATETIME, (Object)new Date());
            data.set(CREATOR, (Object)RequestContext.get().getCurrUserId());
            data.set(INIT_STATUS, (Object)"0");
            data.set("inittype", (Object)initContextEnum.getName());
            data.set("inittext", (Object)initContextEnum.getValue());
            list.add(data);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    public static void initMrpData(long useOrgId, List<Long> ids, long calcId) {
        if (!ids.isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", ids);
            ArrayList<InitContextEnum> initEnums = new ArrayList<InitContextEnum>(ids.size());
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)InvPlanInitHelper.class.getName(), (String)"im_invplaninit", (String)"id,inittype", (QFilter[])new QFilter[]{qFilter}, null);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                InitContextEnum initEnum = InitContextEnum.fromName((String)row.getString("inittype"));
                if (initEnum == null) continue;
                initEnums.add(initEnum);
            }
            for (InitContextEnum initEnum : initEnums) {
                switch (initEnum) {
                    case ResModule: {
                        InvPlanInitHelper.initData(useOrgId, "mrp_resourceregister_cf", true);
                        break;
                    }
                    case AlgoModule: {
                        if (calcId > 0L) {
                            InvPlanInitHelper.initData(useOrgId, "mrp_businessplan", true);
                            break;
                        }
                        InvPlanInitHelper.initData(useOrgId, "mrp_calplanconfig", true);
                        break;
                    }
                    case ExceptionMsg: {
                        InvPlanInitHelper.initException(useOrgId);
                        break;
                    }
                }
            }
            long userId = RequestContext.get().getCurrUserId();
            Timestamp timestamp = new Timestamp(new Date().getTime());
            String updateSql = "update t_im_invplaninit set finitstatus = '1',fmodifierid = ?, fmodifytime = ? where fid = ?";
            ArrayList<Object[]> params = new ArrayList<Object[]>(ids.size());
            for (Long id : ids) {
                Object[] p = new Object[]{userId, timestamp, id};
                params.add(p);
            }
            DB.executeBatch((DBRoute)new DBRoute("scm"), (String)updateSql, params);
        }
    }

    public static void initData(long orgId, String entity, boolean isReload) {
        if (StringUtils.isBlank((CharSequence)entity)) {
            return;
        }
        Map initSql = (Map)InvPlanConst.SQL.get(entity);
        if (initSql == null) {
            return;
        }
        String defaultCtrlStrategy = InvPlanInitHelper.getDefaultCtrlStrategy(entity);
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
        Object[] value = InvPlanInitHelper.getInsertValue(entity, defaultCtrlStrategy, orgId);
        HashMap exeSqls = new HashMap(initSql.size());
        boolean isPrivate = StringUtils.equals((CharSequence)defaultCtrlStrategy, (CharSequence)"7");
        Map<String, Long> oldPrivateDataId = null;
        if (isReload) {
            if (isPrivate) {
                oldPrivateDataId = InvPlanInitHelper.getPrivateOldData(entity, initSql.keySet(), orgId);
            }
            exeSqls.putAll(initSql);
        } else {
            for (Map.Entry entry : initSql.entrySet()) {
                QFilter qFilter = new QFilter(NUMBER, "=", entry.getKey());
                if (isPrivate) {
                    qFilter.and(new QFilter(CREATEORG, "=", (Object)orgId));
                }
                if (QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{qFilter})) continue;
                exeSqls.put(entry.getKey(), entry.getValue());
            }
        }
        Map idMap = InvPlanConst.DATA_IDS.getOrDefault(entity, new HashMap(0));
        for (Map.Entry entry : exeSqls.entrySet()) {
            Long id = idMap.getOrDefault(entry.getKey(), 0L);
            Long oldId = oldPrivateDataId != null ? oldPrivateDataId.get(entry.getKey()) : null;
            InvPlanInitHelper.insertData(isPrivate, isReload, entity, id, (String)entry.getKey(), (String)entry.getValue(), org, user, value, oldId);
        }
    }

    private static void clearCache(String entity, Long useorgId) {
        BaseDataService baseDataService = new BaseDataService();
        baseDataService.clearBaseDataFilterCache(entity, useorgId);
        ArrayList<Long> orgIdList = new ArrayList<Long>(8);
        orgIdList.add(useorgId);
        BaseDataServiceHelper.refreshBaseDataUseRange((String)entity, orgIdList);
    }

    private static Map<String, Long> getPrivateOldData(String entity, Set<String> nums, Long orgId) {
        HashMap<String, Long> oldPrivateDataId = new HashMap<String, Long>(nums.size());
        QFilter qFilter = new QFilter(NUMBER, "in", nums);
        qFilter.and(new QFilter(CREATEORG, "=", (Object)orgId));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)InvPlanInitHelper.class.getName(), (String)entity, (String)"number,id", (QFilter[])new QFilter[]{qFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                oldPrivateDataId.put(row.getString(NUMBER), row.getLong("id"));
            }
        }
        return oldPrivateDataId;
    }

    private static Long insertData(boolean isPrivate, boolean isReload, String entity, Long id, String num, String sql, DynamicObject org, DynamicObject user, Object[] value, Long oldId) {
        Long result = isPrivate && QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)}) ? InvPlanInitHelper.insertPrivateData(entity, id, num, org, user, oldId, isReload) : InvPlanInitHelper.insertSharedData(entity, sql, id, org, value, user, isReload);
        Long orgId = org == null ? 0L : org.getLong("id");
        InvPlanInitHelper.clearCache(entity, orgId);
        return result;
    }

    private static Long insertSharedData(String entity, String sql, Long id, DynamicObject org, Object[] value, DynamicObject user, boolean isReload) {
        if (!isReload && QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)})) {
            return id;
        }
        switch (entity) {
            case "mrp_calplanconfig": {
                InvPlanInitHelper.loopInsertValue("mrp_businessplan", "7", org, user, isReload);
                break;
            }
            case "mrp_businessplan": {
                InvPlanInitHelper.loopInsertValue("mrp_algoregister", "5", org, user, isReload);
            }
            case "mrp_resourceregister_cf": {
                InvPlanInitHelper.loopInsertValue("mrp_billfieldtransfer", "5", org, user, isReload);
            }
        }
        InvPlanInitHelper.executeSql(new DBRoute(InvPlanInitHelper.getDbKey(entity)), sql, value);
        return id;
    }

    private static void executeSql(DBRoute dbRoute, String sql, Object[] value) {
        String[] sqls;
        for (String s : sqls = sql.split(";\n")) {
            if (s.contains("?")) {
                DB.execute((DBRoute)dbRoute, (String)s, (Object[])value);
                continue;
            }
            DB.execute((DBRoute)dbRoute, (String)s);
        }
    }

    private static void loopInsertValue(String entity, String ctrl, DynamicObject org, DynamicObject user, boolean isReload) {
        Map bizSqls = InvPlanConst.SQL.getOrDefault(entity, new HashMap(0));
        Map bizIds = InvPlanConst.DATA_IDS.getOrDefault(entity, new HashMap(0));
        Long orgId = org == null ? 0L : org.getLong("id");
        Object[] value = InvPlanInitHelper.getInsertValue(entity, ctrl, orgId);
        boolean isPrivate = StringUtils.equals((CharSequence)"7", (CharSequence)ctrl);
        Map<Object, Object> oldPrivateDataId = null;
        oldPrivateDataId = isPrivate ? InvPlanInitHelper.getPrivateOldData(entity, bizSqls.keySet(), orgId) : new HashMap(0);
        for (Map.Entry entry : bizSqls.entrySet()) {
            InvPlanInitHelper.insertData(isPrivate, isReload, entity, (Long)bizIds.get(entry.getKey()), (String)entry.getKey(), (String)entry.getValue(), org, user, value, (Long)oldPrivateDataId.get(entry.getKey()));
        }
    }

    private static Long insertPrivateData(String entity, Long id, String num, DynamicObject org, DynamicObject user, Long oldId, boolean isReload) {
        Long newId = 0L;
        if (id == null || id <= 0L) {
            return newId;
        }
        Long orgId = org == null ? 0L : org.getLong("id");
        Long userId = user == null ? 0L : user.getLong("id");
        String base64 = "";
        switch (entity) {
            case "mrp_calplanconfig": {
                base64 = InvPlanInitHelper.getInitDataCache("calcPlanBase64Cache");
                break;
            }
            case "mrp_businessplan": {
                base64 = InvPlanInitHelper.getInitDataCache("bizBase64Cache");
                break;
            }
            default: {
                return newId;
            }
        }
        ORM orm = ORM.create();
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)entity);
        Object[] deserialize = DynamicObjectSerializeUtil.deserialize((String)base64, (DynamicObjectType)dt);
        DynamicObject newData = (DynamicObject)OrmUtils.clone((Object)deserialize[0], (IDataEntityType)dt, (boolean)true, (boolean)true);
        boolean isSave = false;
        if (oldId != null && oldId > 0L) {
            newId = oldId;
        } else {
            newId = orm.genLongId((IDataEntityType)dt);
            isSave = true;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)entity, (CharSequence)"mrp_calplanconfig")) {
            Map bizIds = InvPlanConst.DATA_IDS.getOrDefault("mrp_businessplan", new HashMap(0));
            Map bizSqls = InvPlanConst.SQL.getOrDefault("mrp_businessplan", new HashMap(0));
            Object[] value = InvPlanInitHelper.getInsertValue("mrp_businessplan", "7", orgId);
            String bizNum = "IM-YWFA-Orignal";
            HashSet<String> bizNums = new HashSet<String>(1);
            bizNums.add(bizNum);
            Map<String, Long> oldPrivateDataId = InvPlanInitHelper.getPrivateOldData("mrp_businessplan", bizNums, orgId);
            Long bizId = InvPlanInitHelper.insertData(true, isReload, "mrp_businessplan", (Long)bizIds.get(bizNum), bizNum, (String)bizSqls.get(bizNum), org, user, value, oldPrivateDataId.get(bizNum));
            DynamicObjectCollection entryentity = newData.getDynamicObjectCollection("entryentity");
            if (entryentity.size() > 0) {
                DynamicObject entry = (DynamicObject)entryentity.get(0);
                entry.set("bizplan", (Object)BusinessDataServiceHelper.loadSingle((Object)bizId, (String)"mrp_businessplan"));
                entry.set("bizplan_id", (Object)bizId);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)entity, (CharSequence)"mrp_businessplan")) {
            InvPlanInitHelper.loopInsertValue("mrp_algoregister", "5", org, user, isReload);
        }
        Date nowTime = new Date();
        newData.set("masterid", (Object)newId);
        newData.set("id", (Object)newId);
        newData.set("createorg_id", (Object)orgId);
        newData.set("org_id", (Object)orgId);
        newData.set("org", (Object)org);
        newData.set(CREATEORG, (Object)org);
        newData.set(CTRLSTRATEGY, (Object)"7");
        newData.set("creator_id", (Object)userId);
        newData.set("modifier_id", (Object)userId);
        newData.set(CREATOR, (Object)user);
        newData.set("modifier", (Object)user);
        newData.set(CREATETIME, (Object)nowTime);
        newData.set("modifytime", (Object)nowTime);
        newData.set("fieldtype", (Object)"1");
        if (isReload || isSave) {
            DeleteServiceHelper.delete((String)entity, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)newId)});
            Object[] objs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newData});
            if (objs.length > 0 && objs[0] instanceof DynamicObject) {
                newId = ((DynamicObject)objs[0]).getLong("id");
            }
        }
        return newId;
    }

    private static String getDefaultCtrlStrategy(String entity) {
        String defaultCtrlStrategy;
        switch (entity) {
            case "mrp_calplanconfig": 
            case "mrp_businessplan": {
                defaultCtrlStrategy = "7";
                break;
            }
            default: {
                defaultCtrlStrategy = "5";
            }
        }
        return defaultCtrlStrategy;
    }

    private static String getDbKey(String entity) {
        return ORM.create().getDataEntityType(entity).getDBRouteKey();
    }

    private static Object[] getInsertValue(String entityKey, String defaultctrlstrategy, Long orgId) {
        Object[] value;
        Date nowTime = new Date();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        switch (entityKey) {
            case "mrp_algoregister": {
                value = new Object[]{orgId, orgId, defaultctrlstrategy, nowTime, userId, nowTime, userId};
                break;
            }
            case "mrp_resourceregister_cf": 
            case "mrp_billfieldtransfer": {
                value = new Object[]{orgId, orgId, nowTime, userId};
                break;
            }
            case "mrp_calplanconfig": {
                value = new Object[]{nowTime, orgId, orgId, userId};
                break;
            }
            case "mrp_businessplan": {
                value = new Object[]{InvPlanInitHelper.getInitDataCache("bizCellStr"), orgId, orgId, defaultctrlstrategy, nowTime, userId, nowTime, InvPlanInitHelper.xmlToString(), userId};
                break;
            }
            default: {
                value = new Object[]{};
            }
        }
        return value;
    }

    private static String getInitDataCache(String key) {
        InputStream in = InvPlanInitHelper.class.getResourceAsStream("/initCache-data");
        ArrayList<String> strs = new ArrayList<String>(6);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                strs.add(line);
            }
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        for (int i = 0; i < strs.size() - 1; ++i) {
            if (!StringUtils.equals((CharSequence)key, (CharSequence)((CharSequence)strs.get(i)))) continue;
            return (String)strs.get(i + 1);
        }
        return null;
    }

    private static Document load() {
        Document document = null;
        try (InputStream in = InvPlanInitHelper.class.getResourceAsStream("/bizPlanXml.xml");){
            document = SAXReaderUtil.getSAXReader().read(in);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return document;
    }

    private static String xmlToString() {
        Document document = InvPlanInitHelper.load();
        String result = "";
        if (document != null) {
            result = document.asXML();
        }
        return result;
    }

    public static void initException(Object createOrgId) {
        DeleteServiceHelper.delete((String)MRP_EXCEPTIONGROUP, (QFilter[])new QFilter[]{new QFilter("createorg.id", "=", createOrgId)});
        DeleteServiceHelper.delete((String)MRP_DEFINITIONEXCEPTION, (QFilter[])new QFilter[]{new QFilter("createorg.id", "=", createOrgId)});
        ArrayList<String> groupList = new ArrayList<String>();
        groupList.add(ResManager.loadKDString((String)"\u8fc7\u53bb\u65e5\u671f\u5f00\u59cb", (String)"InvPlanInitHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
        groupList.add(ResManager.loadKDString((String)"\u8fc7\u53bb\u65e5\u671f\u7ed3\u675f", (String)"InvPlanInitHelper_2", (String)"scmc-im-business", (Object[])new Object[0]));
        groupList.add(ResManager.loadKDString((String)"BOM\u4f8b\u5916", (String)"InvPlanInitHelper_3", (String)"scmc-im-business", (Object[])new Object[0]));
        groupList.add(ResManager.loadKDString((String)"\u5e93\u5b58\u4f8b\u5916", (String)"InvPlanInitHelper_4", (String)"scmc-im-business", (Object[])new Object[0]));
        groupList.add(ResManager.loadKDString((String)"\u7269\u6599\u66ff\u4ee3", (String)"InvPlanInitHelper_5", (String)"scmc-im-business", (Object[])new Object[0]));
        groupList.add(ResManager.loadKDString((String)"\u6392\u7a0b\u4f8b\u5916", (String)"InvPlanInitHelper_6", (String)"scmc-im-business", (Object[])new Object[0]));
        groupList.add(ResManager.loadKDString((String)"\u65b0\u521b\u5efa\u8ba1\u5212", (String)"InvPlanInitHelper_7", (String)"scmc-im-business", (Object[])new Object[0]));
        groupList.add(ResManager.loadKDString((String)"\u6570\u636e\u4f8b\u5916", (String)"InvPlanInitHelper_8", (String)"scmc-im-business", (Object[])new Object[0]));
        DynamicObject[] groupEntities = new DynamicObject[groupList.size()];
        for (int i = 0; i < groupList.size(); ++i) {
            DynamicObject groupObj = BusinessDataServiceHelper.newDynamicObject((String)MRP_EXCEPTIONGROUP);
            groupObj.set(NUMBER, (Object)(i + 1));
            groupObj.set(NAME, groupList.get(i));
            groupObj.set(STATUS, (Object)"C");
            groupObj.set(ENABLE, (Object)"1");
            groupObj.set(CREATOR, (Object)RequestContext.get().getUserId());
            groupObj.set(CREATETIME, (Object)new Date());
            groupObj.set(CREATEORG, createOrgId);
            groupObj.set(CTRLSTRATEGY, (Object)"7");
            groupEntities[i] = groupObj;
        }
        SaveServiceHelper.save((DynamicObject[])groupEntities);
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        String key = MRP_EXCEPTIONGROUP + createOrgId;
        BaseDataCtrlCacheMrg.clearCache((String)type, (String)key);
        DynamicObject[] exceptionEntities = new DynamicObject[35];
        for (int i = 0; i < exceptionEntities.length; ++i) {
            DynamicObject exceptionObj = BusinessDataServiceHelper.newDynamicObject((String)MRP_DEFINITIONEXCEPTION);
            exceptionObj.set(CREATEORG, createOrgId);
            exceptionObj.set(ISVISIBLE, (Object)"1");
            exceptionObj.set(STATUS, (Object)"C");
            exceptionObj.set(CREATOR, (Object)UserServiceHelper.getCurrentUserId());
            exceptionObj.set(ENABLE, (Object)"1");
            exceptionObj.set(CREATETIME, (Object)new Date());
            exceptionObj.set(CTRLSTRATEGY, (Object)"7");
            switch (i) {
                case 0: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[0], "10", ResManager.loadKDString((String)"\u65b0\u589e\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u5728\u8fc7\u53bb\u3002", (String)"InvPlanInitHelper_9", (String)"scmc-im-business", (Object[])new Object[0]), "1", "0", "0", "1", 1);
                    break;
                }
                case 1: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[0], "11", ResManager.loadKDString((String)"\u8fc7\u53bb\u7684\u5f00\u59cb\u65e5\u671f\u3002", (String)"InvPlanInitHelper_10", (String)"scmc-im-business", (Object[])new Object[0]), "1", "0", "0", "1", 2);
                    break;
                }
                case 2: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[1], "20", ResManager.loadKDString((String)"\u65b0\u589e\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u5728\u8fc7\u53bb\u3002", (String)"InvPlanInitHelper_11", (String)"scmc-im-business", (Object[])new Object[0]), "1", "0", "0", "1", 3);
                    break;
                }
                case 3: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[1], "21", ResManager.loadKDString((String)"\u8fc7\u53bb\u7684\u7ed3\u675f\u65e5\u671f\u3002", (String)"InvPlanInitHelper_12", (String)"scmc-im-business", (Object[])new Object[0]), "1", "0", "0", "1", 4);
                    break;
                }
                case 4: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[2], "30", ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5236\u9020BOM\u3002", (String)"InvPlanInitHelper_13", (String)"scmc-im-business", (Object[])new Object[0]), "1", "0", "0", "1", 5);
                    break;
                }
                case 5: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[2], "31", ResManager.loadKDString((String)"\u6ca1\u6709\u5236\u9020BOM\u88ab\u7cfb\u7edf\u9009\u5b9a\uff0c\u68c0\u67e5BOM\u7684\u5f53\u524d\u65f6\u95f4\u662f\u5426\u6709\u6548\u3002", (String)"InvPlanInitHelper_14", (String)"scmc-im-business", (Object[])new Object[0]), "1", "0", "0", "1", 6);
                    break;
                }
                case 6: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[3], "40", ResManager.loadKDString((String)"\u8d85\u51fa\u6700\u9ad8\u5e93\u5b58\u91cf\u3002", (String)"InvPlanInitHelper_15", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 7);
                    break;
                }
                case 7: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[3], "41", ResManager.loadKDString((String)"\u4f4e\u4e8e\u5b89\u5168\u5e93\u5b58", (String)"InvPlanInitHelper_16", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 8);
                    break;
                }
                case 8: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[3], "42", ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u51cf\u5c11", (String)"InvPlanInitHelper_17", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 9);
                    break;
                }
                case 9: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[4], "50", ResManager.loadKDString((String)"\u4e2d\u6b62\u7269\u6599\u90e8\u5206\u88ab\u540e\u7eed\u7269\u6599\u66ff\u4ee3\u3002", (String)"InvPlanInitHelper_18", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 10);
                    break;
                }
                case 10: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[5], "60", ResManager.loadKDString((String)"\u5efa\u8bae\u63d0\u524d", (String)"InvPlanInitHelper_19", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 11);
                    break;
                }
                case 11: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[5], "61", ResManager.loadKDString((String)"\u5efa\u8bae\u5ef6\u540e", (String)"InvPlanInitHelper_20", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 12);
                    break;
                }
                case 12: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[5], "62", ResManager.loadKDString((String)"\u5efa\u8bae\u53d6\u6d88", (String)"InvPlanInitHelper_21", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 13);
                    break;
                }
                case 13: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[5], "63", ResManager.loadKDString((String)"\u4f9d\u8ba1\u5212\u6392\u7a0b", (String)"InvPlanInitHelper_22", (String)"scmc-im-business", (Object[])new Object[0]), "0", "0", "1", "1", 14);
                    break;
                }
                case 14: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[5], "64", ResManager.loadKDString((String)"\u8ba2\u5355\u5efa\u8bae\u88ab\u4fee\u6539\u3002", (String)"InvPlanInitHelper_23", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 15);
                    break;
                }
                case 15: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[6], "70", ResManager.loadKDString((String)"\u65b0\u521b\u5efa\u8ba1\u5212", (String)"InvPlanInitHelper_24", (String)"scmc-im-business", (Object[])new Object[0]), "0", "0", "1", "1", 16);
                    break;
                }
                case 16: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "80", ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u5c06\u4f9b\u5e94\u7ec4\u7ec7\u8bbe\u7f6e\u4e3a\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"InvPlanInitHelper_25", (String)"scmc-im-business", (Object[])new Object[0]), "1", "0", "0", "1", 17);
                    break;
                }
                case 17: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "81", ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\u4e0d\u5339\u914d\u5f02\u5e38\u3002", (String)"InvPlanInitHelper_26", (String)"scmc-im-business", (Object[])new Object[0]), "1", "0", "0", "1", 18);
                    break;
                }
                case 18: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "82", ResManager.loadKDString((String)"\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\uff0c\u4ec5\u4ea7\u751f\u534f\u540c\u8ba1\u5212\u8ba2\u5355\u4f9b\u5e94\u3002", (String)"InvPlanInitHelper_27", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 19);
                    break;
                }
                case 19: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "83", ResManager.loadKDString((String)"\u9700\u6c42\u5355\u636e\u7ec4\u7ec7\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"InvPlanInitHelper_28", (String)"scmc-im-business", (Object[])new Object[0]), "1", "0", "0", "1", 20);
                    break;
                }
                case 20: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "84", ResManager.loadKDString((String)"\u9700\u6c42\u65f6\u95f4\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"InvPlanInitHelper_29", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 21);
                    break;
                }
                case 21: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "85", ResManager.loadKDString((String)"\u4f9b\u5e94\u5355\u636e\u7ec4\u7ec7\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"InvPlanInitHelper_30", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 22);
                    break;
                }
                case 22: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "86", ResManager.loadKDString((String)"\u4f9b\u5e94\u65f6\u95f4\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"InvPlanInitHelper_31", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 23);
                    break;
                }
                case 23: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "87", ResManager.loadKDString((String)"BOM\u5df2\u7ecf\u5931\u6548\u3002", (String)"InvPlanInitHelper_32", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 24);
                    break;
                }
                case 24: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "88", ResManager.loadKDString((String)"\u76f8\u5173\u9700\u6c42\u7269\u6599\u5c5e\u6027\u4e0d\u5b58\u5728\u3002", (String)"InvPlanInitHelper_33", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 25);
                    break;
                }
                case 25: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "89", ResManager.loadKDString((String)"\u5916\u534f\u7ec4\u7ec7\u6b7b\u5faa\u73af\u3002", (String)"InvPlanInitHelper_34", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 26);
                    break;
                }
                case 26: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "90", ResManager.loadKDString((String)"\u672a\u627e\u5230\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"InvPlanInitHelper_35", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 27);
                    break;
                }
                case 27: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "91", ResManager.loadKDString((String)"\u5185\u534f\u4ef6\u9700\u6c42\u7ec4\u7ec7\u4e0d\u80fd\u7b49\u4e8e\u4f9b\u5e94\u7ec4\u7ec7\u3002", (String)"InvPlanInitHelper_36", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 28);
                    break;
                }
                case 28: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "92", ResManager.loadKDString((String)"\u4f9b\u5e94\u6570\u636e\u56e0\u4e3a\u5b89\u5168\u5e93\u5b58\u8c03\u6574\u3002", (String)"InvPlanInitHelper_37", (String)"scmc-im-business", (Object[])new Object[0]), "0", "0", "1", "1", 29);
                    break;
                }
                case 29: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "93", ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u8f6c\u6362\u7387\u7684\u4e09\u54c1\u4ed3\u5e93\u7269\u6599\u3002", (String)"InvPlanInitHelper_38", (String)"scmc-im-business", (Object[])new Object[0]), "0", "0", "1", "1", 30);
                    break;
                }
                case 30: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "94", ResManager.loadKDString((String)"\u9700\u6c42\u65e5\u671f\u56e0\u4e3a\u5b89\u5168\u5e93\u5b58\u63d0\u524d\u3002", (String)"InvPlanInitHelper_39", (String)"scmc-im-business", (Object[])new Object[0]), "0", "0", "1", "1", 31);
                    break;
                }
                case 31: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "95", ResManager.loadKDString((String)"\u672a\u627e\u5230\u5236\u9020\u7b56\u7565\u3002", (String)"InvPlanInitHelper_40", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 32);
                    break;
                }
                case 32: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "96", ResManager.loadKDString((String)"\u672a\u627e\u5230\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f\u3002", (String)"InvPlanInitHelper_41", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 33);
                    break;
                }
                case 33: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "97", ResManager.loadKDString((String)"\u8ba1\u5212\u65b9\u5f0f\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"InvPlanInitHelper_42", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 34);
                    break;
                }
                case 34: {
                    InvPlanInitHelper.setExceptionObj(exceptionObj, groupEntities[7], "98", ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u5360\u7528", (String)"InvPlanInitHelper_43", (String)"scmc-im-business", (Object[])new Object[0]), "0", "1", "0", "1", 35);
                    break;
                }
            }
            exceptionEntities[i] = exceptionObj;
        }
        SaveServiceHelper.save((DynamicObject[])exceptionEntities);
        key = MRP_DEFINITIONEXCEPTION + createOrgId;
        BaseDataCtrlCacheMrg.clearCache((String)type, (String)key);
    }

    private static void setExceptionObj(DynamicObject exceptionObj, DynamicObject group, String number, String name, String isRedLight, String isYellowLight, String isGreenLight, String isShow, int priority) {
        if (exceptionObj == null) {
            return;
        }
        exceptionObj.set(GROUP, (Object)group);
        exceptionObj.set(NUMBER, (Object)number);
        exceptionObj.set(NAME, (Object)name);
        exceptionObj.set(ISREDLIGHT, (Object)isRedLight);
        exceptionObj.set(ISYELLOWLIGHT, (Object)isYellowLight);
        exceptionObj.set(ISGREENLIGHT, (Object)isGreenLight);
        exceptionObj.set(ISSHOW, (Object)isShow);
        exceptionObj.set(PRIORITY, (Object)priority);
    }
}

