/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.invquery;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.helper.invquery.InvqueryHelper;
import kd.scmc.im.consts.InvqueryCfgConst;

public class InvqueryCfgUpgradeHelper {
    protected static final Log logger = LogFactory.getLog(InvqueryCfgUpgradeHelper.class);
    private static final String KEY_CURRENTMETADATAKEY = "currentmetadatakey";
    private static final String DISABLE_METALIST = " ('im_deficitbill','im_lotadjust','im_purreturnbill','im_salreturnbill','im_statusadjust','im_surplusbill','im_typeadjust') ";
    private static final List<String> DISABLE_COLS = Arrays.asList("updatetime", "materialname", "lot", "unit3rd", "qty3rd", "lockqty3rd", "avbqty3rd");

    public static void syncAllMetadataCfg() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select t.fid as billtype from t_meta_mainentityinfo t ", new Object[0]).append("where t.fmodeltype = 'BillFormModel' ", new Object[0]).append("and t.fistemplate = '0' ", new Object[0]).append("and t.fid not in", new Object[0]).append(DISABLE_METALIST, new Object[0]).append("order by t.fid", new Object[0]);
        try (DataSet allBillsDataset = DB.queryDataSet((String)InvqueryCfgUpgradeHelper.class.getName(), (DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder);){
            for (Row row : allBillsDataset) {
                String billtype = row.getString("billtype");
                InvqueryCfgUpgradeHelper.syncMetadataCfg(billtype, true);
            }
        }
    }

    public static void syncMetadataCfg(String billtype, boolean checkItemApFlag) {
        List operateList = EntityMetadataCache.getDataEntityOperate((String)billtype);
        for (Map operateMap : operateList) {
            if (!"scmcinvquery".equals(operateMap.get("type"))) continue;
            String key = null;
            String operatekey = (String)operateMap.get("key");
            boolean findItemFlag = false;
            if (checkItemApFlag) {
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)billtype);
                FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
                EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
                formMeta.bindEntityMetadata(entityMetadata);
                List aps = formMeta.getItems();
                block1: for (ControlAp ap : aps) {
                    BarItemAp barItemAp;
                    if (findItemFlag) break;
                    if (!(ap instanceof BarItemAp) || (barItemAp = (BarItemAp)ap).isHidden()) continue;
                    if (operatekey.equals(barItemAp.getOperationKey())) {
                        key = barItemAp.getKey();
                        findItemFlag = true;
                        break;
                    }
                    List dropdownItems = barItemAp.getDropdownItems();
                    if (dropdownItems == null) continue;
                    for (DropdownItem dropdownItem : dropdownItems) {
                        if (!operatekey.equals(dropdownItem.getOperationKey())) continue;
                        key = dropdownItem.getKey();
                        findItemFlag = true;
                        continue block1;
                    }
                }
            } else {
                findItemFlag = true;
            }
            if (!findItemFlag) continue;
            logger.info("InvqueryCfgSync.syncMetadataCfg:" + billtype + "|key:" + key + "|operatekey:" + operatekey);
            Map mapParam = (Map)operateMap.get("parameter");
            InvqueryCfgUpgradeHelper.genInvQueryCfgFromMeta(billtype, operatekey, (String)mapParam.get("parameter"));
        }
    }

    private static void genInvQueryCfgFromMeta(String billtype, String operatekey, String paramValue) {
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            return;
        }
        Map mapParam = (Map)SerializationUtils.fromJsonString((String)paramValue, Map.class);
        List fieldMaps = (List)mapParam.get("fielddata");
        Map settingParam = (Map)mapParam.get("settingparam");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billtype);
        String entrytype = InvqueryCfgUpgradeHelper.getBillEntryFromFieldmaps(billtype, fieldMaps);
        if (entrytype == null) {
            logger.info(String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e%s\u7684\u5e93\u5b58\u67e5\u8be2\u5b57\u6bb5\u6620\u5c04\u6ca1\u6709\u914d\u7f6e\u5206\u5f55\u5b57\u6bb5\u3002", (String)"InvqueryCfgUpgradeHelper_0", (String)"scmc-im-business", (Object[])new Object[0]), billtype));
        } else {
            DynamicObject cfg = InvqueryHelper.getInvQueryCfg(billtype, operatekey);
            if (cfg == null) {
                InvqueryCfgUpgradeHelper.addcfg(operatekey, billtype, entrytype, settingParam, fieldMaps, mainEntityType);
            } else {
                InvqueryCfgUpgradeHelper.updatecfg(cfg, billtype, entrytype, settingParam, fieldMaps, mainEntityType);
            }
        }
    }

    private static String getBillEntryFromFieldmaps(String billtype, List<Map<String, Object>> fieldMaps) {
        if (fieldMaps == null || fieldMaps.isEmpty()) {
            return null;
        }
        String entrytype = null;
        for (Map<String, Object> field : fieldMaps) {
            String curkey = (String)field.get(KEY_CURRENTMETADATAKEY);
            if (curkey == null || curkey.indexOf(46) == -1) continue;
            String[] curkeys = curkey.split("\\.");
            String curentrytype = curkeys[curkeys.length - 2];
            if (entrytype == null) {
                entrytype = curentrytype;
                continue;
            }
            if (entrytype.equals(curentrytype)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e%s\u7684\u5e93\u5b58\u67e5\u8be2\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\u4e86\u591a\u4e2a\u4e0d\u540c\u5206\u5f55\u5b57\u6bb5,\u8bf7\u5148\u4fee\u6539\u3002", (String)"InvqueryCfgUpgradeHelper_1", (String)"scmc-im-business", (Object[])new Object[0]), billtype));
        }
        return entrytype;
    }

    private static void addcfg(String operatekey, String billtype, String entrytype, Map<String, Object> settingParam, List<Map<String, Object>> fieldMaps, MainEntityType mainEntityType) {
        DynamicObject cfg = BusinessDataServiceHelper.newDynamicObject((String)"im_invqueryconf");
        String cfgnum = InvqueryCfgUpgradeHelper.getCfgNum(billtype);
        Long id = InvqueryCfgUpgradeHelper.getId("t_im_invqueryconf");
        cfg.set("id", (Object)id);
        cfg.set("masterid", (Object)id);
        cfg.set("number", (Object)cfgnum);
        cfg.set("name", (Object)cfgnum);
        cfg.set("enable", (Object)"1");
        cfg.set("status", (Object)"A");
        cfg.set("number", (Object)cfgnum);
        cfg.set("srcbillobj", (Object)billtype);
        cfg.set("operatekey", (Object)operatekey);
        cfg.set("usetype", (Object)"A");
        InvqueryCfgUpgradeHelper.setHeadParam(cfg, billtype, entrytype, settingParam, mainEntityType);
        InvqueryCfgUpgradeHelper.setFieldMap(cfg, fieldMaps, mainEntityType);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cfg});
    }

    private static void updatecfg(DynamicObject cfg, String billtype, String entrytype, Map<String, Object> settingParam, List<Map<String, Object>> fieldMaps, MainEntityType mainEntityType) {
        InvqueryCfgUpgradeHelper.setHeadParam(cfg, billtype, entrytype, settingParam, mainEntityType);
        InvqueryCfgUpgradeHelper.setFieldMap(cfg, fieldMaps, mainEntityType);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cfg});
    }

    private static long getId(String tablename) {
        return DB.genLongId((String)tablename);
    }

    private static String getCfgNum(String billtype) {
        String cfgnumPre = billtype.toUpperCase() + "_U";
        int flownum = 1;
        String cfgnum;
        while (QueryServiceHelper.exists((String)"im_invqueryconf", (QFilter[])new QFilter("number", "=", (Object)(cfgnum = cfgnumPre + flownum)).toArray())) {
            ++flownum;
        }
        return cfgnum;
    }

    private static void setHeadParam(DynamicObject cfg, String billtype, String entrytype, Map<String, Object> settingParam, MainEntityType mainEntityType) {
        cfg.set("srcbillentry", (Object)entrytype);
        EntityType entrytypeObj = (EntityType)mainEntityType.getAllEntities().get(entrytype);
        if (entrytypeObj != null) {
            String entryname = entrytypeObj.getDisplayName().getLocaleValue();
            cfg.set("srcbillentryname", (Object)entryname);
        }
        cfg.set("returntype", settingParam.get("returntype"));
        cfg.set("dealtype", settingParam.get("dealtype"));
        cfg.set("qtyrule", settingParam.get("qtyrule"));
        cfg.set("proqtyfield", settingParam.get("proqtyfield"));
        cfg.set("actionid", settingParam.get("actionid"));
        cfg.set("newdeal", (Object)((Boolean)settingParam.get("newdeal")));
        cfg.set("entrynoupdatefieldkey", settingParam.get("entrynoupdatefieldkey"));
        cfg.set("pluginname", settingParam.get("pluginname"));
        cfg.set("filterpluginname", settingParam.get("filterpluginname"));
        cfg.set("matchshortage", (Object)"popconfirm");
        cfg.set("saveshortagerow", (Object)Boolean.FALSE);
    }

    private static void setFieldMap(DynamicObject cfg, List<Map<String, Object>> fieldMaps, MainEntityType mainEntityType) {
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("entryentity");
        entries.clear();
        int seq = 1;
        for (Map<String, Object> fieldMap : fieldMaps) {
            String metakey;
            boolean qfilterflag = (Boolean)fieldMap.get("qfilter");
            boolean updateflag = (Boolean)fieldMap.get("update");
            boolean matchflag = (Boolean)fieldMap.get("match");
            String billkey = (String)fieldMap.get(KEY_CURRENTMETADATAKEY);
            if (!billkey.contains(".")) {
                updateflag = false;
                matchflag = false;
            }
            if ("material".equals(metakey = (String)fieldMap.get("metadatakey"))) {
                qfilterflag = true;
                updateflag = true;
                matchflag = true;
            } else if (InvqueryCfgConst.ALLQTYFIELDS.contains(metakey)) {
                qfilterflag = false;
            }
            if (!qfilterflag && !updateflag && !matchflag || !StringUtils.isNotBlank((CharSequence)billkey) || DISABLE_COLS.contains(metakey)) continue;
            DynamicObject entry = entries.addNew();
            entry.set("seq", (Object)seq);
            entry.set("invacccolno", fieldMap.get("metadata"));
            entry.set("invacccol", (Object)metakey);
            entry.set("srcbillcolno", (Object)InvqueryCfgUpgradeHelper.getSrcBillColName(mainEntityType, billkey));
            entry.set("srcbillcol", (Object)billkey);
            entry.set("qfilter", (Object)qfilterflag);
            entry.set("update", (Object)updateflag);
            entry.set("match", (Object)matchflag);
            entry.set("returnorder", (Object)InvqueryHelper.getDefaultReturnOrder(metakey));
            if ("org".equals(metakey) || "material".equals(metakey)) {
                entry.set("fieldmustinput", (Object)true);
            }
            ++seq;
        }
    }

    private static String getSrcBillColName(MainEntityType mainEntityType, String billkey) {
        Map allEntities = mainEntityType.getAllEntities();
        Map allFields = mainEntityType.getAllFields();
        String[] billkeys = billkey.split("\\.");
        if (billkeys.length == 1) {
            return ((IDataEntityProperty)allFields.get(billkey)).getDisplayName().getLocaleValue();
        }
        StringBuilder srcBillColNameBuilder = new StringBuilder();
        for (int i = 0; i < billkeys.length - 1; ++i) {
            srcBillColNameBuilder.append(((EntityType)allEntities.get(billkeys[i])).getDisplayName().getLocaleValue()).append('.');
        }
        srcBillColNameBuilder.append(((IDataEntityProperty)allFields.get(billkeys[billkeys.length - 1])).getDisplayName().getLocaleValue());
        return srcBillColNameBuilder.toString();
    }
}

