/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.logisticsbill;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;

public class LogisticsModelMatch {
    private DynamicObject cfg;
    private IDataModel model;
    private int entrySize = 0;
    private Integer priority;

    private LogisticsModelMatch(DynamicObject cfg, IDataModel model) {
        this.model = model;
        this.cfg = cfg;
        this.priority = cfg.getInt("priority");
        this.entrySize = model.getEntryRowCount("billentry");
    }

    public static LogisticsModelMatch getInstance(DynamicObject cfg, IDataModel model) {
        return new LogisticsModelMatch(cfg, model);
    }

    public boolean isLogistcsBill() {
        String filterstr = this.cfg.getString("billfilterstr_tag");
        if (StringUtils.isEmpty((CharSequence)filterstr)) {
            return true;
        }
        MainEntityType entityType = this.model.getDataEntityType();
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterstr, FilterCondition.class);
        this.updateFilterCondition(condition);
        FilterBuilder fb = new FilterBuilder(entityType, condition);
        String[] script = fb.buildFilterScript();
        BOSExpression expr = new BOSExpression(script[0]);
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        Set vars = expr.getVars();
        if (vars.isEmpty()) {
            return true;
        }
        for (String var : vars) {
            String[] sp = var.split("\\.");
            IDataEntityProperty property = entityType.findProperty(sp[0]);
            if (property == null || property instanceof EntryProp || property instanceof BillStatusProp) continue;
            if (property instanceof MuliLangTextProp) {
                ctx.put(var, ((OrmLocaleValue)this.model.getValue(var)).getLocaleValue());
                continue;
            }
            ctx.put(var, this.getProValue(var));
        }
        boolean exec = (Boolean)FormulaEngine.execExcelFormula((Expr)expr.getExpr(), ctx, null);
        return exec;
    }

    private void updateFilterCondition(FilterCondition condition) {
        List filterRow = condition.getFilterRow();
        Iterator it = filterRow.iterator();
        while (it.hasNext()) {
            SimpleFilterRow next = (SimpleFilterRow)it.next();
            String fieldName = next.getFieldName();
            if (StringUtils.isBlank((CharSequence)fieldName) || !fieldName.contains("billentry") && !fieldName.contains("billstatus")) continue;
            it.remove();
        }
    }

    private Object getProValue(String var) {
        String[] sp = var.split("\\.");
        Object value = null;
        for (int i = 0; i < sp.length; ++i) {
            if (i == 0) {
                value = this.model.getValue(sp[i]);
                continue;
            }
            if (value == null) {
                return value;
            }
            value = ((DynamicObject)value).get(sp[i]);
        }
        if (value instanceof OrmLocaleValue) {
            value = ((OrmLocaleValue)value).getLocaleValue();
        }
        return value;
    }

    public void execute() {
        String balanceorg = this.cfg.getString("balanceorg");
        String ownerorg = this.cfg.getString("ownerorg");
        if (StringUtils.isBlank((CharSequence)balanceorg) || StringUtils.isBlank((CharSequence)ownerorg)) {
            return;
        }
        MainEntityType entityType = this.model.getDataEntityType();
        Map<Object, DynamicObject> balanceMap = this.getOrgValueMap(entityType, balanceorg);
        Map<Object, DynamicObject> ownerMap = this.getOrgValueMap(entityType, ownerorg);
        this.match(balanceMap, ownerMap);
    }

    private void match(Map<Object, DynamicObject> balanceMap, Map<Object, DynamicObject> ownerMap) {
        for (int i = 0; i < this.entrySize; ++i) {
            DynamicObject balance = balanceMap.get(i);
            DynamicObject owner = ownerMap.get(i);
            this.model.setValue("logisticsbill", (Object)(balance != null && owner != null && !this.baseEquals(balance, owner) ? 1 : 0), i);
        }
    }

    public Integer getPriority() {
        return this.priority;
    }

    private Map<Object, DynamicObject> getOrgValueMap(MainEntityType entityType, String orgKey) {
        HashMap<Object, DynamicObject> orgMap = new HashMap<Object, DynamicObject>(this.entrySize);
        String[] sp = orgKey.split("\\.");
        IDataEntityProperty prop = entityType.findProperty(sp[0]);
        if (prop == null) {
            return orgMap;
        }
        if (prop instanceof EntryProp) {
            orgKey = orgKey.substring(sp[0].length() + 1, orgKey.length());
            for (int i = 0; i < this.entrySize; ++i) {
                DynamicObject org = (DynamicObject)this.model.getValue(orgKey, i);
                if (!this.isOrgType(org)) continue;
                orgMap.put(i, org);
            }
            return orgMap;
        }
        DynamicObject org = (DynamicObject)this.model.getValue(orgKey);
        if (this.isOrgType(org)) {
            for (int i = 0; i < this.entrySize; ++i) {
                orgMap.put(i, org);
            }
        }
        return orgMap;
    }

    private boolean isOrgType(DynamicObject org) {
        return org != null && "bos_org".equals(org.getDataEntityType().getName());
    }

    private boolean baseEquals(DynamicObject arg1, DynamicObject arg2) {
        return arg1.getPkValue().equals(arg2.getPkValue());
    }
}

