/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.matchruleout;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.sdk.scmc.im.extpoint.IInvMatchruleoutExpand;

public class DefaultMatchingRuleOutExpand
implements IInvMatchruleoutExpand {
    private static Set<String> AMOUNT_HANDLE_BILLS = new HashSet<String>(Arrays.asList("im_locationtransfer", "im_materialreqoutbill", "im_osmaterialreqoutbill", "im_otheroutbill", "im_transdirbill", "im_transoutbill", "im_mdc_mftproorder", "im_mdc_mftreturnorder", "im_mdc_mftfeedorder", "im_mdc_omoutbill", "im_mdc_omreturnbill", "im_mdc_omfeedbill", "im_mdc_omproorder", "im_mdc_omreturnorder", "im_mdc_omfeedorder"));
    private static List<String> SALOUTBILL_HANDLEFIELDS = Arrays.asList("amount", "curamount", "taxamount", "curtaxamount", "amountandtax", "curamountandtax", "discountamount", "materialcost");

    public List<String> getHandleNeedFields(String billtype, String entrykey) {
        if ("im_saloutbill".equals(billtype)) {
            return SALOUTBILL_HANDLEFIELDS;
        }
        if (AMOUNT_HANDLE_BILLS.contains(billtype)) {
            return Collections.singletonList("amount");
        }
        return Collections.emptyList();
    }

    public void handleAfter(IFormView view, String entrykey, List<Map<String, Object>> returnRows) {
        IDataModel model = view.getModel();
        DynamicObject bill = model.getDataEntity();
        String billtypeName = bill.getDataEntityType().getName();
        if (returnRows != null && !returnRows.isEmpty()) {
            String transtype;
            if ("im_transdirbill".equals(billtypeName) && "A".equals(transtype = bill.getString("transtype"))) {
                for (Map<String, Object> returnRow : returnRows) {
                    Integer returnRowIndex = (Integer)returnRow.get("returnRowIndex");
                    Integer returnRowNums = (Integer)returnRow.get("returnRowNums");
                    if (returnRowNums == 0) continue;
                    for (int i = 0; i < returnRowNums; ++i) {
                        int currentIndex = returnRowIndex + i;
                        model.beginInit();
                        model.setValue("inlotnumber", model.getValue("lotnumber", currentIndex), currentIndex);
                        model.setValue("inlot", model.getValue("lot", currentIndex), currentIndex);
                        model.endInit();
                    }
                }
            }
            if ("im_saloutbill".equals(billtypeName)) {
                for (String field : SALOUTBILL_HANDLEFIELDS) {
                    this.amountPlusAdjust(model, field, returnRows);
                }
            } else if (AMOUNT_HANDLE_BILLS.contains(billtypeName)) {
                this.amountPlusAdjust(model, "amount", returnRows);
            }
        }
    }

    private void amountPlusAdjust(IDataModel model, String field, List<Map<String, Object>> returnRows) {
        for (Map<String, Object> returnRow : returnRows) {
            Integer returnRowIndex = (Integer)returnRow.get("returnRowIndex");
            Integer returnRowNums = (Integer)returnRow.get("returnRowNums");
            if (returnRowNums == 0) continue;
            String qtyCol = (String)returnRow.get("qtyCol");
            Map expandNeedFieldValue = (Map)returnRow.get("expandNeedFieldValues");
            BigDecimal amountPlus = (BigDecimal)expandNeedFieldValue.get(field);
            BigDecimal allQty = BigDecimal.ZERO;
            if (amountPlus.compareTo(BigDecimal.ZERO) == 0) continue;
            for (int i = 0; i < returnRowNums; ++i) {
                int currentIndex = returnRowIndex + i;
                amountPlus = amountPlus.subtract((BigDecimal)model.getValue(field, currentIndex));
                allQty = allQty.add((BigDecimal)model.getValue(qtyCol, currentIndex));
            }
            BigDecimal qty = (BigDecimal)returnRow.get("qty");
            if (qty.compareTo(allQty) != 0 || amountPlus.compareTo(BigDecimal.ZERO) == 0) continue;
            int lastIndex = returnRowIndex + returnRowNums - 1;
            BigDecimal lastAmount = ((BigDecimal)model.getValue(field, lastIndex)).add(amountPlus);
            model.beginInit();
            model.setValue(field, (Object)lastAmount, lastIndex);
            model.endInit();
        }
    }
}

