/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.matchruleout;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.NoUpdateFieldsAnalysisHelper;
import kd.scmc.im.business.helper.SupplyChainParameterHelper;
import kd.scmc.im.business.helper.datactrl.InvBizDataCtrlHelper;
import kd.scmc.im.business.helper.datactrl.WarehouseIsolateResultHandle;
import kd.scmc.im.business.helper.matchruleout.DefaultMatchingRuleOutExpand;
import kd.scmc.im.business.helper.matchruleout.MatchingRuleOutNewHelper;
import kd.scmc.im.business.helper.matchruleout.MatchingRuleOutOrder;
import kd.scmc.im.business.helper.matchruleout.MatchingRuleOutPageCache;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.consts.InvqueryCfgConst;
import kd.scmc.sbs.business.reservation.ReserveHelper;
import kd.sdk.scmc.im.extpoint.IInvMatchruleoutExpand;

public abstract class MatchingRuleOutHandler {
    private static final String IMAPP_ID = "=9Q86DR2P+Q";
    public static final String FILTERENTRY = "filterentry";
    public static final String PREFILTERJSON_TAG = "prefilterjson_tag";
    public static final String INVFILTERJSON_TAG = "invfilterjson_tag";
    protected IFormPlugin formPlugin;
    protected IFormView view;
    protected IDataModel model;
    protected List<Integer> selectRows;
    protected DynamicObject billDynObj;
    protected DynamicObjectCollection entriesDynObj;
    protected String formid;
    protected String entry;
    protected String operatekey;
    protected Map<Long, BigDecimal> remainRecordQtyMapInner;
    private String proqtyfield;
    private String proqty2ndfield;
    private String noupdateinvfields;
    protected String entryTable;
    private String orgCol;
    private String materialCol;
    private String wareHouseCol;
    private String qtyCol;
    private String qtyCol2nd;
    private String currentQtyCol;
    private String dQtyCol;
    private String dUnitCol;
    private String unitCol;
    private String unitCol2nd;
    private String currentUnitCol;
    private String invaccQtyCol;
    private String invaccQtyCol2nd;
    private String currentInvaccQtyCol;
    private String lotnumCol;
    private String matchshortage;
    private Boolean saveshortagerow;
    private Boolean materialUseAuxUnit;
    private Boolean isAvbQty2nd;
    private Map<String, String> notNullFields = new HashMap<String, String>();
    private Map<String, String> filterFields = new HashMap<String, String>();
    private Map<String, String> matchFirstFields = new HashMap<String, String>();
    private Map<String, String> updateFields = new LinkedHashMap<String, String>();
    private Map<String, String> currentUpdateFields = new LinkedHashMap<String, String>();
    private Set<String> handleExpandNeedFields = new HashSet<String>();
    private Map<Long, String> nulltransCases = new HashMap<Long, String>();
    private Map<Long, String> customtransCases = new HashMap<Long, String>();
    private List<String> errList;
    private Map<Long, Map<String, Object>> materialInfo = new HashMap<Long, Map<String, Object>>();
    private static final List<String> RESERVE_QTYFIELDS = Arrays.asList("avbqty", "avbbaseqty", "avbqty2nd", "lockqty", "lockbaseqty", "lockqty2nd");
    private static final List<String> ALL_QTYFIELDS = Arrays.asList("avbqty", "avbbaseqty", "avbqty2nd", "qty", "baseqty", "qty2nd");
    private static final String LOTINTRK_PRE = "trk_";
    private static final String NULLTRANS_SUF = "_nulltrans";
    private static final String CUSTOMTRANS_SUF = "_customtrans";
    private static final String NULL_STR = "**********";
    private static final String DATE_MIN_VALUE = "TO_DATE('1970-01-01')";
    private static final String DATE_MAX_VALUE = "TO_DATE('2999-12-31')";
    private static final String[] RESERVE_SP_FIELDS = new String[]{"case when spbaseqty is null then 0 else spbaseqty end as spbaseqty", "case when spqty is null then 0 else spqty end as spqty", "case when spqty2nd is null then 0 else spqty2nd end as spqty2nd"};
    private static final String FILED_INVID = "invid";

    protected MatchingRuleOutHandler(String formid, String entry, String operatekey) {
        this.formid = formid;
        this.entry = entry;
        this.operatekey = operatekey;
    }

    public List<Map<String, Object>> getMatchingResult() {
        DynamicObject cfg = MatchingRuleOutHandler.getInvQueryCfg(this.formid, this.entry, this.operatekey);
        this.extractMapparamFromCfg(cfg);
        String errMsg = this.checkNotNullFields();
        if (errMsg != null && this.view != null) {
            this.view.showTipNotification(errMsg);
            return Collections.emptyList();
        }
        Map<Long, MatchingRuleOutOrder> orderRules = this.getOrderRules();
        if (orderRules.isEmpty() && this.view != null) {
            return Collections.emptyList();
        }
        if (StringUtils.isNotEmpty((String)this.noupdateinvfields) && this.model != null) {
            NoUpdateFieldsAnalysisHelper.setNoUpdateFields(this.model, this.entry, MatchingRuleOutHandler.getPure(this.materialCol), MatchingRuleOutHandler.getPure(this.noupdateinvfields));
        }
        this.getHandleExpandNeedFields();
        MatchingRuleOutPageCache.copyMatchInfoPageCache(this.view);
        List<QFilter> invFilters = this.getInvFilters(cfg);
        this.getMaterialInfo(this.selectRows);
        ArrayList<Map<String, Object>> entryInfoList = new ArrayList<Map<String, Object>>(this.selectRows.size());
        for (int i = 0; i < this.selectRows.size(); ++i) {
            MatchingRuleOutOrder orderRule;
            int index = this.selectRows.get(i);
            MatchingRuleOutPageCache.deleteMatchInfoPageCache(index, this.view, this.entry);
            String entryErrMsg = this.errList.get(i);
            if (entryErrMsg != null) {
                entryInfoList.add(Collections.singletonMap("errMsg", entryErrMsg));
                continue;
            }
            Long entryId = this.getEntryId(index);
            DynamicObject org = (DynamicObject)this.getEntryValue(this.orgCol, index);
            Long orgid = (Long)org.getPkValue();
            DynamicObject material = (DynamicObject)this.getEntryValue(this.materialCol, index);
            Long masterid = (Long)((DynamicObject)material.get("masterid")).getPkValue();
            Long materialmasterid = (Long)material.getDynamicObject("masterid").getPkValue();
            BigDecimal inQty = (BigDecimal)this.getEntryValue(this.qtyCol, index);
            boolean isZero = BigDecimal.ZERO.compareTo(inQty) == 0;
            this.materialUseAuxUnit = (Boolean)this.materialInfo.get(masterid).get("hasAuxptyUnit");
            this.updateFields = new LinkedHashMap<String, String>(this.currentUpdateFields);
            Map<String, Object> info = this.materialInfo.get(masterid);
            String unitConvertDir = (String)info.get("unitconvertdir");
            info.put("isZero", isZero);
            if (this.isAvbQty2nd.booleanValue() && (!this.materialUseAuxUnit.booleanValue() || isZero)) {
                this.currentQtyCol = this.qtyCol2nd;
                this.currentUnitCol = this.unitCol2nd;
                this.currentInvaccQtyCol = this.invaccQtyCol2nd;
                this.updateFields.remove("avbqty2nd");
                this.updateFields.remove("qty2nd");
            } else {
                this.currentQtyCol = this.qtyCol;
                this.currentUnitCol = this.unitCol;
                this.currentInvaccQtyCol = this.invaccQtyCol;
                if (this.materialUseAuxUnit.booleanValue()) {
                    this.removeUpdateFields(unitConvertDir);
                }
            }
            BigDecimal qty = (BigDecimal)this.getEntryValue(this.currentQtyCol, index);
            BigDecimal dQty = BigDecimal.ZERO;
            if (!StringUtils.isEmpty((String)this.dQtyCol) && this.materialUseAuxUnit.booleanValue() && this.getEntryValue(this.dQtyCol, index) != null) {
                dQty = (BigDecimal)this.getEntryValue(this.dQtyCol, index);
            }
            DynamicObject unit = (DynamicObject)this.getEntryValue(this.currentUnitCol, index);
            DynamicObject dUnit = null;
            if (this.materialUseAuxUnit.booleanValue() && !StringUtils.isEmpty((String)this.dUnitCol) && this.getEntryValue(this.dUnitCol, index) != null) {
                dUnit = (DynamicObject)this.getEntryValue(this.dUnitCol, index);
            }
            boolean enableLot = material.getBoolean("enablelot");
            boolean enableShelflifemgr = material.getBoolean("enableshelflifemgr");
            Long ruleId = 0L;
            DynamicObject outboundrule = material.getDynamicObject("outboundrule");
            if (outboundrule != null) {
                ruleId = outboundrule.getLong("id");
            }
            if ((orderRule = orderRules.get(ruleId)) == null) {
                entryInfoList.add(Collections.emptyMap());
                continue;
            }
            boolean includeLotinTrack = orderRule.isIncludeLotinTrack();
            boolean needCheckLotinTrack = includeLotinTrack && (enableLot || enableShelflifemgr);
            List<String> entryNoUpdateFieldValueList = Collections.emptyList();
            if (StringUtils.isNotEmpty((String)this.noupdateinvfields)) {
                String entryNoUpdateFieldValue = (String)this.getEntryValue(this.noupdateinvfields, index);
                entryNoUpdateFieldValueList = NoUpdateFieldsAnalysisHelper.getNoUpdateFieldsList(entryNoUpdateFieldValue);
            }
            List<QFilter> balanceFilters = this.buildBalanceFilters(this.filterFields, index, materialmasterid, entryNoUpdateFieldValueList);
            balanceFilters.addAll(invFilters);
            List<QFilter> extendFilters = this.getExtendFilters(index);
            balanceFilters.addAll(extendFilters);
            List<QFilter> matchFirstFilters = this.buildBalanceFilters(this.matchFirstFields, index, materialmasterid, Collections.emptyList());
            List<QFilter> lotintrkFilters = this.buildLotintrkFilters(needCheckLotinTrack, orgid, materialmasterid);
            this.addWarehouseIsolateFilter(balanceFilters, orgid);
            try (DataSet invAccDataSet = this.getInvAccAndLotTrkDataSet(needCheckLotinTrack, orderRule, balanceFilters, lotintrkFilters, matchFirstFilters);){
                Map<String, Object> entryMap = this.getEntryAllInfoListMap(invAccDataSet, index, entryId, qty, dQty, orgid, material, unit, dUnit, orderRule, entryNoUpdateFieldValueList, needCheckLotinTrack);
                entryInfoList.add(entryMap);
                continue;
            }
        }
        if (this.lotnumCol != null) {
            this.addLotMainFileReturn(entryInfoList);
        }
        return entryInfoList;
    }

    private void removeUpdateFields(String unitConvertDir) {
        if (("A".equals(unitConvertDir) || "D".equals(unitConvertDir)) && this.isAvbQty2nd.booleanValue()) {
            this.updateFields.remove("avbqty");
            this.updateFields.remove("avbbaseqty");
            this.updateFields.remove("qty");
        } else if (("B".equals(unitConvertDir) || "D".equals(unitConvertDir)) && !this.isAvbQty2nd.booleanValue()) {
            this.updateFields.remove("avbqty2nd");
            this.updateFields.remove("qty2nd");
        }
    }

    private void getMaterialInfo(List<Integer> selectRows) {
        for (int i = 0; i < selectRows.size(); ++i) {
            int index = selectRows.get(i);
            DynamicObject materialInv = (DynamicObject)this.getEntryValue(this.materialCol, index);
            DynamicObject material = (DynamicObject)materialInv.get("masterid");
            Long materialId = (Long)material.getPkValue();
            if (this.materialInfo.containsKey(materialId)) continue;
            HashMap<String, Object> info = new HashMap<String, Object>();
            DynamicObject auxptyUnit = (DynamicObject)material.get("auxptyunit");
            if (auxptyUnit != null) {
                info.put("hasAuxptyUnit", true);
            } else {
                info.put("hasAuxptyUnit", false);
            }
            info.put("unitconvertdir", material.get("unitconvertdir"));
            this.materialInfo.put(materialId, info);
        }
    }

    private List<QFilter> getInvFilters(DynamicObject cfg) {
        MainEntityType dataEntityType = (MainEntityType)this.billDynObj.getDataEntityType();
        MainEntityType balEntityType = MetadataServiceHelper.getDataEntityType((String)InvAccConst.getBalTb());
        DynamicObjectCollection filterEntries = cfg.getDynamicObjectCollection(FILTERENTRY);
        ArrayList<QFilter> invFilters = new ArrayList<QFilter>();
        for (DynamicObject filterEntry : filterEntries) {
            String invFilterJson;
            FilterCondition filterCondition;
            FilterBuilder filterBuilder;
            String filterScript;
            String preFilterJson = filterEntry.getString(PREFILTERJSON_TAG);
            boolean matchPreFilter = true;
            if (StringUtils.isNotEmpty((String)preFilterJson) && !StringUtils.isEmpty((String)(filterScript = (filterBuilder = new FilterBuilder(dataEntityType, filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)preFilterJson, FilterCondition.class))).buildFilterScript()[0]))) {
                String[] variables = FormulaEngine.extractVariables((String)filterScript);
                HashMap<String, Object> params = new HashMap<String, Object>(variables.length);
                for (String variable : variables) {
                    params.put(variable, this.billDynObj.get(variable));
                }
                matchPreFilter = (Boolean)FormulaEngine.execExcelFormula((String)filterScript, params);
            }
            if (!matchPreFilter || !StringUtils.isNotEmpty((String)(invFilterJson = filterEntry.getString(INVFILTERJSON_TAG)))) continue;
            FilterCondition invFilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)invFilterJson, FilterCondition.class);
            FilterBuilder builder = new FilterBuilder(balEntityType, invFilterCondition);
            builder.buildFilter();
            invFilters.add(builder.getQFilter());
        }
        return invFilters;
    }

    public static Map<Object, DynamicObject> getInvQueryCfgs(String billtype, String entry, String operatekey) {
        Map cfgs = BusinessDataServiceHelper.loadFromCache((String)"im_invqueryconf", (QFilter[])new QFilter("srcbillobj", "=", (Object)billtype).and("srcbillentry", "=", (Object)entry).and("operatekey", "=", (Object)operatekey).and("enable", "=", (Object)"1").toArray());
        return cfgs;
    }

    public static DynamicObject getInvQueryCfg(String billtype, String entry, String operatekey) {
        Map<Object, DynamicObject> cfgs = MatchingRuleOutHandler.getInvQueryCfgs(billtype, entry, operatekey);
        if (cfgs == null || cfgs.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7528\u4e8e\u5339\u914d\u89c4\u5219\u51fa\u5e93\u7684\u5e93\u5b58\u67e5\u8be2\u914d\u7f6e\u3002", (String)"MatchingRuleOutHandler_0", (String)"scmc-im-business", (Object[])new Object[0]), billtype, operatekey));
        }
        if (cfgs.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u4e86\u591a\u4e2a\u542f\u7528\u7684\u7528\u4e8e\u5339\u914d\u89c4\u5219\u51fa\u5e93\u7684\u5e93\u5b58\u67e5\u8be2\u914d\u7f6e\uff0c\u8bf7\u7981\u7528\u6216\u5220\u9664\u591a\u4f59\u7684\u89c4\u5219\u3002", (String)"MatchingRuleOutHandler_1", (String)"scmc-im-business", (Object[])new Object[0]), billtype, operatekey));
        }
        return cfgs.values().toArray(new DynamicObject[0])[0];
    }

    private void extractMapparamFromCfg(DynamicObject cfg) {
        this.noupdateinvfields = cfg.getString("entrynoupdatefieldkey");
        if (StringUtils.isNotEmpty((String)this.noupdateinvfields)) {
            this.noupdateinvfields = this.entry + '.' + this.noupdateinvfields;
        }
        this.matchshortage = cfg.getString("matchshortage");
        this.saveshortagerow = cfg.getBoolean("saveshortagerow");
        this.proqtyfield = cfg.getString("proqtyfield");
        String unitField = "unit";
        String dUnitField = "unit2nd";
        this.isAvbQty2nd = false;
        this.proqty2ndfield = cfg.getString("proqty2ndfield");
        if ("avbqty2nd".equals(this.proqtyfield) || "qty2nd".equals(this.proqtyfield)) {
            unitField = "unit2nd";
            dUnitField = "unit";
            this.isAvbQty2nd = true;
        }
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("entryentity");
        ArrayList updateFieldList = new ArrayList(entries.size());
        for (DynamicObject dynamicObject : entries) {
            HashMap<String, Object> updateFieldMap;
            boolean isFilterField = dynamicObject.getBoolean("qfilter");
            boolean isUpdateField = dynamicObject.getBoolean("update");
            boolean isNotNullField = dynamicObject.getBoolean("fieldmustinput");
            boolean isMatchFirstField = dynamicObject.getBoolean("fristout");
            String invacccol = dynamicObject.getString("invacccol");
            String srcbillcol = dynamicObject.getString("srcbillcol");
            String srcbillcolno = dynamicObject.getString("srcbillcolno");
            if ("org".equals(invacccol)) {
                this.orgCol = srcbillcol;
            }
            if ("material".equals(invacccol)) {
                this.materialCol = srcbillcol;
            }
            if ("warehouse".equals(invacccol)) {
                this.wareHouseCol = srcbillcol;
            }
            if (this.proqtyfield.equals(invacccol)) {
                this.invaccQtyCol = invacccol;
                this.qtyCol = srcbillcol;
            }
            if (!StringUtils.isEmpty((String)this.proqty2ndfield) && this.proqty2ndfield.equals(invacccol)) {
                this.invaccQtyCol2nd = invacccol;
                this.qtyCol2nd = srcbillcol;
            }
            if (unitField.equals(invacccol)) {
                this.unitCol = srcbillcol;
            }
            if (!StringUtils.isEmpty((String)this.proqty2ndfield) && "unit".equals(invacccol)) {
                this.unitCol2nd = srcbillcol;
            }
            if (dUnitField.equals(invacccol)) {
                this.dUnitCol = srcbillcol;
            }
            if (this.isAvbQty2nd.booleanValue() && ("avbqty".equals(invacccol) || "qty".equals(invacccol))) {
                this.dQtyCol = srcbillcol;
            }
            if (!this.isAvbQty2nd.booleanValue() && ("avbqty2nd".equals(invacccol) || "qty2nd".equals(invacccol))) {
                this.dQtyCol = srcbillcol;
            }
            if (isNotNullField) {
                this.notNullFields.put(srcbillcol, srcbillcolno);
            }
            if (isMatchFirstField) {
                this.matchFirstFields.put(invacccol, srcbillcol);
            }
            if (isFilterField) {
                this.filterFields.put(invacccol, srcbillcol);
            }
            if (srcbillcol.lastIndexOf(46) == -1 || !isUpdateField) continue;
            if (InvqueryCfgConst.OUTRULEQTYFIELDS.contains(invacccol) || !InvqueryCfgConst.ALLQTYFIELDS.contains(invacccol)) {
                updateFieldMap = new HashMap<String, Object>(3);
                updateFieldMap.put("invacccol", invacccol);
                updateFieldMap.put("srcbillcol", srcbillcol);
                updateFieldMap.put("returnorder", dynamicObject.getInt("returnorder"));
                updateFieldList.add(updateFieldMap);
                if ("lotnum".equals(invacccol)) {
                    this.lotnumCol = srcbillcol;
                }
            }
            if (!"avbqty2nd".equals(invacccol) && !"qty2nd".equals(invacccol)) continue;
            updateFieldMap = new HashMap(3);
            updateFieldMap.put("invacccol", invacccol);
            updateFieldMap.put("srcbillcol", srcbillcol);
            updateFieldMap.put("returnorder", dynamicObject.getInt("returnorder"));
            updateFieldList.add(updateFieldMap);
        }
        updateFieldList.sort((field1, field2) -> {
            int order1 = (Integer)field1.get("returnorder");
            int order2 = (Integer)field2.get("returnorder");
            return order2 - order1;
        });
        for (Map map : updateFieldList) {
            String invacccol = (String)map.get("invacccol");
            String srcbillcol = (String)map.get("srcbillcol");
            this.updateFields.put(invacccol, srcbillcol);
        }
        this.currentUpdateFields = new LinkedHashMap<String, String>(this.updateFields);
    }

    private String checkNotNullFields() {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)this.formid);
        this.errList = new ArrayList<String>(this.selectRows.size());
        for (int i = 0; i < this.selectRows.size(); ++i) {
            int index = this.selectRows.get(i);
            boolean existNull = false;
            HashSet<String> nullHeadFieldNames = new HashSet<String>(this.notNullFields.size());
            HashSet<String> nullEntryFieldNames = new HashSet<String>(this.notNullFields.size());
            for (Map.Entry<String, String> notNullField : this.notNullFields.entrySet()) {
                String col = notNullField.getKey();
                Object value = this.getEntryValue(col, index);
                if (!MatchingRuleOutHandler.isNullValue(value)) continue;
                String eCol = MatchingRuleOutHandler.getPure(col);
                IDataEntityProperty colProp = entityType.findProperty(eCol);
                String colname = MatchingRuleOutHandler.getPure(notNullField.getValue());
                if (colProp != null) {
                    colname = colProp.getDisplayName().getLocaleValue();
                }
                if (col.lastIndexOf(46) == -1) {
                    nullHeadFieldNames.add(colname);
                    continue;
                }
                nullEntryFieldNames.add(colname);
            }
            StringBuilder msgBuilder = new StringBuilder();
            if (!nullHeadFieldNames.isEmpty()) {
                existNull = true;
                msgBuilder.append(String.join((CharSequence)"\u3001", nullHeadFieldNames));
                msgBuilder.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MatchingRuleOutHandler_2", (String)"scmc-im-business", (Object[])new Object[0]));
            }
            if (!nullEntryFieldNames.isEmpty()) {
                existNull = true;
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"MatchingRuleOutHandler_3", (String)"scmc-im-business", (Object[])new Object[0]), index + 1));
                msgBuilder.append(String.join((CharSequence)"\u3001", nullEntryFieldNames));
                msgBuilder.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MatchingRuleOutHandler_2", (String)"scmc-im-business", (Object[])new Object[0]));
            }
            if (existNull) {
                this.errList.add(msgBuilder.toString());
                if (this.view == null) continue;
                return msgBuilder.toString();
            }
            this.errList.add(null);
        }
        return null;
    }

    private Map<Long, MatchingRuleOutOrder> getOrderRules() {
        HashSet<Long> ruleIds = new HashSet<Long>(this.selectRows.size());
        for (int index : this.selectRows) {
            long ruleId;
            DynamicObject outboundrule;
            DynamicObject material = (DynamicObject)this.getEntryValue(this.materialCol, index);
            if (material == null || (outboundrule = material.getDynamicObject("outboundrule")) == null || (ruleId = outboundrule.getLong("id")) == 0L) continue;
            ruleIds.add(ruleId);
        }
        HashMap<Long, MatchingRuleOutOrder> orderRules = new HashMap<Long, MatchingRuleOutOrder>(ruleIds.size());
        if (!ruleIds.isEmpty()) {
            Map matchoutRuleMap = BusinessDataServiceHelper.loadFromCache((Object[])ruleIds.toArray(), (String)"bd_matchout_rule");
            for (Map.Entry matchoutRuleEntry : matchoutRuleMap.entrySet()) {
                Long ruleId = (Long)matchoutRuleEntry.getKey();
                DynamicObject matchoutRule = (DynamicObject)matchoutRuleEntry.getValue();
                MatchingRuleOutOrder ruleOrder = new MatchingRuleOutOrder(ruleId);
                ruleOrder.setRuleName(matchoutRule.getString("name"));
                DynamicObjectCollection orders = matchoutRule.getDynamicObjectCollection("entryentity");
                ArrayList<DynamicObject> orderAttrs = new ArrayList<DynamicObject>(orders.size());
                for (DynamicObject order : orders) {
                    Class<?> propType;
                    String customorder;
                    Class<?> propType2;
                    Integer seq = order.getInt("seq");
                    String source = order.getString("source");
                    String srccol = order.getString("srccol");
                    String type = order.getString("type");
                    Long orderId = order.getLong("id");
                    if ("im_lotintrack".equals(source)) {
                        ruleOrder.setIncludeLotinTrack(true);
                    }
                    orderAttrs.add(order);
                    String valueouttype = order.getString("valueouttype");
                    if (("B".equals(valueouttype) || "C".equals(valueouttype)) && Date.class == (propType2 = this.getFieldPropType(source, srccol))) {
                        String limitValue = this.getKsqlLimitValue(propType2, type, valueouttype, srccol);
                        StringBuilder nullTranColBuilder = new StringBuilder("case when ");
                        nullTranColBuilder.append(srccol).append(" is null then ").append(limitValue).append(" else ").append(srccol).append(" end ");
                        if ("im_lotintrack".equals(source)) {
                            nullTranColBuilder.append(LOTINTRK_PRE);
                        }
                        nullTranColBuilder.append(srccol).append(NULLTRANS_SUF);
                        String nullTranCol = nullTranColBuilder.toString();
                        this.nulltransCases.put(orderId, nullTranCol);
                    }
                    if ("custom".equals(type) && !StringUtils.isBlank((String)(customorder = order.getString("customorder"))) && String.class == (propType = this.getFieldPropType(source, srccol))) {
                        String[] customorderArray = customorder.split(",");
                        StringBuilder customColBuilder = new StringBuilder("case ").append(srccol);
                        int i = 0;
                        for (String customorderItem : customorderArray) {
                            customColBuilder.append(" when '").append(customorderItem).append("' then ").append(i);
                            ++i;
                        }
                        customColBuilder.append(" else ").append(i).append(" end ");
                        if ("im_lotintrack".equals(source)) {
                            customColBuilder.append(LOTINTRK_PRE);
                        }
                        customColBuilder.append(srccol).append(CUSTOMTRANS_SUF);
                        String customTranCol = customColBuilder.toString();
                        this.customtransCases.put(orderId, customTranCol);
                    }
                    Boolean overallMatch = order.getBoolean("overallmatch");
                    if (seq != 1 || !overallMatch.booleanValue()) continue;
                    StringBuilder overallMatchColBuilder = new StringBuilder();
                    if ("im_lotintrack".equals(source)) {
                        overallMatchColBuilder.append(LOTINTRK_PRE);
                    }
                    overallMatchColBuilder.append(srccol);
                    ruleOrder.setOverallMatchCol(overallMatchColBuilder.toString());
                }
                orderAttrs.sort((attr1, attr2) -> {
                    Integer seq1 = attr1.getInt("seq");
                    Integer seq2 = attr2.getInt("seq");
                    return seq1 - seq2;
                });
                ruleOrder.setOrderAttrs(orderAttrs);
                orderRules.put(ruleId, ruleOrder);
            }
        }
        return orderRules;
    }

    private void getHandleExpandNeedFields() {
        PluginProxy pluginProxy = PluginProxy.create((Object)new DefaultMatchingRuleOutExpand(), IInvMatchruleoutExpand.class, (String)"SCMC_IM_INV_MATCHRULEOUT");
        pluginProxy.callAfter(p -> {
            List fields = p.getHandleNeedFields(this.formid, this.entry);
            if (fields != null) {
                this.handleExpandNeedFields.addAll(fields);
            }
            return fields;
        });
    }

    private Class<?> getFieldPropType(String source, String srccol) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)source);
        String[] keys = srccol.split("\\.");
        IDataEntityProperty pro = mainType.findProperty(keys[0]);
        if (keys.length > 1) {
            for (int i = 1; i < keys.length; ++i) {
                String propSubContent;
                if (pro instanceof BasedataProp) {
                    propSubContent = keys[i];
                    if ("id".equals(propSubContent)) {
                        return Long.class;
                    }
                    if (pro instanceof FlexProp) {
                        return String.class;
                    }
                } else {
                    return pro.getPropertyType();
                }
                MainEntityType type = MetadataServiceHelper.getDataEntityType((String)((BasedataProp)pro).getBaseEntityId());
                pro = type.findProperty(propSubContent);
            }
            return pro.getPropertyType();
        }
        return pro.getPropertyType();
    }

    private String getKsqlLimitValue(Class<?> propType, String type, String valueouttype, String defaultCol) {
        if (Date.class == propType) {
            if ("asc".equals(type)) {
                if ("B".equals(valueouttype)) {
                    return DATE_MIN_VALUE;
                }
                if ("C".equals(valueouttype)) {
                    return DATE_MAX_VALUE;
                }
            } else if ("desc".equals(type)) {
                if ("B".equals(valueouttype)) {
                    return DATE_MAX_VALUE;
                }
                if ("C".equals(valueouttype)) {
                    return DATE_MIN_VALUE;
                }
            }
        }
        return defaultCol;
    }

    private List<QFilter> buildBalanceFilters(Map<String, String> filterFields, int index, Long materialmasterid, List<String> entryNoUpdateFieldValueList) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(filterFields.size());
        for (Map.Entry<String, String> filterField : filterFields.entrySet()) {
            String srcbillcol = filterField.getValue();
            Object value = this.getEntryValue(srcbillcol, index);
            if (MatchingRuleOutHandler.isNullValue(value) || entryNoUpdateFieldValueList.contains(MatchingRuleOutHandler.getPure(srcbillcol))) continue;
            if (this.materialCol.equals(srcbillcol)) {
                value = materialmasterid;
            } else if (value instanceof DynamicObject) {
                value = ((DynamicObject)value).getPkValue();
            }
            String invacccol = filterField.getKey();
            QFilter filter = new QFilter(invacccol, "=", value);
            filters.add(filter);
        }
        return filters;
    }

    private List<QFilter> getExtendFilters(int index) {
        ArrayList<QFilter> extendFilters = new ArrayList<QFilter>();
        PluginProxy pluginProxy = PluginProxy.create((Object)new DefaultMatchingRuleOutExpand(), IInvMatchruleoutExpand.class, (String)"SCMC_IM_INV_MATCHRULEOUT");
        List filterList = pluginProxy.callAfter(plugin -> plugin.getFilter(field -> this.getEntryValue((String)field, index), this.formid, this.entry));
        if (filterList != null && !filterList.isEmpty()) {
            for (List qFilters : filterList) {
                if (qFilters == null || qFilters.isEmpty()) continue;
                extendFilters.addAll(qFilters);
            }
        }
        return extendFilters;
    }

    private List<QFilter> buildLotintrkFilters(boolean needCheckLotinTrack, Long orgid, Long materialMasterid) {
        if (needCheckLotinTrack) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            filters.add(new QFilter("org", "=", (Object)orgid));
            filters.add(new QFilter("materialmaster", "=", (Object)materialMasterid));
            return filters;
        }
        return Collections.emptyList();
    }

    private void addWarehouseIsolateFilter(List<QFilter> balanceFilters, Long orgid) {
        Set<Long> warehouseIds;
        boolean hasWarehouseFilter = false;
        for (QFilter filter : balanceFilters) {
            String property = filter.getProperty();
            if (!property.equals("warehouse")) continue;
            hasWarehouseFilter = true;
            break;
        }
        if (!(hasWarehouseFilter || StringUtils.isBlank((String)this.wareHouseCol) || (warehouseIds = InvBizDataCtrlHelper.buildLimitHelper(new WarehouseIsolateResultHandle()).getDataByUser(Collections.singletonList(orgid), this.formid, this.wareHouseCol)) == null || warehouseIds.isEmpty())) {
            balanceFilters.add(new QFilter("warehouse", "in", warehouseIds));
        }
    }

    private void getAllSelectors(boolean needCheckLotinTrack, MatchingRuleOutOrder orderRule, Set<String> balanceSelectorSet, Set<String> balanceTranSelectorSet, Set<String> balanceNullTranSelectorSet, Set<String> lotintrkSelectorSet) {
        List<DynamicObject> orderAttrs;
        balanceSelectorSet.add("id");
        for (Map.Entry<String, String> matchFirstField : this.matchFirstFields.entrySet()) {
            this.addBalanceSelectorSet(balanceSelectorSet, balanceTranSelectorSet, matchFirstField.getKey());
        }
        for (Map.Entry<String, String> updateField : this.updateFields.entrySet()) {
            this.addBalanceSelectorSet(balanceSelectorSet, balanceTranSelectorSet, updateField.getKey());
        }
        if (needCheckLotinTrack) {
            balanceSelectorSet.add("lotnum");
            balanceSelectorSet.add("producedate");
            balanceSelectorSet.add("expirydate");
            this.addLotintrkSelectorSet(lotintrkSelectorSet, "lotnumber");
            this.addLotintrkSelectorSet(lotintrkSelectorSet, "producedate");
            this.addLotintrkSelectorSet(lotintrkSelectorSet, "expirydate");
        }
        if (!(orderAttrs = orderRule.getOrderAttrs()).isEmpty()) {
            for (DynamicObject orderAttr : orderAttrs) {
                String customTranCol;
                String nullTranCol;
                String source = orderAttr.getString("source");
                String srccol = orderAttr.getString("srccol");
                String type = orderAttr.getString("type");
                Long orderId = orderAttr.getLong("id");
                if ("im_inv_realbalance".equals(source)) {
                    this.addBalanceSelectorSet(balanceSelectorSet, balanceTranSelectorSet, srccol);
                } else if ("im_lotintrack".equals(source) && needCheckLotinTrack) {
                    this.addLotintrkSelectorSet(lotintrkSelectorSet, srccol);
                }
                String valueouttype = orderAttr.getString("valueouttype");
                if (("B".equals(valueouttype) || "C".equals(valueouttype)) && (nullTranCol = this.nulltransCases.get(orderId)) != null) {
                    if ("im_inv_realbalance".equals(source)) {
                        balanceNullTranSelectorSet.add(nullTranCol);
                        balanceTranSelectorSet.add(srccol.concat(NULLTRANS_SUF));
                    } else if ("im_lotintrack".equals(source) && needCheckLotinTrack) {
                        lotintrkSelectorSet.add(nullTranCol);
                    }
                }
                if (!"custom".equals(type) || (customTranCol = this.customtransCases.get(orderId)) == null) continue;
                if ("im_inv_realbalance".equals(source)) {
                    balanceTranSelectorSet.add(customTranCol);
                    continue;
                }
                if (!"im_lotintrack".equals(source) || !needCheckLotinTrack) continue;
                lotintrkSelectorSet.add(customTranCol);
            }
        }
    }

    private void addBalanceSelectorSet(Set<String> normalSet, Set<String> tranSet, String key) {
        if (RESERVE_QTYFIELDS.contains(key)) {
            switch (key) {
                case "avbbaseqty": {
                    tranSet.add(key);
                    break;
                }
                case "avbqty": {
                    tranSet.add("avbbqty as avbqty");
                    break;
                }
                case "avbqty2nd": {
                    tranSet.add("avbbtndqty as avbqty2nd");
                    break;
                }
                case "lockqty": {
                    tranSet.add("reserveqty as lockqty");
                    break;
                }
                case "lockbaseqty": {
                    tranSet.add("reservebaseqty as lockbaseqty");
                    break;
                }
                case "lockqty2nd": {
                    tranSet.add("reserveunit2ndqty as lockqty2nd");
                }
            }
        } else {
            normalSet.add(key);
        }
    }

    private void addLotintrkSelectorSet(Set<String> selectorSet, String key) {
        selectorSet.add(key + " as " + LOTINTRK_PRE + key);
    }

    private DataSet getInvAccAndLotTrkDataSet(boolean needCheckLotinTrack, MatchingRuleOutOrder orderRule, List<QFilter> balanceFilters, List<QFilter> lotintrkFilters, List<QFilter> matchFirstFilters) {
        HashSet<String> balanceSelectorSet = new HashSet<String>();
        HashSet<String> balanceTranSelectorSet = new HashSet<String>();
        HashSet<String> balanceNullTranSelectorSet = new HashSet<String>();
        HashSet<String> lotintrkSelectorSet = new HashSet<String>();
        this.getAllSelectors(needCheckLotinTrack, orderRule, balanceSelectorSet, balanceTranSelectorSet, balanceNullTranSelectorSet, lotintrkSelectorSet);
        DataSet invAccDataSet = this.getInvAccDataSet(balanceSelectorSet, balanceTranSelectorSet, balanceNullTranSelectorSet, balanceFilters);
        boolean hasMatchFirst = false;
        if (!matchFirstFilters.isEmpty()) {
            hasMatchFirst = true;
            matchFirstFilters.addAll(balanceFilters);
            DataSet matchFirstDataSet = QueryServiceHelper.queryDataSet((String)MatchingRuleOutNewHelper.class.getName(), (String)InvAccConst.getBalTb(), (String)"id as matchfirstId", (QFilter[])matchFirstFilters.toArray(new QFilter[matchFirstFilters.size()]), (String)"");
            invAccDataSet = invAccDataSet.leftJoin(matchFirstDataSet).on("id", "matchfirstId").select(invAccDataSet.getRowMeta().getFieldNames(), new String[]{"case when matchFirstId is null then 0 else 1 end matchfirst"}).finish();
        }
        if (needCheckLotinTrack) {
            Set<Long> ids = this.getLotTrakIds(lotintrkFilters);
            QFilter idFilter = new QFilter("id", "in", ids);
            DataSet lotintrkDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_lotintrack", (String)String.join((CharSequence)",", lotintrkSelectorSet), (QFilter[])idFilter.toArray(), (String)"").distinct();
            invAccDataSet = invAccDataSet.join(lotintrkDataSet, JoinType.INNER).on("lotnum", "trk_lotnumber").on("producedate", "trk_producedate").on("expirydate", "trk_expirydate").select(invAccDataSet.getRowMeta().getFieldNames(), lotintrkDataSet.getRowMeta().getFieldNames()).finish();
        }
        List<String> orderbys = this.getOrderBy(orderRule, hasMatchFirst, needCheckLotinTrack);
        return invAccDataSet.orderBy(orderbys.toArray(new String[orderbys.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Long> getLotTrakIds(List<QFilter> lotintrkFilters) {
        HashSet<Long> ids = new HashSet<Long>(16);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_lotintrack", (String)"id,biztime,lotnumber,producedate,expirydate", (QFilter[])lotintrkFilters.toArray(new QFilter[lotintrkFilters.size()]), (String)"");
        dataSet = dataSet.groupBy(new String[]{"lotnumber", "producedate", "expirydate"}).maxP("biztime", "id").finish();
        try {
            for (Row row : dataSet) {
                ids.add(row.getLong("id"));
            }
        }
        finally {
            dataSet.close();
        }
        return ids;
    }

    private DataSet getInvAccDataSet(Set<String> balanceSelectorSet, Set<String> balanceTranSelectorSet, Set<String> balanceNullTranSelectorSet, List<QFilter> balanceFilters) {
        MainEntityType invaccEntityType = EntityMetadataCache.getDataEntityType((String)InvAccConst.getBalTb());
        HashSet<Object> allBalanceSelectorSet = new HashSet<Object>();
        allBalanceSelectorSet.addAll(invaccEntityType.getAllFields().keySet());
        allBalanceSelectorSet.addAll(balanceSelectorSet);
        allBalanceSelectorSet.addAll(balanceNullTranSelectorSet);
        DataSet balanceDataSet = QueryServiceHelper.queryDataSet((String)MatchingRuleOutNewHelper.class.getName(), (String)InvAccConst.getBalTb(), (String)String.join((CharSequence)",", allBalanceSelectorSet), (QFilter[])balanceFilters.toArray(new QFilter[balanceFilters.size()]), (String)"");
        balanceDataSet = this.mergeReserveQty(balanceDataSet);
        HashSet<String> allResultSelectorSet = new HashSet<String>(balanceSelectorSet.size() + balanceTranSelectorSet.size());
        allResultSelectorSet.addAll(balanceSelectorSet);
        allResultSelectorSet.addAll(balanceTranSelectorSet);
        String qtyNotZerofilter = this.currentInvaccQtyCol + " > 0";
        DataSet avbbaseqtyDataSet = ReserveHelper.getAvbbaseqty((DataSet)balanceDataSet).select(allResultSelectorSet.toArray(new String[allResultSelectorSet.size()])).filter(qtyNotZerofilter);
        return avbbaseqtyDataSet;
    }

    private List<String> getOrderBy(MatchingRuleOutOrder orderRule, boolean hasMatchFirst, boolean needCheckLotinTrack) {
        List<DynamicObject> orderAttrs = orderRule.getOrderAttrs();
        ArrayList<String> orderbys = new ArrayList<String>(orderAttrs.size() + 2);
        if (hasMatchFirst) {
            orderbys.add("matchfirst desc");
        }
        for (DynamicObject orderAttr : orderAttrs) {
            String nullTranCol;
            Long orderId = orderAttr.getLong("id");
            String source = orderAttr.getString("source");
            String srccol = orderAttr.getString("srccol");
            String type = orderAttr.getString("type");
            String valueouttype = orderAttr.getString("valueouttype");
            if ("im_lotintrack".equals(source) && !needCheckLotinTrack) continue;
            if ("im_lotintrack".equals(source)) {
                srccol = LOTINTRK_PRE.concat(srccol);
            }
            if ("custom".equals(type)) {
                String customTranCol = this.customtransCases.get(orderId);
                if (customTranCol == null) continue;
                srccol = srccol.concat(CUSTOMTRANS_SUF);
                orderbys.add(srccol + ' ' + "asc");
                continue;
            }
            if (("B".equals(valueouttype) || "C".equals(valueouttype)) && (nullTranCol = this.nulltransCases.get(orderId)) != null) {
                srccol = srccol.concat(NULLTRANS_SUF);
            }
            orderbys.add(srccol + ' ' + type);
        }
        orderbys.add("id asc");
        return orderbys;
    }

    private Map<String, Object> getEntryAllInfoListMap(DataSet invAccDataSet, int index, Long srcEntryId, BigDecimal qty, BigDecimal dQty, Long orgid, DynamicObject material, DynamicObject unit, DynamicObject dunit, MatchingRuleOutOrder orderRule, List<String> entryNoUpdateFieldValueList, boolean needCheckLotinTrack) {
        Long materialid = (Long)material.getPkValue();
        DynamicObject materialmaster = material.getDynamicObject("masterid");
        Long materialmasterid = (Long)materialmaster.getPkValue();
        Long masterId = (Long)((DynamicObject)material.get("masterId")).getPkValue();
        Map<String, Object> info = this.materialInfo.get(masterId);
        String unitConvertDir = (String)info.get("unitconvertdir");
        BigDecimal plusQty = qty;
        String overallMatchCol = orderRule.getOverallMatchCol();
        String preOverallMatchVal = null;
        String overallMatchVal = null;
        boolean needOverallMatch = false;
        if (overallMatchCol != null) {
            needOverallMatch = !overallMatchCol.startsWith(LOTINTRK_PRE) || needCheckLotinTrack;
        }
        Map<String, Object> handleExpandNeedFieldValues = this.getHandleExpandNeedFieldValues(index);
        int seq = 0;
        ArrayList<Map<String, Object>> singleEntryInfoList = new ArrayList<Map<String, Object>>(16);
        for (Row row : invAccDataSet) {
            if (plusQty.compareTo(BigDecimal.ZERO) <= 0 && !needOverallMatch) break;
            Long invaccId = row.getLong("id");
            BigDecimal invaccQty = row.getBigDecimal(this.currentInvaccQtyCol);
            BigDecimal remainRecordQty = MatchingRuleOutPageCache.getRemainQtyByPageCache(this.view, invaccId);
            if (this.view == null) {
                remainRecordQty = this.remainRecordQtyMapInner.get(invaccId);
            }
            if (remainRecordQty != null) {
                invaccQty = remainRecordQty;
            }
            if (BigDecimal.ZERO.compareTo(invaccQty) >= 0) continue;
            boolean currentRowOverall = false;
            if (needOverallMatch) {
                Object overallMatchObj = row.get(overallMatchCol);
                overallMatchVal = overallMatchObj != null ? overallMatchObj.toString() : NULL_STR;
                if (preOverallMatchVal == null || overallMatchVal.equals(preOverallMatchVal) || plusQty.compareTo(BigDecimal.ZERO) > 0) {
                    currentRowOverall = true;
                }
                preOverallMatchVal = overallMatchVal;
            }
            if (plusQty.compareTo(BigDecimal.ZERO) <= 0 && !currentRowOverall) break;
            long entryId = srcEntryId;
            if (entryId == 0L || seq > 0) {
                entryId = this.getEntryId();
            }
            BigDecimal currentQty = plusQty.compareTo(invaccQty) >= 0 || currentRowOverall ? invaccQty : plusQty;
            BigDecimal invaccPlusQty = invaccQty.subtract(currentQty);
            plusQty = plusQty.subtract(currentQty);
            Map<String, Object> singleEntryMap = this.putReturnEntryMap(row, invaccId, entryId, materialid, currentQty, entryNoUpdateFieldValueList);
            singleEntryInfoList.add(singleEntryMap);
            MatchingRuleOutPageCache.updateMatchPageCache(this.view, entryId, invaccId, currentQty, invaccPlusQty);
            if (this.view == null) {
                this.remainRecordQtyMapInner.put(invaccId, invaccPlusQty);
            }
            ++seq;
        }
        Integer precision = (Integer)unit.get("precision");
        Integer dPrecision = dunit != null ? (Integer)dunit.get("precision") : 0;
        HashMap<String, Object> entryMap = new HashMap<String, Object>(10);
        entryMap.put("orgid", orgid);
        entryMap.put("materialmasterid", materialmasterid);
        entryMap.put("materialname", materialmaster.getString("name"));
        entryMap.put("rulename", orderRule.getRuleName());
        entryMap.put("qtyCol", MatchingRuleOutHandler.getPure(this.currentQtyCol));
        entryMap.put("qty", qty.setScale((int)precision, 4));
        entryMap.put("dQty", dQty.setScale((int)dPrecision, 4));
        entryMap.put("plusQty", plusQty.setScale((int)precision, 4));
        entryMap.put("saveshortagerow", this.saveshortagerow);
        entryMap.put("expandNeedFieldValues", handleExpandNeedFieldValues);
        entryMap.put("entryInfo", singleEntryInfoList);
        entryMap.put("isUseAuxQty", this.materialUseAuxUnit);
        if (!StringUtils.isEmpty((String)this.dQtyCol)) {
            entryMap.put("dQtyCol", MatchingRuleOutHandler.getPure(this.dQtyCol));
        }
        entryMap.put("unitConvertDir", unitConvertDir);
        entryMap.put("qtyCol2nd", this.qtyCol2nd);
        entryMap.put("isZero", info.get("isZero"));
        return entryMap;
    }

    private Map<String, Object> getHandleExpandNeedFieldValues(int index) {
        HashMap<String, Object> handleExpandNeedFieldValues = new HashMap<String, Object>(this.handleExpandNeedFields.size());
        for (String field : this.handleExpandNeedFields) {
            Object fieldValue = this.getEntryValue(this.entry + '.' + field, index);
            if (fieldValue instanceof DynamicObject) {
                fieldValue = ((DynamicObject)fieldValue).getPkValue();
            }
            handleExpandNeedFieldValues.put(MatchingRuleOutHandler.getPure(field), fieldValue);
        }
        return handleExpandNeedFieldValues;
    }

    private Map<String, Object> putReturnEntryMap(Row row, Long invaccId, Long entryId, Long materialid, BigDecimal currentQty, List<String> entryNoUpdateFieldValueList) {
        LinkedHashMap<String, Object> singleEntryMap = new LinkedHashMap<String, Object>(this.updateFields.size() * 2);
        singleEntryMap.put("entryId", entryId);
        singleEntryMap.put("invaccId", invaccId);
        for (Map.Entry<String, String> updateField : this.updateFields.entrySet()) {
            String invacccol = updateField.getKey();
            String srcbillcol = MatchingRuleOutHandler.getPure(updateField.getValue());
            if (entryNoUpdateFieldValueList.contains(srcbillcol)) continue;
            if ("material".equals(invacccol)) {
                singleEntryMap.put(srcbillcol, materialid);
                continue;
            }
            if (this.currentInvaccQtyCol.equals(invacccol)) {
                singleEntryMap.put(srcbillcol, currentQty);
                continue;
            }
            if (ALL_QTYFIELDS.contains(invacccol)) continue;
            Object value = row.get(invacccol);
            singleEntryMap.put(srcbillcol, value);
        }
        return singleEntryMap;
    }

    private void addLotMainFileReturn(List<Map<String, Object>> entryInfoList) {
        boolean isUseLotMF = LotMainFileHelper.isUseLotMainFile();
        if (isUseLotMF) {
            String lotnumKey = MatchingRuleOutHandler.getPure(this.lotnumCol);
            RowMeta lotRowMeta = new RowMeta(new Field[]{new Field("invaccId", (DataType)DataType.LongType), new Field("entry_materialid", (DataType)DataType.LongType), new Field("entry_orgid", (DataType)DataType.LongType), new Field("entry_lotnum", (DataType)DataType.StringType)});
            DataSetBuilder lotDsBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(lotRowMeta);
            HashSet<String> lotnums = new HashSet<String>();
            for (Map<String, Object> entryMap : entryInfoList) {
                if (entryMap.isEmpty() || entryMap.containsKey("errMsg")) continue;
                Long orgid = (Long)entryMap.get("orgid");
                Long materialmasterid = (Long)entryMap.get("materialmasterid");
                List singleEntryInfoList = (List)entryMap.get("entryInfo");
                for (Map singleEntryMap : singleEntryInfoList) {
                    Long invaccId = (Long)singleEntryMap.get("invaccId");
                    String lotnum = (String)singleEntryMap.get(lotnumKey);
                    if (lotnum == null || lotnum.isEmpty()) continue;
                    lotnums.add(lotnum);
                    lotDsBuilder.append(new Object[]{invaccId, materialmasterid, orgid, lotnum});
                }
            }
            if (!lotnums.isEmpty()) {
                Set lotCfgs = (Set)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getLotMainFileBillConfigByBillAndLotNum", (Object[])new Object[]{this.formid, this.entry, this.billDynObj, this.lotnumCol});
                if (lotCfgs == null || lotCfgs.size() == 0) {
                    return;
                }
                DynamicObject lotCfg = (DynamicObject)new ArrayList(lotCfgs).get(0);
                String lotidCol = lotCfg.getString("lotidfield");
                Long lottypeid = lotCfg.getDynamicObject("masterfiletype").getLong("id");
                Integer lotUnqCtrl = (Integer)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getUnqctrl", (Object[])new Object[0]);
                DynamicObject firstEntry = this.model != null ? this.model.getEntryRowEntity(this.entry, this.selectRows.get(0).intValue()) : (DynamicObject)this.entriesDynObj.get(0);
                Map lotMainFileReturnParamMaps = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getReturnParamMapping", (Object[])new Object[]{this.billDynObj, firstEntry, lotidCol});
                DataSet lotEntryDataSet = lotDsBuilder.build();
                HashSet<String> lotSelectorSet = new HashSet<String>(4 + lotMainFileReturnParamMaps.size());
                lotSelectorSet.add("id");
                lotSelectorSet.add("number");
                lotSelectorSet.add("material");
                lotSelectorSet.add("createorg");
                lotSelectorSet.addAll(lotMainFileReturnParamMaps.keySet());
                DataSet lotMainFileDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_lot", (String)String.join((CharSequence)",", lotSelectorSet), (QFilter[])new QFilter("number", "in", lotnums).and("masterfiletype", "=", (Object)lottypeid).toArray(), (String)"");
                JoinDataSet tempDataSet = lotEntryDataSet.join(lotMainFileDataSet).on("entry_lotnum", "number").on("entry_materialid", "material");
                if (lotUnqCtrl == 3 || lotUnqCtrl == 4) {
                    tempDataSet.on("entry_orgid", "createorg");
                }
                DataSet result = tempDataSet.select(lotMainFileDataSet.getRowMeta().getFieldNames(), new String[]{"invaccId"}).finish();
                HashMap lotReturnMap = new HashMap();
                for (Row row : result) {
                    HashMap<String, Object> lotReturnAttrs = new HashMap<String, Object>(lotMainFileReturnParamMaps.size());
                    Long invaccId = row.getLong("invaccId");
                    Long lotid = row.getLong("id");
                    lotReturnAttrs.put(MatchingRuleOutHandler.getPure(lotidCol), lotid);
                    for (Map.Entry returnEntry : lotMainFileReturnParamMaps.entrySet()) {
                        String lotKey = (String)returnEntry.getKey();
                        String billKey = (String)returnEntry.getValue();
                        if (billKey.lastIndexOf(46) == -1 || "number".equals(lotKey)) continue;
                        lotReturnAttrs.put(MatchingRuleOutHandler.getPure(billKey), row.get(lotKey));
                    }
                    lotReturnMap.put(invaccId, lotReturnAttrs);
                }
                for (Map<String, Object> entryMap : entryInfoList) {
                    if (entryMap.isEmpty() || entryMap.containsKey("errMsg")) continue;
                    List singleEntryInfoList = (List)entryMap.get("entryInfo");
                    for (Map singleEntryMap : singleEntryInfoList) {
                        Long invaccId = (Long)singleEntryMap.get("invaccId");
                        Map lotReturnAttrs = (Map)lotReturnMap.get(invaccId);
                        if (lotReturnAttrs == null) continue;
                        for (Map.Entry lotReturnAttr : lotReturnAttrs.entrySet()) {
                            String lotReturnCol = (String)lotReturnAttr.getKey();
                            Object lotReturnValue = lotReturnAttr.getValue();
                            singleEntryMap.putIfAbsent(lotReturnCol, lotReturnValue);
                        }
                    }
                }
            }
        }
    }

    public boolean showConfirmIfNeed(List<Map<String, Object>> entryInfoList) {
        if (this.view != null && !"match".equals(this.matchshortage)) {
            boolean isEnough = true;
            int selectRowIndex = 0;
            StringBuilder notEnoughMsgBuilder = new StringBuilder();
            for (Map<String, Object> entryInfo : entryInfoList) {
                if (entryInfo.isEmpty()) {
                    ++selectRowIndex;
                    continue;
                }
                BigDecimal plusQty = (BigDecimal)entryInfo.get("plusQty");
                if (plusQty.compareTo(BigDecimal.ZERO) > 0) {
                    isEnough = false;
                    int index = this.selectRows.get(selectRowIndex);
                    String materialName = (String)entryInfo.get("materialname");
                    String ruleName = (String)entryInfo.get("rulename");
                    boolean isZero = (Boolean)entryInfo.get("isZero");
                    String notEnoughMsg = "";
                    notEnoughMsg = this.isAvbQty2nd == false || this.isAvbQty2nd != false && isZero ? String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u7684\u7269\u6599\uff1a%2$s %3$s\uff0c\u4e0d\u8db3\u6570\u91cf\u4e3a\uff1a%4$s\u3002", (String)"MatchingRuleOutHandler_4", (String)"scmc-im-business", (Object[])new Object[0]), index + 1, materialName, ruleName, plusQty) : String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u7684\u7269\u6599\uff1a%2$s %3$s\uff0c\u4e0d\u8db3\u8f85\u52a9\u6570\u91cf\u4e3a\uff1a%4$s\u3002", (String)"MatchingRuleOutHandler_8", (String)"scmc-im-business", (Object[])new Object[0]), index + 1, materialName, ruleName, plusQty);
                    notEnoughMsgBuilder.append(notEnoughMsg).append("\n");
                }
                ++selectRowIndex;
            }
            if (!isEnough) {
                ConfirmCallBackListener cb = new ConfirmCallBackListener("cb_matchruleout_new", this.formPlugin);
                HashMap<String, Object> matchResult = new HashMap<String, Object>(5);
                matchResult.put("formid", this.formid);
                matchResult.put("entry", this.entry);
                matchResult.put("operatekey", this.operatekey);
                matchResult.put("selectRows", this.selectRows);
                matchResult.put("entryInfoList", entryInfoList);
                if ("notmatch".equals(this.matchshortage)) {
                    this.view.showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7269\u6599\u5e93\u5b58\u4e0d\u8db3", (String)"MatchingRuleOutHandler_5", (String)"scmc-im-business", (Object[])new Object[0]), notEnoughMsgBuilder.toString(), MessageBoxOptions.None, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(matchResult));
                } else {
                    this.view.showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7269\u6599\u5e93\u5b58\u4e0d\u8db3\uff0c\u662f\u5426\u6309\u73b0\u6709\u5e93\u5b58\u5339\u914d\uff1f", (String)"MatchingRuleOutHandler_6", (String)"scmc-im-business", (Object[])new Object[0]), notEnoughMsgBuilder.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(matchResult));
                }
                return true;
            }
        }
        return false;
    }

    protected static String getPure(String currentValue) {
        int lastIndex = currentValue.lastIndexOf(46);
        if (lastIndex != -1) {
            return currentValue.substring(lastIndex + 1);
        }
        return currentValue;
    }

    private static boolean isNullValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        return value instanceof BigDecimal && BigDecimal.ZERO.compareTo((BigDecimal)value) == 0;
    }

    private long getEntryId() {
        return DB.genLongId((String)this.entryTable);
    }

    private Long getEntryId(int index) {
        return (Long)((DynamicObject)this.entriesDynObj.get(index)).getPkValue();
    }

    protected abstract Object getEntryValue(String var1, int var2);

    private DataSet mergeReserveQty(DataSet invAccDataSet) {
        if (!SupplyChainParameterHelper.getScmParam()) {
            return invAccDataSet;
        }
        DataSet spDataSet = QueryServiceHelper.queryDataSet((String)MatchingRuleOutNewHelper.class.getName(), (String)"msmod_reserve_bal_sp", (String)"invid,baseqty as spbaseqty,qty as spqty ,qty2nd as spqty2nd", null, null);
        if (!spDataSet.hasNext()) {
            return invAccDataSet;
        }
        spDataSet = spDataSet.groupBy(new String[]{FILED_INVID}).sum("spbaseqty").sum("spqty").sum("spqty2nd").finish();
        String[] invaccFields = invAccDataSet.getRowMeta().getFieldNames();
        DataSet qty = invAccDataSet.join(spDataSet, JoinType.LEFT).on("id", FILED_INVID).select(invaccFields, RESERVE_SP_FIELDS).finish();
        return this.calReverseQty(qty);
    }

    private DataSet calReverseQty(DataSet qty) {
        String[] spFieldNames = qty.getRowMeta().getFieldNames();
        for (int i = 0; i < spFieldNames.length; ++i) {
            if ("lockqty".equals(spFieldNames[i])) {
                spFieldNames[i] = "(lockqty + spqty) AS lockqty";
            }
            if ("lockbaseqty".equals(spFieldNames[i])) {
                spFieldNames[i] = "(spbaseqty + lockbaseqty) AS lockbaseqty";
            }
            if (!"lockqty2nd".equals(spFieldNames[i])) continue;
            spFieldNames[i] = "(spqty2nd + lockqty2nd) AS lockqty2nd";
        }
        return qty.select(spFieldNames);
    }
}

