/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.pojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.scmc.im.business.pojo.ValidateResult;

public class ValidateResultCollection {
    private Map<String, ValidateResult> validateInfo = new HashMap<String, ValidateResult>();

    public void addValidateInfo(String billId, String message) {
        ValidateResult result = this.validateInfo.get(billId);
        List<String> messages = null;
        StringBuilder sbf = new StringBuilder();
        if (result == null) {
            messages = new ArrayList<String>();
            result = new ValidateResult();
            sbf.append(message);
            sbf.append('\n');
            messages.add(sbf.toString());
            result.setErrValResult(messages);
            this.validateInfo.put(billId, result);
            return;
        }
        messages = result.getValResults();
        if (messages == null) {
            messages = new ArrayList<String>();
            sbf.append(message);
            sbf.append('\n');
            messages.add(sbf.toString());
            result.setErrValResult(messages);
            this.validateInfo.put(billId, result);
            return;
        }
        if (!messages.contains(message)) {
            sbf.append(message);
            sbf.append('\n');
            messages.add(sbf.toString());
            result.setErrValResult(messages);
            this.validateInfo.put(billId, result);
        }
    }

    public void addValidateResult(String billId, ValidateResult validateResult) {
        if (validateResult == null) {
            return;
        }
        ValidateResult result = this.validateInfo.get(billId);
        if (result == null) {
            this.validateInfo.put(billId, validateResult);
            return;
        }
        if (result == validateResult || result.equals(validateResult)) {
            return;
        }
        List<String> srcErrMsgs = result.getValResults();
        List<String> addErrMsgs = validateResult.getValResults();
        for (String newErr : addErrMsgs) {
            if (srcErrMsgs.contains(newErr)) continue;
            srcErrMsgs.add(newErr);
        }
        if (!srcErrMsgs.isEmpty()) {
            result.setIsVaild(Boolean.FALSE);
        }
    }

    public void addAllValidateResults(ValidateResultCollection vResult) {
        if (vResult == null || vResult == this) {
            return;
        }
        Map<String, ValidateResult> vResultData = vResult.getAllValidateInfos();
        if (vResultData.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ValidateResult> vResultEntry : vResultData.entrySet()) {
            String billId = vResultEntry.getKey();
            ValidateResult result = vResultEntry.getValue();
            this.addValidateResult(billId, result);
        }
    }

    private Map<String, ValidateResult> getAllValidateInfos() {
        return this.validateInfo;
    }

    public ValidateResult getValidateResult(String billId) {
        ValidateResult result = this.validateInfo.get(billId);
        if (result == null) {
            result = new ValidateResult();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.validateInfo.isEmpty();
    }

    public String toString() {
        return "ValidateResult [validateInfo=" + this.validateInfo + "]";
    }
}

