/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.LRUCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.service.InvSchemeService;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSchemeService
implements InvSchemeService {
    protected IFormView view = null;
    protected DynamicObject bill = null;
    private boolean formPage = false;
    private LRUCache<String, String> localCache = null;

    public DynamicObject getBill() {
        return this.bill;
    }

    public void setBill(DynamicObject bill) {
        this.bill = bill;
    }

    public AbstractSchemeService() {
    }

    public AbstractSchemeService(DynamicObject bill) {
        this.bill = bill;
    }

    public AbstractSchemeService(IFormView view) {
        this.view = view;
        this.bill = view.getModel().getDataEntity();
        this.formPage = true;
    }

    private IPageCache getPageCache() {
        if (this.view == null) {
            return null;
        }
        IPageCache pageCache = (IPageCache)this.view.getService(IPageCache.class);
        return pageCache;
    }

    @Override
    public void setView(IFormView view) {
        this.view = view;
    }

    private LRUCache<String, String> getLocalCache() {
        int size;
        if (this.localCache != null) {
            return this.localCache;
        }
        if (this.view == null) {
            DynamicObjectCollection entrys = this.bill.getDynamicObjectCollection("billentry");
            size = entrys.size();
        } else {
            size = this.view.getModel().getEntryRowCount("billentry");
        }
        this.localCache = new LRUCache(size * 2 + 1);
        return this.localCache;
    }

    protected String getCache(String key) {
        String value = null;
        if (this.formPage) {
            IPageCache pageCache = this.getPageCache();
            if (pageCache != null) {
                value = pageCache.get(key);
            }
        } else {
            value = (String)this.getLocalCache().get((Object)key);
        }
        return value;
    }

    protected void putCache(String key, String value) {
        if (this.formPage) {
            IPageCache pageCache = this.getPageCache();
            if (pageCache != null) {
                pageCache.put(key, value);
            }
        } else {
            this.getLocalCache().put((Object)key, (Object)value);
        }
    }

    public IFormView getView() {
        return this.view;
    }

    public Object getValue(String key) {
        return this.bill.get(key);
    }

    public Object getValue(String key, int i) {
        if (this.view == null) {
            DynamicObjectCollection entrys = this.bill.getDynamicObjectCollection("billentry");
            return ((DynamicObject)entrys.get(i)).get(key);
        }
        DynamicObject entryRowEntity = this.view.getModel().getEntryRowEntity("billentry", i);
        return entryRowEntity.get(key);
    }

    protected Long getCompanyByOrg(Long bizOrgId) {
        Long settleOrgId = null;
        if (bizOrgId != null) {
            String nullStr = "empty";
            String cacheKey = "settleOrgIdcache_" + bizOrgId;
            String settleOrgIdStr = this.getCache(cacheKey);
            if (settleOrgIdStr == null) {
                settleOrgId = this.queryCompanyId(bizOrgId);
                if (settleOrgId != null && StringUtils.isNotEmpty((CharSequence)settleOrgId.toString())) {
                    this.putCache(cacheKey, settleOrgId.toString());
                } else {
                    this.putCache(cacheKey, nullStr);
                }
            } else if (!nullStr.equals(settleOrgIdStr)) {
                settleOrgId = Long.valueOf(settleOrgIdStr);
            }
        }
        return settleOrgId;
    }

    Long getDefaultOwner(DynamicObject invOrg, DynamicObject reqOrg) {
        if (invOrg == null) {
            return null;
        }
        Map<String, Object> delegation = this.getDelegationOrgList((Long)invOrg.getPkValue());
        List orgIds = (List)delegation.get("orgId");
        if (orgIds == null || orgIds.size() == 0) {
            DynamicObject orgDyc = (DynamicObject)this.getValue("org");
            List<Object> ownerList = this.getOwnerList(orgDyc);
            if (ownerList.size() > 0) {
                return Long.valueOf(ownerList.get(0).toString());
            }
        } else {
            if (reqOrg == null) {
                return null;
            }
            Long companyByOrg = this.getCompanyByOrg((Long)reqOrg.getPkValue());
            if (orgIds.contains(companyByOrg)) {
                return companyByOrg;
            }
            List detailList = (List)delegation.get("data");
            for (Map detailMap : detailList) {
                Boolean isDefault = (Boolean)detailMap.get("isDefault");
                if (!isDefault.booleanValue() || detailMap.get("orgId") == null) continue;
                return detailMap.get("orgId") instanceof Long ? (Long)detailMap.get("orgId") : Long.valueOf(detailMap.get("orgId").toString());
            }
        }
        return null;
    }

    List<Long> getOwnerList(Long invOrgId) {
        boolean isAccoutOrg = OrgUnitServiceHelper.checkOrgFunction((Long)invOrgId, (String)"10");
        Map<String, Object> delegation = this.getDelegationOrgList(invOrgId);
        List orgIds = (List)delegation.get("orgId");
        if (orgIds != null && orgIds.size() > 0) {
            if (isAccoutOrg) {
                orgIds.add(invOrgId);
            }
            return orgIds;
        }
        DynamicObject orgDyc = (DynamicObject)this.getValue("org");
        List<Object> list = this.getOwnerList(orgDyc);
        ArrayList<Long> owners = new ArrayList<Long>(16);
        for (Object o : list) {
            owners.add(Long.valueOf(o.toString()));
        }
        return owners;
    }

    private Map<String, Object> getDelegationOrgList(Long orgId) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setFromViewType("10");
        param.setToViewType("05");
        param.setDirectViewType("fromorg");
        return OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
    }

    private Long queryCompanyId(Long bizOrgId) {
        Long settleOrgId = null;
        Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)bizOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (map != null) {
            settleOrgId = (Long)map.get("id");
        }
        return settleOrgId;
    }

    protected List<Object> getOwnerList(DynamicObject org) {
        List<Object> array = new ArrayList<Object>();
        if (org != null) {
            Long orgId = (Long)org.getPkValue();
            String cacheKey = "ownercache_" + orgId;
            String ownerArrayStr = this.getCache(cacheKey);
            if (ownerArrayStr == null) {
                array = this.queryOwnerList(orgId);
                ownerArrayStr = StringUtils.join(array, (String)",");
                this.putCache(cacheKey, ownerArrayStr);
            } else {
                String[] ownerArray;
                for (String owner : ownerArray = ownerArrayStr.split(",")) {
                    array.add(Long.valueOf(owner));
                }
            }
        }
        return array;
    }

    private List<Object> queryOwnerList(Long orgId) {
        ArrayList<Object> array = new ArrayList<Object>();
        ArrayList<Object> ownerArray = OwnerHelper.getOwners(orgId);
        array.addAll(ownerArray);
        Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        Object settleOrgId = null;
        if (companyByOrg != null && (settleOrgId = (Object)companyByOrg.get("id")) != null && StringUtils.isNotEmpty((CharSequence)settleOrgId.toString())) {
            array.add(settleOrgId);
        }
        return array;
    }

    public boolean isFormPage() {
        return this.formPage;
    }

    protected void setKeeperOwnerEnable(int rowIndex, String keeperOwnerType, String keeperOwnerKey) {
        IFormView view = this.getView();
        this.setKeeperOwnerEnable(view, rowIndex, keeperOwnerType, keeperOwnerKey);
    }

    private void setKeeperOwnerEnable(IFormView view, int rowIndex, String keeperOwnerType, String keeperOwnerKey) {
        if (StringUtils.isEmpty((CharSequence)keeperOwnerType)) {
            view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{keeperOwnerKey});
            return;
        }
        switch (keeperOwnerType) {
            case "bos_org": {
                view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{keeperOwnerKey});
                break;
            }
            case "bd_customer": 
            case "bd_supplier": {
                view.setEnable(Boolean.valueOf(true), rowIndex, new String[]{keeperOwnerKey});
                break;
            }
        }
    }

    protected void setOwnerFieldEnable(int rowIndex, String ownerType, String ownerKey) {
        boolean isEmpty = StringUtils.isEmpty((CharSequence)ownerType);
        this.getView().setEnable(Boolean.valueOf(!isEmpty), rowIndex, new String[]{ownerKey});
    }
}

