/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.exception.ErrorCode;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.service.AbstractSchemeService;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class InspectInvSchemeService
extends AbstractSchemeService {
    private static Set<String> INSPECT_BILL_TYPES = new HashSet<String>(Arrays.asList("sm_delivernotice", "sm_returnapply"));

    public InspectInvSchemeService() {
    }

    public InspectInvSchemeService(DynamicObject bill) {
        super(bill);
    }

    public InspectInvSchemeService(IFormView view) {
        super(view);
    }

    @Override
    public Object getDefalutOwner(String type, int i) {
        Long owner = null;
        if (StringUtils.isEmpty((String)type)) {
            return owner;
        }
        switch (type) {
            case "bos_org": {
                DynamicObject reqOrg = (DynamicObject)this.getValue("entryreqorg", i);
                if (reqOrg == null) break;
                DynamicObject orgDyc = (DynamicObject)this.getValue("org");
                owner = this.getDefaultOwner(orgDyc, reqOrg);
                break;
            }
            case "bd_customer": {
                owner = this.getSrcBillFiled("customer");
                break;
            }
            case "bd_supplier": {
                owner = this.getSrcBillFiled("supplier");
                break;
            }
        }
        return owner;
    }

    @Override
    public Object getDefalutKeeper(String type, int rowIndex) {
        Long keeperId = null;
        if (StringUtils.isEmpty((String)type)) {
            return keeperId;
        }
        switch (type) {
            case "bos_org": {
                DynamicObject org = (DynamicObject)this.getValue("org");
                if (org == null) break;
                keeperId = (Long)org.getPkValue();
                break;
            }
            case "bd_customer": {
                keeperId = this.getSrcBillFiled("customer");
                break;
            }
            case "bd_supplier": {
                keeperId = this.getSrcBillFiled("supplier");
                break;
            }
        }
        return keeperId;
    }

    @Override
    public Object getDefalutOutOwner(String type, int rowIndex) {
        Long outOwnerId = null;
        if (StringUtils.isEmpty((String)type)) {
            return outOwnerId;
        }
        switch (type) {
            case "bos_org": {
                DynamicObject reqOrg = (DynamicObject)this.getValue("entryreqorg", rowIndex);
                if (reqOrg == null) break;
                DynamicObject orgDyc = (DynamicObject)this.getValue("org");
                outOwnerId = this.getDefaultOwner(orgDyc, reqOrg);
                break;
            }
            case "bd_customer": {
                outOwnerId = this.getSrcBillFiled("customer");
                break;
            }
            case "bd_supplier": {
                outOwnerId = this.getSrcBillFiled("supplier");
                break;
            }
        }
        return outOwnerId;
    }

    @Override
    public Object getDefalutOutKeeper(String type, int i) {
        Long outKeeperId = null;
        if (StringUtils.isEmpty((String)type)) {
            return outKeeperId;
        }
        switch (type) {
            case "bos_org": {
                DynamicObject org = (DynamicObject)this.getValue("org");
                if (org == null) break;
                outKeeperId = (Long)org.getPkValue();
                break;
            }
            case "bd_customer": {
                outKeeperId = this.getSrcBillFiled("customer");
                break;
            }
            case "bd_supplier": {
                outKeeperId = this.getSrcBillFiled("supplier");
                break;
            }
        }
        return outKeeperId;
    }

    @Override
    public void setOwnerF7Select(BeforeF7SelectEvent e, int i) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter f = null;
        String type = (String)this.getValue("ownertype", i);
        if (StringUtils.isEmpty((String)type)) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getValue("org");
        switch (type) {
            case "bos_org": {
                if (org == null) {
                    this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                    e.setCancel(true);
                    return;
                }
                List<Long> ownerList = this.getOwnerList((Long)org.getPkValue());
                f = new QFilter("id", "in", ownerList);
                showParameter.setCustomParam("orgFuncId", (Object)"10");
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public void setKeeperF7Select(BeforeF7SelectEvent e, int i) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String type = (String)this.getValue("keepertype", i);
        if (StringUtils.isEmpty((String)type)) {
            return;
        }
        QFilter f = null;
        DynamicObject org = (DynamicObject)this.getValue("org");
        switch (type) {
            case "bos_org": {
                f = new QFilter("id", "=", org == null ? null : org.getPkValue());
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public void setOutOwnerF7Select(BeforeF7SelectEvent e, int i) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String type = (String)this.getValue("outownertype", i);
        if (StringUtils.isEmpty((String)type)) {
            return;
        }
        QFilter f = null;
        DynamicObject org = (DynamicObject)this.getValue("org");
        switch (type) {
            case "bos_org": {
                if (org == null) {
                    this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                    e.setCancel(true);
                    return;
                }
                List<Long> ownerList = this.getOwnerList((Long)org.getPkValue());
                f = new QFilter("id", "in", ownerList);
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public void setOutKeeperF7Select(BeforeF7SelectEvent e, int i) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String type = (String)this.getValue("outkeepertype", i);
        if (StringUtils.isEmpty((String)type)) {
            return;
        }
        QFilter f = null;
        DynamicObject org = (DynamicObject)this.getValue("org");
        switch (type) {
            case "bos_org": {
                f = new QFilter("id", "=", org == null ? null : org.getPkValue());
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public void setOutKeeperEnable(int rowIndex) {
        String outKeeperType = (String)this.getValue("outkeepertype", rowIndex);
        this.setKeeperOwnerEnable(rowIndex, outKeeperType, "outkeeper");
    }

    @Override
    public void setOutKeeperEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("outkeepertype");
        this.setKeeperOwnerEnable(rowIndex, ownerType, "outkeeper");
    }

    @Override
    public void setOutOwnerEnable(int rowIndex) {
        String outOwnerType = (String)this.getValue("outownertype", rowIndex);
        this.setOutOwnerEnable(rowIndex, outOwnerType);
    }

    @Override
    public void setOutOwnerEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String outOwnerType = entry.getString("outownertype");
        this.setOutOwnerEnable(rowIndex, outOwnerType);
    }

    private void setOutOwnerEnable(int rowIndex, String outOwnerType) {
        if (StringUtils.isEmpty((String)outOwnerType)) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"outowner"});
            return;
        }
        switch (outOwnerType) {
            case "bos_org": 
            case "bd_customer": 
            case "bd_supplier": {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"outowner"});
                break;
            }
        }
    }

    @Override
    public void setKeeperEnable(int rowIndex) {
        String keeperType = (String)this.getValue("keepertype", rowIndex);
        this.setKeeperOwnerEnable(rowIndex, keeperType, "keeper");
    }

    @Override
    public void setKeeperEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("keepertype");
        this.setKeeperOwnerEnable(rowIndex, ownerType, "keeper");
    }

    @Override
    public void setOwnerEnable(int rowIndex) {
        String ownerType = (String)this.getValue("ownertype", rowIndex);
        this.setOwnerFieldEnable(rowIndex, ownerType, "owner");
    }

    @Override
    public void setOwnerEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("ownertype");
        this.setOwnerFieldEnable(rowIndex, ownerType, "owner");
    }

    private Long getSrcBillFiled(String fieldName) {
        boolean hasSupplier;
        Long fieldId = null;
        if (StringUtils.isEmpty((String)fieldName)) {
            return fieldId;
        }
        DynamicObjectCollection entryCollection = this.getBill().getDynamicObjectCollection("billentry");
        if (CollectionUtils.isEmpty((Collection)entryCollection)) {
            return fieldId;
        }
        DynamicObject entry = (DynamicObject)entryCollection.get(0);
        Object srcbillid = entry.get("srcbillid");
        String srcbillNumber = entry.getString("srcbillentity");
        if (srcbillid == null || StringUtils.isEmpty((String)srcbillNumber)) {
            return fieldId;
        }
        QFilter qFilter = new QFilter("id", "=", srcbillid);
        DynamicObject srcbill = null;
        boolean hasCustomer = "customer".equals(fieldName) && INSPECT_BILL_TYPES.contains(srcbillNumber);
        boolean bl = hasSupplier = "supplier".equals(fieldName) && "im_purreceivebill".equals(srcbillNumber);
        if ((hasCustomer || hasSupplier) && (srcbill = BusinessDataServiceHelper.loadSingle((String)srcbillNumber, (String)("id," + fieldName), (QFilter[])qFilter.toArray())) != null && srcbill.getDynamicObject(fieldName) != null) {
            fieldId = (Long)srcbill.getDynamicObject(fieldName).getPkValue();
        }
        return fieldId;
    }
}

