/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.service;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.exception.ErrorCode;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.service.AbstractSchemeService;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.F7Utils;
import org.apache.commons.lang3.StringUtils;

public class MReqOutInvSchemeService
extends AbstractSchemeService {
    public MReqOutInvSchemeService() {
    }

    public MReqOutInvSchemeService(DynamicObject bill) {
        super(bill);
    }

    public MReqOutInvSchemeService(IFormView view) {
        super(view);
    }

    @Override
    public Object getDefalutOwner(String type, int i) {
        Object ownerId = null;
        DynamicObject settleorg = (DynamicObject)this.getValue("org");
        if (StringUtils.isEmpty((CharSequence)type)) {
            return ownerId;
        }
        switch (type) {
            case "bos_org": {
                if (settleorg == null) break;
                ownerId = settleorg.getPkValue();
                break;
            }
            case "bd_customer": {
                break;
            }
            case "bd_supplier": {
                break;
            }
        }
        return ownerId;
    }

    @Override
    public Object getDefalutKeeper(String type, int i) {
        Object keeperId = null;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return keeperId;
        }
        switch (type) {
            case "bos_org": {
                DynamicObject org = (DynamicObject)this.getValue("org");
                if (org == null) break;
                keeperId = org.getPkValue();
                break;
            }
            case "bd_customer": 
            case "bd_supplier": {
                break;
            }
        }
        return keeperId;
    }

    @Override
    public Object getDefalutOutOwner(String type, int i) {
        Long ownerId = null;
        DynamicObject supplyowner = (DynamicObject)this.getValue("supplyowner");
        if (StringUtils.isEmpty((CharSequence)type)) {
            return ownerId;
        }
        switch (type) {
            case "bos_org": 
            case "bd_customer": 
            case "bd_supplier": {
                if (supplyowner == null) break;
                ownerId = (Long)supplyowner.getPkValue();
                break;
            }
        }
        return ownerId;
    }

    @Override
    public Object getDefalutOutKeeper(String type, int i) {
        Long keeperId = null;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return keeperId;
        }
        switch (type) {
            case "bos_org": {
                DynamicObject org = (DynamicObject)this.getValue("org");
                if (org == null) break;
                keeperId = (Long)org.getPkValue();
                break;
            }
            case "bd_customer": {
                break;
            }
            case "bd_supplier": {
                break;
            }
        }
        return keeperId;
    }

    @Override
    public void setOwnerEnable(int rowIndex) {
        String ownerType = (String)this.getValue("ownertype", rowIndex);
        this.setOwnerFieldEnable(rowIndex, ownerType, "owner");
    }

    @Override
    public void setOwnerEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("ownertype");
        this.setOwnerFieldEnable(rowIndex, ownerType, "owner");
    }

    @Override
    public void setKeeperEnable(int rowIndex) {
        String keeperType = (String)this.getValue("keepertype", rowIndex);
        this.setKeeperOwnerEnable(rowIndex, keeperType, "keeper");
    }

    @Override
    public void setKeeperEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("keepertype");
        this.setKeeperOwnerEnable(rowIndex, ownerType, "keeper");
    }

    @Override
    public void setOutOwnerEnable(int rowIndex) {
        String outOwnerType = (String)this.getValue("outownertype", rowIndex);
        this.setOwnerFieldEnable(rowIndex, outOwnerType, "outowner");
    }

    @Override
    public void setOutOwnerEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String outOwnerType = entry.getString("outownertype");
        this.setOwnerFieldEnable(rowIndex, outOwnerType, "outowner");
    }

    @Override
    public void setOutKeeperEnable(int rowIndex) {
        String outKeeperType = (String)this.getValue("outkeepertype", rowIndex);
        this.setKeeperOwnerEnable(rowIndex, outKeeperType, "outkeeper");
    }

    @Override
    public void setOutKeeperEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("outkeepertype");
        this.setKeeperOwnerEnable(rowIndex, ownerType, "outkeeper");
    }

    @Override
    public void setOwnerF7Select(BeforeF7SelectEvent e, int rowIndex) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String type = (String)this.getValue("ownertype", rowIndex);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        QFilter f = null;
        DynamicObject org = (DynamicObject)this.getValue("org");
        switch (type) {
            case "bos_org": {
                DynamicObject settleorg = (DynamicObject)this.getValue("settleorg");
                f = new QFilter("id", "=", settleorg == null ? null : settleorg.getPkValue());
                showParameter.setCustomParam("orgFuncId", (Object)"10");
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    public ArrayList<Object> getOwnerList() {
        DynamicObject org = (DynamicObject)this.getValue("org");
        ArrayList<Object> array = new ArrayList<Object>();
        if (!CommonUtils.isNull((Object)org)) {
            Long orgId = (Long)org.getPkValue();
            ArrayList<Object> ownerArray = OwnerHelper.getOwners(orgId);
            array.addAll(ownerArray);
            Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            if (companyByOrg != null) {
                array.add(companyByOrg.get("id"));
            }
        }
        return array;
    }

    @Override
    public void setKeeperF7Select(BeforeF7SelectEvent e, int rowIndex) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String type = (String)this.getValue("keepertype", rowIndex);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        QFilter f = null;
        DynamicObject org = (DynamicObject)this.getValue("org");
        switch (type) {
            case "bos_org": {
                f = new QFilter("id", "=", org == null ? null : org.getPkValue());
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public void setOutOwnerF7Select(BeforeF7SelectEvent e, int rowIndex) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String type = (String)this.getValue("outownertype", rowIndex);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        QFilter f = null;
        DynamicObject org = (DynamicObject)this.getValue("org");
        switch (type) {
            case "bos_org": {
                if (org == null) {
                    this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                    e.setCancel(true);
                    return;
                }
                f = new QFilter("id", "in", this.getOwnerList(org.getLong("id")));
                showParameter.setCustomParam("orgFuncId", (Object)"10");
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org == null) {
                    this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                    e.setCancel(true);
                    return;
                }
                this.addVMISelect(e);
                break;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    private void addVMISelect(BeforeF7SelectEvent e) {
        String domain;
        DynamicObject bizType = (DynamicObject)this.getValue("biztype");
        if (bizType != null && "6".equals(domain = bizType.getString("domain"))) {
            QFilter q = new QFilter("enablevmi", "=", (Object)"1");
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)q);
        }
    }

    @Override
    public void setOutKeeperF7Select(BeforeF7SelectEvent e, int rowIndex) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String type = (String)this.getValue("outkeepertype", rowIndex);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        QFilter f = null;
        DynamicObject org = (DynamicObject)this.getValue("org");
        switch (type) {
            case "bos_org": {
                f = new QFilter("id", "=", org == null ? null : org.getPkValue());
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }
}

