/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.service;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.exception.ErrorCode;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.service.AbstractSchemeService;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import org.apache.commons.lang3.StringUtils;

public class PurReceInvSchemeService
extends AbstractSchemeService {
    public PurReceInvSchemeService() {
    }

    public PurReceInvSchemeService(DynamicObject bill) {
        super(bill);
    }

    public PurReceInvSchemeService(IFormView view) {
        super(view);
    }

    @Override
    public Object getDefalutOwner(String type, int i) {
        Long ownerId = null;
        DynamicObject reqOrg = (DynamicObject)this.getValue("entryreqorg", i);
        DynamicObject supplier = (DynamicObject)this.getValue("supplier");
        String outOwnerType = (String)this.getValue("ownertype", i);
        if (StringUtils.isEmpty((CharSequence)outOwnerType)) {
            return ownerId;
        }
        switch (outOwnerType) {
            case "bos_org": {
                if (reqOrg == null) break;
                DynamicObject orgDyc = (DynamicObject)this.getValue("org");
                ownerId = this.getDefaultOwner(orgDyc, reqOrg);
                break;
            }
            case "bd_customer": {
                DynamicObject owner = (DynamicObject)this.getValue("owner", i);
                if (owner == null) break;
                ownerId = (Long)owner.getPkValue();
                break;
            }
            case "bd_supplier": {
                if (supplier == null) break;
                ownerId = (Long)supplier.getPkValue();
                break;
            }
        }
        return ownerId;
    }

    @Override
    public void setOwnerF7Select(BeforeF7SelectEvent e, int i) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter f = null;
        String type = (String)this.getValue("ownertype", i);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getValue("org");
        if ("bos_org".equals(type)) {
            if (org == null) {
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            List<Long> ownerList = this.getOwnerList((Long)org.getPkValue());
            f = new QFilter("id", "in", ownerList);
            showParameter.setCustomParam("orgFuncId", (Object)"10");
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public void setOutOwnerF7Select(BeforeF7SelectEvent e, int i) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String type = (String)this.getValue("outownertype", i);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        QFilter f = null;
        DynamicObject org = (DynamicObject)this.getValue("org");
        switch (type) {
            case "bos_org": {
                if (org == null) {
                    this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                    e.setCancel(true);
                    return;
                }
                List<Long> ownerList = this.getOwnerList((Long)org.getPkValue());
                f = new QFilter("id", "in", ownerList);
                showParameter.setCustomParam("orgFuncId", (Object)"10");
                break;
            }
            case "bd_customer": {
                break;
            }
            case "bd_supplier": {
                break;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public Object getDefalutOutOwner(String type, int rowIndex) {
        Object outOwner = null;
        DynamicObject org = (DynamicObject)this.getValue("org");
        DynamicObject supplier = (DynamicObject)this.getValue("supplier");
        String outOwnerType = (String)this.getValue("outownertype", rowIndex);
        DynamicObject reqOrg = (DynamicObject)this.getValue("entryreqorg", rowIndex);
        if (StringUtils.isEmpty((CharSequence)outOwnerType)) {
            return outOwner;
        }
        switch (outOwnerType) {
            case "bos_org": {
                if (reqOrg == null) break;
                outOwner = this.getDefaultOwner(org, reqOrg);
                break;
            }
            case "bd_customer": {
                outOwner = this.getValue("outowner", rowIndex);
                break;
            }
            case "bd_supplier": {
                if (supplier == null) break;
                outOwner = (Long)supplier.getPkValue();
                break;
            }
        }
        return outOwner;
    }

    @Override
    public Object getDefalutKeeper(String type, int rowIndex) {
        Long keeperId = null;
        DynamicObject org = (DynamicObject)this.getValue("org");
        DynamicObject supplier = (DynamicObject)this.getValue("supplier");
        String keeperType = (String)this.getValue("keepertype", rowIndex);
        if (StringUtils.isEmpty((CharSequence)keeperType)) {
            return keeperId;
        }
        switch (keeperType) {
            case "bos_org": {
                if (org == null) break;
                keeperId = (Long)org.getPkValue();
                break;
            }
            case "bd_customer": {
                DynamicObject keeper = (DynamicObject)this.getValue("keeper", rowIndex);
                if (keeper == null) break;
                keeperId = (Long)keeper.getPkValue();
                break;
            }
            case "bd_supplier": {
                if (supplier == null) break;
                keeperId = (Long)supplier.getPkValue();
                break;
            }
        }
        return keeperId;
    }

    @Override
    public Object getDefalutOutKeeper(String type, int rowIndex) {
        Long outKeeperId = null;
        DynamicObject supplier = (DynamicObject)this.getValue("supplier");
        String keeperType = (String)this.getValue("outkeepertype", rowIndex);
        if (StringUtils.isEmpty((CharSequence)keeperType)) {
            return outKeeperId;
        }
        switch (keeperType) {
            case "bos_org": {
                DynamicObject org = (DynamicObject)this.getValue("org");
                if (org == null) break;
                outKeeperId = (Long)org.getPkValue();
                break;
            }
            case "bd_customer": {
                DynamicObject outKeeper = (DynamicObject)this.getValue("outkeeper", rowIndex);
                if (outKeeper == null) break;
                outKeeperId = (Long)outKeeper.getPkValue();
                break;
            }
            case "bd_supplier": {
                if (supplier == null) break;
                outKeeperId = (Long)supplier.getPkValue();
                break;
            }
        }
        return outKeeperId;
    }

    @Override
    public void setOwnerEnable(int rowIndex) {
        String ownerType = (String)this.getValue("ownertype", rowIndex);
        this.setKeeperOwnerEnable(rowIndex, ownerType, "owner");
    }

    @Override
    public void setOwnerEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("ownertype");
        this.setKeeperOwnerEnable(rowIndex, ownerType, "owner");
    }

    @Override
    public void setKeeperEnable(int rowIndex) {
        String keeperType = (String)this.getValue("keepertype", rowIndex);
        this.setKeeperOwnerEnable(rowIndex, keeperType, "keeper");
    }

    @Override
    public void setKeeperEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("keepertype");
        this.setKeeperOwnerEnable(rowIndex, ownerType, "keeper");
    }

    @Override
    public void setOutKeeperEnable(int rowIndex) {
        String outKeeperType = (String)this.getValue("outkeepertype", rowIndex);
        this.setKeeperOwnerEnable(rowIndex, outKeeperType, "outkeeper");
    }

    @Override
    public void setOutKeeperEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("outkeepertype");
        this.setKeeperOwnerEnable(rowIndex, ownerType, "outkeeper");
    }
}

