/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.workbench;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;

public class PushServiceHelper {
    private static final Log log = LogFactory.getLog(PushServiceHelper.class);

    public static ConvertOperationResult push(DynamicObject botpRuleDym, DynamicObjectCollection taskDataColl) {
        PushArgs args = PushServiceHelper.buildTaskArgs(botpRuleDym, taskDataColl);
        return PushServiceHelper.push(args);
    }

    public static ConvertOperationResult push(DynamicObject botpRuleDym, List<Object> idList) {
        PushArgs args = PushServiceHelper.buildIdListArgs(botpRuleDym, idList);
        return PushServiceHelper.push(args);
    }

    public static List<DynamicObject> pushAndGetSuccessBill(DynamicObject botpRuleDym, PushArgs args) {
        ConvertOperationResult convertOperationResult;
        try {
            convertOperationResult = ConvertServiceHelper.push((PushArgs)args);
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        if (!convertOperationResult.isSuccess()) {
            StringBuilder reports = new StringBuilder();
            reports.append(convertOperationResult.getMessage());
            for (SourceBillReport billReport : convertOperationResult.getBillReports()) {
                reports.append(billReport);
            }
            throw new KDBizException(reports.toString());
        }
        return PushServiceHelper.getBOTPPushBill(botpRuleDym, convertOperationResult);
    }

    public static List<DynamicObject> getBOTPPushBill(DynamicObject botpRuleDym, ConvertOperationResult convertOperationResult) {
        String targetEntityNumber = PushServiceHelper.getTargetEntityType(botpRuleDym);
        MainEntityType targetEntityType = MetadataServiceHelper.getDataEntityType((String)targetEntityNumber);
        return convertOperationResult.loadTargetDataObjects(BusinessDataServiceHelper::loadRefence, targetEntityType);
    }

    public static ConvertOperationResult push(PushArgs args) {
        ConvertOperationResult convertOperationResult;
        try {
            convertOperationResult = ConvertServiceHelper.push((PushArgs)args);
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return convertOperationResult;
    }

    private static PushArgs buildTaskArgs(DynamicObject botpRuleDym, DynamicObjectCollection taskDataColl) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(PushServiceHelper.getSourceEntityType(botpRuleDym));
        pushArgs.setTargetEntityNumber(PushServiceHelper.getTargetEntityType(botpRuleDym));
        pushArgs.setRuleId(botpRuleDym.getString("id"));
        pushArgs.setSelectedRows(PushServiceHelper.buildTaskSelectedRows(taskDataColl));
        pushArgs.setHasRight(false);
        pushArgs.setBuildConvReport(true);
        return pushArgs;
    }

    private static PushArgs buildIdListArgs(DynamicObject botpRuleDym, List<Object> idList) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(PushServiceHelper.getSourceEntityType(botpRuleDym));
        pushArgs.setTargetEntityNumber(PushServiceHelper.getTargetEntityType(botpRuleDym));
        pushArgs.setRuleId(botpRuleDym.getString("id"));
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(idList.size());
        for (Object id : idList) {
            ListSelectedRow row = new ListSelectedRow(id, Boolean.TRUE);
            selectedRowList.add(row);
        }
        pushArgs.setSelectedRows(selectedRowList);
        pushArgs.setHasRight(false);
        pushArgs.setBuildConvReport(true);
        return pushArgs;
    }

    private static List<ListSelectedRow> buildTaskSelectedRows(DynamicObjectCollection taskDataColl) {
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(taskDataColl.size());
        for (DynamicObject taskData : taskDataColl) {
            long billId = taskData.getLong("srcid");
            long entryId = taskData.getLong("srcentryid");
            ListSelectedRow row = new ListSelectedRow((Object)billId, Boolean.TRUE);
            if (entryId > 0L) {
                String entryKey = taskData.getString("srcentrykey");
                row.setEntryEntityKey(entryKey);
                row.setEntryPrimaryKeyValue((Object)entryId);
            }
            selectedRowList.add(row);
        }
        return selectedRowList;
    }

    private static String getTargetEntityType(DynamicObject botpRuleDym) {
        return (String)botpRuleDym.getDynamicObject("targetentitynumber").getPkValue();
    }

    private static String getSourceEntityType(DynamicObject botpRuleDym) {
        return (String)botpRuleDym.getDynamicObject("sourceentitynumber").getPkValue();
    }
}

