/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.workbench;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AssistantProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.AssistantFlexEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.IAssistantDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.WarehouseHelper;

public class WorkbenchBeforeF7SelectHelper {
    public static void beforeF7Select(String key, BeforeF7SelectEvent beforeF7SelectEvent, IFormView view, String formId) {
        if (key.contains("auxpty")) {
            WorkbenchBeforeF7SelectHelper.auxPtyFilter(beforeF7SelectEvent, view);
            return;
        }
        IDataModel model = view.getModel();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (key) {
            case "billtype": {
                WorkbenchBeforeF7SelectHelper.billTypeFilter(beforeF7SelectEvent, formId);
                break;
            }
            case "biztype": {
                WorkbenchBeforeF7SelectHelper.bizTypeFilter(beforeF7SelectEvent, formId, view);
                break;
            }
            case "invscheme": {
                WorkbenchBeforeF7SelectHelper.invSchemeFilter(beforeF7SelectEvent, formId, view);
                break;
            }
            case "supplier": {
                WorkbenchBeforeF7SelectHelper.supplierFilter(beforeF7SelectEvent, view);
                break;
            }
            case "customer": {
                WorkbenchBeforeF7SelectHelper.customerFilter(beforeF7SelectEvent, view);
                break;
            }
            case "inorg": 
            case "outorg": {
                HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)UserServiceHelper.getCurrentUserId(), (boolean)false);
                boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
                if (hasAllOrgPerm) break;
                List hasPermOrgList = hasPermOrgResult.getHasPermOrgs();
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)hasPermOrgList));
                break;
            }
            case "materiel": {
                WorkbenchBeforeF7SelectHelper.setMaterielFilter(beforeF7SelectEvent, view, model);
                break;
            }
            case "unit": {
                WorkbenchBeforeF7SelectHelper.setUnitFilter(beforeF7SelectEvent, view);
                break;
            }
            case "outlocation": {
                WorkbenchBeforeF7SelectHelper.setOutLocationFilter(beforeF7SelectEvent, view);
                break;
            }
            case "outwarehouse": {
                WorkbenchBeforeF7SelectHelper.setOutWareHouseFilter(beforeF7SelectEvent, view);
                break;
            }
            case "inwarehouse": {
                WorkbenchBeforeF7SelectHelper.setInWareHouseFilter(beforeF7SelectEvent, view);
                break;
            }
            case "inlocation": {
                WorkbenchBeforeF7SelectHelper.setInLocationFilter(beforeF7SelectEvent, view);
                break;
            }
            case "outinvtype": {
                WorkbenchBeforeF7SelectHelper.beforeInvTypeOrStatus(beforeF7SelectEvent, view, "outinvtypeentry", "outinvtype");
                break;
            }
            case "outinvstatus": {
                WorkbenchBeforeF7SelectHelper.beforeInvTypeOrStatus(beforeF7SelectEvent, view, "outinvstatusentry", "outinvstatus");
                break;
            }
            case "outownertype": {
                WorkbenchBeforeF7SelectHelper.beforeInvTypeOrStatus(beforeF7SelectEvent, view, "outinvstatusentry", "outownertype");
                break;
            }
            case "outowner": {
                WorkbenchBeforeF7SelectHelper.setOutOwnerFilter(beforeF7SelectEvent, view);
                break;
            }
            case "outkeepertype": {
                WorkbenchBeforeF7SelectHelper.beforeInvTypeOrStatus(beforeF7SelectEvent, view, "outinvstatusentry", "outkeepertype");
                break;
            }
            case "ininvtype": {
                WorkbenchBeforeF7SelectHelper.beforeInvTypeOrStatus(beforeF7SelectEvent, view, "invtypeentry", "invtype");
                break;
            }
            case "ininvstatus": {
                WorkbenchBeforeF7SelectHelper.beforeInvTypeOrStatus(beforeF7SelectEvent, view, "invstatusentry", "invstatus");
                break;
            }
            case "inownertype": {
                WorkbenchBeforeF7SelectHelper.beforeInvTypeOrStatus(beforeF7SelectEvent, view, "invstatusentry", "ownertype");
                break;
            }
            case "inowner": {
                WorkbenchBeforeF7SelectHelper.setInOwnerFilter(beforeF7SelectEvent, view);
                break;
            }
            case "inkeepertype": {
                WorkbenchBeforeF7SelectHelper.beforeInvTypeOrStatus(beforeF7SelectEvent, view, "invstatusentry", "keepertype");
                break;
            }
            case "projectno": {
                WorkbenchBeforeF7SelectHelper.setProjectFilter(beforeF7SelectEvent, view);
                break;
            }
        }
    }

    private static void auxPtyFilter(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        DynamicObject materielOutOrg;
        IDataModel model = view.getModel();
        IDataEntityProperty property = model.getProperty("inorg");
        IDataEntityProperty outOrgProperty = model.getProperty("outorg");
        if (property == null && outOrgProperty == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u51fa\u5e93\u7ec4\u7ec7\u6216\u5165\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_10", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject materielInOrg = property == null ? null : (DynamicObject)model.getValue("inorg");
        DynamicObject dynamicObject = materielOutOrg = outOrgProperty == null ? null : (DynamicObject)model.getValue("outorg");
        if (materielInOrg == null && materielOutOrg == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u51fa\u5e93\u7ec4\u7ec7\u6216\u5165\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_10", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        ArrayList<Long> orgList = new ArrayList<Long>(2);
        if (materielInOrg != null) {
            orgList.add(materielInOrg.getLong("id"));
        }
        if (materielOutOrg != null) {
            orgList.add(materielOutOrg.getLong("id"));
        }
        WorkbenchBeforeF7SelectHelper.auxPtyOrgFilter(beforeF7SelectEvent, orgList);
    }

    public static void auxPtyOrgFilter(BeforeF7SelectEvent beforeF7SelectEvent, List<Long> orgList) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (beforeF7SelectEvent.getSource() instanceof AssistantFlexEdit) {
            AssistantProp assistantProp = (AssistantProp)((AssistantFlexEdit)beforeF7SelectEvent.getSource()).getProperty();
            String assistType = assistantProp.getAsstTypeId();
            DynamicObject group = BusinessDataServiceHelper.loadSingle((Object)assistType, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_assistantdatagroup"));
            long groupId = null == group ? 0L : (Long)group.getPkValue();
            IAssistantDataService assistantDataService = (IAssistantDataService)ServiceFactory.getService(IAssistantDataService.class);
            for (Long orgId : orgList) {
                QFilter qfilter = assistantDataService.getAssistantDataFilter(Long.valueOf(groupId), orgId);
                showParameter.getListFilterParameter().setFilter(qfilter);
            }
        } else {
            for (Long orgId : orgList) {
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)showParameter.getBillFormId(), (Long)orgId);
                showParameter.getListFilterParameter().setFilter(baseDataFilter);
            }
        }
    }

    private static void billTypeFilter(BeforeF7SelectEvent beforeF7SelectEvent, String formId) {
        QFilter qFilter = new QFilter("billformid.id", "=", (Object)formId);
        qFilter.and("enable", "=", (Object)"0");
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(new QFilter("billformid.id", "=", (Object)formId));
    }

    private static void setInLocationFilter(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        IDataModel model = view.getModel();
        IDataEntityProperty property = model.getProperty("inwarehouse");
        if (property == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5165\u5e93\u4ed3\u5e93\u3002", (String)"WorkbenchBeforeF7SelectHelper_7", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject inWareHouse = (DynamicObject)model.getValue("inwarehouse");
        if (inWareHouse == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5165\u5e93\u4ed3\u5e93\u3002", (String)"WorkbenchBeforeF7SelectHelper_7", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        QFilter inWareHouseFilter = WarehouseHelper.buildLocationQFilter(inWareHouse);
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(inWareHouseFilter);
    }

    private static void setOutLocationFilter(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        IDataModel model = view.getModel();
        IDataEntityProperty property = model.getProperty("outwarehouse");
        if (property == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u51fa\u5e93\u4ed3\u5e93\u3002", (String)"WorkbenchBeforeF7SelectHelper_5", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject outWareHouse = (DynamicObject)model.getValue("outwarehouse");
        if (outWareHouse == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u51fa\u5e93\u4ed3\u5e93\u3002", (String)"WorkbenchBeforeF7SelectHelper_5", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        QFilter outWareHouseFilter = WarehouseHelper.buildLocationQFilter(outWareHouse);
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(outWareHouseFilter);
    }

    private static void customerFilter(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        IDataModel model = view.getModel();
        IDataEntityProperty property = model.getProperty("outorg");
        if (property == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u51fa\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_3", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject outOrg = (DynamicObject)model.getValue("outorg");
        if (outOrg == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u51fa\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_3", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        QFilter outBaseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)outOrg.getLong("id"));
        outBaseDataFilter.and("enable", "=", (Object)kd.scmc.im.enums.EnableStatusEnum.ENABLE.getValue());
        outBaseDataFilter.and("status", "=", (Object)"C");
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(outBaseDataFilter);
    }

    private static void supplierFilter(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        IDataModel model = view.getModel();
        IDataEntityProperty property = model.getProperty("inorg");
        if (property == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5165\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_2", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject inOrg = (DynamicObject)model.getValue("inorg");
        if (inOrg == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5165\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_2", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        QFilter inBaseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)inOrg.getLong("id"));
        inBaseDataFilter.and("enable", "=", (Object)kd.scmc.im.enums.EnableStatusEnum.ENABLE.getValue());
        inBaseDataFilter.and("status", "=", (Object)"C");
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(inBaseDataFilter);
    }

    private static void bizTypeFilter(BeforeF7SelectEvent beforeF7SelectEvent, String formId, IFormView view) {
        IDataModel model = view.getModel();
        IDataEntityProperty property = model.getProperty("billtype");
        if (property == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5355\u636e\u7c7b\u578b\u3002", (String)"WorkbenchBeforeF7SelectHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject billType = (DynamicObject)view.getModel().getValue("billtype");
        if (billType == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5355\u636e\u7c7b\u578b\u3002", (String)"WorkbenchBeforeF7SelectHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        List<Object> bizTypeIds = BizTypeHelper.getBizTypeIds(billType.getPkValue(), formId);
        Object[] objects = new Object[]{1037687972641726464L, 1037688326724870144L};
        if ("im_otherinbill".equals(formId) && bizTypeIds.contains(objects[0])) {
            bizTypeIds.remove(objects[0]);
        } else if ("im_otheroutbill".equals(formId) && bizTypeIds.contains(objects[1])) {
            bizTypeIds.remove(objects[1]);
        }
        if (bizTypeIds != null) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", bizTypeIds));
        }
    }

    private static void invSchemeFilter(BeforeF7SelectEvent beforeF7SelectEvent, String formId, IFormView view) {
        IDataModel model = view.getModel();
        IDataEntityProperty property = model.getProperty("biztype");
        if (property == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u4fe1\u606f\u3002", (String)"WorkbenchBeforeF7SelectHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject bizType = (DynamicObject)model.getValue("biztype");
        if (bizType == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u4fe1\u606f\u3002", (String)"WorkbenchBeforeF7SelectHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("billform", "=", (Object)formId);
        qFilter.and("bitypeentry.biztype", "=", bizType.getPkValue());
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        qFilter.and("bitypeentry.allowmanualadd", "=", (Object)"1");
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private static void setMaterielFilter(BeforeF7SelectEvent evt, IFormView view, IDataModel model) {
        QFilter materielBaseDataFilter;
        DynamicObject materielOutOrg;
        IDataEntityProperty property = model.getProperty("inorg");
        IDataEntityProperty outOrgProperty = model.getProperty("outorg");
        if (property == null && outOrgProperty == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u51fa\u5e93\u7ec4\u7ec7\u6216\u5165\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_10", (String)"scmc-im-business", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject materielInOrg = property == null ? null : (DynamicObject)model.getValue("inorg");
        DynamicObject dynamicObject = materielOutOrg = outOrgProperty == null ? null : (DynamicObject)model.getValue("outorg");
        if (materielInOrg == null && materielOutOrg == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u51fa\u5e93\u7ec4\u7ec7\u6216\u5165\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_10", (String)"scmc-im-business", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        QFilter materielFilter = new QFilter("masterid.status", "=", (Object)"C");
        materielFilter.and("masterid.enable", "=", (Object)"1");
        if (materielInOrg != null) {
            materielBaseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)materielInOrg.getLong("id"));
            materielFilter.and(materielBaseDataFilter);
        }
        if (materielOutOrg != null) {
            materielBaseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)materielOutOrg.getLong("id"));
            materielFilter.and(materielBaseDataFilter);
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(materielFilter);
    }

    private static void setProjectFilter(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        DynamicObject outOrg;
        IDataModel model = view.getModel();
        IDataEntityProperty property = model.getProperty("inorg");
        IDataEntityProperty outOrgProperty = model.getProperty("outorg");
        if (property == null && outOrgProperty == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u51fa\u5e93\u7ec4\u7ec7\u6216\u5165\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_10", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject inOrg = property == null ? null : (DynamicObject)model.getValue("inorg");
        DynamicObject dynamicObject = outOrg = outOrgProperty == null ? null : (DynamicObject)model.getValue("outorg");
        if (inOrg == null && outOrg == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u51fa\u5e93\u7ec4\u7ec7\u6216\u5165\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_10", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        QFilter projectBaseDataFilter = null;
        if (inOrg != null) {
            projectBaseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_project", (Long)inOrg.getLong("id"));
        }
        if (outOrg != null) {
            projectBaseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_project", (Long)outOrg.getLong("id"));
        }
        QFilter projectFilter = new QFilter("status", "=", (Object)"C");
        projectFilter.and("enable", "=", (Object)"1");
        projectFilter.and(projectBaseDataFilter);
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(projectFilter);
    }

    private static void setOutWareHouseFilter(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        DynamicObject inOrg;
        IDataModel model = view.getModel();
        IDataEntityProperty outOrgProperty = model.getProperty("outorg");
        IDataEntityProperty inOrgProperty = model.getProperty("inorg");
        if (outOrgProperty == null && inOrgProperty == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5165\u5e93\u7ec4\u7ec7\u6216\u8005\u51fa\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_6", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject outOrg = outOrgProperty == null ? null : (DynamicObject)model.getValue("outorg");
        DynamicObject dynamicObject = inOrg = inOrgProperty == null ? null : (DynamicObject)model.getValue("inorg");
        if (inOrg == null && outOrg == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5165\u5e93\u7ec4\u7ec7\u6216\u8005\u51fa\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_6", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        ArrayList<Object> orgIdList = new ArrayList<Object>(2);
        if (outOrg == null && inOrg != null) {
            orgIdList.add(inOrg.getPkValue());
        }
        if (outOrg != null && inOrg == null) {
            orgIdList.add(outOrg.getPkValue());
        }
        if (outOrg != null && inOrg != null) {
            orgIdList.add(outOrg.getPkValue());
        }
        List<Long> allWarehouse = WarehouseHelper.getAllWarehouse(orgIdList);
        QFilter qFilter = new QFilter("id", "in", allWarehouse);
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private static void setInWareHouseFilter(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        DynamicObject inOrg;
        IDataModel model = view.getModel();
        IDataEntityProperty outOrgProperty = model.getProperty("outorg");
        IDataEntityProperty inOrgProperty = model.getProperty("inorg");
        if (outOrgProperty == null && inOrgProperty == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5165\u5e93\u7ec4\u7ec7\u6216\u8005\u51fa\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_6", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject outOrg = outOrgProperty == null ? null : (DynamicObject)model.getValue("outorg");
        DynamicObject dynamicObject = inOrg = inOrgProperty == null ? null : (DynamicObject)model.getValue("inorg");
        if (inOrg == null && outOrg == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5165\u5e93\u7ec4\u7ec7\u6216\u8005\u51fa\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_6", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        ArrayList<Object> orgIdList = new ArrayList<Object>(2);
        if (outOrg == null && inOrg != null) {
            orgIdList.add(inOrg.getPkValue());
        }
        if (outOrg != null && inOrg == null) {
            orgIdList.add(outOrg.getPkValue());
        }
        if (outOrg != null && inOrg != null) {
            orgIdList.add(inOrg.getPkValue());
        }
        List<Long> allWarehouse = WarehouseHelper.getAllWarehouse(orgIdList);
        QFilter qFilter = new QFilter("id", "in", allWarehouse);
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private static void setInOwnerFilter(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        DynamicObject inOrg;
        IDataModel model = view.getModel();
        IDataEntityProperty property = model.getProperty("inownertype");
        if (property == null) {
            return;
        }
        String inOwnerType = (String)model.getValue("inownertype");
        if (!"bos_org".equals(inOwnerType)) {
            return;
        }
        IDataEntityProperty outOrgProperty = model.getProperty("outorg");
        IDataEntityProperty inOrgProperty = model.getProperty("inorg");
        if (outOrgProperty == null && inOrgProperty == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5165\u5e93\u7ec4\u7ec7\u6216\u8005\u51fa\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_6", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject outOrg = outOrgProperty == null ? null : (DynamicObject)model.getValue("outorg");
        DynamicObject dynamicObject = inOrg = inOrgProperty == null ? null : (DynamicObject)model.getValue("inorg");
        if (inOrg == null && outOrg == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5165\u5e93\u7ec4\u7ec7\u6216\u8005\u51fa\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_6", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        Object orgId = null;
        if (outOrg == null && inOrg != null) {
            orgId = inOrg.getPkValue();
        }
        if (outOrg != null && inOrg == null) {
            orgId = outOrg.getPkValue();
        }
        if (outOrg != null && inOrg != null) {
            orgId = inOrg.getPkValue();
        }
        List<Long> ownerList = WorkbenchBeforeF7SelectHelper.getOwnerList((Long)orgId, view);
        QFilter filter = new QFilter("id", "in", ownerList);
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.setCustomParam("orgFuncId", (Object)"10");
        showParameter.getListFilterParameter().setFilter(filter);
    }

    private static void setOutOwnerFilter(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        DynamicObject inOrg;
        IDataModel model = view.getModel();
        IDataEntityProperty property = model.getProperty("outownertype");
        if (property == null) {
            return;
        }
        String outOwnerType = (String)model.getValue("outownertype");
        if (!"bos_org".equals(outOwnerType)) {
            return;
        }
        IDataEntityProperty outOrgProperty = model.getProperty("outorg");
        IDataEntityProperty inOrgProperty = model.getProperty("inorg");
        if (outOrgProperty == null && inOrgProperty == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5165\u5e93\u7ec4\u7ec7\u6216\u8005\u51fa\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_6", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject outOrg = outOrgProperty == null ? null : (DynamicObject)model.getValue("outorg");
        DynamicObject dynamicObject = inOrg = inOrgProperty == null ? null : (DynamicObject)model.getValue("inorg");
        if (inOrg == null && outOrg == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5165\u5e93\u7ec4\u7ec7\u6216\u8005\u51fa\u5e93\u7ec4\u7ec7\u3002", (String)"WorkbenchBeforeF7SelectHelper_6", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        Object orgId = null;
        if (outOrg == null && inOrg != null) {
            orgId = inOrg.getPkValue();
        }
        if (outOrg != null && inOrg == null) {
            orgId = outOrg.getPkValue();
        }
        if (outOrg != null && inOrg != null) {
            orgId = outOrg.getPkValue();
        }
        List<Long> ownerList = WorkbenchBeforeF7SelectHelper.getOwnerList((Long)orgId, view);
        QFilter filter = new QFilter("id", "in", ownerList);
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.setCustomParam("orgFuncId", (Object)"10");
        showParameter.getListFilterParameter().setFilter(filter);
    }

    private static DynamicObject getInvScheme(IDataModel model) {
        DynamicObject scheme = null;
        try {
            scheme = (DynamicObject)model.getValue("invscheme");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DynamicObject invScheme = null;
        if (scheme != null && scheme.getPkValue() != null) {
            invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)scheme.getPkValue(), (String)"im_invscheme");
        }
        return invScheme;
    }

    private static void beforeInvTypeOrStatus(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view, String entry, String entryField) {
        IDataModel model = view.getModel();
        DynamicObject invScheme = WorkbenchBeforeF7SelectHelper.getInvScheme(model);
        if (null == invScheme) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5e93\u5b58\u4e8b\u52a1\u3002", (String)"WorkbenchBeforeF7SelectHelper_8", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObjectCollection entries = invScheme.getDynamicObjectCollection(entry);
        HashSet invTypeOrStatusIds = new HashSet();
        if (entries != null) {
            entries.forEach(c -> invTypeOrStatusIds.add(c.getDynamicObject(entryField).get("id")));
        }
        QFilter f = new QFilter("id", "in", invTypeOrStatusIds);
        f.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        formShowParameter.getListFilterParameter().setFilter(f);
    }

    private static List<Long> getOwnerList(Long invOrgId, IFormView view) {
        boolean isAccoutOrg = OrgUnitServiceHelper.checkOrgFunction((Long)invOrgId, (String)"10");
        Map<String, Object> delegation = WorkbenchBeforeF7SelectHelper.getDelegationOrgList(invOrgId);
        List orgIds = (List)delegation.get("orgId");
        if (orgIds != null && !orgIds.isEmpty()) {
            if (isAccoutOrg) {
                orgIds.add(invOrgId);
            }
            return orgIds;
        }
        Set<Object> ownerSet = WorkbenchBeforeF7SelectHelper.getOwnerListByCache(invOrgId, view);
        ArrayList<Long> owners = new ArrayList<Long>(16);
        for (Object o : ownerSet) {
            owners.add(Long.valueOf(o.toString()));
        }
        return owners;
    }

    private static Map<String, Object> getDelegationOrgList(Long orgId) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setFromViewType("10");
        param.setToViewType("05");
        param.setDirectViewType("fromorg");
        return OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
    }

    protected static Set<Object> getOwnerListByCache(Long orgId, IFormView view) {
        Set<Object> ownerSet = new HashSet<Object>(16);
        if (orgId != null && orgId != 0L) {
            String cacheKey = "ownercache_" + orgId;
            IPageCache pageCache = view.getPageCache();
            String ownerArrayStr = pageCache.get(cacheKey);
            if (ownerArrayStr == null) {
                ownerSet = WorkbenchBeforeF7SelectHelper.queryOwnerList(orgId);
                ownerArrayStr = ownerSet.stream().map(p -> p.toString()).collect(Collectors.joining(","));
                pageCache.put(cacheKey, ownerArrayStr);
            } else {
                String[] ownerArray;
                for (String owner : ownerArray = ownerArrayStr.split(",")) {
                    ownerSet.add(Long.valueOf(owner));
                }
            }
        }
        return ownerSet;
    }

    private static Set<Object> queryOwnerList(Long orgId) {
        ArrayList<Object> ownerArray = OwnerHelper.getOwners(orgId);
        HashSet<Object> ownerOrgIdList = new HashSet<Object>(ownerArray);
        Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        Object settleOrgId = null;
        if (companyByOrg != null && (settleOrgId = (Object)companyByOrg.get("id")) != null && StringUtils.isNotEmpty((CharSequence)settleOrgId.toString())) {
            ownerOrgIdList.add(settleOrgId);
        }
        return ownerOrgIdList;
    }

    private static void setUnitFilter(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        IDataModel model = view.getModel();
        IDataEntityProperty property = model.getProperty("materiel");
        if (property == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u7f16\u7801\u3002", (String)"WorkbenchBeforeF7SelectHelper_4", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject materialInvInfo = (DynamicObject)model.getValue("materiel");
        if (materialInvInfo == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u7f16\u7801\u3002", (String)"WorkbenchBeforeF7SelectHelper_4", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        IDataEntityProperty baseUnitProperty = model.getProperty("baseunit");
        if (baseUnitProperty == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u57fa\u672c\u5355\u4f4d\u3002", (String)"WorkbenchBeforeF7SelectHelper_9", (String)"scmc-im-business", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        long masterMaterialId = materialInvInfo.getLong("masterid.id");
        DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit");
        Long srcmuId = baseUnit == null ? Long.valueOf(0L) : (Long)baseUnit.getPkValue();
        List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1", (Boolean)Boolean.TRUE);
        QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }
}

