/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.workbench;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.QueryEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.model.CheckDimObjParam;
import kd.bos.service.ServiceFactory;

public class WorkbenchPermissionHelper {
    private static final Log logger = LogFactory.getLog(WorkbenchPermissionHelper.class);

    public static boolean checkPermission(MainEntityType mainEntityType, Set<Object> pkIds, String permissionItemId) {
        PermissionControlType permissionControlType = mainEntityType.getPermissionControlType();
        String dimType = permissionControlType.getDimension();
        String dimFldKey = permissionControlType.getDataDimensionField();
        String dimAssitFldKey = permissionControlType.getDataAssistDimensionField();
        String realEntityId = mainEntityType.getName();
        String appId = mainEntityType.getAppId();
        if (StringUtils.isNotBlank((CharSequence)dimFldKey) && mainEntityType.findProperty(dimFldKey) == null) {
            dimFldKey = null;
        }
        if (StringUtils.isNotBlank((CharSequence)dimAssitFldKey) && mainEntityType.findProperty(dimAssitFldKey) == null) {
            dimAssitFldKey = null;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)dimType, (CharSequence)"DIM_ORG") || StringUtils.isBlank((CharSequence)dimFldKey)) {
            dimType = "DIM_ORG";
            if (StringUtils.isNotBlank((CharSequence)mainEntityType.getMainOrg())) {
                dimFldKey = mainEntityType.getMainOrg();
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)dimType, (CharSequence)"DIM_NULL") || StringUtils.isBlank((CharSequence)dimFldKey)) {
            return WorkbenchPermissionHelper.doPermission(realEntityId, appId, permissionItemId, 0L, null);
        }
        QFilter[] filters = new QFilter[]{pkIds.size() == 1 ? new QFilter("id", "=", pkIds.iterator().next()) : new QFilter("id", "in", (Object)pkIds.toArray())};
        String entityName = mainEntityType.getName();
        String selectFields = "id";
        if (StringUtils.isNotBlank((CharSequence)dimFldKey)) {
            selectFields = selectFields + "," + dimFldKey;
        }
        if (dimAssitFldKey != null && StringUtils.isNotBlank((CharSequence)dimAssitFldKey) && !dimAssitFldKey.equals(dimFldKey)) {
            selectFields = selectFields + "," + dimAssitFldKey;
        }
        String orderBys = null;
        ORM orm = ORM.create();
        ArrayList<CheckDimObjParam> dimObjParamList = new ArrayList<CheckDimObjParam>();
        try (DataSet ds = orm.queryDataSet(entityName, entityName, selectFields, filters, orderBys);){
            DynamicObjectCollection objs = orm.toPlainDynamicObjectCollection(ds);
            for (DynamicObject obj : objs) {
                CheckDimObjParam dimObjParam = new CheckDimObjParam();
                if (StringUtils.isNotBlank((CharSequence)dimFldKey)) {
                    dimObjParam.setDimensionOrg(obj.getLong(dimFldKey));
                    dimObjParam.setId(obj.get("id"));
                }
                if (dimAssitFldKey != null && StringUtils.isNotBlank((CharSequence)dimAssitFldKey) && !dimAssitFldKey.equals(dimFldKey)) {
                    dimObjParam.setAssistDimensionOrg(obj.getLong(dimAssitFldKey));
                }
                if (dimObjParam.getDimensionOrg() == null) continue;
                dimObjParamList.add(dimObjParam);
            }
        }
        if (!dimObjParamList.isEmpty()) {
            return WorkbenchPermissionHelper.doPermissionBatch(permissionItemId, dimObjParamList, mainEntityType);
        }
        return WorkbenchPermissionHelper.doPermission(realEntityId, appId, permissionItemId, 0L, dimType);
    }

    public static boolean doPermissionBatch(String permissionItemId, List<CheckDimObjParam> dimObjParamList, MainEntityType mainEntityType) {
        ArrayList<CheckDimObjParam> tempDimObjParamList = new ArrayList<CheckDimObjParam>(dimObjParamList);
        long userId = RequestContext.get().getCurrUserId();
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        String appId = mainEntityType.getAppId();
        List checkList = permissionService.checkPermissionBatch(Long.valueOf(userId), appId, mainEntityType.getName(), permissionItemId, dimObjParamList);
        if (mainEntityType instanceof QueryEntityType) {
            HashSet<Object> pkIds = new HashSet<Object>(8);
            for (CheckDimObjParam tempParam : tempDimObjParamList) {
                Object pkId = tempParam.getId();
                pkIds.add(pkId);
            }
            if (checkList != null) {
                int checkListCount = checkList.size();
                if (checkListCount == 0) {
                    return true;
                }
                tempDimObjParamList.removeAll(checkList);
                for (CheckDimObjParam tempParam : tempDimObjParamList) {
                    Object pkId = tempParam.getId();
                    pkIds.remove(pkId);
                }
            }
            if (!pkIds.isEmpty()) {
                return false;
            }
        } else if (checkList == null || !checkList.isEmpty()) {
            return false;
        }
        return true;
    }

    public static boolean doPermission(String realEntityId, String bizAppId, String permissionItemId, long dimId, String dimType) {
        long userId = RequestContext.get().getCurrUserId();
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        String dimensionType = "";
        dimensionType = StringUtils.isEmpty((CharSequence)dimType) ? (Objects.equals(0L, dimId) ? "DIM_NULL" : "DIM_ORG") : dimType;
        return permissionService.checkPermission(userId, dimensionType, dimId, bizAppId, realEntityId, permissionItemId) == 1;
    }
}

