/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.workbench;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.IFormPlugin;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.im.business.helper.InvSchemeHelper;
import kd.scmc.im.business.helper.MaterialHelper;
import kd.scmc.im.business.workbench.InterfaceCfgField;
import kd.scmc.im.business.workbench.WorkbenchAuxQtyAndUnitHelper;
import kd.scmc.im.business.workbench.WorkbenchFieldsConditionShowAndLockHelper;
import kd.scmc.im.business.workbench.WorkbenchServiceHelper;
import kd.scmc.im.business.workbench.WorkbenchUnitAndQtytHelper;
import kd.scmc.im.helper.ShelfLifeDateUtil;

public class WorkbenchPropertyChangeHelper {
    public static void propertyChange(String propName, Object newValue, Object oldValue, int rowIndex, boolean formBOTP, IFormView view, IFormPlugin plugin) {
        switch (propName) {
            case "billtype": {
                WorkbenchServiceHelper.setNullValue("biztype", rowIndex, view);
                break;
            }
            case "biztype": {
                WorkbenchServiceHelper.setNullValue("invscheme", rowIndex, view);
                break;
            }
            case "inorg": {
                WorkbenchPropertyChangeHelper.clearMaterielAndProjectNo(rowIndex, view);
                WorkbenchServiceHelper.setNullValue("inwarehouse", rowIndex, view);
                WorkbenchServiceHelper.setNullValue("inlocation", rowIndex, view);
                WorkbenchServiceHelper.setNullValue("inowner", rowIndex, view);
                WorkbenchServiceHelper.setNullValue("inkeeper", rowIndex, view);
                WorkbenchPropertyChangeHelper.setDefaultKeeper("inkeepertype", "inkeeper", rowIndex, newValue, view);
                break;
            }
            case "outorg": {
                WorkbenchPropertyChangeHelper.clearMaterielAndProjectNo(rowIndex, view);
                WorkbenchServiceHelper.setNullValue("outwarehouse", rowIndex, view);
                WorkbenchServiceHelper.setNullValue("outlocation", rowIndex, view);
                WorkbenchServiceHelper.setNullValue("outowner", rowIndex, view);
                WorkbenchServiceHelper.setNullValue("outkeeper", rowIndex, view);
                WorkbenchPropertyChangeHelper.setDefaultKeeper("outkeepertype", "outkeeper", rowIndex, newValue, view);
                break;
            }
            case "invscheme": {
                WorkbenchPropertyChangeHelper.invSchemeChange(rowIndex, newValue, view);
                break;
            }
            case "outwarehouse": {
                WorkbenchPropertyChangeHelper.changeWareHouse("outlocation", formBOTP, view, rowIndex);
                break;
            }
            case "outkeepertype": {
                WorkbenchPropertyChangeHelper.changeOutKeeperType((String)newValue, rowIndex, view);
                break;
            }
            case "inwarehouse": {
                WorkbenchPropertyChangeHelper.changeWareHouse("inlocation", formBOTP, view, rowIndex);
                break;
            }
            case "inkeepertype": {
                WorkbenchPropertyChangeHelper.changeInKeeperType((String)newValue, rowIndex, view);
                break;
            }
            case "bizdate": {
                WorkbenchServiceHelper.setValue("bookdate", newValue, rowIndex, view);
                break;
            }
            case "materiel": {
                WorkbenchPropertyChangeHelper.changeMateriel(newValue, rowIndex, view);
                break;
            }
            case "baseqty": 
            case "qty2nd": 
            case "unit": 
            case "qty": {
                WorkbenchPropertyChangeHelper.changeQtyOrUnit(propName, newValue, oldValue, rowIndex, view);
                break;
            }
            case "producedate": {
                WorkbenchPropertyChangeHelper.changeProduceDate(oldValue, (Date)newValue, rowIndex, view, plugin);
                break;
            }
            case "expiredate": {
                WorkbenchPropertyChangeHelper.changeExpiryDate(oldValue, (Date)newValue, rowIndex, view, plugin);
                break;
            }
        }
    }

    private static void setDefaultKeeper(String keeperTypeKey, String keeperKey, int rowIndex, Object newValue, IFormView view) {
        String outKeeperType = (String)WorkbenchServiceHelper.getValue(keeperTypeKey, rowIndex, view);
        if ("bos_org".equals(outKeeperType)) {
            WorkbenchServiceHelper.setValue(keeperKey, newValue, rowIndex, view);
        }
    }

    private static void changeMateriel(Object newValue, int rowIndex, IFormView view) {
        WorkbenchServiceHelper.setNullValue("materielname", rowIndex, view);
        WorkbenchServiceHelper.setNullValue("baseunit", rowIndex, view);
        WorkbenchServiceHelper.setNullValue("unit2nd", rowIndex, view);
        if (Objects.nonNull(newValue)) {
            DynamicObject materielInfo = (DynamicObject)newValue;
            DynamicObject materiel = materielInfo.getDynamicObject("masterid");
            String name = materiel.getString("name");
            WorkbenchServiceHelper.setValue("materielname", name, rowIndex, view);
            DynamicObject baseUnit = materiel.getDynamicObject("baseunit");
            DynamicObject auxPtyUnit = materiel.getDynamicObject("auxptyunit");
            WorkbenchServiceHelper.setValue("baseunit", (Object)baseUnit, rowIndex, view);
            WorkbenchServiceHelper.setValue("unit2nd", (Object)auxPtyUnit, rowIndex, view);
        }
        WorkbenchServiceHelper.setNullValue("auxpty", rowIndex, view);
        WorkbenchServiceHelper.setNullValue("lotnumber", rowIndex, view);
        WorkbenchServiceHelper.setNullValue("producedate", rowIndex, view);
        WorkbenchServiceHelper.setNullValue("expiredate", rowIndex, view);
        WorkbenchServiceHelper.setNullValue("unit", rowIndex, view);
        WorkbenchServiceHelper.setNullValue("qty", rowIndex, view);
        WorkbenchServiceHelper.setNullValue("baseqty", rowIndex, view);
        WorkbenchServiceHelper.setNullValue("qty2nd", rowIndex, view);
    }

    private static void changeWareHouse(String fLocation, boolean formBOTP, IFormView view, int rowIndex) {
        IDataModel model = view.getModel();
        MainEntityType dataEntityType = model.getDataEntityType();
        Map allFields = dataEntityType.getAllFields();
        boolean containsKey = allFields.containsKey(fLocation);
        if (!containsKey) {
            return;
        }
        WorkbenchServiceHelper.setNullValue(fLocation, rowIndex, view);
        List<InterfaceCfgField> fieldsMappingList = WorkbenchServiceHelper.getFieldsMappingList(view);
        DynamicObject data = rowIndex == -1 ? model.getDataEntity() : model.getEntryRowEntity("entryentity", rowIndex);
        WorkbenchFieldsConditionShowAndLockHelper.setEnable(data, formBOTP, fLocation, rowIndex, fieldsMappingList, view);
    }

    private static void clearMaterielAndProjectNo(int rowIndex, IFormView view) {
        WorkbenchServiceHelper.setNullValue("materiel", rowIndex, view);
        WorkbenchServiceHelper.setNullValue("materielname", rowIndex, view);
        WorkbenchServiceHelper.setNullValue("projectno", rowIndex, view);
    }

    private static void invSchemeChange(int rowIndex, Object invSchemeObj, IFormView view) {
        WorkbenchServiceHelper.setNullValue("inkeeper", rowIndex, view);
        WorkbenchServiceHelper.setNullValue("inowner", rowIndex, view);
        WorkbenchServiceHelper.setNullValue("outkeeper", rowIndex, view);
        WorkbenchServiceHelper.setNullValue("outowner", rowIndex, view);
        if (Objects.isNull(invSchemeObj)) {
            WorkbenchServiceHelper.setNullValue("outinvtype", rowIndex, view);
            WorkbenchServiceHelper.setNullValue("outinvstatus", rowIndex, view);
            WorkbenchServiceHelper.setNullValue("outownertype", rowIndex, view);
            WorkbenchServiceHelper.setNullValue("outkeepertype", rowIndex, view);
            WorkbenchServiceHelper.setNullValue("ininvtype", rowIndex, view);
            WorkbenchServiceHelper.setNullValue("ininvstatus", rowIndex, view);
            WorkbenchServiceHelper.setNullValue("inownertype", rowIndex, view);
            WorkbenchServiceHelper.setNullValue("inkeepertype", rowIndex, view);
            return;
        }
        DynamicObject invScheme = (DynamicObject)invSchemeObj;
        WorkbenchServiceHelper.setValue("outinvtype", (Object)InvSchemeHelper.getDefaltOutInvtype(invScheme), rowIndex, view);
        WorkbenchServiceHelper.setValue("outinvstatus", (Object)InvSchemeHelper.getDefaultOutInvStatus(invScheme), rowIndex, view);
        WorkbenchServiceHelper.setValue("outownertype", InvSchemeHelper.getDefaultOutOwnerType(invScheme), rowIndex, view);
        WorkbenchServiceHelper.setValue("outkeepertype", InvSchemeHelper.getDefaultOutKeeperType(invScheme), rowIndex, view);
        WorkbenchServiceHelper.setValue("ininvtype", (Object)InvSchemeHelper.getDefaltInvtype(invScheme), rowIndex, view);
        WorkbenchServiceHelper.setValue("ininvstatus", (Object)InvSchemeHelper.getDefaultInvStatus(invScheme), rowIndex, view);
        WorkbenchServiceHelper.setValue("inownertype", InvSchemeHelper.getDefaultOwnerType(invScheme), rowIndex, view);
        WorkbenchServiceHelper.setValue("inkeepertype", InvSchemeHelper.getDefaultKeeperType(invScheme), rowIndex, view);
    }

    private static void changeQtyOrUnit(String propName, Object newValue, Object oldValue, int rowIndex, IFormView view) {
        DynamicObject materialInvInfo;
        if ("unit".equals(propName)) {
            view.setEnable(Boolean.valueOf(newValue != null), rowIndex, new String[]{"qty"});
        }
        if (StringUtils.isBlank((Object)(materialInvInfo = (DynamicObject)WorkbenchServiceHelper.getValue("materiel", rowIndex, view)))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u3002", (String)"WorkbenchPropertyChangeHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
            return;
        }
        WorkbenchUnitAndQtytHelper.setBizQtyAndUnit(view, rowIndex, propName, newValue, oldValue);
        WorkbenchAuxQtyAndUnitHelper.setAuxBizQtyAndUnit(view, rowIndex, propName);
        WorkbenchServiceHelper.updateView("qty", rowIndex, view);
        WorkbenchServiceHelper.updateView("baseqty", rowIndex, view);
        WorkbenchServiceHelper.updateView("qty2nd", rowIndex, view);
    }

    private static void changeProduceDate(Object oldValue, Date date, int rowIndex, IFormView view, IFormPlugin plugin) {
        String calculationForEndDate;
        int shelflife;
        if (date == null) {
            return;
        }
        DynamicObject materialInvInfo = (DynamicObject)WorkbenchServiceHelper.getValue("materiel", rowIndex, view);
        if (materialInvInfo == null || !materialInvInfo.getBoolean("enableshelflifemgr")) {
            return;
        }
        if (!MaterialHelper.isCalShelflife(materialInvInfo, true)) {
            Date oldExpirydate = (Date)WorkbenchServiceHelper.getValue("expiredate", rowIndex, view);
            WorkbenchPropertyChangeHelper.checkShelflifeDate(date, oldExpirydate, rowIndex, "producedate", materialInvInfo, view);
            return;
        }
        String shelflifeUnit = materialInvInfo.getString("shelflifeunit");
        Date expirydate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(shelflife = materialInvInfo.getInt("shelflife")), (Date)date, (String)(calculationForEndDate = materialInvInfo.getString("calculationforenddate")));
        if (expirydate.before(date)) {
            String newExpirydateStr = WorkbenchPropertyChangeHelper.getDateStr(expirydate);
            String newProduceDateStr = WorkbenchPropertyChangeHelper.getDateStr(date);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u5230\u671f\u65e5\u671f\u6216\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u7684\u201c\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u201d\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"WorkbenchPropertyChangeHelper_1", (String)"scmc-im-business", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            view.showErrorNotification(msg);
            WorkbenchServiceHelper.setValueNoChange("producedate", null, rowIndex, view);
            return;
        }
        Date oldExpirydate = (Date)WorkbenchServiceHelper.getValue("expiredate", rowIndex, view);
        WorkbenchPropertyChangeHelper.showExpiryDateConfirm(rowIndex, materialInvInfo, oldExpirydate, expirydate, (Date)oldValue, date, view, plugin);
    }

    private static void changeExpiryDate(Object oldValue, Date date, int rowIndex, IFormView view, IFormPlugin plugin) {
        if (date == null) {
            return;
        }
        Date oldProducedate = (Date)WorkbenchServiceHelper.getValue("producedate", rowIndex, view);
        DynamicObject materialInvInfo = (DynamicObject)WorkbenchServiceHelper.getValue("materiel", rowIndex, view);
        if (materialInvInfo == null || !materialInvInfo.getBoolean("enableshelflifemgr")) {
            return;
        }
        if (!MaterialHelper.isCalShelflife(materialInvInfo, false)) {
            WorkbenchPropertyChangeHelper.checkShelflifeDate(oldProducedate, date, rowIndex, "expiredate", materialInvInfo, view);
            WorkbenchPropertyChangeHelper.showExpiryDateConfirm(rowIndex, materialInvInfo, (Date)oldValue, date, oldProducedate, oldProducedate, view, plugin);
            return;
        }
        String shelflifeUnit = materialInvInfo.getString("shelflifeunit");
        int shelflife = materialInvInfo.getInt("shelflife");
        String calculationForEndDate = materialInvInfo.getString("calculationforenddate");
        Date producedate = oldProducedate;
        if (!"2".equals(calculationForEndDate)) {
            producedate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(shelflife * -1), (Date)date, (String)calculationForEndDate);
        } else if (producedate != null && date.before(producedate)) {
            Date oldExpirydate = (Date)oldValue;
            if (oldExpirydate != null && oldExpirydate.before(producedate)) {
                oldExpirydate = null;
            }
            String newExpirydateStr = WorkbenchPropertyChangeHelper.getDateStr(date);
            String newProduceDateStr = WorkbenchPropertyChangeHelper.getDateStr(producedate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u3002\u8bf7\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4fdd\u8d28\u671f\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u548c\u4fdd\u8d28\u671f\u8bbe\u7f6e\u3002", (String)"WorkbenchPropertyChangeHelper_2", (String)"scmc-im-business", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            view.showErrorNotification(msg);
            WorkbenchServiceHelper.setValueNoChange("expiredate", oldExpirydate, rowIndex, view);
            return;
        }
        WorkbenchPropertyChangeHelper.showExpiryDateConfirm(rowIndex, materialInvInfo, (Date)oldValue, date, oldProducedate, producedate, view, plugin);
    }

    private static String getDateStr(Date date) {
        String dateStr = null;
        if (date == null) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        dateStr = sd.format(date);
        return dateStr;
    }

    private static void checkShelflifeDate(Date produceDate, Date expirydate, int rowIndex, String key, DynamicObject materialInvInfo, IFormView view) {
        if (expirydate != null && produceDate != null && expirydate.before(produceDate)) {
            String newExpirydateStr = WorkbenchPropertyChangeHelper.getDateStr(expirydate);
            String newProduceDateStr = WorkbenchPropertyChangeHelper.getDateStr(produceDate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u5230\u671f\u65e5\u671f\u6216\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u7684\u201c\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u201d\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"WorkbenchPropertyChangeHelper_1", (String)"scmc-im-business", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            view.showErrorNotification(msg);
            WorkbenchServiceHelper.setValueNoChange(key, null, rowIndex, view);
        }
    }

    private static void showExpiryDateConfirm(int rowIndex, DynamicObject materialInvInfo, Date oldExpiryDate, Date newExpiryDate, Date oldProducedate, Date newProducedate, IFormView view, IFormPlugin plugin) {
        String billName = WorkbenchServiceHelper.getTargetEntityType(view);
        String entryName = "billentry";
        boolean isOutBill = InvBillHelper.isOutEntry(billName, entryName);
        boolean isInBill = InvBillHelper.isInEntry(billName, entryName);
        String leadTimeUnit = materialInvInfo.getString("leadtimeunit");
        int dateOfOverdueForIn = materialInvInfo.getInt("dateofoverdueforin");
        int dateOfOverdueForOut = materialInvInfo.getInt("dateofoverdueforout");
        int dateOfOverdue = 0;
        if (isOutBill && isInBill) {
            dateOfOverdue = dateOfOverdueForOut > dateOfOverdueForIn ? dateOfOverdueForOut : dateOfOverdueForIn;
        } else if (isOutBill) {
            dateOfOverdue = dateOfOverdueForOut;
        } else if (isInBill) {
            dateOfOverdue = dateOfOverdueForIn;
        }
        Date overdueDate = ShelfLifeDateUtil.getDateOfOverdue((String)leadTimeUnit, (int)dateOfOverdue, (Date)newExpiryDate);
        Date nowDate = new Date();
        boolean dateOver = nowDate.after(overdueDate);
        ArrayList alertMsgList = new ArrayList(2);
        if (dateOver) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String newExpirydateStr = WorkbenchPropertyChangeHelper.getDateStr(newExpiryDate);
            String oldExpirydateStr = WorkbenchPropertyChangeHelper.getDateStr(oldExpiryDate);
            String newProducedateStr = WorkbenchPropertyChangeHelper.getDateStr(newProducedate);
            String oldProducedateStr = WorkbenchPropertyChangeHelper.getDateStr(oldProducedate);
            params.put("newProduceDate", newProducedateStr);
            params.put("oldProduceDate", oldProducedateStr);
            params.put("newExpiryDate", newExpirydateStr);
            params.put("oldExpiryDate", oldExpirydateStr);
            params.put("index", rowIndex);
            alertMsgList.add(params);
            ConfirmCallBackListener cb = new ConfirmCallBackListener("MaterialLifeDate", plugin);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s\u201d\u5230\u671f\u65e5\u671f\u4e3a\u201c%3$s\u201d,\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u662f\u5426\u5141\u8bb8\u5f55\u5165\uff1f", (String)"WorkbenchPropertyChangeHelper_3", (String)"scmc-im-business", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr);
            view.showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(alertMsgList));
        } else {
            WorkbenchServiceHelper.setValueNoChange("producedate", newProducedate, rowIndex, view);
            WorkbenchServiceHelper.setValueNoChange("expiredate", newExpiryDate, rowIndex, view);
        }
    }

    private static void changeOutKeeperType(String keeperType, int rowIndex, IFormView view) {
        DynamicObject inOrg;
        if (!"bos_org".equals(keeperType)) {
            WorkbenchServiceHelper.setNullValue("outkeeper", rowIndex, view);
            return;
        }
        IDataModel model = view.getModel();
        MainEntityType dataEntityType = model.getDataEntityType();
        Map allFields = dataEntityType.getAllFields();
        boolean containsOutOgKey = allFields.containsKey("outorg");
        boolean containsInOgKey = allFields.containsKey("inorg");
        if (!containsOutOgKey && !containsInOgKey) {
            return;
        }
        DynamicObject outOrg = containsOutOgKey ? (DynamicObject)model.getValue("outorg") : null;
        DynamicObject dynamicObject = inOrg = containsInOgKey ? (DynamicObject)model.getValue("inorg") : null;
        if (inOrg == null && outOrg == null) {
            return;
        }
        DynamicObject org = null;
        if (outOrg == null && inOrg != null) {
            org = inOrg;
        }
        if (outOrg != null && inOrg == null) {
            org = outOrg;
        }
        if (outOrg != null && inOrg != null) {
            org = outOrg;
        }
        WorkbenchServiceHelper.setValue("outkeeper", (Object)org, rowIndex, view);
    }

    private static void changeInKeeperType(String keeperType, int rowIndex, IFormView view) {
        DynamicObject inOrg;
        if (!"bos_org".equals(keeperType)) {
            WorkbenchServiceHelper.setNullValue("inkeeper", rowIndex, view);
            return;
        }
        IDataModel model = view.getModel();
        MainEntityType dataEntityType = model.getDataEntityType();
        Map allFields = dataEntityType.getAllFields();
        boolean containsOutOgKey = allFields.containsKey("outorg");
        boolean containsInOgKey = allFields.containsKey("inorg");
        if (!containsOutOgKey && !containsInOgKey) {
            return;
        }
        DynamicObject outOrg = containsOutOgKey ? (DynamicObject)model.getValue("outorg") : null;
        DynamicObject dynamicObject = inOrg = containsInOgKey ? (DynamicObject)model.getValue("inorg") : null;
        if (inOrg == null && outOrg == null) {
            return;
        }
        DynamicObject org = null;
        if (outOrg == null && inOrg != null) {
            org = inOrg;
        }
        if (outOrg != null && inOrg == null) {
            org = outOrg;
        }
        if (outOrg != null && inOrg != null) {
            org = inOrg;
        }
        WorkbenchServiceHelper.setValue("inkeeper", (Object)org, rowIndex, view);
    }
}

