/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.workbench;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.PrecisionAccountHelper;
import kd.scmc.im.business.workbench.WorkbenchServiceHelper;
import kd.scmc.im.utils.BigDecimalUtils;

public class WorkbenchUnitAndQtytHelper {
    private static final Log log = LogFactory.getLog(WorkbenchUnitAndQtytHelper.class);

    public static void setBizQtyAndUnit(IFormView view, int rowIndex, String fieldName, Object newValue, Object oldValue) {
        DynamicObject materialInvInfo = (DynamicObject)WorkbenchServiceHelper.getValue("materiel", rowIndex, view);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            return;
        }
        switch (fieldName) {
            case "qty": {
                BigDecimal qty = (BigDecimal)newValue;
                if (qty.compareTo(BigDecimal.ZERO) < 0) {
                    WorkbenchServiceHelper.setValueNoChange("qty", oldValue, rowIndex, view);
                    view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u91cf\u4e0d\u5141\u8bb8\u4e3a\u8d1f\u6570\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WorkbenchUnitAndQtytHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
                    return;
                }
                WorkbenchUnitAndQtytHelper.changeQty(view, rowIndex, (BigDecimal)newValue, (BigDecimal)oldValue, material);
                break;
            }
            case "unit": {
                WorkbenchUnitAndQtytHelper.changeUnit(view, rowIndex, (DynamicObject)newValue, material);
                break;
            }
        }
    }

    private static void changeQty(IFormView view, int rowIndex, BigDecimal qty, BigDecimal oldQty, DynamicObject material) {
        DynamicObject unit = (DynamicObject)WorkbenchServiceHelper.getValue("unit", rowIndex, view);
        DynamicObject baseUnit = (DynamicObject)WorkbenchServiceHelper.getValue("baseunit", rowIndex, view);
        WorkbenchUnitAndQtytHelper.setBaseQtyValue(view, rowIndex, material, qty, oldQty, baseUnit, unit);
    }

    private static void changeUnit(IFormView view, int rowIndex, DynamicObject unit, DynamicObject material) {
        if (unit == null) {
            return;
        }
        BigDecimal qty = (BigDecimal)WorkbenchServiceHelper.getValue("qty", rowIndex, view);
        DynamicObject baseUnit = (DynamicObject)WorkbenchServiceHelper.getValue("baseunit", rowIndex, view);
        qty = PrecisionAccountHelper.dealWithprecision(unit, qty);
        WorkbenchServiceHelper.setValue("qty", qty, rowIndex, view);
        WorkbenchUnitAndQtytHelper.setBaseQtyValue(view, rowIndex, material, qty, qty, baseUnit, unit);
    }

    private static void setBaseQtyValue(IFormView view, int rowIndex, DynamicObject material, BigDecimal qty, BigDecimal oldQty, DynamicObject baseUnit, DynamicObject unit) {
        BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv(material, unit, qty, baseUnit);
        IDataModel model = view.getModel();
        Map allFields = view.getModel().getDataEntityType().getAllFields();
        if (!allFields.containsKey("baseqty")) {
            return;
        }
        try {
            BigDecimalUtils.showBigDecimalErrorTip((IDataModel)model, (BigDecimal)baseQty, (String)"baseqty");
        }
        catch (Exception e) {
            WorkbenchServiceHelper.setValueNoChange("qty", oldQty, rowIndex, view);
            view.showErrorNotification(e.getMessage());
            return;
        }
        WorkbenchServiceHelper.setValueNoChange("baseqty", baseQty, rowIndex, view);
    }
}

