/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.MaterialWhRelationHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.OperatorGroupHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.enums.InvalidEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import org.apache.commons.lang3.StringUtils;

public class ImTransformBillBeforeF7Select {
    private IFormView view = null;

    private IDataModel getModel() {
        return this.getView().getModel();
    }

    private IFormView getView() {
        return this.view;
    }

    public ImTransformBillBeforeF7Select(IFormView view) {
        this.view = view;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        String formid = this.getModel().getDataEntityType().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        IDataModel bill = this.getModel();
        DynamicObject org = (DynamicObject)bill.getValue("org");
        if ("org".equals(fieldKey)) {
            this.beforeOrgSelectF7(formid, showParameter);
            return;
        }
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"AssembBillEdit_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        int subentryRowIndex = this.getModel().getEntryCurrentRowIndex("afterentity");
        switch (fieldKey) {
            case "biztype": {
                this.beforeBiztypeSelectF7(formid, showParameter);
                break;
            }
            case "location": {
                this.beforeLocationSelectF7(bill, rowIndex, e, showParameter);
                break;
            }
            case "location1": {
                this.beforeAfterLocationSelectF7(bill, subentryRowIndex, e, showParameter);
                break;
            }
            case "warehouse": {
                DynamicObject row = bill.getEntryRowEntity("billentry", rowIndex);
                WareHouseIsolateHelper.setWarehouseQFilterByDataCtrl((Long)org.getLong("id"), (ListShowParameter)showParameter, (String)formid, (DynamicObject)row, (String)"billentry.warehouse");
                break;
            }
            case "unit": {
                this.beforeUnitSelectF7(bill, rowIndex, e, showParameter);
                break;
            }
            case "unit1": {
                this.beforeAfterUnitSelectF7(bill, subentryRowIndex, e, showParameter);
                break;
            }
            case "operator": 
            case "outoperator": {
                this.beforeOperatorSelectF7(bill, showParameter, org);
                break;
            }
            case "operatorgroup": 
            case "outoperatorgroup": {
                this.beforeOperatorGroupSelectF7(bill, showParameter);
                break;
            }
            case "mversion": {
                DynamicObject materialInvInfo = (DynamicObject)bill.getValue("material", rowIndex);
                if (materialInvInfo == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599", (String)"ImTransformBillEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("material", "=", (Object)materialInvInfo.getLong("masterid_id")));
                break;
            }
            case "mversion1": {
                DynamicObject afterMaterialInvInfo = (DynamicObject)bill.getValue("material1", subentryRowIndex);
                if (afterMaterialInvInfo == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599", (String)"ImTransformBillEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("material", "=", (Object)afterMaterialInvInfo.getLong("masterid_id")));
                break;
            }
            case "lot": {
                this.beforeLotSelectF7(bill, rowIndex, e, fieldKey);
                break;
            }
            case "lot1": {
                this.beforeAfterLotSelectF7(bill, subentryRowIndex, e, fieldKey);
                break;
            }
            case "owner": {
                this.beforeOwnerSelect(e);
                break;
            }
            case "keeper": {
                this.beforeKeeperSelect(e);
                break;
            }
            case "warehouse1": {
                this.beforeAfterWarehouseSelect(e, formid);
                break;
            }
            case "configuredcode": {
                this.beforeConfigCodeF7(showParameter, rowIndex, fieldKey);
                break;
            }
            case "configuredcode1": {
                this.beforeConfigCodeF7(showParameter, subentryRowIndex, fieldKey);
                break;
            }
            case "tracknumber": 
            case "tracknumber1": {
                showParameter.getListFilterParameter().setFilter(InvBillHelper.getTrackNumberFilter());
                break;
            }
            case "material1": {
                MaterialWhRelationHelper.addWarehouseSetupFilter((BeforeF7SelectEvent)e, (ListShowParameter)showParameter, (IDataModel)bill, (String)"warehouse1");
                break;
            }
            case "material": {
                MaterialWhRelationHelper.addWarehouseSetupFilter((BeforeF7SelectEvent)e, (ListShowParameter)showParameter, (IDataModel)bill, (String)"warehouse");
                break;
            }
        }
    }

    private void beforeConfigCodeF7(ListShowParameter showParameter, int rowIndex, String field) {
        QFilter qFilter = null;
        Object masterId = null;
        if (field.equalsIgnoreCase("configuredcode")) {
            Object value = this.getModel().getValue("material", rowIndex);
            if (value != null) {
                masterId = ((DynamicObject)value).get("masterid.id");
            }
        } else {
            Object value = this.getModel().getValue("material1", rowIndex);
            if (value != null) {
                masterId = ((DynamicObject)value).get("masterid.id");
            }
        }
        qFilter = InvBillHelper.getConfigureCodeFilter(masterId);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeBiztypeSelectF7(String formId, ListShowParameter showParameter) {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if (billType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5355\u636e\u7c7b\u578b\u3002", (String)"ImBillBeforeF7Select_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        List bizTypeIds = BizTypeHelper.getBizTypeIds((Object)billType.getPkValue(), (String)formId);
        QFilter qFilter = new QFilter("id", "in", (Object)bizTypeIds);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeOrgSelectF7(String formId, ListShowParameter showParameter) {
        Object[] orgIdList = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)formId, (String)showParameter.getAppId());
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgIdList));
    }

    private void beforeLocationSelectF7(IDataModel bill, int rowIndex, BeforeF7SelectEvent e, ListShowParameter showParameter) {
        DynamicObject warehouse = (DynamicObject)bill.getValue("warehouse", rowIndex);
        if (CommonUtils.isNull((Object)warehouse)) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_WAREHOUSE(), (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter qFilter1 = WarehouseHelper.buildLocationQFilter((DynamicObject)warehouse);
        showParameter.getListFilterParameter().setFilter(qFilter1);
    }

    private void beforeUnitSelectF7(IDataModel bill, int rowIndex, BeforeF7SelectEvent e, ListShowParameter showParameter) {
        Long masterMaterialId = 0L;
        Object masterMaterial = bill.getValue("materialmasterid", rowIndex);
        masterMaterialId = masterMaterial instanceof DynamicObject ? (Long)((DynamicObject)masterMaterial).getPkValue() : (Long)masterMaterial;
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowIndex);
        Long srcmuId = baseUnit == null ? Long.valueOf(0L) : (Long)baseUnit.getPkValue();
        List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1", (Boolean)Boolean.TRUE);
        QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeAfterLocationSelectF7(IDataModel bill, int subentryRowIndex, BeforeF7SelectEvent e, ListShowParameter showParameter) {
        DynamicObject warehouse = (DynamicObject)bill.getValue("warehouse1", subentryRowIndex);
        if (CommonUtils.isNull((Object)warehouse)) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_WAREHOUSE()));
            e.setCancel(true);
            return;
        }
        QFilter qFilter1 = WarehouseHelper.buildLocationQFilter((DynamicObject)warehouse);
        showParameter.getListFilterParameter().setFilter(qFilter1);
    }

    private void beforeAfterUnitSelectF7(IDataModel bill, int subentryRowIndex, BeforeF7SelectEvent e, ListShowParameter showParameter) {
        Long masterMaterialId = 0L;
        Object masterMaterial = bill.getValue("materialmasterid1", subentryRowIndex);
        masterMaterialId = masterMaterial instanceof DynamicObject ? (Long)((DynamicObject)masterMaterial).getPkValue() : (Long)masterMaterial;
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit1", subentryRowIndex);
        Long srcmuId = baseUnit == null ? Long.valueOf(0L) : (Long)baseUnit.getPkValue();
        List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1", (Boolean)Boolean.TRUE);
        QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeOperatorSelectF7(IDataModel bill, ListShowParameter showParameter, DynamicObject org) {
        long userId = UserServiceHelper.getCurrentUserId();
        String formId = this.getModel().getDataEntityType().getName();
        try {
            Object operatorGroupIsolate = AppParameterHelper.getAppParameterByFormId((String)formId, (Long)((Long)org.getPkValue()), (String)"foperatorgroupisolate");
            if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                QFilter qFilter1 = OperatorGroupHelper.getOperatorGroupByUserForAll((long)userId, (DynamicObject)org);
                QFilter qFilter2 = new QFilter("opergrptype", "=", (Object)this.getOperatorGroupType(formId, this.getOrgViewType()));
                QFilter qFilter3 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
                showParameter.getListFilterParameter().setFilter(qFilter2.and(qFilter3).and(qFilter1));
            } else {
                QFilter qFilter1 = new QFilter("operatorgrpid", "in", this.getOperatorGroupByOrg((Long)org.getPkValue()));
                QFilter qFilter2 = new QFilter("opergrptype", "=", (Object)this.getOperatorGroupType(formId, this.getOrgViewType()));
                QFilter qFilter3 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
                showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter1, qFilter2, qFilter3));
            }
        }
        catch (Exception ee) {
            showParameter.getListFilterParameter().setFilter(new QFilter("opergrptype", "=", (Object)this.getOperatorGroupType(formId, this.getOrgViewType())));
        }
    }

    private void beforeOperatorGroupSelectF7(IDataModel bill, ListShowParameter showParameter) {
        DynamicObject operator = (DynamicObject)bill.getValue("operator");
        if (CommonUtils.isNull((Object)operator)) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)0));
        } else {
            operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.getPkValue(), (String)"bd_operator");
            QFilter qFilter = new QFilter("id", "in", this.getOperatorGroupByUser((Long)operator.getDynamicObject("operatorid").getPkValue()));
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void beforeLotSelectF7(IDataModel bill, int rowIndex, BeforeF7SelectEvent e, String fieldKey) {
        DynamicObject dynamicObject = bill.getDataEntity();
        DynamicObject selectEntry = bill.getEntryRowEntity("billentry", rowIndex);
        String lotidField = "billentry." + fieldKey;
        LotMainFileHelper.setLotMainfFileF7Filter((BeforeF7SelectEvent)e, (DynamicObject)dynamicObject, (DynamicObject)selectEntry, (String)lotidField);
    }

    private void beforeAfterLotSelectF7(IDataModel bill, int subentryRowIndex, BeforeF7SelectEvent e, String fieldKey) {
        DynamicObject dynamicObject = bill.getDataEntity();
        DynamicObject selectEntry = bill.getEntryRowEntity("afterentity", subentryRowIndex);
        String lotidField = "billentry.afterentity." + fieldKey;
        LotMainFileHelper.setLotMainfFileF7Filter((BeforeF7SelectEvent)e, (DynamicObject)dynamicObject, (DynamicObject)selectEntry, (String)lotidField);
    }

    private void beforeOwnerSelect(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        int row = e.getRow();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String type = (String)model.getValue("ownertype", row);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        QFilter f = null;
        DynamicObject org = (DynamicObject)model.getValue("org");
        switch (type) {
            case "bos_org": {
                if (org == null) {
                    this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                    e.setCancel(true);
                    return;
                }
                f = new QFilter("id", "in", this.getOwnerList());
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    private void beforeKeeperSelect(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        int row = e.getRow();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter f = null;
        String type = (String)model.getValue("keepertype", row);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        DynamicObject org = (DynamicObject)model.getValue("org");
        switch (type) {
            case "bos_org": {
                f = new QFilter("id", "=", org == null ? null : org.getPkValue());
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    private void beforeAfterWarehouseSelect(BeforeF7SelectEvent e, String formId) {
        IDataModel model = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG(), (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        int rowIdx = model.getEntryCurrentRowIndex("afterentity");
        DynamicObject row = model.getEntryRowEntity("afterentity", rowIdx);
        WareHouseIsolateHelper.setWarehouseQFilterByDataCtrl((Long)org.getLong("id"), (ListShowParameter)showParameter, (String)formId, (DynamicObject)row, (String)"billentry.afterentity.warehouse1");
    }

    public ArrayList<Object> getOwnerList() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ArrayList<Object> array = new ArrayList<Object>();
        if (!CommonUtils.isNull((Object)org)) {
            Long orgId = (Long)org.getPkValue();
            ArrayList ownerArray = OwnerHelper.getOwners((Long)orgId);
            array.addAll(ownerArray);
            Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            Object settleOrgId = null;
            if (companyByOrg != null) {
                settleOrgId = companyByOrg.get("id");
                array.add(settleOrgId);
            }
        }
        return array;
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (CommonUtils.isNull((Object)locationCol) || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject("location");
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }

    private ArrayList<Long> getOperatorGroupByUser(long userId) {
        String formId = this.getModel().getDataEntityType().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Map customParas = this.getView().getFormShowParameter().getCustomParams();
        if (customParas != null && customParas.get("sourceformid") != null && customParas.get("orgViewType") != null) {
            formId = (String)customParas.get("sourceformid");
        }
        ArrayList<Long> operatorGroupList = new ArrayList<Long>();
        QFilter qFilter1 = new QFilter("operatorid", "=", (Object)userId);
        QFilter qFilter2 = new QFilter("opergrptype", "=", (Object)this.getOperatorGroupType(formId, this.getOrgViewType()));
        qFilter2.and("invalid", "=", (Object)InvalidEnum.NO.getValue());
        QFilter qFilter3 = new QFilter("operatorgrpid", "in", this.getOperatorGroupByOrg((Long)org.getPkValue()));
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
        if (CommonUtils.isNull((Object)map)) {
            return operatorGroupList;
        }
        ArrayList list = new ArrayList(map.values());
        for (int i = 0; i < list.size(); ++i) {
            operatorGroupList.add(((DynamicObject)list.get(i)).getLong("operatorgrpid"));
        }
        return operatorGroupList;
    }

    private ArrayList<Long> getOperatorGroupByOrg(long orgId) {
        String formId = this.getModel().getDataEntityType().getName();
        Map customParas = this.getView().getFormShowParameter().getCustomParams();
        if (customParas != null && customParas.get("sourceformid") != null && customParas.get("orgViewType") != null) {
            formId = (String)customParas.get("sourceformid");
        }
        ArrayList<Long> operatorGroupList = new ArrayList<Long>();
        QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        QFilter qFilter2 = new QFilter("operatorgrouptype", "=", (Object)this.getOperatorGroupType(formId, this.getOrgViewType()));
        qFilter2.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (CommonUtils.isNull((Object)map)) {
            return operatorGroupList;
        }
        ArrayList list = new ArrayList(map.values());
        for (int i = 0; i < list.size(); ++i) {
            operatorGroupList.add((Long)((DynamicObject)list.get(i)).getPkValue());
        }
        return operatorGroupList;
    }

    private String getOrgViewType() {
        return "05";
    }

    private String getOperatorGroupType(String formId, String orgFunc) {
        return OperatorGrpTypeEnum.INVENTORYGRP.getValue();
    }
}

