/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bd.sbd.enums.UnitConvertDirEnum;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeBatchFillEntryArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.CollectionUtils;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.AuxQtyAndUnitHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.BillViewHelper;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.business.helper.CloseDateHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.FillBatchHelper;
import kd.scmc.im.business.helper.InvAvbQtyQueryHelper;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.MatchingRuleOutHelper;
import kd.scmc.im.business.helper.MaterialHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.PrecisionAccountHelper;
import kd.scmc.im.business.helper.SerialNumberHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;
import kd.scmc.im.business.helper.matchout.MatchingRuleOutOldTransFormHelper;
import kd.scmc.im.business.helper.matchruleout.MatchingRuleOutHandler;
import kd.scmc.im.business.helper.matchruleout.MatchingRuleOutNewHelper;
import kd.scmc.im.business.helper.matchruleout.MatchingRuleOutPageCache;
import kd.scmc.im.consts.Constants;
import kd.scmc.im.consts.TransformBillTplEntryConst;
import kd.scmc.im.enums.InvalidEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.formplugin.ImTransformBillBeforeF7Select;
import kd.scmc.im.helper.DaysCalcHelper;
import kd.scmc.im.helper.ShelfLifeDateUtil;
import kd.scmc.im.utils.BigDecimalUtils;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.DateUtils;
import kd.scmc.im.utils.FormUtils;
import kd.scmc.im.utils.IMStringUtils;

public class ImTransformBillEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
RowClickEventListener,
EntryGridBindDataListener {
    protected static String subSuffix = "1";
    protected IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
    private static final Log log = LogFactory.getLog(ImTransformBillEditPlugin.class);
    private static final String BARITEM_ENTER_SNNUMBER = "entersnnumber";
    private static final String BARITEM_IMPORT_SNNUMBER = "importsnnumber";
    private static final String BARITEM_CHECK_SNNUMBER = "checksnnumber";
    private static final String BARITEM_SUB_ENTER_SNNUMBER = "entersnnumber1";
    private static final String BARITEM_SUB_IMPORT_SNNUMBER = "importsnnumber1";
    private static final String BARITEM_SUB_CHECK_SNNUMBER = "checksnnumber1";
    private static final String INVFLU_INCREASE = "1";
    private static final String INVFLU_SUBTRACT = "2";
    private static final String SCMCAVBINVQUERY = "scmcavbinvquery";
    private static final String SCMCAVBINVQUERY1 = "scmcavbinvquery1";
    private DynamicObject bill;
    private static String[] needFillFields = new String[]{"invstatus1", "invtype1", "project1"};
    public static final List<String> relatedList = Arrays.asList("mainbillid", "mainbillentryid", "mainbillnumber", "mainbillentity", "srcbillid", "srcbillentryid", "srcbillnumber", "srcbillentity", "mainbillentryseq", "srcbillentryseq", "srcsysbillentryid", "srcsystem", "srcsysbillno", "srcsysbillid", "subsrcbillentity", "subsrcbillentryid", "subsrcbillid");

    public void initialize() {
        EntryGrid afterEntryGrid;
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((afterEntryGrid = (EntryGrid)this.getView().getControl("afterentity")) != null) {
            afterEntryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"biztype", "org", "bizuser", "operatorgroup", "operator", "dept", "material", "unit", "lot", "invtype", "invstatus", "owner", "keeper", "warehouse", "location", "mversion", "configuredcode", "tracknumber"});
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"material1", "unit1", "lot1", "invtype1", "invstatus1", "owner1", "keeper1", "warehouse1", "location1", "mversion1", "configuredcode1", "tracknumber1"});
        this.addClickListeners(new String[]{"lotnumber", "lotnumber1"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        FlexEdit auxpty = (FlexEdit)this.getView().getControl("auxpty");
        if (auxpty != null) {
            auxpty.registerBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        FlexEdit afterAuxpty = (FlexEdit)this.getView().getControl("auxpty1");
        DynamicObjectCollection afterEntry = this.getView().getModel().getEntryEntity("afterentity");
        if (afterAuxpty != null && afterEntry != null && afterEntry.size() > 0) {
            afterAuxpty.registerBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        CloseDateHelper.initBookDate((String)this.getView().getEntityId(), (DynamicObject)model.getDataEntity(true));
        model.setValue("ischargeoff", (Object)Boolean.FALSE);
        model.setValue("ischargeoffed", (Object)Boolean.FALSE);
        DynamicObject bizType = (DynamicObject)model.getValue("biztype");
        boolean enable = bizType.getBoolean("enable");
        if (!enable) {
            model.setValue("biztype", null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        BillModel billModel;
        boolean isFromWebApi;
        DynamicObject org;
        super.afterCreateNewData(e);
        this.initNewDataByOrg();
        this.initMainOrg();
        this.initBizType();
        IDataModel model = this.getModel();
        DynamicObjectCollection invBillEntrys = (DynamicObjectCollection)model.getValue("billentry");
        if (invBillEntrys != null) {
            this.initNewBeforeEntry(0);
        }
        if ((org = (DynamicObject)model.getValue("org")) != null) {
            Object defOwer = OwnerHelper.getOwnerDefValue((Long)org.getLong("id"));
            DynamicObjectCollection collections = model.getEntryEntity("billentry");
            if (collections != null && collections.size() != 0) {
                for (int i = 0; i < collections.size(); ++i) {
                    DynamicObject object = (DynamicObject)collections.get(0);
                    this.setDefaultKeeper(object.getString("keepertype"), i);
                    this.setDefaultOwner(object.getString("ownertype"), i, defOwer);
                }
            }
        }
        if (isFromWebApi = (billModel = (BillModel)model).isFromWebApi()) {
            return;
        }
        CloseDateHelper.initBookDate((String)this.getView().getEntityId(), (DynamicObject)this.getModel().getDataEntity(true));
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IDataModel bill = this.getModel();
        String formId = this.getModel().getDataEntityType().getName();
        CloseDateHelper.initBookDate((String)formId, (DynamicObject)bill.getDataEntity(true));
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        String entryKey = e.getEntryProp().getName();
        String formId = this.getModel().getDataEntityType().getName();
        if (formId.equals("im_adjustbill") && entryKey.equals("billentry") || formId.equals("im_assembbill") && entryKey.equals("afterentity")) {
            int[] rowIndexs;
            for (int index : rowIndexs = e.getRowIndexs()) {
                MatchingRuleOutPageCache.deleteMatchInfoPageCache((int)index, (IFormView)this.getView(), (String)entryKey);
            }
        }
    }

    private void initMainOrg() {
        String formId = this.getModel().getDataEntityType().getName();
        String orgKey = "org";
        DynamicObject org = (DynamicObject)this.getModel().getValue(orgKey);
        if (org == null) {
            return;
        }
        Object[] orgList = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)formId, (String)this.getView().getFormShowParameter().getAppId());
        if (orgList == null || orgList.length == 0) {
            this.getModel().setValue(orgKey, null);
            return;
        }
        String orgId = org.getPkValue().toString();
        boolean hasOrg = false;
        for (int i = 0; i < orgList.length; ++i) {
            if (!orgId.equals(orgList[i].toString())) continue;
            hasOrg = true;
            break;
        }
        if (!hasOrg) {
            this.getModel().setValue(orgKey, null);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        this.bill = this.getBill(true);
        this.setLocationView();
        this.setAfterLocationView();
        this.setSubView();
        this.setOperatorView(view);
        this.setMaterialView();
        this.setBookDateView();
    }

    private void setBookDateView() {
        IFormView view = this.getView();
        boolean bookdateEnable = SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0004");
        view.setEnable(Boolean.valueOf(!bookdateEnable), new String[]{"bookdate"});
        if (!bookdateEnable) {
            DateEdit bookdateDateEdit = (DateEdit)view.getControl("bookdate");
            bookdateDateEdit.hideTips();
        }
    }

    private void setMaterialView() {
        IDataModel model = this.getModel();
        DynamicObjectCollection invBillEntrys = (DynamicObjectCollection)model.getValue("billentry");
        if (invBillEntrys == null) {
            return;
        }
        for (int i = 0; i < invBillEntrys.size(); ++i) {
            DynamicObject billEntry = (DynamicObject)invBillEntrys.get(i);
            DynamicObject materialInvInfo = billEntry.getDynamicObject("material");
            if (materialInvInfo == null) continue;
            this.setEnableByMaterial(materialInvInfo, i, this.getView());
        }
    }

    private void setLocationView() {
        IDataModel model = this.getModel();
        DynamicObjectCollection invBillEntrys = (DynamicObjectCollection)model.getValue("billentry");
        if (invBillEntrys == null) {
            return;
        }
        for (int i = 0; i < invBillEntrys.size(); ++i) {
            this.setLocationEnable((DynamicObject)invBillEntrys.get(i), i, this.getView());
        }
    }

    private void setLocationEnable(DynamicObject entry, int rowIndex, IFormView view) {
        DynamicObject warehouse = (DynamicObject)entry.get("warehouse");
        boolean isOpenLocation = warehouse == null ? false : warehouse.getBoolean("isopenlocation");
        view.setEnable(Boolean.valueOf(isOpenLocation), rowIndex, new String[]{"location"});
    }

    private void setAfterLocationView() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entries = (DynamicObjectCollection)model.getValue("afterentity");
        if (entries == null) {
            return;
        }
        for (int i = 0; i < entries.size(); ++i) {
            this.setAfterLocationEnable((DynamicObject)entries.get(i), i, this.getView());
        }
    }

    private void setAfterLocationEnable(DynamicObject entry, int rowIndex, IFormView view) {
        DynamicObject warehouse = (DynamicObject)entry.get("warehouse1");
        boolean isOpenLocation = warehouse == null ? false : warehouse.getBoolean("isopenlocation");
        view.setEnable(Boolean.valueOf(isOpenLocation), rowIndex, new String[]{"location1"});
    }

    private void setSubView() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        if (entryCurrentRowIndex != -1) {
            this.subEntryUi(entryCurrentRowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        if (!this.isChanged(e)) {
            return;
        }
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        InvAvbQtyQueryHelper.clearAvbQty((String)propName, (int)valueSet[0].getRowIndex(), (IFormView)this.getView());
        if ("billtype".equals(propName)) {
            this.changeBillType((DynamicObject)newValue);
        } else if ("warehouse".equals(propName)) {
            this.changeWarehouse(valueSet);
        } else if ("serialnumber".equals(propName)) {
            int cur = this.getModel().getEntryCurrentRowIndex("subentryentity");
            if (cur == -1) {
                return;
            }
            this.getModel().beginInit();
            this.getModel().setValue("serialid", null, cur);
            this.getModel().endInit();
            this.getView().updateView("serialid", cur);
        } else if ("biztime".equals(propName)) {
            this.changeBizData(newValue);
        } else if (propName.equalsIgnoreCase("org")) {
            this.changeOrg(newValue);
        } else if (propName.equalsIgnoreCase("dept")) {
            this.changeDept((DynamicObject)newValue);
        } else if (propName.equalsIgnoreCase("operatorgroup")) {
            this.changeOperatorGroup((DynamicObject)newValue);
        } else if (propName.equalsIgnoreCase("operator")) {
            this.changeOperator((DynamicObject)newValue, propName);
        }
        for (int i = 0; i < valueSet.length; ++i) {
            newValue = valueSet[i].getNewValue();
            Object oldValue = valueSet[i].getOldValue();
            int rowIndex = valueSet[i].getRowIndex();
            int parentRowIndex = valueSet[i].getParentRowIndex();
            if ("material".equals(propName)) {
                this.changeMaterial((DynamicObject)newValue, rowIndex);
                this.update2Version((DynamicObject)newValue, rowIndex, "mversion");
                continue;
            }
            if ("material1".equals(propName)) {
                this.changeAfterMaterial((DynamicObject)newValue, rowIndex);
                this.update2Version((DynamicObject)newValue, rowIndex, "mversion1");
                continue;
            }
            if ("baseqty".equals(propName) || "qtybizunit".equals(propName) || "qtyunit2nd".equals(propName) || "unit".equals(propName) || "qty".equals(propName)) {
                this.changeQtyOrUnit(propName, newValue, rowIndex);
                continue;
            }
            if ("baseqty1".equals(propName) || "qtyunit2nd1".equals(propName) || "unit1".equals(propName) || "qty1".equals(propName)) {
                this.changeQty1OrUnit1(propName, newValue, rowIndex, parentRowIndex);
                continue;
            }
            if ("lotnumber".equals(propName)) {
                this.changeLotNumber(oldValue, newValue, rowIndex, Boolean.FALSE);
                continue;
            }
            if ("lotnumber1".equals(propName)) {
                this.changeLotNumber(oldValue, newValue, rowIndex, Boolean.TRUE);
                continue;
            }
            if ("producedate".equals(propName)) {
                this.changeProduceDate(oldValue, newValue, rowIndex, propName);
                continue;
            }
            if ("producedate1".equals(propName)) {
                this.changeProduceDate(oldValue, newValue, rowIndex, propName);
                continue;
            }
            if ("expirydate".equals(propName)) {
                this.changeExpirydate(oldValue, newValue, rowIndex, propName);
                continue;
            }
            if ("expirydate1".equals(propName)) {
                this.changeExpirydate(oldValue, newValue, rowIndex, propName);
                continue;
            }
            if ("ownertype".equals(propName)) {
                this.changeOwnerType(e);
                continue;
            }
            if ("keepertype".equals(propName)) {
                this.changeKeeperType(e);
                continue;
            }
            if ("lot1".equals(propName)) {
                this.changeAfterLot(e, propName, rowIndex);
                continue;
            }
            if (!"lot".equals(propName)) continue;
            this.changeLot(e, propName, rowIndex);
        }
    }

    private void changeLot(PropertyChangedArgs e, String propName, int rowIndex) {
        String entryName = "billentry";
        String lotidField = "billentry." + propName;
        String lotnumberField = "lotnumber";
        LotMainFileHelper.changeLot((PropertyChangedArgs)e, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)entryName, (int)rowIndex, (String)lotidField, (String)lotnumberField);
    }

    private void changeAfterLot(PropertyChangedArgs e, String propName, int rowIndex) {
        String entryName = "afterentity";
        String lotidField = "billentry.afterentity." + propName;
        String lotnumberField = "lotnumber1";
        LotMainFileHelper.changeLot((PropertyChangedArgs)e, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)entryName, (int)rowIndex, (String)lotidField, (String)lotnumberField);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        try (TraceSpan span = Tracer.create((String)"ImTransformBillEditPlugin", (String)("beforeF7Select: " + e.getProperty().getName()));){
            ImTransformBillBeforeF7Select selector = new ImTransformBillBeforeF7Select(this.getView());
            selector.beforeF7Select(e);
        }
    }

    private void initBizType() {
        DynamicObject bizType;
        String formId = this.getModel().getDataEntityType().getName();
        Object value = this.getModel().getValue("billtype");
        DynamicObject dynamicObject = bizType = value == null ? null : BizTypeHelper.getBizTypeByBillType((String)formId, (DynamicObject)((DynamicObject)value));
        if (bizType != null) {
            this.getModel().setValue("biztype", (Object)bizType.getLong("id"));
        }
    }

    private void initNewDataByOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        Long orgId = (Long)org.getPkValue();
        Map<Object, DynamicObject> operatorGroupMap = this.getOperatorGroupMap(orgId);
        this.initDept(userId, orgId, operatorGroupMap);
        this.initOperatorAndGroup(userId, operatorGroupMap);
    }

    private Map<Object, DynamicObject> getOperatorGroupMap(Long orgId) {
        String operatorGrpType = this.getOperatorGroupType();
        QFilter qFilter01 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        QFilter qFilter02 = new QFilter("operatorgrouptype", "=", (Object)operatorGrpType);
        qFilter02.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter01, qFilter02});
        return map;
    }

    private void initDept(long userId, Long orgId, Map<Object, DynamicObject> operatorGroupMap) {
        if (operatorGroupMap.size() != 0) {
            QFilter qFilter11 = new QFilter("operatorgrpid", "in", operatorGroupMap.keySet());
            QFilter qFilter12 = new QFilter("operatorid", "=", (Object)userId);
            QFilter qFilter3 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
            DynamicObject operator = BusinessDataServiceHelper.loadSingle((String)"bd_operator", (String)"operatorid", (QFilter[])new QFilter[]{qFilter11, qFilter12, qFilter3});
            if (null == operator) {
                this.initDeptByOrg(orgId);
            } else {
                this.initDeptByOperator(operator, orgId);
            }
        }
    }

    private void initDeptByOrg(Long orgId) {
        List deptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
        if (deptIds != null && deptIds.size() > 0) {
            Long deptId = (Long)deptIds.get(0);
            this.getModel().setValue("dept", (Object)deptId);
            return;
        }
        deptIds = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)true);
        if (deptIds != null && deptIds.size() > 0 && deptIds.contains(orgId)) {
            this.getModel().setValue("dept", (Object)orgId);
        }
    }

    private void initDeptByOperator(DynamicObject operator, Long orgId) {
        List deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)true);
        if (deptids != null && deptids.size() > 0) {
            List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)operator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
            if (userdeptIds != null && userdeptIds.size() > 0) {
                for (Long deptId : userdeptIds) {
                    if (!deptids.contains(deptId)) continue;
                    this.getModel().setValue("dept", (Object)deptId);
                    break;
                }
            }
        } else {
            List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)operator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
            if (userdeptIds != null && userdeptIds.size() > 0) {
                Long deptId = (Long)userdeptIds.get(0);
                this.getModel().setValue("dept", (Object)deptId);
            }
        }
    }

    private void initOperatorAndGroup(long userId, Map<Object, DynamicObject> operatorGroupMap) {
        QFilter qFilter13;
        QFilter qFilter12;
        if (operatorGroupMap == null || operatorGroupMap.isEmpty()) {
            return;
        }
        QFilter qFilter11 = new QFilter("operatorgrpid", "in", operatorGroupMap.keySet());
        DynamicObject operator = BusinessDataServiceHelper.loadSingle((String)"bd_operator", (String)"operatorid,operatornumber,operatorname,operatorgrpid,opergrpnumber,opergrpname,opergrptype", (QFilter[])new QFilter[]{qFilter11, qFilter12 = new QFilter("operatorid", "=", (Object)userId), qFilter13 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue())});
        if (operator != null) {
            this.getModel().setValue("operator", operator.getPkValue());
            this.getModel().setValue("operatorgroup", (Object)operator.getLong("operatorgrpid"));
        } else {
            this.getModel().setValue("operator", null);
            this.getModel().setValue("operatorgroup", null);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name;
        super.afterAddRow(e);
        switch (name = e.getEntryProp().getName()) {
            case "billentry": {
                this.billentryAddRow(e);
                break;
            }
        }
    }

    protected void initNewBeforeEntry(int rowIndex) {
        this.getModel().setValue("invtype", (Object)688884005529250816L, rowIndex);
        this.getModel().setValue("invstatus", (Object)691928582720825344L, rowIndex);
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"location"});
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"auxpty"});
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"qtyunit2nd"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("bar_copy".equals(key)) {
            boolean aBoolean = this.getModel().getDataEntity().getBoolean("ischargeoff");
            if (aBoolean) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u51b2\u9500\u5355\u636e\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"ImBillEditPlugin_33", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if ("afterfillbatch".equals(key) || "fillbatch".equals(key)) {
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put("batchBtn", key);
            FillBatchHelper.checkCancelBeforeBatchFill((IFormView)this.getView(), (BeforeItemClickEvent)evt);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        this.subEntryUi(evt.getRow());
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        int[] curRows = BillViewHelper.getCurrentRowIndexs((IFormView)this.getView(), (String)"billentry");
        if (null != curRows && curRows.length == 1 && curRows[0] != -1) {
            this.subEntryUi(curRows[0]);
        }
    }

    private void setOperatorView(IFormView view) {
        DynamicObject operator = this.bill.getDynamicObject("operator");
        if (operator != null) {
            operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.getPkValue(), (String)"bd_operator");
            if (view.getControl("operatorphone") != null) {
                ((Label)view.getControl("operatorphone")).setText((String)operator.getDynamicObject("operatorid").get("phone"));
            }
        } else if (view.getControl("operatorphone") != null) {
            ((Label)view.getControl("operatorphone")).setText(null);
        }
        view.setEnable(Boolean.FALSE, new String[]{"operatorgroup"});
    }

    private void setAuxptyView() {
        IFormView view = this.getView();
        IDataModel bill = this.getModel();
        DynamicObjectCollection billEntrys = (DynamicObjectCollection)bill.getValue("billentry");
        if (billEntrys == null) {
            return;
        }
        for (int i = 0; i < billEntrys.size(); ++i) {
            DynamicObject material;
            DynamicObject billEntry = (DynamicObject)billEntrys.get(i);
            DynamicObject materialInvInfo = billEntry.getDynamicObject("material");
            if (materialInvInfo == null || (material = materialInvInfo.getDynamicObject("masterid")) == null) continue;
            this.setAuxptyEnable(material, i, view);
        }
    }

    private void setAuxptyEnable(DynamicObject material, int rowIndex, IFormView view) {
        Boolean isUseAuxpty = material.getBoolean("isuseauxpty");
        view.setEnable(isUseAuxpty, rowIndex, new String[]{"auxpty"});
    }

    private void setLotView() {
        IFormView view = this.getView();
        IDataModel bill = this.getModel();
        DynamicObjectCollection invBillEntrys = (DynamicObjectCollection)bill.getValue("billentry");
        if (invBillEntrys == null) {
            return;
        }
        for (int i = 0; i < invBillEntrys.size(); ++i) {
            DynamicObject invBillEntry = (DynamicObject)invBillEntrys.get(i);
            DynamicObject materialInvInfo = invBillEntry.getDynamicObject("material");
            if (materialInvInfo == null) continue;
            this.setLotEnable(materialInvInfo, i, view);
        }
    }

    private void setLotEnable(DynamicObject material, int rowIndex, IFormView view) {
        Boolean enableLot = material.getBoolean("enablelot");
        view.setEnable(enableLot, rowIndex, new String[]{"lotnumber"});
        view.setEnable(enableLot, rowIndex, new String[]{"lot"});
    }

    private DynamicObjectCollection setUnitsView() {
        IFormView view = this.getView();
        IDataModel bill = this.getModel();
        DynamicObjectCollection invBillEntrys = (DynamicObjectCollection)bill.getValue("billentry");
        if (invBillEntrys != null) {
            for (int i = 0; i < invBillEntrys.size(); ++i) {
                DynamicObject invBillEntry = (DynamicObject)invBillEntrys.get(i);
                DynamicObject materialInvInfo = invBillEntry.getDynamicObject("material");
                if (materialInvInfo == null) continue;
                this.setUnitEnable(materialInvInfo, i, view);
            }
        }
        return invBillEntrys;
    }

    private void setUnitEnable(DynamicObject material, int rowIndex, IFormView view) {
        DynamicObject masterMaterial = material.getDynamicObject("masterid");
        DynamicObject auxptyUnit = masterMaterial.getDynamicObject("auxptyunit");
        Boolean isUseUnit2nd = auxptyUnit != null;
        view.setEnable(isUseUnit2nd, rowIndex, new String[]{"qtyunit2nd"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "fillbatch": {
                FillBatchHelper.batchFill((IFormView)this.getView());
                break;
            }
            case "afterfillbatch": {
                FillBatchHelper.batchFill((IFormView)this.getView(), (String)"afterentity", (String[])needFillFields);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "unaudit": 
            case "unsubmit": {
                this.setAuxptyView();
                this.setUnitsView();
                this.setLotView();
                break;
            }
            case "scmcavbinvquery": 
            case "scmcavbinvquery1": {
                InvAvbQtyQueryHelper.setAvbQtyInfo((IFormView)this.getView());
                break;
            }
            case "batchfillentry": 
            case "afterbatchfillentry": {
                FillBatchHelper.afterBatchFillEntry((IFormView)this.getView(), (IFormPlugin)this);
                break;
            }
        }
    }

    public void beforeBatchFillEntry(BeforeBatchFillEntryArgs e) {
        FillBatchHelper.batchSetPredicate((IFormView)this.getView(), (BeforeBatchFillEntryArgs)e);
    }

    protected DynamicObject getBill() {
        return this.getBill(false);
    }

    protected DynamicObject getBill(boolean hasEntry) {
        if (this.bill == null) {
            this.bill = this.getModel().getDataEntity();
        }
        return this.bill;
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        String name = ((EntryGrid)e.getSource()).getEntryKey();
        if ("billentry".equals(name)) {
            List list = e.getRows();
            DynamicObject localBill = this.getBill();
            boolean isDraw = this.isDraw();
            for (RowDataEntity entry : list) {
                this.handleEntryEnable(localBill, entry, isDraw);
                String srcBillEntity = entry.getDataEntity().getString("srcbillentity");
                if (!"im_invinspectbill".equals(srcBillEntity)) continue;
                int rowIndex = entry.getRowIndex();
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"material", "unit", "qty"});
            }
        } else if ("afterentity".equals(name)) {
            List list = e.getRows();
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            String srcBillEntity = ((RowDataEntity)list.get(0)).getDataEntity().getString("subsrcbillentity");
            for (RowDataEntity entry : list) {
                DynamicObject materialInvInfo = (DynamicObject)entry.getDataEntity().get("material1");
                if (materialInvInfo != null) {
                    DynamicObject material = materialInvInfo.getDynamicObject("masterid");
                    this.setSubEntryByMaterial(materialInvInfo, material, entry.getRowIndex());
                }
                this.setAfterLocationEnable(entry.getDataEntity(), entry.getRowIndex(), this.getView());
                if (!"im_invinspectbill".equals(srcBillEntity)) continue;
                int rowIndex = entry.getRowIndex();
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"unit1", "material1", "qty1"});
            }
            if ("im_invinspectbill".equals(srcBillEntity)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"addrow", "addafterrow"});
            }
        }
    }

    protected void handleEntryEnable(DynamicObject bill, RowDataEntity row, boolean isDraw) {
        if ("A".equals(bill.getString("billstatus"))) {
            this.setBillEntryEnable(row);
            this.setBillEntryEnable4IsDraw(row, isDraw);
        }
    }

    protected void setBillEntryEnable(RowDataEntity row) {
        IFormView view = this.getView();
        DynamicObject material = (DynamicObject)row.getDataEntity().get("material");
        if (material != null && INVFLU_SUBTRACT.equals(material.get("masterid.configproperties"))) {
            this.getView().setEnable(Boolean.TRUE, row.getRowIndex(), new String[]{"configuredcode"});
        } else {
            this.getView().setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"configuredcode"});
        }
        if (material != null) {
            this.setEnableByMaterial(material, row.getRowIndex(), view);
        }
        this.setLocationEnable(row.getDataEntity(), row.getRowIndex(), view);
    }

    protected void setBillEntryEnable4IsDraw(RowDataEntity row, boolean isDraw) {
        IFormView view = this.getView();
        int index = row.getRowIndex();
        if (isDraw) {
            view.setEnable(Boolean.valueOf(!isDraw), index, new String[]{"unit"});
            view.setEnable(Boolean.FALSE, index, new String[]{"tracknumber", "configuredcode"});
        }
    }

    private String getOperatorGroupType() {
        return OperatorGrpTypeEnum.INVENTORYGRP.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        switch (opKey = FormUtils.getOpKey((BeforeDoOperationEventArgs)args)) {
            case "matchingruleout": {
                IFormView view = this.getView();
                String formid = this.getModel().getDataEntityType().getName();
                boolean after = false;
                String entryKey = TransformBillTplEntryConst.getEntryByBillType((String)formid, (Boolean)after);
                Map cfgs = MatchingRuleOutHandler.getInvQueryCfgs((String)formid, (String)entryKey, (String)opKey);
                if (cfgs == null || cfgs.isEmpty()) {
                    log.info("matchingruleout old");
                    try {
                        String msg = ResManager.loadKDString((String)"\u6b63\u5728\u5339\u914d\u5e93\u5b58\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"ImBillEditPlugin_35", (String)"scmc-im-formplugin", (Object[])new Object[0]);
                        LocaleString info = new LocaleString(msg);
                        view.showLoading(info);
                        new MatchingRuleOutOldTransFormHelper((AbstractBillPlugIn)this).matchingRuleOut(args);
                        break;
                    }
                    catch (Exception e) {
                        log.info("matchingruleout:" + e.getMessage());
                        throw new KDBizException(e.getMessage());
                    }
                    finally {
                        view.hideLoading();
                    }
                }
                log.info("matchingruleout new");
                try {
                    this.matchingRuleOutNew(view, formid, entryKey, opKey);
                    break;
                }
                finally {
                    view.hideLoading();
                }
            }
        }
    }

    private String getOrgViewType() {
        return "05";
    }

    private void subEntryUi(int row) {
        IDataModel model = this.getModel();
        model.setEntryCurrentRowIndex("billentry", row);
        SubEntryGrid subEntry = (SubEntryGrid)this.getControl("afterentity");
        if (subEntry == null) {
            return;
        }
        IFormView view = this.getView();
        int entryRowCount = this.getModel().getEntryRowCount("afterentity");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject materialInvInfo = (DynamicObject)this.getModel().getValue("material1", i);
            if (materialInvInfo == null) continue;
            DynamicObject material = materialInvInfo.getDynamicObject("masterid");
            this.setSubEntryByMaterial(materialInvInfo, material, i);
            this.setAfterLocationEnable(this.getModel().getEntryRowEntity("afterentity", i), i, view);
        }
    }

    public void setValue(String key, Object value, boolean isTriggerChangeEvent) {
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)key, (Object)value, (boolean)isTriggerChangeEvent);
    }

    public void setValue(String key, Object value, int i, boolean isTriggerChangeEvent) {
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)key, (Object)value, (int)i, (boolean)isTriggerChangeEvent);
    }

    protected boolean isChanged(PropertyChangedArgs e) {
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        if (newValue instanceof DynamicObject && oldValue instanceof DynamicObject && newValue != null && oldValue != null && ((DynamicObject)newValue).getPkValue().equals(((DynamicObject)oldValue).getPkValue())) {
            return false;
        }
        return !(newValue instanceof BigDecimal) || !(oldValue instanceof BigDecimal) || newValue == null || oldValue == null || ((BigDecimal)newValue).compareTo((BigDecimal)oldValue) != 0;
    }

    private void changeMaterial(DynamicObject materialInv, int rowIndex) {
        IDataModel bill = this.getModel();
        DynamicObject masterMaterial = null;
        if (materialInv != null) {
            masterMaterial = MaterialHelper.getMaterialByMatBiz((DynamicObject)materialInv);
        }
        bill.setValue("materialmasterid", (Object)masterMaterial, rowIndex);
        this.clearMaterialInfo(bill, rowIndex);
        if (materialInv == null) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"configuredcode"});
            return;
        }
        this.resetMaterialInfo(bill, materialInv, masterMaterial, rowIndex);
        this.setEnableByMaterial(materialInv, rowIndex, this.getView());
    }

    private void setEnableByMaterial(DynamicObject material, int index, IFormView view) {
        DynamicObject masterMaterial = material.getDynamicObject("masterid");
        if (masterMaterial != null) {
            this.setAuxptyEnable(masterMaterial, index, view);
        }
        this.setUnitEnable(material, index, view);
        this.setLotEnable(material, index, view);
        boolean isEnableShelfLife = material.getBoolean("enableshelflifemgr");
        view.setEnable(Boolean.valueOf(isEnableShelfLife), index, new String[]{"producedate"});
        view.setEnable(Boolean.valueOf(isEnableShelfLife), index, new String[]{"expirydate"});
    }

    private void resetMaterialInfo(IDataModel bill, DynamicObject materialInv, DynamicObject masterMaterial, int rowIndex) {
        if (masterMaterial == null) {
            return;
        }
        this.getView().setEnable(Boolean.valueOf(INVFLU_SUBTRACT.equals(masterMaterial.get("configproperties"))), rowIndex, new String[]{"configuredcode"});
        DynamicObject baseUnit = masterMaterial.getDynamicObject("baseunit");
        if (baseUnit == null) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MATERIAL_BASEUNIT(), (Object[])new Object[0]));
        }
        bill.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
        Boolean isuseauxpty = masterMaterial.getBoolean("isuseauxpty");
        this.getView().setEnable(isuseauxpty, rowIndex, new String[]{"auxpty"});
        boolean isOnShelf = materialInv.getBoolean("enableshelflifemgr");
        this.getView().setEnable(Boolean.valueOf(isOnShelf), rowIndex, new String[]{"producedate"});
        this.getView().setEnable(Boolean.valueOf(isOnShelf), rowIndex, new String[]{"expirydate"});
        DynamicObject auxptyUnit = masterMaterial.getDynamicObject("auxptyunit");
        Boolean isUseUnit2nd = auxptyUnit != null;
        if (isUseUnit2nd.booleanValue()) {
            BigDecimal unit2ndRate = BillUnitAndQtytHelper.getUnitRateConv((Long)((Long)masterMaterial.getPkValue()), (Long)((Long)auxptyUnit.getPkValue()), (Long)((Long)baseUnit.getPkValue()));
            bill.setValue("unit2nd", auxptyUnit.getPkValue(), rowIndex);
            IPageCache pageCache = this.getPageCache();
            unit2ndRate = unit2ndRate == null ? BigDecimal.ZERO : unit2ndRate;
            pageCache.put("unit2ndrate_" + rowIndex, unit2ndRate.toString());
        }
        this.getView().setEnable(isUseUnit2nd, rowIndex, new String[]{"qtyunit2nd"});
        DynamicObject unit = materialInv.getDynamicObject("inventoryunit");
        bill.setValue("unit", unit.getPkValue(), rowIndex);
        bill.setValue("lotnumber", null, rowIndex);
        Boolean enablelot = materialInv.getBoolean("enablelot");
        this.getView().setEnable(enablelot, rowIndex, new String[]{"lotnumber"});
        this.getView().setEnable(enablelot, rowIndex, new String[]{"lot"});
    }

    private void clearMaterialInfo(IDataModel bill, int rowindex) {
        this.setValue("auxpty", null, rowindex, false);
        this.setValue("unit", null, rowindex, false);
        this.setValue("qty", null, rowindex, false);
        this.setValue("baseunit", null, rowindex, false);
        this.setValue("baseqty", null, rowindex, false);
        this.setValue("unit2nd", null, rowindex, false);
        this.setValue("qtyunit2nd", null, rowindex, false);
        this.setValue("producedate", null, rowindex, false);
        this.setValue("expirydate", null, rowindex, false);
        this.setValue("configuredcode", null, rowindex, false);
    }

    private void changeAfterMaterial(DynamicObject material, int rowIndex) {
        IDataModel bill = this.getModel();
        DynamicObject masterMaterial = null;
        if (material != null) {
            masterMaterial = MaterialHelper.getMaterialByMatBiz((DynamicObject)material);
        }
        bill.setValue("materialmasterid1", (Object)masterMaterial, rowIndex);
        this.clearMaterial1Info(bill, rowIndex);
        if (material == null) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"configuredcode1"});
            return;
        }
        this.resetMaterial1Info(bill, material, masterMaterial, rowIndex);
        this.setEnableByAfterShelfLife(material, rowIndex, this.getView());
    }

    protected void setEnableByAfterShelfLife(DynamicObject entry, int index, IFormView view) {
        boolean isEnableShelfLife = entry.getBoolean("enableshelflifemgr");
        view.setEnable(Boolean.valueOf(isEnableShelfLife), index, new String[]{"producedate1"});
        view.setEnable(Boolean.valueOf(isEnableShelfLife), index, new String[]{"expirydate1"});
    }

    private void resetMaterial1Info(IDataModel bill, DynamicObject material, DynamicObject masterMaterial, int rowIndex) {
        if (masterMaterial == null) {
            return;
        }
        this.getView().setEnable(Boolean.valueOf(INVFLU_SUBTRACT.equals(masterMaterial.get("configproperties"))), rowIndex, new String[]{"configuredcode1"});
        DynamicObject baseUnit = masterMaterial.getDynamicObject("baseunit");
        if (baseUnit == null) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MATERIAL_BASEUNIT(), (Object[])new Object[0]));
        }
        bill.setValue("baseunit1", baseUnit.getPkValue(), rowIndex);
        boolean isOnShelf = material.getBoolean("enableshelflifemgr");
        this.getView().setEnable(Boolean.valueOf(isOnShelf), rowIndex, new String[]{"producedate1"});
        this.getView().setEnable(Boolean.valueOf(isOnShelf), rowIndex, new String[]{"expirydate1"});
        DynamicObject auxptyUnit = masterMaterial.getDynamicObject("auxptyunit");
        Boolean isUseUnit2nd = auxptyUnit != null;
        if (isUseUnit2nd.booleanValue()) {
            BigDecimal unit2ndRate = BillUnitAndQtytHelper.getUnitRateConv((Long)((Long)masterMaterial.getPkValue()), (Long)((Long)auxptyUnit.getPkValue()), (Long)((Long)baseUnit.getPkValue()));
            bill.setValue("unit2nd1", auxptyUnit.getPkValue(), rowIndex);
            IPageCache pageCache = this.getPageCache();
            pageCache.put("unit2ndrate1_" + rowIndex, unit2ndRate == null || unit2ndRate.compareTo(BigDecimal.ZERO) == 0 ? null : unit2ndRate.toString());
        }
        DynamicObject unit = material.getDynamicObject("inventoryunit");
        bill.setValue("unit1", unit.getPkValue(), rowIndex);
        bill.setValue("lotnumber1", null, rowIndex);
        this.setSubEntryByMaterial(material, masterMaterial, rowIndex);
    }

    protected void setSubEntryByMaterial(int subRow, int parRow) {
        DynamicObject materialInvInfo = (DynamicObject)this.getModel().getValue("material1", subRow, parRow);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        this.setSubEntryByMaterial(materialInvInfo, material, subRow);
    }

    protected void setSubEntryByMaterial(DynamicObject materialInvInfo, DynamicObject masterMaterial, int rowIndex) {
        String number;
        DynamicObject bizTypeObj;
        if (this.isDraw()) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"configuredcode1", "tracknumber1"});
        }
        if (materialInvInfo == null || masterMaterial == null) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"auxpty1"});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"qtyunit2nd1"});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"configuredcode1"});
            return;
        }
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"configuredcode1"});
        if (INVFLU_SUBTRACT.equals(masterMaterial.get("configproperties")) && (bizTypeObj = (DynamicObject)this.getModel().getValue("biztype")) != null && !"511".equals(number = bizTypeObj.getString("number"))) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"configuredcode1"});
        }
        Boolean isuseauxpty = masterMaterial.getBoolean("isuseauxpty");
        this.getView().setEnable(isuseauxpty, rowIndex, new String[]{"auxpty1"});
        DynamicObject auxptyUnit = masterMaterial.getDynamicObject("auxptyunit");
        Boolean isUseUnit2nd = auxptyUnit != null;
        this.getView().setEnable(isUseUnit2nd, rowIndex, new String[]{"qtyunit2nd1"});
        Boolean enablelot = materialInvInfo.getBoolean("enablelot");
        this.getView().setEnable(enablelot, rowIndex, new String[]{"lotnumber1"});
        this.getView().setEnable(enablelot, rowIndex, new String[]{"lot1"});
        this.setEnableByAfterShelfLife(materialInvInfo, rowIndex, this.getView());
    }

    private void clearMaterial1Info(IDataModel bill, int rowIndex) {
        this.setValue("auxpty1", null, rowIndex, false);
        this.setValue("unit1", null, rowIndex, false);
        this.setValue("qty1", null, rowIndex, false);
        this.setValue("baseunit1", null, rowIndex, false);
        this.setValue("baseqty1", null, rowIndex, false);
        this.setValue("unit2nd1", null, rowIndex, false);
        this.setValue("qtyunit2nd1", null, rowIndex, false);
        this.setValue("producedate1", null, rowIndex, false);
        this.setValue("expirydate1", null, rowIndex, false);
        this.setValue("configuredcode1", null, rowIndex, false);
    }

    protected void changeQtyOrUnit(String propName, Object newValue, int rowIndex) {
        Object material;
        if ("unit".equals(propName)) {
            this.getView().setEnable(Boolean.valueOf(newValue != null), rowIndex, new String[]{"qty"});
        }
        IDataModel bill = this.getModel();
        Object masterMaterial = material = bill.getValue("material", rowIndex);
        masterMaterial = bill.getValue("materialmasterid", rowIndex);
        if (StringUtils.isBlank((Object)material) && StringUtils.isBlank((Object)masterMaterial)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"BillBizQtyPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        BillUnitAndQtytHelper.setBizQtyAndUnit((IDataModel)bill, (int)rowIndex, (String)propName, (Object)newValue);
        AuxQtyAndUnitHelper.setAuxBizQtyAndUnit((IPageCache)this.getPageCache(), (IDataModel)bill, (int)rowIndex, (String)propName, (Object)newValue);
        BillViewHelper.updateViewRow((IFormView)this.getView(), (int)rowIndex, (String)"billentry");
    }

    protected void changeQty1OrUnit1(String propName, Object newValue, int rowIndex, int parentRowIndex) {
        IDataModel bill;
        DynamicObjectCollection afterEntry;
        if ("unit1".equals(propName)) {
            this.getView().setEnable(Boolean.valueOf(newValue != null), rowIndex, new String[]{"qty1"});
        }
        if ((afterEntry = (DynamicObjectCollection)(bill = this.getModel()).getValue("afterentity", parentRowIndex)) == null || afterEntry.size() == 0) {
            return;
        }
        this.setAfterBizQtyAndUnit(bill, rowIndex, parentRowIndex, propName, newValue);
        this.setAfterAuxBizQtyAndUnit(bill, rowIndex, parentRowIndex, propName, newValue);
        BillViewHelper.updateViewRow((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (String)"afterentity");
    }

    public void setAfterAuxBizQtyAndUnit(IDataModel bill, int rowindex, int parentRowIndex, String fieldName, Object newValue) {
        DynamicObject materialInvInfo = (DynamicObject)bill.getValue("material1", rowindex, parentRowIndex);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MATERIAL_INV()));
        }
        DynamicObject unit2nd = material.getDynamicObject("auxptyunit");
        Boolean isUseUnit2nd = unit2nd != null;
        if (!isUseUnit2nd.booleanValue()) {
            return;
        }
        BigDecimal baseQty = (BigDecimal)bill.getValue("baseqty1", rowindex, parentRowIndex);
        BigDecimal qty = (BigDecimal)bill.getValue("qty1", rowindex, parentRowIndex);
        DynamicObject unit = (DynamicObject)bill.getValue("unit1", rowindex, parentRowIndex);
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit1", rowindex, parentRowIndex);
        if (unit == null) {
            return;
        }
        String unitConvertDir = material.getString("unitconvertdir");
        BigDecimal qtyUnit2nd = (BigDecimal)bill.getValue("qtyunit2nd1", rowindex, parentRowIndex);
        BigDecimal unit2ndRate = AuxQtyAndUnitHelper.getRateCache((IPageCache)this.getPageCache(), (DynamicObject)material, (String)("unit2ndrate1_" + rowindex));
        if (unit2ndRate == null || Constants.ZERO.compareTo(unit2ndRate) == 0) {
            return;
        }
        unit2ndRate = unit2ndRate.setScale(10);
        boolean isConvert = false;
        switch (fieldName) {
            case "qty1": 
            case "unit1": {
                if ("qty1".equals(fieldName)) {
                    qty = (BigDecimal)newValue;
                    BigDecimal unitRate1 = this.getUnitRateConv((Long)material.getPkValue(), (Long)unit.getPkValue(), (Long)baseUnit.getPkValue());
                    if (unitRate1 != null) {
                        baseQty = qty.multiply(unitRate1);
                    }
                }
                boolean bl = isConvert = UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
                if (!isConvert || unit2ndRate.compareTo(BigDecimal.ZERO) == 0) break;
                qtyUnit2nd = BigDecimal.valueOf(baseQty.doubleValue() / unit2ndRate.doubleValue());
                DynamicObject afterUnit2nd = (DynamicObject)bill.getValue("unit2nd1", rowindex, parentRowIndex);
                qtyUnit2nd = PrecisionAccountHelper.dealWithprecision((DynamicObject)afterUnit2nd, (BigDecimal)qtyUnit2nd);
                BigDecimalUtils.showBigDecimalErrorTip((IDataModel)bill, (BigDecimal)qtyUnit2nd, (String)"qtyunit2nd1");
                bill.beginInit();
                bill.setValue("qtyunit2nd1", (Object)qtyUnit2nd, rowindex, parentRowIndex);
                bill.endInit();
                break;
            }
            case "qtyunit2nd1": {
                BigDecimal unitRate = this.getUnitRateConv((Long)material.getPkValue(), (Long)unit.getPkValue(), baseUnit == null ? null : (Long)baseUnit.getPkValue());
                if (unitRate == null) break;
                unitRate = unitRate.setScale(10);
                boolean bl = isConvert = UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
                if (!isConvert) break;
                baseQty = qtyUnit2nd.multiply(unit2ndRate);
                baseQty = PrecisionAccountHelper.dealWithprecision((IDataModel)bill, (String)"baseunit1", (int)rowindex, (BigDecimal)baseQty);
                qty = baseQty.divide(unitRate, 10, RoundingMode.HALF_UP);
                qty = PrecisionAccountHelper.dealWithprecision((IDataModel)bill, (String)"unit1", (int)rowindex, (BigDecimal)qty);
                BigDecimalUtils.showBigDecimalErrorTip((IDataModel)bill, (BigDecimal)baseQty, (String)"baseqty1");
                BigDecimalUtils.showBigDecimalErrorTip((IDataModel)bill, (BigDecimal)qty, (String)"qty1");
                bill.beginInit();
                bill.setValue("baseqty1", (Object)baseQty, rowindex);
                bill.setValue("qty1", (Object)qty, rowindex);
                bill.endInit();
                break;
            }
        }
    }

    public void setAfterBizQtyAndUnit(IDataModel bill, int rowindex, int parentRowIndex, String fieldName, Object newValue) {
        BigDecimal baseQty = (BigDecimal)bill.getValue("baseqty1", rowindex, parentRowIndex);
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit1", rowindex, parentRowIndex);
        DynamicObject material = (DynamicObject)bill.getValue("material1", rowindex, parentRowIndex);
        DynamicObject masterMaterial = MaterialHelper.getMaterialByMatBiz((DynamicObject)material);
        BigDecimal qty = (BigDecimal)bill.getValue("qty1", rowindex, parentRowIndex);
        DynamicObject unit = (DynamicObject)bill.getValue("unit1", rowindex, parentRowIndex);
        BigDecimal unitRate = null;
        if (masterMaterial != null && baseUnit != null && unit != null) {
            unitRate = this.getUnitRateConv((Long)masterMaterial.getPkValue(), (Long)unit.getPkValue(), (Long)baseUnit.getPkValue());
        }
        if (unitRate != null) {
            unitRate = unitRate.setScale(10, 4);
        }
        switch (fieldName) {
            case "qty1": {
                qty = (BigDecimal)newValue;
                qty = BigDecimal.ZERO.max(qty);
                if (unitRate != null) {
                    baseQty = qty.multiply(unitRate);
                    DynamicObject afterUnit = (DynamicObject)bill.getValue("baseunit1", rowindex, parentRowIndex);
                    baseQty = PrecisionAccountHelper.dealWithprecision((DynamicObject)afterUnit, (BigDecimal)baseQty);
                }
                BigDecimalUtils.showBigDecimalErrorTip((IDataModel)bill, (BigDecimal)baseQty, (String)"baseqty1");
                bill.setValue("baseqty1", (Object)baseQty, rowindex, parentRowIndex);
                bill.setValue("qty1", (Object)qty, rowindex, parentRowIndex);
                break;
            }
            case "unit1": {
                unit = (DynamicObject)newValue;
                if (unit != null) {
                    int precision = unit.getInt("precision");
                    String precisionaccountStr = unit.getString("precisionaccount");
                    int precisionaccount = 4;
                    if (!StringUtils.isEmpty((CharSequence)precisionaccountStr)) {
                        precisionaccount = Integer.parseInt(precisionaccountStr);
                    }
                    qty = qty.setScale(precision, precisionaccount);
                    BigDecimalUtils.showBigDecimalErrorTip((IDataModel)bill, (BigDecimal)qty, (String)"qty1");
                    bill.setValue("qty1", (Object)qty, rowindex, parentRowIndex);
                }
                if (masterMaterial != null && unit != null && baseUnit != null) {
                    unitRate = this.getUnitRateConv((Long)masterMaterial.getPkValue(), (Long)unit.getPkValue(), (Long)baseUnit.getPkValue());
                }
                if (unitRate != null) {
                    baseQty = qty.multiply(unitRate);
                }
                BigDecimalUtils.showBigDecimalErrorTip((IDataModel)bill, (BigDecimal)baseQty, (String)"baseqty1");
                bill.setValue("baseqty1", (Object)baseQty, rowindex, parentRowIndex);
                break;
            }
        }
    }

    private static void showQtyErrorTip(BigDecimal qtyAmount) {
        CommonUtils.showQtyErrorTip((BigDecimal)qtyAmount);
    }

    public BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            unitRate = Constants.ZERO;
        } else if (srcUnitId.equals(desUnitId)) {
            unitRate = Constants.ONE;
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
            if (muConv != null && muConv.getInt("numerator") != 0) {
                unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4);
            }
        }
        if (unitRate == null) {
            unitRate = Constants.ZERO;
        }
        return unitRate;
    }

    private void changeOrg(Object newValue) {
        Map customParas = this.getView().getFormShowParameter().getCustomParams();
        if (customParas != null && customParas.get("sourceformid") != null && customParas.get("orgViewType") != null) {
            this.getModel().setValue("dept", null);
            this.getModel().setValue("operatorgroup", null);
            this.getModel().setValue("operator", null);
        }
    }

    private void changeOperator(DynamicObject operator, String propName) {
        if (operator == null) {
            this.setValue("operatorgroup", null, false);
            this.setValue("dept", null, false);
        } else {
            operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.getPkValue(), (String)"bd_operator");
            this.setValue("operatorgroup", operator.get("operatorgrpid"), false);
            DynamicObject org = this.getOrgDyc();
            List deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)((Long)org.getPkValue()), (boolean)false);
            if (deptids != null && deptids.size() > 0) {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)operator.getDynamicObject("operatorid").getPkValue()), (boolean)false);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    for (Long deptId : userdeptIds) {
                        if (!deptids.contains(deptId)) continue;
                        this.setValue("dept", deptId, false);
                        break;
                    }
                }
            } else {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)operator.getDynamicObject("operatorid").getPkValue()), (boolean)false);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    this.setValue("dept", userdeptIds.get(0), false);
                }
            }
        }
    }

    private void changeOperatorGroup(DynamicObject operatorGroup) {
        if (operatorGroup == null) {
            this.setValue("operator", null, false);
        }
    }

    private void changeDept(DynamicObject operatorDept) {
    }

    private void changeBizData(Object newValue) {
        String formId = this.getModel().getDataEntityType().getName();
        if ("im_initbill".equals(formId)) {
            return;
        }
        Date bizDate = (Date)newValue;
        if (bizDate == null) {
            return;
        }
        DynamicObject org = this.getOrgDyc();
        LocaleString bizTimeName = this.getModel().getDataEntityType().findProperty("biztime").getDisplayName();
        Date now = new Date();
        TimeZone orgZone = this.getOrgZone(org);
        if (orgZone == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u201c\u7ec4\u7ec7\u65f6\u533a\u201d\u548c\u201c\u7cfb\u7edf\u65f6\u533a\u201d\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImTransformBillEditPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        int fallowDays = 0;
        int differDays = 0;
        boolean before = false;
        if (now.before(bizDate)) {
            Object beforeDays = AppParameterHelper.getAppParameter((String)"=9Q86DR2P+Q", (String)"05", (Long)((Long)org.getPkValue()), (String)"fallowbeforedays");
            differDays = DaysCalcHelper.differentDays((Date)bizDate, (Date)now, (ZoneId)orgZone.toZoneId());
            differDays = Math.abs(differDays);
            fallowDays = Integer.parseInt(beforeDays == null ? "0" : beforeDays.toString());
            before = true;
        } else if (now.after(bizDate)) {
            Object afterDays = AppParameterHelper.getAppParameter((String)"=9Q86DR2P+Q", (String)"05", (Long)((Long)org.getPkValue()), (String)"fallowafterdays");
            differDays = DaysCalcHelper.differentDays((Date)bizDate, (Date)now, (ZoneId)orgZone.toZoneId());
            differDays = Math.abs(differDays);
            fallowDays = Integer.parseInt(afterDays == null ? "0" : afterDays.toString());
        }
        if (differDays > fallowDays) {
            String tip = before ? ResManager.loadKDString((String)"\u5141\u8bb8\u63d0\u524d\u5f55\u5355\u671f\u9650", (String)"ImBillPropChanged_16", (String)"scmc-im-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5141\u8bb8\u4e8b\u540e\u8865\u5f55\u671f\u9650", (String)"ImBillPropChanged_17", (String)"scmc-im-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(IMStringUtils.append((String)bizTimeName.getLocaleValue(), (Object[])new Object[]{String.format(ResManager.loadKDString((String)"\u8d85\u51fa%s\uff0c\u5982\u4ecd\u9700\u63d0\u4ea4\u5355\u636e\uff0c\u8bf7\u5230\u7cfb\u7edf\u53c2\u6570\u4e2d\u4fee\u6539\u76f8\u5173\u8bbe\u7f6e\u3002", (String)"ImTransformBillEditPlugin_2", (String)"scmc-im-formplugin", (Object[])new Object[0]), tip)}));
            return;
        }
        this.changeBookDate(bizDate);
    }

    private void changeBookDate(Date bizDate) {
        Date closeDate;
        Date addDate;
        DynamicObject bill;
        Map closeDateMap;
        String formId = this.getModel().getDataEntityType().getName();
        Date bookDate = bizDate;
        if (!SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0004") && null != (closeDateMap = CloseDateHelper.getCloseDateMap((String)formId, (DynamicObject)(bill = this.getModel().getDataEntity(true)))) && bizDate.before(addDate = DateUtils.addOneDay((Date)(closeDate = (Date)closeDateMap.get("closeDate"))))) {
            bookDate = addDate;
        }
        this.getModel().setValue("bookdate", (Object)bookDate);
    }

    protected TimeZone getOrgZone(DynamicObject org) {
        TimeZone timeZone = null;
        DynamicObject timezone = org.getDynamicObject("timezone");
        if (timezone == null) {
            timeZone = this.getSysTimezone();
        } else {
            String timeArea = timezone.getString("number");
            timeZone = TimeZone.getTimeZone(timeArea);
        }
        return timeZone;
    }

    protected TimeZone getSysTimezone() {
        DynamicObject sysTimezoneMeta = this.service.getSysTimezone();
        String timeArea = sysTimezoneMeta.getString("number");
        return TimeZone.getTimeZone(timeArea);
    }

    private void changeWarehouse(ChangeData[] valueSet) {
        for (int i = 0; i < valueSet.length; ++i) {
            Object oldValue;
            Object newValue = valueSet[i].getNewValue();
            if (newValue == (oldValue = valueSet[i].getOldValue())) continue;
            int rowindex = valueSet[i].getRowIndex();
            this.getModel().setValue("location", null, rowindex);
            if (newValue != null) {
                boolean isopenlocation = ((DynamicObject)newValue).getBoolean("isopenlocation");
                if (isopenlocation) {
                    this.getView().setEnable(Boolean.TRUE, rowindex, new String[]{"location"});
                    continue;
                }
                this.getView().setEnable(Boolean.FALSE, rowindex, new String[]{"location"});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, rowindex, new String[]{"location"});
        }
    }

    private void changeBillType(DynamicObject billType) {
        if (billType == null) {
            return;
        }
        String formId = this.getModel().getDataEntityType().getName();
        DynamicObject bizType = null;
        List bizTypes = BizTypeHelper.getBizTypeByEntityID((String)formId);
        if (!bizTypes.isEmpty()) {
            bizType = BizTypeHelper.getBizTypeByBillType((String)formId, (DynamicObject)billType);
        }
        if (bizType != null) {
            this.getModel().setValue("biztype", bizType.getPkValue());
        }
    }

    private void update2Version(DynamicObject materialInvInfo, int rowIndex, String version) {
        if (materialInvInfo == null) {
            this.getModel().setValue(version, null, rowIndex);
            return;
        }
        try {
            String versionId = (String)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataService", (String)"getVersionByMaterial", (Object[])new Object[]{materialInvInfo.getLong("masterid_id")});
            if (StringUtils.isNotBlank((CharSequence)versionId) && !"0".equals(versionId)) {
                this.getModel().setValue(version, (Object)Long.valueOf(versionId), rowIndex);
            } else {
                this.getModel().setValue(version, null, rowIndex);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7269\u6599\u7248\u672c\u201c\u67e5\u8be2\u670d\u52a1\u201d\u51fa\u9519\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ImTransformBillEditPlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject getOrgDyc() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"ImTransformBillEditPlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        return org;
    }

    private void changeProduceDate(Object oldValue, Object newValue, int rowIndex, String propName) {
        String entry = "billentry";
        if (!propName.equals("producedate")) {
            entry = "afterentity";
        }
        this.changeProduceDateForAll(oldValue, (Date)newValue, rowIndex, propName, entry);
    }

    private void changeProduceDateForAll(Object oldValue, Date date, int rowIndex, String key, String entryName) {
        DynamicObject materialInvInfo;
        if (date == null) {
            return;
        }
        String materialKey = "material";
        if ("producedate1".equals(key)) {
            materialKey = "material1";
        }
        if ((materialInvInfo = (DynamicObject)this.getModel().getValue(materialKey, rowIndex)) == null || !materialInvInfo.getBoolean("enableshelflifemgr")) {
            return;
        }
        if (!MaterialHelper.isCalShelflife((DynamicObject)materialInvInfo, (boolean)true)) {
            Date expirydate = null;
            expirydate = "producedate".equals(key) ? (Date)this.getModel().getValue("expirydate", rowIndex) : (Date)this.getModel().getValue("expirydate1", rowIndex);
            this.checkShelflifeDate(date, expirydate, rowIndex, key, materialInvInfo);
            return;
        }
        String shelflifeUnit = materialInvInfo.getString("shelflifeunit");
        int shelflife = materialInvInfo.getInt("shelflife");
        String calculationForEndDate = materialInvInfo.getString("calculationforenddate");
        String leadTimeUnit = materialInvInfo.getString("leadtimeunit");
        int dateOfOverdueForIn = materialInvInfo.getInt("dateofoverdueforin");
        int dateOfOverdueForOut = materialInvInfo.getInt("dateofoverdueforout");
        Date expirydate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)shelflife, (Date)date, (String)calculationForEndDate);
        if (expirydate.before(date)) {
            String newExpirydateStr = this.getDateStr(expirydate);
            String newProduceDateStr = this.getDateStr(date);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u5230\u671f\u65e5\u671f\u6216\u786e\u8ba4 \u7269\u6599\u5e93\u5b58\u4fe1\u606f \u7684\u201c\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u201d\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImTransformBillEditPlugin_6", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            this.setValue(key, null, rowIndex, false);
            return;
        }
        String billName = this.getModel().getDataEntityType().getName();
        boolean isOutBill = InvBillHelper.isOutEntry((String)billName, (String)entryName);
        boolean isInBill = InvBillHelper.isInEntry((String)billName, (String)entryName);
        int dateOfOverdue = 0;
        if (isOutBill && isInBill) {
            dateOfOverdue = dateOfOverdueForOut > dateOfOverdueForIn ? dateOfOverdueForOut : dateOfOverdueForIn;
        } else if (isOutBill) {
            dateOfOverdue = dateOfOverdueForOut;
        } else if (isInBill) {
            dateOfOverdue = dateOfOverdueForIn;
        }
        Date overdueDate = ShelfLifeDateUtil.getDateOfOverdue((String)leadTimeUnit, (int)dateOfOverdue, (Date)expirydate);
        Date nowDate = new Date();
        boolean dateOver = nowDate.after(overdueDate);
        if (dateOver) {
            ArrayList alertMsgList = new ArrayList(2);
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            String dateStr = this.getDateStr(date);
            String oldDateStr = this.getDateStr((Date)oldValue);
            String expirydateStr = this.getDateStr(expirydate);
            params.put("oldProduceDate", oldDateStr);
            params.put("newProduceDate", dateStr);
            params.put("newExpirydate", expirydateStr);
            params.put("index", rowIndex);
            params.put("changeKey", key);
            alertMsgList.add(params);
            ConfirmCallBackListener cb = new ConfirmCallBackListener("producedate", (IFormPlugin)this);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s\u201d\u5230\u671f\u65e5\u671f\u4e3a\u201c%3$s\u201d,\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u662f\u5426\u5141\u8bb8\u5f55\u5165\uff1f", (String)"ImTransformBillEditPlugin_5", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), expirydateStr);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(alertMsgList));
        } else if ("producedate".equals(key)) {
            this.setValue("expirydate", expirydate, rowIndex, false);
        } else {
            this.setValue("expirydate1", expirydate, rowIndex, false);
        }
    }

    private void changeExpirydate(Object oldValue, Object newValue, int rowIndex, String propName) {
        String entry = "billentry";
        if (!propName.equals("expirydate")) {
            entry = "afterentity";
        }
        this.changeExpirydateForAll(oldValue, (Date)newValue, rowIndex, propName, entry);
    }

    private void changeExpirydateForAll(Object oldValue, Date date, int rowIndex, String key, String entryName) {
        Date oldProducedate;
        DynamicObject materialInvInfo;
        if (date == null) {
            return;
        }
        String materialKey = "material";
        String producedateKey = "producedate";
        if ("expirydate1".equals(key)) {
            materialKey = "material1";
            producedateKey = "producedate1";
        }
        if ((materialInvInfo = (DynamicObject)this.getModel().getValue(materialKey, rowIndex)) == null || !materialInvInfo.getBoolean("enableshelflifemgr")) {
            return;
        }
        if (!MaterialHelper.isCalShelflife((DynamicObject)materialInvInfo, (boolean)false)) {
            Date oldProducedate2 = (Date)this.getModel().getValue(producedateKey, rowIndex);
            this.checkShelflifeDate(oldProducedate2, date, rowIndex, key, materialInvInfo);
            return;
        }
        String shelflifeUnit = materialInvInfo.getString("shelflifeunit");
        int shelflife = materialInvInfo.getInt("shelflife");
        String calculationForEndDate = materialInvInfo.getString("calculationforenddate");
        Date producedate = oldProducedate = (Date)this.getModel().getValue(producedateKey, rowIndex);
        if (!INVFLU_SUBTRACT.equals(calculationForEndDate)) {
            producedate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(shelflife * -1), (Date)date, (String)calculationForEndDate);
        } else if (producedate != null && date.before(producedate)) {
            Date oldExpirydate = (Date)oldValue;
            if (oldExpirydate != null && oldExpirydate.before(producedate)) {
                oldExpirydate = null;
            }
            String newExpirydateStr = this.getDateStr(date);
            String newProduceDateStr = this.getDateStr(producedate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u5230\u671f\u65e5\u671f\u6216\u786e\u8ba4 \u7269\u6599\u5e93\u5b58\u4fe1\u606f \u7684\u201c\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u201d\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImTransformBillEditPlugin_6", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            this.setValue(key, oldExpirydate, rowIndex, false);
            return;
        }
        ArrayList<Map<Object, Object>> confirmList = new ArrayList<Map<Object, Object>>(2);
        HashMap<String, Object> confirmMap = new HashMap<String, Object>(16);
        confirmMap.put("entryIndex", rowIndex);
        confirmMap.put("key", key);
        confirmMap.put("entryName", entryName);
        confirmMap.put("materialInvInfo", materialInvInfo);
        confirmMap.put("oldExpiryDate", oldValue);
        confirmMap.put("expiryDate", date);
        confirmMap.put("produceDate", producedate);
        confirmList.add(confirmMap);
        this.showExpiryDateConfirm(confirmList);
    }

    protected void showExpiryDateConfirm(List<Map<Object, Object>> confirmList) {
        StringBuilder alertMsg = new StringBuilder();
        ArrayList alertMsgList = new ArrayList(16);
        for (int i = 0; i < confirmList.size(); ++i) {
            Map<Object, Object> confirmMap = confirmList.get(i);
            int rowIndex = (Integer)confirmMap.get("entryIndex");
            String key = (String)confirmMap.get("key");
            String entryName = (String)confirmMap.get("entryName");
            DynamicObject materialInvInfo = (DynamicObject)confirmMap.get("materialInvInfo");
            Object oldExpiryDate = confirmMap.get("oldExpiryDate");
            Date newExpiryDate = (Date)confirmMap.get("expiryDate");
            Date producedate = (Date)confirmMap.get("produceDate");
            if (newExpiryDate == null) {
                return;
            }
            String billName = this.getModel().getDataEntityType().getName();
            boolean isOutBill = InvBillHelper.isOutEntry((String)billName, (String)entryName);
            boolean isInBill = InvBillHelper.isInEntry((String)billName, (String)entryName);
            String leadTimeUnit = materialInvInfo.getString("leadtimeunit");
            int dateOfOverdueForIn = materialInvInfo.getInt("dateofoverdueforin");
            int dateOfOverdueForOut = materialInvInfo.getInt("dateofoverdueforout");
            int dateOfOverdue = 0;
            if (isOutBill && isInBill) {
                dateOfOverdue = dateOfOverdueForOut > dateOfOverdueForIn ? dateOfOverdueForOut : dateOfOverdueForIn;
            } else if (isOutBill) {
                dateOfOverdue = dateOfOverdueForOut;
            } else if (isInBill) {
                dateOfOverdue = dateOfOverdueForIn;
            }
            Date overdueDate = ShelfLifeDateUtil.getDateOfOverdue((String)leadTimeUnit, (int)dateOfOverdue, (Date)newExpiryDate);
            Date nowDate = new Date();
            boolean dateOver = nowDate.after(overdueDate);
            if (dateOver) {
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                String dateStr = this.getDateStr(newExpiryDate);
                String oldDateStr = this.getDateStr((Date)oldExpiryDate);
                String producedateStr = this.getDateStr(producedate);
                params.put("newProduceDate", producedateStr);
                params.put("oldProduceDate", oldDateStr);
                params.put("newExpirydate", dateStr);
                params.put("index", rowIndex);
                params.put("changeKey", key);
                alertMsgList.add(params);
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s\u201d\u5230\u671f\u65e5\u671f\u4e3a\u201c%3$s\u201d,\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u662f\u5426\u5141\u8bb8\u5f55\u5165\uff1f", (String)"ImTransformBillEditPlugin_5", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), dateStr);
                alertMsg.append(msg);
                continue;
            }
            if ("expirydate".equals(key)) {
                this.setValue("producedate", producedate, rowIndex, false);
                continue;
            }
            this.setValue("producedate1", producedate, rowIndex, false);
        }
        if (alertMsg.length() > 0) {
            ConfirmCallBackListener cb = new ConfirmCallBackListener("expirydate", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\u7269\u6599\u3002", (String)"ImBillPropChanged_12", (String)"scmc-im-formplugin", (Object[])new Object[0]), alertMsg.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(alertMsgList));
        }
    }

    protected String getDateStr(Date date) {
        String dateStr = null;
        if (date == null) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        dateStr = sd.format(date);
        return dateStr;
    }

    protected Date parseDate(String dateStr) {
        Date date = null;
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sd.parse(dateStr);
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u65e5\u671f\u201d\u8f6c\u6362\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImTransformBillEditPlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        return date;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("cb_matchruleout_new".equals(callBackId)) {
            MatchingRuleOutNewHelper.confirmCallBack((IFormView)this.getView(), (MessageBoxClosedEvent)e);
            return;
        }
        MessageBoxResult result = e.getResult();
        DynamicObject biztype = this.getModel().getDataEntity().getDynamicObject("biztype");
        String number = "";
        if (biztype != null) {
            number = biztype.getString("number");
        }
        String customVaule = e.getCustomVaule();
        if ("bar_matchingrule".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                if (!StringUtils.isEmpty((CharSequence)customVaule)) {
                    List entryInfoList = (List)SerializationUtils.fromJsonString((String)customVaule, ArrayList.class);
                    String formId = this.getModel().getDataEntityType().getName();
                    boolean after = false;
                    if (entryInfoList.size() > 0) {
                        new MatchingRuleOutOldTransFormHelper((AbstractBillPlugIn)this).insertEntry(entryInfoList, after, formId);
                    }
                }
            } else {
                MatchingRuleOutHelper.resetMatchInfoPageCache((IFormView)this.getView());
            }
            return;
        }
        List entryInfoList = (List)SerializationUtils.fromJsonString((String)customVaule, ArrayList.class);
        this.setDate(number, callBackId, result, entryInfoList);
    }

    private void setDate(String number, String callBackId, MessageBoxResult result, List<Map<String, Object>> entryInfoList) {
        for (Map<String, Object> params : entryInfoList) {
            int rowIndex = (Integer)params.get("index");
            boolean change = this.afterentityChange(rowIndex, number);
            String changeKey = (String)params.get("changeKey");
            Date newExpirydate = this.parseDate((String)params.get("newExpirydate"));
            Date newProducedate = this.parseDate((String)params.get("newProduceDate"));
            switch (callBackId) {
                case "MaterialLifeDate": {
                    Boolean isAfter = (Boolean)params.get("isAfter");
                    String producedateId = "producedate";
                    String expirydateId = "expirydate";
                    if (isAfter.booleanValue()) {
                        producedateId = "producedate1";
                        expirydateId = "expirydate1";
                    }
                    if (MessageBoxResult.Yes.equals((Object)result)) {
                        this.setValue(expirydateId, newExpirydate, rowIndex, false);
                        this.setValue(producedateId, newProducedate, rowIndex, false);
                        break;
                    }
                    this.setValue(producedateId, null, rowIndex, false);
                    this.setValue(expirydateId, null, rowIndex, false);
                    break;
                }
                case "producedate": {
                    if (MessageBoxResult.Yes.equals((Object)result)) {
                        if ("producedate".equals(changeKey)) {
                            this.setValue("expirydate", newExpirydate, rowIndex, false);
                            if (!change) break;
                            this.setValue("expirydate1", newExpirydate, rowIndex, false);
                            break;
                        }
                        this.setValue("expirydate1", newExpirydate, rowIndex, false);
                        break;
                    }
                    if ("producedate".equals(changeKey)) {
                        this.setValue("producedate", null, rowIndex, false);
                        this.setValue("expirydate", null, rowIndex, false);
                        break;
                    }
                    this.setValue("producedate1", null, rowIndex, false);
                    this.setValue("expirydate1", null, rowIndex, false);
                    break;
                }
                case "expirydate": {
                    Date newProduceDate = this.parseDate((String)params.get("newProduceDate"));
                    if (MessageBoxResult.Yes.equals((Object)result)) {
                        if ("expirydate".equals(changeKey)) {
                            this.setValue("producedate", newProduceDate, rowIndex, false);
                            if (!change) break;
                            this.setValue("producedate1", newProduceDate, rowIndex, false);
                            break;
                        }
                        this.setValue("producedate1", newProduceDate, rowIndex, false);
                        break;
                    }
                    if ("expirydate".equals(changeKey)) {
                        this.setValue("producedate", null, rowIndex, false);
                        this.setValue("expirydate", null, rowIndex, false);
                        break;
                    }
                    this.setValue("producedate1", null, rowIndex, false);
                    this.setValue("expirydate1", null, rowIndex, false);
                    break;
                }
            }
        }
    }

    private boolean afterentityChange(int rowIndex, String biztypeNumber) {
        boolean exist;
        String entityName = this.getModel().getDataEntityType().getName();
        ArrayList<String> notChangeAfterDateList = new ArrayList<String>(2);
        notChangeAfterDateList.add("im_assembbill");
        notChangeAfterDateList.add("im_disassemblebill");
        if (notChangeAfterDateList.contains(entityName)) {
            return false;
        }
        boolean change = false;
        ArrayList<String> biztypeNumberList = new ArrayList<String>(2);
        biztypeNumberList.add("510");
        int entryRowCount = this.getModel().getEntryRowCount("afterentity");
        boolean bl = exist = entryRowCount >= rowIndex + 1;
        if (exist) {
            return !biztypeNumberList.contains(biztypeNumber);
        }
        return change;
    }

    private void handleSNNumber(ItemClickEvent evt) {
        long locationId;
        IDataModel model = this.getModel();
        MainEntityType billtypeEntity = model.getDataEntityType();
        String billtype = billtypeEntity.getName();
        String itemKey = evt.getItemKey();
        String entryName = "billentry";
        EntryGrid billentry = (EntryGrid)this.getView().getControl(entryName);
        int[] selectRows = billentry.getSelectRows();
        if (selectRows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"SelectOneEntryToHandleSerialNumber", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject entry = (DynamicObject)model.getEntryEntity(entryName).get(selectRows[0]);
        DynamicObject material = entry.getDynamicObject("material");
        String serialQtyKey = SerialNumberHelper.getSerialQtyKey((String)billtype, (String)entryName, (Long)((Long)model.getDataEntity().getPkValue()), (String)"baseqty");
        String serialUnitKey = SerialNumberHelper.getSerialUnitKey((MainEntityType)billtypeEntity, (String)entryName, (String)serialQtyKey);
        DynamicObject unit = entry.getDynamicObject(serialUnitKey);
        BigDecimal qty = entry.getBigDecimal(serialQtyKey);
        DynamicObject warehouse = entry.getDynamicObject("warehouse");
        long warehouseId = warehouse == null ? 0L : (Long)warehouse.getPkValue();
        DynamicObject location = entry.getDynamicObject("location");
        long l = locationId = location == null ? 0L : (Long)location.getPkValue();
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u3002", (String)"MaterialIsNull", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!material.getBoolean("enableserial")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u672a\u542f\u7528\u5e8f\u5217\u53f7\u7ba1\u7406\uff0c\u65e0\u6cd5\u5904\u7406\u5e8f\u5217\u53f7\u3002", (String)"UnEnableSerialCanNotHandleSerialNumber", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        this.commonhandleSerialNumber(itemKey, entryName, entry, material, unit, qty, warehouseId, locationId);
    }

    private void handleSubSNNumber(ItemClickEvent evt) {
        long locationId;
        IDataModel model = this.getModel();
        MainEntityType billtypeEntity = model.getDataEntityType();
        String billtype = billtypeEntity.getName();
        String itemKey = evt.getItemKey();
        String entryName = "afterentity";
        EntryGrid billentry = (EntryGrid)this.getView().getControl(entryName);
        int[] selectRows = billentry.getSelectRows();
        if (selectRows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"SelectOneEntryToHandleSerialNumber", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject entry = (DynamicObject)model.getEntryEntity(entryName).get(selectRows[0]);
        DynamicObject material = entry.getDynamicObject("material1");
        String serialQtyKey = SerialNumberHelper.getSerialQtyKey((String)billtype, (String)entryName, (Long)((Long)model.getDataEntity().getPkValue()), (String)"baseqty1");
        String serialUnitKey = SerialNumberHelper.getSerialUnitKey((MainEntityType)billtypeEntity, (String)entryName, (String)serialQtyKey);
        DynamicObject unit = entry.getDynamicObject(serialUnitKey);
        BigDecimal qty = entry.getBigDecimal(serialQtyKey);
        DynamicObject warehouse = entry.getDynamicObject("warehouse1");
        long warehouseId = warehouse == null ? 0L : (Long)warehouse.getPkValue();
        DynamicObject location = entry.getDynamicObject("location1");
        long l = locationId = location == null ? 0L : (Long)location.getPkValue();
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u3002", (String)"MaterialIsNull", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!material.getBoolean("enableserial")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u672a\u542f\u7528\u5e8f\u5217\u53f7\u7ba1\u7406\uff0c\u65e0\u6cd5\u5904\u7406\u5e8f\u5217\u53f7\u3002", (String)"UnEnableSerialCanNotHandleSerialNumber", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        this.commonhandleSerialNumber(itemKey, entryName, entry, material, unit, qty, warehouseId, locationId);
    }

    private void commonhandleSerialNumber(String itemKey, String entryName, DynamicObject entry, DynamicObject material, DynamicObject unit, BigDecimal qty, Long warehouse, Long location) {
        boolean isCheckSnnumber;
        Boolean isSub = Boolean.FALSE;
        if ("afterentity".equals(entryName)) {
            isSub = Boolean.TRUE;
        }
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity();
        Object pkValue = bill.getPkValue();
        String billtype = bill.getDataEntityType().getName();
        Object entryid = entry.getPkValue();
        DynamicObject org = (DynamicObject)bill.get("org");
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        boolean isFromDataBase = bill.getDataEntityState().getFromDatabase();
        boolean bl = isCheckSnnumber = BARITEM_CHECK_SNNUMBER.equals(itemKey) || BARITEM_SUB_CHECK_SNNUMBER.equals(itemKey);
        if (!isFromDataBase && isCheckSnnumber) {
            param.put("material", material != null ? material.getPkValue() : null);
            param.put("unit", unit != null ? unit.getPkValue() : null);
            param.put("qty", qty.intValue());
            Object billSnRelationId = SerialNumberHelper.getUpSnRelationId((String)billtype, (DynamicObject)entry);
            param.put("billsnrelationid", billSnRelationId);
        } else {
            if (pkValue == null || pkValue.equals(0L) || !isFromDataBase) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u6dfb\u52a0\u5e8f\u5217\u53f7\u3002", (String)"CanNotHandleSerialNumberBecauseBillNotSave", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                return;
            }
            if (entryid == null || entryid.equals(0L)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u5f55\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u6dfb\u52a0\u5e8f\u5217\u53f7\u3002", (String)"CanNotHandleSerialNumberBecauseEntryNotSave", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                return;
            }
            if (unit == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"UnitIsNull", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                return;
            }
            param.put("billid", pkValue);
            param.put("billtype", billtype);
            param.put("entryid", entryid);
            param.put("entrykey", entryName);
            param.put("invorg", org != null ? org.getPkValue() : null);
            param.put("material", material.getPkValue());
            param.put("unit", unit.getPkValue());
            param.put("qty", qty.intValue());
            param.put("curwarehous", warehouse);
            param.put("curlocation", location);
            QFilter filter = new QFilter("billtype", "=", (Object)billtype).and("entrykey", "=", (Object)entryName).and("billid", "=", pkValue).and("entryid", "=", entryid);
            DynamicObject billSNRelation = QueryServiceHelper.queryOne((String)"sbs_billsnrelation", (String)"id", (QFilter[])filter.toArray());
            if (billSNRelation != null) {
                param.put("billsnrelationid", billSNRelation.get("id"));
            }
        }
        this.showSerialNumberPage(itemKey, param, isSub);
    }

    private void showSerialNumberPage(String itemKey, Map<String, Object> param, Boolean isSub) {
        switch (itemKey) {
            case "checksnnumber1": 
            case "checksnnumber": {
                SerialNumberHelper.showPageCheckSNNumber((AbstractBillPlugIn)this, param);
                break;
            }
            case "entersnnumber1": 
            case "entersnnumber": {
                param.put("invflu", this.getInvFlu(isSub));
                if (!"A".equals(this.getModel().getValue("billstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u4e3a\u6682\u5b58\u72b6\u6001\u624d\u80fd\u5f55\u5165\u5e8f\u5217\u53f7\u3002", (String)"OnlySaveStatusCanAddSerialNumber", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                    return;
                }
                SerialNumberHelper.showPageEnterSNNumber((AbstractBillPlugIn)this, param);
                break;
            }
            case "importsnnumber1": 
            case "importsnnumber": {
                if (!"A".equals(this.getModel().getValue("billstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u4e3a\u6682\u5b58\u72b6\u6001\u624d\u80fd\u5bfc\u5165\u5e8f\u5217\u53f7\u3002", (String)"OnlySaveStatusCanImportSerialNumber", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                    return;
                }
                SerialNumberHelper.showPageImportSNNumber((AbstractBillPlugIn)this, param);
                break;
            }
        }
    }

    protected String getInvFlu(Boolean issub) {
        String billTypeName = this.getModel().getDataEntity().getDynamicObjectType().getName();
        String invflu = null;
        boolean assIsSub = "im_assembbill".equals(billTypeName) && issub != false;
        boolean adjIsSub = "im_adjustbill".equals(billTypeName) && issub == false;
        boolean disIsSub = "im_disassemblebill".equals(billTypeName) && issub == false;
        invflu = assIsSub || adjIsSub || disIsSub ? INVFLU_SUBTRACT : INVFLU_INCREASE;
        return invflu;
    }

    private void relLotnumberSpace(String dt, String lotNumberConst, int row) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity(dt, row);
        String lotNumber = dynamicObject.getString(lotNumberConst);
        if (lotNumber != null) {
            lotNumber = lotNumber.replaceAll("\u3000", " ").trim();
            this.setValue(lotNumberConst, lotNumber, row, false);
        }
    }

    protected final boolean isDraw() {
        String flag;
        boolean isDraw = false;
        IPageCache cache = this.getPageCache();
        String isDrawFlag = cache.get(flag = "IM_BILL_ISDRAW");
        if (StringUtils.isBlank((CharSequence)isDrawFlag)) {
            isDraw = this.isDrawByBOTP();
            cache.put(flag, isDraw ? "Boolean.TRUE" : "Boolean.FALSE");
        } else {
            isDraw = "Boolean.TRUE".equals(isDrawFlag);
        }
        return isDraw;
    }

    private boolean isDrawByBOTP() {
        DynamicObjectCollection afterEntityList;
        DynamicObject bill = this.getBill();
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(this.getEntryName());
        if (entrys == null || entrys.size() == 0) {
            return false;
        }
        DynamicObjectCollection linkColl = ((DynamicObject)entrys.get(0)).getDynamicObjectCollection(this.getEntryLinkName());
        if ("im_adjustbill".equals(bill.getDataEntityType().getName()) && (afterEntityList = ((DynamicObject)entrys.get(0)).getDynamicObjectCollection("afterentity")) != null && afterEntityList.size() > 0) {
            linkColl = ((DynamicObject)afterEntityList.get(0)).getDynamicObjectCollection("subentryentity_lk");
        }
        return linkColl != null && linkColl.size() > 0;
    }

    protected String getEntryLinkName() {
        return "billentry_lk";
    }

    protected String getEntryName() {
        return "billentry";
    }

    private void changeLotNumber(Object oldValue, Object newValue, int rowIndex, Boolean isAfter) {
        IDataModel model = this.getModel();
        String entry = "billentry";
        String lotNum = "lot";
        String lotNumber = "lotnumber";
        if (isAfter.booleanValue()) {
            entry = "afterentity";
            lotNum = "lot1";
            lotNumber = "lotnumber1";
        }
        DataChangeHelper.setValue((IDataModel)model, (String)lotNum, null, (int)rowIndex, (boolean)false);
        this.setLifeDateByLotNmber(rowIndex, (String)newValue, model, isAfter);
        this.relLotnumberSpace(entry, lotNumber, rowIndex);
    }

    private void setLifeDateByLotNmber(int rowIndex, String lotNumber, IDataModel model, Boolean isAfter) {
        DynamicObject org = (DynamicObject)model.getValue("org");
        String materialId = "material";
        String producedateId = "producedate";
        String expirydateId = "expirydate";
        if (isAfter.booleanValue()) {
            materialId = "material1";
            producedateId = "producedate1";
            expirydateId = "expirydate1";
        }
        DynamicObject material = (DynamicObject)model.getValue(materialId, rowIndex);
        if (org == null || material == null) {
            return;
        }
        if (!material.getBoolean("enableshelflifemgr")) {
            return;
        }
        QFilter qFilter = new QFilter("materialmaster", "=", (Object)material.getLong("masterid.id"));
        qFilter.and("org", "=", org.getPkValue());
        qFilter.and("lotnumber", "=", (Object)lotNumber);
        DynamicObjectCollection lotinTracks = QueryServiceHelper.query((String)"im_lotintrack", (String)"producedate,expirydate", (QFilter[])qFilter.toArray(), (String)"biztime desc, createtime desc", (int)1);
        if (lotinTracks != null && lotinTracks.size() > 0) {
            DynamicObject lotinTrack = (DynamicObject)lotinTracks.get(0);
            Date producedate = lotinTrack.getDate("producedate");
            Date oldProducedate = (Date)model.getValue(producedateId, rowIndex);
            Date expirydate = lotinTrack.getDate("expirydate");
            Date oldExpirydate = (Date)model.getValue(expirydateId, rowIndex);
            if (expirydate == null) {
                this.setValue(producedateId, producedate, rowIndex, false);
                this.setValue(expirydateId, expirydate, rowIndex, false);
            } else {
                DynamicObject materialInvInfo = (DynamicObject)model.getValue(materialId, rowIndex);
                this.showExpiryDateConfirm(rowIndex, materialInvInfo, oldExpirydate, expirydate, oldProducedate, producedate, isAfter);
            }
        }
    }

    private void showExpiryDateConfirm(int rowIndex, DynamicObject materialInvInfo, Date oldExpiryDate, Date newExpiryDate, Date oldProducedate, Date newProducedate, Boolean isAfter) {
        ArrayList alertMsgList = new ArrayList(16);
        StringBuilder alertMsg = new StringBuilder();
        String billName = this.getModel().getDataEntityType().getName();
        String entryName = "billentry";
        boolean isOutBill = InvBillHelper.isOutEntry((String)billName, (String)entryName);
        boolean isInBill = InvBillHelper.isInEntry((String)billName, (String)entryName);
        String leadTimeUnit = materialInvInfo.getString("leadtimeunit");
        int dateOfOverdueForIn = materialInvInfo.getInt("dateofoverdueforin");
        int dateOfOverdueForOut = materialInvInfo.getInt("dateofoverdueforout");
        int dateOfOverdue = 0;
        if (isOutBill && isInBill) {
            dateOfOverdue = dateOfOverdueForOut > dateOfOverdueForIn ? dateOfOverdueForOut : dateOfOverdueForIn;
        } else if (isOutBill) {
            dateOfOverdue = dateOfOverdueForOut;
        } else if (isInBill) {
            dateOfOverdue = dateOfOverdueForIn;
        }
        Date overdueDate = ShelfLifeDateUtil.getDateOfOverdue((String)leadTimeUnit, (int)dateOfOverdue, (Date)newExpiryDate);
        Date nowDate = new Date();
        boolean dateOver = nowDate.after(overdueDate);
        if (dateOver) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            String newExpirydateStr = this.getDateStr(newExpiryDate);
            String oldExpirydateStr = this.getDateStr(oldExpiryDate);
            String newProducedateStr = this.getDateStr(newProducedate);
            String oldProducedateStr = this.getDateStr(oldProducedate);
            params.put("newProduceDate", newProducedateStr);
            params.put("oldProduceDate", oldProducedateStr);
            params.put("newExpirydate", newExpirydateStr);
            params.put("oldExpirydate", oldExpirydateStr);
            params.put("index", rowIndex);
            params.put("isAfter", isAfter);
            alertMsgList.add(params);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s\u201d\u5230\u671f\u65e5\u671f\u4e3a\u201c%3$s\u201d,\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u662f\u5426\u5141\u8bb8\u5f55\u5165\uff1f", (String)"ImBillPropChanged_7", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr);
            alertMsg.append(msg);
        } else {
            String producedateId = "producedate";
            String expirydateId = "expirydate";
            if (isAfter.booleanValue()) {
                producedateId = "producedate1";
                expirydateId = "expirydate1";
            }
            this.setValue(producedateId, newProducedate, rowIndex, false);
            this.setValue(expirydateId, newExpiryDate, rowIndex, false);
        }
        if (alertMsg.length() > 0) {
            ConfirmCallBackListener cb = new ConfirmCallBackListener("MaterialLifeDate", (IFormPlugin)this);
            alertMsg.append(ResManager.loadKDString((String)"\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u662f\u5426\u5141\u8bb8\u5f55\u5165\uff1f", (String)"ImBillPropChanged_11", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\u7269\u6599\u3002", (String)"ImBillPropChanged_12", (String)"scmc-im-formplugin", (Object[])new Object[0]), alertMsg.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(alertMsgList));
        }
    }

    private void matchingRuleOutNew(IFormView view, String formid, String entry, String operateKey) {
        EntryGrid control = (EntryGrid)this.getControl(entry);
        int[] selectRows = control.getSelectRows();
        if (selectRows.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ImBillEditPlugin_11", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Integer> selectRowList = new ArrayList<Integer>(selectRows.length);
        for (int i = 0; i < selectRows.length; ++i) {
            selectRowList.add(selectRows[i]);
        }
        MatchingRuleOutNewHelper.execMatchingFromView((IFormPlugin)this, (String)formid, (String)entry, (String)operateKey, (IFormView)view, selectRowList);
    }

    @Deprecated
    public void dealWithEntry(List<Map<String, Object>> insertEntryInfo, List<String> ruleList, boolean after, String formId) {
        new MatchingRuleOutOldTransFormHelper((AbstractBillPlugIn)this).dealWithEntry(insertEntryInfo, ruleList, after, formId);
    }

    public void insertEntry(List<Map<String, Object>> insertEntryInfo, boolean after, String formId) {
        new MatchingRuleOutOldTransFormHelper((AbstractBillPlugIn)this).insertEntry(insertEntryInfo, after, formId);
    }

    private void changeOwnerType(PropertyChangedArgs e) {
        ChangeData data = e.getChangeSet()[0];
        String propName = e.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.setValue("owner", null, data.getRowIndex(), false);
            return;
        }
        Object defOwner = OwnerHelper.getOwnerDefValue((Long)org.getLong("id"));
        this.setDefaultOwner((String)data.getNewValue(), data.getRowIndex(), defOwner);
        this.setAllSubEntryValueAsParent("owner", e.getChangeSet()[0].getRowIndex());
        this.setAllSubEntryValueAsParent(propName, e.getChangeSet()[0].getRowIndex());
    }

    private void changeKeeperType(PropertyChangedArgs e) {
        ChangeData data = e.getChangeSet()[0];
        String propName = e.getProperty().getName();
        this.setDefaultKeeper((String)data.getNewValue(), data.getRowIndex());
        this.setAllSubEntryValueAsParent("keeper", e.getChangeSet()[0].getRowIndex());
        this.setAllSubEntryValueAsParent(propName, e.getChangeSet()[0].getRowIndex());
    }

    private void setAllSubEntryValueAsParent(String parentKey, int parentIndex) {
        IDataModel model = this.getModel();
        model.beginInit();
        DynamicObject row = model.getEntryRowEntity("billentry", parentIndex);
        DynamicObjectCollection entries = row.getDynamicObjectCollection("afterentity");
        String subkey = parentKey + INVFLU_INCREASE;
        Object value = row.get(parentKey);
        for (int i = 0; i < entries.size(); ++i) {
            ((DynamicObject)entries.get(i)).set(subkey, value);
        }
        model.endInit();
        int entryRowCount = this.getModel().getEntryRowCount("afterentity");
        for (int i = 0; i < entryRowCount; ++i) {
            this.getView().updateView(subkey, i);
        }
    }

    private void setDefaultKeeper(String keeperType, int rowIndex) {
        Object defaultKeeper = null;
        if (keeperType != null && "bos_org".equals(keeperType)) {
            defaultKeeper = this.getModel().getValue("org");
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"keeper"});
        } else {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"keeper"});
        }
        this.setValue("keeper", defaultKeeper, rowIndex, false);
    }

    private void setDefaultOwner(String ownerType, int rowIndex, Object defaultOwner) {
        if (ownerType != null && "bos_org".equals(ownerType)) {
            this.setValue("owner", defaultOwner, rowIndex, false);
        } else {
            this.setValue("owner", null, rowIndex, false);
        }
    }

    private void billentryAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rows = e.getRowDataEntities();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Object defOwer = OwnerHelper.getOwnerDefValue((Long)org.getLong("id"));
        for (RowDataEntity row : rows) {
            int rowIndex = row.getRowIndex();
            DynamicObject object = row.getDataEntity();
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"location"});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"configuredcode"});
            this.setDefaultKeeper(object.getString("keepertype"), rowIndex);
            this.setDefaultOwner(object.getString("ownertype"), rowIndex, defOwer);
            this.getModel().setValue("invtype", (Object)688884005529250816L, rowIndex);
            this.getModel().setValue("invstatus", (Object)691928582720825344L, rowIndex);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "lotnumber": 
            case "lotnumber1": {
                this.openPageSelectLotMainfile(key);
                break;
            }
        }
    }

    private void openPageSelectLotMainfile(String fieldKey) {
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity();
        DynamicObject selectEntry = null;
        String lotnumField = null;
        switch (fieldKey) {
            case "lotnumber": {
                int rowIndex = model.getEntryCurrentRowIndex("billentry");
                selectEntry = model.getEntryRowEntity("billentry", rowIndex);
                lotnumField = "billentry." + fieldKey;
                break;
            }
            case "lotnumber1": {
                int rowIndex = model.getEntryCurrentRowIndex("afterentity");
                selectEntry = model.getEntryRowEntity("afterentity", rowIndex);
                lotnumField = "billentry.afterentity." + fieldKey;
            }
        }
        LotMainFileHelper.showPageLotMainfileList((IFormPlugin)this, (IFormView)this.getView(), (DynamicObject)bill, selectEntry, lotnumField);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "msmod_selectlot": {
                this.closedSelectedLot(e);
                break;
            }
        }
    }

    private void closedSelectedLot(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData instanceof Map) {
            IDataModel model = this.getModel();
            int rowIndex = 0;
            Map lotAttr = (Map)returnData;
            String lotidfield = (String)lotAttr.get("lotidfield");
            String lotnumfield = (String)lotAttr.get("lotnumfield");
            switch (lotidfield) {
                case "lot": {
                    rowIndex = model.getEntryCurrentRowIndex("billentry");
                    break;
                }
                case "lot1": {
                    rowIndex = model.getEntryCurrentRowIndex("afterentity");
                }
            }
            model.setValue(lotnumfield, lotAttr.get("lotnumber"), rowIndex);
            model.setValue(lotidfield, lotAttr.get("lotid"), rowIndex);
        }
    }

    private void checkShelflifeDate(Date produceDate, Date expirydate, int rowIndex, String key, DynamicObject materialInvInfo) {
        if (expirydate != null && produceDate != null && expirydate.before(produceDate)) {
            String newExpirydateStr = this.getDateStr(expirydate);
            String newProduceDateStr = this.getDateStr(produceDate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u5230\u671f\u65e5\u671f\u6216\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u7684\u201c\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u201d\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImBillPropChanged_9", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            this.setValue(key, null, rowIndex, false);
        }
    }

    @Deprecated
    protected void setSubEntryByMaterial(int subRow) {
        DynamicObject materialInvInfo = (DynamicObject)this.getModel().getValue("material1", subRow);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        this.setSubEntryByMaterial(materialInvInfo, material, subRow);
    }
}

