/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.acc.balance;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;

public class BalReCalFilterEdit
extends AbstractFormPlugin {
    private static final String F_BILL = "bill";
    private static final String AP_FILTER_AP = "filterap";
    private static final String BT_CREATE = "create";
    private static final String F_FILTER = "filter";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.bindFilterGrid();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BT_CREATE});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control bt = (Control)evt.getSource();
        switch (key = bt.getKey()) {
            case "create": {
                this.createFilterStr();
                break;
            }
        }
    }

    private void createFilterStr() {
        FilterGrid grid = (FilterGrid)this.getView().getControl(AP_FILTER_AP);
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        DynamicObject bill = this.getModel().getDataEntity().getDynamicObject(F_BILL);
        if (bill == null) {
            return;
        }
        FilterBuilder fb = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)bill.getString("id")), condition);
        fb.buildFilter();
        QFilter fs = fb.getQFilter();
        String jsonStr = fs.toSerializedString();
        this.getModel().setValue(F_FILTER, (Object)jsonStr);
    }

    private void bindFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(AP_FILTER_AP);
        DynamicObject bill = this.getModel().getDataEntity().getDynamicObject(F_BILL);
        if (bill == null) {
            filterGrid.setFilterColumns(new ArrayList());
        } else {
            EntityTypeUtil helper = new EntityTypeUtil();
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)bill.getString("id"));
            List cols = helper.getFilterColumns((IDataEntityType)type);
            filterGrid.setEntityNumber(type.getName());
            filterGrid.setFilterColumns(cols);
        }
        this.getView().updateView(AP_FILTER_AP);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "bill": {
                this.bindFilterGrid();
                break;
            }
        }
    }
}

