/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.acc.balance;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.id.IDRange;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.scmc.im.business.balance.BalanceUpdateHandle;
import kd.scmc.im.business.balance.ReCalMonitorLog;
import kd.scmc.im.business.balance.recal.BalReCalCache;
import org.apache.commons.lang3.StringUtils;

public class BalanceUpdateEdit
extends AbstractFormPlugin
implements ProgresssListener {
    private static final ThreadPool POOL = ThreadPools.newFixedThreadPool((String)"balanceUpdate", (int)1);
    private static final String BT_REAL_CLEAR_ZERO = "real_clear_zero";
    private static final String BT_REAL_CLEAR = "real_clear";
    private static final String BT_REAL_SET_0 = "real_set0";
    private static final String BT_REAL_RECAL = "real_recal";
    private static final String BT_REAL_RESET_KEYCOL = "real_reset_keycol";
    private static final String BT_REAL_CLEAR_SNAP = "real_clear_snap";
    private static final String BT_REAL_CLEAR_BY_BAL_FS = "real_clear_bybalfs";
    private static final String BT_REAL_SET_0_BY_BAL_FS = "real_set0_bybalfs";
    private static final String BT_REAL_RECAL_BY_BAL_FS = "real_recal_bybalfs";
    private static final String BT_REAL_CHECK_BAL = "real_check_bal";
    private static final String F_REAL_BALS = "real_bals";
    private static final String F_REAL_ORG = "real_org";
    private static final String BT_PERIOD_CLEAR = "period_clear";
    private static final String BT_PERIOD_SET_0 = "period_set0";
    private static final String BT_PERIOD_RECAL = "period_recal";
    private static final String BT_PERIOD_RESET_KEYCOL = "period_reset_keycol";
    private static final String BT_PERIOD_CLEAR_SNAP = "period_clear_snap";
    private static final String BT_PERIOD_CHENGE_ENGINE = "period_chenge_engine";
    private static final String BT_PERIOD_CLEAR_BY_BAL_FS = "period_clear_bybalfs";
    private static final String BT_PERIOD_SET_0_BY_BAL_FS = "period_set0_bybalfs";
    private static final String BT_PERIOD_RECAL_BY_BAL_FS = "period_recal_bybalfs";
    private static final String F_PERIOD_BALS = "period_bals";
    private static final String F_PERIOD_IS_NEW = "period_isnew";
    private static final String F_PERIOD_ORG = "period_org";
    private static final String F_START_PERIOD = "startperiod";
    private static final String F_BILL_IDS = "billids";
    private static final String BT_RECAL_BYBILLFS = "recal_bybillfs";
    private static final String BT_RECAL_BYBILL_IDS = "recal_bybillids";
    private static final String F_BILL = "bill";
    private static final String F_START_DATE = "startdate";
    private static final String F_END_DATE = "enddate";
    private static final String AP_BILL_FS = "bill_fs";
    private static final String BT_SHOW_RECAL_TASKS = "show_recal_tasks";
    private static final String BT_SAVE_RECAL_POINT = "save_recal_point";
    private static final String BT_SHOW_RECAL_POINT = "show_recal_point";
    private static final String F_START = "start";
    private static final String F_PHONE = "pwd";
    private static final String F_RESULT_INFO = "resultinfo";
    private static final String TB_REAL = "realtb";
    private static final String TB_PERIOD = "periodtb";
    private static final String F_BATCH_COUNT = "batchcount";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.getProgressBar().addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{BT_REAL_CLEAR_ZERO, BT_REAL_CLEAR, BT_REAL_SET_0, BT_REAL_RECAL, BT_REAL_CLEAR_BY_BAL_FS, BT_REAL_SET_0_BY_BAL_FS, BT_REAL_RECAL_BY_BAL_FS, BT_REAL_RESET_KEYCOL, BT_REAL_CLEAR_SNAP, BT_REAL_CHECK_BAL, BT_PERIOD_CLEAR, BT_PERIOD_SET_0, BT_PERIOD_RECAL, BT_PERIOD_RESET_KEYCOL, BT_PERIOD_CLEAR_SNAP, BT_PERIOD_CHENGE_ENGINE, BT_PERIOD_CLEAR_BY_BAL_FS, BT_PERIOD_SET_0_BY_BAL_FS, BT_PERIOD_RECAL_BY_BAL_FS, BT_RECAL_BYBILLFS, BT_SHOW_RECAL_TASKS, BT_SAVE_RECAL_POINT, BT_SHOW_RECAL_POINT, BT_RECAL_BYBILL_IDS});
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    private void realCheckBal() {
        final String[] balTBs = this.getRealBal(true);
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                BalanceUpdateHandle.realCheckBal((String)balTBs[0]);
            }
        });
    }

    private void periodSet0ByBalFs() {
        final String[] balTBs = this.getPeriodBal(true);
        if (balTBs == null) {
            return;
        }
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObject org = data.getDynamicObject(F_PERIOD_ORG);
        final int period = data.getInt(F_START_PERIOD);
        final Long orgId = org == null ? null : Long.valueOf(org.getLong("id"));
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                BalanceUpdateHandle.periodSet0ByBalFs((String[])balTBs, (Long)orgId, (int)period);
            }
        });
    }

    private void periodClearByBalFs() {
        final String[] balTBs = this.getPeriodBal(true);
        if (balTBs == null) {
            return;
        }
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObject org = data.getDynamicObject(F_PERIOD_ORG);
        final int period = data.getInt(F_START_PERIOD);
        final Long orgId = org == null ? null : Long.valueOf(org.getLong("id"));
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                BalanceUpdateHandle.periodClearByBalFs((String[])balTBs, (Long)orgId, (int)period);
            }
        });
    }

    private void periodChangeEngine() {
        boolean isNew = this.getModel().getDataEntity().getBoolean(F_PERIOD_IS_NEW);
        BalanceUpdateHandle.periodChangeEngine((!isNew ? 1 : 0) != 0);
        this.loadBalanceFlag();
    }

    private void realClearZero() {
        final String[] balTBs = this.getRealBal(true);
        if (balTBs == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                BalanceUpdateHandle.realClearZero((String[])balTBs);
            }
        });
    }

    private void periodReSetKeyCol() {
        final String[] balTBs = this.getPeriodBal(true);
        if (balTBs == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                BalanceUpdateHandle.reSetKeyCol((String[])balTBs);
            }
        });
    }

    private void periodClearSnap() {
        final String[] balTBs = this.getPeriodBal(true);
        if (balTBs == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                BalanceUpdateHandle.clearSnapData((String[])balTBs);
            }
        });
    }

    private void realClearSnap() {
        final String[] balTBs = this.getRealBal(true);
        if (balTBs == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                BalanceUpdateHandle.clearSnapData((String[])balTBs);
            }
        });
    }

    private void realReSetKeyCol() {
        final String[] balTBs = this.getRealBal(true);
        if (balTBs == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                BalanceUpdateHandle.reSetKeyCol((String[])balTBs);
            }
        });
    }

    private void showReCalPoint() {
        ListShowParameter fsp = new ListShowParameter();
        fsp.setBillFormId("im_bal_recal_point");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)fsp);
    }

    private void showReCalTask() {
        ListShowParameter fsp = new ListShowParameter();
        fsp.setBillFormId("im_bal_recal_log");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)fsp);
    }

    private void periodReCal() {
        final String[] balTBs = this.getPeriodBal(true);
        if (balTBs == null) {
            return;
        }
        final Date start = this.getStart(true);
        if (start == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                BalanceUpdateHandle.periodReCal((Date)start, (String[])balTBs);
            }
        });
    }

    private void periodSet0() {
        final String[] balTBs = this.getPeriodBal(true);
        if (balTBs == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                BalanceUpdateHandle.setAll0((String[])balTBs);
            }
        });
    }

    private void periodClear() {
        final String[] balTBs = this.getPeriodBal(true);
        if (balTBs == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                BalanceUpdateHandle.clearBals((String[])balTBs);
            }
        });
    }

    private QFilter getBillIdFs() {
        IDRange idRange;
        DynamicObject data = this.getModel().getDataEntity();
        Date startDate = data.getDate(F_START_DATE);
        Date endDate = data.getDate(F_END_DATE);
        QFilter fs = null;
        if (startDate != null) {
            idRange = ID.getIDRangeOfDay((Date)startDate);
            fs = new QFilter("id", ">=", (Object)idRange.getMinId());
        }
        if (endDate != null) {
            idRange = ID.getIDRangeOfDay((Date)startDate);
            if (fs == null) {
                fs = new QFilter("id", "<=", (Object)idRange.getMinId());
            } else {
                fs.and("id", ">=", (Object)idRange.getMinId());
            }
        }
        return fs;
    }

    private void reCalByBillFs() {
        Tab control = (Tab)this.getControl("tabap");
        String currentTab = control.getCurrentTab();
        String[] balTBs = null;
        if (TB_PERIOD.equals(currentTab)) {
            balTBs = this.getPeriodBal(true);
        } else if (TB_REAL.equals(currentTab)) {
            balTBs = this.getRealBal(true);
        }
        if (balTBs == null) {
            return;
        }
        QFilter fs = this.getBillIdFs();
        final String bill = this.getBill();
        if (bill != null) {
            QFilter billFs = this.getBillFs(bill);
            if (fs == null) {
                fs = billFs;
            } else if (billFs != null) {
                fs = fs.and(billFs);
            }
        }
        final Date finalStart = this.getStart(true);
        final QFilter finalFs = fs;
        final String[] finalBalTBs = balTBs;
        if (finalStart == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                BalanceUpdateHandle.reCalByBillFs((Date)finalStart, (String[])finalBalTBs, (QFilter)finalFs, (String)bill);
            }
        });
    }

    private void realReCal() {
        final String[] balTBs = this.getRealBal(true);
        if (balTBs == null) {
            return;
        }
        final Date start = this.getStart(true);
        if (start == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                BalanceUpdateHandle.realReCal((Date)start, (String[])balTBs);
            }
        });
    }

    private void realSet0() {
        final String[] balTBs = this.getRealBal(true);
        if (balTBs == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                BalanceUpdateHandle.setAll0((String[])balTBs);
            }
        });
    }

    private void realClear() {
        final String[] balTBs = this.getRealBal(true);
        if (balTBs == null) {
            return;
        }
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                BalanceUpdateHandle.clearBals((String[])balTBs);
            }
        });
    }

    private String[] getRealBal(boolean check) {
        return this.getBal(check, F_REAL_BALS, ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5373\u65f6\u4f59\u989d\u8868\u3002", (String)"IM-E-054341", (String)"scmc-im-formplugin", (Object[])new Object[0]));
    }

    private QFilter getBillFs(String bill) {
        if (bill == null) {
            return null;
        }
        FilterGrid grid = (FilterGrid)this.getControl(AP_BILL_FS);
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        FilterBuilder fb = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)bill), condition);
        fb.buildFilter();
        QFilter fs = fb.getQFilter();
        return fs;
    }

    private Date getStart(boolean checkAndSet) {
        Date start = this.getModel().getDataEntity().getDate(F_START);
        if (start != null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6e05\u7a7a\u5f00\u59cb\u65f6\u95f4\uff0c\u6216\u8005\u6839\u636e\u5f00\u59cb\u65f6\u95f4\u67e5\u8be2\u5df2\u5f00\u59cb\u7684\u4efb\u52a1\u3002", (String)"IM-E-662042", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return null;
        }
        Calendar cd = Calendar.getInstance();
        cd.set(14, 0);
        start = cd.getTime();
        this.getModel().setValue(F_START, (Object)start);
        return start;
    }

    private String[] getPeriodBal(boolean check) {
        return this.getBal(check, F_PERIOD_BALS, ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u671f\u95f4\u4f59\u989d\u8868\u3002", (String)"IM-E-480066", (String)"scmc-im-formplugin", (Object[])new Object[0]));
    }

    private String[] getBal(boolean check, String balCol, String msg) {
        String bals = this.getModel().getDataEntity().getString(balCol);
        if (StringUtils.isNotBlank((CharSequence)bals)) {
            String[] tempBals;
            ArrayList<String> tbs = new ArrayList<String>(2);
            for (String tb : tempBals = bals.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)tb)) continue;
                tbs.add(tb);
            }
            if (!tbs.isEmpty()) {
                return tbs.toArray(new String[0]);
            }
        }
        if (check) {
            this.getView().showMessage(msg);
        }
        return null;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadBalanceFlag();
    }

    private void loadBalanceFlag() {
        boolean isnew = BalanceUpdateHandle.reLoadPeriodBalFlag();
        this.getModel().setValue(F_PERIOD_IS_NEW, (Object)isnew);
    }

    public void onProgress(ProgressEvent e) {
        JSONObject data = BalReCalCache.getReCalPercent();
        int percent = data.getIntValue("percent");
        if (percent >= 100) {
            percent = 99;
        }
        e.setProgress(percent);
        e.setText("");
        this.getModel().setValue(F_RESULT_INFO, (Object)data.getString("text"));
    }

    private ProgressBar getProgressBar() {
        return (ProgressBar)this.getView().getControl("progressap");
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getProgressBar().stop();
    }

    public void afterCreateNewData(EventObject e) {
        this.getProgressBar().start();
        BalReCalCache.setReCalPercent((int)0, (String)ResManager.loadKDString((String)"\u6682\u65e0\u64cd\u4f5c\u6267\u884c\u3002", (String)"IM-E-233144", (String)"scmc-im-formplugin", (Object[])new Object[0]));
    }

    private String getBill() {
        DynamicObject bill = this.getModel().getDataEntity().getDynamicObject(F_BILL);
        if (bill != null) {
            return bill.getString("id");
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "bill": {
                this.billChanged(e);
                break;
            }
            case "batchcount": {
                this.batchCountChanged(e);
                break;
            }
        }
    }

    private void batchCountChanged(PropertyChangedArgs e) {
        int batch = this.getModel().getDataEntity().getInt(F_BATCH_COUNT);
        if (batch >= 200 && batch <= 20000) {
            BalReCalCache.setBatchCount((int)batch);
        }
    }

    private void billChanged(PropertyChangedArgs e) {
        final String billName = this.getBill();
        this.setCols4FilterGrid(billName, AP_BILL_FS, new Predicate<Map<String, Object>>(){

            @Override
            public boolean test(Map<String, Object> info) {
                return billName.equals(info.get("entryEntity").toString());
            }
        });
    }

    private void setCols4FilterGrid(String entityName, String grid, Predicate<Map<String, Object>> predicate) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(grid);
        filterGrid.SetValue(new FilterCondition());
        if (StringUtils.isBlank((CharSequence)entityName)) {
            filterGrid.setFilterColumns(new ArrayList());
        } else {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType).stream().filter(predicate).collect(Collectors.toList());
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(cols);
        }
        this.getView().updateView(grid);
    }

    private void addOpLog(Button tb) {
        try {
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"im_invbal_oplog");
            log.set("optime", (Object)new Date());
            log.set("opuser", (Object)Long.parseLong(RequestContext.getOrCreate().getUserId()));
            log.set("op", (Object)tb.getKey());
            log.set("params", (Object)this.getParams());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        }
        catch (Exception e) {
            ReCalMonitorLog.error((Throwable)e);
        }
    }

    private String getParams() {
        JSONObject param = new JSONObject();
        DynamicObject data = this.getModel().getDataEntity();
        param.put(F_REAL_BALS, (Object)this.getRealBal(false));
        DynamicObject org = data.getDynamicObject(F_REAL_ORG);
        param.put(F_REAL_ORG, org == null ? null : org.getPkValue());
        String bill = this.getBill();
        QFilter billFs = this.getBillFs(bill);
        param.put("billfs", (Object)billFs);
        QFilter billIdFs = this.getBillIdFs();
        param.put("billIdFs", (Object)billIdFs);
        param.put(F_START, (Object)data.getDate(F_START));
        org = data.getDynamicObject(F_PERIOD_ORG);
        param.put(F_PERIOD_ORG, org == null ? null : org.getPkValue());
        param.put(F_START_PERIOD, (Object)data.getInt(F_START_PERIOD));
        return param.toJSONString();
    }
}

