/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.acc.balance;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MaterielProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.operation.helper.BillUnitHelper;
import kd.bos.ext.scmc.operation.helper.NoUpdateFieldsAnalysisExtHelper;
import kd.bos.ext.scmc.operation.helper.PrecisionAccountHelper;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.scmc.im.business.workbench.WorkbenchServiceHelper;

public class InventoryQueryWorkbenchCallBack
implements ICloseCallBack {
    private static final Log log = LogFactory.getLog(InventoryQueryWorkbenchCallBack.class);
    private static final String KEY_METADATAKEY = "metadatakey";
    private static final String KEY_CURRENTMETADATAKEY = "currentmetadatakey";
    private static final String KEY_UPDATE = "update";
    private static final String KEY_MATCH = "match";
    private static final String KEY_RETURNCL = "returncol";
    private static final String MATERIALINVACC_CALLBACK = "materialinvaccCallBack";
    private static final String INVENTORY_QUERY = "inventory_query";
    private static final String EXPANDUPDATE_KEY = "key";
    private static final String EXPANDUPDATE_TYPE = "type";
    private static final String EXPANDUPDATE_FORMULA = "formula";
    private static final String EXPANDUPDATE_ACC = "acc";
    private static final String EXPANDUPDATE_FIX = "fix";
    private static final String BD_MATERIAL = "bd_material";
    private static final String BD_MATERIALINVENTORYINFO = "bd_materialinventoryinfo";
    private static final List<String> AVBFIELDS = Arrays.asList("avbbaseqty", "avbqty", "avbqty2nd");
    private static final List<String> QTYFIELDS = Arrays.asList("baseqty", "qty", "qty2nd");
    private static final List<String> ALLQTYFIELDS = Arrays.asList("baseqty", "qty", "qty2nd", "avbbaseqty", "avbqty", "avbqty2nd", "lockbaseqty", "lockqty", "lockqty2nd");
    private static final List<String> UNITQTYFIELDS = Arrays.asList("qty", "avbqty");
    private static final List<String> BASEQTYFIELDS = Arrays.asList("baseqty", "avbbaseqty");
    private static final String[] SCMC_SOURCE_COLS = new String[]{"srcbillentity", "srcbillid", "srcbillnumber", "srcbillentryid", "srcbillentryseq", "mainbillid", "mainbillentryid", "mainbillentity", "mainbillentryseq", "mainbillnumber", "srcsysbillentryid", "srcsystem", "srcsysbillid", "conbillentity", "conbillid", "conbillnumber", "conbillentryid", "conbillrownum", "kitproducttype", "kitproduct", "pricemodel", "kittransfermodel", "pid"};
    public static final String MASTERID = "masterid";
    public static final String MATERIAL = "material";
    private static final List<String> NEGATIVE_BILLS = Arrays.asList("im_locationtransfer", "im_adjustbill", "im_assembbill", "im_disassemblebill", "im_purreceivebill");
    private String appid;
    private String billtype;
    private String entrykey;
    private String operatekey;
    private String entrykey_lk;
    private int row = -1;
    private List<Map<String, Object>> updateFields = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> matchFields = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> returnFields = new ArrayList<Map<String, Object>>();
    private Map<String, String> lotMainFileReturnParamMaps = Collections.emptyMap();
    private List<Map<String, String>> expandUpdateFields = new ArrayList<Map<String, String>>();
    private String qtyRule;
    private boolean newDeal;
    private boolean isDraw;
    private Boolean isContainLinetype;
    private Boolean isContainProductType;
    private Object defLinetypePK;
    private Boolean isUseLotMF;
    private String lotidCol;
    private Long lottypeid;
    private Map<Long, Long> lotMainFileMap;
    private boolean updateQty2ndZero = false;
    private boolean unittran = false;
    private String materialCol;
    private String unitCol;
    private String baseUnitCol;
    private DynamicObject materialValue;
    private DynamicObject unitValue;
    private Map<String, String> unitCacheMap = new HashMap<String, String>();
    private boolean middleinsert;
    private DynamicObjectCollection chooseEntryLks;
    private List<String> entryNoUpdateFieldValueList = new ArrayList<String>();
    private Map<String, BigDecimal> billQtyMap = new HashMap<String, BigDecimal>();
    private Map<Long, Boolean> matchMap = new HashMap<Long, Boolean>();
    private boolean billQtyGTInvQty = false;
    private String billBaseQtyCol;
    private String billQtyCol;
    private static final Set<String> enableApps = new HashSet<String>(Arrays.asList("im", "pm", "sm"));
    private Map<String, IDataEntityProperty> allFields = new HashMap<String, IDataEntityProperty>();
    private DynamicObject targetBillEntity;
    private DynamicObjectCollection entryEntity;
    private DynamicObjectCollection modelEntryEntity = new DynamicObjectCollection();

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnObj = e.getReturnData();
        try {
            if (returnObj != null && MATERIALINVACC_CALLBACK.equals(actionId)) {
                IFormView view = e.getView();
                EntryGrid control = (EntryGrid)view.getControl("entryentity");
                int[] selectRows = control.getSelectRows();
                if (selectRows.length <= 0) {
                    return;
                }
                JSONObject returnData = (JSONObject)returnObj;
                this.dealInvData(view, returnData);
                this.targetBillEntity.set(this.entrykey, (Object)this.entryEntity);
                WorkbenchServiceHelper.updateDynamicObjCache((IFormView)view, (DynamicObject)this.targetBillEntity);
                DynamicObject matchEntryEntity = (DynamicObject)this.entryEntity.get(this.row);
                WorkbenchServiceHelper.appendRowByTarBillEntry((List)WorkbenchServiceHelper.getFieldsMappingList((IFormView)view), (DynamicObject)this.targetBillEntity, (DynamicObject)matchEntryEntity, (long)matchEntryEntity.getLong("id"), (int)selectRows[0], (IFormView)view);
                this.appendExcludeMatchRowEntry(view, selectRows[0]);
                WorkbenchServiceHelper.setPageShowProperty((IFormView)view, (boolean)WorkbenchServiceHelper.isDataFromBOTP((IFormView)view));
                view.updateView("entryentity");
                WorkbenchServiceHelper.selectedFocusRow((IFormView)view);
            }
        }
        catch (Exception ex) {
            log.error("\u9519\u8bef\u65e5\u5fd7\uff1a ", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    private void appendExcludeMatchRowEntry(IFormView view, int selectRow) {
        if (this.modelEntryEntity.size() <= 0) {
            return;
        }
        int[] newRowNum = this.middleinsert ? view.getModel().appendEntryRow("entryentity", selectRow, this.modelEntryEntity.size()) : view.getModel().batchCreateNewEntryRow("entryentity", this.modelEntryEntity.size());
        this.appendRowByTarBillEntry(view, newRowNum, this.modelEntryEntity);
    }

    private void appendRowByTarBillEntry(IFormView view, int[] newRowNum, DynamicObjectCollection newEntryCollection) {
        if (newEntryCollection.isEmpty()) {
            return;
        }
        int entryIndex = 0;
        List fieldsMappingList = WorkbenchServiceHelper.getFieldsMappingList((IFormView)view);
        long[] ids = ID.genLongIds((int)newRowNum.length);
        for (int i = 0; i < newRowNum.length; ++i) {
            WorkbenchServiceHelper.appendRowByTarBillEntry((List)fieldsMappingList, (DynamicObject)this.targetBillEntity, (DynamicObject)((DynamicObject)newEntryCollection.get(entryIndex++)), (long)ids[i], (int)newRowNum[i], (IFormView)view);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void dealInvData(IFormView view, JSONObject returnData) {
        DynamicObject[] invaccs;
        this.appid = view.getModel().getDataEntityType().getAppId();
        if (enableApps.contains(this.appid)) {
            returnData = (JSONObject)DispatchServiceHelper.invokeBizService((String)"scmc", (String)this.appid, (String)"InvqueryService", (String)"dealReturnData", (Object[])new Object[]{view, returnData});
        }
        IDataModel model = view.getModel();
        model.getDataEntity(true);
        Map mapParam = (Map)returnData.get((Object)"mapparam");
        Object[] invAccIdArr = (Long[])returnData.get((Object)"data");
        MainEntityType realBalType = MetadataServiceHelper.getDataEntityType((String)"im_inv_realbalance");
        for (DynamicObject invacc : invaccs = BusinessDataServiceHelper.load((Object[])invAccIdArr, (DynamicObjectType)realBalType)) {
            invacc.set("avbqty", (Object)invacc.getBigDecimal("qty").subtract(invacc.getBigDecimal("lockqty")));
            invacc.set("avbbaseqty", (Object)invacc.getBigDecimal("baseqty").subtract(invacc.getBigDecimal("lockbaseqty")));
            invacc.set("avbqty2nd", (Object)invacc.getBigDecimal("qty2nd").subtract(invacc.getBigDecimal("lockqty2nd")));
        }
        this.initControlParam(view, mapParam, invaccs);
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        entryGrid.setStopUpdateCell(true);
        boolean hasMatched = false;
        int middleInsertSkew = 1;
        HashMap<Long, DynamicObject> invaccMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : invaccs) {
            invaccMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        for (Object object : invAccIdArr) {
            DynamicObject invacc = (DynamicObject)invaccMap.get(object);
            boolean isMatch = false;
            int setRow = -1;
            if (this.row > -1 && !hasMatched) {
                if (this.materialCol != null && this.materialValue == null) {
                    isMatch = true;
                }
                if (!isMatch) {
                    DynamicObject entry = (DynamicObject)this.entryEntity.get(this.row);
                    isMatch = this.isMatch(entry, invacc);
                }
                hasMatched = isMatch;
            }
            if (isMatch) {
                setRow = this.row;
            } else if (this.materialCol == null) {
                isMatch = false;
            } else if (this.row == -1) {
                int nullRow = this.getNullRow(this.materialCol);
                if (nullRow == -1) {
                    isMatch = false;
                } else {
                    isMatch = true;
                    setRow = nullRow;
                }
            }
            if (this.billQtyGTInvQty) {
                isMatch = false;
            }
            if (isMatch) {
                this.handleReturnDataInMatchedRow(view, this.updateFields, setRow, invacc);
                continue;
            }
            if (this.newDeal) {
                IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
                pageCache.put(INVENTORY_QUERY, "1");
                if (!this.isDraw) {
                    if (this.middleinsert) {
                        setRow = this.row + middleInsertSkew;
                        this.appendEntryEntity(setRow);
                        ++middleInsertSkew;
                    } else {
                        setRow = this.entryEntity.size();
                        this.appendEntryEntity(setRow);
                    }
                    this.handleReturnDataInNewRow(view, this.returnFields, this.row, setRow, invacc);
                } else {
                    if (this.middleinsert) {
                        setRow = this.row + middleInsertSkew;
                        this.appendEntryEntity(setRow);
                        ++middleInsertSkew;
                        this.copyEntryRelation(setRow, this.chooseEntryLks);
                    } else {
                        setRow = this.entryEntity.size();
                        this.appendEntryEntity(setRow);
                    }
                    this.handleReturnDataInNewRow(view, this.returnFields, this.row, setRow, invacc);
                    this.copySouceFiledsInfo(view, this.row, setRow);
                }
                pageCache.remove(INVENTORY_QUERY);
            }
            this.modelEntryEntity.add(this.entryEntity.get(setRow));
        }
        if (this.billQtyGTInvQty && StringUtils.isNotBlank((CharSequence)this.billBaseQtyCol)) {
            BigDecimal bigDecimal = this.billQtyMap.get(this.billBaseQtyCol);
            DynamicObject entry = (DynamicObject)this.entryEntity.get(this.row);
            entry.set(this.billBaseQtyCol, (Object)bigDecimal);
            if (StringUtils.isNotBlank((CharSequence)this.baseUnitCol) && this.materialValue != null && StringUtils.isNotBlank((CharSequence)this.billQtyCol)) {
                DynamicObject baseUnit = entry.getDynamicObject(this.baseUnitCol);
                Object object = this.materialValue.get(MASTERID);
                if (object instanceof DynamicObject) {
                    Object object2 = ((DynamicObject)object).get(MASTERID);
                }
                if (baseUnit.getPkValue().equals(this.unitValue.getPkValue())) {
                    entry.set(this.billQtyCol, (Object)bigDecimal);
                } else {
                    void var15_24;
                    BigDecimal unitRate = BillUnitHelper.getUnitRateConv((Long)((Long)var15_24), (Long)((Long)baseUnit.getPkValue()), (Long)((Long)this.unitValue.getPkValue()), this.unitCacheMap);
                    BigDecimal remainQty = PrecisionAccountHelper.dealWithprecision((DynamicObject)this.unitValue, (BigDecimal)bigDecimal.multiply(unitRate));
                    entry.set(this.billQtyCol, (Object)remainQty);
                }
            }
        }
        entryGrid.setStopUpdateCell(false);
    }

    private void appendEntryEntity(int entityRow) {
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject newEntry = (DynamicObject)cloneUtils.clone((IDataEntityBase)this.entryEntity.get(this.row));
        newEntry.set("id", (Object)ID.genLongId());
        this.entryEntity.add(entityRow, newEntry);
    }

    private DynamicObject deserializeDynamicFromStr(String targetBillEntityStr) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.billtype);
        Object[] targetBillEntity = DynamicObjectSerializeUtil.deserialize((String)targetBillEntityStr, (DynamicObjectType)dataEntityType);
        return (DynamicObject)targetBillEntity[0];
    }

    private boolean isMatch(DynamicObject entry, DynamicObject invacc) {
        boolean isMatch = true;
        for (Map<String, Object> field : this.matchFields) {
            boolean currentValueIsNull;
            String invaccKey = (String)field.get(KEY_METADATAKEY);
            Object invaccValue = invacc.get(invaccKey);
            String currentKey = this.getPureKey((String)field.get(KEY_CURRENTMETADATAKEY));
            Object currentValue = entry.get(currentKey);
            boolean invaccValueIsNull = invaccValue == null || "".equals(invaccValue);
            boolean bl = currentValueIsNull = currentValue == null || "".equals(currentValue);
            if (invaccValueIsNull && !currentValueIsNull) {
                isMatch = false;
                break;
            }
            if (invaccValueIsNull || currentValueIsNull) continue;
            if (currentValue instanceof DynamicObject) {
                IDataEntityType invaccValueType = ((DynamicObject)invaccValue).getDataEntityType();
                if (BD_MATERIAL.equals(invaccValueType.getName())) {
                    Object billMaterialMasterId;
                    DynamicObject materialInfo = invacc.getDynamicObject(MATERIAL);
                    Object invAccMaterialMasterID = materialInfo.get(MASTERID);
                    if (invAccMaterialMasterID instanceof DynamicObject) {
                        invAccMaterialMasterID = ((DynamicObject)invAccMaterialMasterID).get(MASTERID);
                    }
                    if ((billMaterialMasterId = ((DynamicObject)currentValue).get(MASTERID)) instanceof DynamicObject) {
                        billMaterialMasterId = ((DynamicObject)billMaterialMasterId).get(MASTERID);
                    }
                    if (billMaterialMasterId.equals(invAccMaterialMasterID)) continue;
                    isMatch = false;
                    break;
                }
                if (((DynamicObject)invaccValue).getPkValue().equals(((DynamicObject)currentValue).getPkValue())) continue;
                isMatch = false;
                break;
            }
            if (currentValue.equals(invaccValue)) continue;
            isMatch = false;
            break;
        }
        return isMatch;
    }

    private void initControlParam(IFormView view, Map<String, Object> mapParam, DynamicObject[] invaccs) {
        BigDecimal bigDecimal;
        String entryNoUpdateFieldkey;
        Map settingParam = (Map)mapParam.get("settingparam");
        List fields = (List)mapParam.get("fielddata");
        this.appid = view.getModel().getDataEntityType().getAppId();
        this.billtype = (String)mapParam.get("targetBillType");
        this.entrykey = (String)settingParam.get("entrykey");
        this.operatekey = (String)settingParam.get("operatekey");
        this.entrykey_lk = this.getLinkEntityKey();
        this.targetBillEntity = this.deserializeDynamicFromStr((String)mapParam.get("targetBillEntity"));
        this.entryEntity = this.targetBillEntity.getDynamicObjectCollection(this.entrykey);
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        this.row = (Integer)mapParam.get("row");
        this.qtyRule = (String)settingParam.get("qtyrule");
        this.newDeal = (Boolean)settingParam.get("newdeal");
        this.isDraw = (Boolean)mapParam.get("isDraw");
        if (fields != null) {
            for (Map field : fields) {
                String currentKey = (String)field.get(KEY_CURRENTMETADATAKEY);
                if (!StringUtils.isNotBlank((CharSequence)currentKey)) continue;
                boolean isUpdateField = (Boolean)field.get(KEY_UPDATE);
                boolean isMatchField = (Boolean)field.get(KEY_MATCH);
                if (isUpdateField) {
                    this.updateFields.add(field);
                }
                if (isMatchField) {
                    this.matchFields.add(field);
                }
                if (!isUpdateField && !isMatchField) continue;
                this.returnFields.add(field);
            }
        }
        this.expandUpdateFields = (List)mapParam.get("expandUpdateFields");
        this.materialCol = this.getBillMatKey(this.matchFields);
        this.isUseLotMF = (Boolean)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"isUseLotMainFile", (Object[])new Object[0]);
        this.lotidCol = this.getLotidCol(this.targetBillEntity, this.updateFields);
        this.lotMainFileMap = Collections.emptyMap();
        if (this.isUseLotMF.booleanValue() && this.lotidCol != null) {
            this.lotMainFileMap = this.getLotMainFileByInvaccs(invaccs);
            if (this.row > -1) {
                this.lotMainFileReturnParamMaps = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getReturnParamMapping", (Object[])new Object[]{this.targetBillEntity, this.targetBillEntity.getDynamicObjectCollection(this.entrykey).get(this.row), this.lotidCol});
            }
            this.lotidCol = this.getPureKey(this.lotidCol);
        }
        IDataEntityType dataEntityType = this.targetBillEntity.getDataEntityType();
        this.allFields = ((EntityType)((BillEntityType)dataEntityType).getAllEntities().get(this.entrykey)).getFields();
        this.isContainLinetype = this.allFields.containsKey("linetype");
        this.isContainProductType = this.allFields.containsKey("producttype");
        this.defLinetypePK = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_linetype", (QFilter[])new QFilter("number", "=", (Object)"010").toArray()).getPkValue();
        DynamicObjectCollection entryEntity = this.targetBillEntity.getDynamicObjectCollection(this.entrykey);
        DynamicObject entry = (DynamicObject)entryEntity.get(this.row);
        Map<String, String> qtyKeyMap = this.getBillQtyAndQty2ndKey(this.returnFields);
        String qtyUnit2ndCol = qtyKeyMap.get("qtyunit2nd");
        String qtyCol = qtyKeyMap.get("qty");
        if (StringUtils.isNotBlank((CharSequence)qtyUnit2ndCol) && StringUtils.isNotBlank((CharSequence)qtyCol) && this.row > -1) {
            BigDecimal pageQty2nd = entry.getBigDecimal(qtyUnit2ndCol);
            BigDecimal pageQty = (BigDecimal)entry.get(qtyCol);
            this.updateQty2ndZero = pageQty != null && pageQty.compareTo(BigDecimal.ZERO) != 0 && (pageQty2nd == null || pageQty2nd.compareTo(BigDecimal.ZERO) == 0);
        }
        this.unittran = (Boolean)settingParam.get("unittran");
        this.unitCol = this.getBillUnitKey((List)mapParam.get("fielddata"));
        if (StringUtils.isNotBlank((CharSequence)this.materialCol) && this.row > -1) {
            this.materialValue = (DynamicObject)entry.get(this.materialCol);
        }
        if (StringUtils.isNotBlank((CharSequence)this.unitCol) && this.row > -1) {
            this.unitValue = (DynamicObject)entry.get(this.unitCol);
        }
        if (this.unittran && (this.row == -1 || this.materialValue == null || this.unitValue == null)) {
            this.unittran = false;
        }
        this.middleinsert = (Boolean)settingParam.get("middleinsert");
        if (this.row == -1) {
            this.middleinsert = false;
        }
        if (this.middleinsert && this.isDraw) {
            this.chooseEntryLks = entry.getDynamicObjectCollection(this.entrykey_lk);
        }
        if (StringUtils.isNotBlank((CharSequence)(entryNoUpdateFieldkey = (String)settingParam.get("entrynoupdatefieldkey"))) && this.row > -1) {
            String entryNoUpdateFieldValue = (String)entry.get(entryNoUpdateFieldkey);
            this.entryNoUpdateFieldValueList = NoUpdateFieldsAnalysisExtHelper.getNoUpdateFieldsList((String)entryNoUpdateFieldValue);
        }
        String invBaseQtyCol = null;
        if (this.row > -1) {
            for (Map<String, Object> map : this.updateFields) {
                String key = (String)map.get(KEY_METADATAKEY);
                String currentKey = this.getPureKey((String)map.get(KEY_CURRENTMETADATAKEY));
                if (StringUtils.isNotBlank((CharSequence)key) && ALLQTYFIELDS.contains(key)) {
                    BigDecimal reqQty = (BigDecimal)entry.get(currentKey);
                    this.billQtyMap.put(currentKey, reqQty);
                }
                if (StringUtils.isNotBlank((CharSequence)key) && BASEQTYFIELDS.contains(key)) {
                    this.billBaseQtyCol = currentKey;
                    invBaseQtyCol = key;
                }
                if (StringUtils.isNotBlank((CharSequence)key) && UNITQTYFIELDS.contains(key)) {
                    this.billQtyCol = currentKey;
                }
                if (!StringUtils.isNotBlank((CharSequence)key) || !"baseunit".equals(key)) continue;
                this.baseUnitCol = currentKey;
            }
        }
        BigDecimal invSumBaseQty = BigDecimal.ZERO;
        for (DynamicObject invAcc : invaccs) {
            BigDecimal pageQty;
            boolean isMatch;
            boolean bl = isMatch = this.row > -1 && this.isMatch(entry, invAcc);
            if (this.row > -1 && ((pageQty = (BigDecimal)entry.get(qtyCol)) == null || pageQty.compareTo(BigDecimal.ZERO) == 0)) {
                isMatch = false;
            }
            this.matchMap.put(invAcc.getLong("id"), isMatch);
            if (!"reqqty".equals(this.qtyRule) || this.row <= -1 || !isMatch || !StringUtils.isNotBlank((CharSequence)invBaseQtyCol) || !StringUtils.isNotBlank((CharSequence)this.billBaseQtyCol)) continue;
            BigDecimal invBaseQty = invAcc.getBigDecimal(invBaseQtyCol);
            invSumBaseQty = invSumBaseQty.add(invBaseQty);
        }
        this.billQtyGTInvQty = false;
        if ("reqqty".equals(this.qtyRule) && this.row > -1 && StringUtils.isNotBlank((CharSequence)this.billBaseQtyCol) && (bigDecimal = this.billQtyMap.get(this.billBaseQtyCol)).compareTo(invSumBaseQty) > 0) {
            this.billQtyGTInvQty = true;
        }
    }

    private String getPureKey(String currentKey) {
        if (currentKey.lastIndexOf(46) != -1) {
            return currentKey.substring(currentKey.lastIndexOf(46) + 1);
        }
        return currentKey;
    }

    private String getBillMatKey(List<Map<String, Object>> matchFields) {
        for (Map<String, Object> field : matchFields) {
            String key = (String)field.get(KEY_METADATAKEY);
            if (!key.equals(MATERIAL)) continue;
            String currentKey = this.getPureKey((String)field.get(KEY_CURRENTMETADATAKEY));
            return currentKey;
        }
        return null;
    }

    private Map<String, String> getBillQtyAndQty2ndKey(List<Map<String, Object>> matchFields) {
        HashMap<String, String> keyMap = new HashMap<String, String>();
        for (Map<String, Object> field : matchFields) {
            String key = (String)field.get(KEY_METADATAKEY);
            String currentKey = this.getPureKey((String)field.get(KEY_CURRENTMETADATAKEY));
            if ("avbqty".equals(key) || "qty".equals(key)) {
                keyMap.put("qty", currentKey);
            }
            if (!"avbqty2nd".equals(key) && !"qty2nd".equals(key)) continue;
            keyMap.put("qtyunit2nd", currentKey);
        }
        return keyMap;
    }

    private String getBillUnitKey(List<Map<String, Object>> updateFields) {
        if (updateFields != null) {
            for (Map<String, Object> field : updateFields) {
                String key = (String)field.get(KEY_METADATAKEY);
                if (!key.equals("unit")) continue;
                String currentKey = this.getPureKey((String)field.get(KEY_CURRENTMETADATAKEY));
                return currentKey;
            }
        }
        return null;
    }

    private DynamicObject getMaterialStrategy(String currentKey, DynamicObject invacc) {
        String orgName;
        long orgId;
        IDataEntityType strategyType = ((MaterielProp)MetadataServiceHelper.getDataEntityType((String)this.billtype).getAllFields().get(currentKey)).getComplexType();
        String materialStrategy = strategyType.getName();
        if (materialStrategy.equals(BD_MATERIAL)) {
            return null;
        }
        DynamicObject material = invacc.getDynamicObject(MATERIAL);
        DynamicObject accOrg = invacc.getDynamicObject("org");
        String materialName = material.getLocaleString("name").getLocaleValue();
        String materialStrategyname = strategyType.getDisplayName().getLocaleValue();
        if (BD_MATERIALINVENTORYINFO.equals(materialStrategy)) {
            orgId = Long.parseLong(accOrg.getPkValue().toString());
            orgName = accOrg.getLocaleString("name").getLocaleValue();
        } else {
            DynamicObject orgDyc = (DynamicObject)this.targetBillEntity.get("org");
            if (orgDyc == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InventoryQuery_2", (String)"bos-ext-scmc", (Object[])new Object[0]));
            }
            orgId = Long.parseLong(orgDyc.getPkValue().toString());
            orgName = orgDyc.getLocaleString("name").getLocaleValue();
        }
        QFilter qFilter = new QFilter("masterid.id", "=", material.getPkValue());
        material = this.getMaterialStrategyDyc(qFilter, orgId, materialStrategy, orgName, materialName, materialStrategyname);
        return material;
    }

    private DynamicObject getMaterialStrategyDyc(QFilter qFilter, long orgId, String materialFormId, String orgName, String materialName, String strategyName) {
        qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)materialFormId, (Long)orgId));
        DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((String)materialFormId, (QFilter[])new QFilter[]{qFilter});
        if (material == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u3010%s\u3011\u4e0b\u3010%s\u3011\u7684%s\u3002", (String)"InventoryQuery_0", (String)"bos-ext-scmc", (Object[])new Object[0]), orgName, materialName, strategyName));
        }
        return material;
    }

    private Map<Long, Long> getLotMainFileByInvaccs(DynamicObject[] invaccs) {
        HashMap<Long, Long> map = new HashMap<Long, Long>(invaccs.length);
        RowMeta billentryRowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("matPK", (DataType)DataType.LongType), new Field("orgId", (DataType)DataType.LongType), new Field("lotnum", (DataType)DataType.StringType)});
        DataSetBuilder billentryDsBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(billentryRowMeta);
        HashSet<String> lotnums = new HashSet<String>(invaccs.length);
        for (DynamicObject invacc : invaccs) {
            String lotnum = invacc.getString("lotnum");
            if (lotnum == null || lotnum.isEmpty()) continue;
            Object orgId = invacc.getDynamicObject("org").getPkValue();
            Object matPK = invacc.getDynamicObject(MATERIAL).getPkValue();
            Object id = invacc.getPkValue();
            lotnums.add(lotnum);
            billentryDsBuilder.append(new Object[]{id, matPK, orgId, lotnum});
        }
        if (!lotnums.isEmpty()) {
            DataSet billentryDataSet = billentryDsBuilder.build();
            DataSet lotMainFileDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_lot", (String)"id as mainfileid,number as mflotnumber, material as mfmaterialid,createorg as mfinvorg", (QFilter[])new QFilter("number", "in", lotnums).and("masterfiletype", "=", (Object)this.lottypeid).toArray(), (String)"");
            JoinDataSet tempDataSet = billentryDataSet.leftJoin(lotMainFileDataSet).on("lotnum", "mflotnumber");
            Integer unqCtrl = (Integer)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getUnqctrl", (Object[])new Object[0]);
            if (unqCtrl == 2 || unqCtrl == 4) {
                tempDataSet.on("matPK", "mfmaterialid");
            }
            if (unqCtrl == 3 || unqCtrl == 4) {
                tempDataSet.on("orgId", "mfinvorg");
            }
            DataSet billLotRelWithMatDataSet = tempDataSet.select(billentryDataSet.getRowMeta().getFieldNames(), lotMainFileDataSet.getRowMeta().getFieldNames()).finish();
            while (billLotRelWithMatDataSet.hasNext()) {
                Row row = billLotRelWithMatDataSet.next();
                map.put(row.getLong("id"), row.getLong("mainfileid"));
            }
        }
        return map;
    }

    private int getNullRow(String matKey) {
        DynamicObjectCollection entryCols = this.targetBillEntity.getDynamicObjectCollection(this.entrykey);
        if (this.entrykey == null) {
            return -1;
        }
        if (entryCols == null || entryCols.size() == 0) {
            return -1;
        }
        for (int i = 0; i < entryCols.size(); ++i) {
            if (((DynamicObject)entryCols.get(i)).getDynamicObject(matKey) != null) continue;
            if (this.isContainProductType.booleanValue()) {
                String productType = ((DynamicObject)entryCols.get(i)).getString("producttype");
                if ("kitparent".equals(productType) || "kitchild".equals(productType)) continue;
                return i;
            }
            return i;
        }
        return -1;
    }

    private void setLineType(IDataModel model, int row) {
        if (this.isContainLinetype.booleanValue()) {
            model.beginInit();
            model.setValue("linetype", this.defLinetypePK, row);
            model.endInit();
        }
    }

    private String getLotidCol(DynamicObject targetBillEntity, List<Map<String, Object>> updateFields) {
        if (!this.isUseLotMF.booleanValue()) {
            return null;
        }
        String lotnumKey = null;
        for (Map<String, Object> field : updateFields) {
            String key = (String)field.get(KEY_METADATAKEY);
            if (!"lotnum".equals(key)) continue;
            lotnumKey = (String)field.get(KEY_CURRENTMETADATAKEY);
            break;
        }
        if (lotnumKey != null) {
            DynamicObject bill = targetBillEntity;
            Set lotCfgs = (Set)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getLotMainFileBillConfigByBillAndLotNum", (Object[])new Object[]{this.billtype, this.entrykey, bill, lotnumKey});
            if (lotCfgs == null || lotCfgs.size() == 0) {
                return null;
            }
            DynamicObject lotCfg = (DynamicObject)new ArrayList(lotCfgs).get(0);
            String lotidCol = lotCfg.getString("lotidfield");
            this.lottypeid = lotCfg.getDynamicObject("masterfiletype").getLong("id");
            return lotidCol;
        }
        return null;
    }

    private void setLotIdValue(int row, Long invaccId) {
        if (this.lotidCol != null) {
            DynamicObjectCollection entryEntity = this.targetBillEntity.getDynamicObjectCollection(this.entrykey);
            DynamicObject entry = (DynamicObject)entryEntity.get(row);
            Long lotid = this.lotMainFileMap.getOrDefault(invaccId, 0L);
            entry.set(this.lotidCol, (Object)lotid);
        }
    }

    private void setNotAccFields(DynamicObject targetBillEntity, List<Map<String, Object>> returnFields, int selectRow, int newRow, boolean materialSame) {
        if (selectRow > -1 && materialSame) {
            HashSet<String> entryFillFields = new HashSet<String>(returnFields.size());
            for (Map<String, Object> field : returnFields) {
                String currentKey = this.getPureKey((String)field.get(KEY_CURRENTMETADATAKEY));
                entryFillFields.add(currentKey);
            }
            if (this.lotidCol != null) {
                entryFillFields.add(this.lotidCol);
                for (String lotMainFileReturnField : this.lotMainFileReturnParamMaps.values()) {
                    entryFillFields.add(this.getPureKey(lotMainFileReturnField));
                }
            }
            DynamicObjectCollection entryEntity = targetBillEntity.getDynamicObjectCollection(this.entrykey);
            DynamicObject entry = (DynamicObject)entryEntity.get(selectRow);
            for (Map.Entry<String, IDataEntityProperty> entryField : this.allFields.entrySet()) {
                String field = entryField.getKey();
                IFieldHandle fieldHandle = (IFieldHandle)entryField.getValue();
                boolean copyable = fieldHandle.isCopyable();
                if (entryFillFields.contains(field) || !copyable) continue;
                DynamicObject newEntry = (DynamicObject)entryEntity.get(newRow);
                newEntry.set(field, entry.get(field));
            }
        }
    }

    private void handleReturnDataInMatchedRow(IFormView view, List<Map<String, Object>> updateFields, int row, DynamicObject invacc) {
        DynamicObject entry = (DynamicObject)this.entryEntity.get(row);
        if (this.row == -1) {
            // empty if block
        }
        HashMap<String, BigDecimal> avbQtyMap = new HashMap<String, BigDecimal>(3);
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>(3);
        HashMap<String, String> invQtyMap = new HashMap<String, String>(9);
        Long materialmasterid = 0L;
        for (Map<String, Object> field : updateFields) {
            IDataEntityType accType;
            String key = (String)field.get(KEY_METADATAKEY);
            String currentKey = this.getPureKey((String)field.get(KEY_CURRENTMETADATAKEY));
            String returnKey = (String)field.get(KEY_RETURNCL);
            if (StringUtils.isNotEmpty((CharSequence)returnKey)) {
                returnKey = this.getPureKey((String)field.get(KEY_RETURNCL));
            }
            if (this.entryNoUpdateFieldValueList.contains(currentKey)) continue;
            if (StringUtils.isNotBlank((CharSequence)key) && ALLQTYFIELDS.contains(key)) {
                BigDecimal value;
                BigDecimal reqqty = entry.getBigDecimal(currentKey);
                BigDecimal proqty = (BigDecimal)invacc.get(key);
                if (this.unittran && UNITQTYFIELDS.contains(key)) {
                    DynamicObject rowUnitValue = invacc.getDynamicObject("unit");
                    BigDecimal unitRate = BillUnitHelper.getUnitRateConv((Long)materialmasterid, (Long)((Long)rowUnitValue.getPkValue()), (Long)((Long)this.unitValue.getPkValue()), this.unitCacheMap);
                    proqty = PrecisionAccountHelper.dealWithprecision((DynamicObject)this.unitValue, (BigDecimal)proqty.multiply(unitRate));
                }
                if (reqqty == null || reqqty.compareTo(new BigDecimal(0)) == 0 || "proqty".equals(this.qtyRule)) {
                    value = proqty;
                } else {
                    BigDecimal bigDecimal = value = reqqty.compareTo(proqty) > 0 ? proqty : reqqty;
                }
                if (value.compareTo(BigDecimal.ZERO) > 0 || NEGATIVE_BILLS.contains(view.getEntityId())) {
                    this.billQtyMap.put(currentKey, this.billQtyMap.getOrDefault(currentKey, BigDecimal.ZERO).subtract(value));
                }
                this.setModelValue(view, row, currentKey, value, key);
                if (StringUtils.isNotEmpty((CharSequence)returnKey)) {
                    this.setModelValue(view, row, returnKey, value, key);
                }
                if (AVBFIELDS.contains(key)) {
                    avbQtyMap.put(currentKey, value);
                } else if (QTYFIELDS.contains(key)) {
                    qtyMap.put(currentKey, value);
                }
                invQtyMap.put(key, currentKey);
                continue;
            }
            if (this.unittran && "unit".equals(key)) continue;
            Object accValue = invacc.get(key);
            if (accValue instanceof DynamicObject && BD_MATERIAL.equals((accType = ((DynamicObject)accValue).getDataEntityType()).getName())) {
                DynamicObject materialStrategy = this.getMaterialStrategy(currentKey, invacc);
                DynamicObject matPK = materialStrategy == null ? (DynamicObject)accValue : materialStrategy;
                entry.set(currentKey, (Object)matPK);
                materialmasterid = ((DynamicObject)accValue).getLong("id");
                continue;
            }
            this.setModelValue(view, row, currentKey, accValue, key);
            if (StringUtils.isNotEmpty((CharSequence)returnKey)) {
                this.setModelValue(view, row, returnKey, accValue, key);
            }
            if (!this.isUseLotMF.booleanValue() || !"lotnum".equals(key)) continue;
            Long invaccId = invacc.getLong("id");
            this.setLotIdValue(row, invaccId);
        }
        this.setExpandUpdateFields(view, row, invacc);
        this.setBillQtyByDirFromQty(view, row, qtyMap, invQtyMap, "qty", "qty2nd");
        this.setBillQtyByDirFromQty(view, row, avbQtyMap, invQtyMap, "avbqty", "avbqty2nd");
        if (enableApps.contains(this.appid)) {
            DispatchServiceHelper.invokeBizService((String)"scmc", (String)this.appid, (String)"InvqueryService", (String)"afterReturnRow", (Object[])new Object[]{view, this.entrykey, row, row, this.operatekey});
        }
    }

    private void handleReturnDataInNewRow(IFormView view, List<Map<String, Object>> returnFields, int selectRow, int newRow, DynamicObject invacc) {
        DynamicObject entry = (DynamicObject)this.entryEntity.get(newRow);
        if (enableApps.contains(this.appid)) {
            DispatchServiceHelper.invokeBizService((String)"scmc", (String)this.appid, (String)"InvqueryService", (String)"beforeCreateRow", (Object[])new Object[]{view, this.entrykey, selectRow, newRow, this.operatekey});
        }
        boolean isMatch = this.matchMap.get(invacc.getLong("id"));
        boolean materialSame = false;
        HashMap<String, BigDecimal> avbQtyMap = new HashMap<String, BigDecimal>(3);
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>(3);
        HashMap<String, String> invQtyMap = new HashMap<String, String>(9);
        Long materialmasterid = 0L;
        for (Map<String, Object> field : returnFields) {
            IDataEntityType accType;
            Object accValue;
            String key = (String)field.get(KEY_METADATAKEY);
            String currentKey = this.getPureKey((String)field.get(KEY_CURRENTMETADATAKEY));
            String returnKey = (String)field.get(KEY_RETURNCL);
            if (StringUtils.isNotEmpty((CharSequence)returnKey)) {
                returnKey = this.getPureKey(returnKey);
            }
            if ((accValue = invacc.get(key)) instanceof DynamicObject && BD_MATERIAL.equals((accType = ((DynamicObject)accValue).getDataEntityType()).getName())) {
                DynamicObject materialStrategy = this.getMaterialStrategy(currentKey, invacc);
                DynamicObject matPK = materialStrategy == null ? (DynamicObject)accValue : materialStrategy;
                entry.set(currentKey, null);
                if (StringUtils.isNotEmpty((CharSequence)returnKey)) {
                    entry.set(returnKey, null);
                }
                entry.set(currentKey, (Object)matPK);
                if (StringUtils.isNotEmpty((CharSequence)returnKey)) {
                    entry.set(returnKey, (Object)matPK);
                }
                if (this.materialValue != null) {
                    materialSame = matPK.getPkValue().equals(this.materialValue.getPkValue());
                }
                materialmasterid = ((DynamicObject)accValue).getLong("id");
                continue;
            }
            if (this.unittran && materialSame && "unit".equals(key)) {
                this.setModelValue(view, newRow, currentKey, this.unitValue, key);
                if (!StringUtils.isNotEmpty((CharSequence)returnKey)) continue;
                this.setModelValue(view, newRow, returnKey, this.unitValue, key);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)key) && ALLQTYFIELDS.contains(key)) {
                BigDecimal accBigDecimal = (BigDecimal)accValue;
                if (this.unittran && materialSame && UNITQTYFIELDS.contains(key)) {
                    DynamicObject rowUnitValue = invacc.getDynamicObject("unit");
                    BigDecimal unitRate = BillUnitHelper.getUnitRateConv((Long)materialmasterid, (Long)((Long)rowUnitValue.getPkValue()), (Long)((Long)this.unitValue.getPkValue()), this.unitCacheMap);
                    accBigDecimal = PrecisionAccountHelper.dealWithprecision((DynamicObject)this.unitValue, (BigDecimal)accBigDecimal.multiply(unitRate));
                }
                BigDecimal qtyValue = accBigDecimal;
                if (isMatch) {
                    BigDecimal reqQty = this.billQtyMap.get(currentKey);
                    if (reqQty.compareTo(BigDecimal.ZERO) < 0) {
                        reqQty = BigDecimal.ZERO;
                    }
                    if ("proqty".equals(this.qtyRule)) {
                        qtyValue = accBigDecimal;
                    } else {
                        BigDecimal bigDecimal = qtyValue = reqQty.compareTo(accBigDecimal) > 0 ? accBigDecimal : reqQty;
                    }
                    if (qtyValue.compareTo(BigDecimal.ZERO) > 0 || NEGATIVE_BILLS.contains(view.getEntityId())) {
                        this.billQtyMap.put(currentKey, reqQty.subtract(qtyValue));
                    }
                }
                if (AVBFIELDS.contains(key)) {
                    avbQtyMap.put(currentKey, qtyValue);
                } else if (QTYFIELDS.contains(key)) {
                    qtyMap.put(currentKey, qtyValue);
                }
                invQtyMap.put(key, currentKey);
                this.setModelValue(view, newRow, currentKey, qtyValue, key);
                if (!StringUtils.isNotEmpty((CharSequence)returnKey)) continue;
                this.setModelValue(view, newRow, returnKey, qtyValue, key);
                continue;
            }
            this.setModelValue(view, newRow, currentKey, accValue, key);
            if (StringUtils.isNotEmpty((CharSequence)returnKey)) {
                this.setModelValue(view, newRow, returnKey, accValue, key);
            }
            if (!this.isUseLotMF.booleanValue() || !"lotnum".equals(key)) continue;
            Long invaccId = invacc.getLong("id");
            this.setLotIdValue(newRow, invaccId);
        }
        this.setNotAccFields(this.targetBillEntity, returnFields, selectRow, newRow, materialSame);
        this.setExpandUpdateFields(view, newRow, invacc);
        this.setBillQtyByDirFromQty(view, newRow, qtyMap, invQtyMap, "qty", "qty2nd");
        this.setBillQtyByDirFromQty(view, newRow, avbQtyMap, invQtyMap, "avbqty", "avbqty2nd");
        if (enableApps.contains(this.appid)) {
            DispatchServiceHelper.invokeBizService((String)"scmc", (String)this.appid, (String)"InvqueryService", (String)"afterReturnRow", (Object[])new Object[]{view, this.entrykey, selectRow, newRow, this.operatekey});
        }
    }

    private void copySouceFiledsInfo(IFormView view, int currentRow, int newRow) {
        DynamicObject rowData = (DynamicObject)this.entryEntity.get(currentRow);
        DynamicObject newRowData = (DynamicObject)this.entryEntity.get(newRow);
        newRowData.getDataEntityState().setPushChanged(true);
        for (String key : SCMC_SOURCE_COLS) {
            if (!this.allFields.containsKey(key)) continue;
            newRowData.set(key, rowData.get(key));
            view.updateView(key, newRow);
        }
    }

    private void setBillQty(int row, Map<String, BigDecimal> qtyMap, Map<String, String> invQtyMap, String invQtyCol) {
        String invQtyBillCol = invQtyMap.get(invQtyCol);
        DynamicObject entry = (DynamicObject)this.entryEntity.get(row);
        if (invQtyBillCol != null) {
            entry.set(invQtyBillCol, (Object)BigDecimal.ONE.negate());
            entry.set(invQtyBillCol, (Object)qtyMap.get(invQtyBillCol));
        }
    }

    private void setBillQtyByDirFromQty(IFormView view, int setRow, Map<String, BigDecimal> qtyMap, Map<String, String> invQtyMap, String qtyCol, String qty2ndCol) {
        String qty2ndBillCol = invQtyMap.get(qty2ndCol);
        if (qty2ndBillCol == null) {
            return;
        }
        if (this.updateQty2ndZero) {
            this.setModelValue(view, setRow, qty2ndBillCol, BigDecimal.ZERO, qty2ndCol);
        } else if (qty2ndBillCol != null) {
            BigDecimal avbqty2ndValue = qtyMap.get(qty2ndBillCol).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : qtyMap.get(qty2ndBillCol);
            this.setModelValue(view, setRow, qty2ndBillCol, avbqty2ndValue, qty2ndCol);
        }
    }

    private String getLinkEntityKey() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.billtype);
        Map allEntities = mainType.getAllEntities();
        for (EntityType entity : allEntities.values()) {
            if (!(entity instanceof LinkEntryType) || !this.entrykey.equals(entity.getParent().getName())) continue;
            return entity.getName();
        }
        return "";
    }

    private DynamicObjectCollection getSrcRowRelation(IDataModel model) {
        DynamicObjectCollection entrys = model.getEntryEntity(this.entrykey);
        DynamicObject selectedEntry = (DynamicObject)entrys.get(this.row);
        return selectedEntry.getDynamicObjectCollection(this.entrykey_lk);
    }

    private void copyEntryRelation(int setRow, DynamicObjectCollection srcEntryLks) {
        if (srcEntryLks == null || srcEntryLks.isEmpty()) {
            return;
        }
        DynamicObject entry = (DynamicObject)this.targetBillEntity.getDynamicObjectCollection(this.entrykey).get(setRow);
        DynamicObjectCollection newEntryLk = entry.getDynamicObjectCollection(this.entrykey_lk);
        for (DynamicObject srcEntryLk : srcEntryLks) {
            DynamicObject newLk = new DynamicObject(srcEntryLk.getDynamicObjectType());
            newLk.set("seq", srcEntryLk.get("seq"));
            newLk.set(this.entrykey_lk + "_stableid", srcEntryLk.get(this.entrykey_lk + "_stableid"));
            newLk.set(this.entrykey_lk + "_sbillid", srcEntryLk.get(this.entrykey_lk + "_sbillid"));
            newLk.set(this.entrykey_lk + "_sid", srcEntryLk.get(this.entrykey_lk + "_sid"));
            newEntryLk.add((Object)newLk);
        }
    }

    private void setExpandUpdateFields(IFormView view, int row, DynamicObject invacc) {
        for (Map<String, String> field : this.expandUpdateFields) {
            String currentkey = field.get(EXPANDUPDATE_KEY);
            String type = field.get(EXPANDUPDATE_TYPE);
            String formula = field.get(EXPANDUPDATE_FORMULA);
            switch (type) {
                case "acc": {
                    Object value = invacc.get(formula);
                    this.setModelValue(view, row, this.getPureKey(currentkey), value, formula);
                    break;
                }
                case "fix": {
                    this.setModelValue(view, row, this.getPureKey(currentkey), formula, null);
                }
            }
        }
    }

    private void setModelValue(IFormView view, int row, String currentKey, Object value, String invaccCol) {
        DynamicObjectCollection entryEntity = this.targetBillEntity.getDynamicObjectCollection(this.entrykey);
        DynamicObject entry = (DynamicObject)entryEntity.get(row);
        entry.set(currentKey, value);
        if (value instanceof BigDecimal && ((BigDecimal)value).compareTo(BigDecimal.ZERO) < 0) {
            entry.set(currentKey, (Object)BigDecimal.ZERO);
        }
    }

    private boolean isFireEventAfterAddRow() {
        return false;
    }

    private void mergeReverseQty(Long[] invAccIdArr, DynamicObject[] invaccs) {
        if (invAccIdArr == null || invAccIdArr.length == 0 || invaccs == null || invaccs.length == 0 || !this.getScmParam()) {
            return;
        }
        QFilter spFilter = new QFilter("invid", "in", (Object)invAccIdArr);
        DataSet spReserveDataSet = QueryServiceHelper.queryDataSet((String)"InventoryQueryCallBack", (String)"msmod_reserve_bal_sp", (String)"invid,baseqty as lockbaseqty,qty as lockqty,qty2nd as lockqty2nd", (QFilter[])spFilter.toArray(), null);
        if (!spReserveDataSet.hasNext()) {
            return;
        }
        spReserveDataSet = spReserveDataSet.groupBy(new String[]{"invid"}).sum("lockbaseqty").sum("lockqty").sum("lockqty2nd").finish();
        block0: while (spReserveDataSet.hasNext()) {
            Row spReserveData = spReserveDataSet.next();
            for (DynamicObject invAcc : invaccs) {
                if (!spReserveData.getLong("invid").equals(invAcc.getLong("id"))) continue;
                this.addSpQty(invAcc, spReserveData, "lockqty");
                this.addSpQty(invAcc, spReserveData, "lockbaseqty");
                this.addSpQty(invAcc, spReserveData, "lockqty2nd");
                continue block0;
            }
        }
    }

    private void addSpQty(DynamicObject invAcc, Row row, String key) {
        BigDecimal lockQty = invAcc.getBigDecimal(key);
        BigDecimal lockQtySp = row.getBigDecimal(key);
        invAcc.set(key, (Object)lockQty.add(lockQtySp));
    }

    private boolean getScmParam() {
        QFilter qFilter = new QFilter("number", "=", (Object)"INV0007");
        DynamicObject scmParam = QueryServiceHelper.queryOne((String)"sbs_scmcapplevelparam", (String)"enable", (QFilter[])qFilter.toArray());
        if (scmParam == null) {
            return false;
        }
        return scmParam.getBoolean("enable");
    }
}

