/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.acc.balance;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.utils.CommonUtils;

public class QueryMaterialInvAccSimpPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String KEY_ENTRYENTITY = "entryentity";

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "org": {
                this.getModel().beginInit();
                this.getModel().setValue("material", null);
                this.getModel().endInit();
                this.getView().updateView("material");
                this.getModel().deleteEntryData(KEY_ENTRYENTITY);
                break;
            }
            case "material": {
                this.queryInventory();
                break;
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String formid = showParameter.getFormId();
        List orgs = NewInvOrgHelper.getHasPermissionAndStartedInvOrg((String)formid, (String)showParameter.getAppId());
        if (CommonUtils.isNull((Object)orgs)) {
            e.setCancel(true);
            return;
        }
        ArrayList<Long> idList = new ArrayList<Long>(orgs.size());
        for (Map org : orgs) {
            Long orgId = Long.valueOf((String)org.get("id"));
            idList.add(orgId);
        }
        showParameter.getCustomParams().put("HasPermissionAndStartedInvOrg", SerializationUtils.toJsonString(idList));
    }

    public void registerListener(EventObject e) {
        BasedataEdit matEdit;
        super.registerListener(e);
        OrgEdit orgEdit = (OrgEdit)this.getView().getControl("org");
        if (orgEdit != null) {
            orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((matEdit = (BasedataEdit)this.getView().getControl("material")) != null) {
            matEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "org": {
                String pkSet = (String)this.getView().getFormShowParameter().getCustomParams().get("HasPermissionAndStartedInvOrg");
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)pkSet, List.class)));
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        String org = (String)this.getView().getFormShowParameter().getCustomParam("HasPermissionAndStartedInvOrg");
        if (StringUtils.isNotEmpty((CharSequence)org)) {
            Object orgId = this.getView().getFormShowParameter().getCustomParam("org");
            List orgIds = (List)SerializationUtils.fromJsonString((String)org, List.class);
            if (orgIds.contains(orgId)) {
                this.getModel().setValue("org", orgId);
            } else {
                this.getModel().setValue("org", orgIds.get(0));
            }
        }
    }

    private void queryInventory() {
        IDataModel model = this.getModel();
        Object orgValue = model.getValue("org");
        Object materielValue = model.getValue("material");
        if (CommonUtils.isNull((Object)orgValue)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"QueryMaterialInvAccSimpPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        if (CommonUtils.isNull((Object)materielValue)) {
            return;
        }
        model.deleteEntryData(KEY_ENTRYENTITY);
        List<Map<String, Object>> list = this.getInVaccData();
        if (list != null && list.size() > 0) {
            int size = list.size();
            model.batchCreateNewEntryRow(KEY_ENTRYENTITY, size);
            for (int i = 0; i < size; ++i) {
                Map<String, Object> map = list.get(i);
                model.setValue("warehouse", map.get("warehouse"), i);
                model.setValue("qty", map.get("qty"), i);
                model.setValue("unit", map.get("unit"), i);
                model.setValue("ownertype", map.get("ownertype"), i);
                model.setValue("owner", map.get("owner"), i);
                model.setValue("invstatus", map.get("invstatus"), i);
            }
        }
    }

    private List<Map<String, Object>> getInVaccData() {
        IDataModel model = this.getModel();
        DynamicObject orgValue = (DynamicObject)model.getValue("org");
        DynamicObject materielValue = (DynamicObject)model.getValue("material");
        Object materialId = 0L;
        String name = materielValue.getDataEntityType().getName();
        materialId = "bd_material".equals(name) ? materielValue.getPkValue() : materielValue.getDynamicObject("masterid").getPkValue();
        QFilter f1 = new QFilter("org", "=", orgValue.getPkValue());
        QFilter f2 = new QFilter("material", "=", materialId);
        QFilter[] filter = new QFilter[]{f1, f2};
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getDataCount"), (String)InvAccConst.getBalTb(), (String)"warehouse,qty,unit,ownertype,owner,invstatus", (QFilter[])filter, null);
             DataSet dataSet = queryDataSet.groupBy(new String[]{"warehouse", "ownertype", "owner", "invstatus", "unit"}).sum("qty").finish();){
            for (Row row : dataSet) {
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("warehouse", row.get("warehouse"));
                map.put("qty", row.get("qty"));
                map.put("unit", row.get("unit"));
                map.put("ownertype", row.get("ownertype"));
                map.put("owner", row.get("owner"));
                map.put("invstatus", row.get("invstatus"));
                list.add(map);
            }
        }
        return list;
    }
}

