/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.acc.close;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.EnumBillStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.business.helper.acct.CloseAcctHelper;
import kd.scmc.im.consts.CloseAccountConst;
import kd.scmc.im.errorcode.InvHomePageErrorCode;
import kd.scmc.im.formplugin.acc.close.CloseAcctHandler;
import kd.scmc.im.formplugin.acc.close.ICloseAcctHandler;
import kd.scmc.im.formplugin.acc.close.UnCloseAcctHandler;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.DateUtils;
import kd.scmc.im.utils.FormUtils;

public class CloseAccountPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener,
HyperLinkClickListener {
    private HashMap<String, Boolean> checkMap = new HashMap(4);
    private List<Object> pks = new ArrayList<Object>(128);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadCloseAcctData();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        switch (propName) {
            case "orgf": {
                this.getModel().setValue("warehousef", null);
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"querybtn"});
        this.addClickListeners(new String[]{"fillbatch"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"orgf", "warehousef"});
        ((EntryGrid)this.getControl("billentry")).addHyperClickListener((HyperLinkClickListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "querybtn": {
                this.loadCloseAcctData();
                break;
            }
            case "fillbatch": {
                this.batchFill();
                break;
            }
        }
    }

    private void batchFill() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length != 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u586b\u5145\u3002", (String)"CloseAccountPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        Object selValue = model.getValue("closedate", rows[0]);
        int rowCount = model.getEntryRowCount("billentry");
        for (int i = rows[0] + 1; i < rowCount; ++i) {
            model.setValue("closedate", selValue, i);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        int[] selectRows = ((EntryGrid)this.getControl("billentry")).getSelectRows();
        String itemKey = evt.getItemKey();
        DynamicObjectCollection dataEntity = this.getModel().getDataEntity().getDynamicObjectCollection("billentry");
        switch (itemKey) {
            case "refreshbtn": {
                this.loadCloseAcctData();
                break;
            }
            case "closeaccountbtn": {
                this.checkMap.put("checkboxsave", (Boolean)this.getModel().getValue("checkboxsave"));
                this.checkMap.put("checkboxsubmit", (Boolean)this.getModel().getValue("checkboxsubmit"));
                this.checkMap.put("checkomctoap", (Boolean)this.getModel().getValue("checkomctoap"));
                this.checkMap.put("checksettlestatus", (Boolean)this.getModel().getValue("checksettlestatus"));
                this.execCloseAcctOp(dataEntity, selectRows, itemKey, new CloseAcctHandler(this), this.checkMap);
                break;
            }
            case "uncloseaccountbtn": {
                this.execCloseAcctOp(dataEntity, selectRows, itemKey, new UnCloseAcctHandler(this), null);
                break;
            }
            case "fillbatchbtn": {
                this.batchFill();
                break;
            }
            case "configbtn": {
                this.clickCloseAcctConfig();
                break;
            }
            case "asynccloseaccountbtn": 
            case "asyncuncloseaccountbtn": {
                this.execAsyncCloseAcctOp(dataEntity, selectRows, itemKey);
                break;
            }
        }
    }

    protected void execAsyncCloseAcctOp(DynamicObjectCollection dataEntity, int[] selectRows, String itemKey) {
        if (dataEntity.isEmpty() && !this.getModel().getEntryEntity("billentry").isEmpty()) {
            return;
        }
        if (selectRows.length == 0) {
            this.getView().showMessage(new InvHomePageErrorCode().getDATA_SELECT().getMessage());
            return;
        }
        ArrayList<Integer> successRows = new ArrayList<Integer>(16);
        ArrayList<Integer> dateEqualLastDateRows = new ArrayList<Integer>(16);
        ArrayList checkDateFailRows = new ArrayList(16);
        if ("asynccloseaccountbtn".equals(itemKey)) {
            Map closeDateCheckInfo = CloseAcctHelper.checkCloseDate((DynamicObjectCollection)dataEntity, (int[])selectRows, successRows, dateEqualLastDateRows, checkDateFailRows);
            this.showCloseDateCheckInfo(EnumBillStatus.B.toString(), closeDateCheckInfo);
            if (!checkDateFailRows.isEmpty()) {
                return;
            }
            String execInfo = CloseAcctHelper.checkCloseDateMonth((DynamicObjectCollection)dataEntity, (int[])selectRows);
            if (StringUtils.isNotBlank((CharSequence)execInfo)) {
                HashMap<String, Object> confirmInfo = new HashMap<String, Object>(4);
                confirmInfo.put("selectRows", selectRows);
                confirmInfo.put("itemKey", itemKey);
                confirmInfo.put("successRows", successRows);
                confirmInfo.put("dateEqualLastDateRows", dateEqualLastDateRows);
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("asyncCloseAccount", (IFormPlugin)this);
                this.getView().showConfirm(execInfo, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
            } else {
                this.execAsyncCloseOrUnClose(dataEntity, selectRows, successRows, dateEqualLastDateRows, itemKey);
            }
        } else {
            this.execAsyncCloseOrUnClose(dataEntity, selectRows, successRows, dateEqualLastDateRows, itemKey);
        }
    }

    private void execAsyncCloseOrUnClose(DynamicObjectCollection dataEntity, int[] selectRows, List<Integer> successRows, List<Integer> dateEqualLastDateRows, String itemKey) {
        HashMap<Integer, Object> rowIdxToDate = new HashMap<Integer, Object>(selectRows.length * 2);
        for (int rowIndex : selectRows) {
            this.getModel().setValue("failreason", null, rowIndex);
            this.getModel().setValue("result", null, rowIndex);
            Object closeDate = this.getModel().getValue("closedate");
            rowIdxToDate.put(rowIndex, closeDate);
        }
        FormShowParameter showParameter = new FormShowParameter();
        if ("asynccloseaccountbtn".equals(itemKey)) {
            this.checkMap.put("checkboxsave", (Boolean)this.getModel().getValue("checkboxsave"));
            this.checkMap.put("checkboxsubmit", (Boolean)this.getModel().getValue("checkboxsubmit"));
            this.checkMap.put("checkomctoap", (Boolean)this.getModel().getValue("checkomctoap"));
            this.checkMap.put("checksettlestatus", (Boolean)this.getModel().getValue("checksettlestatus"));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closingaccount"));
        } else {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "unclosingaccount"));
        }
        showParameter.setFormId("im_account_closing");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("entryKey", "billentry");
        params.put("selectRows", selectRows);
        params.put("itemKey", itemKey);
        params.put("checkMap", this.checkMap);
        params.put("totalRows", selectRows.length);
        params.put("rowIdxToDate", rowIdxToDate);
        params.put("successRows", successRows);
        params.put("dateEqualLastDateRows", dateEqualLastDateRows);
        String requestId = RequestContext.get().getRequestId();
        params.put("requestId", requestId);
        for (DynamicObject dynamicObject : dataEntity) {
            this.pks.add(dynamicObject.getPkValue());
        }
        params.put("pks", this.pks);
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        switch (e.getProperty().getName()) {
            case "orgf": {
                this.setF7IdFilter(e, this.geAllPermOrgsFilter("id"));
                break;
            }
            case "warehousef": {
                this.beforeWarehouse(e);
                break;
            }
        }
    }

    private void clickCloseAcctConfig() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        Object checkSave = model.getValue("checkboxsave");
        Object checkSubmit = model.getValue("checkboxsubmit");
        Object checkAp = model.getValue("checkomctoap");
        Object checkSettle = model.getValue("checksettlestatus");
        paramMap.put("checkboxsave", checkSave);
        paramMap.put("checkboxsubmit", checkSubmit);
        paramMap.put("checkomctoap", checkAp);
        paramMap.put("checksettlestatus", checkSettle);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("im_closeaccount_config");
        showParameter.getCustomParams().put("configparam", paramMap);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeaccountconfigcb"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (actionId == null || returnData == null) {
            return;
        }
        if ("closeaccountconfigcb".equals(actionId)) {
            this.closeCallAccountConfig(returnData);
        }
        if ("closingaccount".equals(actionId) || "unclosingaccount".equals(actionId)) {
            Map paramMap = (Map)returnData;
            HashMap data = (HashMap)paramMap.get("returndata");
            if (data == null) {
                return;
            }
            IDataModel model = this.getView().getModel();
            for (Map.Entry entry : data.entrySet()) {
                if (entry == null) continue;
                Map.Entry entry1 = entry;
                Object index = entry1.getKey();
                LinkedHashMap value = (LinkedHashMap)entry1.getValue();
                Iterator iterator = value.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry subEntry;
                    Map.Entry subEntry1 = subEntry = iterator.next();
                    Object key = subEntry1.getKey();
                    Object value1 = subEntry1.getValue();
                    model.setValue((String)key, value1, Integer.parseInt(index.toString()));
                }
            }
        }
    }

    private void closeCallAccountConfig(Object returnData) {
        Map paramMap = (Map)returnData;
        this.getModel().setValue("checkboxsave", paramMap.get("checkboxsave"));
        this.getModel().setValue("checkboxsubmit", paramMap.get("checkboxsubmit"));
        this.getModel().setValue("checkomctoap", paramMap.get("checkomctoap"));
        this.getModel().setValue("checksettlestatus", paramMap.get("checksettlestatus"));
    }

    private void beforeWarehouse(BeforeF7SelectEvent e) {
        List<Long> orgIds = this.getCheckedIds("orgf");
        if (orgIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"InvOperatorMatPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        String entityName = this.getModel().getDataEntityType().getName();
        QFilter qFilter = WareHouseIsolateHelper.getCAWHIsolateQFilter((String)this.getView().getFormShowParameter().getAppId(), orgIds, (String)entityName, (String)"warehouse");
        Map orgWarehouseMap = CloseAcctHelper.getInitWarehouses((QFilter)qFilter);
        ArrayList<Long> warehouseIds = new ArrayList<Long>(orgWarehouseMap.size());
        Set entries = orgWarehouseMap.entrySet();
        for (Map.Entry entry : entries) {
            warehouseIds.add(Long.parseLong(((DynamicObject)entry.getValue()).getDynamicObject("warehouse").get("masterid").toString()));
        }
        QFilter qFilter1 = new QFilter("masterid", "in", warehouseIds);
        this.setF7IdFilter(e, qFilter1);
    }

    private List<Long> getCheckedIds(String dy) {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(dy);
        ArrayList<Long> orgIds = new ArrayList<Long>(orgs.size());
        for (DynamicObject org : orgs) {
            orgIds.add(Long.parseLong(org.getDynamicObject("fbasedataid").getString("masterid")));
        }
        return orgIds;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("failreason".equals(fieldName)) {
            this.linkReason(evt);
        }
    }

    private void linkReason(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org", rowIndex);
        DynamicObject wareHouse = (DynamicObject)this.getModel().getValue("warehouse", rowIndex);
        String failReason = (String)this.getModel().getValue("failreason", rowIndex);
        String unAuditBillInfo = (String)this.getModel().getValue("unauditbill_tag", rowIndex);
        String unOmcBillInfo = (String)this.getModel().getValue("unomcbill_tag", rowIndex);
        String unSettleBillInfo = (String)this.getModel().getValue("unsettlebill_tag", rowIndex);
        if (org == null || wareHouse == null || StringUtils.isBlank((CharSequence)failReason)) {
            return;
        }
        String orgName = org.getLocaleString("name").getLocaleValue();
        String warehouseName = wareHouse.getLocaleString("name").getLocaleValue();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> reasonMap = new HashMap<String, String>(6);
        reasonMap.put("orgName", orgName);
        reasonMap.put("warehouseName", warehouseName);
        reasonMap.put("failreason", failReason);
        reasonMap.put("unAuditBillInfo", unAuditBillInfo);
        reasonMap.put("unOmcBillInfo", unOmcBillInfo);
        reasonMap.put("unSettleBillInfo", unSettleBillInfo);
        proxy.setClientLocalStorage("reasonMap", SerializationUtils.toJsonString(reasonMap));
        this.showSlideBill(proxy);
    }

    protected void setF7IdFilter(BeforeF7SelectEvent e, QFilter filter) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (!CommonUtils.isNull((Object)filter)) {
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }

    protected void execCloseAcctOp(DynamicObjectCollection dataEntity, int[] selectRows, String itemKey, ICloseAcctHandler handler, Map<String, Boolean> checkMap) {
        if (dataEntity.isEmpty() && !this.getModel().getEntryEntity("billentry").isEmpty()) {
            return;
        }
        if (selectRows.length == 0) {
            this.getView().showMessage(new InvHomePageErrorCode().getDATA_SELECT().getMessage());
            return;
        }
        ArrayList<Integer> successRows = new ArrayList<Integer>(16);
        ArrayList<Integer> dateEqualLastDateRows = new ArrayList<Integer>(16);
        ArrayList checkDateFailRows = new ArrayList(16);
        if ("closeaccountbtn".equals(itemKey)) {
            Map closeDateCheckInfo = CloseAcctHelper.checkCloseDate((DynamicObjectCollection)dataEntity, (int[])selectRows, successRows, dateEqualLastDateRows, checkDateFailRows);
            this.showCloseDateCheckInfo(EnumBillStatus.B.toString(), closeDateCheckInfo);
            if (!checkDateFailRows.isEmpty()) {
                return;
            }
            String execInfo = CloseAcctHelper.checkCloseDateMonth((DynamicObjectCollection)dataEntity, (int[])selectRows);
            if (StringUtils.isNotBlank((CharSequence)execInfo)) {
                HashMap<String, Object> confirmInfo = new HashMap<String, Object>(4);
                confirmInfo.put("selectRows", selectRows);
                confirmInfo.put("itemKey", itemKey);
                confirmInfo.put("checkMap", checkMap);
                confirmInfo.put("successRows", successRows);
                confirmInfo.put("dateEqualLastDateRows", dateEqualLastDateRows);
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("syncCloseAccount", (IFormPlugin)this);
                this.getView().showConfirm(execInfo, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
            } else {
                this.execCloseOrUnCloseAcct(dataEntity, selectRows, successRows, dateEqualLastDateRows, itemKey, handler, checkMap);
            }
        } else if ("uncloseaccountbtn".equals(itemKey)) {
            this.execCloseOrUnCloseAcct(dataEntity, selectRows, successRows, dateEqualLastDateRows, itemKey, handler, checkMap);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        String customVaule = event.getCustomVaule();
        if (callBackId == null || customVaule == null) {
            return;
        }
        DynamicObjectCollection dataEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customVaule, Map.class);
        List rows = (List)confirmInfo.get("selectRows");
        List successRows = (List)confirmInfo.get("successRows");
        List dateEqualLastDateRows = (List)confirmInfo.get("dateEqualLastDateRows");
        int[] selectRows = Arrays.stream(rows.toArray(new Integer[0])).mapToInt(Integer::valueOf).toArray();
        String itemKey = (String)confirmInfo.get("itemKey");
        if ("syncCloseAccount".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            Map checkMap = (Map)confirmInfo.get("checkMap");
            CloseAcctHandler closeAcctHandler = new CloseAcctHandler(this);
            this.execCloseOrUnCloseAcct(dataEntity, selectRows, successRows, dateEqualLastDateRows, itemKey, closeAcctHandler, checkMap);
        } else if ("asyncCloseAccount".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.execAsyncCloseOrUnClose(dataEntity, selectRows, successRows, dateEqualLastDateRows, itemKey);
        }
    }

    protected Map<Boolean, List<DLock>> getLocks(DynamicObjectCollection dataEntity, int[] selectRows) {
        HashMap<Boolean, List<DLock>> result = new HashMap<Boolean, List<DLock>>();
        ArrayList locks = new ArrayList();
        Map allowOp = CloseAcctHelper.isAllowOp((DynamicObjectCollection)dataEntity, (int[])selectRows, locks);
        Boolean allow = allowOp.keySet().toArray(new Boolean[0])[0];
        if (!allow.booleanValue()) {
            this.getView().showMessage((String)allowOp.get(Boolean.FALSE));
        }
        result.put(allow, locks);
        return result;
    }

    protected void execCloseOrUnCloseAcct(DynamicObjectCollection dataEntity, int[] selectRows, List<Integer> successRows, List<Integer> dateEqualLastDateRows, String itemKey, ICloseAcctHandler closeAcctHandler, Map<String, Boolean> checkMap) {
        try (TXHandle h = TX.requiresNew((String)String.format("scm/im/%s", itemKey));){
            Map<Boolean, List<DLock>> locksMap = this.getLocks(dataEntity, selectRows);
            Boolean allLocks = locksMap.keySet().toArray(new Boolean[0])[0];
            List<DLock> locks = locksMap.get(allLocks);
            if (!allLocks.booleanValue()) {
                this.unLocks(locks);
                return;
            }
            try {
                closeAcctHandler.handle(dataEntity, selectRows, successRows, dateEqualLastDateRows, checkMap);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
            finally {
                this.unLocks(locks);
            }
        }
    }

    protected void updateDataAfterUnClose(List<Integer> successRows, Map<String, DynamicObject> lastCloseDateMap) {
        for (Integer item : successRows) {
            DynamicObject orgDyc = (DynamicObject)this.getModel().getValue("org", item.intValue());
            DynamicObject warehouseDyc = (DynamicObject)this.getModel().getValue("warehouse", item.intValue());
            String closeDateKey = orgDyc.getPkValue() + "," + warehouseDyc.getPkValue();
            DynamicObject record = lastCloseDateMap.get(closeDateKey);
            this.getModel().setValue("failreason", null, item.intValue());
            this.getModel().setValue("unauditbill_tag", null, item.intValue());
            this.getModel().setValue("unomcbill_tag", null, item.intValue());
            this.getModel().setValue("unsettlebill_tag", null, item.intValue());
            this.getModel().setValue("lastclosedate", (Object)(CommonUtils.isNull((Object)record) ? null : record.getDate("closedate")), item.intValue());
            this.getModel().setValue("closedate", (Object)DateUtils.getDayStartTime((Date)new Date()), item.intValue());
            this.getModel().setValue("result", (Object)EnumBillStatus.C, item.intValue());
        }
    }

    protected void updateDataAfterClose(List<Integer> successRows) {
        for (Integer rowIndex : successRows) {
            this.getModel().setValue("failreason", null, rowIndex.intValue());
            this.getModel().setValue("unauditbill_tag", null, rowIndex.intValue());
            this.getModel().setValue("unomcbill_tag", null, rowIndex.intValue());
            this.getModel().setValue("unsettlebill_tag", null, rowIndex.intValue());
            this.getModel().setValue("result", (Object)EnumBillStatus.A, rowIndex.intValue());
            this.getModel().setValue("lastclosedate", this.getModel().getValue("closedate", rowIndex.intValue()), rowIndex.intValue());
        }
    }

    protected void unLocks(List<DLock> locks) {
        for (DLock item : locks) {
            item.unlock();
        }
    }

    protected void loadCloseAcctData() {
        QFilter headFilter = this.getHeadFilter();
        Map orgWarehouseMap = CloseAcctHelper.getInitWarehouses((QFilter)headFilter);
        DynamicObject[] orgWarehouses = orgWarehouseMap.values().toArray(new DynamicObject[0]);
        this.getModel().deleteEntryData("billentry");
        if (CommonUtils.isNull((Object)orgWarehouses)) {
            return;
        }
        int size = orgWarehouses.length;
        int MaxNum = 128;
        HashMap closeDateMap = new HashMap(16);
        HashSet<DynamicObject> orgWareHouseSet = new HashSet<DynamicObject>(16);
        if (size >= MaxNum) {
            for (DynamicObject orgWarehouse : orgWarehouses) {
                orgWareHouseSet.add(orgWarehouse);
                if (orgWareHouseSet.size() != MaxNum) continue;
                closeDateMap.putAll(CloseAcctHelper.getCloseDateMap((DynamicObject[])orgWareHouseSet.toArray(new DynamicObject[0])));
                orgWareHouseSet.clear();
            }
            if (!orgWareHouseSet.isEmpty()) {
                closeDateMap.putAll(CloseAcctHelper.getCloseDateMap((DynamicObject[])orgWareHouseSet.toArray(new DynamicObject[0])));
            }
        } else {
            closeDateMap.putAll(CloseAcctHelper.getCloseDateMap((DynamicObject[])orgWarehouses));
        }
        this.getModel().beginInit();
        this.getModel().batchCreateNewEntryRow("billentry", orgWarehouses.length);
        this.pks = new ArrayList<Object>(128);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
        for (int i = 0; i < orgWarehouses.length; ++i) {
            this.pks.add(orgWarehouses[i].getPkValue());
            DynamicObject orgDyc = orgWarehouses[i].getDynamicObject("org");
            DynamicObject warehouseDyc = orgWarehouses[i].getDynamicObject("warehouse");
            ((DynamicObject)entryEntity.get(i)).set("id", orgWarehouses[i].getPkValue());
            this.getModel().setValue("org", orgDyc == null ? orgDyc : orgDyc.getPkValue(), i);
            this.getModel().setValue("warehouse", warehouseDyc == null ? warehouseDyc : warehouseDyc.getPkValue(), i);
            if (orgDyc != null && warehouseDyc != null) {
                String closeDateKey = orgDyc.getPkValue() + "," + warehouseDyc.getPkValue();
                DynamicObject record = (DynamicObject)closeDateMap.get(closeDateKey);
                this.getModel().setValue("lastclosedate", (Object)(CommonUtils.isNull((Object)record) ? null : record.getDate("closedate")), i);
            }
            this.getModel().setValue("closedate", (Object)DateUtils.getDayStartTime((Date)new Date()), i);
        }
        this.getModel().endInit();
        IFormView view = this.getView();
        view.updateView("billentry");
        Container queryFilterAp = (Container)view.getControl("queryfilterap");
        queryFilterAp.setCollapse(true);
    }

    private DynamicObjectCollection getFailBillsByOrgAndWareHouse(Object orgId, Object warehouseId, DynamicObjectCollection dyc) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        for (DynamicObject item : dyc) {
            if (!item.get("org").equals(orgId) || !item.get("warehouse").equals(warehouseId)) continue;
            dynamicObjectCollection.add((Object)item);
        }
        return dynamicObjectCollection;
    }

    protected List<Object> getWarehouseIds(List<DynamicObject> dyc) {
        ArrayList<Object> warehouseIds = new ArrayList<Object>();
        for (DynamicObject item : dyc) {
            DynamicObject warehouseDyc = item.getDynamicObject("warehouse");
            if (CommonUtils.isNull((Object)warehouseDyc)) continue;
            warehouseIds.add(warehouseDyc.getPkValue());
        }
        return warehouseIds;
    }

    protected void showCloseDateCheckInfo(String result, Map<Integer, String> execInfoMap) {
        if (execInfoMap.keySet().isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, String> item : execInfoMap.entrySet()) {
            Integer rowIndex = item.getKey();
            this.getModel().setValue("unauditbill_tag", null, rowIndex.intValue());
            this.getModel().setValue("unomcbill_tag", null, rowIndex.intValue());
            this.getModel().setValue("unsettlebill_tag", null, rowIndex.intValue());
            this.getModel().setValue("failreason", (Object)item.getValue(), rowIndex.intValue());
            this.getModel().setValue("result", (Object)result, item.getKey().intValue());
        }
    }

    protected void showFailReason(Map<String, Map<String, String>> unAuditCheckMsg, Map<String, Map<String, String>> omcToAPCheckMsg, Map<String, Map<String, String>> unSettleCheckMsg, List<Integer> failRows) {
        for (Integer failRow : failRows) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org", failRow.intValue());
            DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse", failRow.intValue());
            if (org == null || warehouse == null) continue;
            Long orgId = org.getLong("id");
            Long warehouseId = warehouse.getLong("id");
            String orgWarehouseKey = CloseAcctHelper.getOrgWarehouseKey((String)orgId.toString(), (String)warehouseId.toString());
            Map unAuditInfos = unAuditCheckMsg.getOrDefault(orgWarehouseKey, new HashMap());
            Map omcApInfos = omcToAPCheckMsg.getOrDefault(orgWarehouseKey, new HashMap());
            Map settleInfos = unSettleCheckMsg.getOrDefault(orgWarehouseKey, new HashMap());
            this.getModel().setValue("result", (Object)EnumBillStatus.B.toString(), failRow.intValue());
            if (CollectionUtils.isEmpty((Map)unAuditInfos) && CollectionUtils.isEmpty((Map)omcApInfos) && CollectionUtils.isEmpty((Map)settleInfos)) continue;
            StringBuilder failReason = new StringBuilder();
            if (!CollectionUtils.isEmpty((Map)unAuditInfos)) {
                failReason.append(CloseAccountConst.getSubmitOrSaveBill());
            }
            if (!CollectionUtils.isEmpty((Map)omcApInfos)) {
                failReason.append(CloseAccountConst.getOmcBill());
            }
            if (!CollectionUtils.isEmpty((Map)settleInfos)) {
                failReason.append(CloseAccountConst.getSettleBill());
            }
            this.getModel().setValue("failreason", (Object)failReason, failRow.intValue());
            this.getModel().setValue("unauditbill_tag", (Object)SerializationUtils.toJsonString((Object)unAuditInfos), failRow.intValue());
            this.getModel().setValue("unomcbill_tag", (Object)SerializationUtils.toJsonString((Object)omcApInfos), failRow.intValue());
            this.getModel().setValue("unsettlebill_tag", (Object)SerializationUtils.toJsonString((Object)settleInfos), failRow.intValue());
        }
    }

    private Map<String, String> getFailBillsMapByOrgAndWarehouse(Map<String, DynamicObjectCollection> failInfosMap, String checkMsg, Long orgId, Long warehouseId) {
        HashMap<String, String> failBillsMap = new HashMap<String, String>(16);
        for (Map.Entry<String, DynamicObjectCollection> map : failInfosMap.entrySet()) {
            DynamicObjectCollection failBills = this.getFailBillsByOrgAndWareHouse(orgId, warehouseId, map.getValue());
            if (failBills.isEmpty()) continue;
            String entityName = "";
            String tipMsg = "";
            switch (checkMsg) {
                case "checkboxsubmit": {
                    entityName = map.getKey();
                    tipMsg = this.getBillStatus(failBills);
                    break;
                }
                case "checkomctoap": {
                    entityName = map.getKey();
                    tipMsg = CloseAccountConst.getNotConvertAp();
                    break;
                }
                case "checksettlestatus": {
                    String formMsg = map.getKey();
                    String[] splits = formMsg.split(",");
                    entityName = splits[0];
                    String resultMsg = splits[1];
                    tipMsg = this.getSettleMsg(resultMsg);
                    break;
                }
            }
            tipMsg = tipMsg + "#" + entityName;
            String localEntityName = EntityMetadataCache.getDataEntityType((String)entityName).getDisplayName().getLocaleValue();
            HashSet<String> numbers = new HashSet<String>(16);
            for (DynamicObject failBill : failBills) {
                String billNo = failBill.getString("billno");
                numbers.add(billNo);
            }
            String billNo = StringUtils.join((Object[])numbers.toArray(), (String)",");
            failBillsMap.put(String.format(tipMsg, localEntityName), billNo);
        }
        return failBillsMap;
    }

    private String getBillStatus(DynamicObjectCollection dynamicCollection) {
        String billHint = CloseAccountConst.getUNAUDITFORMAT();
        HashSet billStatus = new HashSet();
        dynamicCollection.stream().forEach(oneBill -> billStatus.add((String)oneBill.get("billstatus")));
        if (CollectionUtils.isEmpty(billStatus)) {
            return billHint;
        }
        if (billStatus.contains(EnumBillStatus.A.toString()) && billStatus.contains(EnumBillStatus.B.toString())) {
            billHint = CloseAccountConst.getTEMPORARYANDSUBMITFORMAT();
        } else if (billStatus.contains(EnumBillStatus.A.toString())) {
            billHint = CloseAccountConst.getTEMPORARYSTORAGEFORMAT();
        } else if (billStatus.contains(EnumBillStatus.B.toString())) {
            billHint = CloseAccountConst.getSUBMITFORMAT();
        }
        return billHint;
    }

    private String getSettleMsg(String resultMSg) {
        String settleMsg = null;
        if ("nosettle".equals(resultMSg)) {
            settleMsg = CloseAccountConst.getNotSETTLE();
        } else if ("settlefail".equals(resultMSg)) {
            settleMsg = CloseAccountConst.getSETTLEFAILED();
        }
        return settleMsg;
    }

    protected QFilter getHeadFilter() {
        QFilter orgWarehousef = this.geAllPermOrgsFilter("org");
        List<Long> orgIds = this.getCheckedIds("orgf");
        List<Long> warehouseIds = this.getCheckedIds("warehousef");
        String entityName = this.getModel().getDataEntityType().getName();
        QFilter qFilter = WareHouseIsolateHelper.getCAWHIsolateQFilter((String)this.getView().getFormShowParameter().getAppId(), orgIds, (String)entityName, (String)"warehouse");
        if (!orgIds.isEmpty()) {
            orgWarehousef = new QFilter("org", "in", (Object)orgIds.toArray());
        }
        if (!warehouseIds.isEmpty()) {
            QFilter filter = new QFilter("warehouse", "in", (Object)warehouseIds.toArray());
            orgWarehousef = orgWarehousef == null ? filter : orgWarehousef.and(filter);
        } else if (qFilter != null) {
            return qFilter;
        }
        return orgWarehousef;
    }

    protected QFilter geAllPermOrgsFilter(String field) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String entityName = this.getModel().getDataEntityType().getName();
        String appId = this.getView().getFormShowParameter().getAppId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"05", (String)appId, (String)entityName, (String)"47150e89000000ac");
        Set allInitOrgId = WarehouseHelper.getAllInitOrgId();
        if (allPermOrgs.hasAllOrgPerm()) {
            return new QFilter(field, "in", (Object)allInitOrgId);
        }
        List hasPermOrgs = allPermOrgs.getHasPermOrgs();
        hasPermOrgs.removeIf(next -> !allInitOrgId.contains(next));
        return new QFilter(field, "in", (Object)hasPermOrgs);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("checkboxsubmit", (Object)true);
        this.getModel().setValue("checkboxsave", (Object)true);
        this.getModel().setValue("checkomctoap", (Object)true);
        this.getModel().setValue("checksettlestatus", (Object)true);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("formId", "im_closeaccount_reason");
        param.put("dc", "right");
        HashMap<String, Integer> offset = new HashMap<String, Integer>();
        offset.put("top", 83);
        param.put("offsetInAllDC", offset);
        proxy.addAction("setSlideBillFormId", param);
    }

    private void showSlideBill(IClientViewProxy proxy) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("formId", "im_closeaccount_reason");
        param.put("show", Boolean.TRUE);
        proxy.addAction("showSlideBill", param);
    }
}

