/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.acc.close;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.EnumBillStatus;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.scmc.im.business.helper.DymAccDSMappingBill;
import kd.scmc.im.business.helper.DymAccDataSourceHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;
import kd.scmc.im.business.helper.acct.CloseAcctHelper;
import kd.scmc.im.consts.InvBalanceConst;
import kd.scmc.im.formplugin.acc.close.CloseAccountPlugin;
import kd.scmc.im.formplugin.acc.close.ICloseAcctHandler;
import kd.scmc.im.utils.ArrayUtils;
import kd.scmc.im.utils.DateUtils;

public class CloseAcctHandler
implements ICloseAcctHandler {
    private final CloseAccountPlugin closeAccountPlugin;
    private static final int SPLIT_NUMS = 1024;
    private static final int THREAD_NUMS = 16;
    private static final int MAX_EXEC_NUMS = 3;
    private static final Log logger = LogFactory.getLog(CloseAcctHandler.class);

    public CloseAcctHandler(CloseAccountPlugin closeAccountPlugin) {
        this.closeAccountPlugin = closeAccountPlugin;
    }

    private AppLogInfo getAppLogInfo(String opDescription) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizObjID("im_closeaccount");
        appLogInfo.setBizAppID("=9Q86DR2P+Q");
        appLogInfo.setUserID(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        appLogInfo.setOpTime(new Date());
        appLogInfo.setOpName("close", ResManager.loadKDString((String)"\u5173\u8d26", (String)"imCloseaccount_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        appLogInfo.setOpDescription(opDescription);
        return appLogInfo;
    }

    @Override
    public void handle(DynamicObjectCollection dataEntity, int[] selectRows, List<Integer> successRows, List<Integer> dateEqualLastDateRows, Map<String, Boolean> checkMap) {
        ArrayList updateDycs = new ArrayList(16);
        Map unAuditCheckMsgMap = CloseAcctHelper.checkUnAuditBill((DynamicObjectCollection)dataEntity, successRows, checkMap);
        Map omcToAPBillCheckMsgMap = CloseAcctHelper.checkOmcToAPBill((DynamicObjectCollection)dataEntity, successRows, checkMap);
        Map settleBillCheckMsgMap = CloseAcctHelper.checkUnSettleBill((DynamicObjectCollection)dataEntity, successRows, checkMap);
        List<Integer> failRows = CloseAcctHandler.getFailRows(dataEntity, successRows, unAuditCheckMsgMap, omcToAPBillCheckMsgMap, settleBillCheckMsgMap);
        CloseAcctHelper.updateCloseRecord((DynamicObjectCollection)dataEntity, successRows, updateDycs, dateEqualLastDateRows, failRows);
        List<Integer> rows = Arrays.stream(selectRows).boxed().collect(Collectors.toList());
        rows.removeAll(successRows);
        this.closeAccountPlugin.showFailReason(unAuditCheckMsgMap, omcToAPBillCheckMsgMap, settleBillCheckMsgMap, rows);
        if (!successRows.isEmpty()) {
            this.changeBillBookDate(successRows, dataEntity, checkMap);
            SaveServiceHelper.save((DynamicObject[])updateDycs.toArray(new DynamicObject[0]));
            this.closeAccountPlugin.updateDataAfterClose(successRows);
        }
        ArrayList<AppLogInfo> appLogInfoList = new ArrayList<AppLogInfo>(selectRows.length);
        for (int rowIndex : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)dataEntity.get(rowIndex);
            Object name = dynamicObject.getDynamicObject("org").get("name");
            Object warehouseName = dynamicObject.getDynamicObject("warehouse").get("name");
            Date closeDate = dynamicObject.getDate("closedate");
            String description = successRows.contains(rowIndex) ? String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d+\u4ed3\u5e93\u201c%2$s\u201d\u5173\u8d26\u6210\u529f\uff0c\u5173\u8d26\u65e5\u671f%3$s\u3002", (String)"imCloseaccount_2", (String)"scmc-im-formplugin", (Object[])new Object[0]), name.toString(), warehouseName.toString(), DateUtils.getDateString((Date)closeDate)) : String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d+\u4ed3\u5e93\u201c%2$s\u201d\u5173\u8d26\u5931\u8d25\uff0c\u5173\u8d26\u65e5\u671f%3$s\u3002", (String)"imCloseaccount_3", (String)"scmc-im-formplugin", (Object[])new Object[0]), name.toString(), warehouseName.toString(), DateUtils.getDateString((Date)closeDate));
            appLogInfoList.add(this.getAppLogInfo(description));
        }
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        service.addBatchLog(appLogInfoList);
    }

    static List<Integer> getFailRows(DynamicObjectCollection dataEntity, List<Integer> successRows, Map<String, Map<String, String>> unAuditCheckMsgMap, Map<String, Map<String, String>> omcToAPBillCheckMsgMap, Map<String, Map<String, String>> settleBillCheckMsgMap) {
        ArrayList<Integer> failRows = new ArrayList<Integer>();
        for (Integer rowIndex : successRows) {
            DynamicObject org = ((DynamicObject)dataEntity.get(rowIndex.intValue())).getDynamicObject("org");
            DynamicObject warehouse = ((DynamicObject)dataEntity.get(rowIndex.intValue())).getDynamicObject("warehouse");
            String orgWarehouseKey = CloseAcctHelper.getOrgWarehouseKey((String)org.getPkValue().toString(), (String)warehouse.getPkValue().toString());
            if (!unAuditCheckMsgMap.containsKey(orgWarehouseKey) && !omcToAPBillCheckMsgMap.containsKey(orgWarehouseKey) && !settleBillCheckMsgMap.containsKey(orgWarehouseKey)) continue;
            failRows.add(rowIndex);
        }
        return failRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeBillBookDate(List<Integer> successRows, DynamicObjectCollection dataEntity, Map<String, Boolean> checkMap) {
        HashMap<String, Date> closeDateMap = new HashMap<String, Date>(16);
        HashSet<Long> allSubmitBills = new HashSet<Long>(16);
        HashMap<Long, Set<String>> billWareHouseMap = new HashMap<Long, Set<String>>(16);
        HashMap<Date, HashSet<Long>> billCloseDateMap = new HashMap<Date, HashSet<Long>>(16);
        if (!checkMap.get("checkboxsubmit").booleanValue() || !checkMap.get("checkboxsave").booleanValue()) {
            Date closeDate;
            Set<String> dymMappings = this.getDymMappings();
            for (Integer n : successRows) {
                DynamicObject dynamicObject = (DynamicObject)dataEntity.get(n.intValue());
                DynamicObject warehouse = dynamicObject.getDynamicObject("warehouse");
                closeDate = dynamicObject.getDate("closedate");
                Date lastCloseDate = dynamicObject.getDate("lastclosedate");
                DynamicObject org = dynamicObject.getDynamicObject("org");
                if (org == null || warehouse == null) continue;
                Long orgId = org.getLong("id");
                Long warehouseId = warehouse.getLong("id");
                String orgWareHouseKey = orgId + "#" + warehouseId;
                closeDateMap.put(orgWareHouseKey, closeDate);
                Set<Long> rowSubmitBills = this.getSubmitBills(orgId, warehouseId, lastCloseDate, closeDate, dymMappings, checkMap);
                allSubmitBills.addAll(rowSubmitBills);
            }
            if (allSubmitBills.isEmpty()) {
                return;
            }
            Map<Integer, Set<Long>> splitBills = this.getSplitBillIdMap(allSubmitBills);
            for (Set<Long> set : splitBills.values()) {
                billWareHouseMap.putAll(this.getBillWareHouseMap(set, dymMappings));
            }
            for (Map.Entry entry : billWareHouseMap.entrySet()) {
                Long billId = (Long)entry.getKey();
                Set orgWareHouseKeys = (Set)entry.getValue();
                ArrayList<Date> dateList = new ArrayList<Date>(2);
                if (orgWareHouseKeys.isEmpty()) {
                    return;
                }
                for (String orgWareHouseKey : orgWareHouseKeys) {
                    if (!closeDateMap.containsKey(orgWareHouseKey)) continue;
                    Date date = (Date)closeDateMap.get(orgWareHouseKey);
                    if (dateList.isEmpty()) {
                        dateList.add(date);
                        continue;
                    }
                    if (!((Date)dateList.get(0)).before(date)) continue;
                    dateList.remove(0);
                    dateList.add(date);
                }
                Date closeDate2 = (Date)dateList.get(0);
                HashSet<Long> billIdSet = (HashSet<Long>)billCloseDateMap.get(closeDate2);
                if (billIdSet == null) {
                    billIdSet = new HashSet<Long>(16);
                    billIdSet.add(billId);
                    billCloseDateMap.put(closeDate2, billIdSet);
                    continue;
                }
                billIdSet.add(billId);
            }
            try (ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)CloseAcctHandler.class.getName(), (int)16, (int)32);){
                for (Map.Entry item : billCloseDateMap.entrySet()) {
                    closeDate = (Date)item.getKey();
                    Set billIdSet = (Set)item.getValue();
                    if (billIdSet == null || billIdSet.isEmpty()) continue;
                    Map<Integer, Set<Long>> splitBillIdMap = this.getSplitBillIdMap(billIdSet);
                    if (closeDate == null) continue;
                    this.updateBookDate(threadPool, closeDate, splitBillIdMap, checkMap);
                }
            }
        }
    }

    private void updateBookDate(ThreadPool threadPool, Date closeDate, Map<Integer, Set<Long>> splitBillIdMap, Map<String, Boolean> checkMap) {
        int size = splitBillIdMap.size();
        HashSet<Integer> execIndexes = new HashSet<Integer>(16);
        int execNum = 0;
        String msg = ResManager.loadKDString((String)"\u66f4\u65b0\u8bb0\u8d26\u65e5\u671f\u5931\u8d25\u3002", (String)"CloseAcctHandler_0", (String)"scmc-im-formplugin", (Object[])new Object[0]);
        while (!splitBillIdMap.isEmpty()) {
            if (execNum >= 3) {
                StringBuilder errLog = new StringBuilder();
                for (Set<Long> value : splitBillIdMap.values()) {
                    errLog.append(value);
                }
                errLog.append(msg);
                logger.error(errLog.toString());
                break;
            }
            execIndexes.clear();
            for (int i = 1; i <= size; ++i) {
                if (!splitBillIdMap.containsKey(i)) continue;
                execIndexes.add(i);
                if (execIndexes.size() != 16) continue;
                this.splitUpdateBookDate(threadPool, splitBillIdMap, execIndexes, closeDate, checkMap);
                execIndexes.clear();
            }
            if (!execIndexes.isEmpty()) {
                this.splitUpdateBookDate(threadPool, splitBillIdMap, execIndexes, closeDate, checkMap);
            }
            ++execNum;
        }
    }

    private void splitUpdateBookDate(ThreadPool threadPool, Map<Integer, Set<Long>> splitBillIdMap, Set<Integer> execIndexes, Date closeDate, Map<String, Boolean> checkMap) {
        Future future;
        HashMap<Integer, Future> execFutureMap = new HashMap<Integer, Future>(16);
        for (Integer n : execIndexes) {
            Set<Long> fidSet = splitBillIdMap.get(n);
            future = threadPool.submit(() -> {
                try {
                    this.executeSplitSql(fidSet, closeDate, checkMap);
                    return true;
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    return false;
                }
            });
            execFutureMap.put(n, future);
        }
        for (Map.Entry entry : execFutureMap.entrySet()) {
            int index = (Integer)entry.getKey();
            future = (Future)entry.getValue();
            try {
                if (!((Boolean)future.get()).booleanValue()) continue;
                splitBillIdMap.remove(index);
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error(e.getMessage());
            }
        }
    }

    private Map<Integer, Set<Long>> getSplitBillIdMap(Set<Long> billIdSet) {
        HashMap<Integer, Set<Long>> splitBillIdMap = new HashMap<Integer, Set<Long>>(16);
        int size = billIdSet.size();
        int i = 1;
        if (size >= 1024) {
            for (Long fid : billIdSet) {
                HashSet<Long> idSet = (HashSet<Long>)splitBillIdMap.get(i);
                if (idSet == null) {
                    idSet = new HashSet<Long>(1024);
                    idSet.add(fid);
                    splitBillIdMap.put(i, idSet);
                    continue;
                }
                idSet.add(fid);
                if (idSet.size() != 1024) continue;
                ++i;
            }
        } else {
            splitBillIdMap.put(i, billIdSet);
        }
        return splitBillIdMap;
    }

    private Set<String> getDymMappings() {
        List updateBillFromDymAccDS = DymAccDataSourceHelper.getUpdateBillFromDymAccDS((boolean)false);
        HashSet<String> dymMappings = new HashSet<String>(updateBillFromDymAccDS.size());
        for (DymAccDSMappingBill dymAccDSMappingBill : updateBillFromDymAccDS) {
            String warehouse;
            Map mapping;
            String org;
            String srcBill = dymAccDSMappingBill.getSrcbill();
            if (!InvBalanceConst.getBalBillList().contains(srcBill) || StringUtils.isEmpty((CharSequence)(org = (String)(mapping = dymAccDSMappingBill.getMapping()).get("org"))) || StringUtils.isEmpty((CharSequence)(warehouse = (String)mapping.get("warehouse")))) continue;
            String billKey = srcBill + "#" + org + "#" + warehouse;
            dymMappings.add(billKey);
        }
        return dymMappings;
    }

    private Set<Long> getSubmitBills(Long orgId, Long wareHouseId, Date lastCloseDate, Date closeDate, Set<String> dymMappings, Map<String, Boolean> checkMap) {
        Map mdcBillTypeMap = InvBalanceConst.getMdcBillTypeMap();
        HashSet<Long> fidSet = new HashSet<Long>(16);
        QFilter filter = CloseAcctHandler.getUnAuditFilter(checkMap);
        if (lastCloseDate != null) {
            filter.and("bookdate", ">", (Object)lastCloseDate);
        }
        if (closeDate != null) {
            Date newCloseDate = DateUtils.addOneDay((Date)closeDate);
            filter.and("bookdate", "<", (Object)newCloseDate);
        }
        HashSet<OrmInput> allBillOrmInputs = new HashSet<OrmInput>(dymMappings.size());
        for (String billOwnerKey : dymMappings) {
            MainEntityType dataType;
            IDataEntityProperty invSchemeType;
            String[] split = billOwnerKey.split("#");
            String srcBill = split[0];
            String org = split[1];
            String wareHouse = split[2];
            QFilter billFilter = new QFilter(org, "=", (Object)orgId);
            billFilter.and(wareHouse, "=", (Object)wareHouseId);
            if (mdcBillTypeMap.get(srcBill) != null) {
                billFilter.and("billtype.number", "=", mdcBillTypeMap.get(srcBill));
            }
            if ((invSchemeType = (dataType = MetadataServiceHelper.getDataEntityType((String)srcBill)).findProperty("invscheme")) != null) {
                billFilter.and("invscheme.isnotupdate", "=", (Object)false);
            }
            OrmInput billOrmInput = new OrmInput(CloseAcctHandler.class.getName() + "getSubmitBills", srcBill, "id, '" + srcBill + "' as billkey", (QFilter[])ArrayUtils.concatAll((Object[])filter.toArray(), (Object[][])new QFilter[][]{billFilter.toArray()}));
            allBillOrmInputs.add(billOrmInput);
        }
        Algo algo = Algo.create((String)CloseAcctHandler.class.getName());
        DataSet unionDataSet = algo.createDataSet((Input[])allBillOrmInputs.toArray(new OrmInput[0]));
        for (Row row : unionDataSet) {
            Long billId = row.getLong("id");
            fidSet.add(billId);
        }
        return fidSet;
    }

    private Map<Long, Set<String>> getBillWareHouseMap(Set<Long> fidSet, Set<String> dymMappings) {
        Map mdcBillTypeMap = InvBalanceConst.getMdcBillTypeMap();
        HashMap<Long, Set<String>> wareHouseMap = new HashMap<Long, Set<String>>(16);
        HashSet<OrmInput> allBillOrmInputs = new HashSet<OrmInput>(dymMappings.size());
        for (String billOwnerKey : dymMappings) {
            String[] split = billOwnerKey.split("#");
            String srcBill = split[0];
            String org = split[1];
            String warehouse = split[2];
            QFilter billFilter = new QFilter("id", "in", fidSet);
            if (mdcBillTypeMap.get(srcBill) != null) {
                billFilter.and("billtype.number", "=", mdcBillTypeMap.get(srcBill));
            }
            String selectFields = "id, '" + srcBill + "' as billkey, " + org + " as  org, " + warehouse + " as warehouse";
            OrmInput billOrmInput = new OrmInput(CloseAcctHandler.class.getName() + "getWareHouseMap", srcBill, selectFields, billFilter.toArray());
            allBillOrmInputs.add(billOrmInput);
        }
        Algo algo = Algo.create((String)CloseAcctHandler.class.getName());
        DataSet unionDataSet = algo.createDataSet((Input[])allBillOrmInputs.toArray(new OrmInput[0]));
        for (Row row : unionDataSet) {
            Long fid = row.getLong("id");
            Long orgId = row.getLong("org");
            Long wareHouSeId = row.getLong("warehouse");
            String orgWareHouseKey = orgId + "#" + wareHouSeId;
            HashSet<String> wareHouseSet = (HashSet<String>)wareHouseMap.get(fid);
            if (wareHouseSet == null) {
                wareHouseSet = new HashSet<String>(16);
                wareHouseSet.add(orgWareHouseKey);
                wareHouseMap.put(fid, wareHouseSet);
                continue;
            }
            wareHouseSet.add(orgWareHouseKey);
        }
        return wareHouseMap;
    }

    private void executeSplitSql(Set<Long> fidSet, Date closeDate, Map<String, Boolean> checkMap) {
        Map IMBillTableMap = InvBalanceConst.getIMBillTableMap();
        StringBuilder sqlBuilder = new StringBuilder();
        DBRoute scmRoute = new DBRoute("scm");
        if (fidSet != null && !fidSet.isEmpty()) {
            sqlBuilder.append("(");
            for (Long fid : fidSet) {
                sqlBuilder.append(fid);
                sqlBuilder.append(",");
            }
            sqlBuilder.deleteCharAt(sqlBuilder.lastIndexOf(","));
            sqlBuilder.append(")");
        }
        boolean enableBookEqualsBiz = SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0004");
        Date newBookDate = DateUtils.addOneDay((Date)closeDate);
        try (TXHandle dtx = TX.required((String)"updateBookDate");){
            try {
                for (Map.Entry item : IMBillTableMap.entrySet()) {
                    String tableName = (String)item.getValue();
                    String billName = (String)item.getKey();
                    ArrayList<Date> params = new ArrayList<Date>(2);
                    String sql = "update " + tableName + " set fbookdate = ? ";
                    if (enableBookEqualsBiz) {
                        switch (billName) {
                            case "im_productinbill": 
                            case "im_mdc_mftmanuinbill": 
                            case "im_mdc_mftreturnbill": {
                                sql = sql + ", fbiztimes = ? ";
                                break;
                            }
                            default: {
                                sql = sql + ", fbiztime = ? ";
                            }
                        }
                        params.add(newBookDate);
                    }
                    sql = sql + "where fid in " + sqlBuilder;
                    if ("im_purinbill".equals(billName) || "im_saloutbill".equals(billName) || "im_ospurinbill".equals(billName)) {
                        sql = sql + " and fisinitbill = '0'";
                    }
                    params.add(newBookDate);
                    this.executeMethod(scmRoute, params, sql);
                }
                if (!checkMap.get("checkboxsubmit").booleanValue()) {
                    DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBookDateUpdateService", (String)"updateRecordBookDate", (Object[])new Object[]{fidSet, closeDate});
                }
            }
            catch (Exception e) {
                dtx.markRollback();
                throw e;
            }
        }
    }

    private void executeMethod(DBRoute scmRoute, List<Date> params, String sql) {
        DB.update((DBRoute)scmRoute, (String)sql, (Object[])params.toArray());
    }

    private static QFilter getUnAuditFilter(Map<String, Boolean> checkMap) {
        QFilter unAuditFilter = new QFilter("1", "=", (Object)1);
        if (!checkMap.get("checkboxsave").booleanValue() && checkMap.get("checkboxsubmit").booleanValue()) {
            unAuditFilter = new QFilter("billstatus", "=", (Object)EnumBillStatus.A);
        } else if (checkMap.get("checkboxsave").booleanValue() && !checkMap.get("checkboxsubmit").booleanValue()) {
            unAuditFilter = new QFilter("billstatus", "=", (Object)EnumBillStatus.B);
        } else if (!checkMap.get("checkboxsave").booleanValue() && !checkMap.get("checkboxsubmit").booleanValue()) {
            ArrayList<String> billstatus = new ArrayList<String>(2);
            billstatus.add(EnumBillStatus.A.toString());
            billstatus.add(EnumBillStatus.B.toString());
            unAuditFilter = new QFilter("billstatus", "in", billstatus);
        }
        return unAuditFilter;
    }
}

