/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.acc.init;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.im.business.helper.InitExecHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class FinishInitListPlugin
extends AbstractListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        List orgItem;
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        List permissionOrgs = NewInvOrgHelper.getPermissionOrgsByAppId((String)"im_warehousesetup", (String)this.getView().getFormShowParameter().getAppId());
        if (permissionOrgs == null || permissionOrgs.isEmpty()) {
            this.getView().showErrorNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_USE_INVORG()));
        }
        if (CommonUtils.isNull((Object)(orgItem = NewInvOrgHelper.getHasPermissionAndStartedInvOrgFilterColumns((List)permissionOrgs)))) {
            filterColumns.clear();
            if (permissionOrgs != null && permissionOrgs.size() > 0) {
                this.getView().showErrorNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ENABLED_INV()));
            }
        }
        for (FilterColumn filterColumn : filterColumns) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            if (!commonFilterColumn.getFieldName().equals("org.number")) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            commonFilterColumn.setComboItems(orgItem);
            commonFilterColumn.setDefaultValue(((ComboItem)orgItem.get(0)).getValue());
            this.getPageCache().put("org.id", ((ComboItem)orgItem.get(0)).getValue());
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("startstatus", "=", (Object)"B"));
        e.setOrderBy("biztime desc,billno desc");
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        List customfilter = (List)args.getSearchClickEvent().getFilterValues().get("customfilter");
        if (customfilter != null) {
            for (Map filteritem : customfilter) {
                String filterName = ((List)filteritem.get("FieldName")).get(0).toString();
                if (!"org.id".equals(filterName)) continue;
                String orgId = ((List)filteritem.get("Value")).get(0).toString();
                if (orgId.equals("")) {
                    this.getPageCache().put("org.id", null);
                    continue;
                }
                this.getPageCache().put("org.id", orgId);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"bar_init", "bar_uninit"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        Map<Object, DynamicObject> selectedInitRows = this.getSelectedInitRows();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "bar_init": {
                if (!this.checkFinishInitPerm("init", selectedInitRows)) break;
                this.showInitForm("init");
                break;
            }
            case "bar_uninit": {
                if (!this.checkFinishInitPerm("uninit", selectedInitRows)) break;
                this.showInitForm("uninit");
                break;
            }
            case "bar_batchinit": {
                if (!this.checkFinishInitPerm("init", selectedInitRows)) break;
                this.processInit("init", selectedInitRows);
                break;
            }
            case "bar_batchuninit": {
                if (!this.checkFinishInitPerm("uninit", selectedInitRows)) break;
                this.processInit("uninit", selectedInitRows);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        this.getView().invokeOperation("refresh");
    }

    private Map<Object, DynamicObject> getSelectedInitRows() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection initInfo = list.getSelectedRows();
        if (initInfo == null) {
            return new HashMap<Object, DynamicObject>();
        }
        HashSet<Object> initPks = new HashSet<Object>(initInfo.size());
        for (ListSelectedRow listSelectedRow : initInfo) {
            Object pkValue = listSelectedRow.getPrimaryKeyValue();
            if (pkValue == null) continue;
            initPks.add(pkValue);
        }
        Map initCollection = BusinessDataServiceHelper.loadFromCache((Object[])initPks.toArray(), (String)"im_warehousesetup");
        return initCollection;
    }

    private void processInit(String execId, Map<Object, DynamicObject> initCollection) {
        if (initCollection.isEmpty()) {
            return;
        }
        HashMap<String, List> orgToWhsMapping = new HashMap<String, List>(initCollection.size());
        for (Map.Entry<Object, DynamicObject> entry : initCollection.entrySet()) {
            DynamicObject initObj = entry.getValue();
            Object org = initObj.get("org");
            Object warehouse = initObj.get("warehouse");
            if (org == null || warehouse == null) continue;
            String orgId = ((DynamicObject)org).getString("id");
            String warehouseId = ((DynamicObject)warehouse).getString("id");
            List warehouseIds = orgToWhsMapping.computeIfAbsent(orgId, k -> new ArrayList());
            warehouseIds.add(warehouseId);
        }
        JSONArray result = InitExecHelper.batchInitExecute(orgToWhsMapping, (String)execId, (String)"2");
        if (result.size() == 0) {
            return;
        }
        JSONObject[] jsonObjects = (JSONObject[])result.toArray((Object[])new JSONObject[0]);
        StringBuilder msg = new StringBuilder();
        for (JSONObject jsonObject : jsonObjects) {
            if (jsonObject.getBoolean("isSuccess").booleanValue()) continue;
            String initError = ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u521d\u59cb\u5e93\u5b58\u5355\u3002", (String)"FinishInitListPlugin_5", (String)"scmc-im-formplugin", (Object[])new Object[0]);
            String errStr = jsonObject.getString("errorMessage");
            if (errStr.contains(initError)) {
                Object warehouseName = jsonObject.get((Object)"warehousename");
                errStr = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4ed3\u5e93\u201c%s\u201d\u5b58\u5728\u672a\u5ba1\u6838\u7684\u521d\u59cb\u5e93\u5b58\u5355\u3002", (String)"FinishInitListPlugin_6", (String)"scmc-im-formplugin", (Object[])new Object[0]), warehouseName);
            }
            msg.append(errStr.substring(errStr.lastIndexOf(",") + 1));
            msg.append("\n");
        }
        if (msg.length() == 0) {
            if ("init".equals(execId)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"InitExecPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"InitExecPlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showErrorNotification(msg.toString());
        }
        this.getView().invokeOperation("refresh");
    }

    private void showInitForm(String execId) {
        FormShowParameter parameter = new FormShowParameter();
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow initInfo = list.getCurrentSelectedRowInfo();
        long orgId = 0L;
        long whid = 0L;
        if (initInfo != null) {
            orgId = initInfo.getMainOrgId();
            long initId = (Long)initInfo.getPrimaryKeyValue();
            DynamicObject initObj = BusinessDataServiceHelper.loadSingle((Object)initId, (String)"im_warehousesetup");
            whid = initObj.getDynamicObject("warehouse").getLong("id");
            if (execId.equals("uninit")) {
                parameter.setCaption(ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\uff08\u7ec4\u7ec7\uff09", (String)"FinishInitListPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            } else {
                parameter.setCaption(ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\uff08\u7ec4\u7ec7\uff09", (String)"FinishInitListPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
        } else {
            if (this.getPageCache().get("org.id") != null) {
                String orgIdStr = (String)SerializationUtils.fromJsonString((String)this.getPageCache().get("org.id"), String.class);
                orgId = Long.parseLong(orgIdStr);
            } else {
                DynamicObject orgObj = NewInvOrgHelper.getDefaultInvOrg((String)"im_warehousesetup", (String)this.getView().getFormShowParameter().getAppId());
                orgId = orgObj.getLong("id");
            }
            if (execId.equals("uninit")) {
                parameter.setCaption(ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\uff08\u7ec4\u7ec7\uff09", (String)"FinishInitListPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            } else {
                parameter.setCaption(ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\uff08\u7ec4\u7ec7\uff09", (String)"FinishInitListPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
        }
        parameter.setFormId("im_init_exe");
        parameter.setCustomParam("orgId", (Object)orgId);
        parameter.setCustomParam("execId", (Object)execId);
        parameter.setCustomParam("whId", (Object)whid);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refreshlist"));
        this.getView().showForm(parameter);
    }

    private boolean checkFinishInitPerm(String execId, Map<Object, DynamicObject> selectedInitRows) {
        if (selectedInitRows.size() == 0) {
            return false;
        }
        HashSet<DynamicObject> orgSet = new HashSet<DynamicObject>(selectedInitRows.size());
        for (Map.Entry<Object, DynamicObject> initEntry : selectedInitRows.entrySet()) {
            DynamicObject initEntity = initEntry.getValue();
            Object org = initEntity.get("org");
            if (org == null) continue;
            orgSet.add((DynamicObject)org);
        }
        int permission = 0;
        String userId = RequestContext.get().getUserId();
        String initPermissinId = "4730fc9f000005ae";
        String unInitPermissinId = "4730fc9f000006ae";
        String appId = this.getView().getFormShowParameter().getAppId();
        OpLogAppInfo appLogInfo = InitExecHelper.getAppLogInfo((String)execId);
        for (DynamicObject org : orgSet) {
            if ("init".equals(execId) || "batchinit".equals(execId)) {
                permission = PermissionServiceHelper.checkPermission((long)Long.parseLong(userId), (String)"DIM_ORG", (long)org.getLong("id"), (String)appId, (String)"im_init_exe", (String)initPermissinId);
                if (permission == 1) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u672a\u6388\u6743\u7ec4\u7ec7\u201c%s\u201d\u4e0b\u7ed3\u675f\u521d\u59cb\u5316\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"FinishInitListPlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0]), org.getLocaleString("name"));
                appLogInfo.setStatus("0");
                appLogInfo.setOpDesc(new MultiLangEnumBridge("\u5f53\u524d\u7528\u6237\u672a\u6388\u6743\u7ec4\u7ec7\u201c%s\u201d\u4e0b\u7ed3\u675f\u521d\u59cb\u5316\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", "FinishInitListPlugin_7", "scmc-im-formplugin"), new String[]{org.getString("name")});
                InitExecHelper.saveApplogInfo((AppLogInfo)appLogInfo);
                this.getView().showErrorNotification(msg);
                return false;
            }
            permission = PermissionServiceHelper.checkPermission((long)Long.parseLong(userId), (String)"DIM_ORG", (long)org.getLong("id"), (String)appId, (String)"im_init_exe", (String)unInitPermissinId);
            if (permission == 1) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u672a\u6388\u6743\u7ec4\u7ec7\u201c%s\u201d\u4e0b\u53cd\u521d\u59cb\u5316\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"FinishInitListPlugin_8", (String)"scmc-im-formplugin", (Object[])new Object[0]), org.getLocaleString("name"));
            appLogInfo.setStatus("0");
            appLogInfo.setOpDesc(new MultiLangEnumBridge("\u5f53\u524d\u7528\u6237\u672a\u6388\u6743\u7ec4\u7ec7\u201c%s\u201d\u4e0b\u53cd\u521d\u59cb\u5316\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", "FinishInitListPlugin_8", "scmc-im-formplugin"), new String[]{org.getString("name")});
            InitExecHelper.saveApplogInfo((AppLogInfo)appLogInfo);
            this.getView().showErrorNotification(msg);
            return false;
        }
        return true;
    }
}

