/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.acc.init;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.InitExecHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FormUtils;

public class InitExecPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
CountDownListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"invorg", "warehouse"});
        CountDown countdown = (CountDown)this.getView().getControl("countdownap");
        countdown.addCountDownListener((CountDownListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.registerListener((EventObject)e);
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (e.getProperty().getName()) {
            case "invorg": {
                Object[] orgList = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)"im_warehousesetup", (String)this.getView().getFormShowParameter().getAppId());
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
                break;
            }
            case "warehouse": {
                Long invOrgID = null;
                DynamicObject org = this.getModel().getDataEntity().getDynamicObject("invorg");
                if (!CommonUtils.isNull((Object)org)) {
                    invOrgID = Long.valueOf(org.getPkValue().toString());
                }
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                showParameter.setIsolationOrg(false);
                if (customParams.get("execId") != null && customParams.get("execId").equals("init")) {
                    Long[] unFinishInitWHId = WarehouseHelper.getAllUnFinishInitWarehouseIDs((Long)invOrgID);
                    QFilter wFilter = new QFilter("id", "in", (Object)unFinishInitWHId);
                    showParameter.getListFilterParameter().setFilter(wFilter);
                    break;
                }
                if (customParams.get("execId") == null || !customParams.get("execId").equals("uninit")) break;
                Long[] finishInitWHId = WarehouseHelper.getAllFinishInitWarehouseIDs((Long)invOrgID);
                QFilter wFilter = new QFilter("id", "in", (Object)finishInitWHId);
                showParameter.getListFilterParameter().setFilter(wFilter);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.get("orgId") != null && !customParams.get("orgId").equals("")) {
            Long orgId = Long.valueOf(customParams.get("orgId").toString());
            DynamicObject orgObj = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
            if (!CommonUtils.isNull((Object)orgObj)) {
                this.getModel().setValue("invorg", orgObj.getPkValue());
            }
            if (customParams.get("whId") != null && !customParams.get("whId").equals("") && !customParams.get("whId").toString().equals("0")) {
                this.getModel().setValue("radiogroup", (Object)2);
                ((FieldEdit)this.getView().getControl("warehouse")).setMustInput(true);
                this.setDefWarehouse();
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "btnok": {
                DynamicObject warehouse;
                long whsId;
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                Object execId = customParams.get("execId");
                if (customParams == null || customParams.get("execId") == null) {
                    return;
                }
                Object executeType = this.getModel().getValue("radiogroup");
                DynamicObject orgdym = (DynamicObject)this.getModel().getValue("invorg");
                long orgId = orgdym == null ? 0L : (Long)orgdym.getPkValue();
                JSONObject result = InitExecHelper.initExecute((long)orgId, (long)(whsId = (warehouse = (DynamicObject)this.getModel().getValue("warehouse")) == null ? 0L : (Long)warehouse.getPkValue()), (String)execId.toString(), (String)((String)executeType));
                if (result == null) {
                    return;
                }
                if (result.getBoolean("isSuccess").booleanValue()) {
                    this.getView().showSuccessNotification(result.getString("successMessage"));
                    break;
                }
                this.getView().showErrorNotification(result.getString("errorMessage"));
            }
        }
    }

    public void onCountDownEnd(CountDownEvent evt) {
        super.onCountDownEnd(evt);
        CountDown countDown = (CountDown)evt.getSource();
        if (countDown.getKey().equals("countdownap")) {
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        switch (propName) {
            case "radiogroup": {
                this.itemchange(newValue);
                break;
            }
            case "warehouse": {
                String msg = this.checkWarehose((DynamicObject)newValue);
                if (CommonUtils.isNull((Object)msg)) break;
                this.getView().showTipNotification(msg);
                break;
            }
            case "invorg": {
                this.getModel().beginInit();
                this.getModel().setValue("warehouse", null);
                this.getModel().endInit();
                this.getView().updateView("warehouse");
                break;
            }
        }
    }

    private void showWarehouseTip(Object warehouseId) {
        DynamicObject warehouse = BusinessDataServiceHelper.loadSingle((Object)warehouseId, (String)"bd_warehouse");
        String msg = this.checkWarehose(warehouse);
        if (!CommonUtils.isNull((Object)msg)) {
            this.getView().showTipNotification(msg);
        }
    }

    private String checkWarehose(DynamicObject dymWhs) {
        boolean isFinish;
        String orgName;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object execId = customParams.get("execId");
        DynamicObject orgdym = (DynamicObject)this.getModel().getValue("invorg");
        Long orgID = orgdym != null ? Long.valueOf(orgdym.getPkValue().toString()) : Long.valueOf(0L);
        String string = orgName = orgdym == null ? "" : orgdym.get("name");
        if (CommonUtils.isNull((Object)dymWhs) || CommonUtils.isNull(execId)) {
            return null;
        }
        if (execId.equals("init")) {
            if (CommonUtils.isNull((Object)this.isExistInWHSetUp(dymWhs))) {
                return CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_WAREHOUSESET_NOTEXIT(), (Object[])new Object[]{orgName, dymWhs.getString("name")});
            }
            boolean isFinish2 = WarehouseHelper.isFinishInit((Long)orgID, (Long)Long.valueOf(dymWhs.getPkValue().toString()));
            if (isFinish2) {
                return CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_WAREHOUSE_INIT(), (Object[])new Object[]{orgName, dymWhs.getString("name")});
            }
        } else if (execId.equals("uninit") && !(isFinish = WarehouseHelper.isFinishInit((Long)orgID, (Long)Long.valueOf(dymWhs.getPkValue().toString())))) {
            return CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_WAREHOUSE_UNINIT(), (Object[])new Object[]{orgName, dymWhs.getString("name")});
        }
        return null;
    }

    private DynamicObject isExistInWHSetUp(DynamicObject dymWhs) {
        DynamicObject invOrgDym = this.getModel().getDataEntity().getDynamicObject("invorg");
        Long invOrgID = invOrgDym != null ? Long.valueOf(invOrgDym.getPkValue().toString()) : null;
        QFilter filters = new QFilter("org", "=", (Object)invOrgID);
        filters.and(new QFilter("warehouse", "=", dymWhs.getPkValue()));
        DynamicObject whsSetup = BusinessDataServiceHelper.loadSingle((String)"im_warehousesetup", (String)"id", (QFilter[])new QFilter[]{filters});
        return whsSetup;
    }

    private void itemchange(Object newValue) {
        if (newValue.equals("2")) {
            ((FieldEdit)this.getView().getControl("warehouse")).setMustInput(true);
            this.setDefWarehouse();
        } else {
            ((FieldEdit)this.getView().getControl("warehouse")).setMustInput(false);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (CommonUtils.isNull(customParams.get("orgId"))) {
                return;
            }
            this.getModel().beginInit();
            this.getModel().setValue("invorg", customParams.get("orgId"));
            this.getModel().endInit();
            this.getView().updateView("invorg");
            this.getView().updateView("warehouse");
        }
    }

    protected void setDefWarehouse() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (CommonUtils.isNull(customParams.get("orgId"))) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().setValue("invorg", customParams.get("orgId"));
        this.getModel().setValue("warehouse", customParams.get("whId"));
        this.getModel().endInit();
        this.getView().updateView("invorg");
        this.getView().updateView("warehouse");
        this.showWarehouseTip(customParams.get("whId"));
    }
}

