/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.adjustbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.AdjustBizTypeHelper;
import kd.scmc.im.business.helper.BillViewHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.MaterialHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.consts.AdjustBillConst;
import kd.scmc.im.enums.PrecisionAccountEnum;
import kd.scmc.im.formplugin.ImTransformBillEditPlugin;
import kd.scmc.im.utils.FormUtils;
import org.apache.commons.lang3.StringUtils;

public class AdjustBillEditPlugin
extends ImTransformBillEditPlugin {
    private static String[] beforeFields = new String[]{"warehouse", "location", "invstatus", "invtype", "owner", "ownertype", "keeper", "keepertype"};

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
        this.addItemClickListeners(new String[]{"lot1"});
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opKey = FormUtils.getOpKey((BeforeDoOperationEventArgs)args);
        if ("newaferentry".equals(opKey)) {
            int entryRowCount;
            Object bizTypeId;
            int parentindex;
            IDataModel model = this.getModel();
            Object material = model.getValue("material", parentindex = model.getEntryCurrentRowIndex("billentry"));
            if (material == null) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8f6c\u6362\u524d\u7269\u6599\u3002", (String)"AdjustBillEditPlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
            this.getModel().setEntryCurrentRowIndex("billentry", entryCurrentRowIndex);
            DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
            Object object = bizTypeId = bizType == null ? null : bizType.getPkValue();
            if ((AdjustBillConst.BIZTYPE_STATUSADJUST.equals(bizTypeId) || AdjustBillConst.BIZTYPE_SNADJUST.equals(bizTypeId) || AdjustBillConst.BIZTYPE_UNITADJUST.equals(bizTypeId) || AdjustBillConst.BIZTYPE_OTHERADJUST.equals(bizTypeId) || AdjustBillConst.BIZTYPE_INSPECTADJUST.equals(bizTypeId)) && (entryRowCount = this.getModel().getEntryRowCount("afterentity")) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u7c7b\u578b\uff0c\u8f6c\u6362\u540e\u5206\u5f55\u4e0d\u5141\u8bb8\u6709\u591a\u6761\u3002", (String)"AdjustBillEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        IDataModel model = this.getView().getModel();
        switch (itemKey) {
            case "scmcgenlotnum": {
                this.getLotCode(model);
                this.saveLotMainFileInfo(itemKey, model);
                break;
            }
        }
    }

    private void getLotCode(IDataModel model) {
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("entryfield", "afterentity");
        param.put("material", "material1");
        param.put("lotmap", "lotnumber1");
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entryEntity = model.getEntryEntity("afterentity");
        if (entryEntity == null || entryEntity.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u8f6c\u6362\u540e\u7269\u6599\u660e\u7ec6\u6570\u636e\u3002", (String)"DisassembleBillEdit_4", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        int selectIndex = (Integer)((DynamicObject)((DynamicObject)entryEntity.get(0)).getParent()).get("seq");
        boolean flag = false;
        if (dataEntity != null) {
            for (DynamicObject row : entryEntity) {
                String lotnum = row.getString("lotnumber1");
                if (!row.getBoolean("material1.enablelot") || lotnum == null || !StringUtils.isEmpty((CharSequence)lotnum.trim())) continue;
                flag = true;
                break;
            }
        }
        if (!flag) {
            return;
        }
        param.put("seq", String.valueOf(selectIndex + 1));
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"LotCodeRuleService", (String)"getLotCode", (Object[])new Object[]{dataEntity, entryEntity, param});
        String lotKey = "lotnumber1";
        StringBuilder sb = new StringBuilder();
        this.getView().getModel().beginInit();
        ArrayList<Integer> index = new ArrayList<Integer>();
        for (Map.Entry entry : map.entrySet()) {
            Integer seq = (Integer)entry.getKey();
            String msg = (String)entry.getValue();
            if (msg.startsWith("ERROR")) {
                sb.append(msg.substring("ERROR".length())).append('\n');
                continue;
            }
            this.getView().getModel().setValue(lotKey, (Object)msg, seq - 1);
            index.add(seq - 1);
        }
        this.getView().getModel().endInit();
        index.forEach(p -> this.getView().updateView(lotKey, p.intValue()));
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u6279\u53f7\u5f02\u5e38", (String)"AdjustBillEditPlugin_6", (String)"scmc-im-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Commit);
        }
    }

    private void saveLotMainFileInfo(String itemKey, IDataModel model) {
        String lotidField = "billentry.afterentity.lot1";
        String lotnumber = "lotnumber1";
        DynamicObject bill = model.getDataEntity();
        DynamicObjectCollection entryEntity = model.getEntryEntity("afterentity");
        if (entryEntity.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u8f6c\u6362\u540e\u7269\u6599\u660e\u7ec6\u6570\u636e\u3002", (String)"DisassembleBillEdit_4", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        LotMainFileHelper.handleLotMainFileNumber((IFormView)this.getView(), (DynamicObject)bill, (DynamicObjectCollection)entryEntity, (String)itemKey, (String)lotidField, (String)lotnumber);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.setKeeperEnable(i);
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        if (entryCurrentRowIndex != -1) {
            this.subBillEntryUI(entryCurrentRowIndex);
        }
    }

    @Override
    protected void initNewBeforeEntry(int rowIndex) {
        super.initNewBeforeEntry(rowIndex);
        if (rowIndex != 0) {
            this.copyFirstEntry(rowIndex);
        } else {
            this.setKeeperDefaltValue(rowIndex);
        }
        this.setKeeperEnable(rowIndex);
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse", rowIndex);
        boolean isopenlocation = warehouse == null ? false : warehouse.getBoolean("isopenlocation");
        this.getView().setEnable(Boolean.valueOf(isopenlocation), rowIndex, new String[]{"location"});
    }

    private void copyFirstEntry(int rowIndex) {
        IDataModel model = this.getModel();
        for (String field : beforeFields) {
            this.setValue(field, model.getValue(field, 0), rowIndex, false);
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        String name;
        super.afterAddRow(e);
        switch (name = e.getEntryProp().getName()) {
            case "afterentity": {
                RowDataEntity[] rows = e.getRowDataEntities();
                int i = this.getModel().getEntryCurrentRowIndex("billentry");
                for (RowDataEntity row : rows) {
                    this.addAfterRow(i, row);
                }
                break;
            }
        }
    }

    private void addAfterRow(int rowIndex, RowDataEntity row) {
        int subRow = row.getRowIndex();
        this.copyBeforeRow(rowIndex, subRow);
        this.setSubRowAfterAddRow(rowIndex, subRow);
    }

    private void setSubRowAfterAddRow(int rowIndex, int subRow) {
        this.setSubEntryByMaterial(subRow, rowIndex);
        this.setSubRowViewAfterAddRow(rowIndex, subRow);
    }

    @Override
    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            rows = new int[]{0};
        }
        for (int i : rows) {
            DynamicObjectCollection subEntrys = (DynamicObjectCollection)this.getModel().getValue("afterentity", i);
            if (subEntrys == null) continue;
            for (int n = 0; n < subEntrys.size(); ++n) {
                this.setSubRowAfterAddRow(i, n);
            }
        }
    }

    private void setSubRowViewAfterAddRow(int rowIndex, int subRow) {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        Object bizTypeId = bizType == null ? null : bizType.getPkValue();
        List fieldArray = AdjustBizTypeHelper.getNeedLockFields((Object)bizTypeId);
        String[] fields = fieldArray.toArray(new String[0]);
        this.addSubKey(fields);
        this.lockEntryFields(subRow, fields);
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse1", subRow, rowIndex);
        if (warehouse == null) {
            return;
        }
        boolean isopenlocation = warehouse.getBoolean("isopenlocation");
        if (isopenlocation) {
            this.getView().setEnable(Boolean.TRUE, subRow, new String[]{"location1"});
        } else {
            this.getView().setEnable(Boolean.FALSE, subRow, new String[]{"location1"});
        }
    }

    private void setSubRowViewByEntryClick(int rowIndex, int subRowIndex) {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        Object bizTypeId = bizType == null ? null : bizType.getPkValue();
        List fieldArray = AdjustBizTypeHelper.getNeedLockFields((Object)bizTypeId);
        String[] fields = fieldArray.toArray(new String[0]);
        this.addSubKey(fields);
        this.lockEntryFields(subRowIndex, fields);
        DynamicObject material = (DynamicObject)this.getModel().getValue("material1", subRowIndex);
        if (material != null) {
            DynamicObject masterMaterial = material.getDynamicObject("masterid");
            this.setSubEntryByMaterial(material, masterMaterial, subRowIndex);
        }
    }

    private void addSubKey(String[] lockFields) {
        for (int i = 0; i < lockFields.length; ++i) {
            lockFields[i] = lockFields[i] + subSuffix;
        }
    }

    private void lockEntryFields(int row, String[] lockFields) {
        if (lockFields.length > 0) {
            this.getView().setEnable(Boolean.FALSE, row, lockFields);
        }
    }

    private void copyBeforeRow(int resRow, int disRow) {
        Object bizTypeId;
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        Object object = bizTypeId = bizType == null ? null : bizType.getPkValue();
        if (!AdjustBillConst.BIZTYPE_MATERIALADJUST.equals(bizTypeId)) {
            // empty if block
        }
        List needCopyFields = AdjustBizTypeHelper.getNeedCopyFields((Object)bizTypeId);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("billentry");
        grid.selectRows(resRow);
        Map type = this.getModel().getDataEntityType().getAllEntities();
        EntityType entityType = (EntityType)type.get("billentry");
        Map map = entityType.getFields();
        String[] notCopyFields = new String[]{"id", "invaccid"};
        List<String> notCopyArrays = Arrays.asList(notCopyFields);
        for (Map.Entry field : map.entrySet()) {
            String beforeKey = (String)field.getKey();
            if (!needCopyFields.contains(beforeKey) || notCopyArrays.contains(beforeKey)) continue;
            Object beforeValue = this.getModel().getValue(beforeKey, resRow);
            this.setValue(beforeKey + subSuffix, beforeValue, disRow, false);
        }
    }

    @Override
    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int rowIndex = evt.getRow();
        if (rowIndex >= 0) {
            this.subBillEntryUI(rowIndex);
        }
    }

    private void subBillEntryUI(int row) {
        IDataModel model = this.getModel();
        model.setEntryCurrentRowIndex("billentry", row);
        SubEntryGrid subEntry = (SubEntryGrid)this.getControl("afterentity");
        if (subEntry != null) {
            int entryRowCount = this.getModel().getEntryRowCount("afterentity");
            for (int i = 0; i < entryRowCount; ++i) {
                this.setSubRowViewByEntryClick(row, i);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int row = valueSet[0].getRowIndex();
        int parentRowIndex = valueSet[0].getParentRowIndex();
        if ("material".equals(propName)) {
            this.changeMaterial(row);
        }
        super.propertyChanged(e);
        if (!this.isChanged(e)) {
            return;
        }
        switch (propName) {
            case "biztype": {
                this.changeBizType();
                break;
            }
            case "warehouse1": {
                this.changeAfterWarehouse(valueSet);
                break;
            }
        }
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        Object bizTypeId = bizType == null ? null : bizType.getPkValue();
        List<String> fields = this.getNeedSyncFields();
        if (fields.contains(propName)) {
            this.copyFieldToAfterEntry(propName, row);
            if ("ownertype".equals(propName)) {
                this.copyFieldToAfterEntry("owner", row);
            } else if ("keepertype".equals(propName)) {
                this.copyFieldToAfterEntry("keeper", row);
            } else if ("lot".equals(propName)) {
                this.copyFieldToAfterEntry("lotnumber", row);
                this.subBillEntryUI(this.getModel().getEntryCurrentRowIndex("billentry"));
            } else if ("lotnumber".equals(propName)) {
                this.copyFieldToAfterEntry("lot", row);
            } else if ("unit".equals(propName) || "qty".equals(propName) || "qtyunit2nd".equals(propName)) {
                this.dealQtyFieldToAfterEntry(propName, row);
            }
        } else if (propName.equals("qty") && AdjustBillConst.BIZTYPE_UNITADJUST.equals(bizTypeId)) {
            this.copyFieldToAfterEntry("baseqty", row);
        }
        if (("baseqty1".equals(propName) || "qty1".equals(propName) || "baseqty".equals(propName) || "qty".equals(propName)) && AdjustBillConst.BIZTYPE_UNITADJUST.equals(bizTypeId)) {
            IDataModel model = this.getModel();
            int size = this.getModel().getEntryRowCount("afterentity");
            Object newValue = model.getValue(propName, row);
            propName = propName + subSuffix;
            for (int i = 0; i < size; ++i) {
                this.calQtyByAfterBaseQty(i, model, parentRowIndex);
                this.setAfterAuxBizQtyAndUnit(model, i, parentRowIndex, propName, newValue);
                this.getView().updateView("qtyunit2nd1", i, parentRowIndex);
                this.getView().updateView("qty1", i, parentRowIndex);
            }
        }
    }

    private void changeAfterWarehouse(ChangeData[] valueSet) {
        for (int i = 0; i < valueSet.length; ++i) {
            Object oldValue;
            Object newValue = valueSet[i].getNewValue();
            if (newValue == (oldValue = valueSet[i].getOldValue())) continue;
            int rowindex = valueSet[i].getRowIndex();
            this.getModel().setValue("location1", null, rowindex);
            this.setAfterLocationEnable(rowindex, (DynamicObject)newValue);
        }
    }

    private void setAfterLocationEnable(int rowIndex, DynamicObject warehouse) {
        if (warehouse != null) {
            boolean isOpenLocation = warehouse.getBoolean("isopenlocation");
            if (isOpenLocation) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"location1"});
            } else {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"location1"});
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"location1"});
        }
    }

    private void dealQtyFieldToAfterEntry(String propName, int row) {
        IDataModel model = this.getModel();
        Object newValue = model.getValue(propName, row);
        propName = propName + subSuffix;
        DynamicObjectCollection afterEntry = (DynamicObjectCollection)model.getValue("afterentity", row);
        if (afterEntry == null || afterEntry.size() == 0) {
            return;
        }
        int size = afterEntry.size();
        int nowRow = this.getModel().getEntryCurrentRowIndex("billentry");
        for (int i = 0; i < size; ++i) {
            this.setAfterBizQtyAndUnit(model, i, row, propName, newValue);
            this.setAfterAuxBizQtyAndUnit(model, i, row, propName, newValue);
            if (nowRow != row) continue;
            BillViewHelper.updateViewRow((IFormView)this.getView(), (int)i, (int)nowRow, (String)"afterentity");
        }
    }

    private void changeMaterial(int row) {
        this.getModel().setEntryCurrentRowIndex("billentry", row);
        this.getModel().deleteEntryData("afterentity");
    }

    @Override
    protected void changeQty1OrUnit1(String propName, Object newValue, int rowIndex, int parentRowIndex) {
        Object bizTypeId;
        IDataModel bill = this.getModel();
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        Object object = bizTypeId = bizType == null ? null : bizType.getPkValue();
        if ("unit1".equals(propName) && AdjustBillConst.BIZTYPE_UNITADJUST.equals(bizTypeId)) {
            this.calQtyByAfterBaseQty(rowIndex, bill, parentRowIndex);
        } else {
            super.changeQty1OrUnit1(propName, newValue, rowIndex, parentRowIndex);
        }
    }

    private void calQtyByAfterBaseQty(int rowIndex, IDataModel bill, int row) {
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit1", rowIndex, row);
        DynamicObject unit = (DynamicObject)bill.getValue("unit1", rowIndex, row);
        DynamicObject materialInv = (DynamicObject)bill.getValue("material1", rowIndex, row);
        DynamicObject material = MaterialHelper.getMaterialByMatBiz((DynamicObject)materialInv);
        BigDecimal baseQty = (BigDecimal)bill.getValue("baseqty1", rowIndex, row);
        BigDecimal unitRate = null;
        if (material != null && baseUnit != null && unit != null) {
            unitRate = this.getUnitRateConv((Long)material.getPkValue(), (Long)unit.getPkValue(), (Long)baseUnit.getPkValue());
        }
        BigDecimal qty = null;
        if (unitRate != null && baseQty != null && baseQty.compareTo(BigDecimal.ZERO) != 0 && unitRate.compareTo(BigDecimal.ZERO) != 0) {
            qty = baseQty.divide(unitRate, unit.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)unit.getInt("precisionaccount")));
        }
        bill.beginInit();
        bill.setValue("qty1", qty, rowIndex, row);
        bill.endInit();
    }

    private List<String> getNeedSyncFields() {
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        Object bizTypeId = bizType == null ? null : bizType.getPkValue();
        List fieldArray = AdjustBizTypeHelper.getNeedSyncFields((Object)bizTypeId);
        return fieldArray;
    }

    private void copyFieldToAfterEntry(String propName, int row) {
        IDataModel model = this.getModel();
        model.beginInit();
        DynamicObject rowDys = model.getEntryRowEntity("billentry", row);
        DynamicObjectCollection entries = rowDys.getDynamicObjectCollection("afterentity");
        String subkey = propName + "1";
        HashSet<String> updateViewKeyes = new HashSet<String>();
        updateViewKeyes.add(subkey);
        if ("project".equals(propName)) {
            updateViewKeyes.add("projectname1");
        }
        DynamicObject material = rowDys.getDynamicObject("material");
        boolean isOnShelf = false;
        Date produceDate = null;
        Date expireDate = null;
        if (material != null) {
            boolean bl = isOnShelf = material.getBoolean("enableshelflifemgr") && "producedate".equals(propName) || "expirydate".equals(propName);
            if (isOnShelf) {
                produceDate = rowDys.getDate("producedate");
                expireDate = rowDys.getDate("expirydate");
                updateViewKeyes.add("producedate1");
                updateViewKeyes.add("expirydate1");
            }
        }
        Object value = rowDys.get(propName);
        for (int i = 0; i < entries.size(); ++i) {
            if ("warehouse".equals(propName) || "location".equals(propName)) {
                if (((DynamicObject)entries.get(i)).get("warehouse1") != null) continue;
                ((DynamicObject)entries.get(i)).set(subkey, value);
                this.setAfterLocationEnable(i, (DynamicObject)value);
                continue;
            }
            if (isOnShelf) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                entry.set("producedate1", (Object)produceDate);
                entry.set("expirydate1", (Object)expireDate);
                continue;
            }
            ((DynamicObject)entries.get(i)).set(subkey, value);
        }
        model.endInit();
        DynamicObjectCollection subEntrys = (DynamicObjectCollection)model.getValue("afterentity", row);
        int entryRowCount = subEntrys.size();
        for (int i = 0; i < entryRowCount; ++i) {
            for (String updateViewKey : updateViewKeyes) {
                this.getView().updateView(updateViewKey, i, row);
            }
        }
    }

    private void changeBizType() {
        this.getModel().deleteEntryData("billentry");
        this.getModel().createNewEntryRow("billentry");
    }

    private void setKeeperDefaltValue(int row) {
        IDataModel model = this.getModel();
        String type = (String)model.getValue("keepertype", row);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        switch (type) {
            case "bos_org": {
                DynamicObject org = (DynamicObject)model.getValue("org");
                this.setValue("keeper", org == null ? org : org.getPkValue(), row, false);
                break;
            }
            case "bd_customer": {
                break;
            }
            case "bd_supplier": {
                break;
            }
        }
    }

    private void setKeeperEnable(int row) {
        IDataModel model = this.getModel();
        String type = (String)model.getValue("keepertype", row);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        switch (type) {
            case "bos_org": {
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"keeper"});
                break;
            }
            case "bd_customer": {
                this.getView().setEnable(Boolean.TRUE, row, new String[]{"keeper"});
                break;
            }
            case "bd_supplier": {
                this.getView().setEnable(Boolean.TRUE, row, new String[]{"keeper"});
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        IDataModel bill = this.getModel();
        switch (fieldKey) {
            case "material": 
            case "material1": {
                this.beforeMaterialSelect(e);
                break;
            }
        }
    }

    private void beforeMaterialSelect(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject biztype = model.getDataEntity().getDynamicObject("biztype");
        if (biztype == null) {
            return;
        }
        Object bizType = biztype.getPkValue();
        if (AdjustBillConst.BIZTYPE_SNADJUST.equals(bizType)) {
            showParameter.getListFilterParameter().setFilter(new QFilter("enableserial", "=", (Object)Boolean.TRUE));
        }
        if (AdjustBillConst.BIZTYPE_LOTADJUST.equals(bizType)) {
            showParameter.getListFilterParameter().setFilter(new QFilter("enablelot", "=", (Object)Boolean.TRUE));
        }
    }

    public ArrayList<Object> getOwnerList() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ArrayList<Object> array = new ArrayList<Object>();
        if (org != null) {
            Long orgId = (Long)org.getPkValue();
            ArrayList ownerArray = OwnerHelper.getOwners((Long)orgId);
            array.addAll(ownerArray);
            Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            Object settleOrgId = null;
            if (companyByOrg != null) {
                settleOrgId = companyByOrg.get("id");
                array.add(settleOrgId);
            }
        }
        return array;
    }
}

